/*
 * Copyright (c) 2019 Linaro Ltd.
 * Copyright (c) 2019 Centaur Analytics, Inc
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_DRIVERS_PINMUX_STM32_PINMUX_STM32L1X_H_
#define ZEPHYR_DRIVERS_PINMUX_STM32_PINMUX_STM32L1X_H_

/**
 * @file Header for STM32L1X pin multiplexing helper
 */

/* Port A */
#define STM32L1X_PINMUX_FUNC_PA0_PWM2_CH1   \
	(STM32_PINMUX_ALT_FUNC_1 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PA0_USART2_CTS   \
	(STM32_PINMUX_ALT_FUNC_7 | STM32_PUSHPULL_PULLUP)
#define STM32L1X_PINMUX_FUNC_PA1_PWM2_CH2   \
	(STM32_PINMUX_ALT_FUNC_1 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PA1_USART2_RTS  \
	(STM32_PINMUX_ALT_FUNC_7 | STM32_PUPDR_NO_PULL)
#define STM32L1X_PINMUX_FUNC_PA2_PWM2_CH3   \
	(STM32_PINMUX_ALT_FUNC_1 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PA2_USART2_TX  \
	(STM32_PINMUX_ALT_FUNC_7 | STM32_PUSHPULL_PULLUP)
#define STM32L1X_PINMUX_FUNC_PA3_PWM2_CH4   \
	(STM32_PINMUX_ALT_FUNC_1 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PA3_USART2_RX  \
	(STM32_PINMUX_ALT_FUNC_7 | STM32_PUPDR_NO_PULL)
#define STM32L1X_PINMUX_FUNC_PA4_SPI1_NSS   \
	(STM32_PINMUX_ALT_FUNC_5 | STM32_PUSHPULL_PULLUP)
#define STM32L1X_PINMUX_FUNC_PA5_SPI1_SCK   \
	(STM32_PINMUX_ALT_FUNC_5 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PA6_SPI1_MISO  \
	(STM32_PINMUX_ALT_FUNC_5 | STM32_PUPDR_PULL_DOWN)
#define STM32L1X_PINMUX_FUNC_PA7_SPI1_MOSI  \
	(STM32_PINMUX_ALT_FUNC_5 | STM32_PUPDR_PULL_DOWN)
#define STM32L1X_PINMUX_FUNC_PA9_USART1_TX  \
	(STM32_PINMUX_ALT_FUNC_7 | STM32_PUSHPULL_PULLUP)
#define STM32L1X_PINMUX_FUNC_PA10_USART1_RX \
	(STM32_PINMUX_ALT_FUNC_7 | STM32_PUPDR_NO_PULL)
#define STM32L1X_PINMUX_FUNC_PA11_USART1_CTS \
	(STM32_PINMUX_ALT_FUNC_7 | STM32_PUPDR_NO_PULL)
#define STM32L1X_PINMUX_FUNC_PA12_USART1_RTS \
	(STM32_PINMUX_ALT_FUNC_7 | STM32_PUPDR_NO_PULL)
#define STM32L1X_PINMUX_FUNC_PA15_PWM2_CH1  \
	(STM32_PINMUX_ALT_FUNC_1 | STM32_PUSHPULL_NOPULL)

/* Port B */
#define STM32L1X_PINMUX_FUNC_PB0_PWM3_CH3   \
	(STM32_PINMUX_ALT_FUNC_2 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PB1_PWM3_CH4   \
	(STM32_PINMUX_ALT_FUNC_2 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PB3_PWM2_CH2   \
	(STM32_PINMUX_ALT_FUNC_1 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PB3_SPI1_SCK   \
	(STM32_PINMUX_ALT_FUNC_5 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PB4_PWM3_CH1   \
	(STM32_PINMUX_ALT_FUNC_2 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PB4_SPI1_MISO  \
	(STM32_PINMUX_ALT_FUNC_5 | STM32_PUPDR_PULL_DOWN)
#define STM32L1X_PINMUX_FUNC_PB5_PWM3_CH2   \
	(STM32_PINMUX_ALT_FUNC_2 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PB5_SPI1_MOSI  \
	(STM32_PINMUX_ALT_FUNC_5 | STM32_PUPDR_PULL_DOWN)
#define STM32L1X_PINMUX_FUNC_PB6_PWM4_CH1   \
	(STM32_PINMUX_ALT_FUNC_2 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PB6_I2C1_SCL   \
	(STM32_PINMUX_ALT_FUNC_4 | STM32_OPENDRAIN_PULLUP)
#define STM32L1X_PINMUX_FUNC_PB7_PWM4_CH2   \
	(STM32_PINMUX_ALT_FUNC_2 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PB7_I2C1_SDA   \
	(STM32_PINMUX_ALT_FUNC_4 | STM32_OPENDRAIN_PULLUP)
#define STM32L1X_PINMUX_FUNC_PB7_USART1_RX  \
	(STM32_PINMUX_ALT_FUNC_7 | STM32_PUPDR_NO_PULL)
#define STM32L1X_PINMUX_FUNC_PB8_PWM4_CH3   \
	(STM32_PINMUX_ALT_FUNC_2 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PB8_I2C1_SCL   \
	(STM32_PINMUX_ALT_FUNC_4 | STM32_OPENDRAIN_PULLUP)
#define STM32L1X_PINMUX_FUNC_PB9_PWM4_CH4   \
	(STM32_PINMUX_ALT_FUNC_2 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PB9_I2C1_SDA   \
	(STM32_PINMUX_ALT_FUNC_4 | STM32_OPENDRAIN_PULLUP)
#define STM32L1X_PINMUX_FUNC_PB10_PWM2_CH3   \
	(STM32_PINMUX_ALT_FUNC_1 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PB10_I2C2_SCL  \
	(STM32_PINMUX_ALT_FUNC_4 | STM32_OPENDRAIN_PULLUP)
#define STM32L1X_PINMUX_FUNC_PB10_USART3_TX \
	(STM32_PINMUX_ALT_FUNC_7 | STM32_PUSHPULL_PULLUP)
#define STM32L1X_PINMUX_FUNC_PB11_PWM2_CH4   \
	(STM32_PINMUX_ALT_FUNC_1 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PB11_I2C2_SDA  \
	(STM32_PINMUX_ALT_FUNC_4 | STM32_OPENDRAIN_PULLUP)
#define STM32L1X_PINMUX_FUNC_PB11_USART3_RX \
	(STM32_PINMUX_ALT_FUNC_7 | STM32_PUPDR_NO_PULL)
#define STM32L1X_PINMUX_FUNC_PB12_PWM10_CH1   \
	(STM32_PINMUX_ALT_FUNC_3 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PB12_SPI2_NSS   \
	(STM32_PINMUX_ALT_FUNC_5 | STM32_PUSHPULL_PULLUP)
#define STM32L1X_PINMUX_FUNC_PB13_PWM9_CH1  \
	(STM32_PINMUX_ALT_FUNC_3 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PB13_SPI2_SCK   \
	(STM32_PINMUX_ALT_FUNC_5 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PB14_PWM9_CH2  \
	(STM32_PINMUX_ALT_FUNC_3 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PB14_SPI2_MISO  \
	(STM32_PINMUX_ALT_FUNC_5 | STM32_PUPDR_PULL_DOWN)
#define STM32L1X_PINMUX_FUNC_PB15_PWM11_CH1  \
	(STM32_PINMUX_ALT_FUNC_3 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PB15_SPI2_MOSI  \
	(STM32_PINMUX_ALT_FUNC_5 | STM32_PUPDR_PULL_DOWN)

/* Port C */
#define STM32L1X_PINMUX_FUNC_PC6_PWM3_CH1  \
	(STM32_PINMUX_ALT_FUNC_2 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PC7_PWM3_CH2  \
	(STM32_PINMUX_ALT_FUNC_2 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PC8_PWM3_CH3  \
	(STM32_PINMUX_ALT_FUNC_2 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PC9_PWM3_CH4  \
	(STM32_PINMUX_ALT_FUNC_2 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PC10_USART3_TX \
	(STM32_PINMUX_ALT_FUNC_7 | STM32_PUSHPULL_PULLUP)
#define STM32L1X_PINMUX_FUNC_PC11_USART3_RX \
	(STM32_PINMUX_ALT_FUNC_7 | STM32_PUPDR_NO_PULL)

/* Port D */
#define STM32L1X_PINMUX_FUNC_PD5_USART2_TX  \
	(STM32_PINMUX_ALT_FUNC_7 | STM32_PUSHPULL_PULLUP)
#define STM32L1X_PINMUX_FUNC_PD6_USART2_RX  \
	(STM32_PINMUX_ALT_FUNC_7 | STM32_PUPDR_NO_PULL)
#define STM32L1X_PINMUX_FUNC_PD8_USART3_TX  \
	(STM32_PINMUX_ALT_FUNC_7 | STM32_PUSHPULL_PULLUP)
#define STM32L1X_PINMUX_FUNC_PD9_USART3_RX  \
	(STM32_PINMUX_ALT_FUNC_7 | STM32_PUPDR_NO_PULL)
#define STM32L1X_PINMUX_FUNC_PD12_PWM4_CH1  \
	(STM32_PINMUX_ALT_FUNC_2 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PD13_PWM4_CH2  \
	(STM32_PINMUX_ALT_FUNC_2 | STM32_PUSHPULL_NOPULL)

/* Port E */
#define STM32L1X_PINMUX_FUNC_PE0_PWM10_CH1   \
	(STM32_PINMUX_ALT_FUNC_3 | STM32_PUSHPULL_NOPULL)
#define STM32L1X_PINMUX_FUNC_PE1_PWM11_CH1   \
	(STM32_PINMUX_ALT_FUNC_3 | STM32_PUSHPULL_NOPULL)

#endif /* ZEPHYR_DRIVERS_PINMUX_STM32_PINMUX_STM32L1X_H_ */
