/*
 * Copyright (c) 2019, Ambiq Micro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from this
 * software without specific prior written permission.
 *
 * Third party software included in this distribution is subject to the
 * additional license terms as defined in the /docs/licenses directory.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @file     apollo3c.h
 * @brief    CMSIS HeaderFile
 * @version  1.0
 * @date     20. May 2019
 * @note     Generated by SVDConv V3.3.18 on Monday, 20.05.2019 15:44:40
 *           from File './apollo3c.svd',
 *           last modified on Monday, 20.05.2019 20:44:40
 */



/** @addtogroup Ambiq Micro
  * @{
  */


/** @addtogroup apollo3c
  * @{
  */


#ifndef APOLLO3C_H
#define APOLLO3C_H

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup Configuration_of_CMSIS
  * @{
  */



/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum {
/* =======================================  ARM Cortex-M4 Specific Interrupt Numbers  ======================================== */
  Reset_IRQn                = -15,              /*!< -15  Reset Vector, invoked on Power up and warm reset                     */
  NonMaskableInt_IRQn       = -14,              /*!< -14  Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn            = -13,              /*!< -13  Hard Fault, all classes of Fault                                     */
  MemoryManagement_IRQn     = -12,              /*!< -12  Memory Management, MPU mismatch, including Access Violation
                                                     and No Match                                                              */
  BusFault_IRQn             = -11,              /*!< -11  Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                                     related Fault                                                             */
  UsageFault_IRQn           = -10,              /*!< -10  Usage Fault, i.e. Undef Instruction, Illegal State Transition        */
  SVCall_IRQn               =  -5,              /*!< -5 System Service Call via SVC instruction                                */
  DebugMonitor_IRQn         =  -4,              /*!< -4 Debug Monitor                                                          */
  PendSV_IRQn               =  -2,              /*!< -2 Pendable request for system service                                    */
  SysTick_IRQn              =  -1,              /*!< -1 System Tick Timer                                                      */
/* ==========================================  apollo3c Specific Interrupt Numbers  ========================================== */
  BROWNOUT_IRQn             =   0,              /*!< 0  BROWNOUT                                                               */
  WDT_IRQn                  =   1,              /*!< 1  WDT                                                                    */
  RTC_IRQn                  =   2,              /*!< 2  RTC                                                                    */
  VCOMP_IRQn                =   3,              /*!< 3  VCOMP                                                                  */
  IOSLAVE_IRQn              =   4,              /*!< 4  IOSLAVE                                                                */
  IOSLAVEACC_IRQn           =   5,              /*!< 5  IOSLAVEACC                                                             */
  IOMSTR0_IRQn              =   6,              /*!< 6  IOMSTR0                                                                */
  IOMSTR1_IRQn              =   7,              /*!< 7  IOMSTR1                                                                */
  IOMSTR2_IRQn              =   8,              /*!< 8  IOMSTR2                                                                */
  IOMSTR3_IRQn              =   9,              /*!< 9  IOMSTR3                                                                */
  IOMSTR4_IRQn              =  10,              /*!< 10 IOMSTR4                                                                */
  IOMSTR5_IRQn              =  11,              /*!< 11 IOMSTR5                                                                */
  BLE_IRQn                  =  12,              /*!< 12 BLE                                                                    */
  GPIO_IRQn                 =  13,              /*!< 13 GPIO                                                                   */
  CTIMER_IRQn               =  14,              /*!< 14 CTIMER                                                                 */
  UART0_IRQn                =  15,              /*!< 15 UART0                                                                  */
  UART1_IRQn                =  16,              /*!< 16 UART1                                                                  */
  SCARD_IRQn                =  17,              /*!< 17 SCARD                                                                  */
  ADC_IRQn                  =  18,              /*!< 18 ADC                                                                    */
  PDM_IRQn                  =  19,              /*!< 19 PDM                                                                    */
  MSPI0_IRQn                =  20,              /*!< 20 MSPI0                                                                  */
  STIMER_IRQn               =  22,              /*!< 22 STIMER                                                                 */
  STIMER_CMPR0_IRQn         =  23,              /*!< 23 STIMER_CMPR0                                                           */
  STIMER_CMPR1_IRQn         =  24,              /*!< 24 STIMER_CMPR1                                                           */
  STIMER_CMPR2_IRQn         =  25,              /*!< 25 STIMER_CMPR2                                                           */
  STIMER_CMPR3_IRQn         =  26,              /*!< 26 STIMER_CMPR3                                                           */
  STIMER_CMPR4_IRQn         =  27,              /*!< 27 STIMER_CMPR4                                                           */
  STIMER_CMPR5_IRQn         =  28,              /*!< 28 STIMER_CMPR5                                                           */
  STIMER_CMPR6_IRQn         =  29,              /*!< 29 STIMER_CMPR6                                                           */
  STIMER_CMPR7_IRQn         =  30,              /*!< 30 STIMER_CMPR7                                                           */
  CLKGEN_IRQn               =  31,              /*!< 31 CLKGEN                                                                 */
  MSPI1_IRQn                =  32,              /*!< 32 MSPI1                                                                  */
  MSPI2_IRQn                =  33               /*!< 33 MSPI2                                                                  */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ===========================  Configuration of the ARM Cortex-M4 Processor and Core Peripherals  =========================== */
#define __CM4_REV                 0x0100U       /*!< CM4 Core Revision                                                         */
#define __NVIC_PRIO_BITS               3        /*!< Number of Bits used for Priority Levels                                   */
#define __Vendor_SysTickConfig         0        /*!< Set to 1 if different SysTick Config is used                              */
#define __MPU_PRESENT                  1        /*!< MPU present or not                                                        */
#define __FPU_PRESENT                  1        /*!< FPU present or not                                                        */


/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm4.h"                           /*!< ARM Cortex-M4 processor and core peripherals                              */
#include "system_apollo3c.h"                    /*!< apollo3c System                                                           */

#ifndef __IM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __IM   __I
#endif
#ifndef __OM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __OM   __O
#endif
#ifndef __IOM                                   /*!< Fallback for older CMSIS versions                                         */
  #define __IOM  __IO
#endif


/* ========================================  Start of section using anonymous unions  ======================================== */
#if defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                            ADC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Analog Digital Converter Control (ADC)
  */

typedef struct {                                /*!< (@ 0x50010000) ADC Structure                                              */

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Configuration Register                                     */

    struct {
      __IOM uint32_t ADCEN      : 1;            /*!< [0..0] This bit enables the ADC module. While the ADC is enabled,
                                                     the ADCCFG and SLOT Configuration regsiter settings must
                                                     remain stable and unchanged. All configuration register
                                                     settings, slot configuration settings and window comparison
                                                     settings should be written prior to setting the ADCEN bit
                                                     to '1'.                                                                   */
      __IM  uint32_t            : 1;
      __IOM uint32_t RPTEN      : 1;            /*!< [2..2] This bit enables Repeating Scan Mode.                              */
      __IOM uint32_t LPMODE     : 1;            /*!< [3..3] Select power mode to enter between active scans.                   */
      __IOM uint32_t CKMODE     : 1;            /*!< [4..4] Clock mode register                                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t REFSEL     : 2;            /*!< [9..8] Select the ADC reference voltage.                                  */
      __IM  uint32_t            : 2;
      __IOM uint32_t DFIFORDEN  : 1;            /*!< [12..12] Destructive FIFO Read Enable. Setting this will enable
                                                     FIFO pop upon reading the FIFOPR register.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t TRIGSEL    : 3;            /*!< [18..16] Select the ADC trigger source.                                   */
      __IOM uint32_t TRIGPOL    : 1;            /*!< [19..19] This bit selects the ADC trigger polarity for external
                                                     off chip triggers.                                                        */
      __IM  uint32_t            : 4;
      __IOM uint32_t CLKSEL     : 2;            /*!< [25..24] Select the source and frequency for the ADC clock.
                                                     All values not enumerated below are undefined.                            */
    } CFG_b;
  } ;

  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x00000004) ADC Power Status                                           */

    struct {
      __IOM uint32_t PWDSTAT    : 1;            /*!< [0..0] Indicates the power-status of the ADC.                             */
    } STAT_b;
  } ;

  union {
    __IOM uint32_t SWT;                         /*!< (@ 0x00000008) Software trigger                                           */

    struct {
      __IOM uint32_t SWT        : 8;            /*!< [7..0] Writing 0x37 to this register generates a software trigger.        */
    } SWT_b;
  } ;

  union {
    __IOM uint32_t SL0CFG;                      /*!< (@ 0x0000000C) Slot 0 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN0      : 1;            /*!< [0..0] This bit enables slot 0 for ADC conversions.                       */
      __IOM uint32_t WCEN0      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     0.                                                                        */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL0     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE0    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL0     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
    } SL0CFG_b;
  } ;

  union {
    __IOM uint32_t SL1CFG;                      /*!< (@ 0x00000010) Slot 1 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN1      : 1;            /*!< [0..0] This bit enables slot 1 for ADC conversions.                       */
      __IOM uint32_t WCEN1      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     1.                                                                        */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL1     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE1    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL1     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
    } SL1CFG_b;
  } ;

  union {
    __IOM uint32_t SL2CFG;                      /*!< (@ 0x00000014) Slot 2 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN2      : 1;            /*!< [0..0] This bit enables slot 2 for ADC conversions.                       */
      __IOM uint32_t WCEN2      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     2.                                                                        */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL2     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE2    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL2     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
    } SL2CFG_b;
  } ;

  union {
    __IOM uint32_t SL3CFG;                      /*!< (@ 0x00000018) Slot 3 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN3      : 1;            /*!< [0..0] This bit enables slot 3 for ADC conversions.                       */
      __IOM uint32_t WCEN3      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     3.                                                                        */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL3     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE3    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL3     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
    } SL3CFG_b;
  } ;

  union {
    __IOM uint32_t SL4CFG;                      /*!< (@ 0x0000001C) Slot 4 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN4      : 1;            /*!< [0..0] This bit enables slot 4 for ADC conversions.                       */
      __IOM uint32_t WCEN4      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     4.                                                                        */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL4     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE4    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL4     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
    } SL4CFG_b;
  } ;

  union {
    __IOM uint32_t SL5CFG;                      /*!< (@ 0x00000020) Slot 5 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN5      : 1;            /*!< [0..0] This bit enables slot 5 for ADC conversions.                       */
      __IOM uint32_t WCEN5      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     5.                                                                        */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL5     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE5    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL5     : 3;            /*!< [26..24] Select number of measurements to average in the accumulate
                                                     divide module for this slot.                                              */
    } SL5CFG_b;
  } ;

  union {
    __IOM uint32_t SL6CFG;                      /*!< (@ 0x00000024) Slot 6 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN6      : 1;            /*!< [0..0] This bit enables slot 6 for ADC conversions.                       */
      __IOM uint32_t WCEN6      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     6.                                                                        */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL6     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE6    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL6     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
    } SL6CFG_b;
  } ;

  union {
    __IOM uint32_t SL7CFG;                      /*!< (@ 0x00000028) Slot 7 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN7      : 1;            /*!< [0..0] This bit enables slot 7 for ADC conversions.                       */
      __IOM uint32_t WCEN7      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     7.                                                                        */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL7     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE7    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL7     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
    } SL7CFG_b;
  } ;

  union {
    __IOM uint32_t WULIM;                       /*!< (@ 0x0000002C) Window Comparator Upper Limits Register                    */

    struct {
      __IOM uint32_t ULIM       : 20;           /*!< [19..0] Sets the upper limit for the window comparator.                   */
    } WULIM_b;
  } ;

  union {
    __IOM uint32_t WLLIM;                       /*!< (@ 0x00000030) Window Comparator Lower Limits Register                    */

    struct {
      __IOM uint32_t LLIM       : 20;           /*!< [19..0] Sets the lower limit for the window comparator.                   */
    } WLLIM_b;
  } ;

  union {
    __IOM uint32_t SCWLIM;                      /*!< (@ 0x00000034) Scale Window Comparator Limits                             */

    struct {
      __IOM uint32_t SCWLIMEN   : 1;            /*!< [0..0] Scale the window limits compare values per precision
                                                     mode. When set to 0x0 (default), the values in the 20-bit
                                                     limits registers will compare directly with the FIFO values
                                                     regardless of the precision mode the slot is configured
                                                     to. When set to 0x1, the compare values will be divided
                                                     by the difference in precision bits while performing the
                                                     window limit comparisons.                                                 */
    } SCWLIM_b;
  } ;

  union {
    __IOM uint32_t FIFO;                        /*!< (@ 0x00000038) FIFO Data and Valid Count Register                         */

    struct {
      __IOM uint32_t DATA       : 20;           /*!< [19..0] Oldest data in the FIFO.                                          */
      __IOM uint32_t COUNT      : 8;            /*!< [27..20] Number of valid entries in the ADC FIFO.                         */
      __IOM uint32_t SLOTNUM    : 3;            /*!< [30..28] Slot number associated with this FIFO data.                      */
      __IOM uint32_t RSVD       : 1;            /*!< [31..31] RESERVED.                                                        */
    } FIFO_b;
  } ;

  union {
    __IOM uint32_t FIFOPR;                      /*!< (@ 0x0000003C) FIFO Data and Valid Count Register                         */

    struct {
      __IOM uint32_t DATA       : 20;           /*!< [19..0] Oldest data in the FIFO.                                          */
      __IOM uint32_t COUNT      : 8;            /*!< [27..20] Number of valid entries in the ADC FIFO.                         */
      __IOM uint32_t SLOTNUMPR  : 3;            /*!< [30..28] Slot number associated with this FIFO data.                      */
      __IOM uint32_t RSVDPR     : 1;            /*!< [31..31] RESERVED.                                                        */
    } FIFOPR_b;
  } ;
  __IM  uint32_t  RESERVED[112];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) ADC Interrupt registers: Enable                            */

    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< [0..0] ADC conversion complete interrupt.                                 */
      __IOM uint32_t SCNCMP     : 1;            /*!< [1..1] ADC scan complete interrupt.                                       */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< [2..2] FIFO 75 percent full interrupt.                                    */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< [3..3] FIFO 100 percent full interrupt.                                   */
      __IOM uint32_t WCEXC      : 1;            /*!< [4..4] Window comparator voltage excursion interrupt.                     */
      __IOM uint32_t WCINC      : 1;            /*!< [5..5] Window comparator voltage incursion interrupt.                     */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Transfer Complete                                              */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Condition                                                */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) ADC Interrupt registers: Status                            */

    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< [0..0] ADC conversion complete interrupt.                                 */
      __IOM uint32_t SCNCMP     : 1;            /*!< [1..1] ADC scan complete interrupt.                                       */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< [2..2] FIFO 75 percent full interrupt.                                    */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< [3..3] FIFO 100 percent full interrupt.                                   */
      __IOM uint32_t WCEXC      : 1;            /*!< [4..4] Window comparator voltage excursion interrupt.                     */
      __IOM uint32_t WCINC      : 1;            /*!< [5..5] Window comparator voltage incursion interrupt.                     */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Transfer Complete                                              */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Condition                                                */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) ADC Interrupt registers: Clear                             */

    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< [0..0] ADC conversion complete interrupt.                                 */
      __IOM uint32_t SCNCMP     : 1;            /*!< [1..1] ADC scan complete interrupt.                                       */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< [2..2] FIFO 75 percent full interrupt.                                    */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< [3..3] FIFO 100 percent full interrupt.                                   */
      __IOM uint32_t WCEXC      : 1;            /*!< [4..4] Window comparator voltage excursion interrupt.                     */
      __IOM uint32_t WCINC      : 1;            /*!< [5..5] Window comparator voltage incursion interrupt.                     */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Transfer Complete                                              */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Condition                                                */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) ADC Interrupt registers: Set                               */

    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< [0..0] ADC conversion complete interrupt.                                 */
      __IOM uint32_t SCNCMP     : 1;            /*!< [1..1] ADC scan complete interrupt.                                       */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< [2..2] FIFO 75 percent full interrupt.                                    */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< [3..3] FIFO 100 percent full interrupt.                                   */
      __IOM uint32_t WCEXC      : 1;            /*!< [4..4] Window comparator voltage excursion interrupt.                     */
      __IOM uint32_t WCINC      : 1;            /*!< [5..5] Window comparator voltage incursion interrupt.                     */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Transfer Complete                                              */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Condition                                                */
    } INTSET_b;
  } ;
  __IM  uint32_t  RESERVED1[12];

  union {
    __IOM uint32_t DMATRIGEN;                   /*!< (@ 0x00000240) DMA Trigger Enable Register                                */

    struct {
      __IOM uint32_t DFIFO75    : 1;            /*!< [0..0] Trigger DMA upon FIFO 75 percent Full                              */
      __IOM uint32_t DFIFOFULL  : 1;            /*!< [1..1] Trigger DMA upon FIFO 100 percent Full                             */
    } DMATRIGEN_b;
  } ;

  union {
    __IOM uint32_t DMATRIGSTAT;                 /*!< (@ 0x00000244) DMA Trigger Status Register                                */

    struct {
      __IOM uint32_t D75STAT    : 1;            /*!< [0..0] Triggered DMA from FIFO 75 percent Full                            */
      __IOM uint32_t DFULLSTAT  : 1;            /*!< [1..1] Triggered DMA from FIFO 100 percent Full                           */
    } DMATRIGSTAT_b;
  } ;
  __IM  uint32_t  RESERVED2[14];

  union {
    __IOM uint32_t DMACFG;                      /*!< (@ 0x00000280) DMA Configuration Register                                 */

    struct {
      __IOM uint32_t DMAEN      : 1;            /*!< [0..0] DMA Enable                                                         */
      __IM  uint32_t            : 1;
      __IOM uint32_t DMADIR     : 1;            /*!< [2..2] Direction                                                          */
      __IM  uint32_t            : 5;
      __IOM uint32_t DMAPRI     : 1;            /*!< [8..8] Sets the Priority of the DMA request                               */
      __IOM uint32_t DMADYNPRI  : 1;            /*!< [9..9] Enables dynamic priority based on FIFO fullness. When
                                                     FIFO is full, priority is automatically set to HIGH. Otherwise,
                                                     DMAPRI is used.                                                           */
      __IM  uint32_t            : 6;
      __IOM uint32_t DMAHONSTAT : 1;            /*!< [16..16] Halt New ADC conversions until DMA Status DMAERR and
                                                     DMACPL Cleared.                                                           */
      __IOM uint32_t DMAMSK     : 1;            /*!< [17..17] Mask the FIFOCNT and SLOTNUM when transferring FIFO
                                                     contents to memory                                                        */
      __IOM uint32_t DPWROFF    : 1;            /*!< [18..18] Power Off the ADC System upon DMACPL.                            */
    } DMACFG_b;
  } ;
  __IM  uint32_t  RESERVED3;

  union {
    __IOM uint32_t DMATOTCOUNT;                 /*!< (@ 0x00000288) DMA Total Transfer Count                                   */

    struct {
      __IM  uint32_t            : 2;
      __IOM uint32_t TOTCOUNT   : 16;           /*!< [17..2] Total Transfer Count                                              */
    } DMATOTCOUNT_b;
  } ;

  union {
    __IOM uint32_t DMATARGADDR;                 /*!< (@ 0x0000028C) DMA Target Address Register                                */

    struct {
      __IOM uint32_t LTARGADDR  : 20;           /*!< [19..0] DMA Target Address                                                */
      __IOM uint32_t UTARGADDR  : 12;           /*!< [31..20] SRAM Target                                                      */
    } DMATARGADDR_b;
  } ;

  union {
    __IOM uint32_t DMASTAT;                     /*!< (@ 0x00000290) DMA Status Register                                        */

    struct {
      __IOM uint32_t DMATIP     : 1;            /*!< [0..0] DMA Transfer In Progress                                           */
      __IOM uint32_t DMACPL     : 1;            /*!< [1..1] DMA Transfer Complete                                              */
      __IOM uint32_t DMAERR     : 1;            /*!< [2..2] DMA Error                                                          */
    } DMASTAT_b;
  } ;
} ADC_Type;                                     /*!< Size = 660 (0x294)                                                        */



/* =========================================================================================================================== */
/* ================                                          APBDMA                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief APB DMA Register Interfaces (APBDMA)
  */

typedef struct {                                /*!< (@ 0x40011000) APBDMA Structure                                           */

  union {
    __IOM uint32_t BBVALUE;                     /*!< (@ 0x00000000) Control Register                                           */

    struct {
      __IOM uint32_t DATAOUT    : 8;            /*!< [7..0] Data Output Values                                                 */
      __IM  uint32_t            : 8;
      __IOM uint32_t PIN        : 8;            /*!< [23..16] PIO values                                                       */
    } BBVALUE_b;
  } ;

  union {
    __IOM uint32_t BBSETCLEAR;                  /*!< (@ 0x00000004) Set/Clear Register                                         */

    struct {
      __IOM uint32_t SET        : 8;            /*!< [7..0] Write 1 to Set PIO value (set hier priority than clear
                                                     if both bit set)                                                          */
      __IM  uint32_t            : 8;
      __IOM uint32_t CLEAR      : 8;            /*!< [23..16] Write 1 to Clear PIO value                                       */
    } BBSETCLEAR_b;
  } ;

  union {
    __IOM uint32_t BBINPUT;                     /*!< (@ 0x00000008) PIO Input Values                                           */

    struct {
      __IOM uint32_t DATAIN     : 8;            /*!< [7..0] PIO values                                                         */
    } BBINPUT_b;
  } ;
  __IM  uint32_t  RESERVED[5];

  union {
    __IOM uint32_t DEBUGDATA;                   /*!< (@ 0x00000020) PIO Input Values                                           */

    struct {
      __IOM uint32_t DEBUGDATA  : 32;           /*!< [31..0] Debug Data                                                        */
    } DEBUGDATA_b;
  } ;
  __IM  uint32_t  RESERVED1[7];

  union {
    __IOM uint32_t DEBUG;                       /*!< (@ 0x00000040) PIO Input Values                                           */

    struct {
      __IOM uint32_t DEBUGEN    : 4;            /*!< [3..0] Debug Enable                                                       */
    } DEBUG_b;
  } ;
} APBDMA_Type;                                  /*!< Size = 68 (0x44)                                                          */



/* =========================================================================================================================== */
/* ================                                           BLEIF                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief BLE Interface (BLEIF)
  */

typedef struct {                                /*!< (@ 0x5000C000) BLEIF Structure                                            */

  union {
    __IOM uint32_t FIFO;                        /*!< (@ 0x00000000) FIFO Access Port                                           */

    struct {
      __IOM uint32_t FIFO       : 32;           /*!< [31..0] FIFO direct access. Only locations 0 - 3F will return
                                                     valid information.                                                        */
    } FIFO_b;
  } ;
  __IM  uint32_t  RESERVED[63];

  union {
    __IOM uint32_t FIFOPTR;                     /*!< (@ 0x00000100) FIFO size and remaining slots open values                  */

    struct {
      __IOM uint32_t FIFO0SIZ   : 8;            /*!< [7..0] The number of valid data bytes currently in the FIFO
                                                     0 (written by MCU, read by interface)                                     */
      __IOM uint32_t FIFO0REM   : 8;            /*!< [15..8] The number of remaining data bytes slots currently in
                                                     FIFO 0 (written by MCU, read by interface)                                */
      __IOM uint32_t FIFO1SIZ   : 8;            /*!< [23..16] The number of valid data bytes currently in FIFO 1
                                                     (written by interface, read by MCU)                                       */
      __IOM uint32_t FIFO1REM   : 8;            /*!< [31..24] The number of remaining data bytes slots currently
                                                     in FIFO 1 (written by interface, read by MCU)                             */
    } FIFOPTR_b;
  } ;

  union {
    __IOM uint32_t FIFOTHR;                     /*!< (@ 0x00000104) FIFO Threshold Configuration                               */

    struct {
      __IOM uint32_t FIFORTHR   : 6;            /*!< [5..0] FIFO read threshold in bytes. A value of 0 will disable
                                                     the read FIFO level from activating the threshold interrupt.
                                                     If this field is non-zero, it will trigger a threshold
                                                     interrupt when the read fifo contains FIFORTHR valid bytes
                                                     of data, as indicated by the FIFO1SIZ field. This is intended
                                                     to signal when a data transfer of FIFORTHR bytes can be
                                                     done from the IOM module to the host via the read fifo
                                                     to support large IOM read operations.                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t FIFOWTHR   : 6;            /*!< [13..8] FIFO write threshold in bytes. A value of 0 will disable
                                                     the write FIFO level from activating the threshold interrupt.
                                                     If this field is non-zero, it will trigger a threshold
                                                     interrupt when the write fifo contains FIFOWTHR free bytes,
                                                     as indicated by the FIFO0REM field. This is intended to
                                                     signal when a transfer of FIFOWTHR bytes can be done from
                                                     the host to the IOM write fifo to support large IOM write
                                                     operations.                                                               */
    } FIFOTHR_b;
  } ;

  union {
    __IOM uint32_t FIFOPOP;                     /*!< (@ 0x00000108) FIFO POP register                                          */

    struct {
      __IOM uint32_t FIFODOUT   : 32;           /*!< [31..0] This register will return the read data indicated by
                                                     the current read pointer on reads. If the POPWR control
                                                     bit in the FIFOCTRL register is reset (0), the fifo read
                                                     pointer will be advanced by one word as a result of the
                                                     read.If the POPWR bit is set (1), the fifo read pointer
                                                     will only be advanced after a write operation to this register.
                                                     The write data is ignored for this register.If less than
                                                     a even word multiple is available, and the command is completed,
                                                     the module will return the word containing                                */
    } FIFOPOP_b;
  } ;

  union {
    __IOM uint32_t FIFOPUSH;                    /*!< (@ 0x0000010C) FIFO PUSH register                                         */

    struct {
      __IOM uint32_t FIFODIN    : 32;           /*!< [31..0] This register is used to write the FIFORAM in FIFO mode
                                                     and will cause a push event to occur to the next open slot
                                                     within the FIFORAM. Writing to this register will cause
                                                     the write point to increment by 1 word(4 bytes).                          */
    } FIFOPUSH_b;
  } ;

  union {
    __IOM uint32_t FIFOCTRL;                    /*!< (@ 0x00000110) FIFO Control Register                                      */

    struct {
      __IOM uint32_t POPWR      : 1;            /*!< [0..0] Selects the mode in which 'pop' events are done for the
                                                     fifo read operations. A value of '1' will prevent a pop
                                                     event on a read operation, and will require a write to
                                                     the FIFOPOP register to create a pop event.A value of '0'
                                                     in this register will allow a pop event to occur on the
                                                     read of the FIFOPOP register, and may cause inadvertant
                                                     fifo pops when used in a debugging mode.                                  */
      __IOM uint32_t FIFORSTN   : 1;            /*!< [1..1] Active low manual reset of the fifo. Write to 0 to reset
                                                     fifo, and then write to 1 to remove the reset.                            */
    } FIFOCTRL_b;
  } ;

  union {
    __IOM uint32_t FIFOLOC;                     /*!< (@ 0x00000114) FIFO Pointers                                              */

    struct {
      __IOM uint32_t FIFOWPTR   : 4;            /*!< [3..0] Current FIFO write pointer. Value is the index into the
                                                     outgoing FIFO (FIFO0), which is used during write operations
                                                     to external devices.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t FIFORPTR   : 4;            /*!< [11..8] Current FIFO read pointer. Used to index into the incoming
                                                     FIFO (FIFO1), which is used to store read data returned
                                                     from external devices during a read operation.                            */
    } FIFOLOC_b;
  } ;
  __IM  uint32_t  RESERVED1[58];

  union {
    __IOM uint32_t CLKCFG;                      /*!< (@ 0x00000200) I/O Clock Configuration                                    */

    struct {
      __IOM uint32_t IOCLKEN    : 1;            /*!< [0..0] Enable for the interface clock. Must be enabled prior
                                                     to executing any IO operations.                                           */
      __IM  uint32_t            : 7;
      __IOM uint32_t FSEL       : 3;            /*!< [10..8] Select the input clock frequency.                                 */
      __IOM uint32_t CLK32KEN   : 1;            /*!< [11..11] Enable for the 32Khz clock to the BLE module                     */
      __IOM uint32_t DIV3       : 1;            /*!< [12..12] Enable of the divide by 3 of the source IOCLK.                   */
    } CLKCFG_b;
  } ;
  __IM  uint32_t  RESERVED2[2];

  union {
    __IOM uint32_t CMD;                         /*!< (@ 0x0000020C) Command and offset Register                                */

    struct {
      __IOM uint32_t CMD        : 5;            /*!< [4..0] Command for submodule.                                             */
      __IOM uint32_t OFFSETCNT  : 2;            /*!< [6..5] Number of offset bytes to use for the command - 0, 1,
                                                     2, 3 are valid selections. The second (byte 1) and third
                                                     byte (byte 2) are read from the OFFSETHI register, and
                                                     the low order byte is pulled from this register in the
                                                     OFFSETLO field.Offset bytes are transmitted highest byte
                                                     first. EG if offsetcnt == 3, OFFSETHI[15:8] will be transmitted
                                                     first, then OFFSETHI[7:0] then OFFSETLO.If offsetcnt ==
                                                     2, OFFSETHI[7:0] will be transmitted, then OFFSETLO.If
                                                     offsetcnt == 1, only OFFSETLO will be transmitted.                        */
      __IOM uint32_t CONT       : 1;            /*!< [7..7] Contine to hold the bus after the current transaction
                                                     if set to a 1 with a new command issued.                                  */
      __IOM uint32_t TSIZE      : 12;           /*!< [19..8] Defines the transaction size in bytes. The offset transfer
                                                     is not included in this size.                                             */
      __IOM uint32_t CMDSEL     : 2;            /*!< [21..20] Command Specific selection information                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t OFFSETLO   : 8;            /*!< [31..24] This register holds the low order byte of offset to
                                                     be used in the transaction. The number of offset bytes
                                                     to use is set with bits 1:0 of the command. Offset bytes
                                                     are transferred starting from the highest byte first.                     */
    } CMD_b;
  } ;

  union {
    __IOM uint32_t CMDRPT;                      /*!< (@ 0x00000210) Command Repeat Register                                    */

    struct {
      __IOM uint32_t CMDRPT     : 5;            /*!< [4..0] Count of number of times to repeat the next command.               */
    } CMDRPT_b;
  } ;

  union {
    __IOM uint32_t OFFSETHI;                    /*!< (@ 0x00000214) High order offset bytes                                    */

    struct {
      __IOM uint32_t OFFSETHI   : 16;           /*!< [15..0] Holds the high order bytes of the 2 or 3 byte offset
                                                     phase of a transaction.                                                   */
    } OFFSETHI_b;
  } ;

  union {
    __IOM uint32_t CMDSTAT;                     /*!< (@ 0x00000218) Command status                                             */

    struct {
      __IOM uint32_t CCMD       : 5;            /*!< [4..0] current command that is being executed                             */
      __IOM uint32_t CMDSTAT    : 3;            /*!< [7..5] The current status of the command execution.                       */
      __IOM uint32_t CTSIZE     : 12;           /*!< [19..8] The current number of bytes still to be transferred
                                                     with this command. This field will count down to zero.                    */
    } CMDSTAT_b;
  } ;
  __IM  uint32_t  RESERVED3;

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000220) IO Master Interrupts: Enable                               */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Command Complete interrupt. Asserted when the current
                                                     operation has completed. For repeated commands, this will
                                                     only be asserted when the final repeated command is completed.            */
      __IOM uint32_t THR        : 1;            /*!< [1..1] FIFO Threshold interrupt. For write operations, asserted
                                                     when the number of free bytes in the write FIFO equals
                                                     or exceeds the WTHR field.For read operations, asserted
                                                     when the number of valid bytes in the read FIFO equals
                                                     of exceeds the value set in the RTHR field.                               */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] Read FIFO Underflow interrupt. Asserted when a pop operation
                                                     is done to a empty read FIFO.                                             */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] Write FIFO Overflow interrupt. This occurs when software
                                                     tries to write to a full fifo. The current operation does
                                                     not stop.                                                                 */
      __IOM uint32_t B2MST      : 1;            /*!< [4..4] B2M State change interrupt. Asserted on any change in
                                                     the B2M_STATE signal from the BLE Core.                                   */
      __IOM uint32_t IACC       : 1;            /*!< [5..5] illegal FIFO access interrupt. Asserted when there is
                                                     a overflow or underflow event                                             */
      __IOM uint32_t ICMD       : 1;            /*!< [6..6] illegal command interrupt. Asserted when a command is
                                                     written when an active command is in progress.                            */
      __IOM uint32_t BLECIRQ    : 1;            /*!< [7..7] BLE Core IRQ signal. Asserted when the BLE_IRQ signal
                                                     from the BLE Core is asserted, indicating the availability
                                                     of read data from the BLE Core.                                           */
      __IOM uint32_t BLECSSTAT  : 1;            /*!< [8..8] BLE Core SPI Status interrupt. Asserted when the SPI_STATUS
                                                     signal from the BLE Core is asserted, indicating that SPI
                                                     writes can be done to the BLE Core.Transfers to the BLE
                                                     Core should only be done when this signal is high.                        */
      __IOM uint32_t DCMP       : 1;            /*!< [9..9] DMA Complete. Processing of the DMA operation has completed
                                                     and the DMA submodule is returned into the idle state                     */
      __IOM uint32_t DERR       : 1;            /*!< [10..10] DMA Error encountered during the processing of the
                                                     DMA command. The DMA error could occur when the memory
                                                     access specified in the DMA operation is not available
                                                     or incorrectly specified.                                                 */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [11..11] Command queue is paused due to an active event enabled
                                                     in the PAUSEEN register. The interrupt is posted when the
                                                     event is enabled within the PAUSEEN register, the mask
                                                     is active in the CQIRQMASK field and the event occurs.                    */
      __IOM uint32_t CQUPD      : 1;            /*!< [12..12] Command queue write operation executed a register write
                                                     with the register address bit 0 set to 1. The low address
                                                     bits in the CQ address fields are unused and bit 0 can
                                                     be used to trigger an interrupt to indicate when this register
                                                     write is performed by the CQ operation.                                   */
      __IOM uint32_t CQERR      : 1;            /*!< [13..13] Command queue error during processing. When an error
                                                     occurs, the system will stop processing and halt operations
                                                     to allow software to take recovery actions                                */
      __IOM uint32_t B2MSLEEP   : 1;            /*!< [14..14] The B2M_STATE from the BLE Core transitioned into the
                                                     sleep state                                                               */
      __IOM uint32_t B2MACTIVE  : 1;            /*!< [15..15] Revision A: The B2M_STATE from the BLE Core transitioned
                                                     into the active state Revision B: Falling BLE Core IRQ
                                                     signal. Asserted when the BLE_IRQ signal from the BLE Core
                                                     is de-asserted (1 -> 0)                                                   */
      __IOM uint32_t B2MSHUTDN  : 1;            /*!< [16..16] Revision A: The B2M_STATE from the BLE Core transitioned
                                                     into shutdown state Revision B: Falling BLE Core Status
                                                     signal. Asserted when the BLE_STATUS signal from the BLE
                                                     Core is de-asserted (1 -> 0)                                              */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000224) IO Master Interrupts: Status                               */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Command Complete interrupt. Asserted when the current
                                                     operation has completed. For repeated commands, this will
                                                     only be asserted when the final repeated command is completed.            */
      __IOM uint32_t THR        : 1;            /*!< [1..1] FIFO Threshold interrupt. For write operations, asserted
                                                     when the number of free bytes in the write FIFO equals
                                                     or exceeds the WTHR field.For read operations, asserted
                                                     when the number of valid bytes in the read FIFO equals
                                                     of exceeds the value set in the RTHR field.                               */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] Read FIFO Underflow interrupt. Asserted when a pop operation
                                                     is done to a empty read FIFO.                                             */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] Write FIFO Overflow interrupt. This occurs when software
                                                     tries to write to a full fifo. The current operation does
                                                     not stop.                                                                 */
      __IOM uint32_t B2MST      : 1;            /*!< [4..4] B2M State change interrupt. Asserted on any change in
                                                     the B2M_STATE signal from the BLE Core.                                   */
      __IOM uint32_t IACC       : 1;            /*!< [5..5] illegal FIFO access interrupt. Asserted when there is
                                                     a overflow or underflow event                                             */
      __IOM uint32_t ICMD       : 1;            /*!< [6..6] illegal command interrupt. Asserted when a command is
                                                     written when an active command is in progress.                            */
      __IOM uint32_t BLECIRQ    : 1;            /*!< [7..7] BLE Core IRQ signal. Asserted when the BLE_IRQ signal
                                                     from the BLE Core is asserted, indicating the availability
                                                     of read data from the BLE Core.                                           */
      __IOM uint32_t BLECSSTAT  : 1;            /*!< [8..8] BLE Core SPI Status interrupt. Asserted when the SPI_STATUS
                                                     signal from the BLE Core is asserted, indicating that SPI
                                                     writes can be done to the BLE Core.Transfers to the BLE
                                                     Core should only be done when this signal is high.                        */
      __IOM uint32_t DCMP       : 1;            /*!< [9..9] DMA Complete. Processing of the DMA operation has completed
                                                     and the DMA submodule is returned into the idle state                     */
      __IOM uint32_t DERR       : 1;            /*!< [10..10] DMA Error encountered during the processing of the
                                                     DMA command. The DMA error could occur when the memory
                                                     access specified in the DMA operation is not available
                                                     or incorrectly specified.                                                 */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [11..11] Command queue is paused due to an active event enabled
                                                     in the PAUSEEN register. The interrupt is posted when the
                                                     event is enabled within the PAUSEEN register, the mask
                                                     is active in the CQIRQMASK field and the event occurs.                    */
      __IOM uint32_t CQUPD      : 1;            /*!< [12..12] Command queue write operation executed a register write
                                                     with the register address bit 0 set to 1. The low address
                                                     bits in the CQ address fields are unused and bit 0 can
                                                     be used to trigger an interrupt to indicate when this register
                                                     write is performed by the CQ operation.                                   */
      __IOM uint32_t CQERR      : 1;            /*!< [13..13] Command queue error during processing. When an error
                                                     occurs, the system will stop processing and halt operations
                                                     to allow software to take recovery actions                                */
      __IOM uint32_t B2MSLEEP   : 1;            /*!< [14..14] The B2M_STATE from the BLE Core transitioned into the
                                                     sleep state                                                               */
      __IOM uint32_t B2MACTIVE  : 1;            /*!< [15..15] Revision A: The B2M_STATE from the BLE Core transitioned
                                                     into the active state Revision B: Falling BLE Core IRQ
                                                     signal. Asserted when the BLE_IRQ signal from the BLE Core
                                                     is de-asserted (1 -> 0)                                                   */
      __IOM uint32_t B2MSHUTDN  : 1;            /*!< [16..16] Revision A: The B2M_STATE from the BLE Core transitioned
                                                     into shutdown state Revision B: Falling BLE Core Status
                                                     signal. Asserted when the BLE_STATUS signal from the BLE
                                                     Core is de-asserted (1 -> 0)                                              */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000228) IO Master Interrupts: Clear                                */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Command Complete interrupt. Asserted when the current
                                                     operation has completed. For repeated commands, this will
                                                     only be asserted when the final repeated command is completed.            */
      __IOM uint32_t THR        : 1;            /*!< [1..1] FIFO Threshold interrupt. For write operations, asserted
                                                     when the number of free bytes in the write FIFO equals
                                                     or exceeds the WTHR field.For read operations, asserted
                                                     when the number of valid bytes in the read FIFO equals
                                                     of exceeds the value set in the RTHR field.                               */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] Read FIFO Underflow interrupt. Asserted when a pop operation
                                                     is done to a empty read FIFO.                                             */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] Write FIFO Overflow interrupt. This occurs when software
                                                     tries to write to a full fifo. The current operation does
                                                     not stop.                                                                 */
      __IOM uint32_t B2MST      : 1;            /*!< [4..4] B2M State change interrupt. Asserted on any change in
                                                     the B2M_STATE signal from the BLE Core.                                   */
      __IOM uint32_t IACC       : 1;            /*!< [5..5] illegal FIFO access interrupt. Asserted when there is
                                                     a overflow or underflow event                                             */
      __IOM uint32_t ICMD       : 1;            /*!< [6..6] illegal command interrupt. Asserted when a command is
                                                     written when an active command is in progress.                            */
      __IOM uint32_t BLECIRQ    : 1;            /*!< [7..7] BLE Core IRQ signal. Asserted when the BLE_IRQ signal
                                                     from the BLE Core is asserted, indicating the availability
                                                     of read data from the BLE Core.                                           */
      __IOM uint32_t BLECSSTAT  : 1;            /*!< [8..8] BLE Core SPI Status interrupt. Asserted when the SPI_STATUS
                                                     signal from the BLE Core is asserted, indicating that SPI
                                                     writes can be done to the BLE Core.Transfers to the BLE
                                                     Core should only be done when this signal is high.                        */
      __IOM uint32_t DCMP       : 1;            /*!< [9..9] DMA Complete. Processing of the DMA operation has completed
                                                     and the DMA submodule is returned into the idle state                     */
      __IOM uint32_t DERR       : 1;            /*!< [10..10] DMA Error encountered during the processing of the
                                                     DMA command. The DMA error could occur when the memory
                                                     access specified in the DMA operation is not available
                                                     or incorrectly specified.                                                 */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [11..11] Command queue is paused due to an active event enabled
                                                     in the PAUSEEN register. The interrupt is posted when the
                                                     event is enabled within the PAUSEEN register, the mask
                                                     is active in the CQIRQMASK field and the event occurs.                    */
      __IOM uint32_t CQUPD      : 1;            /*!< [12..12] Command queue write operation executed a register write
                                                     with the register address bit 0 set to 1. The low address
                                                     bits in the CQ address fields are unused and bit 0 can
                                                     be used to trigger an interrupt to indicate when this register
                                                     write is performed by the CQ operation.                                   */
      __IOM uint32_t CQERR      : 1;            /*!< [13..13] Command queue error during processing. When an error
                                                     occurs, the system will stop processing and halt operations
                                                     to allow software to take recovery actions                                */
      __IOM uint32_t B2MSLEEP   : 1;            /*!< [14..14] The B2M_STATE from the BLE Core transitioned into the
                                                     sleep state                                                               */
      __IOM uint32_t B2MACTIVE  : 1;            /*!< [15..15] Revision A: The B2M_STATE from the BLE Core transitioned
                                                     into the active state Revision B: Falling BLE Core IRQ
                                                     signal. Asserted when the BLE_IRQ signal from the BLE Core
                                                     is de-asserted (1 -> 0)                                                   */
      __IOM uint32_t B2MSHUTDN  : 1;            /*!< [16..16] Revision A: The B2M_STATE from the BLE Core transitioned
                                                     into shutdown state Revision B: Falling BLE Core Status
                                                     signal. Asserted when the BLE_STATUS signal from the BLE
                                                     Core is de-asserted (1 -> 0)                                              */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000022C) IO Master Interrupts: Set                                  */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Command Complete interrupt. Asserted when the current
                                                     operation has completed. For repeated commands, this will
                                                     only be asserted when the final repeated command is completed.            */
      __IOM uint32_t THR        : 1;            /*!< [1..1] FIFO Threshold interrupt. For write operations, asserted
                                                     when the number of free bytes in the write FIFO equals
                                                     or exceeds the WTHR field.For read operations, asserted
                                                     when the number of valid bytes in the read FIFO equals
                                                     of exceeds the value set in the RTHR field.                               */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] Read FIFO Underflow interrupt. Asserted when a pop operation
                                                     is done to a empty read FIFO.                                             */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] Write FIFO Overflow interrupt. This occurs when software
                                                     tries to write to a full fifo. The current operation does
                                                     not stop.                                                                 */
      __IOM uint32_t B2MST      : 1;            /*!< [4..4] B2M State change interrupt. Asserted on any change in
                                                     the B2M_STATE signal from the BLE Core.                                   */
      __IOM uint32_t IACC       : 1;            /*!< [5..5] illegal FIFO access interrupt. Asserted when there is
                                                     a overflow or underflow event                                             */
      __IOM uint32_t ICMD       : 1;            /*!< [6..6] illegal command interrupt. Asserted when a command is
                                                     written when an active command is in progress.                            */
      __IOM uint32_t BLECIRQ    : 1;            /*!< [7..7] BLE Core IRQ signal. Asserted when the BLE_IRQ signal
                                                     from the BLE Core is asserted, indicating the availability
                                                     of read data from the BLE Core.                                           */
      __IOM uint32_t BLECSSTAT  : 1;            /*!< [8..8] BLE Core SPI Status interrupt. Asserted when the SPI_STATUS
                                                     signal from the BLE Core is asserted, indicating that SPI
                                                     writes can be done to the BLE Core.Transfers to the BLE
                                                     Core should only be done when this signal is high.                        */
      __IOM uint32_t DCMP       : 1;            /*!< [9..9] DMA Complete. Processing of the DMA operation has completed
                                                     and the DMA submodule is returned into the idle state                     */
      __IOM uint32_t DERR       : 1;            /*!< [10..10] DMA Error encountered during the processing of the
                                                     DMA command. The DMA error could occur when the memory
                                                     access specified in the DMA operation is not available
                                                     or incorrectly specified.                                                 */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [11..11] Command queue is paused due to an active event enabled
                                                     in the PAUSEEN register. The interrupt is posted when the
                                                     event is enabled within the PAUSEEN register, the mask
                                                     is active in the CQIRQMASK field and the event occurs.                    */
      __IOM uint32_t CQUPD      : 1;            /*!< [12..12] Command queue write operation executed a register write
                                                     with the register address bit 0 set to 1. The low address
                                                     bits in the CQ address fields are unused and bit 0 can
                                                     be used to trigger an interrupt to indicate when this register
                                                     write is performed by the CQ operation.                                   */
      __IOM uint32_t CQERR      : 1;            /*!< [13..13] Command queue error during processing. When an error
                                                     occurs, the system will stop processing and halt operations
                                                     to allow software to take recovery actions                                */
      __IOM uint32_t B2MSLEEP   : 1;            /*!< [14..14] The B2M_STATE from the BLE Core transitioned into the
                                                     sleep state                                                               */
      __IOM uint32_t B2MACTIVE  : 1;            /*!< [15..15] Revision A: The B2M_STATE from the BLE Core transitioned
                                                     into the active state Revision B: Falling BLE Core IRQ
                                                     signal. Asserted when the BLE_IRQ signal from the BLE Core
                                                     is de-asserted (1 -> 0)                                                   */
      __IOM uint32_t B2MSHUTDN  : 1;            /*!< [16..16] Revision A: The B2M_STATE from the BLE Core transitioned
                                                     into shutdown state Revision B: Falling BLE Core Status
                                                     signal. Asserted when the BLE_STATUS signal from the BLE
                                                     Core is de-asserted (1 -> 0)                                              */
    } INTSET_b;
  } ;

  union {
    __IOM uint32_t DMATRIGEN;                   /*!< (@ 0x00000230) DMA Trigger Enable Register                                */

    struct {
      __IOM uint32_t DCMDCMPEN  : 1;            /*!< [0..0] Trigger DMA upon command complete. Enables the trigger
                                                     of the DMA when a command is completed. When this event
                                                     is triggered, the number of words transferred will be the
                                                     lesser of the remaining TOTCOUNT bytes, or the number of
                                                     bytes in the FIFO when the command completed. If this is
                                                     disabled, and the number of bytes in the FIFO is equal
                                                     or greater than the TOTCOUNT bytes, a transfer of TOTCOUNT
                                                     bytes will be done to ensure read data is stored when the
                                                     DMA is completed.                                                         */
      __IOM uint32_t DTHREN     : 1;            /*!< [1..1] Trigger DMA upon THR level reached. For M2P DMA operations
                                                     (IOM writes), the trigger will assert when the write FIFO
                                                     has (WTHR/4) number of words free in the write FIFO, and
                                                     will transfer (WTHR/4) number of wordsor, if the number
                                                     of words left to transfer is less than the WTHR value,
                                                     will transfer the remaining byte count.For P2M DMA operations,
                                                     the trigger will assert when the read FIFO has (RTHR/4)
                                                     words available in the read FIFO, and will transfer (RTHR/4)
                                                     words to SRAM. This trigger will NOT asser                                */
    } DMATRIGEN_b;
  } ;

  union {
    __IOM uint32_t DMATRIGSTAT;                 /*!< (@ 0x00000234) DMA Trigger Status Register                                */

    struct {
      __IOM uint32_t DCMDCMP    : 1;            /*!< [0..0] Triggered DMA from Command complete event. Bit is read
                                                     only and can be cleared by disabling the DCMDCMP trigger
                                                     enable or by disabling DMA.                                               */
      __IOM uint32_t DTHR       : 1;            /*!< [1..1] Triggered DMA from THR event. Bit is read only and can
                                                     be cleared by disabling the DTHR trigger enable or by disabling
                                                     DMA.                                                                      */
      __IOM uint32_t DTOTCMP    : 1;            /*!< [2..2] DMA triggered when DCMDCMP = 0, and the amount of data
                                                     in the FIFO was enough to complete the DMA operation (greater
                                                     than or equal to current TOTCOUNT) when the command completed.
                                                     This trigger is default active when the DCMDCMP trigger
                                                     isdisabled and there is enough data in the FIFO to complete
                                                     the DMA operation.                                                        */
    } DMATRIGSTAT_b;
  } ;

  union {
    __IOM uint32_t DMACFG;                      /*!< (@ 0x00000238) DMA Configuration Register                                 */

    struct {
      __IOM uint32_t DMAEN      : 1;            /*!< [0..0] DMA Enable. Setting this bit to EN will start the DMA
                                                     operation. This should be the last DMA related register
                                                     set prior to issuing the command                                          */
      __IOM uint32_t DMADIR     : 1;            /*!< [1..1] Direction                                                          */
      __IM  uint32_t            : 6;
      __IOM uint32_t DMAPRI     : 1;            /*!< [8..8] Sets the Priority of the DMA request                               */
    } DMACFG_b;
  } ;

  union {
    __IOM uint32_t DMATOTCOUNT;                 /*!< (@ 0x0000023C) DMA Total Transfer Count                                   */

    struct {
      __IOM uint32_t TOTCOUNT   : 12;           /*!< [11..0] Triggered DMA from Command complete event occured. Bit
                                                     is read only and can be cleared by disabling the DTHR trigger
                                                     enable or by disabling DMA.                                               */
    } DMATOTCOUNT_b;
  } ;

  union {
    __IOM uint32_t DMATARGADDR;                 /*!< (@ 0x00000240) DMA Target Address Register                                */

    struct {
      __IOM uint32_t TARGADDR   : 21;           /*!< [20..0] Bits [19:0] of the target byte address for source of
                                                     DMA (either read or write). The address can be any byte
                                                     alignment, and does not have to be word aligned. In cases
                                                     of non-word aligned addresses, the DMA logic will take
                                                     care for ensuring only the target bytes are read/written.                 */
      __IM  uint32_t            : 7;
      __IOM uint32_t TARGADDR28 : 1;            /*!< [28..28] Bit 28 of the target byte address for source of DMA
                                                     (either read or write). In cases of non-word aligned addresses,
                                                     the DMA logic will take care for ensuring only the target
                                                     bytes are read/written.Setting to '1' will select the SRAM.
                                                     Setting to '0' will select the flash                                      */
    } DMATARGADDR_b;
  } ;

  union {
    __IOM uint32_t DMASTAT;                     /*!< (@ 0x00000244) DMA Status Register                                        */

    struct {
      __IOM uint32_t DMATIP     : 1;            /*!< [0..0] DMA Transfer In Progress indicator. 1 will indicate that
                                                     a DMA transfer is active. The DMA transfer may be waiting
                                                     on data, transferring data, or waiting for priority.All
                                                     of these will be indicated with a 1. A 0 will indicate
                                                     that the DMA is fully complete and no further transactions
                                                     will be done. This bit is read only.                                      */
      __IOM uint32_t DMACPL     : 1;            /*!< [1..1] DMA Transfer Complete. This signals the end of the DMA
                                                     operation. This bit can be cleared by writing to 0.                       */
      __IOM uint32_t DMAERR     : 1;            /*!< [2..2] DMA Error. This active high bit signals that an error
                                                     was encountered during the DMA operation.                                 */
    } DMASTAT_b;
  } ;

  union {
    __IOM uint32_t CQCFG;                       /*!< (@ 0x00000248) Command Queue Configuration Register                       */

    struct {
      __IOM uint32_t CQEN       : 1;            /*!< [0..0] Command queue enable. When set, will enable the processing
                                                     of the command queue and fetches of address/data pairs
                                                     will proceed from the word address within the CQADDR register.
                                                     Can be disabledusing a CQ executed write to this bit as
                                                     well.                                                                     */
      __IOM uint32_t CQPRI      : 1;            /*!< [1..1] Sets the Priority of the command queue dma request.                */
    } CQCFG_b;
  } ;

  union {
    __IOM uint32_t CQADDR;                      /*!< (@ 0x0000024C) CQ Target Read Address Register                            */

    struct {
      __IM  uint32_t            : 2;
      __IOM uint32_t CQADDR     : 19;           /*!< [20..2] Bits 19:2 of target byte address for source of CQ (read
                                                     only). The buffer must be aligned on a word boundary                      */
      __IM  uint32_t            : 7;
      __IOM uint32_t CQADDR28   : 1;            /*!< [28..28] Bit 28 of target byte address for source of CQ (read
                                                     only). Used to denote Flash (0) or SRAM (1) access                        */
    } CQADDR_b;
  } ;

  union {
    __IOM uint32_t CQSTAT;                      /*!< (@ 0x00000250) Command Queue Status Register                              */

    struct {
      __IOM uint32_t CQTIP      : 1;            /*!< [0..0] Command queue Transfer In Progress indicator. 1 will
                                                     indicate that a CQ transfer is active and this will remain
                                                     active even when paused waiting for external event.                       */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [1..1] Command queue operation is currently paused.                       */
      __IOM uint32_t CQERR      : 1;            /*!< [2..2] Command queue processing Error. This active high bit
                                                     signals that an error was encountered during the CQ operation.            */
    } CQSTAT_b;
  } ;

  union {
    __IOM uint32_t CQFLAGS;                     /*!< (@ 0x00000254) Command Queue Flag Register                                */

    struct {
      __IOM uint32_t CQFLAGS    : 16;           /*!< [15..0] Current flag status (read-only). Bits [7:0] are software
                                                     controllable and bits [15:8] are hardware status.                         */
      __IOM uint32_t CQIRQMASK  : 16;           /*!< [31..16] Provides for a per-bit mask of the flags used to invoke
                                                     an interrupt. A '1' in the bit position will enable the
                                                     pause event to trigger the interrupt, if the CQWT_int interrupt
                                                     is enabled.Bits definitions are the same as CQPAUSE                       */
    } CQFLAGS_b;
  } ;

  union {
    __IOM uint32_t CQSETCLEAR;                  /*!< (@ 0x00000258) Command Queue Flag Set/Clear Register                      */

    struct {
      __IOM uint32_t CQFSET     : 8;            /*!< [7..0] Set CQFlag status bits. Will set to 1 the value of any
                                                     SWFLAG with a '1' in the corresponding bit position of
                                                     this field                                                                */
      __IOM uint32_t CQFTGL     : 8;            /*!< [15..8] Toggle the indicated bit. Will toggle the value of any
                                                     SWFLAG with a '1' in the corresponding bit position of
                                                     this field                                                                */
      __IOM uint32_t CQFCLR     : 8;            /*!< [23..16] Clear CQFlag status bits. Will clear to 0 any SWFLAG
                                                     with a '1' in the corresponding bit position of this field                */
    } CQSETCLEAR_b;
  } ;

  union {
    __IOM uint32_t CQPAUSEEN;                   /*!< (@ 0x0000025C) Command Queue Pause Enable Register                        */

    struct {
      __IOM uint32_t CQPEN      : 16;           /*!< [15..0] Enables the specified event to pause command processing
                                                     when active                                                               */
    } CQPAUSEEN_b;
  } ;

  union {
    __IOM uint32_t CQCURIDX;                    /*!< (@ 0x00000260) IOM Command Queue current index value . Compared
                                                                    to the CQENDIDX reg contents to generate
                                                                    the IDXEQ Pause event for command queue                    */

    struct {
      __IOM uint32_t CQCURIDX   : 8;            /*!< [7..0] Holds 8 bits of data that will be compared with the CQENDIX
                                                     register field. If the values match, the IDXEQ pause event
                                                     will be activated, which will cause the pausing of command
                                                     quue operation if the IDXEQ bit is enabled in CQPAUSEEN.                  */
    } CQCURIDX_b;
  } ;

  union {
    __IOM uint32_t CQENDIDX;                    /*!< (@ 0x00000264) IOM Command Queue current index value . Compared
                                                                    to the CQCURIDX reg contents to generate
                                                                    the IDXEQ Pause event for command queue                    */

    struct {
      __IOM uint32_t CQENDIDX   : 8;            /*!< [7..0] Holds 8 bits of data that will be compared with the CQCURIX
                                                     register field. If the values match, the IDXEQ pause event
                                                     will be activated, which will cause the pausing of command
                                                     quue operation if the IDXEQ bit is enabled in CQPAUSEEN.                  */
    } CQENDIDX_b;
  } ;

  union {
    __IOM uint32_t STATUS;                      /*!< (@ 0x00000268) IOM Module Status Register                                 */

    struct {
      __IOM uint32_t ERR        : 1;            /*!< [0..0] Bit has been deprecated. Please refer to the other error
                                                     indicators. This will always return 0.                                    */
      __IOM uint32_t CMDACT     : 1;            /*!< [1..1] Indicates if the active I/O Command is currently processing
                                                     a transaction, or command is complete, but the FIFO pointers
                                                     are still syncronizing internally. This bit will go high
                                                     atthe start of the transaction, and will go low when the
                                                     command is complete, and the data and pointers within the
                                                     FIFO have been syncronized.                                               */
      __IOM uint32_t IDLEST     : 1;            /*!< [2..2] indicates if the active I/O state machine is IDLE. Note
                                                     - The state machine could be in idle state due to holdoffs
                                                     from data availability, or as the command gets propagated
                                                     into the logic from the registers.                                        */
    } STATUS_b;
  } ;
  __IM  uint32_t  RESERVED4[37];

  union {
    __IOM uint32_t MSPICFG;                     /*!< (@ 0x00000300) SPI module master configuration                            */

    struct {
      __IOM uint32_t SPOL       : 1;            /*!< [0..0] This bit selects SPI polarity.                                     */
      __IOM uint32_t SPHA       : 1;            /*!< [1..1] Selects the SPI phase; When 1, will shift the sampling
                                                     edge by 1/2 clock.                                                        */
      __IOM uint32_t FULLDUP    : 1;            /*!< [2..2] Full Duplex mode. Capture read data during writes operations       */
      __IM  uint32_t            : 13;
      __IOM uint32_t WTFC       : 1;            /*!< [16..16] Enables flow control of new write transactions based
                                                     on the SPI_STATUS signal from the BLE Core.                               */
      __IOM uint32_t RDFC       : 1;            /*!< [17..17] Enables flow control of new read transactions based
                                                     on the SPI_STATUS signal from the BLE Core.                               */
      __IM  uint32_t            : 3;
      __IOM uint32_t WTFCPOL    : 1;            /*!< [21..21] Selects the write flow control signal polarity. The
                                                     transfers are halted when the selected flow control signal
                                                     is OPPOSITE polarity of this bit. (For example: WTFCPOL
                                                     = 0 will allow a SPI_STATUS=1 to pause transfers).                        */
      __IOM uint32_t RDFCPOL    : 1;            /*!< [22..22] Selects the read flow control signal polarity. When
                                                     set, the clock will be held low until the flow control
                                                     is de-asserted.                                                           */
      __IOM uint32_t SPILSB     : 1;            /*!< [23..23] Selects data transfer as MSB first (0) or LSB first
                                                     (1) for the data portion of the SPI transaction. The offset
                                                     bytes are always transmitted MSB first.                                   */
      __IOM uint32_t DINDLY     : 3;            /*!< [26..24] Delay tap to use for the input signal (MISO). This
                                                     gives more hold time on the input data.                                   */
      __IOM uint32_t DOUTDLY    : 3;            /*!< [29..27] Delay tap to use for the output signal (MOSI). This
                                                     give more hold time on the output data.                                   */
      __IOM uint32_t MSPIRST    : 1;            /*!< [30..30] Bit is deprecated. setting it will have no effect.               */
    } MSPICFG_b;
  } ;

  union {
    __IOM uint32_t BLECFG;                      /*!< (@ 0x00000304) BLE Core Control                                           */

    struct {
      __IOM uint32_t PWRSMEN    : 1;            /*!< [0..0] Enable the power state machine for automatic sequencing
                                                     and control of power states of the BLE Core module.                       */
      __IOM uint32_t BLERSTN    : 1;            /*!< [1..1] Reset line to the BLE Core. This will reset the BLE core
                                                     when asserted ('0') and must be written to '1' prior to
                                                     performing any BTLE related operations to the core.                       */
      __IOM uint32_t WAKEUPCTL  : 2;            /*!< [3..2] WAKE signal override. Controls the source of the WAKE
                                                     signal to the BLE Core.                                                   */
      __IOM uint32_t DCDCFLGCTL : 2;            /*!< [5..4] DCDCFLG signal override. The value of this field will
                                                     be sent to the BLE Core when the PWRSM is off. Otherwise,
                                                     the value is supplied from internal logic.                                */
      __IOM uint32_t BLEHREQCTL : 2;            /*!< [7..6] BLEH power on request override. The value of this field
                                                     will be sent to the BLE Core when the PWRSM is off. Otherwise,
                                                     the value is supplied from internal logic.                                */
      __IOM uint32_t WT4ACTOFF  : 1;            /*!< [8..8] Debug control of BLEIF power state machine. Allows transition
                                                     into the active state in the BLEIF state without waiting
                                                     for dcdc req from BLE Core.                                               */
      __IOM uint32_t MCUFRCSLP  : 1;            /*!< [9..9] Force power state machine to go to the sleep state. Intended
                                                     for debug only. Has no effect on the actual BLE Core state,
                                                     only the state of the BLEIF interface state machine.                      */
      __IOM uint32_t FRCCLK     : 1;            /*!< [10..10] Force the clock in the BLEIF to be always running                */
      __IOM uint32_t STAYASLEEP : 1;            /*!< [11..11] Set to prevent the BLE power control module from waking
                                                     up the BLE Core after going into power down. To be used
                                                     for graceful shutdown, set by software prior to powering
                                                     off and will allow assertion of reset from sleep state.                   */
      __IOM uint32_t PWRISOCTL  : 2;            /*!< [13..12] Configuration of BLEH isolation control for power related
                                                     signals.                                                                  */
      __IOM uint32_t SPIISOCTL  : 2;            /*!< [15..14] Configuration of BLEH isolation controls for SPI related
                                                     signals.                                                                  */
    } BLECFG_b;
  } ;

  union {
    __IOM uint32_t PWRCMD;                      /*!< (@ 0x00000308) BLE Power command interface                                */

    struct {
      __IOM uint32_t WAKEREQ    : 1;            /*!< [0..0] Wake request from the MCU. When asserted (1), the BLE
                                                     Interface logic will assert the wakeup request signal to
                                                     the BLE Core. Only recognized when in the sleep state                     */
      __IOM uint32_t RESTART    : 1;            /*!< [1..1] Restart the BLE Core after going into the shutdown state.
                                                     Only valid when in the shutdown state.                                    */
    } PWRCMD_b;
  } ;

  union {
    __IOM uint32_t BSTATUS;                     /*!< (@ 0x0000030C) BLE Core status                                            */

    struct {
      __IOM uint32_t B2MSTATE   : 3;            /*!< [2..0] State of the BLE Core logic.                                       */
      __IOM uint32_t SPISTATUS  : 1;            /*!< [3..3] Value of the SPISTATUS signal from the BLE Core. The
                                                     signal is asserted when the BLE Core is able to accept
                                                     write data via the SPI interface. Data should be transmitted
                                                     to theBLE core only when this signal is 1. The hardware
                                                     will automatically wait for this signal prior to performing
                                                     a write operation if flow control is active.                              */
      __IOM uint32_t DCDCREQ    : 1;            /*!< [4..4] Value of the DCDCREQ signal from the BLE Core. The DCDCREQ
                                                     signal is sent from the core to the BLEIF module when the
                                                     BLE core requires BLEH power to be active. When activated,
                                                     this isindicated by DCDCFLAG going to 1.                                  */
      __IOM uint32_t DCDCFLAG   : 1;            /*!< [5..5] Value of the DCDCFLAG signal to the BLE Core. The DCDCFLAG
                                                     is a signal to the BLE Core indicating that the BLEH ppower
                                                     is active.                                                                */
      __IOM uint32_t WAKEUP     : 1;            /*!< [6..6] Value of the WAKEUP signal to the BLE Core . The WAKEUP
                                                     signals is sent from the BLEIF to the BLECORE to request
                                                     the BLE Core transition from sleep state to active state.                 */
      __IOM uint32_t BLEIRQ     : 1;            /*!< [7..7] Status of the BLEIRQ signal from the BLE Core. A value
                                                     of 1 idicates that read data is available in the core and
                                                     a read operation needs to be performed.                                   */
      __IOM uint32_t PWRST      : 3;            /*!< [10..8] Current status of the power state machine                         */
      __IOM uint32_t BLEHACK    : 1;            /*!< [11..11] Value of the BLEHACK signal from the power control
                                                     unit. If the signal is '1', the BLEH power is active and
                                                     ready for use.                                                            */
      __IOM uint32_t BLEHREQ    : 1;            /*!< [12..12] Value of the BLEHREQ signal to the power control unit.
                                                     The BLEHREQ signal is sent from the BLEIF module to the
                                                     power control module to request the BLEH power up. When
                                                     the BLEHACK signal is asserted,BLEH power is stable and
                                                     ready for use.                                                            */
    } BSTATUS_b;
  } ;
  __IM  uint32_t  RESERVED5[64];

  union {
    __IOM uint32_t BLEDBG;                      /*!< (@ 0x00000410) BLEIF Master Debug Register                                */

    struct {
      __IOM uint32_t DBGEN      : 1;            /*!< [0..0] Debug Enable. Setting this bit will enable the update
                                                     of data within this register, otherwise it is clock gated
                                                     for power savings                                                         */
      __IOM uint32_t IOCLKON    : 1;            /*!< [1..1] IOCLK debug clock control. Enable IO_CLK to be active
                                                     when this bit is '1'. Otherwise, the clock is controlled
                                                     with gating from the logic as needed.                                     */
      __IOM uint32_t APBCLKON   : 1;            /*!< [2..2] APBCLK debug clock control. Enable APB_CLK to be active
                                                     when this bit is '1'. Otherwise, the clock is controlled
                                                     with gating from the logic as needed.                                     */
      __IOM uint32_t DBGDATA    : 29;           /*!< [31..3] Debug data                                                        */
    } BLEDBG_b;
  } ;
} BLEIF_Type;                                   /*!< Size = 1044 (0x414)                                                       */



/* =========================================================================================================================== */
/* ================                                         CACHECTRL                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief Flash Cache Controller (CACHECTRL)
  */

typedef struct {                                /*!< (@ 0x40018000) CACHECTRL Structure                                        */

  union {
    __IOM uint32_t CACHECFG;                    /*!< (@ 0x00000000) Flash Cache Control Register                               */

    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< [0..0] Enables the flash cache controller and enables power
                                                     to the cache SRAMs. The ICACHE_ENABLE and DCACHE_ENABLE
                                                     should be set to enable caching for each type of access.                  */
      __IOM uint32_t LRU        : 1;            /*!< [1..1] Sets the cache repleacment policy. 0=LRR (least recently
                                                     replaced), 1=LRU (least recently used). LRR minimizes writes
                                                     to the TAG SRAM.                                                          */
      __IOM uint32_t ENABLE_NC0 : 1;            /*!< [2..2] Enable Non-cacheable region 0. See NCR0 registers to
                                                     define the region.                                                        */
      __IOM uint32_t ENABLE_NC1 : 1;            /*!< [3..3] Enable Non-cacheable region 1. See NCR1 registers to
                                                     define the region.                                                        */
      __IOM uint32_t CONFIG     : 4;            /*!< [7..4] Sets the cache configuration                                       */
      __IOM uint32_t ICACHE_ENABLE : 1;         /*!< [8..8] Enable Flash Instruction Caching                                   */
      __IOM uint32_t DCACHE_ENABLE : 1;         /*!< [9..9] Enable Flash Data Caching.                                         */
      __IOM uint32_t CACHE_CLKGATE : 1;         /*!< [10..10] Enable clock gating of cache TAG RAM. Software should
                                                     enable this bit for optimal power efficiency.                             */
      __IOM uint32_t CACHE_LS   : 1;            /*!< [11..11] Enable LS (light sleep) of cache RAMs. Software should
                                                     DISABLE this bit since cache activity is too high to benefit
                                                     from LS usage.                                                            */
      __IM  uint32_t            : 8;
      __IOM uint32_t DATA_CLKGATE : 1;          /*!< [20..20] Enable aggressive clock gating of entire data array.
                                                     This bit should be set to 1 for optimal power efficiency.                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t ENABLE_MONITOR : 1;        /*!< [24..24] Enable Cache Monitoring Stats. Cache monitoring consumes
                                                     additional power and should only be enabled when profiling
                                                     code and counters will increment when this bit is set.
                                                     Counter values will be retained when this is set to 0,
                                                     allowing software to enable/disable counting for multiple
                                                     code segments.                                                            */
    } CACHECFG_b;
  } ;
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000008) Cache Control                                              */

    struct {
      __IOM uint32_t INVALIDATE : 1;            /*!< [0..0] Writing a 1 to this bitfield invalidates the flash cache
                                                     contents.                                                                 */
      __IOM uint32_t RESET_STAT : 1;            /*!< [1..1] Reset Cache Statistics. When written to a 1, the cache
                                                     monitor counters will be cleared. The monitor counters
                                                     can be reset only when the CACHECFG.ENABLE_MONITOR bit
                                                     is set.                                                                   */
      __IOM uint32_t CACHE_READY : 1;           /*!< [2..2] Cache Ready Status (enabled and not processing an invalidate
                                                     operation)                                                                */
      __IM  uint32_t            : 1;
      __IOM uint32_t FLASH0_SLM_STATUS : 1;     /*!< [4..4] Flash Sleep Mode Status. 1 indicates that flash0 is in
                                                     sleep mode, 0 indicates flash0 is in normal mode.                         */
      __IOM uint32_t FLASH0_SLM_DISABLE : 1;    /*!< [5..5] Disable Flash Sleep Mode. Write 1 to wake flash0 from
                                                     sleep mode (reading the array will also automatically wake
                                                     it).                                                                      */
      __IOM uint32_t FLASH0_SLM_ENABLE : 1;     /*!< [6..6] Enable Flash Sleep Mode. Write to 1 to put flash 0 into
                                                     sleep mode. NOTE: there is a 5us latency after waking flash
                                                     until the first access will be returned.                                  */
      __IM  uint32_t            : 1;
      __IOM uint32_t FLASH1_SLM_STATUS : 1;     /*!< [8..8] Flash Sleep Mode Status. 1 indicates that flash1 is in
                                                     sleep mode, 0 indicates flash1 is in normal mode.                         */
      __IOM uint32_t FLASH1_SLM_DISABLE : 1;    /*!< [9..9] Disable Flash Sleep Mode. Write 1 to wake flash1 from
                                                     sleep mode (reading the array will also automatically wake
                                                     it).                                                                      */
      __IOM uint32_t FLASH1_SLM_ENABLE : 1;     /*!< [10..10] Enable Flash Sleep Mode. Write to 1 to put flash 1
                                                     into sleep mode. NOTE: there is a 5us latency after waking
                                                     flash until the first access will be returned.                            */
      __IM  uint32_t            : 1;
      __IOM uint32_t FLASH2_SLM_STATUS : 1;     /*!< [12..12] Flash Sleep Mode Status. 1 indicates that flash1 is
                                                     in sleep mode, 0 indicates flash2 is in normal mode.                      */
      __IOM uint32_t FLASH2_SLM_DISABLE : 1;    /*!< [13..13] Disable Flash Sleep Mode. Write 1 to wake flash2 from
                                                     sleep mode (reading the array will also automatically wake
                                                     it).                                                                      */
      __IOM uint32_t FLASH2_SLM_ENABLE : 1;     /*!< [14..14] Enable Flash Sleep Mode. Write to 1 to put flash 1
                                                     into sleep mode. NOTE: there is a 5us latency after waking
                                                     flash until the first access will be returned.                            */
      __IM  uint32_t            : 1;
      __IOM uint32_t FLASH3_SLM_STATUS : 1;     /*!< [16..16] Flash Sleep Mode Status. 1 indicates that flash1 is
                                                     in sleep mode, 0 indicates flash1 is in normal mode.                      */
      __IOM uint32_t FLASH3_SLM_DISABLE : 1;    /*!< [17..17] Disable Flash Sleep Mode. Write 1 to wake flash1 from
                                                     sleep mode (reading the array will also automatically wake
                                                     it).                                                                      */
      __IOM uint32_t FLASH3_SLM_ENABLE : 1;     /*!< [18..18] Enable Flash Sleep Mode. Write to 1 to put flash 1
                                                     into sleep mode. NOTE: there is a 5us latency after waking
                                                     flash until the first access will be returned.                            */
    } CTRL_b;
  } ;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t NCR0START;                   /*!< (@ 0x00000010) Flash Cache Noncachable Region 0 Start                     */

    struct {
      __IM  uint32_t            : 4;
      __IOM uint32_t ADDR       : 23;           /*!< [26..4] Start address for non-cacheable region 0                          */
    } NCR0START_b;
  } ;

  union {
    __IOM uint32_t NCR0END;                     /*!< (@ 0x00000014) Flash Cache Noncachable Region 0 End                       */

    struct {
      __IM  uint32_t            : 4;
      __IOM uint32_t ADDR       : 23;           /*!< [26..4] End address for non-cacheable region 0                            */
    } NCR0END_b;
  } ;

  union {
    __IOM uint32_t NCR1START;                   /*!< (@ 0x00000018) Flash Cache Noncachable Region 1 Start                     */

    struct {
      __IM  uint32_t            : 4;
      __IOM uint32_t ADDR       : 23;           /*!< [26..4] Start address for non-cacheable region 1                          */
    } NCR1START_b;
  } ;

  union {
    __IOM uint32_t NCR1END;                     /*!< (@ 0x0000001C) Flash Cache Noncachable Region 1 End                       */

    struct {
      __IM  uint32_t            : 4;
      __IOM uint32_t ADDR       : 23;           /*!< [26..4] End address for non-cacheable region 1                            */
    } NCR1END_b;
  } ;
  __IM  uint32_t  RESERVED2[8];

  union {
    __IOM uint32_t DMON0;                       /*!< (@ 0x00000040) Data Cache Total Accesses                                  */

    struct {
      __IOM uint32_t DACCESS_COUNT : 32;        /*!< [31..0] Total accesses to data cache. All performance metrics
                                                     should be relative to the number of accesses performed.                   */
    } DMON0_b;
  } ;

  union {
    __IOM uint32_t DMON1;                       /*!< (@ 0x00000044) Data Cache Tag Lookups                                     */

    struct {
      __IOM uint32_t DLOOKUP_COUNT : 32;        /*!< [31..0] Total tag lookups from data cache.                                */
    } DMON1_b;
  } ;

  union {
    __IOM uint32_t DMON2;                       /*!< (@ 0x00000048) Data Cache Hits                                            */

    struct {
      __IOM uint32_t DHIT_COUNT : 32;           /*!< [31..0] Cache hits from lookup operations.                                */
    } DMON2_b;
  } ;

  union {
    __IOM uint32_t DMON3;                       /*!< (@ 0x0000004C) Data Cache Line Hits                                       */

    struct {
      __IOM uint32_t DLINE_COUNT : 32;          /*!< [31..0] Cache hits from line cache                                        */
    } DMON3_b;
  } ;

  union {
    __IOM uint32_t IMON0;                       /*!< (@ 0x00000050) Instruction Cache Total Accesses                           */

    struct {
      __IOM uint32_t IACCESS_COUNT : 32;        /*!< [31..0] Total accesses to Instruction cache                               */
    } IMON0_b;
  } ;

  union {
    __IOM uint32_t IMON1;                       /*!< (@ 0x00000054) Instruction Cache Tag Lookups                              */

    struct {
      __IOM uint32_t ILOOKUP_COUNT : 32;        /*!< [31..0] Total tag lookups from Instruction cache                          */
    } IMON1_b;
  } ;

  union {
    __IOM uint32_t IMON2;                       /*!< (@ 0x00000058) Instruction Cache Hits                                     */

    struct {
      __IOM uint32_t IHIT_COUNT : 32;           /*!< [31..0] Cache hits from lookup operations                                 */
    } IMON2_b;
  } ;

  union {
    __IOM uint32_t IMON3;                       /*!< (@ 0x0000005C) Instruction Cache Line Hits                                */

    struct {
      __IOM uint32_t ILINE_COUNT : 32;          /*!< [31..0] Cache hits from line cache                                        */
    } IMON3_b;
  } ;
  __IM  uint32_t  RESERVED3[40];

  union {
    __IOM uint32_t FLASH0CFG;                   /*!< (@ 0x00000100) Flash 0 Control Register                                   */

    struct {
      __IOM uint32_t RDWAIT0    : 4;            /*!< [3..0] Sets read waitstates for normal (fast) operation. A value
                                                     of 1 is recommended.                                                      */
      __IOM uint32_t SEDELAY0   : 3;            /*!< [6..4] Sets SE delay (flash address setup). A value of 5 is
                                                     recommended.                                                              */
      __IM  uint32_t            : 1;
      __IOM uint32_t LPMRDWAIT0 : 4;            /*!< [11..8] Sets flash waitstates when in LPM Mode 2 (RD_WAIT in
                                                     LPM mode 2 only)                                                          */
      __IOM uint32_t LPMMODE0   : 2;            /*!< [13..12] Controls flash low power modes (control of LPM pin).             */
    } FLASH0CFG_b;
  } ;

  union {
    __IOM uint32_t FLASH1CFG;                   /*!< (@ 0x00000104) Flash 1 Control Register                                   */

    struct {
      __IOM uint32_t RDWAIT1    : 4;            /*!< [3..0] Sets read waitstates for normal (fast) operation. A value
                                                     of 1 is recommended.                                                      */
      __IOM uint32_t SEDELAY1   : 3;            /*!< [6..4] Sets SE delay (flash address setup). A value of 5 is
                                                     recommended.                                                              */
      __IM  uint32_t            : 1;
      __IOM uint32_t LPMRDWAIT1 : 4;            /*!< [11..8] Sets flash waitstates when in LPM Mode 2 (RD_WAIT in
                                                     LPM mode 2 only)                                                          */
      __IOM uint32_t LPMMODE1   : 2;            /*!< [13..12] Controls flash low power modes (control of LPM pin).             */
    } FLASH1CFG_b;
  } ;

  union {
    __IOM uint32_t FLASH2CFG;                   /*!< (@ 0x00000108) Flash 2 Control Register                                   */

    struct {
      __IOM uint32_t RDWAIT2    : 4;            /*!< [3..0] Sets read waitstates for normal (fast) operation. A value
                                                     of 1 is recommended.                                                      */
      __IOM uint32_t SEDELAY2   : 3;            /*!< [6..4] Sets SE delay (flash address setup). A value of 5 is
                                                     recommended.                                                              */
      __IM  uint32_t            : 1;
      __IOM uint32_t LPMRDWAIT2 : 4;            /*!< [11..8] Sets flash waitstates when in LPM Mode 2 (RD_WAIT in
                                                     LPM mode 2 only)                                                          */
      __IOM uint32_t LPMMODE2   : 2;            /*!< [13..12] Controls flash low power modes (control of LPM pin).             */
    } FLASH2CFG_b;
  } ;

  union {
    __IOM uint32_t FLASH3CFG;                   /*!< (@ 0x0000010C) Flash 3 Control Register                                   */

    struct {
      __IOM uint32_t RDWAIT3    : 4;            /*!< [3..0] Sets read waitstates for normal (fast) operation. A value
                                                     of 1 is recommended.                                                      */
      __IOM uint32_t SEDELAY3   : 3;            /*!< [6..4] Sets SE delay (flash address setup). A value of 5 is
                                                     recommended.                                                              */
      __IM  uint32_t            : 1;
      __IOM uint32_t LPMRDWAIT3 : 4;            /*!< [11..8] Sets flash waitstates when in LPM Mode 2 (RD_WAIT in
                                                     LPM mode 2 only)                                                          */
      __IOM uint32_t LPMMODE3   : 2;            /*!< [13..12] Controls flash low power modes (control of LPM pin).             */
    } FLASH3CFG_b;
  } ;
} CACHECTRL_Type;                               /*!< Size = 272 (0x110)                                                        */



/* =========================================================================================================================== */
/* ================                                          CLKGEN                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Clock Generator (CLKGEN)
  */

typedef struct {                                /*!< (@ 0x40004000) CLKGEN Structure                                           */

  union {
    __IOM uint32_t CALXT;                       /*!< (@ 0x00000000) XT Oscillator Control                                      */

    struct {
      __IOM uint32_t CALXT      : 11;           /*!< [10..0] XT Oscillator calibration value. This register will
                                                     enable the hardware to increase or decrease the number
                                                     of cycles in a 16KHz clock derived from the original 32KHz
                                                     version. The most significant bit is the sign. A '1' is
                                                     a reduction, and a '0' is an addition. This calibration
                                                     value will add or reduce the number of cycles programmed
                                                     here across a 32 second interval. The maximum value that
                                                     is effective is from -1024 to 1023.                                       */
    } CALXT_b;
  } ;

  union {
    __IOM uint32_t CALRC;                       /*!< (@ 0x00000004) RC Oscillator Control                                      */

    struct {
      __IOM uint32_t CALRC      : 18;           /*!< [17..0] LFRC Oscillator calibration value. This register will
                                                     enable the hardware to increase or decrease the number
                                                     of cycles in a 512 Hz clock derived from the original 1024
                                                     version. The most significant bit is the sign. A '1' is
                                                     a reduction, and a '0' is an addition. This calibration
                                                     value will add or reduce the number of cycles programmed
                                                     here across a 32 second interval. The range is from -131072
                                                     (decimal) to 131071 (decimal). This register is normally
                                                     used in conjuction with ACALCTR register. The CAL                         */
    } CALRC_b;
  } ;

  union {
    __IOM uint32_t ACALCTR;                     /*!< (@ 0x00000008) Autocalibration Counter                                    */

    struct {
      __IOM uint32_t ACALCTR    : 24;           /*!< [23..0] Autocalibration Counter result. Bits 17 down to 0 of
                                                     this is feed directly to the CALRC register if ACAL register
                                                     in OCTRL register is set to 1024SEC or 512SEC.                            */
    } ACALCTR_b;
  } ;

  union {
    __IOM uint32_t OCTRL;                       /*!< (@ 0x0000000C) Oscillator Control                                         */

    struct {
      __IOM uint32_t STOPXT     : 1;            /*!< [0..0] Stop the XT Oscillator to the RTC                                  */
      __IOM uint32_t STOPRC     : 1;            /*!< [1..1] Stop the LFRC Oscillator to the RTC                                */
      __IM  uint32_t            : 4;
      __IOM uint32_t FOS        : 1;            /*!< [6..6] Oscillator switch on failure function. If this is set,
                                                     then LFRC clock source will switch from XT to RC.                         */
      __IOM uint32_t OSEL       : 1;            /*!< [7..7] Selects the RTC oscillator (1 => LFRC, 0 => XT)                    */
      __IOM uint32_t ACAL       : 3;            /*!< [10..8] Autocalibration control. This selects the source to
                                                     be used in the autocalibration flow. This flow can also
                                                     be used to measure an internal clock against an external
                                                     clock source, with the external clock normally used as
                                                     the reference.                                                            */
    } OCTRL_b;
  } ;

  union {
    __IOM uint32_t CLKOUT;                      /*!< (@ 0x00000010) CLKOUT Frequency Select                                    */

    struct {
      __IOM uint32_t CKSEL      : 6;            /*!< [5..0] CLKOUT signal select                                               */
      __IM  uint32_t            : 1;
      __IOM uint32_t CKEN       : 1;            /*!< [7..7] Enable the CLKOUT signal                                           */
    } CLKOUT_b;
  } ;

  union {
    __IOM uint32_t CLKKEY;                      /*!< (@ 0x00000014) Key Register for Clock Control Register                    */

    struct {
      __IOM uint32_t CLKKEY     : 32;           /*!< [31..0] Key register value.                                               */
    } CLKKEY_b;
  } ;

  union {
    __IOM uint32_t CCTRL;                       /*!< (@ 0x00000018) HFRC Clock Control                                         */

    struct {
      __IOM uint32_t CORESEL    : 1;            /*!< [0..0] Core Clock divisor                                                 */
    } CCTRL_b;
  } ;

  union {
    __IOM uint32_t STATUS;                      /*!< (@ 0x0000001C) Clock Generator Status                                     */

    struct {
      __IOM uint32_t OMODE      : 1;            /*!< [0..0] Current RTC oscillator (1 => LFRC, 0 => XT). After an
                                                     RTC oscillator change, it may take up to 2 seconds for
                                                     this field to reflect the new oscillator.                                 */
      __IOM uint32_t OSCF       : 1;            /*!< [1..1] XT Oscillator is enabled but not oscillating                       */
    } STATUS_b;
  } ;

  union {
    __IOM uint32_t HFADJ;                       /*!< (@ 0x00000020) HFRC Adjustment                                            */

    struct {
      __IOM uint32_t HFADJEN    : 1;            /*!< [0..0] HFRC adjustment control                                            */
      __IOM uint32_t HFADJCK    : 3;            /*!< [3..1] Repeat period for HFRC adjustment                                  */
      __IM  uint32_t            : 4;
      __IOM uint32_t HFXTADJ    : 12;           /*!< [19..8] Target HFRC adjustment value.                                     */
      __IOM uint32_t HFWARMUP   : 1;            /*!< [20..20] XT warmup period for HFRC adjustment                             */
      __IOM uint32_t HFADJGAIN  : 3;            /*!< [23..21] Gain control for HFRC adjustment                                 */
    } HFADJ_b;
  } ;
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t CLOCKENSTAT;                 /*!< (@ 0x00000028) Clock Enable Status                                        */

    struct {
      __IOM uint32_t CLOCKENSTAT : 32;          /*!< [31..0] Clock enable status                                               */
    } CLOCKENSTAT_b;
  } ;

  union {
    __IOM uint32_t CLOCKEN2STAT;                /*!< (@ 0x0000002C) Clock Enable Status                                        */

    struct {
      __IOM uint32_t CLOCKEN2STAT : 32;         /*!< [31..0] Clock enable status 2                                             */
    } CLOCKEN2STAT_b;
  } ;

  union {
    __IOM uint32_t CLOCKEN3STAT;                /*!< (@ 0x00000030) Clock Enable Status                                        */

    struct {
      __IOM uint32_t CLOCKEN3STAT : 32;         /*!< [31..0] Clock enable status 3                                             */
    } CLOCKEN3STAT_b;
  } ;

  union {
    __IOM uint32_t FREQCTRL;                    /*!< (@ 0x00000034) HFRC Frequency Control register                            */

    struct {
      __IOM uint32_t BURSTREQ   : 1;            /*!< [0..0] Frequency Burst Enable Request                                     */
      __IOM uint32_t BURSTACK   : 1;            /*!< [1..1] Frequency Burst Request Acknowledge. Frequency burst
                                                     requested is always acknowledged whether burst is granted
                                                     or not depending on feature enable.                                       */
      __IOM uint32_t BURSTSTATUS : 1;           /*!< [2..2] This represents frequency burst status.                            */
    } FREQCTRL_b;
  } ;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t BLEBUCKTONADJ;               /*!< (@ 0x0000003C) BLE BUCK TON ADJUST                                        */

    struct {
      __IOM uint32_t TONLOWTHRESHOLD : 10;      /*!< [9..0] TON ADJUST LOW THRESHOLD. Suggested values are #A(94KHz)
                                                     #15(47KHz) #53(12Khz) #14D(3Khz)                                          */
      __IOM uint32_t TONHIGHTHRESHOLD : 10;     /*!< [19..10] TON ADJUST HIGH THRESHOLD. Suggested values are #15(94KHz)
                                                     #2A(47Khz) #A6(12Khz) #29A(3Khz)                                          */
      __IOM uint32_t TONADJUSTPERIOD : 2;       /*!< [21..20] TON ADJUST PERIOD                                                */
      __IOM uint32_t TONADJUSTEN : 1;           /*!< [22..22] TON ADJUST ENABLE                                                */
      __IOM uint32_t ZEROLENDETECTTRIM : 4;     /*!< [26..23] BLEBUCK ZERO LENGTH DETECT TRIM                                  */
      __IOM uint32_t ZEROLENDETECTEN : 1;       /*!< [27..27] BLEBUCK ZERO LENGTH DETECT ENABLE                                */
    } BLEBUCKTONADJ_b;
  } ;
  __IM  uint32_t  RESERVED2[48];

  union {
    __IOM uint32_t INTRPTEN;                    /*!< (@ 0x00000100) CLKGEN Interrupt Register: Enable                          */

    struct {
      __IOM uint32_t ACF        : 1;            /*!< [0..0] Autocalibration Fail interrupt                                     */
      __IOM uint32_t ACC        : 1;            /*!< [1..1] Autocalibration Complete interrupt                                 */
      __IOM uint32_t OF         : 1;            /*!< [2..2] XT Oscillator Fail interrupt                                       */
    } INTRPTEN_b;
  } ;

  union {
    __IOM uint32_t INTRPTSTAT;                  /*!< (@ 0x00000104) CLKGEN Interrupt Register: Status                          */

    struct {
      __IOM uint32_t ACF        : 1;            /*!< [0..0] Autocalibration Fail interrupt                                     */
      __IOM uint32_t ACC        : 1;            /*!< [1..1] Autocalibration Complete interrupt                                 */
      __IOM uint32_t OF         : 1;            /*!< [2..2] XT Oscillator Fail interrupt                                       */
    } INTRPTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTRPTCLR;                   /*!< (@ 0x00000108) CLKGEN Interrupt Register: Clear                           */

    struct {
      __IOM uint32_t ACF        : 1;            /*!< [0..0] Autocalibration Fail interrupt                                     */
      __IOM uint32_t ACC        : 1;            /*!< [1..1] Autocalibration Complete interrupt                                 */
      __IOM uint32_t OF         : 1;            /*!< [2..2] XT Oscillator Fail interrupt                                       */
    } INTRPTCLR_b;
  } ;

  union {
    __IOM uint32_t INTRPTSET;                   /*!< (@ 0x0000010C) CLKGEN Interrupt Register: Set                             */

    struct {
      __IOM uint32_t ACF        : 1;            /*!< [0..0] Autocalibration Fail interrupt                                     */
      __IOM uint32_t ACC        : 1;            /*!< [1..1] Autocalibration Complete interrupt                                 */
      __IOM uint32_t OF         : 1;            /*!< [2..2] XT Oscillator Fail interrupt                                       */
    } INTRPTSET_b;
  } ;
} CLKGEN_Type;                                  /*!< Size = 272 (0x110)                                                        */



/* =========================================================================================================================== */
/* ================                                          CTIMER                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Counter/Timer (CTIMER)
  */

typedef struct {                                /*!< (@ 0x40008000) CTIMER Structure                                           */

  union {
    __IOM uint32_t TMR0;                        /*!< (@ 0x00000000) Counter/Timer Register                                     */

    struct {
      __IOM uint32_t CTTMRA0    : 16;           /*!< [15..0] Counter/Timer A0.                                                 */
      __IOM uint32_t CTTMRB0    : 16;           /*!< [31..16] Counter/Timer B0.                                                */
    } TMR0_b;
  } ;

  union {
    __IOM uint32_t CMPRA0;                      /*!< (@ 0x00000004) Counter/Timer A0 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0A0    : 16;           /*!< [15..0] Counter/Timer A0 Compare Register 0. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR1A0    : 16;           /*!< [31..16] Counter/Timer A0 Compare Register 1. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRA0_b;
  } ;

  union {
    __IOM uint32_t CMPRB0;                      /*!< (@ 0x00000008) Counter/Timer B0 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0B0    : 16;           /*!< [15..0] Counter/Timer B0 Compare Register 0. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR1B0    : 16;           /*!< [31..16] Counter/Timer B0 Compare Register 1. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRB0_b;
  } ;

  union {
    __IOM uint32_t CTRL0;                       /*!< (@ 0x0000000C) Counter/Timer Control                                      */

    struct {
      __IOM uint32_t TMRA0EN    : 1;            /*!< [0..0] Counter/Timer A0 Enable bit.                                       */
      __IOM uint32_t TMRA0CLK   : 5;            /*!< [5..1] Counter/Timer A0 Clock Select.                                     */
      __IOM uint32_t TMRA0FN    : 3;            /*!< [8..6] Counter/Timer A0 Function Select.                                  */
      __IOM uint32_t TMRA0IE0   : 1;            /*!< [9..9] Counter/Timer A0 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA0IE1   : 1;            /*!< [10..10] Counter/Timer A0 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA0CLR   : 1;            /*!< [11..11] Counter/Timer A0 Clear bit.                                      */
      __IOM uint32_t TMRA0POL   : 1;            /*!< [12..12] Counter/Timer A0 output polarity.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t TMRB0EN    : 1;            /*!< [16..16] Counter/Timer B0 Enable bit.                                     */
      __IOM uint32_t TMRB0CLK   : 5;            /*!< [21..17] Counter/Timer B0 Clock Select.                                   */
      __IOM uint32_t TMRB0FN    : 3;            /*!< [24..22] Counter/Timer B0 Function Select.                                */
      __IOM uint32_t TMRB0IE0   : 1;            /*!< [25..25] Counter/Timer B0 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB0IE1   : 1;            /*!< [26..26] Counter/Timer B0 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB0CLR   : 1;            /*!< [27..27] Counter/Timer B0 Clear bit.                                      */
      __IOM uint32_t TMRB0POL   : 1;            /*!< [28..28] Counter/Timer B0 output polarity.                                */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTLINK0    : 1;            /*!< [31..31] Counter/Timer A0/B0 Link bit.                                    */
    } CTRL0_b;
  } ;
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t CMPRAUXA0;                   /*!< (@ 0x00000014) Counter/Timer A0 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR2A0    : 16;           /*!< [15..0] Counter/Timer A0 Compare Register 2. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR3A0    : 16;           /*!< [31..16] Counter/Timer A0 Compare Register 3. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRAUXA0_b;
  } ;

  union {
    __IOM uint32_t CMPRAUXB0;                   /*!< (@ 0x00000018) Counter/Timer B0 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR2B0    : 16;           /*!< [15..0] Counter/Timer B0 Compare Register 2. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR3B0    : 16;           /*!< [31..16] Counter/Timer B0 Compare Register 3. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRAUXB0_b;
  } ;

  union {
    __IOM uint32_t AUX0;                        /*!< (@ 0x0000001C) Counter/Timer Auxiliary                                    */

    struct {
      __IOM uint32_t TMRA0LMT   : 7;            /*!< [6..0] Counter/Timer A0 Pattern Limit Count.                              */
      __IOM uint32_t TMRA0TRIG  : 4;            /*!< [10..7] Counter/Timer A0 Trigger Select.                                  */
      __IOM uint32_t TMRA0NOSYNC : 1;           /*!< [11..11] Source clock synchronization control.                            */
      __IOM uint32_t TMRA0TINV  : 1;            /*!< [12..12] Counter/Timer A0 Invert on trigger.                              */
      __IOM uint32_t TMRA0POL23 : 1;            /*!< [13..13] Counter/Timer A0 Upper output polarity                           */
      __IOM uint32_t TMRA0EN23  : 1;            /*!< [14..14] Counter/Timer A0 Upper compare enable.                           */
      __IM  uint32_t            : 1;
      __IOM uint32_t TMRB0LMT   : 6;            /*!< [21..16] Counter/Timer B0 Pattern Limit Count.                            */
      __IM  uint32_t            : 1;
      __IOM uint32_t TMRB0TRIG  : 4;            /*!< [26..23] Counter/Timer B0 Trigger Select.                                 */
      __IOM uint32_t TMRB0NOSYNC : 1;           /*!< [27..27] Source clock synchronization control.                            */
      __IOM uint32_t TMRB0TINV  : 1;            /*!< [28..28] Counter/Timer B0 Invert on trigger.                              */
      __IOM uint32_t TMRB0POL23 : 1;            /*!< [29..29] Upper output polarity                                            */
      __IOM uint32_t TMRB0EN23  : 1;            /*!< [30..30] Counter/Timer B0 Upper compare enable.                           */
    } AUX0_b;
  } ;

  union {
    __IOM uint32_t TMR1;                        /*!< (@ 0x00000020) Counter/Timer Register                                     */

    struct {
      __IOM uint32_t CTTMRA1    : 16;           /*!< [15..0] Counter/Timer A1.                                                 */
      __IOM uint32_t CTTMRB1    : 16;           /*!< [31..16] Counter/Timer B1.                                                */
    } TMR1_b;
  } ;

  union {
    __IOM uint32_t CMPRA1;                      /*!< (@ 0x00000024) Counter/Timer A1 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0A1    : 16;           /*!< [15..0] Counter/Timer A1 Compare Register 0.                              */
      __IOM uint32_t CMPR1A1    : 16;           /*!< [31..16] Counter/Timer A1 Compare Register 1.                             */
    } CMPRA1_b;
  } ;

  union {
    __IOM uint32_t CMPRB1;                      /*!< (@ 0x00000028) Counter/Timer B1 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0B1    : 16;           /*!< [15..0] Counter/Timer B1 Compare Register 0.                              */
      __IOM uint32_t CMPR1B1    : 16;           /*!< [31..16] Counter/Timer B1 Compare Register 1.                             */
    } CMPRB1_b;
  } ;

  union {
    __IOM uint32_t CTRL1;                       /*!< (@ 0x0000002C) Counter/Timer Control                                      */

    struct {
      __IOM uint32_t TMRA1EN    : 1;            /*!< [0..0] Counter/Timer A1 Enable bit.                                       */
      __IOM uint32_t TMRA1CLK   : 5;            /*!< [5..1] Counter/Timer A1 Clock Select.                                     */
      __IOM uint32_t TMRA1FN    : 3;            /*!< [8..6] Counter/Timer A1 Function Select.                                  */
      __IOM uint32_t TMRA1IE0   : 1;            /*!< [9..9] Counter/Timer A1 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA1IE1   : 1;            /*!< [10..10] Counter/Timer A1 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA1CLR   : 1;            /*!< [11..11] Counter/Timer A1 Clear bit.                                      */
      __IOM uint32_t TMRA1POL   : 1;            /*!< [12..12] Counter/Timer A1 output polarity.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t TMRB1EN    : 1;            /*!< [16..16] Counter/Timer B1 Enable bit.                                     */
      __IOM uint32_t TMRB1CLK   : 5;            /*!< [21..17] Counter/Timer B1 Clock Select.                                   */
      __IOM uint32_t TMRB1FN    : 3;            /*!< [24..22] Counter/Timer B1 Function Select.                                */
      __IOM uint32_t TMRB1IE0   : 1;            /*!< [25..25] Counter/Timer B1 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB1IE1   : 1;            /*!< [26..26] Counter/Timer B1 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB1CLR   : 1;            /*!< [27..27] Counter/Timer B1 Clear bit.                                      */
      __IOM uint32_t TMRB1POL   : 1;            /*!< [28..28] Counter/Timer B1 output polarity.                                */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTLINK1    : 1;            /*!< [31..31] Counter/Timer A1/B1 Link bit.                                    */
    } CTRL1_b;
  } ;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t CMPRAUXA1;                   /*!< (@ 0x00000034) Counter/Timer A1 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR2A1    : 16;           /*!< [15..0] Counter/Timer A1 Compare Register 2. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR3A1    : 16;           /*!< [31..16] Counter/Timer A1 Compare Register 3. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRAUXA1_b;
  } ;

  union {
    __IOM uint32_t CMPRAUXB1;                   /*!< (@ 0x00000038) Counter/Timer B1 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR2B1    : 16;           /*!< [15..0] Counter/Timer B1 Compare Register 2. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR3B1    : 16;           /*!< [31..16] Counter/Timer B1 Compare Register 3. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRAUXB1_b;
  } ;

  union {
    __IOM uint32_t AUX1;                        /*!< (@ 0x0000003C) Counter/Timer Auxiliary                                    */

    struct {
      __IOM uint32_t TMRA1LMT   : 7;            /*!< [6..0] Counter/Timer A1 Pattern Limit Count.                              */
      __IOM uint32_t TMRA1TRIG  : 4;            /*!< [10..7] Counter/Timer A1 Trigger Select.                                  */
      __IOM uint32_t TMRA1NOSYNC : 1;           /*!< [11..11] Source clock synchronization control.                            */
      __IOM uint32_t TMRA1TINV  : 1;            /*!< [12..12] Counter/Timer A1 Invert on trigger.                              */
      __IOM uint32_t TMRA1POL23 : 1;            /*!< [13..13] Counter/Timer A1 Upper output polarity                           */
      __IOM uint32_t TMRA1EN23  : 1;            /*!< [14..14] Counter/Timer A1 Upper compare enable.                           */
      __IM  uint32_t            : 1;
      __IOM uint32_t TMRB1LMT   : 6;            /*!< [21..16] Counter/Timer B1 Pattern Limit Count.                            */
      __IM  uint32_t            : 1;
      __IOM uint32_t TMRB1TRIG  : 4;            /*!< [26..23] Counter/Timer B1 Trigger Select.                                 */
      __IOM uint32_t TMRB1NOSYNC : 1;           /*!< [27..27] Source clock synchronization control.                            */
      __IOM uint32_t TMRB1TINV  : 1;            /*!< [28..28] Counter/Timer B1 Invert on trigger.                              */
      __IOM uint32_t TMRB1POL23 : 1;            /*!< [29..29] Upper output polarity                                            */
      __IOM uint32_t TMRB1EN23  : 1;            /*!< [30..30] Counter/Timer B1 Upper compare enable.                           */
    } AUX1_b;
  } ;

  union {
    __IOM uint32_t TMR2;                        /*!< (@ 0x00000040) Counter/Timer Register                                     */

    struct {
      __IOM uint32_t CTTMRA2    : 16;           /*!< [15..0] Counter/Timer A2.                                                 */
      __IOM uint32_t CTTMRB2    : 16;           /*!< [31..16] Counter/Timer B2.                                                */
    } TMR2_b;
  } ;

  union {
    __IOM uint32_t CMPRA2;                      /*!< (@ 0x00000044) Counter/Timer A2 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0A2    : 16;           /*!< [15..0] Counter/Timer A2 Compare Register 0.                              */
      __IOM uint32_t CMPR1A2    : 16;           /*!< [31..16] Counter/Timer A2 Compare Register 1.                             */
    } CMPRA2_b;
  } ;

  union {
    __IOM uint32_t CMPRB2;                      /*!< (@ 0x00000048) Counter/Timer B2 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0B2    : 16;           /*!< [15..0] Counter/Timer B2 Compare Register 0.                              */
      __IOM uint32_t CMPR1B2    : 16;           /*!< [31..16] Counter/Timer B2 Compare Register 1.                             */
    } CMPRB2_b;
  } ;

  union {
    __IOM uint32_t CTRL2;                       /*!< (@ 0x0000004C) Counter/Timer Control                                      */

    struct {
      __IOM uint32_t TMRA2EN    : 1;            /*!< [0..0] Counter/Timer A2 Enable bit.                                       */
      __IOM uint32_t TMRA2CLK   : 5;            /*!< [5..1] Counter/Timer A2 Clock Select.                                     */
      __IOM uint32_t TMRA2FN    : 3;            /*!< [8..6] Counter/Timer A2 Function Select.                                  */
      __IOM uint32_t TMRA2IE0   : 1;            /*!< [9..9] Counter/Timer A2 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA2IE1   : 1;            /*!< [10..10] Counter/Timer A2 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA2CLR   : 1;            /*!< [11..11] Counter/Timer A2 Clear bit.                                      */
      __IOM uint32_t TMRA2POL   : 1;            /*!< [12..12] Counter/Timer A2 output polarity.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t TMRB2EN    : 1;            /*!< [16..16] Counter/Timer B2 Enable bit.                                     */
      __IOM uint32_t TMRB2CLK   : 5;            /*!< [21..17] Counter/Timer B2 Clock Select.                                   */
      __IOM uint32_t TMRB2FN    : 3;            /*!< [24..22] Counter/Timer B2 Function Select.                                */
      __IOM uint32_t TMRB2IE0   : 1;            /*!< [25..25] Counter/Timer B2 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB2IE1   : 1;            /*!< [26..26] Counter/Timer B2 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB2CLR   : 1;            /*!< [27..27] Counter/Timer B2 Clear bit.                                      */
      __IOM uint32_t TMRB2POL   : 1;            /*!< [28..28] Counter/Timer B2 output polarity.                                */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTLINK2    : 1;            /*!< [31..31] Counter/Timer A2/B2 Link bit.                                    */
    } CTRL2_b;
  } ;
  __IM  uint32_t  RESERVED2;

  union {
    __IOM uint32_t CMPRAUXA2;                   /*!< (@ 0x00000054) Counter/Timer A2 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR2A2    : 16;           /*!< [15..0] Counter/Timer A2 Compare Register 2. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR3A2    : 16;           /*!< [31..16] Counter/Timer A2 Compare Register 3. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRAUXA2_b;
  } ;

  union {
    __IOM uint32_t CMPRAUXB2;                   /*!< (@ 0x00000058) Counter/Timer B2 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR2B2    : 16;           /*!< [15..0] Counter/Timer B2 Compare Register 2. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR3B2    : 16;           /*!< [31..16] Counter/Timer B2 Compare Register 3. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRAUXB2_b;
  } ;

  union {
    __IOM uint32_t AUX2;                        /*!< (@ 0x0000005C) Counter/Timer Auxiliary                                    */

    struct {
      __IOM uint32_t TMRA2LMT   : 7;            /*!< [6..0] Counter/Timer A2 Pattern Limit Count.                              */
      __IOM uint32_t TMRA2TRIG  : 4;            /*!< [10..7] Counter/Timer A2 Trigger Select.                                  */
      __IOM uint32_t TMRA2NOSYNC : 1;           /*!< [11..11] Source clock synchronization control.                            */
      __IOM uint32_t TMRA2TINV  : 1;            /*!< [12..12] Counter/Timer A2 Invert on trigger.                              */
      __IOM uint32_t TMRA2POL23 : 1;            /*!< [13..13] Counter/Timer A2 Upper output polarity                           */
      __IOM uint32_t TMRA2EN23  : 1;            /*!< [14..14] Counter/Timer A2 Upper compare enable.                           */
      __IM  uint32_t            : 1;
      __IOM uint32_t TMRB2LMT   : 6;            /*!< [21..16] Counter/Timer B2 Pattern Limit Count.                            */
      __IM  uint32_t            : 1;
      __IOM uint32_t TMRB2TRIG  : 4;            /*!< [26..23] Counter/Timer B2 Trigger Select.                                 */
      __IOM uint32_t TMRB2NOSYNC : 1;           /*!< [27..27] Source clock synchronization control.                            */
      __IOM uint32_t TMRB2TINV  : 1;            /*!< [28..28] Counter/Timer B2 Invert on trigger.                              */
      __IOM uint32_t TMRB2POL23 : 1;            /*!< [29..29] Upper output polarity                                            */
      __IOM uint32_t TMRB2EN23  : 1;            /*!< [30..30] Counter/Timer B2 Upper compare enable.                           */
    } AUX2_b;
  } ;

  union {
    __IOM uint32_t TMR3;                        /*!< (@ 0x00000060) Counter/Timer Register                                     */

    struct {
      __IOM uint32_t CTTMRA3    : 16;           /*!< [15..0] Counter/Timer A3.                                                 */
      __IOM uint32_t CTTMRB3    : 16;           /*!< [31..16] Counter/Timer B3.                                                */
    } TMR3_b;
  } ;

  union {
    __IOM uint32_t CMPRA3;                      /*!< (@ 0x00000064) Counter/Timer A3 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0A3    : 16;           /*!< [15..0] Counter/Timer A3 Compare Register 0.                              */
      __IOM uint32_t CMPR1A3    : 16;           /*!< [31..16] Counter/Timer A3 Compare Register 1.                             */
    } CMPRA3_b;
  } ;

  union {
    __IOM uint32_t CMPRB3;                      /*!< (@ 0x00000068) Counter/Timer B3 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0B3    : 16;           /*!< [15..0] Counter/Timer B3 Compare Register 0.                              */
      __IOM uint32_t CMPR1B3    : 16;           /*!< [31..16] Counter/Timer B3 Compare Register 1.                             */
    } CMPRB3_b;
  } ;

  union {
    __IOM uint32_t CTRL3;                       /*!< (@ 0x0000006C) Counter/Timer Control                                      */

    struct {
      __IOM uint32_t TMRA3EN    : 1;            /*!< [0..0] Counter/Timer A3 Enable bit.                                       */
      __IOM uint32_t TMRA3CLK   : 5;            /*!< [5..1] Counter/Timer A3 Clock Select.                                     */
      __IOM uint32_t TMRA3FN    : 3;            /*!< [8..6] Counter/Timer A3 Function Select.                                  */
      __IOM uint32_t TMRA3IE0   : 1;            /*!< [9..9] Counter/Timer A3 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA3IE1   : 1;            /*!< [10..10] Counter/Timer A3 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA3CLR   : 1;            /*!< [11..11] Counter/Timer A3 Clear bit.                                      */
      __IOM uint32_t TMRA3POL   : 1;            /*!< [12..12] Counter/Timer A3 output polarity.                                */
      __IM  uint32_t            : 2;
      __IOM uint32_t ADCEN      : 1;            /*!< [15..15] Special Timer A3 enable for ADC function.                        */
      __IOM uint32_t TMRB3EN    : 1;            /*!< [16..16] Counter/Timer B3 Enable bit.                                     */
      __IOM uint32_t TMRB3CLK   : 5;            /*!< [21..17] Counter/Timer B3 Clock Select.                                   */
      __IOM uint32_t TMRB3FN    : 3;            /*!< [24..22] Counter/Timer B3 Function Select.                                */
      __IOM uint32_t TMRB3IE0   : 1;            /*!< [25..25] Counter/Timer B3 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB3IE1   : 1;            /*!< [26..26] Counter/Timer B3 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB3CLR   : 1;            /*!< [27..27] Counter/Timer B3 Clear bit.                                      */
      __IOM uint32_t TMRB3POL   : 1;            /*!< [28..28] Counter/Timer B3 output polarity.                                */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTLINK3    : 1;            /*!< [31..31] Counter/Timer A3/B3 Link bit.                                    */
    } CTRL3_b;
  } ;
  __IM  uint32_t  RESERVED3;

  union {
    __IOM uint32_t CMPRAUXA3;                   /*!< (@ 0x00000074) Counter/Timer A3 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR2A3    : 16;           /*!< [15..0] Counter/Timer A3 Compare Register 2. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR3A3    : 16;           /*!< [31..16] Counter/Timer A3 Compare Register 3. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRAUXA3_b;
  } ;

  union {
    __IOM uint32_t CMPRAUXB3;                   /*!< (@ 0x00000078) Counter/Timer B3 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR2B3    : 16;           /*!< [15..0] Counter/Timer B3 Compare Register 2. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR3B3    : 16;           /*!< [31..16] Counter/Timer B3 Compare Register 3. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRAUXB3_b;
  } ;

  union {
    __IOM uint32_t AUX3;                        /*!< (@ 0x0000007C) Counter/Timer Auxiliary                                    */

    struct {
      __IOM uint32_t TMRA3LMT   : 7;            /*!< [6..0] Counter/Timer A3 Pattern Limit Count.                              */
      __IOM uint32_t TMRA3TRIG  : 4;            /*!< [10..7] Counter/Timer A3 Trigger Select.                                  */
      __IOM uint32_t TMRA3NOSYNC : 1;           /*!< [11..11] Source clock synchronization control.                            */
      __IOM uint32_t TMRA3TINV  : 1;            /*!< [12..12] Counter/Timer A3 Invert on trigger.                              */
      __IOM uint32_t TMRA3POL23 : 1;            /*!< [13..13] Counter/Timer A3 Upper output polarity                           */
      __IOM uint32_t TMRA3EN23  : 1;            /*!< [14..14] Counter/Timer A3 Upper compare enable.                           */
      __IM  uint32_t            : 1;
      __IOM uint32_t TMRB3LMT   : 6;            /*!< [21..16] Counter/Timer B3 Pattern Limit Count.                            */
      __IM  uint32_t            : 1;
      __IOM uint32_t TMRB3TRIG  : 4;            /*!< [26..23] Counter/Timer B3 Trigger Select.                                 */
      __IOM uint32_t TMRB3NOSYNC : 1;           /*!< [27..27] Source clock synchronization control.                            */
      __IOM uint32_t TMRB3TINV  : 1;            /*!< [28..28] Counter/Timer B3 Invert on trigger.                              */
      __IOM uint32_t TMRB3POL23 : 1;            /*!< [29..29] Upper output polarity                                            */
      __IOM uint32_t TMRB3EN23  : 1;            /*!< [30..30] Counter/Timer B3 Upper compare enable.                           */
    } AUX3_b;
  } ;

  union {
    __IOM uint32_t TMR4;                        /*!< (@ 0x00000080) Counter/Timer Register                                     */

    struct {
      __IOM uint32_t CTTMRA4    : 16;           /*!< [15..0] Counter/Timer A4.                                                 */
      __IOM uint32_t CTTMRB4    : 16;           /*!< [31..16] Counter/Timer B4.                                                */
    } TMR4_b;
  } ;

  union {
    __IOM uint32_t CMPRA4;                      /*!< (@ 0x00000084) Counter/Timer A4 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0A4    : 16;           /*!< [15..0] Counter/Timer A4 Compare Register 0. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR1A4    : 16;           /*!< [31..16] Counter/Timer A4 Compare Register 1. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRA4_b;
  } ;

  union {
    __IOM uint32_t CMPRB4;                      /*!< (@ 0x00000088) Counter/Timer B4 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0B4    : 16;           /*!< [15..0] Counter/Timer B4 Compare Register 0. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR1B4    : 16;           /*!< [31..16] Counter/Timer B4 Compare Register 1. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRB4_b;
  } ;

  union {
    __IOM uint32_t CTRL4;                       /*!< (@ 0x0000008C) Counter/Timer Control                                      */

    struct {
      __IOM uint32_t TMRA4EN    : 1;            /*!< [0..0] Counter/Timer A4 Enable bit.                                       */
      __IOM uint32_t TMRA4CLK   : 5;            /*!< [5..1] Counter/Timer A4 Clock Select.                                     */
      __IOM uint32_t TMRA4FN    : 3;            /*!< [8..6] Counter/Timer A4 Function Select.                                  */
      __IOM uint32_t TMRA4IE0   : 1;            /*!< [9..9] Counter/Timer A4 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA4IE1   : 1;            /*!< [10..10] Counter/Timer A4 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA4CLR   : 1;            /*!< [11..11] Counter/Timer A4 Clear bit.                                      */
      __IOM uint32_t TMRA4POL   : 1;            /*!< [12..12] Counter/Timer A4 output polarity.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t TMRB4EN    : 1;            /*!< [16..16] Counter/Timer B4 Enable bit.                                     */
      __IOM uint32_t TMRB4CLK   : 5;            /*!< [21..17] Counter/Timer B4 Clock Select.                                   */
      __IOM uint32_t TMRB4FN    : 3;            /*!< [24..22] Counter/Timer B4 Function Select.                                */
      __IOM uint32_t TMRB4IE0   : 1;            /*!< [25..25] Counter/Timer B4 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB4IE1   : 1;            /*!< [26..26] Counter/Timer B4 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB4CLR   : 1;            /*!< [27..27] Counter/Timer B4 Clear bit.                                      */
      __IOM uint32_t TMRB4POL   : 1;            /*!< [28..28] Counter/Timer B4 output polarity.                                */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTLINK4    : 1;            /*!< [31..31] Counter/Timer A4/B4 Link bit.                                    */
    } CTRL4_b;
  } ;
  __IM  uint32_t  RESERVED4;

  union {
    __IOM uint32_t CMPRAUXA4;                   /*!< (@ 0x00000094) Counter/Timer A4 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR2A4    : 16;           /*!< [15..0] Counter/Timer A4 Compare Register 2. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR3A4    : 16;           /*!< [31..16] Counter/Timer A4 Compare Register 3. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRAUXA4_b;
  } ;

  union {
    __IOM uint32_t CMPRAUXB4;                   /*!< (@ 0x00000098) Counter/Timer B4 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR2B4    : 16;           /*!< [15..0] Counter/Timer B4 Compare Register 2. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR3B4    : 16;           /*!< [31..16] Counter/Timer B4 Compare Register 3. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRAUXB4_b;
  } ;

  union {
    __IOM uint32_t AUX4;                        /*!< (@ 0x0000009C) Counter/Timer Auxiliary                                    */

    struct {
      __IOM uint32_t TMRA4LMT   : 7;            /*!< [6..0] Counter/Timer A4 Pattern Limit Count.                              */
      __IOM uint32_t TMRA4TRIG  : 4;            /*!< [10..7] Counter/Timer A4 Trigger Select.                                  */
      __IOM uint32_t TMRA4NOSYNC : 1;           /*!< [11..11] Source clock synchronization control.                            */
      __IOM uint32_t TMRA4TINV  : 1;            /*!< [12..12] Counter/Timer A4 Invert on trigger.                              */
      __IOM uint32_t TMRA4POL23 : 1;            /*!< [13..13] Counter/Timer A4 Upper output polarity                           */
      __IOM uint32_t TMRA4EN23  : 1;            /*!< [14..14] Counter/Timer A4 Upper compare enable.                           */
      __IM  uint32_t            : 1;
      __IOM uint32_t TMRB4LMT   : 6;            /*!< [21..16] Counter/Timer B4 Pattern Limit Count.                            */
      __IM  uint32_t            : 1;
      __IOM uint32_t TMRB4TRIG  : 4;            /*!< [26..23] Counter/Timer B4 Trigger Select.                                 */
      __IOM uint32_t TMRB4NOSYNC : 1;           /*!< [27..27] Source clock synchronization control.                            */
      __IOM uint32_t TMRB4TINV  : 1;            /*!< [28..28] Counter/Timer B4 Invert on trigger.                              */
      __IOM uint32_t TMRB4POL23 : 1;            /*!< [29..29] Upper output polarity                                            */
      __IOM uint32_t TMRB4EN23  : 1;            /*!< [30..30] Counter/Timer B4 Upper compare enable.                           */
    } AUX4_b;
  } ;

  union {
    __IOM uint32_t TMR5;                        /*!< (@ 0x000000A0) Counter/Timer Register                                     */

    struct {
      __IOM uint32_t CTTMRA5    : 16;           /*!< [15..0] Counter/Timer A5.                                                 */
      __IOM uint32_t CTTMRB5    : 16;           /*!< [31..16] Counter/Timer B5.                                                */
    } TMR5_b;
  } ;

  union {
    __IOM uint32_t CMPRA5;                      /*!< (@ 0x000000A4) Counter/Timer A5 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0A5    : 16;           /*!< [15..0] Counter/Timer A5 Compare Register 0.                              */
      __IOM uint32_t CMPR1A5    : 16;           /*!< [31..16] Counter/Timer A5 Compare Register 1.                             */
    } CMPRA5_b;
  } ;

  union {
    __IOM uint32_t CMPRB5;                      /*!< (@ 0x000000A8) Counter/Timer B5 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0B5    : 16;           /*!< [15..0] Counter/Timer B5 Compare Register 0.                              */
      __IOM uint32_t CMPR1B5    : 16;           /*!< [31..16] Counter/Timer B5 Compare Register 1.                             */
    } CMPRB5_b;
  } ;

  union {
    __IOM uint32_t CTRL5;                       /*!< (@ 0x000000AC) Counter/Timer Control                                      */

    struct {
      __IOM uint32_t TMRA5EN    : 1;            /*!< [0..0] Counter/Timer A5 Enable bit.                                       */
      __IOM uint32_t TMRA5CLK   : 5;            /*!< [5..1] Counter/Timer A5 Clock Select.                                     */
      __IOM uint32_t TMRA5FN    : 3;            /*!< [8..6] Counter/Timer A5 Function Select.                                  */
      __IOM uint32_t TMRA5IE0   : 1;            /*!< [9..9] Counter/Timer A5 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA5IE1   : 1;            /*!< [10..10] Counter/Timer A5 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA5CLR   : 1;            /*!< [11..11] Counter/Timer A5 Clear bit.                                      */
      __IOM uint32_t TMRA5POL   : 1;            /*!< [12..12] Counter/Timer A5 output polarity.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t TMRB5EN    : 1;            /*!< [16..16] Counter/Timer B5 Enable bit.                                     */
      __IOM uint32_t TMRB5CLK   : 5;            /*!< [21..17] Counter/Timer B5 Clock Select.                                   */
      __IOM uint32_t TMRB5FN    : 3;            /*!< [24..22] Counter/Timer B5 Function Select.                                */
      __IOM uint32_t TMRB5IE0   : 1;            /*!< [25..25] Counter/Timer B5 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB5IE1   : 1;            /*!< [26..26] Counter/Timer B5 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB5CLR   : 1;            /*!< [27..27] Counter/Timer B5 Clear bit.                                      */
      __IOM uint32_t TMRB5POL   : 1;            /*!< [28..28] Counter/Timer B5 output polarity.                                */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTLINK5    : 1;            /*!< [31..31] Counter/Timer A5/B5 Link bit.                                    */
    } CTRL5_b;
  } ;
  __IM  uint32_t  RESERVED5;

  union {
    __IOM uint32_t CMPRAUXA5;                   /*!< (@ 0x000000B4) Counter/Timer A5 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR2A5    : 16;           /*!< [15..0] Counter/Timer A5 Compare Register 2. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR3A5    : 16;           /*!< [31..16] Counter/Timer A5 Compare Register 3. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRAUXA5_b;
  } ;

  union {
    __IOM uint32_t CMPRAUXB5;                   /*!< (@ 0x000000B8) Counter/Timer B5 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR2B5    : 16;           /*!< [15..0] Counter/Timer B5 Compare Register 2. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR3B5    : 16;           /*!< [31..16] Counter/Timer B5 Compare Register 3. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRAUXB5_b;
  } ;

  union {
    __IOM uint32_t AUX5;                        /*!< (@ 0x000000BC) Counter/Timer Auxiliary                                    */

    struct {
      __IOM uint32_t TMRA5LMT   : 7;            /*!< [6..0] Counter/Timer A5 Pattern Limit Count.                              */
      __IOM uint32_t TMRA5TRIG  : 4;            /*!< [10..7] Counter/Timer A5 Trigger Select.                                  */
      __IOM uint32_t TMRA5NOSYNC : 1;           /*!< [11..11] Source clock synchronization control.                            */
      __IOM uint32_t TMRA5TINV  : 1;            /*!< [12..12] Counter/Timer A5 Invert on trigger.                              */
      __IOM uint32_t TMRA5POL23 : 1;            /*!< [13..13] Counter/Timer A5 Upper output polarity                           */
      __IOM uint32_t TMRA5EN23  : 1;            /*!< [14..14] Counter/Timer A5 Upper compare enable.                           */
      __IM  uint32_t            : 1;
      __IOM uint32_t TMRB5LMT   : 6;            /*!< [21..16] Counter/Timer B5 Pattern Limit Count.                            */
      __IM  uint32_t            : 1;
      __IOM uint32_t TMRB5TRIG  : 4;            /*!< [26..23] Counter/Timer B5 Trigger Select.                                 */
      __IOM uint32_t TMRB5NOSYNC : 1;           /*!< [27..27] Source clock synchronization control.                            */
      __IOM uint32_t TMRB5TINV  : 1;            /*!< [28..28] Counter/Timer B5 Invert on trigger.                              */
      __IOM uint32_t TMRB5POL23 : 1;            /*!< [29..29] Upper output polarity                                            */
      __IOM uint32_t TMRB5EN23  : 1;            /*!< [30..30] Counter/Timer B5 Upper compare enable.                           */
    } AUX5_b;
  } ;

  union {
    __IOM uint32_t TMR6;                        /*!< (@ 0x000000C0) Counter/Timer Register                                     */

    struct {
      __IOM uint32_t CTTMRA6    : 16;           /*!< [15..0] Counter/Timer A6.                                                 */
      __IOM uint32_t CTTMRB6    : 16;           /*!< [31..16] Counter/Timer B6.                                                */
    } TMR6_b;
  } ;

  union {
    __IOM uint32_t CMPRA6;                      /*!< (@ 0x000000C4) Counter/Timer A6 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0A6    : 16;           /*!< [15..0] Counter/Timer A6 Compare Register 0.                              */
      __IOM uint32_t CMPR1A6    : 16;           /*!< [31..16] Counter/Timer A6 Compare Register 1.                             */
    } CMPRA6_b;
  } ;

  union {
    __IOM uint32_t CMPRB6;                      /*!< (@ 0x000000C8) Counter/Timer B6 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0B6    : 16;           /*!< [15..0] Counter/Timer B6 Compare Register 0.                              */
      __IOM uint32_t CMPR1B6    : 16;           /*!< [31..16] Counter/Timer B6 Compare Register 1.                             */
    } CMPRB6_b;
  } ;

  union {
    __IOM uint32_t CTRL6;                       /*!< (@ 0x000000CC) Counter/Timer Control                                      */

    struct {
      __IOM uint32_t TMRA6EN    : 1;            /*!< [0..0] Counter/Timer A6 Enable bit.                                       */
      __IOM uint32_t TMRA6CLK   : 5;            /*!< [5..1] Counter/Timer A6 Clock Select.                                     */
      __IOM uint32_t TMRA6FN    : 3;            /*!< [8..6] Counter/Timer A6 Function Select.                                  */
      __IOM uint32_t TMRA6IE0   : 1;            /*!< [9..9] Counter/Timer A6 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA6IE1   : 1;            /*!< [10..10] Counter/Timer A6 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA6CLR   : 1;            /*!< [11..11] Counter/Timer A6 Clear bit.                                      */
      __IOM uint32_t TMRA6POL   : 1;            /*!< [12..12] Counter/Timer A6 output polarity.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t TMRB6EN    : 1;            /*!< [16..16] Counter/Timer B6 Enable bit.                                     */
      __IOM uint32_t TMRB6CLK   : 5;            /*!< [21..17] Counter/Timer B6 Clock Select.                                   */
      __IOM uint32_t TMRB6FN    : 3;            /*!< [24..22] Counter/Timer B6 Function Select.                                */
      __IOM uint32_t TMRB6IE0   : 1;            /*!< [25..25] Counter/Timer B6 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB6IE1   : 1;            /*!< [26..26] Counter/Timer B6 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB6CLR   : 1;            /*!< [27..27] Counter/Timer B6 Clear bit.                                      */
      __IOM uint32_t TMRB6POL   : 1;            /*!< [28..28] Counter/Timer B6 output polarity.                                */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTLINK6    : 1;            /*!< [31..31] Counter/Timer A6/B6 Link bit.                                    */
    } CTRL6_b;
  } ;
  __IM  uint32_t  RESERVED6;

  union {
    __IOM uint32_t CMPRAUXA6;                   /*!< (@ 0x000000D4) Counter/Timer A6 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR2A6    : 16;           /*!< [15..0] Counter/Timer A6 Compare Register 2. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR3A6    : 16;           /*!< [31..16] Counter/Timer A6 Compare Register 3. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRAUXA6_b;
  } ;

  union {
    __IOM uint32_t CMPRAUXB6;                   /*!< (@ 0x000000D8) Counter/Timer B6 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR2B6    : 16;           /*!< [15..0] Counter/Timer B6 Compare Register 2. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR3B6    : 16;           /*!< [31..16] Counter/Timer B6 Compare Register 3. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRAUXB6_b;
  } ;

  union {
    __IOM uint32_t AUX6;                        /*!< (@ 0x000000DC) Counter/Timer Auxiliary                                    */

    struct {
      __IOM uint32_t TMRA6LMT   : 7;            /*!< [6..0] Counter/Timer A6 Pattern Limit Count.                              */
      __IOM uint32_t TMRA6TRIG  : 4;            /*!< [10..7] Counter/Timer A6 Trigger Select.                                  */
      __IOM uint32_t TMRA6NOSYNC : 1;           /*!< [11..11] Source clock synchronization control.                            */
      __IOM uint32_t TMRA6TINV  : 1;            /*!< [12..12] Counter/Timer A6 Invert on trigger.                              */
      __IOM uint32_t TMRA6POL23 : 1;            /*!< [13..13] Counter/Timer A6 Upper output polarity                           */
      __IOM uint32_t TMRA6EN23  : 1;            /*!< [14..14] Counter/Timer A6 Upper compare enable.                           */
      __IM  uint32_t            : 1;
      __IOM uint32_t TMRB6LMT   : 6;            /*!< [21..16] Counter/Timer B6 Pattern Limit Count.                            */
      __IM  uint32_t            : 1;
      __IOM uint32_t TMRB6TRIG  : 4;            /*!< [26..23] Counter/Timer B6 Trigger Select.                                 */
      __IOM uint32_t TMRB6NOSYNC : 1;           /*!< [27..27] Source clock synchronization control.                            */
      __IOM uint32_t TMRB6TINV  : 1;            /*!< [28..28] Counter/Timer B6 Invert on trigger.                              */
      __IOM uint32_t TMRB6POL23 : 1;            /*!< [29..29] Upper output polarity                                            */
      __IOM uint32_t TMRB6EN23  : 1;            /*!< [30..30] Counter/Timer B6 Upper compare enable.                           */
    } AUX6_b;
  } ;

  union {
    __IOM uint32_t TMR7;                        /*!< (@ 0x000000E0) Counter/Timer Register                                     */

    struct {
      __IOM uint32_t CTTMRA7    : 16;           /*!< [15..0] Counter/Timer A7.                                                 */
      __IOM uint32_t CTTMRB7    : 16;           /*!< [31..16] Counter/Timer B7.                                                */
    } TMR7_b;
  } ;

  union {
    __IOM uint32_t CMPRA7;                      /*!< (@ 0x000000E4) Counter/Timer A7 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0A7    : 16;           /*!< [15..0] Counter/Timer A7 Compare Register 0.                              */
      __IOM uint32_t CMPR1A7    : 16;           /*!< [31..16] Counter/Timer A7 Compare Register 1.                             */
    } CMPRA7_b;
  } ;

  union {
    __IOM uint32_t CMPRB7;                      /*!< (@ 0x000000E8) Counter/Timer B7 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0B7    : 16;           /*!< [15..0] Counter/Timer B3 Compare Register 0.                              */
      __IOM uint32_t CMPR1B7    : 16;           /*!< [31..16] Counter/Timer B3 Compare Register 1.                             */
    } CMPRB7_b;
  } ;

  union {
    __IOM uint32_t CTRL7;                       /*!< (@ 0x000000EC) Counter/Timer Control                                      */

    struct {
      __IOM uint32_t TMRA7EN    : 1;            /*!< [0..0] Counter/Timer A7 Enable bit.                                       */
      __IOM uint32_t TMRA7CLK   : 5;            /*!< [5..1] Counter/Timer A7 Clock Select.                                     */
      __IOM uint32_t TMRA7FN    : 3;            /*!< [8..6] Counter/Timer A7 Function Select.                                  */
      __IOM uint32_t TMRA7IE0   : 1;            /*!< [9..9] Counter/Timer A7 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA7IE1   : 1;            /*!< [10..10] Counter/Timer A7 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA7CLR   : 1;            /*!< [11..11] Counter/Timer A7 Clear bit.                                      */
      __IOM uint32_t TMRA7POL   : 1;            /*!< [12..12] Counter/Timer A7 output polarity.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t TMRB7EN    : 1;            /*!< [16..16] Counter/Timer B7 Enable bit.                                     */
      __IOM uint32_t TMRB7CLK   : 5;            /*!< [21..17] Counter/Timer B7 Clock Select.                                   */
      __IOM uint32_t TMRB7FN    : 3;            /*!< [24..22] Counter/Timer B7 Function Select.                                */
      __IOM uint32_t TMRB7IE0   : 1;            /*!< [25..25] Counter/Timer B7 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB7IE1   : 1;            /*!< [26..26] Counter/Timer B7 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB7CLR   : 1;            /*!< [27..27] Counter/Timer B7 Clear bit.                                      */
      __IOM uint32_t TMRB7POL   : 1;            /*!< [28..28] Counter/Timer B7 output polarity.                                */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTLINK7    : 1;            /*!< [31..31] Counter/Timer A7/B7 Link bit.                                    */
    } CTRL7_b;
  } ;
  __IM  uint32_t  RESERVED7;

  union {
    __IOM uint32_t CMPRAUXA7;                   /*!< (@ 0x000000F4) Counter/Timer A7 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR2A7    : 16;           /*!< [15..0] Counter/Timer A7 Compare Register 2. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR3A7    : 16;           /*!< [31..16] Counter/Timer A7 Compare Register 3. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRAUXA7_b;
  } ;

  union {
    __IOM uint32_t CMPRAUXB7;                   /*!< (@ 0x000000F8) Counter/Timer B7 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR2B7    : 16;           /*!< [15..0] Counter/Timer B7 Compare Register 2. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR3B7    : 16;           /*!< [31..16] Counter/Timer B7 Compare Register 3. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRAUXB7_b;
  } ;

  union {
    __IOM uint32_t AUX7;                        /*!< (@ 0x000000FC) Counter/Timer Auxiliary                                    */

    struct {
      __IOM uint32_t TMRA7LMT   : 7;            /*!< [6..0] Counter/Timer A7 Pattern Limit Count.                              */
      __IOM uint32_t TMRA7TRIG  : 4;            /*!< [10..7] Counter/Timer A7 Trigger Select.                                  */
      __IOM uint32_t TMRA7NOSYNC : 1;           /*!< [11..11] Source clock synchronization control.                            */
      __IOM uint32_t TMRA7TINV  : 1;            /*!< [12..12] Counter/Timer A7 Invert on trigger.                              */
      __IOM uint32_t TMRA7POL23 : 1;            /*!< [13..13] Counter/Timer A7 Upper output polarity                           */
      __IOM uint32_t TMRA7EN23  : 1;            /*!< [14..14] Counter/Timer A7 Upper compare enable.                           */
      __IM  uint32_t            : 1;
      __IOM uint32_t TMRB7LMT   : 6;            /*!< [21..16] Counter/Timer B7 Pattern Limit Count.                            */
      __IM  uint32_t            : 1;
      __IOM uint32_t TMRB7TRIG  : 4;            /*!< [26..23] Counter/Timer B7 Trigger Select.                                 */
      __IOM uint32_t TMRB7NOSYNC : 1;           /*!< [27..27] Source clock synchronization control.                            */
      __IOM uint32_t TMRB7TINV  : 1;            /*!< [28..28] Counter/Timer B7 Invert on trigger.                              */
      __IOM uint32_t TMRB7POL23 : 1;            /*!< [29..29] Upper output polarity                                            */
      __IOM uint32_t TMRB7EN23  : 1;            /*!< [30..30] Counter/Timer B7 Upper compare enable.                           */
    } AUX7_b;
  } ;

  union {
    __IOM uint32_t GLOBEN;                      /*!< (@ 0x00000100) Counter/Timer Global Enable                                */

    struct {
      __IOM uint32_t ENA0       : 1;            /*!< [0..0] Alternate enable for A0                                            */
      __IOM uint32_t ENB0       : 1;            /*!< [1..1] Alternate enable for B0                                            */
      __IOM uint32_t ENA1       : 1;            /*!< [2..2] Alternate enable for A1                                            */
      __IOM uint32_t ENB1       : 1;            /*!< [3..3] Alternate enable for B1                                            */
      __IOM uint32_t ENA2       : 1;            /*!< [4..4] Alternate enable for A2                                            */
      __IOM uint32_t ENB2       : 1;            /*!< [5..5] Alternate enable for B2                                            */
      __IOM uint32_t ENA3       : 1;            /*!< [6..6] Alternate enable for A3                                            */
      __IOM uint32_t ENB3       : 1;            /*!< [7..7] Alternate enable for B3.                                           */
      __IOM uint32_t ENA4       : 1;            /*!< [8..8] Alternate enable for A4                                            */
      __IOM uint32_t ENB4       : 1;            /*!< [9..9] Alternate enable for B4                                            */
      __IOM uint32_t ENA5       : 1;            /*!< [10..10] Alternate enable for A5                                          */
      __IOM uint32_t ENB5       : 1;            /*!< [11..11] Alternate enable for B5                                          */
      __IOM uint32_t ENA6       : 1;            /*!< [12..12] Alternate enable for A6                                          */
      __IOM uint32_t ENB6       : 1;            /*!< [13..13] Alternate enable for B6                                          */
      __IOM uint32_t ENA7       : 1;            /*!< [14..14] Alternate enable for A7                                          */
      __IOM uint32_t ENB7       : 1;            /*!< [15..15] Alternate enable for B7.                                         */
    } GLOBEN_b;
  } ;

  union {
    __IOM uint32_t OUTCFG0;                     /*!< (@ 0x00000104) Counter/Timer Output Config 0                              */

    struct {
      __IOM uint32_t CFG0       : 3;            /*!< [2..0] Pad output 0 configuration                                         */
      __IOM uint32_t CFG1       : 3;            /*!< [5..3] Pad output 1 configuration                                         */
      __IOM uint32_t CFG2       : 3;            /*!< [8..6] Pad output 2 configuration                                         */
      __IOM uint32_t CFG3       : 3;            /*!< [11..9] Pad output 3 configuration                                        */
      __IOM uint32_t CFG4       : 3;            /*!< [14..12] Pad output 4 configuration                                       */
      __IM  uint32_t            : 1;
      __IOM uint32_t CFG5       : 3;            /*!< [18..16] Pad output 5 configuration                                       */
      __IOM uint32_t CFG6       : 3;            /*!< [21..19] Pad output 6 configuration                                       */
      __IOM uint32_t CFG7       : 3;            /*!< [24..22] Pad output 7 configuration                                       */
      __IOM uint32_t CFG8       : 3;            /*!< [27..25] Pad output 8 configuration                                       */
      __IOM uint32_t CFG9       : 3;            /*!< [30..28] Pad output 9 configuration                                       */
    } OUTCFG0_b;
  } ;

  union {
    __IOM uint32_t OUTCFG1;                     /*!< (@ 0x00000108) Counter/Timer Output Config 1                              */

    struct {
      __IOM uint32_t CFG10      : 3;            /*!< [2..0] Pad output 10 configuration                                        */
      __IOM uint32_t CFG11      : 3;            /*!< [5..3] Pad output 11 configuration                                        */
      __IOM uint32_t CFG12      : 3;            /*!< [8..6] Pad output 12 configuration                                        */
      __IOM uint32_t CFG13      : 3;            /*!< [11..9] Pad output 13 configuration                                       */
      __IOM uint32_t CFG14      : 3;            /*!< [14..12] Pad output 14 configuration                                      */
      __IM  uint32_t            : 1;
      __IOM uint32_t CFG15      : 3;            /*!< [18..16] Pad output 15 configuration                                      */
      __IOM uint32_t CFG16      : 3;            /*!< [21..19] Pad output 16 configuration                                      */
      __IOM uint32_t CFG17      : 3;            /*!< [24..22] Pad output 17 configuration                                      */
      __IOM uint32_t CFG18      : 3;            /*!< [27..25] Pad output 18 configuration                                      */
      __IOM uint32_t CFG19      : 3;            /*!< [30..28] Pad output 19 configuration                                      */
    } OUTCFG1_b;
  } ;

  union {
    __IOM uint32_t OUTCFG2;                     /*!< (@ 0x0000010C) Counter/Timer Output Config 2                              */

    struct {
      __IOM uint32_t CFG20      : 3;            /*!< [2..0] Pad output 20 configuration                                        */
      __IOM uint32_t CFG21      : 3;            /*!< [5..3] Pad output 21 configuration                                        */
      __IOM uint32_t CFG22      : 3;            /*!< [8..6] Pad output 22 configuration                                        */
      __IOM uint32_t CFG23      : 3;            /*!< [11..9] Pad output 23 configuration                                       */
      __IOM uint32_t CFG24      : 3;            /*!< [14..12] Pad output 24 configuration                                      */
      __IM  uint32_t            : 1;
      __IOM uint32_t CFG25      : 3;            /*!< [18..16] Pad output 25 configuration                                      */
      __IOM uint32_t CFG26      : 3;            /*!< [21..19] Pad output 26 configuration                                      */
      __IOM uint32_t CFG27      : 3;            /*!< [24..22] Pad output 27 configuration                                      */
      __IOM uint32_t CFG28      : 3;            /*!< [27..25] Pad output 28 configuration                                      */
      __IOM uint32_t CFG29      : 3;            /*!< [30..28] Pad output 29 configuration                                      */
    } OUTCFG2_b;
  } ;
  __IM  uint32_t  RESERVED8;

  union {
    __IOM uint32_t OUTCFG3;                     /*!< (@ 0x00000114) Counter/Timer Output Config 3                              */

    struct {
      __IOM uint32_t CFG30      : 3;            /*!< [2..0] Pad output 30 configuration                                        */
      __IOM uint32_t CFG31      : 3;            /*!< [5..3] Pad output 31 configuration                                        */
    } OUTCFG3_b;
  } ;

  union {
    __IOM uint32_t INCFG;                       /*!< (@ 0x00000118) Counter/Timer Input Config                                 */

    struct {
      __IOM uint32_t CFGA0      : 1;            /*!< [0..0] CTIMER A0 input configuration                                      */
      __IOM uint32_t CFGB0      : 1;            /*!< [1..1] CTIMER B0 input configuration                                      */
      __IOM uint32_t CFGA1      : 1;            /*!< [2..2] CTIMER A1 input configuration                                      */
      __IOM uint32_t CFGB1      : 1;            /*!< [3..3] CTIMER B1 input configuration                                      */
      __IOM uint32_t CFGA2      : 1;            /*!< [4..4] CTIMER A2 input configuration                                      */
      __IOM uint32_t CFGB2      : 1;            /*!< [5..5] CTIMER B2 input configuration                                      */
      __IOM uint32_t CFGA3      : 1;            /*!< [6..6] CTIMER A3 input configuration                                      */
      __IOM uint32_t CFGB3      : 1;            /*!< [7..7] CTIMER B3 input configuration                                      */
      __IOM uint32_t CFGA4      : 1;            /*!< [8..8] CTIMER A4 input configuration                                      */
      __IOM uint32_t CFGB4      : 1;            /*!< [9..9] CTIMER B4 input configuration                                      */
      __IOM uint32_t CFGA5      : 1;            /*!< [10..10] CTIMER A5 input configuration                                    */
      __IOM uint32_t CFGB5      : 1;            /*!< [11..11] CTIMER B5 input configuration                                    */
      __IOM uint32_t CFGA6      : 1;            /*!< [12..12] CTIMER A6 input configuration                                    */
      __IOM uint32_t CFGB6      : 1;            /*!< [13..13] CTIMER B6 input configuration                                    */
      __IOM uint32_t CFGA7      : 1;            /*!< [14..14] CTIMER A7 input configuration                                    */
      __IOM uint32_t CFGB7      : 1;            /*!< [15..15] CTIMER B7 input configuration                                    */
    } INCFG_b;
  } ;
  __IM  uint32_t  RESERVED9[9];

  union {
    __IOM uint32_t STCFG;                       /*!< (@ 0x00000140) Configuration Register                                     */

    struct {
      __IOM uint32_t CLKSEL     : 4;            /*!< [3..0] Selects an appropriate clock source and divider to use
                                                     for the System Timer clock.                                               */
      __IM  uint32_t            : 4;
      __IOM uint32_t COMPARE_A_EN : 1;          /*!< [8..8] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparision is met.                                       */
      __IOM uint32_t COMPARE_B_EN : 1;          /*!< [9..9] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparision is met.                                       */
      __IOM uint32_t COMPARE_C_EN : 1;          /*!< [10..10] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparision is met.                                       */
      __IOM uint32_t COMPARE_D_EN : 1;          /*!< [11..11] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparision is met.                                       */
      __IOM uint32_t COMPARE_E_EN : 1;          /*!< [12..12] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparision is met.                                       */
      __IOM uint32_t COMPARE_F_EN : 1;          /*!< [13..13] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparision is met.                                       */
      __IOM uint32_t COMPARE_G_EN : 1;          /*!< [14..14] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparision is met.                                       */
      __IOM uint32_t COMPARE_H_EN : 1;          /*!< [15..15] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparision is met.                                       */
      __IM  uint32_t            : 14;
      __IOM uint32_t CLEAR      : 1;            /*!< [30..30] Set this bit to one to clear the System Timer register.
                                                     If this bit is set to '1', the system timer register will
                                                     stay cleared. It needs to be set to '0' for the system
                                                     timer to start running.                                                   */
      __IOM uint32_t FREEZE     : 1;            /*!< [31..31] Set this bit to one to freeze the clock input to the
                                                     COUNTER register. Once frozen, the value can be safely
                                                     written from the MCU. Unfreeze to resume.                                 */
    } STCFG_b;
  } ;

  union {
    __IOM uint32_t STTMR;                       /*!< (@ 0x00000144) System Timer Count Register (Real Time Counter)            */

    struct {
      __IOM uint32_t STTMR      : 32;           /*!< [31..0] Value of the 32-bit counter as it ticks over.                     */
    } STTMR_b;
  } ;

  union {
    __IOM uint32_t CAPTURECONTROL;              /*!< (@ 0x00000148) Capture Control Register                                   */

    struct {
      __IOM uint32_t CAPTURE0   : 1;            /*!< [0..0] Selects whether capture is enabled for the specified
                                                     capture register.                                                         */
      __IOM uint32_t CAPTURE1   : 1;            /*!< [1..1] Selects whether capture is enabled for the specified
                                                     capture register.                                                         */
      __IOM uint32_t CAPTURE2   : 1;            /*!< [2..2] Selects whether capture is enabled for the specified
                                                     capture register.                                                         */
      __IOM uint32_t CAPTURE3   : 1;            /*!< [3..3] Selects whether capture is enabled for the specified
                                                     capture register.                                                         */
    } CAPTURECONTROL_b;
  } ;
  __IM  uint32_t  RESERVED10;

  union {
    __IOM uint32_t SCMPR0;                      /*!< (@ 0x00000150) Compare Register A                                         */

    struct {
      __IOM uint32_t SCMPR0     : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_A_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR0_b;
  } ;

  union {
    __IOM uint32_t SCMPR1;                      /*!< (@ 0x00000154) Compare Register B                                         */

    struct {
      __IOM uint32_t SCMPR1     : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_B_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR1_b;
  } ;

  union {
    __IOM uint32_t SCMPR2;                      /*!< (@ 0x00000158) Compare Register C                                         */

    struct {
      __IOM uint32_t SCMPR2     : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_C_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR2_b;
  } ;

  union {
    __IOM uint32_t SCMPR3;                      /*!< (@ 0x0000015C) Compare Register D                                         */

    struct {
      __IOM uint32_t SCMPR3     : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_D_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR3_b;
  } ;

  union {
    __IOM uint32_t SCMPR4;                      /*!< (@ 0x00000160) Compare Register E                                         */

    struct {
      __IOM uint32_t SCMPR4     : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_E_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR4_b;
  } ;

  union {
    __IOM uint32_t SCMPR5;                      /*!< (@ 0x00000164) Compare Register F                                         */

    struct {
      __IOM uint32_t SCMPR5     : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_F_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR5_b;
  } ;

  union {
    __IOM uint32_t SCMPR6;                      /*!< (@ 0x00000168) Compare Register G                                         */

    struct {
      __IOM uint32_t SCMPR6     : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_G_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR6_b;
  } ;

  union {
    __IOM uint32_t SCMPR7;                      /*!< (@ 0x0000016C) Compare Register H                                         */

    struct {
      __IOM uint32_t SCMPR7     : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_H_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR7_b;
  } ;
  __IM  uint32_t  RESERVED11[28];

  union {
    __IOM uint32_t SCAPT0;                      /*!< (@ 0x000001E0) Capture Register A                                         */

    struct {
      __IOM uint32_t SCAPT0     : 32;           /*!< [31..0] Whenever the event is detected, the value in the COUNTER
                                                     is copied into this register and the corresponding interrupt
                                                     status bit is set.                                                        */
    } SCAPT0_b;
  } ;

  union {
    __IOM uint32_t SCAPT1;                      /*!< (@ 0x000001E4) Capture Register B                                         */

    struct {
      __IOM uint32_t SCAPT1     : 32;           /*!< [31..0] Whenever the event is detected, the value in the COUNTER
                                                     is copied into this register and the corresponding interrupt
                                                     status bit is set.                                                        */
    } SCAPT1_b;
  } ;

  union {
    __IOM uint32_t SCAPT2;                      /*!< (@ 0x000001E8) Capture Register C                                         */

    struct {
      __IOM uint32_t SCAPT2     : 32;           /*!< [31..0] Whenever the event is detected, the value in the COUNTER
                                                     is copied into this register and the corresponding interrupt
                                                     status bit is set.                                                        */
    } SCAPT2_b;
  } ;

  union {
    __IOM uint32_t SCAPT3;                      /*!< (@ 0x000001EC) Capture Register D                                         */

    struct {
      __IOM uint32_t SCAPT3     : 32;           /*!< [31..0] Whenever the event is detected, the value in the COUNTER
                                                     is copied into this register and the corresponding interrupt
                                                     status bit is set.                                                        */
    } SCAPT3_b;
  } ;

  union {
    __IOM uint32_t SNVR0;                       /*!< (@ 0x000001F0) System Timer NVRAM_A Register                              */

    struct {
      __IOM uint32_t SNVR0      : 32;           /*!< [31..0] Value of the 32-bit counter as it ticks over.                     */
    } SNVR0_b;
  } ;

  union {
    __IOM uint32_t SNVR1;                       /*!< (@ 0x000001F4) System Timer NVRAM_B Register                              */

    struct {
      __IOM uint32_t SNVR1      : 32;           /*!< [31..0] Value of the 32-bit counter as it ticks over.                     */
    } SNVR1_b;
  } ;

  union {
    __IOM uint32_t SNVR2;                       /*!< (@ 0x000001F8) System Timer NVRAM_C Register                              */

    struct {
      __IOM uint32_t SNVR2      : 32;           /*!< [31..0] Value of the 32-bit counter as it ticks over.                     */
    } SNVR2_b;
  } ;

  union {
    __IOM uint32_t SNVR3;                       /*!< (@ 0x000001FC) System Timer NVRAM_D Register                              */

    struct {
      __IOM uint32_t SNVR3      : 32;           /*!< [31..0] Value of the 32-bit counter as it ticks over.                     */
    } SNVR3_b;
  } ;

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Counter/Timer Interrupts: Enable                           */

    struct {
      __IOM uint32_t CTMRA0C0INT : 1;           /*!< [0..0] Counter/Timer A0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB0C0INT : 1;           /*!< [1..1] Counter/Timer B0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA1C0INT : 1;           /*!< [2..2] Counter/Timer A1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB1C0INT : 1;           /*!< [3..3] Counter/Timer B1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA2C0INT : 1;           /*!< [4..4] Counter/Timer A2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB2C0INT : 1;           /*!< [5..5] Counter/Timer B2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA3C0INT : 1;           /*!< [6..6] Counter/Timer A3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB3C0INT : 1;           /*!< [7..7] Counter/Timer B3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA4C0INT : 1;           /*!< [8..8] Counter/Timer A4 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB4C0INT : 1;           /*!< [9..9] Counter/Timer B4 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA5C0INT : 1;           /*!< [10..10] Counter/Timer A5 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB5C0INT : 1;           /*!< [11..11] Counter/Timer B5 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA6C0INT : 1;           /*!< [12..12] Counter/Timer A6 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB6C0INT : 1;           /*!< [13..13] Counter/Timer B6 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA7C0INT : 1;           /*!< [14..14] Counter/Timer A7 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB7C0INT : 1;           /*!< [15..15] Counter/Timer B7 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA0C1INT : 1;           /*!< [16..16] Counter/Timer A0 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB0C1INT : 1;           /*!< [17..17] Counter/Timer B0 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA1C1INT : 1;           /*!< [18..18] Counter/Timer A1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB1C1INT : 1;           /*!< [19..19] Counter/Timer B1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA2C1INT : 1;           /*!< [20..20] Counter/Timer A2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB2C1INT : 1;           /*!< [21..21] Counter/Timer B2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA3C1INT : 1;           /*!< [22..22] Counter/Timer A3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB3C1INT : 1;           /*!< [23..23] Counter/Timer B3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA4C1INT : 1;           /*!< [24..24] Counter/Timer A4 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB4C1INT : 1;           /*!< [25..25] Counter/Timer B4 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA5C1INT : 1;           /*!< [26..26] Counter/Timer A5 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB5C1INT : 1;           /*!< [27..27] Counter/Timer B5 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA6C1INT : 1;           /*!< [28..28] Counter/Timer A6 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB6C1INT : 1;           /*!< [29..29] Counter/Timer B6 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA7C1INT : 1;           /*!< [30..30] Counter/Timer A7 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB7C1INT : 1;           /*!< [31..31] Counter/Timer B7 interrupt based on COMPR1.                      */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Counter/Timer Interrupts: Status                           */

    struct {
      __IOM uint32_t CTMRA0C0INT : 1;           /*!< [0..0] Counter/Timer A0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB0C0INT : 1;           /*!< [1..1] Counter/Timer B0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA1C0INT : 1;           /*!< [2..2] Counter/Timer A1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB1C0INT : 1;           /*!< [3..3] Counter/Timer B1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA2C0INT : 1;           /*!< [4..4] Counter/Timer A2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB2C0INT : 1;           /*!< [5..5] Counter/Timer B2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA3C0INT : 1;           /*!< [6..6] Counter/Timer A3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB3C0INT : 1;           /*!< [7..7] Counter/Timer B3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA4C0INT : 1;           /*!< [8..8] Counter/Timer A4 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB4C0INT : 1;           /*!< [9..9] Counter/Timer B4 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA5C0INT : 1;           /*!< [10..10] Counter/Timer A5 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB5C0INT : 1;           /*!< [11..11] Counter/Timer B5 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA6C0INT : 1;           /*!< [12..12] Counter/Timer A6 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB6C0INT : 1;           /*!< [13..13] Counter/Timer B6 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA7C0INT : 1;           /*!< [14..14] Counter/Timer A7 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB7C0INT : 1;           /*!< [15..15] Counter/Timer B7 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA0C1INT : 1;           /*!< [16..16] Counter/Timer A0 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB0C1INT : 1;           /*!< [17..17] Counter/Timer B0 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA1C1INT : 1;           /*!< [18..18] Counter/Timer A1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB1C1INT : 1;           /*!< [19..19] Counter/Timer B1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA2C1INT : 1;           /*!< [20..20] Counter/Timer A2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB2C1INT : 1;           /*!< [21..21] Counter/Timer B2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA3C1INT : 1;           /*!< [22..22] Counter/Timer A3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB3C1INT : 1;           /*!< [23..23] Counter/Timer B3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA4C1INT : 1;           /*!< [24..24] Counter/Timer A4 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB4C1INT : 1;           /*!< [25..25] Counter/Timer B4 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA5C1INT : 1;           /*!< [26..26] Counter/Timer A5 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB5C1INT : 1;           /*!< [27..27] Counter/Timer B5 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA6C1INT : 1;           /*!< [28..28] Counter/Timer A6 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB6C1INT : 1;           /*!< [29..29] Counter/Timer B6 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA7C1INT : 1;           /*!< [30..30] Counter/Timer A7 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB7C1INT : 1;           /*!< [31..31] Counter/Timer B7 interrupt based on COMPR1.                      */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Counter/Timer Interrupts: Clear                            */

    struct {
      __IOM uint32_t CTMRA0C0INT : 1;           /*!< [0..0] Counter/Timer A0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB0C0INT : 1;           /*!< [1..1] Counter/Timer B0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA1C0INT : 1;           /*!< [2..2] Counter/Timer A1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB1C0INT : 1;           /*!< [3..3] Counter/Timer B1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA2C0INT : 1;           /*!< [4..4] Counter/Timer A2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB2C0INT : 1;           /*!< [5..5] Counter/Timer B2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA3C0INT : 1;           /*!< [6..6] Counter/Timer A3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB3C0INT : 1;           /*!< [7..7] Counter/Timer B3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA4C0INT : 1;           /*!< [8..8] Counter/Timer A4 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB4C0INT : 1;           /*!< [9..9] Counter/Timer B4 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA5C0INT : 1;           /*!< [10..10] Counter/Timer A5 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB5C0INT : 1;           /*!< [11..11] Counter/Timer B5 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA6C0INT : 1;           /*!< [12..12] Counter/Timer A6 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB6C0INT : 1;           /*!< [13..13] Counter/Timer B6 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA7C0INT : 1;           /*!< [14..14] Counter/Timer A7 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB7C0INT : 1;           /*!< [15..15] Counter/Timer B7 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA0C1INT : 1;           /*!< [16..16] Counter/Timer A0 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB0C1INT : 1;           /*!< [17..17] Counter/Timer B0 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA1C1INT : 1;           /*!< [18..18] Counter/Timer A1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB1C1INT : 1;           /*!< [19..19] Counter/Timer B1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA2C1INT : 1;           /*!< [20..20] Counter/Timer A2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB2C1INT : 1;           /*!< [21..21] Counter/Timer B2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA3C1INT : 1;           /*!< [22..22] Counter/Timer A3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB3C1INT : 1;           /*!< [23..23] Counter/Timer B3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA4C1INT : 1;           /*!< [24..24] Counter/Timer A4 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB4C1INT : 1;           /*!< [25..25] Counter/Timer B4 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA5C1INT : 1;           /*!< [26..26] Counter/Timer A5 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB5C1INT : 1;           /*!< [27..27] Counter/Timer B5 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA6C1INT : 1;           /*!< [28..28] Counter/Timer A6 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB6C1INT : 1;           /*!< [29..29] Counter/Timer B6 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA7C1INT : 1;           /*!< [30..30] Counter/Timer A7 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB7C1INT : 1;           /*!< [31..31] Counter/Timer B7 interrupt based on COMPR1.                      */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Counter/Timer Interrupts: Set                              */

    struct {
      __IOM uint32_t CTMRA0C0INT : 1;           /*!< [0..0] Counter/Timer A0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB0C0INT : 1;           /*!< [1..1] Counter/Timer B0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA1C0INT : 1;           /*!< [2..2] Counter/Timer A1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB1C0INT : 1;           /*!< [3..3] Counter/Timer B1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA2C0INT : 1;           /*!< [4..4] Counter/Timer A2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB2C0INT : 1;           /*!< [5..5] Counter/Timer B2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA3C0INT : 1;           /*!< [6..6] Counter/Timer A3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB3C0INT : 1;           /*!< [7..7] Counter/Timer B3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA4C0INT : 1;           /*!< [8..8] Counter/Timer A4 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB4C0INT : 1;           /*!< [9..9] Counter/Timer B4 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA5C0INT : 1;           /*!< [10..10] Counter/Timer A5 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB5C0INT : 1;           /*!< [11..11] Counter/Timer B5 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA6C0INT : 1;           /*!< [12..12] Counter/Timer A6 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB6C0INT : 1;           /*!< [13..13] Counter/Timer B6 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA7C0INT : 1;           /*!< [14..14] Counter/Timer A7 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB7C0INT : 1;           /*!< [15..15] Counter/Timer B7 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA0C1INT : 1;           /*!< [16..16] Counter/Timer A0 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB0C1INT : 1;           /*!< [17..17] Counter/Timer B0 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA1C1INT : 1;           /*!< [18..18] Counter/Timer A1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB1C1INT : 1;           /*!< [19..19] Counter/Timer B1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA2C1INT : 1;           /*!< [20..20] Counter/Timer A2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB2C1INT : 1;           /*!< [21..21] Counter/Timer B2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA3C1INT : 1;           /*!< [22..22] Counter/Timer A3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB3C1INT : 1;           /*!< [23..23] Counter/Timer B3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA4C1INT : 1;           /*!< [24..24] Counter/Timer A4 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB4C1INT : 1;           /*!< [25..25] Counter/Timer B4 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA5C1INT : 1;           /*!< [26..26] Counter/Timer A5 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB5C1INT : 1;           /*!< [27..27] Counter/Timer B5 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA6C1INT : 1;           /*!< [28..28] Counter/Timer A6 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB6C1INT : 1;           /*!< [29..29] Counter/Timer B6 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA7C1INT : 1;           /*!< [30..30] Counter/Timer A7 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB7C1INT : 1;           /*!< [31..31] Counter/Timer B7 interrupt based on COMPR1.                      */
    } INTSET_b;
  } ;
  __IM  uint32_t  RESERVED12[60];

  union {
    __IOM uint32_t STMINTEN;                    /*!< (@ 0x00000300) STIMER Interrupt registers: Enable                         */

    struct {
      __IOM uint32_t COMPAREA   : 1;            /*!< [0..0] COUNTER is greater than or equal to COMPARE register
                                                     A.                                                                        */
      __IOM uint32_t COMPAREB   : 1;            /*!< [1..1] COUNTER is greater than or equal to COMPARE register
                                                     B.                                                                        */
      __IOM uint32_t COMPAREC   : 1;            /*!< [2..2] COUNTER is greater than or equal to COMPARE register
                                                     C.                                                                        */
      __IOM uint32_t COMPARED   : 1;            /*!< [3..3] COUNTER is greater than or equal to COMPARE register
                                                     D.                                                                        */
      __IOM uint32_t COMPAREE   : 1;            /*!< [4..4] COUNTER is greater than or equal to COMPARE register
                                                     E.                                                                        */
      __IOM uint32_t COMPAREF   : 1;            /*!< [5..5] COUNTER is greater than or equal to COMPARE register
                                                     F.                                                                        */
      __IOM uint32_t COMPAREG   : 1;            /*!< [6..6] COUNTER is greater than or equal to COMPARE register
                                                     G.                                                                        */
      __IOM uint32_t COMPAREH   : 1;            /*!< [7..7] COUNTER is greater than or equal to COMPARE register
                                                     H.                                                                        */
      __IOM uint32_t OVERFLOW   : 1;            /*!< [8..8] COUNTER over flowed from 0xFFFFFFFF back to 0x00000000.            */
      __IOM uint32_t CAPTUREA   : 1;            /*!< [9..9] CAPTURE register A has grabbed the value in the counter            */
      __IOM uint32_t CAPTUREB   : 1;            /*!< [10..10] CAPTURE register B has grabbed the value in the counter          */
      __IOM uint32_t CAPTUREC   : 1;            /*!< [11..11] CAPTURE register C has grabbed the value in the counter          */
      __IOM uint32_t CAPTURED   : 1;            /*!< [12..12] CAPTURE register D has grabbed the value in the counter          */
    } STMINTEN_b;
  } ;

  union {
    __IOM uint32_t STMINTSTAT;                  /*!< (@ 0x00000304) STIMER Interrupt registers: Status                         */

    struct {
      __IOM uint32_t COMPAREA   : 1;            /*!< [0..0] COUNTER is greater than or equal to COMPARE register
                                                     A.                                                                        */
      __IOM uint32_t COMPAREB   : 1;            /*!< [1..1] COUNTER is greater than or equal to COMPARE register
                                                     B.                                                                        */
      __IOM uint32_t COMPAREC   : 1;            /*!< [2..2] COUNTER is greater than or equal to COMPARE register
                                                     C.                                                                        */
      __IOM uint32_t COMPARED   : 1;            /*!< [3..3] COUNTER is greater than or equal to COMPARE register
                                                     D.                                                                        */
      __IOM uint32_t COMPAREE   : 1;            /*!< [4..4] COUNTER is greater than or equal to COMPARE register
                                                     E.                                                                        */
      __IOM uint32_t COMPAREF   : 1;            /*!< [5..5] COUNTER is greater than or equal to COMPARE register
                                                     F.                                                                        */
      __IOM uint32_t COMPAREG   : 1;            /*!< [6..6] COUNTER is greater than or equal to COMPARE register
                                                     G.                                                                        */
      __IOM uint32_t COMPAREH   : 1;            /*!< [7..7] COUNTER is greater than or equal to COMPARE register
                                                     H.                                                                        */
      __IOM uint32_t OVERFLOW   : 1;            /*!< [8..8] COUNTER over flowed from 0xFFFFFFFF back to 0x00000000.            */
      __IOM uint32_t CAPTUREA   : 1;            /*!< [9..9] CAPTURE register A has grabbed the value in the counter            */
      __IOM uint32_t CAPTUREB   : 1;            /*!< [10..10] CAPTURE register B has grabbed the value in the counter          */
      __IOM uint32_t CAPTUREC   : 1;            /*!< [11..11] CAPTURE register C has grabbed the value in the counter          */
      __IOM uint32_t CAPTURED   : 1;            /*!< [12..12] CAPTURE register D has grabbed the value in the counter          */
    } STMINTSTAT_b;
  } ;

  union {
    __IOM uint32_t STMINTCLR;                   /*!< (@ 0x00000308) STIMER Interrupt registers: Clear                          */

    struct {
      __IOM uint32_t COMPAREA   : 1;            /*!< [0..0] COUNTER is greater than or equal to COMPARE register
                                                     A.                                                                        */
      __IOM uint32_t COMPAREB   : 1;            /*!< [1..1] COUNTER is greater than or equal to COMPARE register
                                                     B.                                                                        */
      __IOM uint32_t COMPAREC   : 1;            /*!< [2..2] COUNTER is greater than or equal to COMPARE register
                                                     C.                                                                        */
      __IOM uint32_t COMPARED   : 1;            /*!< [3..3] COUNTER is greater than or equal to COMPARE register
                                                     D.                                                                        */
      __IOM uint32_t COMPAREE   : 1;            /*!< [4..4] COUNTER is greater than or equal to COMPARE register
                                                     E.                                                                        */
      __IOM uint32_t COMPAREF   : 1;            /*!< [5..5] COUNTER is greater than or equal to COMPARE register
                                                     F.                                                                        */
      __IOM uint32_t COMPAREG   : 1;            /*!< [6..6] COUNTER is greater than or equal to COMPARE register
                                                     G.                                                                        */
      __IOM uint32_t COMPAREH   : 1;            /*!< [7..7] COUNTER is greater than or equal to COMPARE register
                                                     H.                                                                        */
      __IOM uint32_t OVERFLOW   : 1;            /*!< [8..8] COUNTER over flowed from 0xFFFFFFFF back to 0x00000000.            */
      __IOM uint32_t CAPTUREA   : 1;            /*!< [9..9] CAPTURE register A has grabbed the value in the counter            */
      __IOM uint32_t CAPTUREB   : 1;            /*!< [10..10] CAPTURE register B has grabbed the value in the counter          */
      __IOM uint32_t CAPTUREC   : 1;            /*!< [11..11] CAPTURE register C has grabbed the value in the counter          */
      __IOM uint32_t CAPTURED   : 1;            /*!< [12..12] CAPTURE register D has grabbed the value in the counter          */
    } STMINTCLR_b;
  } ;

  union {
    __IOM uint32_t STMINTSET;                   /*!< (@ 0x0000030C) STIMER Interrupt registers: Set                            */

    struct {
      __IOM uint32_t COMPAREA   : 1;            /*!< [0..0] COUNTER is greater than or equal to COMPARE register
                                                     A.                                                                        */
      __IOM uint32_t COMPAREB   : 1;            /*!< [1..1] COUNTER is greater than or equal to COMPARE register
                                                     B.                                                                        */
      __IOM uint32_t COMPAREC   : 1;            /*!< [2..2] COUNTER is greater than or equal to COMPARE register
                                                     C.                                                                        */
      __IOM uint32_t COMPARED   : 1;            /*!< [3..3] COUNTER is greater than or equal to COMPARE register
                                                     D.                                                                        */
      __IOM uint32_t COMPAREE   : 1;            /*!< [4..4] COUNTER is greater than or equal to COMPARE register
                                                     E.                                                                        */
      __IOM uint32_t COMPAREF   : 1;            /*!< [5..5] COUNTER is greater than or equal to COMPARE register
                                                     F.                                                                        */
      __IOM uint32_t COMPAREG   : 1;            /*!< [6..6] COUNTER is greater than or equal to COMPARE register
                                                     G.                                                                        */
      __IOM uint32_t COMPAREH   : 1;            /*!< [7..7] COUNTER is greater than or equal to COMPARE register
                                                     H.                                                                        */
      __IOM uint32_t OVERFLOW   : 1;            /*!< [8..8] COUNTER over flowed from 0xFFFFFFFF back to 0x00000000.            */
      __IOM uint32_t CAPTUREA   : 1;            /*!< [9..9] CAPTURE register A has grabbed the value in the counter            */
      __IOM uint32_t CAPTUREB   : 1;            /*!< [10..10] CAPTURE register B has grabbed the value in the counter          */
      __IOM uint32_t CAPTUREC   : 1;            /*!< [11..11] CAPTURE register C has grabbed the value in the counter          */
      __IOM uint32_t CAPTURED   : 1;            /*!< [12..12] CAPTURE register D has grabbed the value in the counter          */
    } STMINTSET_b;
  } ;
} CTIMER_Type;                                  /*!< Size = 784 (0x310)                                                        */



/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose IO (GPIO)
  */

typedef struct {                                /*!< (@ 0x40010000) GPIO Structure                                             */

  union {
    __IOM uint32_t PADREGA;                     /*!< (@ 0x00000000) Pad Configuration Register A (Pads 0-3)                    */

    struct {
      __IOM uint32_t PAD0PULL   : 1;            /*!< [0..0] Pad 0 pullup enable                                                */
      __IOM uint32_t PAD0INPEN  : 1;            /*!< [1..1] Pad 0 input enable                                                 */
      __IOM uint32_t PAD0STRNG  : 1;            /*!< [2..2] Pad 0 drive strength                                               */
      __IOM uint32_t PAD0FNCSEL : 3;            /*!< [5..3] Pad 0 function select                                              */
      __IOM uint32_t PAD0RSEL   : 2;            /*!< [7..6] Pad 0 pullup resistor selection.                                   */
      __IOM uint32_t PAD1PULL   : 1;            /*!< [8..8] Pad 1 pullup enable                                                */
      __IOM uint32_t PAD1INPEN  : 1;            /*!< [9..9] Pad 1 input enable                                                 */
      __IOM uint32_t PAD1STRNG  : 1;            /*!< [10..10] Pad 1 drive strength                                             */
      __IOM uint32_t PAD1FNCSEL : 3;            /*!< [13..11] Pad 1 function select                                            */
      __IOM uint32_t PAD1RSEL   : 2;            /*!< [15..14] Pad 1 pullup resistor selection.                                 */
      __IOM uint32_t PAD2PULL   : 1;            /*!< [16..16] Pad 2 pullup enable                                              */
      __IOM uint32_t PAD2INPEN  : 1;            /*!< [17..17] Pad 2 input enable                                               */
      __IOM uint32_t PAD2STRNG  : 1;            /*!< [18..18] Pad 2 drive strength                                             */
      __IOM uint32_t PAD2FNCSEL : 3;            /*!< [21..19] Pad 2 function select                                            */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD3PULL   : 1;            /*!< [24..24] Pad 3 pullup enable                                              */
      __IOM uint32_t PAD3INPEN  : 1;            /*!< [25..25] Pad 3 input enable.                                              */
      __IOM uint32_t PAD3STRNG  : 1;            /*!< [26..26] Pad 3 drive strength.                                            */
      __IOM uint32_t PAD3FNCSEL : 3;            /*!< [29..27] Pad 3 function select                                            */
      __IOM uint32_t PAD3PWRUP  : 1;            /*!< [30..30] Pad 3 VDD power switch enable                                    */
    } PADREGA_b;
  } ;

  union {
    __IOM uint32_t PADREGB;                     /*!< (@ 0x00000004) Pad Configuration Register B (Pads 4-7)                    */

    struct {
      __IOM uint32_t PAD4PULL   : 1;            /*!< [0..0] Pad 4 pullup enable                                                */
      __IOM uint32_t PAD4INPEN  : 1;            /*!< [1..1] Pad 4 input enable                                                 */
      __IOM uint32_t PAD4STRNG  : 1;            /*!< [2..2] Pad 4 drive strength                                               */
      __IOM uint32_t PAD4FNCSEL : 3;            /*!< [5..3] Pad 4 function select                                              */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD5PULL   : 1;            /*!< [8..8] Pad 5 pullup enable                                                */
      __IOM uint32_t PAD5INPEN  : 1;            /*!< [9..9] Pad 5 input enable                                                 */
      __IOM uint32_t PAD5STRNG  : 1;            /*!< [10..10] Pad 5 drive strength                                             */
      __IOM uint32_t PAD5FNCSEL : 3;            /*!< [13..11] Pad 5 function select                                            */
      __IOM uint32_t PAD5RSEL   : 2;            /*!< [15..14] Pad 5 pullup resistor selection.                                 */
      __IOM uint32_t PAD6PULL   : 1;            /*!< [16..16] Pad 6 pullup enable                                              */
      __IOM uint32_t PAD6INPEN  : 1;            /*!< [17..17] Pad 6 input enable                                               */
      __IOM uint32_t PAD6STRNG  : 1;            /*!< [18..18] Pad 6 drive strength                                             */
      __IOM uint32_t PAD6FNCSEL : 3;            /*!< [21..19] Pad 6 function select                                            */
      __IOM uint32_t PAD6RSEL   : 2;            /*!< [23..22] Pad 6 pullup resistor selection.                                 */
      __IOM uint32_t PAD7PULL   : 1;            /*!< [24..24] Pad 7 pullup enable                                              */
      __IOM uint32_t PAD7INPEN  : 1;            /*!< [25..25] Pad 7 input enable                                               */
      __IOM uint32_t PAD7STRNG  : 1;            /*!< [26..26] Pad 7 drive strength                                             */
      __IOM uint32_t PAD7FNCSEL : 3;            /*!< [29..27] Pad 7 function select                                            */
    } PADREGB_b;
  } ;

  union {
    __IOM uint32_t PADREGC;                     /*!< (@ 0x00000008) Pad Configuration Register C (Pads 8-11)                   */

    struct {
      __IOM uint32_t PAD8PULL   : 1;            /*!< [0..0] Pad 8 pullup enable                                                */
      __IOM uint32_t PAD8INPEN  : 1;            /*!< [1..1] Pad 8 input enable                                                 */
      __IOM uint32_t PAD8STRNG  : 1;            /*!< [2..2] Pad 8 drive strength                                               */
      __IOM uint32_t PAD8FNCSEL : 3;            /*!< [5..3] Pad 8 function select                                              */
      __IOM uint32_t PAD8RSEL   : 2;            /*!< [7..6] Pad 8 pullup resistor selection.                                   */
      __IOM uint32_t PAD9PULL   : 1;            /*!< [8..8] Pad 9 pullup enable                                                */
      __IOM uint32_t PAD9INPEN  : 1;            /*!< [9..9] Pad 9 input enable                                                 */
      __IOM uint32_t PAD9STRNG  : 1;            /*!< [10..10] Pad 9 drive strength                                             */
      __IOM uint32_t PAD9FNCSEL : 3;            /*!< [13..11] Pad 9 function select                                            */
      __IOM uint32_t PAD9RSEL   : 2;            /*!< [15..14] Pad 9 pullup resistor selection                                  */
      __IOM uint32_t PAD10PULL  : 1;            /*!< [16..16] Pad 10 pullup enable                                             */
      __IOM uint32_t PAD10INPEN : 1;            /*!< [17..17] Pad 10 input enable                                              */
      __IOM uint32_t PAD10STRNG : 1;            /*!< [18..18] Pad 10 drive strength                                            */
      __IOM uint32_t PAD10FNCSEL : 3;           /*!< [21..19] Pad 10 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD11PULL  : 1;            /*!< [24..24] Pad 11 pullup enable                                             */
      __IOM uint32_t PAD11INPEN : 1;            /*!< [25..25] Pad 11 input enable                                              */
      __IOM uint32_t PAD11STRNG : 1;            /*!< [26..26] Pad 11 drive strength                                            */
      __IOM uint32_t PAD11FNCSEL : 3;           /*!< [29..27] Pad 11 function select                                           */
    } PADREGC_b;
  } ;

  union {
    __IOM uint32_t PADREGD;                     /*!< (@ 0x0000000C) Pad Configuration Register D (Pads 12-15)                  */

    struct {
      __IOM uint32_t PAD12PULL  : 1;            /*!< [0..0] Pad 12 pullup enable                                               */
      __IOM uint32_t PAD12INPEN : 1;            /*!< [1..1] Pad 12 input enable                                                */
      __IOM uint32_t PAD12STRNG : 1;            /*!< [2..2] Pad 12 drive strength                                              */
      __IOM uint32_t PAD12FNCSEL : 3;           /*!< [5..3] Pad 12 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD13PULL  : 1;            /*!< [8..8] Pad 13 pullup enable                                               */
      __IOM uint32_t PAD13INPEN : 1;            /*!< [9..9] Pad 13 input enable                                                */
      __IOM uint32_t PAD13STRNG : 1;            /*!< [10..10] Pad 13 drive strength                                            */
      __IOM uint32_t PAD13FNCSEL : 3;           /*!< [13..11] Pad 13 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD14PULL  : 1;            /*!< [16..16] Pad 14 pullup enable                                             */
      __IOM uint32_t PAD14INPEN : 1;            /*!< [17..17] Pad 14 input enable                                              */
      __IOM uint32_t PAD14STRNG : 1;            /*!< [18..18] Pad 14 drive strength                                            */
      __IOM uint32_t PAD14FNCSEL : 3;           /*!< [21..19] Pad 14 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD15PULL  : 1;            /*!< [24..24] Pad 15 pullup enable                                             */
      __IOM uint32_t PAD15INPEN : 1;            /*!< [25..25] Pad 15 input enable                                              */
      __IOM uint32_t PAD15STRNG : 1;            /*!< [26..26] Pad 15 drive strength                                            */
      __IOM uint32_t PAD15FNCSEL : 3;           /*!< [29..27] Pad 15 function select                                           */
    } PADREGD_b;
  } ;

  union {
    __IOM uint32_t PADREGE;                     /*!< (@ 0x00000010) Pad Configuration Register E (Pads 16-19)                  */

    struct {
      __IOM uint32_t PAD16PULL  : 1;            /*!< [0..0] Pad 16 pullup enable                                               */
      __IOM uint32_t PAD16INPEN : 1;            /*!< [1..1] Pad 16 input enable                                                */
      __IOM uint32_t PAD16STRNG : 1;            /*!< [2..2] Pad 16 drive strength                                              */
      __IOM uint32_t PAD16FNCSEL : 3;           /*!< [5..3] Pad 16 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD17PULL  : 1;            /*!< [8..8] Pad 17 pullup enable                                               */
      __IOM uint32_t PAD17INPEN : 1;            /*!< [9..9] Pad 17 input enable                                                */
      __IOM uint32_t PAD17STRNG : 1;            /*!< [10..10] Pad 17 drive strength                                            */
      __IOM uint32_t PAD17FNCSEL : 3;           /*!< [13..11] Pad 17 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD18PULL  : 1;            /*!< [16..16] Pad 18 pullup enable                                             */
      __IOM uint32_t PAD18INPEN : 1;            /*!< [17..17] Pad 18 input enable                                              */
      __IOM uint32_t PAD18STRNG : 1;            /*!< [18..18] Pad 18 drive strength                                            */
      __IOM uint32_t PAD18FNCSEL : 3;           /*!< [21..19] Pad 18 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD19PULL  : 1;            /*!< [24..24] Pad 19 pullup enable                                             */
      __IOM uint32_t PAD19INPEN : 1;            /*!< [25..25] Pad 19 input enable                                              */
      __IOM uint32_t PAD19STRNG : 1;            /*!< [26..26] Pad 19 drive strength                                            */
      __IOM uint32_t PAD19FNCSEL : 3;           /*!< [29..27] Pad 19 function select                                           */
    } PADREGE_b;
  } ;

  union {
    __IOM uint32_t PADREGF;                     /*!< (@ 0x00000014) Pad Configuration Register F (Pads 20-23)                  */

    struct {
      __IOM uint32_t PAD20PULL  : 1;            /*!< [0..0] Pad 20 pulldown enable                                             */
      __IOM uint32_t PAD20INPEN : 1;            /*!< [1..1] Pad 20 input enable                                                */
      __IOM uint32_t PAD20STRNG : 1;            /*!< [2..2] Pad 20 drive strength                                              */
      __IOM uint32_t PAD20FNCSEL : 3;           /*!< [5..3] Pad 20 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD21PULL  : 1;            /*!< [8..8] Pad 21 pullup enable                                               */
      __IOM uint32_t PAD21INPEN : 1;            /*!< [9..9] Pad 21 input enable                                                */
      __IOM uint32_t PAD21STRNG : 1;            /*!< [10..10] Pad 21 drive strength                                            */
      __IOM uint32_t PAD21FNCSEL : 3;           /*!< [13..11] Pad 21 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD22PULL  : 1;            /*!< [16..16] Pad 22 pullup enable                                             */
      __IOM uint32_t PAD22INPEN : 1;            /*!< [17..17] Pad 22 input enable                                              */
      __IOM uint32_t PAD22STRNG : 1;            /*!< [18..18] Pad 22 drive strength                                            */
      __IOM uint32_t PAD22FNCSEL : 3;           /*!< [21..19] Pad 22 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD23PULL  : 1;            /*!< [24..24] Pad 23 pullup enable                                             */
      __IOM uint32_t PAD23INPEN : 1;            /*!< [25..25] Pad 23 input enable                                              */
      __IOM uint32_t PAD23STRNG : 1;            /*!< [26..26] Pad 23 drive strength                                            */
      __IOM uint32_t PAD23FNCSEL : 3;           /*!< [29..27] Pad 23 function select                                           */
    } PADREGF_b;
  } ;

  union {
    __IOM uint32_t PADREGG;                     /*!< (@ 0x00000018) Pad Configuration Register G (Pads 24-27)                  */

    struct {
      __IOM uint32_t PAD24PULL  : 1;            /*!< [0..0] Pad 24 pullup enable                                               */
      __IOM uint32_t PAD24INPEN : 1;            /*!< [1..1] Pad 24 input enable                                                */
      __IOM uint32_t PAD24STRNG : 1;            /*!< [2..2] Pad 24 drive strength                                              */
      __IOM uint32_t PAD24FNCSEL : 3;           /*!< [5..3] Pad 24 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD25PULL  : 1;            /*!< [8..8] Pad 25 pullup enable                                               */
      __IOM uint32_t PAD25INPEN : 1;            /*!< [9..9] Pad 25 input enable                                                */
      __IOM uint32_t PAD25STRNG : 1;            /*!< [10..10] Pad 25 drive strength                                            */
      __IOM uint32_t PAD25FNCSEL : 3;           /*!< [13..11] Pad 25 function select                                           */
      __IOM uint32_t PAD25RSEL  : 2;            /*!< [15..14] Pad 25 pullup resistor selection.                                */
      __IOM uint32_t PAD26PULL  : 1;            /*!< [16..16] Pad 26 pullup enable                                             */
      __IOM uint32_t PAD26INPEN : 1;            /*!< [17..17] Pad 26 input enable                                              */
      __IOM uint32_t PAD26STRNG : 1;            /*!< [18..18] Pad 26 drive strength                                            */
      __IOM uint32_t PAD26FNCSEL : 3;           /*!< [21..19] Pad 26 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD27PULL  : 1;            /*!< [24..24] Pad 27 pullup enable                                             */
      __IOM uint32_t PAD27INPEN : 1;            /*!< [25..25] Pad 27 input enable                                              */
      __IOM uint32_t PAD27STRNG : 1;            /*!< [26..26] Pad 27 drive strength                                            */
      __IOM uint32_t PAD27FNCSEL : 3;           /*!< [29..27] Pad 27 function select                                           */
      __IOM uint32_t PAD27RSEL  : 2;            /*!< [31..30] Pad 27 pullup resistor selection.                                */
    } PADREGG_b;
  } ;

  union {
    __IOM uint32_t PADREGH;                     /*!< (@ 0x0000001C) Pad Configuration Register H (Pads 28-31)                  */

    struct {
      __IOM uint32_t PAD28PULL  : 1;            /*!< [0..0] Pad 28 pullup enable                                               */
      __IOM uint32_t PAD28INPEN : 1;            /*!< [1..1] Pad 28 input enable                                                */
      __IOM uint32_t PAD28STRNG : 1;            /*!< [2..2] Pad 28 drive strength                                              */
      __IOM uint32_t PAD28FNCSEL : 3;           /*!< [5..3] Pad 28 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD29PULL  : 1;            /*!< [8..8] Pad 29 pullup enable                                               */
      __IOM uint32_t PAD29INPEN : 1;            /*!< [9..9] Pad 29 input enable                                                */
      __IOM uint32_t PAD29STRNG : 1;            /*!< [10..10] Pad 29 drive strength                                            */
      __IOM uint32_t PAD29FNCSEL : 3;           /*!< [13..11] Pad 29 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD30PULL  : 1;            /*!< [16..16] Pad 30 pullup enable                                             */
      __IOM uint32_t PAD30INPEN : 1;            /*!< [17..17] Pad 30 input enable                                              */
      __IOM uint32_t PAD30STRNG : 1;            /*!< [18..18] Pad 30 drive strength                                            */
      __IOM uint32_t PAD30FNCSEL : 3;           /*!< [21..19] Pad 30 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD31PULL  : 1;            /*!< [24..24] Pad 31 pullup enable                                             */
      __IOM uint32_t PAD31INPEN : 1;            /*!< [25..25] Pad 31 input enable                                              */
      __IOM uint32_t PAD31STRNG : 1;            /*!< [26..26] Pad 31 drive strength                                            */
      __IOM uint32_t PAD31FNCSEL : 3;           /*!< [29..27] Pad 31 function select                                           */
    } PADREGH_b;
  } ;

  union {
    __IOM uint32_t PADREGI;                     /*!< (@ 0x00000020) Pad Configuration Register I (Pads 32-35)                  */

    struct {
      __IOM uint32_t PAD32PULL  : 1;            /*!< [0..0] Pad 32 pullup enable                                               */
      __IOM uint32_t PAD32INPEN : 1;            /*!< [1..1] Pad 32 input enable                                                */
      __IOM uint32_t PAD32STRNG : 1;            /*!< [2..2] Pad 32 drive strength                                              */
      __IOM uint32_t PAD32FNCSEL : 3;           /*!< [5..3] Pad 32 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD33PULL  : 1;            /*!< [8..8] Pad 33 pullup enable                                               */
      __IOM uint32_t PAD33INPEN : 1;            /*!< [9..9] Pad 33 input enable                                                */
      __IOM uint32_t PAD33STRNG : 1;            /*!< [10..10] Pad 33 drive strength                                            */
      __IOM uint32_t PAD33FNCSEL : 3;           /*!< [13..11] Pad 33 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD34PULL  : 1;            /*!< [16..16] Pad 34 pullup enable                                             */
      __IOM uint32_t PAD34INPEN : 1;            /*!< [17..17] Pad 34 input enable                                              */
      __IOM uint32_t PAD34STRNG : 1;            /*!< [18..18] Pad 34 drive strength                                            */
      __IOM uint32_t PAD34FNCSEL : 3;           /*!< [21..19] Pad 34 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD35PULL  : 1;            /*!< [24..24] Pad 35 pullup enable                                             */
      __IOM uint32_t PAD35INPEN : 1;            /*!< [25..25] Pad 35 input enable                                              */
      __IOM uint32_t PAD35STRNG : 1;            /*!< [26..26] Pad 35 drive strength                                            */
      __IOM uint32_t PAD35FNCSEL : 3;           /*!< [29..27] Pad 35 function select                                           */
    } PADREGI_b;
  } ;

  union {
    __IOM uint32_t PADREGJ;                     /*!< (@ 0x00000024) Pad Configuration Register J (Pads 36-39)                  */

    struct {
      __IOM uint32_t PAD36PULL  : 1;            /*!< [0..0] Pad 36 pullup enable                                               */
      __IOM uint32_t PAD36INPEN : 1;            /*!< [1..1] Pad 36 input enable                                                */
      __IOM uint32_t PAD36STRNG : 1;            /*!< [2..2] Pad 36 drive strength                                              */
      __IOM uint32_t PAD36FNCSEL : 3;           /*!< [5..3] Pad 36 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD37PULL  : 1;            /*!< [8..8] Pad 37 pullup enable                                               */
      __IOM uint32_t PAD37INPEN : 1;            /*!< [9..9] Pad 37 input enable                                                */
      __IOM uint32_t PAD37STRNG : 1;            /*!< [10..10] Pad 37 drive strength                                            */
      __IOM uint32_t PAD37FNCSEL : 3;           /*!< [13..11] Pad 37 function select                                           */
      __IM  uint32_t            : 1;
      __IOM uint32_t PAD37PWRDN : 1;            /*!< [15..15] Pad 37 VSS power switch enable                                   */
      __IOM uint32_t PAD38PULL  : 1;            /*!< [16..16] Pad 38 pullup enable                                             */
      __IOM uint32_t PAD38INPEN : 1;            /*!< [17..17] Pad 38 input enable                                              */
      __IOM uint32_t PAD38STRNG : 1;            /*!< [18..18] Pad 38 drive strength                                            */
      __IOM uint32_t PAD38FNCSEL : 3;           /*!< [21..19] Pad 38 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD39PULL  : 1;            /*!< [24..24] Pad 39 pullup enable                                             */
      __IOM uint32_t PAD39INPEN : 1;            /*!< [25..25] Pad 39 input enable                                              */
      __IOM uint32_t PAD39STRNG : 1;            /*!< [26..26] Pad 39 drive strength                                            */
      __IOM uint32_t PAD39FNCSEL : 3;           /*!< [29..27] Pad 39 function select                                           */
      __IOM uint32_t PAD39RSEL  : 2;            /*!< [31..30] Pad 39 pullup resistor selection.                                */
    } PADREGJ_b;
  } ;

  union {
    __IOM uint32_t PADREGK;                     /*!< (@ 0x00000028) Pad Configuration Register K (Pads 40-43)                  */

    struct {
      __IOM uint32_t PAD40PULL  : 1;            /*!< [0..0] Pad 40 pullup enable                                               */
      __IOM uint32_t PAD40INPEN : 1;            /*!< [1..1] Pad 40 input enable                                                */
      __IOM uint32_t PAD40STRNG : 1;            /*!< [2..2] Pad 40 drive strength                                              */
      __IOM uint32_t PAD40FNCSEL : 3;           /*!< [5..3] Pad 40 function select                                             */
      __IOM uint32_t PAD40RSEL  : 2;            /*!< [7..6] Pad 40 pullup resistor selection.                                  */
      __IOM uint32_t PAD41PULL  : 1;            /*!< [8..8] Pad 41 pullup enable                                               */
      __IOM uint32_t PAD41INPEN : 1;            /*!< [9..9] Pad 41 input enable                                                */
      __IOM uint32_t PAD41STRNG : 1;            /*!< [10..10] Pad 41 drive strength                                            */
      __IOM uint32_t PAD41FNCSEL : 3;           /*!< [13..11] Pad 41 function select                                           */
      __IM  uint32_t            : 1;
      __IOM uint32_t PAD41PWRDN : 1;            /*!< [15..15] Pad 41 power switch enable                                       */
      __IOM uint32_t PAD42PULL  : 1;            /*!< [16..16] Pad 42 pullup enable                                             */
      __IOM uint32_t PAD42INPEN : 1;            /*!< [17..17] Pad 42 input enable                                              */
      __IOM uint32_t PAD42STRNG : 1;            /*!< [18..18] Pad 42 drive strength                                            */
      __IOM uint32_t PAD42FNCSEL : 3;           /*!< [21..19] Pad 42 function select                                           */
      __IOM uint32_t PAD42RSEL  : 2;            /*!< [23..22] Pad 42 pullup resistor selection.                                */
      __IOM uint32_t PAD43PULL  : 1;            /*!< [24..24] Pad 43 pullup enable                                             */
      __IOM uint32_t PAD43INPEN : 1;            /*!< [25..25] Pad 43 input enable                                              */
      __IOM uint32_t PAD43STRNG : 1;            /*!< [26..26] Pad 43 drive strength                                            */
      __IOM uint32_t PAD43FNCSEL : 3;           /*!< [29..27] Pad 43 function select                                           */
      __IOM uint32_t PAD43RSEL  : 2;            /*!< [31..30] Pad 43 pullup resistor selection.                                */
    } PADREGK_b;
  } ;

  union {
    __IOM uint32_t PADREGL;                     /*!< (@ 0x0000002C) Pad Configuration Register L (Pads 44-47)                  */

    struct {
      __IOM uint32_t PAD44PULL  : 1;            /*!< [0..0] Pad 44 pullup enable                                               */
      __IOM uint32_t PAD44INPEN : 1;            /*!< [1..1] Pad 44 input enable                                                */
      __IOM uint32_t PAD44STRNG : 1;            /*!< [2..2] Pad 44 drive strength                                              */
      __IOM uint32_t PAD44FNCSEL : 3;           /*!< [5..3] Pad 44 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD45PULL  : 1;            /*!< [8..8] Pad 45 pullup enable                                               */
      __IOM uint32_t PAD45INPEN : 1;            /*!< [9..9] Pad 45 input enable                                                */
      __IOM uint32_t PAD45STRNG : 1;            /*!< [10..10] Pad 45 drive strength                                            */
      __IOM uint32_t PAD45FNCSEL : 3;           /*!< [13..11] Pad 45 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD46PULL  : 1;            /*!< [16..16] Pad 46 pullup enable                                             */
      __IOM uint32_t PAD46INPEN : 1;            /*!< [17..17] Pad 46 input enable                                              */
      __IOM uint32_t PAD46STRNG : 1;            /*!< [18..18] Pad 46 drive strength                                            */
      __IOM uint32_t PAD46FNCSEL : 3;           /*!< [21..19] Pad 46 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD47PULL  : 1;            /*!< [24..24] Pad 47 pullup enable                                             */
      __IOM uint32_t PAD47INPEN : 1;            /*!< [25..25] Pad 47 input enable                                              */
      __IOM uint32_t PAD47STRNG : 1;            /*!< [26..26] Pad 47 drive strength                                            */
      __IOM uint32_t PAD47FNCSEL : 3;           /*!< [29..27] Pad 47 function select                                           */
    } PADREGL_b;
  } ;

  union {
    __IOM uint32_t PADREGM;                     /*!< (@ 0x00000030) Pad Configuration Register M (Pads 48-51)                  */

    struct {
      __IOM uint32_t PAD48PULL  : 1;            /*!< [0..0] Pad 48 pullup enable                                               */
      __IOM uint32_t PAD48INPEN : 1;            /*!< [1..1] Pad 48 input enable                                                */
      __IOM uint32_t PAD48STRNG : 1;            /*!< [2..2] Pad 48 drive strength                                              */
      __IOM uint32_t PAD48FNCSEL : 3;           /*!< [5..3] Pad 48 function select                                             */
      __IOM uint32_t PAD48RSEL  : 2;            /*!< [7..6] Pad 48 pullup resistor selection.                                  */
      __IOM uint32_t PAD49PULL  : 1;            /*!< [8..8] Pad 49 pullup enable                                               */
      __IOM uint32_t PAD49INPEN : 1;            /*!< [9..9] Pad 49 input enable                                                */
      __IOM uint32_t PAD49STRNG : 1;            /*!< [10..10] Pad 49 drive strength                                            */
      __IOM uint32_t PAD49FNCSEL : 3;           /*!< [13..11] Pad 49 function select                                           */
      __IOM uint32_t PAD49RSEL  : 2;            /*!< [15..14] Pad 49 pullup resistor selection.                                */
      __IOM uint32_t PAD50PULL  : 1;            /*!< [16..16] Pad 50 pullup enable                                             */
      __IOM uint32_t PAD50INPEN : 1;            /*!< [17..17] Pad 50 input enable                                              */
      __IOM uint32_t PAD50STRNG : 1;            /*!< [18..18] Pad 50 drive strength                                            */
      __IOM uint32_t PAD50FNCSEL : 3;           /*!< [21..19] Pad 50 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD51PULL  : 1;            /*!< [24..24] Pad 51 pullup enable                                             */
      __IOM uint32_t PAD51INPEN : 1;            /*!< [25..25] Pad 51 input enable                                              */
      __IOM uint32_t PAD51STRNG : 1;            /*!< [26..26] Pad 51 drive strength                                            */
      __IOM uint32_t PAD51FNCSEL : 3;           /*!< [29..27] Pad 51 function select                                           */
    } PADREGM_b;
  } ;

  union {
    __IOM uint32_t PADREGN;                     /*!< (@ 0x00000034) Pad Configuration Register N (Pads 52-55)                  */

    struct {
      __IOM uint32_t PAD52PULL  : 1;            /*!< [0..0] Pad 52 pullup enable                                               */
      __IOM uint32_t PAD52INPEN : 1;            /*!< [1..1] Pad 52 input enable                                                */
      __IOM uint32_t PAD52STRNG : 1;            /*!< [2..2] Pad 52 drive strength                                              */
      __IOM uint32_t PAD52FNCSEL : 3;           /*!< [5..3] Pad 52 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD53PULL  : 1;            /*!< [8..8] Pad 53 pullup enable                                               */
      __IOM uint32_t PAD53INPEN : 1;            /*!< [9..9] Pad 53 input enable                                                */
      __IOM uint32_t PAD53STRNG : 1;            /*!< [10..10] Pad 53 drive strength                                            */
      __IOM uint32_t PAD53FNCSEL : 3;           /*!< [13..11] Pad 53 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD54PULL  : 1;            /*!< [16..16] Pad 54 pullup enable                                             */
      __IOM uint32_t PAD54INPEN : 1;            /*!< [17..17] Pad 54 input enable                                              */
      __IOM uint32_t PAD54STRNG : 1;            /*!< [18..18] Pad 54 drive strength                                            */
      __IOM uint32_t PAD54FNCSEL : 3;           /*!< [21..19] Pad 54 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD55PULL  : 1;            /*!< [24..24] Pad 55 pullup enable                                             */
      __IOM uint32_t PAD55INPEN : 1;            /*!< [25..25] Pad 55 input enable                                              */
      __IOM uint32_t PAD55STRNG : 1;            /*!< [26..26] Pad 55 drive strength                                            */
      __IOM uint32_t PAD55FNCSEL : 3;           /*!< [29..27] Pad 55 function select                                           */
    } PADREGN_b;
  } ;

  union {
    __IOM uint32_t PADREGO;                     /*!< (@ 0x00000038) Pad Configuration Register O (Pads 56-59)                  */

    struct {
      __IOM uint32_t PAD56PULL  : 1;            /*!< [0..0] Pad 56 pullup enable                                               */
      __IOM uint32_t PAD56INPEN : 1;            /*!< [1..1] Pad 56 input enable                                                */
      __IOM uint32_t PAD56STRNG : 1;            /*!< [2..2] Pad 56 drive strength                                              */
      __IOM uint32_t PAD56FNCSEL : 3;           /*!< [5..3] Pad 56 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD57PULL  : 1;            /*!< [8..8] Pad 57 pullup enable                                               */
      __IOM uint32_t PAD57INPEN : 1;            /*!< [9..9] Pad 57 input enable                                                */
      __IOM uint32_t PAD57STRNG : 1;            /*!< [10..10] Pad 57 drive strength                                            */
      __IOM uint32_t PAD57FNCSEL : 3;           /*!< [13..11] Pad 57 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD58PULL  : 1;            /*!< [16..16] Pad 58 pullup enable                                             */
      __IOM uint32_t PAD58INPEN : 1;            /*!< [17..17] Pad 58 input enable                                              */
      __IOM uint32_t PAD58STRNG : 1;            /*!< [18..18] Pad 58 drive strength                                            */
      __IOM uint32_t PAD58FNCSEL : 3;           /*!< [21..19] Pad 58 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD59PULL  : 1;            /*!< [24..24] Pad 59 pullup enable                                             */
      __IOM uint32_t PAD59INPEN : 1;            /*!< [25..25] Pad 59 input enable                                              */
      __IOM uint32_t PAD59STRNG : 1;            /*!< [26..26] Pad 59 drive strength                                            */
      __IOM uint32_t PAD59FNCSEL : 3;           /*!< [29..27] Pad 59 function select                                           */
    } PADREGO_b;
  } ;

  union {
    __IOM uint32_t PADREGP;                     /*!< (@ 0x0000003C) Pad Configuration Register P (Pads 60-63)                  */

    struct {
      __IOM uint32_t PAD60PULL  : 1;            /*!< [0..0] Pad 60 pullup enable                                               */
      __IOM uint32_t PAD60INPEN : 1;            /*!< [1..1] Pad 60 input enable                                                */
      __IOM uint32_t PAD60STRNG : 1;            /*!< [2..2] Pad 60 drive strength                                              */
      __IOM uint32_t PAD60FNCSEL : 3;           /*!< [5..3] Pad 60 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD61PULL  : 1;            /*!< [8..8] Pad 61 pullup enable                                               */
      __IOM uint32_t PAD61INPEN : 1;            /*!< [9..9] Pad 61 input enable                                                */
      __IOM uint32_t PAD61STRNG : 1;            /*!< [10..10] Pad 61 drive strength                                            */
      __IOM uint32_t PAD61FNCSEL : 3;           /*!< [13..11] Pad 61 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD62PULL  : 1;            /*!< [16..16] Pad 62 pullup enable                                             */
      __IOM uint32_t PAD62INPEN : 1;            /*!< [17..17] Pad 62 input enable                                              */
      __IOM uint32_t PAD62STRNG : 1;            /*!< [18..18] Pad 62 drive strength                                            */
      __IOM uint32_t PAD62FNCSEL : 3;           /*!< [21..19] Pad 62 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD63PULL  : 1;            /*!< [24..24] Pad 63 pullup enable                                             */
      __IOM uint32_t PAD63INPEN : 1;            /*!< [25..25] Pad 63 input enable                                              */
      __IOM uint32_t PAD63STRNG : 1;            /*!< [26..26] Pad 63 drive strength                                            */
      __IOM uint32_t PAD63FNCSEL : 3;           /*!< [29..27] Pad 63 function select                                           */
    } PADREGP_b;
  } ;

  union {
    __IOM uint32_t PADREGQ;                     /*!< (@ 0x00000040) Pad Configuration Register Q (Pads 64-67)                  */

    struct {
      __IOM uint32_t PAD64PULL  : 1;            /*!< [0..0] Pad 64 pullup enable                                               */
      __IOM uint32_t PAD64INPEN : 1;            /*!< [1..1] Pad 64 input enable                                                */
      __IOM uint32_t PAD64STRNG : 1;            /*!< [2..2] Pad 64 drive strength                                              */
      __IOM uint32_t PAD64FNCSEL : 3;           /*!< [5..3] Pad 64 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD65PULL  : 1;            /*!< [8..8] Pad 65 pullup enable                                               */
      __IOM uint32_t PAD65INPEN : 1;            /*!< [9..9] Pad 65 input enable                                                */
      __IOM uint32_t PAD65STRNG : 1;            /*!< [10..10] Pad 65 drive strength                                            */
      __IOM uint32_t PAD65FNCSEL : 3;           /*!< [13..11] Pad 65 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD66PULL  : 1;            /*!< [16..16] Pad 66 pullup enable                                             */
      __IOM uint32_t PAD66INPEN : 1;            /*!< [17..17] Pad 66 input enable                                              */
      __IOM uint32_t PAD66STRNG : 1;            /*!< [18..18] Pad 66 drive strength                                            */
      __IOM uint32_t PAD66FNCSEL : 3;           /*!< [21..19] Pad 66 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD67PULL  : 1;            /*!< [24..24] Pad 67 pullup enable                                             */
      __IOM uint32_t PAD67INPEN : 1;            /*!< [25..25] Pad 67 input enable                                              */
      __IOM uint32_t PAD67STRNG : 1;            /*!< [26..26] Pad 67 drive strength                                            */
      __IOM uint32_t PAD67FNCSEL : 3;           /*!< [29..27] Pad 67 function select                                           */
    } PADREGQ_b;
  } ;

  union {
    __IOM uint32_t PADREGR;                     /*!< (@ 0x00000044) Pad Configuration Register R (Pads 68-71)                  */

    struct {
      __IOM uint32_t PAD68PULL  : 1;            /*!< [0..0] Pad 68 pullup enable                                               */
      __IOM uint32_t PAD68INPEN : 1;            /*!< [1..1] Pad 68 input enable                                                */
      __IOM uint32_t PAD68STRNG : 1;            /*!< [2..2] Pad 68 drive strength                                              */
      __IOM uint32_t PAD68FNCSEL : 3;           /*!< [5..3] Pad 68 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD69PULL  : 1;            /*!< [8..8] Pad 69 pullup enable                                               */
      __IOM uint32_t PAD69INPEN : 1;            /*!< [9..9] Pad 69 input enable                                                */
      __IOM uint32_t PAD69STRNG : 1;            /*!< [10..10] Pad 69 drive strength                                            */
      __IOM uint32_t PAD69FNCSEL : 3;           /*!< [13..11] Pad 69 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD70PULL  : 1;            /*!< [16..16] Pad 70 pullup enable                                             */
      __IOM uint32_t PAD70INPEN : 1;            /*!< [17..17] Pad 70 input enable                                              */
      __IOM uint32_t PAD70STRNG : 1;            /*!< [18..18] Pad 70 drive strength                                            */
      __IOM uint32_t PAD70FNCSEL : 3;           /*!< [21..19] Pad 70 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD71PULL  : 1;            /*!< [24..24] Pad 71 pullup enable                                             */
      __IOM uint32_t PAD71INPEN : 1;            /*!< [25..25] Pad 71 input enable                                              */
      __IOM uint32_t PAD71STRNG : 1;            /*!< [26..26] Pad 71 drive strength                                            */
      __IOM uint32_t PAD71FNCSEL : 3;           /*!< [29..27] Pad 71 function select                                           */
    } PADREGR_b;
  } ;

  union {
    __IOM uint32_t PADREGS;                     /*!< (@ 0x00000048) Pad Configuration Register S (Pads 72-75)                  */

    struct {
      __IOM uint32_t PAD72PULL  : 1;            /*!< [0..0] Pad 72 pullup enable                                               */
      __IOM uint32_t PAD72INPEN : 1;            /*!< [1..1] Pad 72 input enable                                                */
      __IOM uint32_t PAD72STRNG : 1;            /*!< [2..2] Pad 72 drive strength                                              */
      __IOM uint32_t PAD72FNCSEL : 3;           /*!< [5..3] Pad 72 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD73PULL  : 1;            /*!< [8..8] Pad 73 pullup enable                                               */
      __IOM uint32_t PAD73INPEN : 1;            /*!< [9..9] Pad 73 input enable                                                */
      __IOM uint32_t PAD73STRNG : 1;            /*!< [10..10] Pad 73 drive strength                                            */
      __IOM uint32_t PAD73FNCSEL : 3;           /*!< [13..11] Pad 73 function select                                           */
    } PADREGS_b;
  } ;

  union {
    __IOM uint32_t CFGA;                        /*!< (@ 0x0000004C) GPIO Configuration Register A (Pads 7-0)                   */

    struct {
      __IOM uint32_t GPIO0INCFG : 1;            /*!< [0..0] GPIO0 input enable.                                                */
      __IOM uint32_t GPIO0OUTCFG : 2;           /*!< [2..1] GPIO0 output configuration.                                        */
      __IOM uint32_t GPIO0INTD  : 1;            /*!< [3..3] GPIO0 interrupt direction, nCE polarity.                           */
      __IOM uint32_t GPIO1INCFG : 1;            /*!< [4..4] GPIO1 input enable.                                                */
      __IOM uint32_t GPIO1OUTCFG : 2;           /*!< [6..5] GPIO1 output configuration.                                        */
      __IOM uint32_t GPIO1INTD  : 1;            /*!< [7..7] GPIO1 interrupt direction, nCE polarity.                           */
      __IOM uint32_t GPIO2INCFG : 1;            /*!< [8..8] GPIO2 input enable.                                                */
      __IOM uint32_t GPIO2OUTCFG : 2;           /*!< [10..9] GPIO2 output configuration.                                       */
      __IOM uint32_t GPIO2INTD  : 1;            /*!< [11..11] GPIO2 interrupt direction, nCE polarity.                         */
      __IOM uint32_t GPIO3INCFG : 1;            /*!< [12..12] GPIO3 input enable.                                              */
      __IOM uint32_t GPIO3OUTCFG : 2;           /*!< [14..13] GPIO3 output configuration.                                      */
      __IOM uint32_t GPIO3INTD  : 1;            /*!< [15..15] GPIO3 interrupt direction, nCE polarity.                         */
      __IOM uint32_t GPIO4INCFG : 1;            /*!< [16..16] GPIO4 input enable.                                              */
      __IOM uint32_t GPIO4OUTCFG : 2;           /*!< [18..17] GPIO4 output configuration.                                      */
      __IOM uint32_t GPIO4INTD  : 1;            /*!< [19..19] GPIO4 interrupt direction, nCE polarity.                         */
      __IOM uint32_t GPIO5INCFG : 1;            /*!< [20..20] GPIO5 input enable.                                              */
      __IOM uint32_t GPIO5OUTCFG : 2;           /*!< [22..21] GPIO5 output configuration.                                      */
      __IOM uint32_t GPIO5INTD  : 1;            /*!< [23..23] GPIO5 interrupt direction, nCE polarity.                         */
      __IOM uint32_t GPIO6INCFG : 1;            /*!< [24..24] GPIO6 input enable.                                              */
      __IOM uint32_t GPIO6OUTCFG : 2;           /*!< [26..25] GPIO6 output configuration.                                      */
      __IOM uint32_t GPIO6INTD  : 1;            /*!< [27..27] GPIO6 interrupt direction, nCE polarity.                         */
      __IOM uint32_t GPIO7INCFG : 1;            /*!< [28..28] GPIO7 input enable.                                              */
      __IOM uint32_t GPIO7OUTCFG : 2;           /*!< [30..29] GPIO7 output configuration.                                      */
      __IOM uint32_t GPIO7INTD  : 1;            /*!< [31..31] GPIO7 interrupt direction, nCE polarity.                         */
    } CFGA_b;
  } ;

  union {
    __IOM uint32_t CFGB;                        /*!< (@ 0x00000050) GPIO Configuration Register B (Pads 15-8)                  */

    struct {
      __IOM uint32_t GPIO8INCFG : 1;            /*!< [0..0] GPIO8 input enable.                                                */
      __IOM uint32_t GPIO8OUTCFG : 2;           /*!< [2..1] GPIO8 output configuration.                                        */
      __IOM uint32_t GPIO8INTD  : 1;            /*!< [3..3] GPIO8 interrupt direction, nCE polarity.                           */
      __IOM uint32_t GPIO9INCFG : 1;            /*!< [4..4] GPIO9 input enable.                                                */
      __IOM uint32_t GPIO9OUTCFG : 2;           /*!< [6..5] GPIO9 output configuration.                                        */
      __IOM uint32_t GPIO9INTD  : 1;            /*!< [7..7] GPIO9 interrupt direction, nCE polarity.                           */
      __IOM uint32_t GPIO10INCFG : 1;           /*!< [8..8] GPIO10 input enable.                                               */
      __IOM uint32_t GPIO10OUTCFG : 2;          /*!< [10..9] GPIO10 output configuration.                                      */
      __IOM uint32_t GPIO10INTD : 1;            /*!< [11..11] GPIO10 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO11INCFG : 1;           /*!< [12..12] GPIO11 input enable.                                             */
      __IOM uint32_t GPIO11OUTCFG : 2;          /*!< [14..13] GPIO11 output configuration.                                     */
      __IOM uint32_t GPIO11INTD : 1;            /*!< [15..15] GPIO11 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO12INCFG : 1;           /*!< [16..16] GPIO12 input enable.                                             */
      __IOM uint32_t GPIO12OUTCFG : 2;          /*!< [18..17] GPIO12 output configuration.                                     */
      __IOM uint32_t GPIO12INTD : 1;            /*!< [19..19] GPIO12 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO13INCFG : 1;           /*!< [20..20] GPIO13 input enable.                                             */
      __IOM uint32_t GPIO13OUTCFG : 2;          /*!< [22..21] GPIO13 output configuration.                                     */
      __IOM uint32_t GPIO13INTD : 1;            /*!< [23..23] GPIO13 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO14INCFG : 1;           /*!< [24..24] GPIO14 input enable.                                             */
      __IOM uint32_t GPIO14OUTCFG : 2;          /*!< [26..25] GPIO14 output configuration.                                     */
      __IOM uint32_t GPIO14INTD : 1;            /*!< [27..27] GPIO14 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO15INCFG : 1;           /*!< [28..28] GPIO15 input enable.                                             */
      __IOM uint32_t GPIO15OUTCFG : 2;          /*!< [30..29] GPIO15 output configuration.                                     */
      __IOM uint32_t GPIO15INTD : 1;            /*!< [31..31] GPIO15 interrupt direction, nCE polarity.                        */
    } CFGB_b;
  } ;

  union {
    __IOM uint32_t CFGC;                        /*!< (@ 0x00000054) GPIO Configuration Register C (Pads 23-16)                 */

    struct {
      __IOM uint32_t GPIO16INCFG : 1;           /*!< [0..0] GPIO16 input enable.                                               */
      __IOM uint32_t GPIO16OUTCFG : 2;          /*!< [2..1] GPIO16 output configuration.                                       */
      __IOM uint32_t GPIO16INTD : 1;            /*!< [3..3] GPIO16 interrupt direction, nCE polarity.                          */
      __IOM uint32_t GPIO17INCFG : 1;           /*!< [4..4] GPIO17 input enable.                                               */
      __IOM uint32_t GPIO17OUTCFG : 2;          /*!< [6..5] GPIO17 output configuration.                                       */
      __IOM uint32_t GPIO17INTD : 1;            /*!< [7..7] GPIO17 interrupt direction, nCE polarity.                          */
      __IOM uint32_t GPIO18INCFG : 1;           /*!< [8..8] GPIO18 input enable.                                               */
      __IOM uint32_t GPIO18OUTCFG : 2;          /*!< [10..9] GPIO18 output configuration.                                      */
      __IOM uint32_t GPIO18INTD : 1;            /*!< [11..11] GPIO18 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO19INCFG : 1;           /*!< [12..12] GPIO19 input enable.                                             */
      __IOM uint32_t GPIO19OUTCFG : 2;          /*!< [14..13] GPIO19 output configuration.                                     */
      __IOM uint32_t GPIO19INTD : 1;            /*!< [15..15] GPIO19 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO20INCFG : 1;           /*!< [16..16] GPIO20 input enable.                                             */
      __IOM uint32_t GPIO20OUTCFG : 2;          /*!< [18..17] GPIO20 output configuration.                                     */
      __IOM uint32_t GPIO20INTD : 1;            /*!< [19..19] GPIO20 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO21INCFG : 1;           /*!< [20..20] GPIO21 input enable.                                             */
      __IOM uint32_t GPIO21OUTCFG : 2;          /*!< [22..21] GPIO21 output configuration.                                     */
      __IOM uint32_t GPIO21INTD : 1;            /*!< [23..23] GPIO21 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO22INCFG : 1;           /*!< [24..24] GPIO22 input enable.                                             */
      __IOM uint32_t GPIO22OUTCFG : 2;          /*!< [26..25] GPIO22 output configuration.                                     */
      __IOM uint32_t GPIO22INTD : 1;            /*!< [27..27] GPIO22 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO23INCFG : 1;           /*!< [28..28] GPIO23 input enable.                                             */
      __IOM uint32_t GPIO23OUTCFG : 2;          /*!< [30..29] GPIO23 output configuration.                                     */
      __IOM uint32_t GPIO23INTD : 1;            /*!< [31..31] GPIO23 interrupt direction, nCE polarity.                        */
    } CFGC_b;
  } ;

  union {
    __IOM uint32_t CFGD;                        /*!< (@ 0x00000058) GPIO Configuration Register D (Pads 31-24)                 */

    struct {
      __IOM uint32_t GPIO24INCFG : 1;           /*!< [0..0] GPIO24 input enable.                                               */
      __IOM uint32_t GPIO24OUTCFG : 2;          /*!< [2..1] GPIO24 output configuration.                                       */
      __IOM uint32_t GPIO24INTD : 1;            /*!< [3..3] GPIO24 interrupt direction, nCE polarity.                          */
      __IOM uint32_t GPIO25INCFG : 1;           /*!< [4..4] GPIO25 input enable.                                               */
      __IOM uint32_t GPIO25OUTCFG : 2;          /*!< [6..5] GPIO25 output configuration.                                       */
      __IOM uint32_t GPIO25INTD : 1;            /*!< [7..7] GPIO25 interrupt direction, nCE polarity.                          */
      __IOM uint32_t GPIO26INCFG : 1;           /*!< [8..8] GPIO26 input enable.                                               */
      __IOM uint32_t GPIO26OUTCFG : 2;          /*!< [10..9] GPIO26 output configuration.                                      */
      __IOM uint32_t GPIO26INTD : 1;            /*!< [11..11] GPIO26 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO27INCFG : 1;           /*!< [12..12] GPIO27 input enable.                                             */
      __IOM uint32_t GPIO27OUTCFG : 2;          /*!< [14..13] GPIO27 output configuration.                                     */
      __IOM uint32_t GPIO27INTD : 1;            /*!< [15..15] GPIO27 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO28INCFG : 1;           /*!< [16..16] GPIO28 input enable.                                             */
      __IOM uint32_t GPIO28OUTCFG : 2;          /*!< [18..17] GPIO28 output configuration.                                     */
      __IOM uint32_t GPIO28INTD : 1;            /*!< [19..19] GPIO28 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO29INCFG : 1;           /*!< [20..20] GPIO29 input enable.                                             */
      __IOM uint32_t GPIO29OUTCFG : 2;          /*!< [22..21] GPIO29 output configuration.                                     */
      __IOM uint32_t GPIO29INTD : 1;            /*!< [23..23] GPIO29 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO30INCFG : 1;           /*!< [24..24] GPIO30 input enable.                                             */
      __IOM uint32_t GPIO30OUTCFG : 2;          /*!< [26..25] GPIO30 output configuration.                                     */
      __IOM uint32_t GPIO30INTD : 1;            /*!< [27..27] GPIO30 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO31INCFG : 1;           /*!< [28..28] GPIO31 input enable.                                             */
      __IOM uint32_t GPIO31OUTCFG : 2;          /*!< [30..29] GPIO31 output configuration.                                     */
      __IOM uint32_t GPIO31INTD : 1;            /*!< [31..31] GPIO31 interrupt direction, nCE polarity.                        */
    } CFGD_b;
  } ;

  union {
    __IOM uint32_t CFGE;                        /*!< (@ 0x0000005C) GPIO Configuration Register E (Pads 39-32)                 */

    struct {
      __IOM uint32_t GPIO32INCFG : 1;           /*!< [0..0] GPIO32 input enable.                                               */
      __IOM uint32_t GPIO32OUTCFG : 2;          /*!< [2..1] GPIO32 output configuration.                                       */
      __IOM uint32_t GPIO32INTD : 1;            /*!< [3..3] GPIO32 interrupt direction, nCE polarity.                          */
      __IOM uint32_t GPIO33INCFG : 1;           /*!< [4..4] GPIO33 input enable.                                               */
      __IOM uint32_t GPIO33OUTCFG : 2;          /*!< [6..5] GPIO33 output configuration.                                       */
      __IOM uint32_t GPIO33INTD : 1;            /*!< [7..7] GPIO33 interrupt direction, nCE polarity.                          */
      __IOM uint32_t GPIO34INCFG : 1;           /*!< [8..8] GPIO34 input enable.                                               */
      __IOM uint32_t GPIO34OUTCFG : 2;          /*!< [10..9] GPIO34 output configuration.                                      */
      __IOM uint32_t GPIO34INTD : 1;            /*!< [11..11] GPIO34 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO35INCFG : 1;           /*!< [12..12] GPIO35 input enable.                                             */
      __IOM uint32_t GPIO35OUTCFG : 2;          /*!< [14..13] GPIO35 output configuration.                                     */
      __IOM uint32_t GPIO35INTD : 1;            /*!< [15..15] GPIO35 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO36INCFG : 1;           /*!< [16..16] GPIO36 input enable.                                             */
      __IOM uint32_t GPIO36OUTCFG : 2;          /*!< [18..17] GPIO36 output configuration.                                     */
      __IOM uint32_t GPIO36INTD : 1;            /*!< [19..19] GPIO36 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO37INCFG : 1;           /*!< [20..20] GPIO37 input enable.                                             */
      __IOM uint32_t GPIO37OUTCFG : 2;          /*!< [22..21] GPIO37 output configuration.                                     */
      __IOM uint32_t GPIO37INTD : 1;            /*!< [23..23] GPIO37 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO38INCFG : 1;           /*!< [24..24] GPIO38 input enable.                                             */
      __IOM uint32_t GPIO38OUTCFG : 2;          /*!< [26..25] GPIO38 output configuration.                                     */
      __IOM uint32_t GPIO38INTD : 1;            /*!< [27..27] GPIO38 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO39INCFG : 1;           /*!< [28..28] GPIO39 input enable.                                             */
      __IOM uint32_t GPIO39OUTCFG : 2;          /*!< [30..29] GPIO39 output configuration.                                     */
      __IOM uint32_t GPIO39INTD : 1;            /*!< [31..31] GPIO39 interrupt direction, nCE polarity.                        */
    } CFGE_b;
  } ;

  union {
    __IOM uint32_t CFGF;                        /*!< (@ 0x00000060) GPIO Configuration Register F (Pads 47-40)                 */

    struct {
      __IOM uint32_t GPIO40INCFG : 1;           /*!< [0..0] GPIO40 input enable.                                               */
      __IOM uint32_t GPIO40OUTCFG : 2;          /*!< [2..1] GPIO40 output configuration.                                       */
      __IOM uint32_t GPIO40INTD : 1;            /*!< [3..3] GPIO40 interrupt direction, nCE polarity.                          */
      __IOM uint32_t GPIO41INCFG : 1;           /*!< [4..4] GPIO41 input enable.                                               */
      __IOM uint32_t GPIO41OUTCFG : 2;          /*!< [6..5] GPIO41 output configuration.                                       */
      __IOM uint32_t GPIO41INTD : 1;            /*!< [7..7] GPIO41 interrupt direction, nCE polarity.                          */
      __IOM uint32_t GPIO42INCFG : 1;           /*!< [8..8] GPIO42 input enable.                                               */
      __IOM uint32_t GPIO42OUTCFG : 2;          /*!< [10..9] GPIO42 output configuration.                                      */
      __IOM uint32_t GPIO42INTD : 1;            /*!< [11..11] GPIO42 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO43INCFG : 1;           /*!< [12..12] GPIO43 input enable.                                             */
      __IOM uint32_t GPIO43OUTCFG : 2;          /*!< [14..13] GPIO43 output configuration.                                     */
      __IOM uint32_t GPIO43INTD : 1;            /*!< [15..15] GPIO43 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO44INCFG : 1;           /*!< [16..16] GPIO44 input enable.                                             */
      __IOM uint32_t GPIO44OUTCFG : 2;          /*!< [18..17] GPIO44 output configuration.                                     */
      __IOM uint32_t GPIO44INTD : 1;            /*!< [19..19] GPIO44 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO45INCFG : 1;           /*!< [20..20] GPIO45 input enable.                                             */
      __IOM uint32_t GPIO45OUTCFG : 2;          /*!< [22..21] GPIO45 output configuration.                                     */
      __IOM uint32_t GPIO45INTD : 1;            /*!< [23..23] GPIO45 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO46INCFG : 1;           /*!< [24..24] GPIO46 input enable.                                             */
      __IOM uint32_t GPIO46OUTCFG : 2;          /*!< [26..25] GPIO46 output configuration.                                     */
      __IOM uint32_t GPIO46INTD : 1;            /*!< [27..27] GPIO46 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO47INCFG : 1;           /*!< [28..28] GPIO47 input enable.                                             */
      __IOM uint32_t GPIO47OUTCFG : 2;          /*!< [30..29] GPIO47 output configuration.                                     */
      __IOM uint32_t GPIO47INTD : 1;            /*!< [31..31] GPIO47 interrupt direction, nCE polarity.                        */
    } CFGF_b;
  } ;

  union {
    __IOM uint32_t CFGG;                        /*!< (@ 0x00000064) GPIO Configuration Register G (Pads 55-48)                 */

    struct {
      __IOM uint32_t GPIO48INCFG : 1;           /*!< [0..0] GPIO48 input enable.                                               */
      __IOM uint32_t GPIO48OUTCFG : 2;          /*!< [2..1] GPIO48 output configuration.                                       */
      __IOM uint32_t GPIO48INTD : 1;            /*!< [3..3] GPIO48 interrupt direction, nCE polarity.                          */
      __IOM uint32_t GPIO49INCFG : 1;           /*!< [4..4] GPIO49 input enable.                                               */
      __IOM uint32_t GPIO49OUTCFG : 2;          /*!< [6..5] GPIO49 output configuration.                                       */
      __IOM uint32_t GPIO49INTD : 1;            /*!< [7..7] GPIO49 interrupt direction, nCE polarity.                          */
      __IOM uint32_t GPIO50INCFG : 1;           /*!< [8..8] GPIO50 input enable.                                               */
      __IOM uint32_t GPIO50OUTCFG : 2;          /*!< [10..9] GPIO50 output configuration.                                      */
      __IOM uint32_t GPIO50INTD : 1;            /*!< [11..11] GPIO50 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO51INCFG : 1;           /*!< [12..12] GPIO51 input enable.                                             */
      __IOM uint32_t GPIO51OUTCFG : 2;          /*!< [14..13] GPIO51 output configuration.                                     */
      __IOM uint32_t GPIO51INTD : 1;            /*!< [15..15] GPIO51 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO52INCFG : 1;           /*!< [16..16] GPIO52 input enable.                                             */
      __IOM uint32_t GPIO52OUTCFG : 2;          /*!< [18..17] GPIO52 output configuration.                                     */
      __IOM uint32_t GPIO52INTD : 1;            /*!< [19..19] GPIO52 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO53INCFG : 1;           /*!< [20..20] GPIO53 input enable.                                             */
      __IOM uint32_t GPIO53OUTCFG : 2;          /*!< [22..21] GPIO53 output configuration.                                     */
      __IOM uint32_t GPIO53INTD : 1;            /*!< [23..23] GPIO53 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO54INCFG : 1;           /*!< [24..24] GPIO54 input enable.                                             */
      __IOM uint32_t GPIO54OUTCFG : 2;          /*!< [26..25] GPIO54 output configuration.                                     */
      __IOM uint32_t GPIO54INTD : 1;            /*!< [27..27] GPIO54 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO55INCFG : 1;           /*!< [28..28] GPIO55 input enable.                                             */
      __IOM uint32_t GPIO55OUTCFG : 2;          /*!< [30..29] GPIO55 output configuration.                                     */
      __IOM uint32_t GPIO55INTD : 1;            /*!< [31..31] GPIO55 interrupt direction, nCE polarity.                        */
    } CFGG_b;
  } ;

  union {
    __IOM uint32_t CFGH;                        /*!< (@ 0x00000068) GPIO Configuration Register H (Pads 63-56)                 */

    struct {
      __IOM uint32_t GPIO56INCFG : 1;           /*!< [0..0] GPIO56 input enable.                                               */
      __IOM uint32_t GPIO56OUTCFG : 2;          /*!< [2..1] GPIO56 output configuration.                                       */
      __IOM uint32_t GPIO56INTD : 1;            /*!< [3..3] GPIO56 interrupt direction, nCE polarity.                          */
      __IOM uint32_t GPIO57INCFG : 1;           /*!< [4..4] GPIO57 input enable.                                               */
      __IOM uint32_t GPIO57OUTCFG : 2;          /*!< [6..5] GPIO57 output configuration.                                       */
      __IOM uint32_t GPIO57INTD : 1;            /*!< [7..7] GPIO57 interrupt direction, nCE polarity.                          */
      __IOM uint32_t GPIO58INCFG : 1;           /*!< [8..8] GPIO58 input enable.                                               */
      __IOM uint32_t GPIO58OUTCFG : 2;          /*!< [10..9] GPIO58 output configuration.                                      */
      __IOM uint32_t GPIO58INTD : 1;            /*!< [11..11] GPIO58 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO59INCFG : 1;           /*!< [12..12] GPIO59 input enable.                                             */
      __IOM uint32_t GPIO59OUTCFG : 2;          /*!< [14..13] GPIO59 output configuration.                                     */
      __IOM uint32_t GPIO59INTD : 1;            /*!< [15..15] GPIO59 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO60INCFG : 1;           /*!< [16..16] GPIO60 input enable.                                             */
      __IOM uint32_t GPIO60OUTCFG : 2;          /*!< [18..17] GPIO60 output configuration.                                     */
      __IOM uint32_t GPIO60INTD : 1;            /*!< [19..19] GPIO60 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO61INCFG : 1;           /*!< [20..20] GPIO61 input enable.                                             */
      __IOM uint32_t GPIO61OUTCFG : 2;          /*!< [22..21] GPIO61 output configuration.                                     */
      __IOM uint32_t GPIO61INTD : 1;            /*!< [23..23] GPIO61 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO62INCFG : 1;           /*!< [24..24] GPIO62 input enable.                                             */
      __IOM uint32_t GPIO62OUTCFG : 2;          /*!< [26..25] GPIO62 output configuration.                                     */
      __IOM uint32_t GPIO62INTD : 1;            /*!< [27..27] GPIO62 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO63INCFG : 1;           /*!< [28..28] GPIO63 input enable.                                             */
      __IOM uint32_t GPIO63OUTCFG : 2;          /*!< [30..29] GPIO63 output configuration.                                     */
      __IOM uint32_t GPIO63INTD : 1;            /*!< [31..31] GPIO63 interrupt direction, nCE polarity.                        */
    } CFGH_b;
  } ;

  union {
    __IOM uint32_t CFGI;                        /*!< (@ 0x0000006C) GPIO Configuration Register I (Pads 71-64)                 */

    struct {
      __IOM uint32_t GPIO64INCFG : 1;           /*!< [0..0] GPIO64 input enable.                                               */
      __IOM uint32_t GPIO64OUTCFG : 2;          /*!< [2..1] GPIO64 output configuration.                                       */
      __IOM uint32_t GPIO64INTD : 1;            /*!< [3..3] GPIO64 interrupt direction, nCE polarity.                          */
      __IOM uint32_t GPIO65INCFG : 1;           /*!< [4..4] GPIO65 input enable.                                               */
      __IOM uint32_t GPIO65OUTCFG : 2;          /*!< [6..5] GPIO65 output configuration.                                       */
      __IOM uint32_t GPIO65INTD : 1;            /*!< [7..7] GPIO65 interrupt direction, nCE polarity.                          */
      __IOM uint32_t GPIO66INCFG : 1;           /*!< [8..8] GPIO66 input enable.                                               */
      __IOM uint32_t GPIO66OUTCFG : 2;          /*!< [10..9] GPIO66 output configuration.                                      */
      __IOM uint32_t GPIO66INTD : 1;            /*!< [11..11] GPIO66 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO67INCFG : 1;           /*!< [12..12] GPIO67 input enable.                                             */
      __IOM uint32_t GPIO67OUTCFG : 2;          /*!< [14..13] GPIO67 output configuration.                                     */
      __IOM uint32_t GPIO67INTD : 1;            /*!< [15..15] GPIO67 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO68INCFG : 1;           /*!< [16..16] GPIO68 input enable.                                             */
      __IOM uint32_t GPIO68OUTCFG : 2;          /*!< [18..17] GPIO68 output configuration.                                     */
      __IOM uint32_t GPIO68INTD : 1;            /*!< [19..19] GPIO68 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO69INCFG : 1;           /*!< [20..20] GPIO69 input enable.                                             */
      __IOM uint32_t GPIO69OUTCFG : 2;          /*!< [22..21] GPIO69 output configuration.                                     */
      __IOM uint32_t GPIO69INTD : 1;            /*!< [23..23] GPIO69 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO70INCFG : 1;           /*!< [24..24] GPIO70 input enable.                                             */
      __IOM uint32_t GPIO70OUTCFG : 2;          /*!< [26..25] GPIO70 output configuration.                                     */
      __IOM uint32_t GPIO70INTD : 1;            /*!< [27..27] GPIO70 interrupt direction, nCE polarity.                        */
      __IOM uint32_t GPIO71INCFG : 1;           /*!< [28..28] GPIO71 input enable.                                             */
      __IOM uint32_t GPIO71OUTCFG : 2;          /*!< [30..29] GPIO71 output configuration.                                     */
      __IOM uint32_t GPIO71INTD : 1;            /*!< [31..31] GPIO71 interrupt direction, nCE polarity.                        */
    } CFGI_b;
  } ;

  union {
    __IOM uint32_t CFGJ;                        /*!< (@ 0x00000070) GPIO Configuration Register J (Pads 79-72)                 */

    struct {
      __IOM uint32_t GPIO72INCFG : 1;           /*!< [0..0] GPIO72 input enable.                                               */
      __IOM uint32_t GPIO72OUTCFG : 2;          /*!< [2..1] GPIO72 output configuration.                                       */
      __IOM uint32_t GPIO72INTD : 1;            /*!< [3..3] GPIO72 interrupt direction, nCE polarity.                          */
      __IOM uint32_t GPIO73INCFG : 1;           /*!< [4..4] GPIO73 input enable.                                               */
      __IOM uint32_t GPIO73OUTCFG : 2;          /*!< [6..5] GPIO73 output configuration.                                       */
      __IOM uint32_t GPIO73INTD : 1;            /*!< [7..7] GPIO73 interrupt direction, nCE polarity.                          */
    } CFGJ_b;
  } ;

  union {
    __IOM uint32_t PADKEY;                      /*!< (@ 0x00000074) Key Register for all pad configuration registers           */

    struct {
      __IOM uint32_t PADKEY     : 32;           /*!< [31..0] Key register value.                                               */
    } PADKEY_b;
  } ;
  __IM  uint32_t  RESERVED[2];

  union {
    __IOM uint32_t RDA;                         /*!< (@ 0x00000080) GPIO Input Register A                                      */

    struct {
      __IOM uint32_t RDA        : 32;           /*!< [31..0] GPIO31-0 read data.                                               */
    } RDA_b;
  } ;

  union {
    __IOM uint32_t RDB;                         /*!< (@ 0x00000084) GPIO Input Register B                                      */

    struct {
      __IOM uint32_t RDB        : 32;           /*!< [31..0] GPIO63-32 read data.                                              */
    } RDB_b;
  } ;

  union {
    __IOM uint32_t RDC;                         /*!< (@ 0x00000088) GPIO Input Register C                                      */

    struct {
      __IOM uint32_t RDC        : 10;           /*!< [9..0] GPIO73-64 read data.                                               */
    } RDC_b;
  } ;

  union {
    __IOM uint32_t WTA;                         /*!< (@ 0x0000008C) GPIO Output Register A                                     */

    struct {
      __IOM uint32_t WTA        : 32;           /*!< [31..0] GPIO31-0 write data.                                              */
    } WTA_b;
  } ;

  union {
    __IOM uint32_t WTB;                         /*!< (@ 0x00000090) GPIO Output Register B                                     */

    struct {
      __IOM uint32_t WTB        : 32;           /*!< [31..0] GPIO63-32 write data.                                             */
    } WTB_b;
  } ;

  union {
    __IOM uint32_t WTC;                         /*!< (@ 0x00000094) GPIO Output Register C                                     */

    struct {
      __IOM uint32_t WTC        : 10;           /*!< [9..0] GPIO73-64 write data.                                              */
    } WTC_b;
  } ;

  union {
    __IOM uint32_t WTSA;                        /*!< (@ 0x00000098) GPIO Output Register A Set                                 */

    struct {
      __IOM uint32_t WTSA       : 32;           /*!< [31..0] Set the GPIO31-0 write data.                                      */
    } WTSA_b;
  } ;

  union {
    __IOM uint32_t WTSB;                        /*!< (@ 0x0000009C) GPIO Output Register B Set                                 */

    struct {
      __IOM uint32_t WTSB       : 32;           /*!< [31..0] Set the GPIO63-32 write data.                                     */
    } WTSB_b;
  } ;

  union {
    __IOM uint32_t WTSC;                        /*!< (@ 0x000000A0) GPIO Output Register C Set                                 */

    struct {
      __IOM uint32_t WTSC       : 10;           /*!< [9..0] Set the GPIO73-64 write data.                                      */
    } WTSC_b;
  } ;

  union {
    __IOM uint32_t WTCA;                        /*!< (@ 0x000000A4) GPIO Output Register A Clear                               */

    struct {
      __IOM uint32_t WTCA       : 32;           /*!< [31..0] Clear the GPIO31-0 write data.                                    */
    } WTCA_b;
  } ;

  union {
    __IOM uint32_t WTCB;                        /*!< (@ 0x000000A8) GPIO Output Register B Clear                               */

    struct {
      __IOM uint32_t WTCB       : 32;           /*!< [31..0] Clear the GPIO63-32 write data.                                   */
    } WTCB_b;
  } ;

  union {
    __IOM uint32_t WTCC;                        /*!< (@ 0x000000AC) GPIO Output Register C Clear                               */

    struct {
      __IOM uint32_t WTCB       : 10;           /*!< [9..0] Clear the GPIO73-64 write data.                                    */
    } WTCC_b;
  } ;

  union {
    __IOM uint32_t ENA;                         /*!< (@ 0x000000B0) GPIO Enable Register A                                     */

    struct {
      __IOM uint32_t ENA        : 32;           /*!< [31..0] GPIO31-0 output enables                                           */
    } ENA_b;
  } ;

  union {
    __IOM uint32_t ENB;                         /*!< (@ 0x000000B4) GPIO Enable Register B                                     */

    struct {
      __IOM uint32_t ENB        : 32;           /*!< [31..0] GPIO63-32 output enables                                          */
    } ENB_b;
  } ;

  union {
    __IOM uint32_t ENC;                         /*!< (@ 0x000000B8) GPIO Enable Register C                                     */

    struct {
      __IOM uint32_t ENC        : 10;           /*!< [9..0] GPIO73-64 output enables                                           */
    } ENC_b;
  } ;

  union {
    __IOM uint32_t ENSA;                        /*!< (@ 0x000000BC) GPIO Enable Register A Set                                 */

    struct {
      __IOM uint32_t ENSA       : 32;           /*!< [31..0] Set the GPIO31-0 output enables                                   */
    } ENSA_b;
  } ;

  union {
    __IOM uint32_t ENSB;                        /*!< (@ 0x000000C0) GPIO Enable Register B Set                                 */

    struct {
      __IOM uint32_t ENSB       : 32;           /*!< [31..0] Set the GPIO63-32 output enables                                  */
    } ENSB_b;
  } ;

  union {
    __IOM uint32_t ENSC;                        /*!< (@ 0x000000C4) GPIO Enable Register C Set                                 */

    struct {
      __IOM uint32_t ENSC       : 10;           /*!< [9..0] Set the GPIO73-64 output enables                                   */
    } ENSC_b;
  } ;

  union {
    __IOM uint32_t ENCA;                        /*!< (@ 0x000000C8) GPIO Enable Register A Clear                               */

    struct {
      __IOM uint32_t ENCA       : 32;           /*!< [31..0] Clear the GPIO31-0 output enables                                 */
    } ENCA_b;
  } ;

  union {
    __IOM uint32_t ENCB;                        /*!< (@ 0x000000CC) GPIO Enable Register B Clear                               */

    struct {
      __IOM uint32_t ENCB       : 32;           /*!< [31..0] Clear the GPIO49-32 output enables                                */
    } ENCB_b;
  } ;

  union {
    __IOM uint32_t ENCC;                        /*!< (@ 0x000000D0) GPIO Enable Register C Clear                               */

    struct {
      __IOM uint32_t ENCC       : 10;           /*!< [9..0] Clear the GPIO73-64 output enables                                 */
    } ENCC_b;
  } ;

  union {
    __IOM uint32_t STMRCAP;                     /*!< (@ 0x000000D4) STIMER Capture Control                                     */

    struct {
      __IOM uint32_t STSEL0     : 7;            /*!< [6..0] STIMER Capture 0 Select.                                           */
      __IOM uint32_t STPOL0     : 1;            /*!< [7..7] STIMER Capture 0 Polarity.                                         */
      __IOM uint32_t STSEL1     : 7;            /*!< [14..8] STIMER Capture 1 Select.                                          */
      __IOM uint32_t STPOL1     : 1;            /*!< [15..15] STIMER Capture 1 Polarity.                                       */
      __IOM uint32_t STSEL2     : 7;            /*!< [22..16] STIMER Capture 2 Select.                                         */
      __IOM uint32_t STPOL2     : 1;            /*!< [23..23] STIMER Capture 2 Polarity.                                       */
      __IOM uint32_t STSEL3     : 7;            /*!< [30..24] STIMER Capture 3 Select.                                         */
      __IOM uint32_t STPOL3     : 1;            /*!< [31..31] STIMER Capture 3 Polarity.                                       */
    } STMRCAP_b;
  } ;

  union {
    __IOM uint32_t IOM0IRQ;                     /*!< (@ 0x000000D8) IOM0 Flow Control IRQ Select                               */

    struct {
      __IOM uint32_t IOM0IRQ    : 7;            /*!< [6..0] IOMSTR0 IRQ pad select.                                            */
    } IOM0IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM1IRQ;                     /*!< (@ 0x000000DC) IOM1 Flow Control IRQ Select                               */

    struct {
      __IOM uint32_t IOM1IRQ    : 7;            /*!< [6..0] IOMSTR1 IRQ pad select.                                            */
    } IOM1IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM2IRQ;                     /*!< (@ 0x000000E0) IOM2 Flow Control IRQ Select                               */

    struct {
      __IOM uint32_t IOM2IRQ    : 7;            /*!< [6..0] IOMSTR2 IRQ pad select.                                            */
    } IOM2IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM3IRQ;                     /*!< (@ 0x000000E4) IOM3 Flow Control IRQ Select                               */

    struct {
      __IOM uint32_t IOM3IRQ    : 7;            /*!< [6..0] IOMSTR3 IRQ pad select.                                            */
    } IOM3IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM4IRQ;                     /*!< (@ 0x000000E8) IOM4 Flow Control IRQ Select                               */

    struct {
      __IOM uint32_t IOM4IRQ    : 7;            /*!< [6..0] IOMSTR4 IRQ pad select.                                            */
    } IOM4IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM5IRQ;                     /*!< (@ 0x000000EC) IOM5 Flow Control IRQ Select                               */

    struct {
      __IOM uint32_t IOM5IRQ    : 7;            /*!< [6..0] IOMSTR5 IRQ pad select.                                            */
    } IOM5IRQ_b;
  } ;

  union {
    __IOM uint32_t BLEIFIRQ;                    /*!< (@ 0x000000F0) BLEIF Flow Control IRQ Select                              */

    struct {
      __IOM uint32_t BLEIFIRQ   : 7;            /*!< [6..0] BLEIF IRQ pad select.                                              */
    } BLEIFIRQ_b;
  } ;

  union {
    __IOM uint32_t GPIOOBS;                     /*!< (@ 0x000000F4) GPIO Observation Mode Sample register                      */

    struct {
      __IOM uint32_t OBS_DATA   : 16;           /*!< [15..0] Sample of the data output on the GPIO observation port.
                                                     May have async sampling issues, as the data is not synronized
                                                     to the read operation. Intended for debug purposes only                   */
    } GPIOOBS_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGA;                  /*!< (@ 0x000000F8) Alternate Pad Configuration reg0 (Pads 3-0)                */

    struct {
      __IOM uint32_t PAD0_DS1   : 1;            /*!< [0..0] Pad 0 high order drive strength selection. Used in conjunction
                                                     with PAD0STRNG field to set the pad drive strength.                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD0_SR    : 1;            /*!< [4..4] Pad 3 slew rate selection.                                         */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD1_DS1   : 1;            /*!< [8..8] Pad 1 high order drive strength selection. Used in conjunction
                                                     with PAD1STRNG field to set the pad drive strength.                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD1_SR    : 1;            /*!< [12..12] Pad 3 slew rate selection.                                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD2_DS1   : 1;            /*!< [16..16] Pad 2 high order drive strength selection. Used in
                                                     conjunction with PAD2STRNG field to set the pad drive strength.           */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD2_SR    : 1;            /*!< [20..20] Pad 3 slew rate selection.                                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD3_DS1   : 1;            /*!< [24..24] Pad 3 high order drive strength selection. Used in
                                                     conjunction with PAD3STRNG field to set the pad drive strength.           */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD3_SR    : 1;            /*!< [28..28] Pad 3 slew rate selection.                                       */
    } ALTPADCFGA_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGB;                  /*!< (@ 0x000000FC) Alternate Pad Configuration reg0 (Pads 7-4)                */

    struct {
      __IOM uint32_t PAD4_DS1   : 1;            /*!< [0..0] Pad 4 high order drive strength selection. Used in conjunction
                                                     with PAD4STRNG field to set the pad drive strength.                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD4_SR    : 1;            /*!< [4..4] Pad 7 slew rate selection.                                         */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD5_DS1   : 1;            /*!< [8..8] Pad 5 high order drive strength selection. Used in conjunction
                                                     with PAD5STRNG field to set the pad drive strength.                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD5_SR    : 1;            /*!< [12..12] Pad 7 slew rate selection.                                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD6_DS1   : 1;            /*!< [16..16] Pad 6 high order drive strength selection. Used in
                                                     conjunction with PAD6STRNG field to set the pad drive strength.           */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD6_SR    : 1;            /*!< [20..20] Pad 7 slew rate selection.                                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD7_DS1   : 1;            /*!< [24..24] Pad 7 high order drive strength selection. Used in
                                                     conjunction with PAD7STRNG field to set the pad drive strength.           */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD7_SR    : 1;            /*!< [28..28] Pad 7 slew rate selection.                                       */
    } ALTPADCFGB_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGC;                  /*!< (@ 0x00000100) Alternate Pad Configuration reg0 (Pads 11-8)               */

    struct {
      __IOM uint32_t PAD8_DS1   : 1;            /*!< [0..0] Pad 8 high order drive strength selection. Used in conjunction
                                                     with PAD8STRNG field to set the pad drive strength.                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD8_SR    : 1;            /*!< [4..4] Pad 11 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD9_DS1   : 1;            /*!< [8..8] Pad 9 high order drive strength selection. Used in conjunction
                                                     with PAD9STRNG field to set the pad drive strength.                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD9_SR    : 1;            /*!< [12..12] Pad 11 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD10_DS1  : 1;            /*!< [16..16] Pad 10 high order drive strength selection. Used in
                                                     conjunction with PAD10STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD10_SR   : 1;            /*!< [20..20] Pad 11 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD11_DS1  : 1;            /*!< [24..24] Pad 11 high order drive strength selection. Used in
                                                     conjunction with PAD11STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD11_SR   : 1;            /*!< [28..28] Pad 11 slew rate selection.                                      */
    } ALTPADCFGC_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGD;                  /*!< (@ 0x00000104) Alternate Pad Configuration reg0 (Pads 15-12)              */

    struct {
      __IOM uint32_t PAD12_DS1  : 1;            /*!< [0..0] Pad 12 high order drive strength selection. Used in conjunction
                                                     with PAD12STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD12_SR   : 1;            /*!< [4..4] Pad 15 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD13_DS1  : 1;            /*!< [8..8] Pad 13 high order drive strength selection. Used in conjunction
                                                     with PAD13STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD13_SR   : 1;            /*!< [12..12] Pad 15 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD14_DS1  : 1;            /*!< [16..16] Pad 14 high order drive strength selection. Used in
                                                     conjunction with PAD14STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD14_SR   : 1;            /*!< [20..20] Pad 15 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD15_DS1  : 1;            /*!< [24..24] Pad 15 high order drive strength selection. Used in
                                                     conjunction with PAD15STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD15_SR   : 1;            /*!< [28..28] Pad 15 slew rate selection.                                      */
    } ALTPADCFGD_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGE;                  /*!< (@ 0x00000108) Alternate Pad Configuration reg0 (Pads 19-16)              */

    struct {
      __IOM uint32_t PAD16_DS1  : 1;            /*!< [0..0] Pad 16 high order drive strength selection. Used in conjunction
                                                     with PAD16STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD16_SR   : 1;            /*!< [4..4] Pad 19 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD17_DS1  : 1;            /*!< [8..8] Pad 17 high order drive strength selection. Used in conjunction
                                                     with PAD17STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD17_SR   : 1;            /*!< [12..12] Pad 19 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD18_DS1  : 1;            /*!< [16..16] Pad 18 high order drive strength selection. Used in
                                                     conjunction with PAD18STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD18_SR   : 1;            /*!< [20..20] Pad 19 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD19_DS1  : 1;            /*!< [24..24] Pad 19 high order drive strength selection. Used in
                                                     conjunction with PAD19STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD19_SR   : 1;            /*!< [28..28] Pad 19 slew rate selection.                                      */
    } ALTPADCFGE_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGF;                  /*!< (@ 0x0000010C) Alternate Pad Configuration reg0 (Pads 23-20)              */

    struct {
      __IOM uint32_t PAD20_DS1  : 1;            /*!< [0..0] Pad 20 high order drive strength selection. Used in conjunction
                                                     with PAD20STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD20_SR   : 1;            /*!< [4..4] Pad 23 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD21_DS1  : 1;            /*!< [8..8] Pad 21 high order drive strength selection. Used in conjunction
                                                     with PAD21STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD21_SR   : 1;            /*!< [12..12] Pad 23 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD22_DS1  : 1;            /*!< [16..16] Pad 22 high order drive strength selection. Used in
                                                     conjunction with PAD22STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD22_SR   : 1;            /*!< [20..20] Pad 23 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD23_DS1  : 1;            /*!< [24..24] Pad 23 high order drive strength selection. Used in
                                                     conjunction with PAD23STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD23_SR   : 1;            /*!< [28..28] Pad 23 slew rate selection.                                      */
    } ALTPADCFGF_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGG;                  /*!< (@ 0x00000110) Alternate Pad Configuration reg0 (Pads 27-24)              */

    struct {
      __IOM uint32_t PAD24_DS1  : 1;            /*!< [0..0] Pad 24 high order drive strength selection. Used in conjunction
                                                     with PAD24STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD24_SR   : 1;            /*!< [4..4] Pad 27 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD25_DS1  : 1;            /*!< [8..8] Pad 25 high order drive strength selection. Used in conjunction
                                                     with PAD25STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD25_SR   : 1;            /*!< [12..12] Pad 27 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD26_DS1  : 1;            /*!< [16..16] Pad 26 high order drive strength selection. Used in
                                                     conjunction with PAD26STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD26_SR   : 1;            /*!< [20..20] Pad 27 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD27_DS1  : 1;            /*!< [24..24] Pad 27 high order drive strength selection. Used in
                                                     conjunction with PAD27STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD27_SR   : 1;            /*!< [28..28] Pad 27 slew rate selection.                                      */
    } ALTPADCFGG_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGH;                  /*!< (@ 0x00000114) Alternate Pad Configuration reg0 (Pads 31-28)              */

    struct {
      __IOM uint32_t PAD28_DS1  : 1;            /*!< [0..0] Pad 28 high order drive strength selection. Used in conjunction
                                                     with PAD28STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD28_SR   : 1;            /*!< [4..4] Pad 31 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD29_DS1  : 1;            /*!< [8..8] Pad 29 high order drive strength selection. Used in conjunction
                                                     with PAD29STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD29_SR   : 1;            /*!< [12..12] Pad 31 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD30_DS1  : 1;            /*!< [16..16] Pad 30 high order drive strength selection. Used in
                                                     conjunction with PAD30STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD30_SR   : 1;            /*!< [20..20] Pad 31 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD31_DS1  : 1;            /*!< [24..24] Pad 31 high order drive strength selection. Used in
                                                     conjunction with PAD31STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD31_SR   : 1;            /*!< [28..28] Pad 31 slew rate selection.                                      */
    } ALTPADCFGH_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGI;                  /*!< (@ 0x00000118) Alternate Pad Configuration reg0 (Pads 35-32)              */

    struct {
      __IOM uint32_t PAD32_DS1  : 1;            /*!< [0..0] Pad 32 high order drive strength selection. Used in conjunction
                                                     with PAD32STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD32_SR   : 1;            /*!< [4..4] Pad 35 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD33_DS1  : 1;            /*!< [8..8] Pad 33 high order drive strength selection. Used in conjunction
                                                     with PAD33STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD33_SR   : 1;            /*!< [12..12] Pad 35 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD34_DS1  : 1;            /*!< [16..16] Pad 34 high order drive strength selection. Used in
                                                     conjunction with PAD34STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD34_SR   : 1;            /*!< [20..20] Pad 35 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD35_DS1  : 1;            /*!< [24..24] Pad 35 high order drive strength selection. Used in
                                                     conjunction with PAD35STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD35_SR   : 1;            /*!< [28..28] Pad 35 slew rate selection.                                      */
    } ALTPADCFGI_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGJ;                  /*!< (@ 0x0000011C) Alternate Pad Configuration reg0 (Pads 39-36)              */

    struct {
      __IOM uint32_t PAD36_DS1  : 1;            /*!< [0..0] Pad 36 high order drive strength selection. Used in conjunction
                                                     with PAD36STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD36_SR   : 1;            /*!< [4..4] Pad 39 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD37_DS1  : 1;            /*!< [8..8] Pad 37 high order drive strength selection. Used in conjunction
                                                     with PAD37STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD37_SR   : 1;            /*!< [12..12] Pad 39 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD38_DS1  : 1;            /*!< [16..16] Pad 38 high order drive strength selection. Used in
                                                     conjunction with PAD38STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD38_SR   : 1;            /*!< [20..20] Pad 39 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD39_DS1  : 1;            /*!< [24..24] Pad 39 high order drive strength selection. Used in
                                                     conjunction with PAD39STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD39_SR   : 1;            /*!< [28..28] Pad 39 slew rate selection.                                      */
    } ALTPADCFGJ_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGK;                  /*!< (@ 0x00000120) Alternate Pad Configuration reg0 (Pads 43-40)              */

    struct {
      __IOM uint32_t PAD40_DS1  : 1;            /*!< [0..0] Pad 40 high order drive strength selection. Used in conjunction
                                                     with PAD40STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD40_SR   : 1;            /*!< [4..4] Pad 43 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD41_DS1  : 1;            /*!< [8..8] Pad 41 high order drive strength selection. Used in conjunction
                                                     with PAD41STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD41_SR   : 1;            /*!< [12..12] Pad 43 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD42_DS1  : 1;            /*!< [16..16] Pad 42 high order drive strength selection. Used in
                                                     conjunction with PAD42STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD42_SR   : 1;            /*!< [20..20] Pad 43 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD43_DS1  : 1;            /*!< [24..24] Pad 43 high order drive strength selection. Used in
                                                     conjunction with PAD43STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD43_SR   : 1;            /*!< [28..28] Pad 43 slew rate selection.                                      */
    } ALTPADCFGK_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGL;                  /*!< (@ 0x00000124) Alternate Pad Configuration reg0 (Pads 47-44)              */

    struct {
      __IOM uint32_t PAD44_DS1  : 1;            /*!< [0..0] Pad 44 high order drive strength selection. Used in conjunction
                                                     with PAD44STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD44_SR   : 1;            /*!< [4..4] Pad 47 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD45_DS1  : 1;            /*!< [8..8] Pad 45 high order drive strength selection. Used in conjunction
                                                     with PAD45STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD45_SR   : 1;            /*!< [12..12] Pad 47 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD46_DS1  : 1;            /*!< [16..16] Pad 46 high order drive strength selection. Used in
                                                     conjunction with PAD46STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD46_SR   : 1;            /*!< [20..20] Pad 47 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD47_DS1  : 1;            /*!< [24..24] Pad 47 high order drive strength selection. Used in
                                                     conjunction with PAD47STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD47_SR   : 1;            /*!< [28..28] Pad 47 slew rate selection.                                      */
    } ALTPADCFGL_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGM;                  /*!< (@ 0x00000128) Alternate Pad Configuration reg0 (Pads 51-48)              */

    struct {
      __IOM uint32_t PAD48_DS1  : 1;            /*!< [0..0] Pad 48 high order drive strength selection. Used in conjunction
                                                     with PAD48STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD48_SR   : 1;            /*!< [4..4] Pad 51 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD49_DS1  : 1;            /*!< [8..8] Pad 49 high order drive strength selection. Used in conjunction
                                                     with PAD49STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD49_SR   : 1;            /*!< [12..12] Pad 51 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD50_DS1  : 1;            /*!< [16..16] Pad 50 high order drive strength selection. Used in
                                                     conjunction with PAD50STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD50_SR   : 1;            /*!< [20..20] Pad 51 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD51_DS1  : 1;            /*!< [24..24] Pad 51 high order drive strength selection. Used in
                                                     conjunction with PAD51STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD51_SR   : 1;            /*!< [28..28] Pad 51 slew rate selection.                                      */
    } ALTPADCFGM_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGN;                  /*!< (@ 0x0000012C) Alternate Pad Configuration reg0 (Pads 55-52)              */

    struct {
      __IOM uint32_t PAD52_DS1  : 1;            /*!< [0..0] Pad 52 high order drive strength selection. Used in conjunction
                                                     with PAD52STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD52_SR   : 1;            /*!< [4..4] Pad 55 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD53_DS1  : 1;            /*!< [8..8] Pad 53 high order drive strength selection. Used in conjunction
                                                     with PAD53STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD53_SR   : 1;            /*!< [12..12] Pad 55 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD54_DS1  : 1;            /*!< [16..16] Pad 54 high order drive strength selection. Used in
                                                     conjunction with PAD54STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD54_SR   : 1;            /*!< [20..20] Pad 55 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD55_DS1  : 1;            /*!< [24..24] Pad 55 high order drive strength selection. Used in
                                                     conjunction with PAD55STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD55_SR   : 1;            /*!< [28..28] Pad 55 slew rate selection.                                      */
    } ALTPADCFGN_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGO;                  /*!< (@ 0x00000130) Alternate Pad Configuration reg0 (Pads 59-56)              */

    struct {
      __IOM uint32_t PAD56_DS1  : 1;            /*!< [0..0] Pad 56 high order drive strength selection. Used in conjunction
                                                     with PAD56STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD56_SR   : 1;            /*!< [4..4] Pad 59 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD57_DS1  : 1;            /*!< [8..8] Pad 57 high order drive strength selection. Used in conjunction
                                                     with PAD57STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD57_SR   : 1;            /*!< [12..12] Pad 59 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD58_DS1  : 1;            /*!< [16..16] Pad 58 high order drive strength selection. Used in
                                                     conjunction with PAD58STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD58_SR   : 1;            /*!< [20..20] Pad 59 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD59_DS1  : 1;            /*!< [24..24] Pad 59 high order drive strength selection. Used in
                                                     conjunction with PAD59STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD59_SR   : 1;            /*!< [28..28] Pad 59 slew rate selection.                                      */
    } ALTPADCFGO_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGP;                  /*!< (@ 0x00000134) Alternate Pad Configuration reg0 (Pads 63-60)              */

    struct {
      __IOM uint32_t PAD60_DS1  : 1;            /*!< [0..0] Pad 60 high order drive strength selection. Used in conjunction
                                                     with PAD60STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD60_SR   : 1;            /*!< [4..4] Pad 63 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD61_DS1  : 1;            /*!< [8..8] Pad 61 high order drive strength selection. Used in conjunction
                                                     with PAD61STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD61_SR   : 1;            /*!< [12..12] Pad 63 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD62_DS1  : 1;            /*!< [16..16] Pad 62 high order drive strength selection. Used in
                                                     conjunction with PAD62STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD62_SR   : 1;            /*!< [20..20] Pad 63 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD63_DS1  : 1;            /*!< [24..24] Pad 63 high order drive strength selection. Used in
                                                     conjunction with PAD63STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD63_SR   : 1;            /*!< [28..28] Pad 63 slew rate selection.                                      */
    } ALTPADCFGP_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGQ;                  /*!< (@ 0x00000138) Alternate Pad Configuration reg0 (Pads 67-64)              */

    struct {
      __IOM uint32_t PAD64_DS1  : 1;            /*!< [0..0] Pad 64 high order drive strength selection. Used in conjunction
                                                     with PAD64STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD64_SR   : 1;            /*!< [4..4] Pad 67 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD65_DS1  : 1;            /*!< [8..8] Pad 65 high order drive strength selection. Used in conjunction
                                                     with PAD65STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD65_SR   : 1;            /*!< [12..12] Pad 67 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD66_DS1  : 1;            /*!< [16..16] Pad 66 high order drive strength selection. Used in
                                                     conjunction with PAD66STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD66_SR   : 1;            /*!< [20..20] Pad 67 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD67_DS1  : 1;            /*!< [24..24] Pad 67 high order drive strength selection. Used in
                                                     conjunction with PAD67STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD67_SR   : 1;            /*!< [28..28] Pad 67 slew rate selection.                                      */
    } ALTPADCFGQ_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGR;                  /*!< (@ 0x0000013C) Alternate Pad Configuration reg0 (Pads 71-68)              */

    struct {
      __IOM uint32_t PAD68_DS1  : 1;            /*!< [0..0] Pad 68 high order drive strength selection. Used in conjunction
                                                     with PAD68STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD68_SR   : 1;            /*!< [4..4] Pad 71 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD69_DS1  : 1;            /*!< [8..8] Pad 69 high order drive strength selection. Used in conjunction
                                                     with PAD69STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD69_SR   : 1;            /*!< [12..12] Pad 71 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD70_DS1  : 1;            /*!< [16..16] Pad 70 high order drive strength selection. Used in
                                                     conjunction with PAD70STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD70_SR   : 1;            /*!< [20..20] Pad 71 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD71_DS1  : 1;            /*!< [24..24] Pad 71 high order drive strength selection. Used in
                                                     conjunction with PAD71STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD71_SR   : 1;            /*!< [28..28] Pad 71 slew rate selection.                                      */
    } ALTPADCFGR_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGS;                  /*!< (@ 0x00000140) Alternate Pad Configuration reg0 (Pads 75-72)              */

    struct {
      __IOM uint32_t PAD72_DS1  : 1;            /*!< [0..0] Pad 72 high order drive strength selection. Used in conjunction
                                                     with PAD72STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD72_SR   : 1;            /*!< [4..4] Pad 75 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD73_DS1  : 1;            /*!< [8..8] Pad 73 high order drive strength selection. Used in conjunction
                                                     with PAD73STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD73_SR   : 1;            /*!< [12..12] Pad 75 slew rate selection.                                      */
    } ALTPADCFGS_b;
  } ;

  union {
    __IOM uint32_t SCDET;                       /*!< (@ 0x00000144) SCARD Card Detect select                                   */

    struct {
      __IOM uint32_t SCDET      : 7;            /*!< [6..0] SCARD card detect pad select.                                      */
    } SCDET_b;
  } ;

  union {
    __IOM uint32_t CTENCFG;                     /*!< (@ 0x00000148) Counter/Timer Enable Config                                */

    struct {
      __IOM uint32_t EN0        : 1;            /*!< [0..0] CT0 Enable                                                         */
      __IOM uint32_t EN1        : 1;            /*!< [1..1] CT1 Enable                                                         */
      __IOM uint32_t EN2        : 1;            /*!< [2..2] CT2 Enable                                                         */
      __IOM uint32_t EN3        : 1;            /*!< [3..3] CT3 Enable                                                         */
      __IOM uint32_t EN4        : 1;            /*!< [4..4] CT4 Enable                                                         */
      __IOM uint32_t EN5        : 1;            /*!< [5..5] CT5 Enable                                                         */
      __IOM uint32_t EN6        : 1;            /*!< [6..6] CT6 Enable                                                         */
      __IOM uint32_t EN7        : 1;            /*!< [7..7] CT7 Enable                                                         */
      __IOM uint32_t EN8        : 1;            /*!< [8..8] CT8 Enable                                                         */
      __IOM uint32_t EN9        : 1;            /*!< [9..9] CT9 Enable                                                         */
      __IOM uint32_t EN10       : 1;            /*!< [10..10] CT10 Enable                                                      */
      __IOM uint32_t EN11       : 1;            /*!< [11..11] CT11 Enable                                                      */
      __IOM uint32_t EN12       : 1;            /*!< [12..12] CT12 Enable                                                      */
      __IOM uint32_t EN13       : 1;            /*!< [13..13] CT13 Enable                                                      */
      __IOM uint32_t EN14       : 1;            /*!< [14..14] CT14 Enable                                                      */
      __IOM uint32_t EN15       : 1;            /*!< [15..15] CT15 Enable                                                      */
      __IOM uint32_t EN16       : 1;            /*!< [16..16] CT16 Enable                                                      */
      __IOM uint32_t EN17       : 1;            /*!< [17..17] CT17 Enable                                                      */
      __IOM uint32_t EN18       : 1;            /*!< [18..18] CT18 Enable                                                      */
      __IOM uint32_t EN19       : 1;            /*!< [19..19] CT19 Enable                                                      */
      __IOM uint32_t EN20       : 1;            /*!< [20..20] CT20 Enable                                                      */
      __IOM uint32_t EN21       : 1;            /*!< [21..21] CT21 Enable                                                      */
      __IOM uint32_t EN22       : 1;            /*!< [22..22] CT22 Enable                                                      */
      __IOM uint32_t EN23       : 1;            /*!< [23..23] CT23 Enable                                                      */
      __IOM uint32_t EN24       : 1;            /*!< [24..24] CT24 Enable                                                      */
      __IOM uint32_t EN25       : 1;            /*!< [25..25] CT25 Enable                                                      */
      __IOM uint32_t EN26       : 1;            /*!< [26..26] CT26 Enable                                                      */
      __IOM uint32_t EN27       : 1;            /*!< [27..27] CT27 Enable                                                      */
      __IOM uint32_t EN28       : 1;            /*!< [28..28] CT28 Enable                                                      */
      __IOM uint32_t EN29       : 1;            /*!< [29..29] CT29 Enable                                                      */
      __IOM uint32_t EN30       : 1;            /*!< [30..30] CT30 Enable                                                      */
      __IOM uint32_t EN31       : 1;            /*!< [31..31] CT31 Enable                                                      */
    } CTENCFG_b;
  } ;
  __IM  uint32_t  RESERVED1[45];

  union {
    __IOM uint32_t INT0EN;                      /*!< (@ 0x00000200) GPIO Interrupt Registers 31-0: Enable                      */

    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< [0..0] GPIO0 interrupt.                                                   */
      __IOM uint32_t GPIO1      : 1;            /*!< [1..1] GPIO1 interrupt.                                                   */
      __IOM uint32_t GPIO2      : 1;            /*!< [2..2] GPIO2 interrupt.                                                   */
      __IOM uint32_t GPIO3      : 1;            /*!< [3..3] GPIO3 interrupt.                                                   */
      __IOM uint32_t GPIO4      : 1;            /*!< [4..4] GPIO4 interrupt.                                                   */
      __IOM uint32_t GPIO5      : 1;            /*!< [5..5] GPIO5 interrupt.                                                   */
      __IOM uint32_t GPIO6      : 1;            /*!< [6..6] GPIO6 interrupt.                                                   */
      __IOM uint32_t GPIO7      : 1;            /*!< [7..7] GPIO7 interrupt.                                                   */
      __IOM uint32_t GPIO8      : 1;            /*!< [8..8] GPIO8 interrupt.                                                   */
      __IOM uint32_t GPIO9      : 1;            /*!< [9..9] GPIO9 interrupt.                                                   */
      __IOM uint32_t GPIO10     : 1;            /*!< [10..10] GPIO10 interrupt.                                                */
      __IOM uint32_t GPIO11     : 1;            /*!< [11..11] GPIO11 interrupt.                                                */
      __IOM uint32_t GPIO12     : 1;            /*!< [12..12] GPIO12 interrupt.                                                */
      __IOM uint32_t GPIO13     : 1;            /*!< [13..13] GPIO13 interrupt.                                                */
      __IOM uint32_t GPIO14     : 1;            /*!< [14..14] GPIO14 interrupt.                                                */
      __IOM uint32_t GPIO15     : 1;            /*!< [15..15] GPIO15 interrupt.                                                */
      __IOM uint32_t GPIO16     : 1;            /*!< [16..16] GPIO16 interrupt.                                                */
      __IOM uint32_t GPIO17     : 1;            /*!< [17..17] GPIO17 interrupt.                                                */
      __IOM uint32_t GPIO18     : 1;            /*!< [18..18] GPIO18interrupt.                                                 */
      __IOM uint32_t GPIO19     : 1;            /*!< [19..19] GPIO19 interrupt.                                                */
      __IOM uint32_t GPIO20     : 1;            /*!< [20..20] GPIO20 interrupt.                                                */
      __IOM uint32_t GPIO21     : 1;            /*!< [21..21] GPIO21 interrupt.                                                */
      __IOM uint32_t GPIO22     : 1;            /*!< [22..22] GPIO22 interrupt.                                                */
      __IOM uint32_t GPIO23     : 1;            /*!< [23..23] GPIO23 interrupt.                                                */
      __IOM uint32_t GPIO24     : 1;            /*!< [24..24] GPIO24 interrupt.                                                */
      __IOM uint32_t GPIO25     : 1;            /*!< [25..25] GPIO25 interrupt.                                                */
      __IOM uint32_t GPIO26     : 1;            /*!< [26..26] GPIO26 interrupt.                                                */
      __IOM uint32_t GPIO27     : 1;            /*!< [27..27] GPIO27 interrupt.                                                */
      __IOM uint32_t GPIO28     : 1;            /*!< [28..28] GPIO28 interrupt.                                                */
      __IOM uint32_t GPIO29     : 1;            /*!< [29..29] GPIO29 interrupt.                                                */
      __IOM uint32_t GPIO30     : 1;            /*!< [30..30] GPIO30 interrupt.                                                */
      __IOM uint32_t GPIO31     : 1;            /*!< [31..31] GPIO31 interrupt.                                                */
    } INT0EN_b;
  } ;

  union {
    __IOM uint32_t INT0STAT;                    /*!< (@ 0x00000204) GPIO Interrupt Registers 31-0: Status                      */

    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< [0..0] GPIO0 interrupt.                                                   */
      __IOM uint32_t GPIO1      : 1;            /*!< [1..1] GPIO1 interrupt.                                                   */
      __IOM uint32_t GPIO2      : 1;            /*!< [2..2] GPIO2 interrupt.                                                   */
      __IOM uint32_t GPIO3      : 1;            /*!< [3..3] GPIO3 interrupt.                                                   */
      __IOM uint32_t GPIO4      : 1;            /*!< [4..4] GPIO4 interrupt.                                                   */
      __IOM uint32_t GPIO5      : 1;            /*!< [5..5] GPIO5 interrupt.                                                   */
      __IOM uint32_t GPIO6      : 1;            /*!< [6..6] GPIO6 interrupt.                                                   */
      __IOM uint32_t GPIO7      : 1;            /*!< [7..7] GPIO7 interrupt.                                                   */
      __IOM uint32_t GPIO8      : 1;            /*!< [8..8] GPIO8 interrupt.                                                   */
      __IOM uint32_t GPIO9      : 1;            /*!< [9..9] GPIO9 interrupt.                                                   */
      __IOM uint32_t GPIO10     : 1;            /*!< [10..10] GPIO10 interrupt.                                                */
      __IOM uint32_t GPIO11     : 1;            /*!< [11..11] GPIO11 interrupt.                                                */
      __IOM uint32_t GPIO12     : 1;            /*!< [12..12] GPIO12 interrupt.                                                */
      __IOM uint32_t GPIO13     : 1;            /*!< [13..13] GPIO13 interrupt.                                                */
      __IOM uint32_t GPIO14     : 1;            /*!< [14..14] GPIO14 interrupt.                                                */
      __IOM uint32_t GPIO15     : 1;            /*!< [15..15] GPIO15 interrupt.                                                */
      __IOM uint32_t GPIO16     : 1;            /*!< [16..16] GPIO16 interrupt.                                                */
      __IOM uint32_t GPIO17     : 1;            /*!< [17..17] GPIO17 interrupt.                                                */
      __IOM uint32_t GPIO18     : 1;            /*!< [18..18] GPIO18interrupt.                                                 */
      __IOM uint32_t GPIO19     : 1;            /*!< [19..19] GPIO19 interrupt.                                                */
      __IOM uint32_t GPIO20     : 1;            /*!< [20..20] GPIO20 interrupt.                                                */
      __IOM uint32_t GPIO21     : 1;            /*!< [21..21] GPIO21 interrupt.                                                */
      __IOM uint32_t GPIO22     : 1;            /*!< [22..22] GPIO22 interrupt.                                                */
      __IOM uint32_t GPIO23     : 1;            /*!< [23..23] GPIO23 interrupt.                                                */
      __IOM uint32_t GPIO24     : 1;            /*!< [24..24] GPIO24 interrupt.                                                */
      __IOM uint32_t GPIO25     : 1;            /*!< [25..25] GPIO25 interrupt.                                                */
      __IOM uint32_t GPIO26     : 1;            /*!< [26..26] GPIO26 interrupt.                                                */
      __IOM uint32_t GPIO27     : 1;            /*!< [27..27] GPIO27 interrupt.                                                */
      __IOM uint32_t GPIO28     : 1;            /*!< [28..28] GPIO28 interrupt.                                                */
      __IOM uint32_t GPIO29     : 1;            /*!< [29..29] GPIO29 interrupt.                                                */
      __IOM uint32_t GPIO30     : 1;            /*!< [30..30] GPIO30 interrupt.                                                */
      __IOM uint32_t GPIO31     : 1;            /*!< [31..31] GPIO31 interrupt.                                                */
    } INT0STAT_b;
  } ;

  union {
    __IOM uint32_t INT0CLR;                     /*!< (@ 0x00000208) GPIO Interrupt Registers 31-0: Clear                       */

    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< [0..0] GPIO0 interrupt.                                                   */
      __IOM uint32_t GPIO1      : 1;            /*!< [1..1] GPIO1 interrupt.                                                   */
      __IOM uint32_t GPIO2      : 1;            /*!< [2..2] GPIO2 interrupt.                                                   */
      __IOM uint32_t GPIO3      : 1;            /*!< [3..3] GPIO3 interrupt.                                                   */
      __IOM uint32_t GPIO4      : 1;            /*!< [4..4] GPIO4 interrupt.                                                   */
      __IOM uint32_t GPIO5      : 1;            /*!< [5..5] GPIO5 interrupt.                                                   */
      __IOM uint32_t GPIO6      : 1;            /*!< [6..6] GPIO6 interrupt.                                                   */
      __IOM uint32_t GPIO7      : 1;            /*!< [7..7] GPIO7 interrupt.                                                   */
      __IOM uint32_t GPIO8      : 1;            /*!< [8..8] GPIO8 interrupt.                                                   */
      __IOM uint32_t GPIO9      : 1;            /*!< [9..9] GPIO9 interrupt.                                                   */
      __IOM uint32_t GPIO10     : 1;            /*!< [10..10] GPIO10 interrupt.                                                */
      __IOM uint32_t GPIO11     : 1;            /*!< [11..11] GPIO11 interrupt.                                                */
      __IOM uint32_t GPIO12     : 1;            /*!< [12..12] GPIO12 interrupt.                                                */
      __IOM uint32_t GPIO13     : 1;            /*!< [13..13] GPIO13 interrupt.                                                */
      __IOM uint32_t GPIO14     : 1;            /*!< [14..14] GPIO14 interrupt.                                                */
      __IOM uint32_t GPIO15     : 1;            /*!< [15..15] GPIO15 interrupt.                                                */
      __IOM uint32_t GPIO16     : 1;            /*!< [16..16] GPIO16 interrupt.                                                */
      __IOM uint32_t GPIO17     : 1;            /*!< [17..17] GPIO17 interrupt.                                                */
      __IOM uint32_t GPIO18     : 1;            /*!< [18..18] GPIO18interrupt.                                                 */
      __IOM uint32_t GPIO19     : 1;            /*!< [19..19] GPIO19 interrupt.                                                */
      __IOM uint32_t GPIO20     : 1;            /*!< [20..20] GPIO20 interrupt.                                                */
      __IOM uint32_t GPIO21     : 1;            /*!< [21..21] GPIO21 interrupt.                                                */
      __IOM uint32_t GPIO22     : 1;            /*!< [22..22] GPIO22 interrupt.                                                */
      __IOM uint32_t GPIO23     : 1;            /*!< [23..23] GPIO23 interrupt.                                                */
      __IOM uint32_t GPIO24     : 1;            /*!< [24..24] GPIO24 interrupt.                                                */
      __IOM uint32_t GPIO25     : 1;            /*!< [25..25] GPIO25 interrupt.                                                */
      __IOM uint32_t GPIO26     : 1;            /*!< [26..26] GPIO26 interrupt.                                                */
      __IOM uint32_t GPIO27     : 1;            /*!< [27..27] GPIO27 interrupt.                                                */
      __IOM uint32_t GPIO28     : 1;            /*!< [28..28] GPIO28 interrupt.                                                */
      __IOM uint32_t GPIO29     : 1;            /*!< [29..29] GPIO29 interrupt.                                                */
      __IOM uint32_t GPIO30     : 1;            /*!< [30..30] GPIO30 interrupt.                                                */
      __IOM uint32_t GPIO31     : 1;            /*!< [31..31] GPIO31 interrupt.                                                */
    } INT0CLR_b;
  } ;

  union {
    __IOM uint32_t INT0SET;                     /*!< (@ 0x0000020C) GPIO Interrupt Registers 31-0: Set                         */

    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< [0..0] GPIO0 interrupt.                                                   */
      __IOM uint32_t GPIO1      : 1;            /*!< [1..1] GPIO1 interrupt.                                                   */
      __IOM uint32_t GPIO2      : 1;            /*!< [2..2] GPIO2 interrupt.                                                   */
      __IOM uint32_t GPIO3      : 1;            /*!< [3..3] GPIO3 interrupt.                                                   */
      __IOM uint32_t GPIO4      : 1;            /*!< [4..4] GPIO4 interrupt.                                                   */
      __IOM uint32_t GPIO5      : 1;            /*!< [5..5] GPIO5 interrupt.                                                   */
      __IOM uint32_t GPIO6      : 1;            /*!< [6..6] GPIO6 interrupt.                                                   */
      __IOM uint32_t GPIO7      : 1;            /*!< [7..7] GPIO7 interrupt.                                                   */
      __IOM uint32_t GPIO8      : 1;            /*!< [8..8] GPIO8 interrupt.                                                   */
      __IOM uint32_t GPIO9      : 1;            /*!< [9..9] GPIO9 interrupt.                                                   */
      __IOM uint32_t GPIO10     : 1;            /*!< [10..10] GPIO10 interrupt.                                                */
      __IOM uint32_t GPIO11     : 1;            /*!< [11..11] GPIO11 interrupt.                                                */
      __IOM uint32_t GPIO12     : 1;            /*!< [12..12] GPIO12 interrupt.                                                */
      __IOM uint32_t GPIO13     : 1;            /*!< [13..13] GPIO13 interrupt.                                                */
      __IOM uint32_t GPIO14     : 1;            /*!< [14..14] GPIO14 interrupt.                                                */
      __IOM uint32_t GPIO15     : 1;            /*!< [15..15] GPIO15 interrupt.                                                */
      __IOM uint32_t GPIO16     : 1;            /*!< [16..16] GPIO16 interrupt.                                                */
      __IOM uint32_t GPIO17     : 1;            /*!< [17..17] GPIO17 interrupt.                                                */
      __IOM uint32_t GPIO18     : 1;            /*!< [18..18] GPIO18interrupt.                                                 */
      __IOM uint32_t GPIO19     : 1;            /*!< [19..19] GPIO19 interrupt.                                                */
      __IOM uint32_t GPIO20     : 1;            /*!< [20..20] GPIO20 interrupt.                                                */
      __IOM uint32_t GPIO21     : 1;            /*!< [21..21] GPIO21 interrupt.                                                */
      __IOM uint32_t GPIO22     : 1;            /*!< [22..22] GPIO22 interrupt.                                                */
      __IOM uint32_t GPIO23     : 1;            /*!< [23..23] GPIO23 interrupt.                                                */
      __IOM uint32_t GPIO24     : 1;            /*!< [24..24] GPIO24 interrupt.                                                */
      __IOM uint32_t GPIO25     : 1;            /*!< [25..25] GPIO25 interrupt.                                                */
      __IOM uint32_t GPIO26     : 1;            /*!< [26..26] GPIO26 interrupt.                                                */
      __IOM uint32_t GPIO27     : 1;            /*!< [27..27] GPIO27 interrupt.                                                */
      __IOM uint32_t GPIO28     : 1;            /*!< [28..28] GPIO28 interrupt.                                                */
      __IOM uint32_t GPIO29     : 1;            /*!< [29..29] GPIO29 interrupt.                                                */
      __IOM uint32_t GPIO30     : 1;            /*!< [30..30] GPIO30 interrupt.                                                */
      __IOM uint32_t GPIO31     : 1;            /*!< [31..31] GPIO31 interrupt.                                                */
    } INT0SET_b;
  } ;
  __IM  uint32_t  RESERVED2[4];

  union {
    __IOM uint32_t INT1EN;                      /*!< (@ 0x00000220) GPIO Interrupt Registers 63-32: Enable                     */

    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< [0..0] GPIO32 interrupt.                                                  */
      __IOM uint32_t GPIO33     : 1;            /*!< [1..1] GPIO33 interrupt.                                                  */
      __IOM uint32_t GPIO34     : 1;            /*!< [2..2] GPIO34 interrupt.                                                  */
      __IOM uint32_t GPIO35     : 1;            /*!< [3..3] GPIO35 interrupt.                                                  */
      __IOM uint32_t GPIO36     : 1;            /*!< [4..4] GPIO36 interrupt.                                                  */
      __IOM uint32_t GPIO37     : 1;            /*!< [5..5] GPIO37 interrupt.                                                  */
      __IOM uint32_t GPIO38     : 1;            /*!< [6..6] GPIO38 interrupt.                                                  */
      __IOM uint32_t GPIO39     : 1;            /*!< [7..7] GPIO39 interrupt.                                                  */
      __IOM uint32_t GPIO40     : 1;            /*!< [8..8] GPIO40 interrupt.                                                  */
      __IOM uint32_t GPIO41     : 1;            /*!< [9..9] GPIO41 interrupt.                                                  */
      __IOM uint32_t GPIO42     : 1;            /*!< [10..10] GPIO42 interrupt.                                                */
      __IOM uint32_t GPIO43     : 1;            /*!< [11..11] GPIO43 interrupt.                                                */
      __IOM uint32_t GPIO44     : 1;            /*!< [12..12] GPIO44 interrupt.                                                */
      __IOM uint32_t GPIO45     : 1;            /*!< [13..13] GPIO45 interrupt.                                                */
      __IOM uint32_t GPIO46     : 1;            /*!< [14..14] GPIO46 interrupt.                                                */
      __IOM uint32_t GPIO47     : 1;            /*!< [15..15] GPIO47 interrupt.                                                */
      __IOM uint32_t GPIO48     : 1;            /*!< [16..16] GPIO48 interrupt.                                                */
      __IOM uint32_t GPIO49     : 1;            /*!< [17..17] GPIO49 interrupt.                                                */
      __IOM uint32_t GPIO50     : 1;            /*!< [18..18] GPIO50 interrupt.                                                */
      __IOM uint32_t GPIO51     : 1;            /*!< [19..19] GPIO51 interrupt.                                                */
      __IOM uint32_t GPIO52     : 1;            /*!< [20..20] GPIO52 interrupt.                                                */
      __IOM uint32_t GPIO53     : 1;            /*!< [21..21] GPIO53 interrupt.                                                */
      __IOM uint32_t GPIO54     : 1;            /*!< [22..22] GPIO54 interrupt.                                                */
      __IOM uint32_t GPIO55     : 1;            /*!< [23..23] GPIO55 interrupt.                                                */
      __IOM uint32_t GPIO56     : 1;            /*!< [24..24] GPIO56 interrupt.                                                */
      __IOM uint32_t GPIO57     : 1;            /*!< [25..25] GPIO57 interrupt.                                                */
      __IOM uint32_t GPIO58     : 1;            /*!< [26..26] GPIO58 interrupt.                                                */
      __IOM uint32_t GPIO59     : 1;            /*!< [27..27] GPIO59 interrupt.                                                */
      __IOM uint32_t GPIO60     : 1;            /*!< [28..28] GPIO60 interrupt.                                                */
      __IOM uint32_t GPIO61     : 1;            /*!< [29..29] GPIO61 interrupt.                                                */
      __IOM uint32_t GPIO62     : 1;            /*!< [30..30] GPIO62 interrupt.                                                */
      __IOM uint32_t GPIO63     : 1;            /*!< [31..31] GPIO63 interrupt.                                                */
    } INT1EN_b;
  } ;

  union {
    __IOM uint32_t INT1STAT;                    /*!< (@ 0x00000224) GPIO Interrupt Registers 63-32: Status                     */

    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< [0..0] GPIO32 interrupt.                                                  */
      __IOM uint32_t GPIO33     : 1;            /*!< [1..1] GPIO33 interrupt.                                                  */
      __IOM uint32_t GPIO34     : 1;            /*!< [2..2] GPIO34 interrupt.                                                  */
      __IOM uint32_t GPIO35     : 1;            /*!< [3..3] GPIO35 interrupt.                                                  */
      __IOM uint32_t GPIO36     : 1;            /*!< [4..4] GPIO36 interrupt.                                                  */
      __IOM uint32_t GPIO37     : 1;            /*!< [5..5] GPIO37 interrupt.                                                  */
      __IOM uint32_t GPIO38     : 1;            /*!< [6..6] GPIO38 interrupt.                                                  */
      __IOM uint32_t GPIO39     : 1;            /*!< [7..7] GPIO39 interrupt.                                                  */
      __IOM uint32_t GPIO40     : 1;            /*!< [8..8] GPIO40 interrupt.                                                  */
      __IOM uint32_t GPIO41     : 1;            /*!< [9..9] GPIO41 interrupt.                                                  */
      __IOM uint32_t GPIO42     : 1;            /*!< [10..10] GPIO42 interrupt.                                                */
      __IOM uint32_t GPIO43     : 1;            /*!< [11..11] GPIO43 interrupt.                                                */
      __IOM uint32_t GPIO44     : 1;            /*!< [12..12] GPIO44 interrupt.                                                */
      __IOM uint32_t GPIO45     : 1;            /*!< [13..13] GPIO45 interrupt.                                                */
      __IOM uint32_t GPIO46     : 1;            /*!< [14..14] GPIO46 interrupt.                                                */
      __IOM uint32_t GPIO47     : 1;            /*!< [15..15] GPIO47 interrupt.                                                */
      __IOM uint32_t GPIO48     : 1;            /*!< [16..16] GPIO48 interrupt.                                                */
      __IOM uint32_t GPIO49     : 1;            /*!< [17..17] GPIO49 interrupt.                                                */
      __IOM uint32_t GPIO50     : 1;            /*!< [18..18] GPIO50 interrupt.                                                */
      __IOM uint32_t GPIO51     : 1;            /*!< [19..19] GPIO51 interrupt.                                                */
      __IOM uint32_t GPIO52     : 1;            /*!< [20..20] GPIO52 interrupt.                                                */
      __IOM uint32_t GPIO53     : 1;            /*!< [21..21] GPIO53 interrupt.                                                */
      __IOM uint32_t GPIO54     : 1;            /*!< [22..22] GPIO54 interrupt.                                                */
      __IOM uint32_t GPIO55     : 1;            /*!< [23..23] GPIO55 interrupt.                                                */
      __IOM uint32_t GPIO56     : 1;            /*!< [24..24] GPIO56 interrupt.                                                */
      __IOM uint32_t GPIO57     : 1;            /*!< [25..25] GPIO57 interrupt.                                                */
      __IOM uint32_t GPIO58     : 1;            /*!< [26..26] GPIO58 interrupt.                                                */
      __IOM uint32_t GPIO59     : 1;            /*!< [27..27] GPIO59 interrupt.                                                */
      __IOM uint32_t GPIO60     : 1;            /*!< [28..28] GPIO60 interrupt.                                                */
      __IOM uint32_t GPIO61     : 1;            /*!< [29..29] GPIO61 interrupt.                                                */
      __IOM uint32_t GPIO62     : 1;            /*!< [30..30] GPIO62 interrupt.                                                */
      __IOM uint32_t GPIO63     : 1;            /*!< [31..31] GPIO63 interrupt.                                                */
    } INT1STAT_b;
  } ;

  union {
    __IOM uint32_t INT1CLR;                     /*!< (@ 0x00000228) GPIO Interrupt Registers 63-32: Clear                      */

    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< [0..0] GPIO32 interrupt.                                                  */
      __IOM uint32_t GPIO33     : 1;            /*!< [1..1] GPIO33 interrupt.                                                  */
      __IOM uint32_t GPIO34     : 1;            /*!< [2..2] GPIO34 interrupt.                                                  */
      __IOM uint32_t GPIO35     : 1;            /*!< [3..3] GPIO35 interrupt.                                                  */
      __IOM uint32_t GPIO36     : 1;            /*!< [4..4] GPIO36 interrupt.                                                  */
      __IOM uint32_t GPIO37     : 1;            /*!< [5..5] GPIO37 interrupt.                                                  */
      __IOM uint32_t GPIO38     : 1;            /*!< [6..6] GPIO38 interrupt.                                                  */
      __IOM uint32_t GPIO39     : 1;            /*!< [7..7] GPIO39 interrupt.                                                  */
      __IOM uint32_t GPIO40     : 1;            /*!< [8..8] GPIO40 interrupt.                                                  */
      __IOM uint32_t GPIO41     : 1;            /*!< [9..9] GPIO41 interrupt.                                                  */
      __IOM uint32_t GPIO42     : 1;            /*!< [10..10] GPIO42 interrupt.                                                */
      __IOM uint32_t GPIO43     : 1;            /*!< [11..11] GPIO43 interrupt.                                                */
      __IOM uint32_t GPIO44     : 1;            /*!< [12..12] GPIO44 interrupt.                                                */
      __IOM uint32_t GPIO45     : 1;            /*!< [13..13] GPIO45 interrupt.                                                */
      __IOM uint32_t GPIO46     : 1;            /*!< [14..14] GPIO46 interrupt.                                                */
      __IOM uint32_t GPIO47     : 1;            /*!< [15..15] GPIO47 interrupt.                                                */
      __IOM uint32_t GPIO48     : 1;            /*!< [16..16] GPIO48 interrupt.                                                */
      __IOM uint32_t GPIO49     : 1;            /*!< [17..17] GPIO49 interrupt.                                                */
      __IOM uint32_t GPIO50     : 1;            /*!< [18..18] GPIO50 interrupt.                                                */
      __IOM uint32_t GPIO51     : 1;            /*!< [19..19] GPIO51 interrupt.                                                */
      __IOM uint32_t GPIO52     : 1;            /*!< [20..20] GPIO52 interrupt.                                                */
      __IOM uint32_t GPIO53     : 1;            /*!< [21..21] GPIO53 interrupt.                                                */
      __IOM uint32_t GPIO54     : 1;            /*!< [22..22] GPIO54 interrupt.                                                */
      __IOM uint32_t GPIO55     : 1;            /*!< [23..23] GPIO55 interrupt.                                                */
      __IOM uint32_t GPIO56     : 1;            /*!< [24..24] GPIO56 interrupt.                                                */
      __IOM uint32_t GPIO57     : 1;            /*!< [25..25] GPIO57 interrupt.                                                */
      __IOM uint32_t GPIO58     : 1;            /*!< [26..26] GPIO58 interrupt.                                                */
      __IOM uint32_t GPIO59     : 1;            /*!< [27..27] GPIO59 interrupt.                                                */
      __IOM uint32_t GPIO60     : 1;            /*!< [28..28] GPIO60 interrupt.                                                */
      __IOM uint32_t GPIO61     : 1;            /*!< [29..29] GPIO61 interrupt.                                                */
      __IOM uint32_t GPIO62     : 1;            /*!< [30..30] GPIO62 interrupt.                                                */
      __IOM uint32_t GPIO63     : 1;            /*!< [31..31] GPIO63 interrupt.                                                */
    } INT1CLR_b;
  } ;

  union {
    __IOM uint32_t INT1SET;                     /*!< (@ 0x0000022C) GPIO Interrupt Registers 63-32: Set                        */

    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< [0..0] GPIO32 interrupt.                                                  */
      __IOM uint32_t GPIO33     : 1;            /*!< [1..1] GPIO33 interrupt.                                                  */
      __IOM uint32_t GPIO34     : 1;            /*!< [2..2] GPIO34 interrupt.                                                  */
      __IOM uint32_t GPIO35     : 1;            /*!< [3..3] GPIO35 interrupt.                                                  */
      __IOM uint32_t GPIO36     : 1;            /*!< [4..4] GPIO36 interrupt.                                                  */
      __IOM uint32_t GPIO37     : 1;            /*!< [5..5] GPIO37 interrupt.                                                  */
      __IOM uint32_t GPIO38     : 1;            /*!< [6..6] GPIO38 interrupt.                                                  */
      __IOM uint32_t GPIO39     : 1;            /*!< [7..7] GPIO39 interrupt.                                                  */
      __IOM uint32_t GPIO40     : 1;            /*!< [8..8] GPIO40 interrupt.                                                  */
      __IOM uint32_t GPIO41     : 1;            /*!< [9..9] GPIO41 interrupt.                                                  */
      __IOM uint32_t GPIO42     : 1;            /*!< [10..10] GPIO42 interrupt.                                                */
      __IOM uint32_t GPIO43     : 1;            /*!< [11..11] GPIO43 interrupt.                                                */
      __IOM uint32_t GPIO44     : 1;            /*!< [12..12] GPIO44 interrupt.                                                */
      __IOM uint32_t GPIO45     : 1;            /*!< [13..13] GPIO45 interrupt.                                                */
      __IOM uint32_t GPIO46     : 1;            /*!< [14..14] GPIO46 interrupt.                                                */
      __IOM uint32_t GPIO47     : 1;            /*!< [15..15] GPIO47 interrupt.                                                */
      __IOM uint32_t GPIO48     : 1;            /*!< [16..16] GPIO48 interrupt.                                                */
      __IOM uint32_t GPIO49     : 1;            /*!< [17..17] GPIO49 interrupt.                                                */
      __IOM uint32_t GPIO50     : 1;            /*!< [18..18] GPIO50 interrupt.                                                */
      __IOM uint32_t GPIO51     : 1;            /*!< [19..19] GPIO51 interrupt.                                                */
      __IOM uint32_t GPIO52     : 1;            /*!< [20..20] GPIO52 interrupt.                                                */
      __IOM uint32_t GPIO53     : 1;            /*!< [21..21] GPIO53 interrupt.                                                */
      __IOM uint32_t GPIO54     : 1;            /*!< [22..22] GPIO54 interrupt.                                                */
      __IOM uint32_t GPIO55     : 1;            /*!< [23..23] GPIO55 interrupt.                                                */
      __IOM uint32_t GPIO56     : 1;            /*!< [24..24] GPIO56 interrupt.                                                */
      __IOM uint32_t GPIO57     : 1;            /*!< [25..25] GPIO57 interrupt.                                                */
      __IOM uint32_t GPIO58     : 1;            /*!< [26..26] GPIO58 interrupt.                                                */
      __IOM uint32_t GPIO59     : 1;            /*!< [27..27] GPIO59 interrupt.                                                */
      __IOM uint32_t GPIO60     : 1;            /*!< [28..28] GPIO60 interrupt.                                                */
      __IOM uint32_t GPIO61     : 1;            /*!< [29..29] GPIO61 interrupt.                                                */
      __IOM uint32_t GPIO62     : 1;            /*!< [30..30] GPIO62 interrupt.                                                */
      __IOM uint32_t GPIO63     : 1;            /*!< [31..31] GPIO63 interrupt.                                                */
    } INT1SET_b;
  } ;
  __IM  uint32_t  RESERVED3[4];

  union {
    __IOM uint32_t INT2EN;                      /*!< (@ 0x00000240) GPIO Interrupt Registers 73-64: Enable                     */

    struct {
      __IOM uint32_t GPIO64     : 1;            /*!< [0..0] GPIO64 interrupt.                                                  */
      __IOM uint32_t GPIO65     : 1;            /*!< [1..1] GPIO65 interrupt.                                                  */
      __IOM uint32_t GPIO66     : 1;            /*!< [2..2] GPIO66 interrupt.                                                  */
      __IOM uint32_t GPIO67     : 1;            /*!< [3..3] GPIO67 interrupt.                                                  */
      __IOM uint32_t GPIO68     : 1;            /*!< [4..4] GPIO68 interrupt.                                                  */
      __IOM uint32_t GPIO69     : 1;            /*!< [5..5] GPIO69 interrupt.                                                  */
      __IOM uint32_t GPIO70     : 1;            /*!< [6..6] GPIO70 interrupt.                                                  */
      __IOM uint32_t GPIO71     : 1;            /*!< [7..7] GPIO71 interrupt.                                                  */
      __IOM uint32_t GPIO72     : 1;            /*!< [8..8] GPIO72 interrupt.                                                  */
      __IOM uint32_t GPIO73     : 1;            /*!< [9..9] GPIO73 interrupt.                                                  */
    } INT2EN_b;
  } ;

  union {
    __IOM uint32_t INT2STAT;                    /*!< (@ 0x00000244) GPIO Interrupt Registers 73-64: Status                     */

    struct {
      __IOM uint32_t GPIO64     : 1;            /*!< [0..0] GPIO64 interrupt.                                                  */
      __IOM uint32_t GPIO65     : 1;            /*!< [1..1] GPIO65 interrupt.                                                  */
      __IOM uint32_t GPIO66     : 1;            /*!< [2..2] GPIO66 interrupt.                                                  */
      __IOM uint32_t GPIO67     : 1;            /*!< [3..3] GPIO67 interrupt.                                                  */
      __IOM uint32_t GPIO68     : 1;            /*!< [4..4] GPIO68 interrupt.                                                  */
      __IOM uint32_t GPIO69     : 1;            /*!< [5..5] GPIO69 interrupt.                                                  */
      __IOM uint32_t GPIO70     : 1;            /*!< [6..6] GPIO70 interrupt.                                                  */
      __IOM uint32_t GPIO71     : 1;            /*!< [7..7] GPIO71 interrupt.                                                  */
      __IOM uint32_t GPIO72     : 1;            /*!< [8..8] GPIO72 interrupt.                                                  */
      __IOM uint32_t GPIO73     : 1;            /*!< [9..9] GPIO73 interrupt.                                                  */
    } INT2STAT_b;
  } ;

  union {
    __IOM uint32_t INT2CLR;                     /*!< (@ 0x00000248) GPIO Interrupt Registers 73-64: Clear                      */

    struct {
      __IOM uint32_t GPIO64     : 1;            /*!< [0..0] GPIO64 interrupt.                                                  */
      __IOM uint32_t GPIO65     : 1;            /*!< [1..1] GPIO65 interrupt.                                                  */
      __IOM uint32_t GPIO66     : 1;            /*!< [2..2] GPIO66 interrupt.                                                  */
      __IOM uint32_t GPIO67     : 1;            /*!< [3..3] GPIO67 interrupt.                                                  */
      __IOM uint32_t GPIO68     : 1;            /*!< [4..4] GPIO68 interrupt.                                                  */
      __IOM uint32_t GPIO69     : 1;            /*!< [5..5] GPIO69 interrupt.                                                  */
      __IOM uint32_t GPIO70     : 1;            /*!< [6..6] GPIO70 interrupt.                                                  */
      __IOM uint32_t GPIO71     : 1;            /*!< [7..7] GPIO71 interrupt.                                                  */
      __IOM uint32_t GPIO72     : 1;            /*!< [8..8] GPIO72 interrupt.                                                  */
      __IOM uint32_t GPIO73     : 1;            /*!< [9..9] GPIO73 interrupt.                                                  */
    } INT2CLR_b;
  } ;

  union {
    __IOM uint32_t INT2SET;                     /*!< (@ 0x0000024C) GPIO Interrupt Registers 73-64: Set                        */

    struct {
      __IOM uint32_t GPIO64     : 1;            /*!< [0..0] GPIO64 interrupt.                                                  */
      __IOM uint32_t GPIO65     : 1;            /*!< [1..1] GPIO65 interrupt.                                                  */
      __IOM uint32_t GPIO66     : 1;            /*!< [2..2] GPIO66 interrupt.                                                  */
      __IOM uint32_t GPIO67     : 1;            /*!< [3..3] GPIO67 interrupt.                                                  */
      __IOM uint32_t GPIO68     : 1;            /*!< [4..4] GPIO68 interrupt.                                                  */
      __IOM uint32_t GPIO69     : 1;            /*!< [5..5] GPIO69 interrupt.                                                  */
      __IOM uint32_t GPIO70     : 1;            /*!< [6..6] GPIO70 interrupt.                                                  */
      __IOM uint32_t GPIO71     : 1;            /*!< [7..7] GPIO71 interrupt.                                                  */
      __IOM uint32_t GPIO72     : 1;            /*!< [8..8] GPIO72 interrupt.                                                  */
      __IOM uint32_t GPIO73     : 1;            /*!< [9..9] GPIO73 interrupt.                                                  */
    } INT2SET_b;
  } ;

  union {
    __IOM uint32_t DBGCTRL;                     /*!< (@ 0x00000250) Debug Control                                              */

    struct {
      __IOM uint32_t GCLK0      : 1;            /*!< [0..0] Gate IOM0 CLK in SPI mode, allowing external input clock           */
      __IOM uint32_t GCLK1      : 1;            /*!< [1..1] Gate IOM1 CLK in SPI mode, allowing external input clock           */
      __IOM uint32_t GCLK2      : 1;            /*!< [2..2] Gate IOM2 CLK in SPI mode, allowing external input clock           */
      __IOM uint32_t GCLK3      : 1;            /*!< [3..3] Gate IOM3 CLK in SPI mode, allowing external input clock           */
      __IOM uint32_t GCLK4      : 1;            /*!< [4..4] Gate IOM4 CLK in SPI mode, allowing external input clock           */
      __IOM uint32_t GCLK5      : 1;            /*!< [5..5] Gate IOM5 CLK in SPI mode, allowing external input clock           */
    } DBGCTRL_b;
  } ;
} GPIO_Type;                                    /*!< Size = 596 (0x254)                                                        */



/* =========================================================================================================================== */
/* ================                                           IOM0                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief IO Peripheral Master (IOM0)
  */

typedef struct {                                /*!< (@ 0x50004000) IOM0 Structure                                             */

  union {
    __IOM uint32_t FIFO;                        /*!< (@ 0x00000000) FIFO Access Port                                           */

    struct {
      __IOM uint32_t FIFO       : 32;           /*!< [31..0] FIFO direct access. Only locations 0 - 3F will return
                                                     valid information.                                                        */
    } FIFO_b;
  } ;
  __IM  uint32_t  RESERVED[63];

  union {
    __IOM uint32_t FIFOPTR;                     /*!< (@ 0x00000100) FIFO size and remaining slots open values                  */

    struct {
      __IOM uint32_t FIFO0SIZ   : 8;            /*!< [7..0] The number of valid data bytes currently in the FIFO
                                                     0 (written by MCU, read by interface)                                     */
      __IOM uint32_t FIFO0REM   : 8;            /*!< [15..8] The number of remaining data bytes slots currently in
                                                     FIFO 0 (written by MCU, read by interface)                                */
      __IOM uint32_t FIFO1SIZ   : 8;            /*!< [23..16] The number of valid data bytes currently in FIFO 1
                                                     (written by interface, read by MCU)                                       */
      __IOM uint32_t FIFO1REM   : 8;            /*!< [31..24] The number of remaining data bytes slots currently
                                                     in FIFO 1 (written by interface, read by MCU)                             */
    } FIFOPTR_b;
  } ;

  union {
    __IOM uint32_t FIFOTHR;                     /*!< (@ 0x00000104) FIFO Threshold Configuration                               */

    struct {
      __IOM uint32_t FIFORTHR   : 6;            /*!< [5..0] FIFO read threshold in bytes. A value of 0 will disable
                                                     the read FIFO level from activating the threshold interrupt.
                                                     If this field is non-zero, it will trigger a threshold
                                                     interrupt when the read fifo contains FIFORTHR valid bytes
                                                     of data, as indicated by the FIFO1SIZ field. This is intended
                                                     to signal when a data transfer of FIFORTHR bytes can be
                                                     done from the IOM module to the host via the read fifo
                                                     to support large IOM read operations.                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t FIFOWTHR   : 6;            /*!< [13..8] FIFO write threshold in bytes. A value of 0 will disable
                                                     the write FIFO level from activating the threshold interrupt.
                                                     If this field is non-zero, it will trigger a threshold
                                                     interrupt when the write fifo contains FIFOWTHR free bytes,
                                                     as indicated by the FIFO0REM field. This is intended to
                                                     signal when a transfer of FIFOWTHR bytes can be done from
                                                     the host to the IOM write fifo to support large IOM write
                                                     operations.                                                               */
    } FIFOTHR_b;
  } ;

  union {
    __IOM uint32_t FIFOPOP;                     /*!< (@ 0x00000108) FIFO POP register                                          */

    struct {
      __IOM uint32_t FIFODOUT   : 32;           /*!< [31..0] This register will return the read data indicated by
                                                     the current read pointer on reads. If the POPWR control
                                                     bit in the FIFOCTRL register is reset (0), the fifo read
                                                     pointer will be advanced by one word as a result of the
                                                     read.If the POPWR bit is set (1), the fifo read pointer
                                                     will only be advanced after a write operation to this register.
                                                     The write data is ignored for this register.If less than
                                                     a even word multiple is available, and the command is completed,
                                                     the module will return the word containing                                */
    } FIFOPOP_b;
  } ;

  union {
    __IOM uint32_t FIFOPUSH;                    /*!< (@ 0x0000010C) FIFO PUSH register                                         */

    struct {
      __IOM uint32_t FIFODIN    : 32;           /*!< [31..0] This register is used to write the FIFORAM in FIFO mode
                                                     and will cause a push event to occur to the next open slot
                                                     within the FIFORAM. Writing to this register will cause
                                                     the write point to increment by 1 word(4 bytes).                          */
    } FIFOPUSH_b;
  } ;

  union {
    __IOM uint32_t FIFOCTRL;                    /*!< (@ 0x00000110) FIFO Control Register                                      */

    struct {
      __IOM uint32_t POPWR      : 1;            /*!< [0..0] Selects the mode in which 'pop' events are done for the
                                                     fifo read operations. A value of '1' will prevent a pop
                                                     event on a read operation, and will require a write to
                                                     the FIFOPOP register to create a pop event.A value of '0'
                                                     in this register will allow a pop event to occur on the
                                                     read of the FIFOPOP register, and may cause inadvertant
                                                     fifo pops when used in a debugging mode.                                  */
      __IOM uint32_t FIFORSTN   : 1;            /*!< [1..1] Active low manual reset of the fifo. Write to 0 to reset
                                                     fifo, and then write to 1 to remove the reset.                            */
    } FIFOCTRL_b;
  } ;

  union {
    __IOM uint32_t FIFOLOC;                     /*!< (@ 0x00000114) FIFO Pointers                                              */

    struct {
      __IOM uint32_t FIFOWPTR   : 4;            /*!< [3..0] Current FIFO write pointer. Value is the index into the
                                                     outgoing FIFO (FIFO0), which is used during write operations
                                                     to external devices.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t FIFORPTR   : 4;            /*!< [11..8] Current FIFO read pointer. Used to index into the incoming
                                                     FIFO (FIFO1), which is used to store read data returned
                                                     from external devices during a read operation.                            */
    } FIFOLOC_b;
  } ;
  __IM  uint32_t  RESERVED1[58];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) IO Master Interrupts: Enable                               */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Command complete interrupt                                         */
      __IOM uint32_t THR        : 1;            /*!< [1..1] FIFO Threshold interrupt. For write operations, asserted
                                                     when the number of free bytes in the write FIFO equals
                                                     or exceeds the WTHR field.For read operations, asserted
                                                     when the number of valid bytes in the read FIFO equals
                                                     of exceeds the value set in the RTHR field.                               */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] Read FIFO Underflow interrupt. This occurs when software
                                                     tries to pop from an empty fifo.                                          */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] Write FIFO Overflow interrupt. This occurs when software
                                                     tries to write to a full fifo. The current operation does
                                                     not stop.                                                                 */
      __IOM uint32_t NAK        : 1;            /*!< [4..4] I2C NAK interrupt. Asserted when an unexpected NAK has
                                                     been received on the I2C bus.                                             */
      __IOM uint32_t IACC       : 1;            /*!< [5..5] illegal FIFO access interrupt. Asserted when there is
                                                     a overflow or underflow event                                             */
      __IOM uint32_t ICMD       : 1;            /*!< [6..6] illegal command interrupt. Asserted when a command is
                                                     written when an active command is in progress.                            */
      __IOM uint32_t START      : 1;            /*!< [7..7] START command interrupt. Asserted when another master
                                                     on the bus has signaled a START command.                                  */
      __IOM uint32_t STOP       : 1;            /*!< [8..8] STOP command interrupt. Asserted when another master
                                                     on the bus has signaled a STOP command.                                   */
      __IOM uint32_t ARB        : 1;            /*!< [9..9] Arbitration loss interrupt. Asserted when arbitration
                                                     is enabled and has been lost to another master on the bus.                */
      __IOM uint32_t DCMP       : 1;            /*!< [10..10] DMA Complete. Processing of the DMA operation has completed
                                                     and the DMA submodule is returned into the idle state                     */
      __IOM uint32_t DERR       : 1;            /*!< [11..11] DMA Error encountered during the processing of the
                                                     DMA command. The DMA error could occur when the memory
                                                     access specified in the DMA operation is not available
                                                     or incorrectly specified.                                                 */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [12..12] Command queue is paused due to an active event enabled
                                                     in the PAUSEEN register. The interrupt is posted when the
                                                     event is enabled within the PAUSEEN register, the mask
                                                     is active in the CQIRQMASK field and the event occurs.                    */
      __IOM uint32_t CQUPD      : 1;            /*!< [13..13] CQ write operation performed a register write with
                                                     the register address bit 0 set to 1. The low address bits
                                                     in the CQ address fields are unused and bit 0 can be used
                                                     to trigger an interrupt to indicate when this register
                                                     write is performed by the CQ operation.                                   */
      __IOM uint32_t CQERR      : 1;            /*!< [14..14] Error during command queue operations                            */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) IO Master Interrupts: Status                               */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Command complete interrupt                                         */
      __IOM uint32_t THR        : 1;            /*!< [1..1] FIFO Threshold interrupt. For write operations, asserted
                                                     when the number of free bytes in the write FIFO equals
                                                     or exceeds the WTHR field.For read operations, asserted
                                                     when the number of valid bytes in the read FIFO equals
                                                     of exceeds the value set in the RTHR field.                               */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] Read FIFO Underflow interrupt. This occurs when software
                                                     tries to pop from an empty fifo.                                          */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] Write FIFO Overflow interrupt. This occurs when software
                                                     tries to write to a full fifo. The current operation does
                                                     not stop.                                                                 */
      __IOM uint32_t NAK        : 1;            /*!< [4..4] I2C NAK interrupt. Asserted when an unexpected NAK has
                                                     been received on the I2C bus.                                             */
      __IOM uint32_t IACC       : 1;            /*!< [5..5] illegal FIFO access interrupt. Asserted when there is
                                                     a overflow or underflow event                                             */
      __IOM uint32_t ICMD       : 1;            /*!< [6..6] illegal command interrupt. Asserted when a command is
                                                     written when an active command is in progress.                            */
      __IOM uint32_t START      : 1;            /*!< [7..7] START command interrupt. Asserted when another master
                                                     on the bus has signaled a START command.                                  */
      __IOM uint32_t STOP       : 1;            /*!< [8..8] STOP command interrupt. Asserted when another master
                                                     on the bus has signaled a STOP command.                                   */
      __IOM uint32_t ARB        : 1;            /*!< [9..9] Arbitration loss interrupt. Asserted when arbitration
                                                     is enabled and has been lost to another master on the bus.                */
      __IOM uint32_t DCMP       : 1;            /*!< [10..10] DMA Complete. Processing of the DMA operation has completed
                                                     and the DMA submodule is returned into the idle state                     */
      __IOM uint32_t DERR       : 1;            /*!< [11..11] DMA Error encountered during the processing of the
                                                     DMA command. The DMA error could occur when the memory
                                                     access specified in the DMA operation is not available
                                                     or incorrectly specified.                                                 */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [12..12] Command queue is paused due to an active event enabled
                                                     in the PAUSEEN register. The interrupt is posted when the
                                                     event is enabled within the PAUSEEN register, the mask
                                                     is active in the CQIRQMASK field and the event occurs.                    */
      __IOM uint32_t CQUPD      : 1;            /*!< [13..13] CQ write operation performed a register write with
                                                     the register address bit 0 set to 1. The low address bits
                                                     in the CQ address fields are unused and bit 0 can be used
                                                     to trigger an interrupt to indicate when this register
                                                     write is performed by the CQ operation.                                   */
      __IOM uint32_t CQERR      : 1;            /*!< [14..14] Error during command queue operations                            */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) IO Master Interrupts: Clear                                */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Command complete interrupt                                         */
      __IOM uint32_t THR        : 1;            /*!< [1..1] FIFO Threshold interrupt. For write operations, asserted
                                                     when the number of free bytes in the write FIFO equals
                                                     or exceeds the WTHR field.For read operations, asserted
                                                     when the number of valid bytes in the read FIFO equals
                                                     of exceeds the value set in the RTHR field.                               */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] Read FIFO Underflow interrupt. This occurs when software
                                                     tries to pop from an empty fifo.                                          */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] Write FIFO Overflow interrupt. This occurs when software
                                                     tries to write to a full fifo. The current operation does
                                                     not stop.                                                                 */
      __IOM uint32_t NAK        : 1;            /*!< [4..4] I2C NAK interrupt. Asserted when an unexpected NAK has
                                                     been received on the I2C bus.                                             */
      __IOM uint32_t IACC       : 1;            /*!< [5..5] illegal FIFO access interrupt. Asserted when there is
                                                     a overflow or underflow event                                             */
      __IOM uint32_t ICMD       : 1;            /*!< [6..6] illegal command interrupt. Asserted when a command is
                                                     written when an active command is in progress.                            */
      __IOM uint32_t START      : 1;            /*!< [7..7] START command interrupt. Asserted when another master
                                                     on the bus has signaled a START command.                                  */
      __IOM uint32_t STOP       : 1;            /*!< [8..8] STOP command interrupt. Asserted when another master
                                                     on the bus has signaled a STOP command.                                   */
      __IOM uint32_t ARB        : 1;            /*!< [9..9] Arbitration loss interrupt. Asserted when arbitration
                                                     is enabled and has been lost to another master on the bus.                */
      __IOM uint32_t DCMP       : 1;            /*!< [10..10] DMA Complete. Processing of the DMA operation has completed
                                                     and the DMA submodule is returned into the idle state                     */
      __IOM uint32_t DERR       : 1;            /*!< [11..11] DMA Error encountered during the processing of the
                                                     DMA command. The DMA error could occur when the memory
                                                     access specified in the DMA operation is not available
                                                     or incorrectly specified.                                                 */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [12..12] Command queue is paused due to an active event enabled
                                                     in the PAUSEEN register. The interrupt is posted when the
                                                     event is enabled within the PAUSEEN register, the mask
                                                     is active in the CQIRQMASK field and the event occurs.                    */
      __IOM uint32_t CQUPD      : 1;            /*!< [13..13] CQ write operation performed a register write with
                                                     the register address bit 0 set to 1. The low address bits
                                                     in the CQ address fields are unused and bit 0 can be used
                                                     to trigger an interrupt to indicate when this register
                                                     write is performed by the CQ operation.                                   */
      __IOM uint32_t CQERR      : 1;            /*!< [14..14] Error during command queue operations                            */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) IO Master Interrupts: Set                                  */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Command complete interrupt                                         */
      __IOM uint32_t THR        : 1;            /*!< [1..1] FIFO Threshold interrupt. For write operations, asserted
                                                     when the number of free bytes in the write FIFO equals
                                                     or exceeds the WTHR field.For read operations, asserted
                                                     when the number of valid bytes in the read FIFO equals
                                                     of exceeds the value set in the RTHR field.                               */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] Read FIFO Underflow interrupt. This occurs when software
                                                     tries to pop from an empty fifo.                                          */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] Write FIFO Overflow interrupt. This occurs when software
                                                     tries to write to a full fifo. The current operation does
                                                     not stop.                                                                 */
      __IOM uint32_t NAK        : 1;            /*!< [4..4] I2C NAK interrupt. Asserted when an unexpected NAK has
                                                     been received on the I2C bus.                                             */
      __IOM uint32_t IACC       : 1;            /*!< [5..5] illegal FIFO access interrupt. Asserted when there is
                                                     a overflow or underflow event                                             */
      __IOM uint32_t ICMD       : 1;            /*!< [6..6] illegal command interrupt. Asserted when a command is
                                                     written when an active command is in progress.                            */
      __IOM uint32_t START      : 1;            /*!< [7..7] START command interrupt. Asserted when another master
                                                     on the bus has signaled a START command.                                  */
      __IOM uint32_t STOP       : 1;            /*!< [8..8] STOP command interrupt. Asserted when another master
                                                     on the bus has signaled a STOP command.                                   */
      __IOM uint32_t ARB        : 1;            /*!< [9..9] Arbitration loss interrupt. Asserted when arbitration
                                                     is enabled and has been lost to another master on the bus.                */
      __IOM uint32_t DCMP       : 1;            /*!< [10..10] DMA Complete. Processing of the DMA operation has completed
                                                     and the DMA submodule is returned into the idle state                     */
      __IOM uint32_t DERR       : 1;            /*!< [11..11] DMA Error encountered during the processing of the
                                                     DMA command. The DMA error could occur when the memory
                                                     access specified in the DMA operation is not available
                                                     or incorrectly specified.                                                 */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [12..12] Command queue is paused due to an active event enabled
                                                     in the PAUSEEN register. The interrupt is posted when the
                                                     event is enabled within the PAUSEEN register, the mask
                                                     is active in the CQIRQMASK field and the event occurs.                    */
      __IOM uint32_t CQUPD      : 1;            /*!< [13..13] CQ write operation performed a register write with
                                                     the register address bit 0 set to 1. The low address bits
                                                     in the CQ address fields are unused and bit 0 can be used
                                                     to trigger an interrupt to indicate when this register
                                                     write is performed by the CQ operation.                                   */
      __IOM uint32_t CQERR      : 1;            /*!< [14..14] Error during command queue operations                            */
    } INTSET_b;
  } ;

  union {
    __IOM uint32_t CLKCFG;                      /*!< (@ 0x00000210) I/O Clock Configuration                                    */

    struct {
      __IOM uint32_t IOCLKEN    : 1;            /*!< [0..0] Enable for the interface clock. Must be enabled prior
                                                     to executing any IO operations.                                           */
      __IM  uint32_t            : 7;
      __IOM uint32_t FSEL       : 3;            /*!< [10..8] Select the input clock frequency.                                 */
      __IOM uint32_t DIV3       : 1;            /*!< [11..11] Enable divide by 3 of the source IOCLK. Division by
                                                     3 is done before the DIVEN programmable divider, and if
                                                     enabledwill provide the divided by 3 clock as the source
                                                     to the programmable divider.                                              */
      __IOM uint32_t DIVEN      : 1;            /*!< [12..12] Enable clock division by TOTPER and LOWPER                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t LOWPER     : 8;            /*!< [23..16] Clock low clock count minus 1. This provides the number
                                                     of clocks the divided clock will be low when the DIVEN
                                                     = 1.Only applicable when DIVEN = 1.                                       */
      __IOM uint32_t TOTPER     : 8;            /*!< [31..24] Clock total clock count minus 1. This provides the
                                                     total period of the divided clock -1 when the DIVEN is
                                                     active. Thesource clock is selected by FSEL. Only applicable
                                                     when DIVEN = 1.                                                           */
    } CLKCFG_b;
  } ;

  union {
    __IOM uint32_t SUBMODCTRL;                  /*!< (@ 0x00000214) Submodule control                                          */

    struct {
      __IOM uint32_t SMOD0EN    : 1;            /*!< [0..0] Submodule 0 enable (1) or disable (0)                              */
      __IOM uint32_t SMOD0TYPE  : 3;            /*!< [3..1] Submodule 0 module type. This is the SPI Master interface.         */
      __IOM uint32_t SMOD1EN    : 1;            /*!< [4..4] Submodule 1 enable (1) or disable (0)                              */
      __IOM uint32_t SMOD1TYPE  : 3;            /*!< [7..5] Submodule 0 module type. This is the I2C Master interface          */
    } SUBMODCTRL_b;
  } ;

  union {
    __IOM uint32_t CMD;                         /*!< (@ 0x00000218) Command and offset Register                                */

    struct {
      __IOM uint32_t CMD        : 5;            /*!< [4..0] Command for submodule.                                             */
      __IOM uint32_t OFFSETCNT  : 2;            /*!< [6..5] Number of offset bytes to use for the command - 0, 1,
                                                     2, 3 are valid selections. The second (byte 1) and third
                                                     byte (byte 2) are read from the OFFSETHI register, and
                                                     the low order byte is pulled from this register in the
                                                     OFFSETLO field.Offset bytes are transmitted highest byte
                                                     first. EG if offsetcnt == 3, OFFSETHI[15:8] will be transmitted
                                                     first, then OFFSETHI[7:0] then OFFSETLO.If offsetcnt ==
                                                     2, OFFSETHI[7:0] will be transmitted, then OFFSETLO.If
                                                     offsetcnt == 1, only OFFSETLO will be transmitted.                        */
      __IOM uint32_t CONT       : 1;            /*!< [7..7] Contine to hold the bus after the current transaction
                                                     if set to a 1 with a new command issued.                                  */
      __IOM uint32_t TSIZE      : 12;           /*!< [19..8] Defines the transaction size in bytes. The offset transfer
                                                     is not included in this size.                                             */
      __IOM uint32_t CMDSEL     : 2;            /*!< [21..20] Command Specific selection information. Not used in
                                                     Master I2C. Used as CEn select for Master SPI transactions                */
      __IM  uint32_t            : 2;
      __IOM uint32_t OFFSETLO   : 8;            /*!< [31..24] This register holds the low order byte of offset to
                                                     be used in the transaction. The number of offset bytes
                                                     to use is set with bits 1:0 of the command.                               */
    } CMD_b;
  } ;

  union {
    __IOM uint32_t DCX;                         /*!< (@ 0x0000021C) DCX Control Register                                       */

    struct {
      __IOM uint32_t CE0OUT     : 1;            /*!< [0..0] Enable DCX output using CE0 output                                 */
      __IOM uint32_t CE1OUT     : 1;            /*!< [1..1] Enable DCX output using CE1 output                                 */
      __IOM uint32_t CE2OUT     : 1;            /*!< [2..2] Enable DCX output using CE2 output                                 */
      __IOM uint32_t CE3OUT     : 1;            /*!< [3..3] Enable DCX output using CE3 output                                 */
      __IOM uint32_t DCXEN      : 1;            /*!< [4..4] DCX Signaling Enable The selected DCX signal (unused
                                                     CE pin) will be driven low during write of offset byte,
                                                     and high during transmission of data bytes.                               */
    } DCX_b;
  } ;

  union {
    __IOM uint32_t OFFSETHI;                    /*!< (@ 0x00000220) High order 2 bytes of 3 byte offset for IO transaction     */

    struct {
      __IOM uint32_t OFFSETHI   : 16;           /*!< [15..0] Holds the high order 2 bytes of the 3 byte addressing/offset
                                                     field to use with IO commands. The number of offset bytes
                                                     to use is specified in the command register                               */
    } OFFSETHI_b;
  } ;

  union {
    __IOM uint32_t CMDSTAT;                     /*!< (@ 0x00000224) Command status                                             */

    struct {
      __IOM uint32_t CCMD       : 5;            /*!< [4..0] current command that is being executed                             */
      __IOM uint32_t CMDSTAT    : 3;            /*!< [7..5] The current status of the command execution.                       */
      __IOM uint32_t CTSIZE     : 12;           /*!< [19..8] The current number of bytes still to be transferred
                                                     with this command. This field will count down to zero.                    */
    } CMDSTAT_b;
  } ;
  __IM  uint32_t  RESERVED2[6];

  union {
    __IOM uint32_t DMATRIGEN;                   /*!< (@ 0x00000240) DMA Trigger Enable Register                                */

    struct {
      __IOM uint32_t DCMDCMPEN  : 1;            /*!< [0..0] Trigger DMA upon command complete. Enables the trigger
                                                     of the DMA when a command is completed. When this event
                                                     is triggered, the number of words transferred will be the
                                                     lesser of the remaining TOTCOUNT bytes, or                                */
      __IOM uint32_t DTHREN     : 1;            /*!< [1..1] Trigger DMA upon THR level reached. For M2P DMA operations
                                                     (IOM writes), the trigger will assert when the write FIFO
                                                     has (WTHR/4) number of words free in the write FIFO, and
                                                     will transfer (WTHR/4) number of wordsor, if the number
                                                     of words left to transfer is less than the WTHR value,
                                                     will transfer the remaining byte count.For P2M DMA operations,
                                                     the trigger will assert when the read FIFO has (RTHR/4)
                                                     words available in the read FIFO, and will transfer (RTHR/4)
                                                     words to SRAM. This trigger will NOT asser                                */
    } DMATRIGEN_b;
  } ;

  union {
    __IOM uint32_t DMATRIGSTAT;                 /*!< (@ 0x00000244) DMA Trigger Status Register                                */

    struct {
      __IOM uint32_t DCMDCMP    : 1;            /*!< [0..0] Triggered DMA from Command complete event. Bit is read
                                                     only and can be cleared by disabling the DCMDCMP trigger
                                                     enable or by disabling DMA.                                               */
      __IOM uint32_t DTHR       : 1;            /*!< [1..1] Triggered DMA from THR event. Bit is read only and can
                                                     be cleared by disabling the DTHR trigger enable or by disabling
                                                     DMA.                                                                      */
      __IOM uint32_t DTOTCMP    : 1;            /*!< [2..2] DMA triggered when DCMDCMP = 0, and the amount of data
                                                     in the FIFO was enough to complete the DMA operation (greater
                                                     than or equal to current TOTCOUNT) when the command completed.
                                                     This trigger is default active when the DCMDCMP trigger
                                                     isdisabled and there is enough data in the FIFO to complete
                                                     the DMA operation.                                                        */
    } DMATRIGSTAT_b;
  } ;
  __IM  uint32_t  RESERVED3[14];

  union {
    __IOM uint32_t DMACFG;                      /*!< (@ 0x00000280) DMA Configuration Register                                 */

    struct {
      __IOM uint32_t DMAEN      : 1;            /*!< [0..0] DMA Enable. Setting this bit to EN will start the DMA
                                                     operation. This should be the last DMA related register
                                                     set prior to issuing the command                                          */
      __IOM uint32_t DMADIR     : 1;            /*!< [1..1] Direction                                                          */
      __IM  uint32_t            : 6;
      __IOM uint32_t DMAPRI     : 1;            /*!< [8..8] Sets the Priority of the DMA request                               */
      __IOM uint32_t DPWROFF    : 1;            /*!< [9..9] Power off module after DMA is complete. If this bit is
                                                     active, the module will request to power off the supply
                                                     it is attached to. If there are other units still requiring
                                                     power from the same domain, power down will not be performed.             */
    } DMACFG_b;
  } ;
  __IM  uint32_t  RESERVED4;

  union {
    __IOM uint32_t DMATOTCOUNT;                 /*!< (@ 0x00000288) DMA Total Transfer Count                                   */

    struct {
      __IOM uint32_t TOTCOUNT   : 12;           /*!< [11..0] Triggered DMA from Command complete event occured. Bit
                                                     is read only and can be cleared by disabling the DTHR trigger
                                                     enable or by disabling DMA.                                               */
    } DMATOTCOUNT_b;
  } ;

  union {
    __IOM uint32_t DMATARGADDR;                 /*!< (@ 0x0000028C) DMA Target Address Register                                */

    struct {
      __IOM uint32_t TARGADDR   : 21;           /*!< [20..0] Bits [19:0] of the target byte address for source of
                                                     DMA (either read or write). The address can be any byte
                                                     alignment, and does not have to be word aligned. In cases
                                                     of non-word aligned addresses, the DMA logic will take
                                                     care for ensuring only the target bytes are read/written.                 */
      __IM  uint32_t            : 7;
      __IOM uint32_t TARGADDR28 : 1;            /*!< [28..28] Bit 28 of the target byte address for source of DMA
                                                     (either read or write). In cases of non-word aligned addresses,
                                                     the DMA logic will take care for ensuring only the target
                                                     bytes are read/written.Setting to '1' will select the SRAM.
                                                     Setting to '0' will select the flash                                      */
    } DMATARGADDR_b;
  } ;

  union {
    __IOM uint32_t DMASTAT;                     /*!< (@ 0x00000290) DMA Status Register                                        */

    struct {
      __IOM uint32_t DMATIP     : 1;            /*!< [0..0] DMA Transfer In Progress indicator. 1 will indicate that
                                                     a DMA transfer is active. The DMA transfer may be waiting
                                                     on data, transferring data, or waiting for priority.All
                                                     of these will be indicated with a 1. A 0 will indicate
                                                     that the DMA is fully complete and no further transactions
                                                     will be done. This bit is read only.                                      */
      __IOM uint32_t DMACPL     : 1;            /*!< [1..1] DMA Transfer Complete. This signals the end of the DMA
                                                     operation. This bit can be cleared by writing to 0, and
                                                     will also be cleared when a new DMA is started.                           */
      __IOM uint32_t DMAERR     : 1;            /*!< [2..2] DMA Error. This active high bit signals an error was
                                                     encountered during the DMA operation. The bit can be cleared
                                                     by writing to 0. Once set, this bit will remain set until
                                                     cleared by software.                                                      */
    } DMASTAT_b;
  } ;

  union {
    __IOM uint32_t CQCFG;                       /*!< (@ 0x00000294) Command Queue Configuration Register                       */

    struct {
      __IOM uint32_t CQEN       : 1;            /*!< [0..0] Command queue enable. When set, will enable the processing
                                                     of the command queue and fetches of address/data pairs
                                                     will proceed from the word address within the CQADDR register.
                                                     Can be disabled using a CQ executed write to this bit as
                                                     well.                                                                     */
      __IOM uint32_t CQPRI      : 1;            /*!< [1..1] Sets the Priority of the command queue dma request                 */
      __IOM uint32_t MSPIFLGSEL : 2;            /*!< [3..2] Selects the MPSI modules used for sourcing the CQFLAG
                                                     [11:8].                                                                   */
    } CQCFG_b;
  } ;

  union {
    __IOM uint32_t CQADDR;                      /*!< (@ 0x00000298) CQ Target Read Address Register                            */

    struct {
      __IM  uint32_t            : 2;
      __IOM uint32_t CQADDR     : 19;           /*!< [20..2] Bits 19:2 of target byte address for source of CQ. The
                                                     buffer must be aligned on a word boundary                                 */
      __IM  uint32_t            : 7;
      __IOM uint32_t CQADDR28   : 1;            /*!< [28..28] Bit 28 of target byte address for source of CQ. Used
                                                     to denote Flash (0) or SRAM (1) access                                    */
    } CQADDR_b;
  } ;

  union {
    __IOM uint32_t CQSTAT;                      /*!< (@ 0x0000029C) Command Queue Status Register                              */

    struct {
      __IOM uint32_t CQTIP      : 1;            /*!< [0..0] Command queue Transfer In Progress indicator. 1 will
                                                     indicate that a CQ transfer is active and this will remain
                                                     active even when paused waiting for external event.                       */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [1..1] Command queue operation is currently paused.                       */
      __IOM uint32_t CQERR      : 1;            /*!< [2..2] Command queue processing Error. This active high bit
                                                     signals that an error was encountered during the CQ operation.            */
    } CQSTAT_b;
  } ;

  union {
    __IOM uint32_t CQFLAGS;                     /*!< (@ 0x000002A0) Command Queue Flag Register                                */

    struct {
      __IOM uint32_t CQFLAGS    : 16;           /*!< [15..0] Current flag status (read-only). Bits [7:0] are software
                                                     controllable and bits [15:8] are hardware status.                         */
      __IOM uint32_t CQIRQMASK  : 16;           /*!< [31..16] Mask the bits used to generate the command queue interrupt.
                                                     A '1' in the bit position will enable the pause event to
                                                     trigger the interrupt, if the CQWT_int interrupt is enabled.
                                                     Bits definitions are the same as CQPAUSE                                  */
    } CQFLAGS_b;
  } ;

  union {
    __IOM uint32_t CQSETCLEAR;                  /*!< (@ 0x000002A4) Command Queue Flag Set/Clear Register                      */

    struct {
      __IOM uint32_t CQFSET     : 8;            /*!< [7..0] Set CQFlag status bits. Will set to 1 the value of any
                                                     SWFLAG with a '1' in the corresponding bit position of
                                                     this field                                                                */
      __IOM uint32_t CQFTGL     : 8;            /*!< [15..8] Toggle the indicated bit. Will toggle the value of any
                                                     SWFLAG with a '1' in the corresponding bit position of
                                                     this field                                                                */
      __IOM uint32_t CQFCLR     : 8;            /*!< [23..16] Clear CQFlag status bits. Will clear to 0 any SWFLAG
                                                     with a '1' in the corresponding bit position of this field                */
    } CQSETCLEAR_b;
  } ;

  union {
    __IOM uint32_t CQPAUSEEN;                   /*!< (@ 0x000002A8) Command Queue Pause Enable Register                        */

    struct {
      __IOM uint32_t CQPEN      : 16;           /*!< [15..0] Enables the specified event to pause command processing
                                                     when active                                                               */
    } CQPAUSEEN_b;
  } ;

  union {
    __IOM uint32_t CQCURIDX;                    /*!< (@ 0x000002AC) IOM Command Queue current index value . Compared
                                                                    to the CQENDIDX reg contents to generate
                                                                    the IDXEQ Pause event for command queue                    */

    struct {
      __IOM uint32_t CQCURIDX   : 8;            /*!< [7..0] Holds 8 bits of data that will be compared with the CQENDIX
                                                     register field. If the values match, the IDXEQ pause event
                                                     will be activated, which will cause the pausing of command
                                                     quue operation if the IDXEQ bit is enabled in CQPAUSEEN.                  */
    } CQCURIDX_b;
  } ;

  union {
    __IOM uint32_t CQENDIDX;                    /*!< (@ 0x000002B0) IOM Command Queue current index value . Compared
                                                                    to the CQCURIDX reg contents to generate
                                                                    the IDXEQ Pause event for command queue                    */

    struct {
      __IOM uint32_t CQENDIDX   : 8;            /*!< [7..0] Holds 8 bits of data that will be compared with the CQCURIX
                                                     register field. If the values match, the IDXEQ pause event
                                                     will be activated, which will cause the pausing of command
                                                     quue operation if the IDXEQ bit is enabled in CQPAUSEEN.                  */
    } CQENDIDX_b;
  } ;

  union {
    __IOM uint32_t STATUS;                      /*!< (@ 0x000002B4) IOM Module Status Register                                 */

    struct {
      __IOM uint32_t ERR        : 1;            /*!< [0..0] Bit has been deprecated. Please refer to the other error
                                                     indicators. This will always return 0.                                    */
      __IOM uint32_t CMDACT     : 1;            /*!< [1..1] Indicates if the active I/O Command is currently processing
                                                     a transaction, or command is complete, but the FIFO pointers
                                                     are still syncronizing internally. This bit will go high
                                                     atthe start of the transaction, and will go low when the
                                                     command is complete, and the data and pointers within the
                                                     FIFO have been syncronized.                                               */
      __IOM uint32_t IDLEST     : 1;            /*!< [2..2] indicates if the active I/O state machine is IDLE. Note
                                                     - The state machine could be in idle state due to holdoffs
                                                     from data availability, or as the command gets propagated
                                                     into the logic from the registers.                                        */
    } STATUS_b;
  } ;
  __IM  uint32_t  RESERVED5[18];

  union {
    __IOM uint32_t MSPICFG;                     /*!< (@ 0x00000300) SPI module master configuration                            */

    struct {
      __IOM uint32_t SPOL       : 1;            /*!< [0..0] selects SPI polarity.                                              */
      __IOM uint32_t SPHA       : 1;            /*!< [1..1] selects SPI phase.                                                 */
      __IOM uint32_t FULLDUP    : 1;            /*!< [2..2] Enables full duplex mode for Master SPI write operations.
                                                     Data will be captured simultaneously into the read fifo                   */
      __IM  uint32_t            : 13;
      __IOM uint32_t WTFC       : 1;            /*!< [16..16] enables write mode flow control.                                 */
      __IOM uint32_t RDFC       : 1;            /*!< [17..17] enables read mode flow control.                                  */
      __IOM uint32_t MOSIINV    : 1;            /*!< [18..18] inverts MOSI when flow control is enabled.                       */
      __IM  uint32_t            : 1;
      __IOM uint32_t WTFCIRQ    : 1;            /*!< [20..20] selects the write mode flow control signal.                      */
      __IOM uint32_t WTFCPOL    : 1;            /*!< [21..21] selects the write flow control signal polarity. The
                                                     transfers are halted when the selected flow control signal
                                                     is OPPOSITE polarity of bit. (For example: WTFCPOL = 0
                                                     will allow a IRQ=1 to pause transfers).                                   */
      __IOM uint32_t RDFCPOL    : 1;            /*!< [22..22] selects the read flow control signal polarity.                   */
      __IOM uint32_t SPILSB     : 1;            /*!< [23..23] Selects data transfer as MSB first (0) or LSB first
                                                     (1) for the data portion of the SPI transaction. The offset
                                                     bytes are always transmitted MSB first.                                   */
      __IOM uint32_t DINDLY     : 3;            /*!< [26..24] Delay tap to use for the input signal (MISO). This
                                                     gives more hold time on the input data.                                   */
      __IOM uint32_t DOUTDLY    : 3;            /*!< [29..27] Delay tap to use for the output signal (MOSI). This
                                                     give more hold time on the output data                                    */
      __IOM uint32_t MSPIRST    : 1;            /*!< [30..30] Not used. To reset the module, toggle the SMOD_EN for
                                                     the module                                                                */
    } MSPICFG_b;
  } ;
  __IM  uint32_t  RESERVED6[63];

  union {
    __IOM uint32_t MI2CCFG;                     /*!< (@ 0x00000400) I2C Master configuration                                   */

    struct {
      __IOM uint32_t ADDRSZ     : 1;            /*!< [0..0] Sets the I2C master device address size to either 7b
                                                     (0) or 10b (1).                                                           */
      __IOM uint32_t I2CLSB     : 1;            /*!< [1..1] Direction of data transmit and receive, MSB(0) or LSB(1)
                                                     first. Default per I2C specification is MSB first. This
                                                     applies to both read and write data, and read data will
                                                     be bit                                                                    */
      __IOM uint32_t ARBEN      : 1;            /*!< [2..2] Enables multi-master arbitration for the I2C master.
                                                     If the bus is known to have only a single master, this
                                                     function can be disabled to save clock cycles on I2C transactions         */
      __IM  uint32_t            : 1;
      __IOM uint32_t SDADLY     : 2;            /*!< [5..4] Delay to enable on the SDA output. Values are 0x0-0x3.             */
      __IOM uint32_t MI2CRST    : 1;            /*!< [6..6] Not used. To reset the module, toggle the SMOD_EN for
                                                     the module                                                                */
      __IM  uint32_t            : 1;
      __IOM uint32_t SCLENDLY   : 4;            /*!< [11..8] Number of IOCLK cycles to delay the rising edge of the
                                                     SCL output en (clock will go low on this edge). Used to
                                                     allow clock shaping.                                                      */
      __IOM uint32_t SDAENDLY   : 4;            /*!< [15..12] Number of IOCLK cycles to delay the SDA output en (all
                                                     transitions affected). Used to delay data relative to clock               */
      __IOM uint32_t SMPCNT     : 8;            /*!< [23..16] Number of Base clk cycles to wait before sampling the
                                                     SCL clock to determine if a clock stretch event has occured               */
      __IOM uint32_t STRDIS     : 1;            /*!< [24..24] Disable detection of clock stretch events smaller than
                                                     1 cycle                                                                   */
    } MI2CCFG_b;
  } ;

  union {
    __IOM uint32_t DEVCFG;                      /*!< (@ 0x00000404) I2C Device Configuration register                          */

    struct {
      __IOM uint32_t DEVADDR    : 10;           /*!< [9..0] I2C address of the device that the Master will use to
                                                     target for read/write operations. This can be either a
                                                     7b or 10b address.                                                        */
    } DEVCFG_b;
  } ;
  __IM  uint32_t  RESERVED7[2];

  union {
    __IOM uint32_t IOMDBG;                      /*!< (@ 0x00000410) IOM Debug Register                                         */

    struct {
      __IOM uint32_t DBGEN      : 1;            /*!< [0..0] Debug Enable. Setting bit will enable the update of data
                                                     within this register, otherwise it is clock gated for power
                                                     savings                                                                   */
      __IOM uint32_t IOCLKON    : 1;            /*!< [1..1] IOCLK debug clock control. Enable IO_CLK to be active
                                                     when this bit is '1'. Otherwise, the clock is controlled
                                                     with gating from the logic as needed.                                     */
      __IOM uint32_t APBCLKON   : 1;            /*!< [2..2] APBCLK debug clock control. Enable APB_CLK to be active
                                                     when this bit is '1'. Otherwise, the clock is controlled
                                                     with gating from the logic as needed.                                     */
      __IOM uint32_t DBGDATA    : 29;           /*!< [31..3] Debug control for various options. DBGDATA[1:0] is used
                                                     to select between different debug data available in the
                                                     DBG0 and DBG1 registers.                                                  */
    } IOMDBG_b;
  } ;
} IOM0_Type;                                    /*!< Size = 1044 (0x414)                                                       */



/* =========================================================================================================================== */
/* ================                                          IOSLAVE                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief I2C/SPI Slave (IOSLAVE)
  */

typedef struct {                                /*!< (@ 0x50000000) IOSLAVE Structure                                          */
  __IM  uint32_t  RESERVED[64];

  union {
    __IOM uint32_t FIFOPTR;                     /*!< (@ 0x00000100) Current FIFO Pointer                                       */

    struct {
      __IOM uint32_t FIFOPTR    : 8;            /*!< [7..0] Current FIFO pointer.                                              */
      __IOM uint32_t FIFOSIZ    : 8;            /*!< [15..8] The number of bytes currently in the hardware FIFO.               */
    } FIFOPTR_b;
  } ;

  union {
    __IOM uint32_t FIFOCFG;                     /*!< (@ 0x00000104) FIFO Configuration                                         */

    struct {
      __IOM uint32_t FIFOBASE   : 5;            /*!< [4..0] These bits hold the base address of the I/O FIFO in 8
                                                     byte segments. The IO Slave FIFO is situated in LRAM at
                                                     (FIFOBASE*8) to (FIFOMAX*8-1).                                            */
      __IM  uint32_t            : 3;
      __IOM uint32_t FIFOMAX    : 6;            /*!< [13..8] These bits hold the maximum FIFO address in 8 byte segments.
                                                     It is also the beginning of the RAM area of the LRAM. Note
                                                     that no RAM area is configured if FIFOMAX is set to 0x1F.                 */
      __IM  uint32_t            : 10;
      __IOM uint32_t ROBASE     : 6;            /*!< [29..24] Defines the read-only area. The IO Slave read-only
                                                     area is situated in LRAM at (ROBASE*8) to (FIFOBASE*8-1)                  */
    } FIFOCFG_b;
  } ;

  union {
    __IOM uint32_t FIFOTHR;                     /*!< (@ 0x00000108) FIFO Threshold Configuration                               */

    struct {
      __IOM uint32_t FIFOTHR    : 8;            /*!< [7..0] FIFO size interrupt threshold.                                     */
    } FIFOTHR_b;
  } ;

  union {
    __IOM uint32_t FUPD;                        /*!< (@ 0x0000010C) FIFO Update Status                                         */

    struct {
      __IOM uint32_t FIFOUPD    : 1;            /*!< [0..0] This bit indicates that a FIFO update is underway.                 */
      __IOM uint32_t IOREAD     : 1;            /*!< [1..1] This bitfield indicates an IO read is active.                      */
    } FUPD_b;
  } ;

  union {
    __IOM uint32_t FIFOCTR;                     /*!< (@ 0x00000110) Overall FIFO Counter                                       */

    struct {
      __IOM uint32_t FIFOCTR    : 10;           /*!< [9..0] Virtual FIFO byte count                                            */
    } FIFOCTR_b;
  } ;

  union {
    __IOM uint32_t FIFOINC;                     /*!< (@ 0x00000114) Overall FIFO Counter Increment                             */

    struct {
      __IOM uint32_t FIFOINC    : 10;           /*!< [9..0] Increment the Overall FIFO Counter by this value on a
                                                     write                                                                     */
    } FIFOINC_b;
  } ;

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000118) I/O Slave Configuration                                    */

    struct {
      __IOM uint32_t IFCSEL     : 1;            /*!< [0..0] This bit selects the I/O interface.                                */
      __IOM uint32_t SPOL       : 1;            /*!< [1..1] This bit selects SPI polarity.                                     */
      __IOM uint32_t LSB        : 1;            /*!< [2..2] This bit selects the transfer bit ordering.                        */
      __IM  uint32_t            : 1;
      __IOM uint32_t STARTRD    : 1;            /*!< [4..4] This bit holds the cycle to initiate an I/O RAM read.              */
      __IM  uint32_t            : 3;
      __IOM uint32_t I2CADDR    : 12;           /*!< [19..8] 7-bit or 10-bit I2C device address.                               */
      __IM  uint32_t            : 11;
      __IOM uint32_t IFCEN      : 1;            /*!< [31..31] IOSLAVE interface enable.                                        */
    } CFG_b;
  } ;

  union {
    __IOM uint32_t PRENC;                       /*!< (@ 0x0000011C) I/O Slave Interrupt Priority Encode                        */

    struct {
      __IOM uint32_t PRENC      : 5;            /*!< [4..0] These bits hold the priority encode of the REGACC interrupts.      */
    } PRENC_b;
  } ;

  union {
    __IOM uint32_t IOINTCTL;                    /*!< (@ 0x00000120) I/O Interrupt Control                                      */

    struct {
      __IOM uint32_t IOINTEN    : 8;            /*!< [7..0] These read-only bits indicate whether the IOINT interrupts
                                                     are enabled.                                                              */
      __IOM uint32_t IOINT      : 8;            /*!< [15..8] These bits read the IOINT interrupts.                             */
      __IOM uint32_t IOINTCLR   : 1;            /*!< [16..16] This bit clears all of the IOINT interrupts when written
                                                     with a 1.                                                                 */
      __IM  uint32_t            : 7;
      __IOM uint32_t IOINTSET   : 8;            /*!< [31..24] These bits set the IOINT interrupts when written with
                                                     a 1.                                                                      */
    } IOINTCTL_b;
  } ;

  union {
    __IOM uint32_t GENADD;                      /*!< (@ 0x00000124) General Address Data                                       */

    struct {
      __IOM uint32_t GADATA     : 8;            /*!< [7..0] The data supplied on the last General Address reference.           */
    } GENADD_b;
  } ;
  __IM  uint32_t  RESERVED1[54];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) IO Slave Interrupts: Enable                                */

    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< [0..0] FIFO Size interrupt.                                               */
      __IOM uint32_t FOVFL      : 1;            /*!< [1..1] FIFO Overflow interrupt.                                           */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] FIFO Underflow interrupt.                                          */
      __IOM uint32_t FRDERR     : 1;            /*!< [3..3] FIFO Read Error interrupt.                                         */
      __IOM uint32_t GENAD      : 1;            /*!< [4..4] I2C General Address interrupt.                                     */
      __IOM uint32_t IOINTW     : 1;            /*!< [5..5] IO Write interrupt.                                                */
      __IOM uint32_t XCMPRF     : 1;            /*!< [6..6] Transfer complete interrupt, read from FIFO space.                 */
      __IOM uint32_t XCMPRR     : 1;            /*!< [7..7] Transfer complete interrupt, read from register space.             */
      __IOM uint32_t XCMPWF     : 1;            /*!< [8..8] Transfer complete interrupt, write to FIFO space.                  */
      __IOM uint32_t XCMPWR     : 1;            /*!< [9..9] Transfer complete interrupt, write to register space.              */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) IO Slave Interrupts: Status                                */

    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< [0..0] FIFO Size interrupt.                                               */
      __IOM uint32_t FOVFL      : 1;            /*!< [1..1] FIFO Overflow interrupt.                                           */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] FIFO Underflow interrupt.                                          */
      __IOM uint32_t FRDERR     : 1;            /*!< [3..3] FIFO Read Error interrupt.                                         */
      __IOM uint32_t GENAD      : 1;            /*!< [4..4] I2C General Address interrupt.                                     */
      __IOM uint32_t IOINTW     : 1;            /*!< [5..5] IO Write interrupt.                                                */
      __IOM uint32_t XCMPRF     : 1;            /*!< [6..6] Transfer complete interrupt, read from FIFO space.                 */
      __IOM uint32_t XCMPRR     : 1;            /*!< [7..7] Transfer complete interrupt, read from register space.             */
      __IOM uint32_t XCMPWF     : 1;            /*!< [8..8] Transfer complete interrupt, write to FIFO space.                  */
      __IOM uint32_t XCMPWR     : 1;            /*!< [9..9] Transfer complete interrupt, write to register space.              */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) IO Slave Interrupts: Clear                                 */

    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< [0..0] FIFO Size interrupt.                                               */
      __IOM uint32_t FOVFL      : 1;            /*!< [1..1] FIFO Overflow interrupt.                                           */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] FIFO Underflow interrupt.                                          */
      __IOM uint32_t FRDERR     : 1;            /*!< [3..3] FIFO Read Error interrupt.                                         */
      __IOM uint32_t GENAD      : 1;            /*!< [4..4] I2C General Address interrupt.                                     */
      __IOM uint32_t IOINTW     : 1;            /*!< [5..5] IO Write interrupt.                                                */
      __IOM uint32_t XCMPRF     : 1;            /*!< [6..6] Transfer complete interrupt, read from FIFO space.                 */
      __IOM uint32_t XCMPRR     : 1;            /*!< [7..7] Transfer complete interrupt, read from register space.             */
      __IOM uint32_t XCMPWF     : 1;            /*!< [8..8] Transfer complete interrupt, write to FIFO space.                  */
      __IOM uint32_t XCMPWR     : 1;            /*!< [9..9] Transfer complete interrupt, write to register space.              */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) IO Slave Interrupts: Set                                   */

    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< [0..0] FIFO Size interrupt.                                               */
      __IOM uint32_t FOVFL      : 1;            /*!< [1..1] FIFO Overflow interrupt.                                           */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] FIFO Underflow interrupt.                                          */
      __IOM uint32_t FRDERR     : 1;            /*!< [3..3] FIFO Read Error interrupt.                                         */
      __IOM uint32_t GENAD      : 1;            /*!< [4..4] I2C General Address interrupt.                                     */
      __IOM uint32_t IOINTW     : 1;            /*!< [5..5] IO Write interrupt.                                                */
      __IOM uint32_t XCMPRF     : 1;            /*!< [6..6] Transfer complete interrupt, read from FIFO space.                 */
      __IOM uint32_t XCMPRR     : 1;            /*!< [7..7] Transfer complete interrupt, read from register space.             */
      __IOM uint32_t XCMPWF     : 1;            /*!< [8..8] Transfer complete interrupt, write to FIFO space.                  */
      __IOM uint32_t XCMPWR     : 1;            /*!< [9..9] Transfer complete interrupt, write to register space.              */
    } INTSET_b;
  } ;

  union {
    __IOM uint32_t REGACCINTEN;                 /*!< (@ 0x00000210) Register Access Interrupts: Enable                         */

    struct {
      __IOM uint32_t REGACC     : 32;           /*!< [31..0] Register access interrupts.                                       */
    } REGACCINTEN_b;
  } ;

  union {
    __IOM uint32_t REGACCINTSTAT;               /*!< (@ 0x00000214) Register Access Interrupts: Status                         */

    struct {
      __IOM uint32_t REGACC     : 32;           /*!< [31..0] Register access interrupts.                                       */
    } REGACCINTSTAT_b;
  } ;

  union {
    __IOM uint32_t REGACCINTCLR;                /*!< (@ 0x00000218) Register Access Interrupts: Clear                          */

    struct {
      __IOM uint32_t REGACC     : 32;           /*!< [31..0] Register access interrupts.                                       */
    } REGACCINTCLR_b;
  } ;

  union {
    __IOM uint32_t REGACCINTSET;                /*!< (@ 0x0000021C) Register Access Interrupts: Set                            */

    struct {
      __IOM uint32_t REGACC     : 32;           /*!< [31..0] Register access interrupts.                                       */
    } REGACCINTSET_b;
  } ;
} IOSLAVE_Type;                                 /*!< Size = 544 (0x220)                                                        */



/* =========================================================================================================================== */
/* ================                                          MCUCTRL                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief MCU Miscellaneous Control Logic (MCUCTRL)
  */

typedef struct {                                /*!< (@ 0x40020000) MCUCTRL Structure                                          */

  union {
    __IOM uint32_t CHIPPN;                      /*!< (@ 0x00000000) Chip Information Register                                  */

    struct {
      __IOM uint32_t PARTNUM    : 32;           /*!< [31..0] BCD part number.                                                  */
    } CHIPPN_b;
  } ;

  union {
    __IOM uint32_t CHIPID0;                     /*!< (@ 0x00000004) Unique Chip ID 0                                           */

    struct {
      __IOM uint32_t CHIPID0    : 32;           /*!< [31..0] Unique chip ID 0.                                                 */
    } CHIPID0_b;
  } ;

  union {
    __IOM uint32_t CHIPID1;                     /*!< (@ 0x00000008) Unique Chip ID 1                                           */

    struct {
      __IOM uint32_t CHIPID1    : 32;           /*!< [31..0] Unique chip ID 1.                                                 */
    } CHIPID1_b;
  } ;

  union {
    __IOM uint32_t CHIPREV;                     /*!< (@ 0x0000000C) Chip Revision                                              */

    struct {
      __IOM uint32_t REVMIN     : 4;            /*!< [3..0] Minor Revision ID.                                                 */
      __IOM uint32_t REVMAJ     : 4;            /*!< [7..4] Major Revision ID.                                                 */
      __IOM uint32_t SIPART     : 12;           /*!< [19..8] Silicon Part ID                                                   */
    } CHIPREV_b;
  } ;

  union {
    __IOM uint32_t VENDORID;                    /*!< (@ 0x00000010) Unique Vendor ID                                           */

    struct {
      __IOM uint32_t VENDORID   : 32;           /*!< [31..0] Unique Vendor ID                                                  */
    } VENDORID_b;
  } ;

  union {
    __IOM uint32_t SKU;                         /*!< (@ 0x00000014) Unique Chip SKU                                            */

    struct {
      __IOM uint32_t ALLOWBURST : 1;            /*!< [0..0] Allow Burst feature                                                */
      __IOM uint32_t ALLOWBLE   : 1;            /*!< [1..1] Allow BLE feature                                                  */
      __IOM uint32_t SECBOOT    : 1;            /*!< [2..2] Secure boot feature allowed                                        */
    } SKU_b;
  } ;

  union {
    __IOM uint32_t FEATUREENABLE;               /*!< (@ 0x00000018) Feature Enable on Burst and BLE                            */

    struct {
      __IOM uint32_t BLEREQ     : 1;            /*!< [0..0] Controls the BLE functionality                                     */
      __IOM uint32_t BLEACK     : 1;            /*!< [1..1] ACK for BLEREQ                                                     */
      __IOM uint32_t BLEAVAIL   : 1;            /*!< [2..2] AVAILABILITY of the BLE functionality                              */
      __IM  uint32_t            : 1;
      __IOM uint32_t BURSTREQ   : 1;            /*!< [4..4] Controls the Burst functionality                                   */
      __IOM uint32_t BURSTACK   : 1;            /*!< [5..5] ACK for BURSTREQ                                                   */
      __IOM uint32_t BURSTAVAIL : 1;            /*!< [6..6] Availability of Burst functionality                                */
    } FEATUREENABLE_b;
  } ;
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t DEBUGGER;                    /*!< (@ 0x00000020) Debugger Control                                           */

    struct {
      __IOM uint32_t LOCKOUT    : 1;            /*!< [0..0] Lockout of debugger (SWD).                                         */
    } DEBUGGER_b;
  } ;
  __IM  uint32_t  RESERVED1[5];

  union {
    __IOM uint32_t DMASRAMWRITEPROTECT2;        /*!< (@ 0x00000038) SRAM write-protection bits.                                */

    struct {
      __IOM uint32_t DMA_WPROT2 : 32;           /*!< [31..0] Write protect SRAM from DMA. Each bit provides write
                                                     protection for an 8KB region of memory. When set to 1,
                                                     the region will be protected from DMA writes, when set
                                                     to 0, DMA may write the region.                                           */
    } DMASRAMWRITEPROTECT2_b;
  } ;
  __IM  uint32_t  RESERVED2[49];

  union {
    __IOM uint32_t BODCTRL;                     /*!< (@ 0x00000100) BOD control Register                                       */

    struct {
      __IOM uint32_t BODLPWD    : 1;            /*!< [0..0] BODL Power Down.                                                   */
      __IOM uint32_t BODHPWD    : 1;            /*!< [1..1] BODH Power Down.                                                   */
      __IOM uint32_t BODCPWD    : 1;            /*!< [2..2] BODC Power Down.                                                   */
      __IOM uint32_t BODFPWD    : 1;            /*!< [3..3] BODF Power Down.                                                   */
      __IOM uint32_t BODLVREFSEL : 1;           /*!< [4..4] BODL External Reference Select. Note: the SWE mux select
                                                     in PWRSEQ2SWE must be set for this to take effect.                        */
      __IOM uint32_t BODHVREFSEL : 1;           /*!< [5..5] BODH External Reference Select. Note: the SWE mux select
                                                     in PWRSEQ2SWE must be set for this to take effect.                        */
    } BODCTRL_b;
  } ;

  union {
    __IOM uint32_t ADCPWRDLY;                   /*!< (@ 0x00000104) ADC Power Up Delay Control                                 */

    struct {
      __IOM uint32_t ADCPWR0    : 8;            /*!< [7..0] ADC Reference Buffer Power Enable delay in 64 ADC CLK
                                                     increments for ADC_CLKSEL = 0x1, 32 ADC CLOCK increments
                                                     for ADC_CLKSEL = 0x2.                                                     */
      __IOM uint32_t ADCPWR1    : 8;            /*!< [15..8] ADC Reference Keeper enable delay in 16 ADC CLK increments
                                                     for ADC_CLKSEL = 0x1, 8 ADC CLOCK increments for ADC_CLKSEL
                                                     = 0x2.                                                                    */
    } ADCPWRDLY_b;
  } ;
  __IM  uint32_t  RESERVED3;

  union {
    __IOM uint32_t ADCCAL;                      /*!< (@ 0x0000010C) ADC Calibration Control                                    */

    struct {
      __IOM uint32_t CALONPWRUP : 1;            /*!< [0..0] Run ADC Calibration on initial power up sequence                   */
      __IOM uint32_t ADCCALIBRATED : 1;         /*!< [1..1] Status for ADC Calibration                                         */
    } ADCCAL_b;
  } ;

  union {
    __IOM uint32_t ADCBATTLOAD;                 /*!< (@ 0x00000110) ADC Battery Load Enable                                    */

    struct {
      __IOM uint32_t BATTLOAD   : 1;            /*!< [0..0] Enable the ADC battery load resistor                               */
    } ADCBATTLOAD_b;
  } ;
  __IM  uint32_t  RESERVED4;

  union {
    __IOM uint32_t ADCTRIM;                     /*!< (@ 0x00000118) ADC Trims                                                  */

    struct {
      __IOM uint32_t ADCREFKEEPIBTRIM : 2;      /*!< [1..0] ADC Reference Ibias trim                                           */
      __IM  uint32_t            : 4;
      __IOM uint32_t ADCREFBUFTRIM : 5;         /*!< [10..6] ADC Reference buffer trim                                         */
      __IOM uint32_t ADCRFBUFIBTRIM : 2;        /*!< [12..11] ADC reference buffer input bias trim                             */
    } ADCTRIM_b;
  } ;

  union {
    __IOM uint32_t ADCREFCOMP;                  /*!< (@ 0x0000011C) ADC Referece Keeper and Comparator Control                 */

    struct {
      __IOM uint32_t ADC_REFCOMP_OUT : 1;       /*!< [0..0] Output of the ADC reference comparator                             */
      __IM  uint32_t            : 7;
      __IOM uint32_t ADCREFKEEPTRIM : 5;        /*!< [12..8] ADC Reference Keeper Trim                                         */
      __IM  uint32_t            : 3;
      __IOM uint32_t ADCRFCMPEN : 1;            /*!< [16..16] ADC Reference comparator power down                              */
    } ADCREFCOMP_b;
  } ;

  union {
    __IOM uint32_t XTALCTRL;                    /*!< (@ 0x00000120) XTAL Oscillator Control                                    */

    struct {
      __IOM uint32_t XTALSWE    : 1;            /*!< [0..0] XTAL Software Override Enable.                                     */
      __IOM uint32_t FDBKDSBLXTAL : 1;          /*!< [1..1] XTAL Oscillator Disable Feedback.                                  */
      __IOM uint32_t BYPCMPRXTAL : 1;           /*!< [2..2] XTAL Oscillator Bypass Comparator.                                 */
      __IOM uint32_t PDNBCOREXTAL : 1;          /*!< [3..3] XTAL Oscillator Power Down Core.                                   */
      __IOM uint32_t PDNBCMPRXTAL : 1;          /*!< [4..4] XTAL Oscillator Power Down Comparator.                             */
      __IOM uint32_t PWDBODXTAL : 1;            /*!< [5..5] XTAL Power down on brown out.                                      */
      __IOM uint32_t XTALIBUFTRIM : 2;          /*!< [7..6] XTAL IBUFF trim                                                    */
      __IOM uint32_t XTALICOMPTRIM : 2;         /*!< [9..8] XTAL ICOMP trim                                                    */
    } XTALCTRL_b;
  } ;

  union {
    __IOM uint32_t XTALGENCTRL;                 /*!< (@ 0x00000124) XTAL Oscillator General Control                            */

    struct {
      __IOM uint32_t ACWARMUP   : 2;            /*!< [1..0] Auto-calibration delay control                                     */
      __IOM uint32_t XTALBIASTRIM : 6;          /*!< [7..2] XTAL BIAS trim                                                     */
      __IOM uint32_t XTALKSBIASTRIM : 6;        /*!< [13..8] XTAL IBIAS Kick start trim. This trim value is used
                                                     during the startup process to enable a faster lock.                       */
    } XTALGENCTRL_b;
  } ;
  __IM  uint32_t  RESERVED5[28];

  union {
    __IOM uint32_t MISCCTRL;                    /*!< (@ 0x00000198) Miscellaneous control register.                            */

    struct {
      __IOM uint32_t RESERVED_RW_0 : 5;         /*!< [4..0] Reserved bits, always leave unchanged. The MISCCTRL register
                                                     must be modified via atomic RMW, leaving this bitfield
                                                     completely unmodified. Failure to do so will result in
                                                     unpredictable behavior.                                                   */
      __IOM uint32_t BLE_RESETN : 1;            /*!< [5..5] BLE reset signal.                                                  */
    } MISCCTRL_b;
  } ;
  __IM  uint32_t  RESERVED6;

  union {
    __IOM uint32_t BOOTLOADER;                  /*!< (@ 0x000001A0) Bootloader and secure boot functions                       */

    struct {
      __IOM uint32_t BOOTLOADERLOW : 1;         /*!< [0..0] Determines whether the bootloader code is visible at
                                                     address 0x00000000 or not. Resets to 1, write 1 to clear.                 */
      __IOM uint32_t SBLOCK     : 1;            /*!< [1..1] Secure boot lock. Always resets to 1, write 1 to clear.
                                                     Enables system visibility to bootloader until set.                        */
      __IOM uint32_t PROTLOCK   : 1;            /*!< [2..2] Flash protection lock. Always resets to 1, write 1 to
                                                     clear. Enables writes to flash protection register set.                   */
      __IM  uint32_t            : 23;
      __IOM uint32_t SECBOOTFEATURE : 2;        /*!< [27..26] Indicates whether the secure boot feature is enabled.            */
      __IOM uint32_t SECBOOT    : 2;            /*!< [29..28] Indicates whether the secure boot on cold reset is
                                                     enabled                                                                   */
      __IOM uint32_t SECBOOTONRST : 2;          /*!< [31..30] Indicates whether the secure boot on warm reset is
                                                     enabled                                                                   */
    } BOOTLOADER_b;
  } ;

  union {
    __IOM uint32_t SHADOWVALID;                 /*!< (@ 0x000001A4) Register to indicate whether the shadow registers
                                                                    have been successfully loaded from the Flash
                                                                    Information Space.                                         */

    struct {
      __IOM uint32_t VALID      : 1;            /*!< [0..0] Indicates whether the shadow registers contain valid
                                                     data from the Flash Information Space.                                    */
      __IOM uint32_t BLDSLEEP   : 1;            /*!< [1..1] Indicates whether the bootloader should sleep or deep
                                                     sleep if no image loaded.                                                 */
      __IOM uint32_t INFO0_VALID : 1;           /*!< [2..2] Indicates whether info0 contains valid data                        */
    } SHADOWVALID_b;
  } ;
  __IM  uint32_t  RESERVED7[2];

  union {
    __IOM uint32_t SCRATCH0;                    /*!< (@ 0x000001B0) Scratch register that is not reset by any reset            */

    struct {
      __IOM uint32_t SCRATCH0   : 32;           /*!< [31..0] Scratch register 0.                                               */
    } SCRATCH0_b;
  } ;

  union {
    __IOM uint32_t SCRATCH1;                    /*!< (@ 0x000001B4) Scratch register that is not reset by any reset            */

    struct {
      __IOM uint32_t SCRATCH1   : 32;           /*!< [31..0] Scratch register 1.                                               */
    } SCRATCH1_b;
  } ;
  __IM  uint32_t  RESERVED8[2];

  union {
    __IOM uint32_t ICODEFAULTADDR;              /*!< (@ 0x000001C0) ICODE bus address which was present when a bus
                                                                    fault occurred.                                            */

    struct {
      __IOM uint32_t ICODEFAULTADDR : 32;       /*!< [31..0] The ICODE bus address observed when a Bus Fault occurred.
                                                     Once an address is captured in this field, it is held until
                                                     the corresponding Fault Observed bit is cleared in the
                                                     FAULTSTATUS register.                                                     */
    } ICODEFAULTADDR_b;
  } ;

  union {
    __IOM uint32_t DCODEFAULTADDR;              /*!< (@ 0x000001C4) DCODE bus address which was present when a bus
                                                                    fault occurred.                                            */

    struct {
      __IOM uint32_t DCODEFAULTADDR : 32;       /*!< [31..0] The DCODE bus address observed when a Bus Fault occurred.
                                                     Once an address is captured in this field, it is held until
                                                     the corresponding Fault Observed bit is cleared in the
                                                     FAULTSTATUS register.                                                     */
    } DCODEFAULTADDR_b;
  } ;

  union {
    __IOM uint32_t SYSFAULTADDR;                /*!< (@ 0x000001C8) System bus address which was present when a bus
                                                                    fault occurred.                                            */

    struct {
      __IOM uint32_t SYSFAULTADDR : 32;         /*!< [31..0] SYS bus address observed when a Bus Fault occurred.
                                                     Once an address is captured in this field, it is held until
                                                     the corresponding Fault Observed bit is cleared in the
                                                     FAULTSTATUS register.                                                     */
    } SYSFAULTADDR_b;
  } ;

  union {
    __IOM uint32_t FAULTSTATUS;                 /*!< (@ 0x000001CC) Reflects the status of the bus decoders' fault
                                                                    detection. Any write to this register will
                                                                    clear all of the status bits within the
                                                                    register.                                                  */

    struct {
      __IOM uint32_t ICODEFAULT : 1;            /*!< [0..0] The ICODE Bus Decoder Fault Detected bit. When set, a
                                                     fault has been detected, and the ICODEFAULTADDR register
                                                     will contain the bus address which generated the fault.                   */
      __IOM uint32_t DCODEFAULT : 1;            /*!< [1..1] DCODE Bus Decoder Fault Detected bit. When set, a fault
                                                     has been detected, and the DCODEFAULTADDR register will
                                                     contain the bus address which generated the fault.                        */
      __IOM uint32_t SYSFAULT   : 1;            /*!< [2..2] SYS Bus Decoder Fault Detected bit. When set, a fault
                                                     has been detected, and the SYSFAULTADDR register will contain
                                                     the bus address which generated the fault.                                */
    } FAULTSTATUS_b;
  } ;

  union {
    __IOM uint32_t FAULTCAPTUREEN;              /*!< (@ 0x000001D0) Enable the fault capture registers                         */

    struct {
      __IOM uint32_t FAULTCAPTUREEN : 1;        /*!< [0..0] Fault Capture Enable field. When set, the Fault Capture
                                                     monitors are enabled and addresses which generate a hard
                                                     fault are captured into the FAULTADDR registers.                          */
    } FAULTCAPTUREEN_b;
  } ;
  __IM  uint32_t  RESERVED9[11];

  union {
    __IOM uint32_t DBGR1;                       /*!< (@ 0x00000200) Read-only debug register 1                                 */

    struct {
      __IOM uint32_t ONETO8     : 32;           /*!< [31..0] Read-only register for communication validation                   */
    } DBGR1_b;
  } ;

  union {
    __IOM uint32_t DBGR2;                       /*!< (@ 0x00000204) Read-only debug register 2                                 */

    struct {
      __IOM uint32_t COOLCODE   : 32;           /*!< [31..0] Read-only register for communication validation                   */
    } DBGR2_b;
  } ;
  __IM  uint32_t  RESERVED10[6];

  union {
    __IOM uint32_t PMUENABLE;                   /*!< (@ 0x00000220) Control bit to enable/disable the PMU                      */

    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< [0..0] PMU Enable Control bit. When set, the MCU's PMU will
                                                     place the MCU into the lowest power consuming Deep Sleep
                                                     mode upon execution of a WFI instruction (dependent on
                                                     the setting of the SLEEPDEEP bit in the ARM SCR register).
                                                     When cleared, regardless of the requested sleep mode, the
                                                     PMU will not enter the lowest power Deep Sleep mode, instead
                                                     entering the Sleep mode.                                                  */
    } PMUENABLE_b;
  } ;
  __IM  uint32_t  RESERVED11[11];

  union {
    __IOM uint32_t TPIUCTRL;                    /*!< (@ 0x00000250) TPIU Control Register. Determines the clock enable
                                                                    and frequency for the M4's TPIU interface.                 */

    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< [0..0] TPIU Enable field. When set, the ARM M4 TPIU is enabled
                                                     and data can be streamed out of the MCU's SWO port using
                                                     the ARM ITM and TPIU modules.                                             */
      __IM  uint32_t            : 7;
      __IOM uint32_t CLKSEL     : 3;            /*!< [10..8] This field selects the frequency of the ARM M4 TPIU
                                                     port.                                                                     */
    } TPIUCTRL_b;
  } ;
  __IM  uint32_t  RESERVED12[4];

  union {
    __IOM uint32_t OTAPOINTER;                  /*!< (@ 0x00000264) OTA (Over the Air) Update Pointer/Status. Reset
                                                                    only by POA                                                */

    struct {
      __IOM uint32_t OTAVALID   : 1;            /*!< [0..0] Indicates that an OTA update is valid                              */
      __IOM uint32_t OTASBLUPDATE : 1;          /*!< [1..1] Indicates that the sbl_init has been updated                       */
      __IOM uint32_t OTAPOINTER : 30;           /*!< [31..2] Flash page pointer with updated OTA image                         */
    } OTAPOINTER_b;
  } ;
  __IM  uint32_t  RESERVED13[6];

  union {
    __IOM uint32_t APBDMACTRL;                  /*!< (@ 0x00000280) DMA Control Register. Determines misc settings
                                                                    for DMA operation                                          */

    struct {
      __IOM uint32_t DMA_ENABLE : 1;            /*!< [0..0] Enable the DMA controller. When disabled, DMA requests
                                                     will be ignored by the controller                                         */
      __IOM uint32_t DECODEABORT : 1;           /*!< [1..1] APB Decode Abort. When set, the APB bridge will issue
                                                     a data abort (bus fault) on transactions to peripherals
                                                     that are powered down. When set to 0, writes are quietly
                                                     discarded and reads return 0.                                             */
      __IOM uint32_t DMAOPT     : 1;            /*!< [2..2] Enables DMA latency optimizations                                  */
      __IM  uint32_t            : 5;
      __IOM uint32_t HYSTERESIS : 8;            /*!< [15..8] This field determines how long the DMA will remain active
                                                     during deep sleep before shutting down and returning the
                                                     system to full deep sleep. Values are based on a 94KHz
                                                     clock and are roughly 10us increments for a range of ~10us
                                                     to 2.55ms                                                                 */
    } APBDMACTRL_b;
  } ;

  union {
    __IOM uint32_t SRAMMODE;                    /*!< (@ 0x00000284) SRAM Controller mode bits                                  */

    struct {
      __IOM uint32_t IPREFETCH  : 1;            /*!< [0..0] When set, instruction accesses to the SRAM banks will
                                                     be prefetched (normally 2 cycle read access). Generally,
                                                     this mode bit should be set for improved performance when
                                                     executing instructions from SRAM.                                         */
      __IOM uint32_t IPREFETCH_CACHE : 1;       /*!< [1..1] Secondary prefetch feature that will cache prefetched
                                                     data across bus waitstates (requires IPREFETCH to be set).                */
      __IM  uint32_t            : 2;
      __IOM uint32_t DPREFETCH  : 1;            /*!< [4..4] When set, data bus accesses to the SRAM banks will be
                                                     prefetched (normally 2 cycle read access). Use of this
                                                     mode bit is only recommended if the work flow has a large
                                                     number of sequential accesses.                                            */
      __IOM uint32_t DPREFETCH_CACHE : 1;       /*!< [5..5] Secondary prefetch feature that will cache prefetched
                                                     data across bus waitstates (requires DPREFETCH to be set).                */
    } SRAMMODE_b;
  } ;
  __IM  uint32_t  RESERVED14[48];

  union {
    __IOM uint32_t KEXTCLKSEL;                  /*!< (@ 0x00000348) Key Register to enable the use of external clock
                                                                    selects via the EXTCLKSEL reg                              */

    struct {
      __IOM uint32_t KEXTCLKSEL : 32;           /*!< [31..0] Key register value.                                               */
    } KEXTCLKSEL_b;
  } ;
  __IM  uint32_t  RESERVED15[4];

  union {
    __IOM uint32_t SIMOBUCK4;                   /*!< (@ 0x0000035C) SIMO Buck Control Reg1                                     */

    struct {
      __IM  uint32_t            : 21;
      __IOM uint32_t SIMOBUCKCLKDIVSEL : 2;     /*!< [22..21] simobuck_clkdiv_sel                                              */
    } SIMOBUCK4_b;
  } ;
  __IM  uint32_t  RESERVED16[2];

  union {
    __IOM uint32_t BLEBUCK2;                    /*!< (@ 0x00000368) BLEBUCK2 Control Reg                                       */

    struct {
      __IOM uint32_t BLEBUCKTONLOWTRIM : 6;     /*!< [5..0] blebuck_ton_low_trim                                               */
      __IOM uint32_t BLEBUCKTONHITRIM : 6;      /*!< [11..6] blebuck_ton_hi_trim                                               */
      __IOM uint32_t BLEBUCKTOND2ATRIM : 6;     /*!< [17..12] blebuck_ton_trim                                                 */
    } BLEBUCK2_b;
  } ;
  __IM  uint32_t  RESERVED17[13];

  union {
    __IOM uint32_t FLASHWPROT0;                 /*!< (@ 0x000003A0) Flash Write Protection Bits                                */

    struct {
      __IOM uint32_t FW0BITS    : 32;           /*!< [31..0] Write protect flash 0x00000000 - 0x0007FFFF. Each bit
                                                     provides write protection for 16KB chunks of flash data
                                                     space. Bits are cleared by writing a 1 to the bit. When
                                                     read, 0 indicates the region is protected. Bits are sticky
                                                     (can be set when PROTLOCK is 1, but only cleared by reset)                */
    } FLASHWPROT0_b;
  } ;

  union {
    __IOM uint32_t FLASHWPROT1;                 /*!< (@ 0x000003A4) Flash Write Protection Bits                                */

    struct {
      __IOM uint32_t FW1BITS    : 32;           /*!< [31..0] Write protect flash 0x00080000 - 0x000FFFFF. Each bit
                                                     provides write protection for 16KB chunks of flash data
                                                     space. Bits are cleared by writing a 1 to the bit. When
                                                     read, 0 indicates the region is protected. Bits are sticky
                                                     (can be set when PROTLOCK is 1, but only cleared by reset)                */
    } FLASHWPROT1_b;
  } ;

  union {
    __IOM uint32_t FLASHWPROT2;                 /*!< (@ 0x000003A8) Flash Write Protection Bits                                */

    struct {
      __IOM uint32_t FW2BITS    : 32;           /*!< [31..0] Write protect flash 0x00100000 - 0x0017FFFF. Each bit
                                                     provides write protection for 16KB chunks of flash data
                                                     space. Bits are cleared by writing a 1 to the bit. When
                                                     read, 0 indicates the region is protected. Bits are sticky
                                                     (can be set when PROTLOCK is 1, but only cleared by reset)                */
    } FLASHWPROT2_b;
  } ;

  union {
    __IOM uint32_t FLASHWPROT3;                 /*!< (@ 0x000003AC) Flash Write Protection Bits                                */

    struct {
      __IOM uint32_t FW3BITS    : 32;           /*!< [31..0] Write protect flash 0x00180000 - 0x001FFFFF. Each bit
                                                     provides write protection for 16KB chunks of flash data
                                                     space. Bits are cleared by writing a 1 to the bit. When
                                                     read, 0 indicates the region is protected. Bits are sticky
                                                     (can be set when PROTLOCK is 1, but only cleared by reset)                */
    } FLASHWPROT3_b;
  } ;

  union {
    __IOM uint32_t FLASHRPROT0;                 /*!< (@ 0x000003B0) Flash Read Protection Bits                                 */

    struct {
      __IOM uint32_t FR0BITS    : 32;           /*!< [31..0] Copy (read) protect flash 0x00000000 - 0x0007FFFF. Each
                                                     bit provides read protection for 16KB chunks of flash.
                                                     Bits are cleared by writing a 1 to the bit. When read,
                                                     0 indicates the region is protected. Bits are sticky (can
                                                     be set when PROTLOCK is 1, but only cleared by reset)                     */
    } FLASHRPROT0_b;
  } ;

  union {
    __IOM uint32_t FLASHRPROT1;                 /*!< (@ 0x000003B4) Flash Read Protection Bits                                 */

    struct {
      __IOM uint32_t FR1BITS    : 32;           /*!< [31..0] Copy (read) protect flash 0x00080000 - 0x000FFFFF. Each
                                                     bit provides read protection for 16KB chunks of flash.
                                                     Bits are cleared by writing a 1 to the bit. When read,
                                                     0 indicates the region is protected. Bits are sticky (can
                                                     be set when PROTLOCK is 1, but only cleared by reset)                     */
    } FLASHRPROT1_b;
  } ;

  union {
    __IOM uint32_t FLASHRPROT2;                 /*!< (@ 0x000003B8) Flash Read Protection Bits                                 */

    struct {
      __IOM uint32_t FR2BITS    : 32;           /*!< [31..0] Copy (read) protect flash 0x00100000 - 0x0017FFFF. Each
                                                     bit provides read protection for 16KB chunks of flash.
                                                     Bits are cleared by writing a 1 to the bit. When read,
                                                     0 indicates the region is protected. Bits are sticky (can
                                                     be set when PROTLOCK is 1, but only cleared by reset)                     */
    } FLASHRPROT2_b;
  } ;

  union {
    __IOM uint32_t FLASHRPROT3;                 /*!< (@ 0x000003BC) Flash Read Protection Bits                                 */

    struct {
      __IOM uint32_t FR3BITS    : 32;           /*!< [31..0] Copy (read) protect flash 0x00180000 - 0x001FFFFF. Each
                                                     bit provides read protection for 16KB chunks of flash.
                                                     Bits are cleared by writing a 1 to the bit. When read,
                                                     0 indicates the region is protected. Bits are sticky (can
                                                     be set when PROTLOCK is 1, but only cleared by reset)                     */
    } FLASHRPROT3_b;
  } ;

  union {
    __IOM uint32_t DMASRAMWRITEPROTECT0;        /*!< (@ 0x000003C0) SRAM write-protection bits.                                */

    struct {
      __IOM uint32_t DMA_WPROT0 : 32;           /*!< [31..0] Write protect SRAM from DMA. Each bit provides write
                                                     protection for an 8KB region of memory. When set to 1,
                                                     the region will be protected from DMA writes, when set
                                                     to 0, DMA may write the region.                                           */
    } DMASRAMWRITEPROTECT0_b;
  } ;

  union {
    __IOM uint32_t DMASRAMWRITEPROTECT1;        /*!< (@ 0x000003C4) SRAM write-protection bits.                                */

    struct {
      __IOM uint32_t DMA_WPROT1 : 32;           /*!< [31..0] Write protect SRAM from DMA. Each bit provides write
                                                     protection for an 8KB region of memory. When set to 1,
                                                     the region will be protected from DMA writes, when set
                                                     to 0, DMA may write the region.                                           */
    } DMASRAMWRITEPROTECT1_b;
  } ;
  __IM  uint32_t  RESERVED18[2];

  union {
    __IOM uint32_t DMASRAMREADPROTECT0;         /*!< (@ 0x000003D0) SRAM read-protection bits.                                 */

    struct {
      __IOM uint32_t DMA_RPROT0 : 32;           /*!< [31..0] Read protect SRAM from DMA. Each bit provides write
                                                     protection for an 8KB region of memory. When set to 1,
                                                     the region will be protected from DMA reads, when set to
                                                     0, DMA may read the region.                                               */
    } DMASRAMREADPROTECT0_b;
  } ;

  union {
    __IOM uint32_t DMASRAMREADPROTECT1;         /*!< (@ 0x000003D4) SRAM read-protection bits.                                 */

    struct {
      __IOM uint32_t DMA_RPROT1 : 32;           /*!< [31..0] Read protect SRAM from DMA. Each bit provides write
                                                     protection for an 8KB region of memory. When set to 1,
                                                     the region will be protected from DMA reads, when set to
                                                     0, DMA may read the region.                                               */
    } DMASRAMREADPROTECT1_b;
  } ;

  union {
    __IOM uint32_t DMASRAMREADPROTECT2;         /*!< (@ 0x000003D8) SRAM read-protection bits.                                 */

    struct {
      __IOM uint32_t DMA_RPROT2 : 32;           /*!< [31..0] Read protect SRAM from DMA. Each bit provides write
                                                     protection for an 8KB region of memory. When set to 1,
                                                     the region will be protected from DMA reads, when set to
                                                     0, DMA may read the region.                                               */
    } DMASRAMREADPROTECT2_b;
  } ;
} MCUCTRL_Type;                                 /*!< Size = 988 (0x3dc)                                                        */



/* =========================================================================================================================== */
/* ================                                           MSPI0                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Multibit SPI Master (MSPI0)
  */

typedef struct {                                /*!< (@ 0x50014000) MSPI0 Structure                                            */

  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000000) MSPI PIO Transfer Control/Status Register                  */

    struct {
      __IOM uint32_t START      : 1;            /*!< [0..0] Write to 1 to initiate a PIO transaction on the bus (typically
                                                     the entire register should be written at once with this
                                                     bit set).                                                                 */
      __IOM uint32_t STATUS     : 1;            /*!< [1..1] Command status: 1 indicates command has completed. Cleared
                                                     by writing 1 to this bit or starting a new transfer.                      */
      __IOM uint32_t BUSY       : 1;            /*!< [2..2] Command status: 1 indicates controller is busy (command
                                                     in progress)                                                              */
      __IOM uint32_t QUADCMD    : 1;            /*!< [3..3] Flag indicating that the operation is a command that
                                                     should be replicated to both devices in paired QUAD mode.
                                                     This is typically only used when reading/writing configuration
                                                     registers in paired flash devices (do not set for memory
                                                     transfers).                                                               */
      __IOM uint32_t ENWLAT     : 1;            /*!< [4..4] Enable Write Latency Counter (time between address and
                                                     first data byte). Counter value is WRITELATENCY.                          */
      __IOM uint32_t CONT       : 1;            /*!< [5..5] Continuation transfer. When 1, indicates that the MSPI
                                                     will hold CE low after the transaction completes. This
                                                     is included for compatibility with IOM module since the
                                                     MSPI transfer module can handle most cases in a single
                                                     transfer. NOTE: CONT functionality only works with CLKDIV=2
                                                     (24 MHz).                                                                 */
      __IOM uint32_t BIGENDIAN  : 1;            /*!< [6..6] 1 indicates data in FIFO is in big endian format (MSB
                                                     first); 0 indicates little endian data (default, LSB first).              */
      __IOM uint32_t ENTURN     : 1;            /*!< [7..7] Indicates whether TX->RX turnaround cycles should be
                                                     enabled for this operation (see TURNAROUND field in CFG
                                                     register).                                                                */
      __IOM uint32_t SENDA      : 1;            /*!< [8..8] Indicates whether an address phase should be sent (see
                                                     ADDR register and ASIZE field in CFG register)                            */
      __IOM uint32_t SENDI      : 1;            /*!< [9..9] Indicates whether an instruction phase should be sent
                                                     (see INSTR field and ISIZE field in CFG register)                         */
      __IOM uint32_t TXRX       : 1;            /*!< [10..10] 1 Indicates a TX operation, 0 indicates an RX operation
                                                     of XFERBYTES                                                              */
      __IOM uint32_t PIOSCRAMBLE : 1;           /*!< [11..11] Enables data scrambling for PIO opertions. This should
                                                     only be used for data operations and never for commands
                                                     to a device.                                                              */
      __IOM uint32_t ENDCX      : 1;            /*!< [12..12] Enable DCX signal on data [1]                                    */
      __IM  uint32_t            : 3;
      __IOM uint32_t XFERBYTES  : 16;           /*!< [31..16] Number of bytes to transmit or receive (based on TXRX
                                                     bit)                                                                      */
    } CTRL_b;
  } ;

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000004) MSPI Transfer Configuration Register                       */

    struct {
      __IOM uint32_t DEVCFG     : 4;            /*!< [3..0] Flash configuration for XIP and AUTO DMA operations.
                                                     Controls value for SER (Slave Enable) for XIP operations
                                                     and address generation for DMA/XIP modes. Also used to
                                                     configure SPIFRF (frame format).                                          */
      __IOM uint32_t ASIZE      : 2;            /*!< [5..4] Address Size. Address bytes to send from ADDR register             */
      __IOM uint32_t ISIZE      : 1;            /*!< [6..6] Instruction Sizeenum name = I8 value = 0x0 desc = Instruction
                                                     is 1 byteenum name = I16 value = 0x1 desc = Instruction
                                                     is 2 bytes                                                                */
      __IOM uint32_t SEPIO      : 1;            /*!< [7..7] Separate IO configuration. This bit should be set when
                                                     the target device has separate MOSI and MISO pins. Respective
                                                     IN/OUT bits below should be set to map pins.                              */
      __IOM uint32_t TURNAROUND : 6;            /*!< [13..8] Number of turnaound cycles (for TX->RX transitions).
                                                     Qualified by ENTURN or XIPENTURN bit field.                               */
      __IM  uint32_t            : 2;
      __IOM uint32_t CPHA       : 1;            /*!< [16..16] Serial clock phase.                                              */
      __IOM uint32_t CPOL       : 1;            /*!< [17..17] Serial clock polarity.                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t WRITELATENCY : 6;          /*!< [25..20] Number of cycles between addressn and TX data. Qualified
                                                     by ENLAT                                                                  */
    } CFG_b;
  } ;

  union {
    __IOM uint32_t ADDR;                        /*!< (@ 0x00000008) MSPI Transfer Address Register                             */

    struct {
      __IOM uint32_t ADDR       : 32;           /*!< [31..0] Optional Address field to send (after optional instruction
                                                     field) - qualified by ASIZE in CMD register. NOTE: This
                                                     register is aliased to DMADEVADDR.                                        */
    } ADDR_b;
  } ;

  union {
    __IOM uint32_t INSTR;                       /*!< (@ 0x0000000C) MSPI Transfer Instruction                                  */

    struct {
      __IOM uint32_t INSTR      : 16;           /*!< [15..0] Optional Instruction field to send (1st byte) - qualified
                                                     by ISEND/ISIZE                                                            */
    } INSTR_b;
  } ;

  union {
    __IOM uint32_t TXFIFO;                      /*!< (@ 0x00000010) TX Data FIFO                                               */

    struct {
      __IOM uint32_t TXFIFO     : 32;           /*!< [31..0] Data to be transmitted. Data should normall be aligned
                                                     to the LSB (pad the upper bits with zeros) unless BIGENDIAN
                                                     is set.                                                                   */
    } TXFIFO_b;
  } ;

  union {
    __IOM uint32_t RXFIFO;                      /*!< (@ 0x00000014) RX Data FIFO                                               */

    struct {
      __IOM uint32_t RXFIFO     : 32;           /*!< [31..0] Receive data. Data is aligned to the LSB (padded zeros
                                                     on upper bits) unless BIGENDIAN is set.                                   */
    } RXFIFO_b;
  } ;

  union {
    __IOM uint32_t TXENTRIES;                   /*!< (@ 0x00000018) TX FIFO Entries                                            */

    struct {
      __IOM uint32_t TXENTRIES  : 6;            /*!< [5..0] Number of 32-bit words/entries in TX FIFO                          */
    } TXENTRIES_b;
  } ;

  union {
    __IOM uint32_t RXENTRIES;                   /*!< (@ 0x0000001C) RX FIFO Entries                                            */

    struct {
      __IOM uint32_t RXENTRIES  : 6;            /*!< [5..0] Number of 32-bit words/entries in RX FIFO                          */
    } RXENTRIES_b;
  } ;

  union {
    __IOM uint32_t THRESHOLD;                   /*!< (@ 0x00000020) TX/RX FIFO Threshhold Levels                               */

    struct {
      __IOM uint32_t TXTHRESH   : 6;            /*!< [5..0] Number of entries in TX FIFO that cause TXF interrupt              */
      __IM  uint32_t            : 2;
      __IOM uint32_t RXTHRESH   : 6;            /*!< [13..8] Number of entries in TX FIFO that cause RXE interrupt             */
    } THRESHOLD_b;
  } ;
  __IM  uint32_t  RESERVED[55];

  union {
    __IOM uint32_t MSPICFG;                     /*!< (@ 0x00000100) MSPI Module Configuration                                  */

    struct {
      __IOM uint32_t APBCLK     : 1;            /*!< [0..0] Enable continuous APB clock. For power-efficient operation,
                                                     APBCLK should be set to 0.                                                */
      __IOM uint32_t RXCAP      : 1;            /*!< [1..1] Controls RX data capture phase. A setting of 0 (NORMAL)
                                                     captures read data at the normal capture point relative
                                                     to the internal clock launch point. However, to accomodate
                                                     chip/pad/board delays, a setting of RXCAP of 1 is expected
                                                     to be used to align the capture point with the return data
                                                     window. This bit is used in conjunction with RXNEG to provide
                                                     4 unique capture points, all about 10ns apart.                            */
      __IOM uint32_t RXNEG      : 1;            /*!< [2..2] Adjusts the RX capture phase to the negedge of the 48MHz
                                                     internal clock (~10ns early). For normal operation, it
                                                     is expected that RXNEG will be set to 0.                                  */
      __IOM uint32_t TXNEG      : 1;            /*!< [3..3] Launches TX data a half clock cycle (~10ns) early. This
                                                     should normally be programmed to zero (NORMAL).                           */
      __IOM uint32_t IOMSEL     : 4;            /*!< [7..4] Selects which IOM is selected for CQ handshake status.             */
      __IOM uint32_t CLKDIV     : 6;            /*!< [13..8] Clock Divider. Allows dividing 48 MHz base clock by
                                                     integer multiples. Enumerations are provided for common
                                                     frequency, but any integer divide from 48 MHz is allowed.
                                                     Odd divide ratios will result in a 33/66 percent duty cycle
                                                     with a long low clock pulse (to allow longer round-trip
                                                     for read data).                                                           */
      __IM  uint32_t            : 15;
      __IOM uint32_t FIFORESET  : 1;            /*!< [29..29] Reset MSPI FIFO (active high). 1=reset FIFO, 0=normal
                                                     operation. May be used to manually flush the FIFO in error
                                                     handling.                                                                 */
      __IOM uint32_t IPRSTN     : 1;            /*!< [30..30] IP block reset. Write to 0 to put the transfer module
                                                     in reset or 1 for normal operation. This may be required
                                                     after error conditions to clear the transfer on the bus.                  */
      __IOM uint32_t PRSTN      : 1;            /*!< [31..31] Peripheral reset. Master reset to the entire MSPI module
                                                     (DMA, XIP, and transfer state machines). 1=normal operation,
                                                     0=in reset.                                                               */
    } MSPICFG_b;
  } ;

  union {
    __IOM uint32_t MSPIDDR;                     /*!< (@ 0x00000104) MSPI Module DDR Configuration Bits                         */

    struct {
      __IOM uint32_t EMULATEDDR : 1;            /*!< [0..0] Drive external clock at 1/2 rate to emulate DDR mode               */
      __IOM uint32_t QUADDDR    : 1;            /*!< [1..1] Enables use of delay line to provide fine control over
                                                     traditional RX capture clock.                                             */
      __IOM uint32_t ENABLEDQS  : 1;            /*!< [2..2] In EMULATEDDR mode, enable DQS for read capture                    */
      __IOM uint32_t DQSSYNCNEG : 1;            /*!< [3..3] Use negative edge of clock for DDR data sync                       */
      __IOM uint32_t OVERRIDERXDQSDELAY : 1;    /*!< [4..4] Override DQS delay line with the value in DQSDELAY (for
                                                     RX capture in QUADDDR mode)                                               */
      __IOM uint32_t OVERRIDEDDRCLKOUTDELAY : 1;/*!< [5..5] Override TX delay line with the value in DQSDELAY (for
                                                     TX clock offset when in QUADDDR mode)                                     */
      __IOM uint32_t ENABLEFINEDELAY : 1;       /*!< [6..6] Enables use of delay line to provide fine control over
                                                     traditional RX capture clock.                                             */
      __IM  uint32_t            : 1;
      __IOM uint32_t RXDQSDELAY : 5;            /*!< [12..8] When OVERRIDEDQSDELAY is set this sets the DQS delayline
                                                     value. In ENABLEDQS mode, this acts as an offset to the
                                                     computed value (should be set to 0 by default)                            */
      __IM  uint32_t            : 3;
      __IOM uint32_t TXDQSDELAY : 5;            /*!< [20..16] When OVERRIDEDQSDELAY is set this sets the DQS delayline
                                                     value. In ENABLEDQS mode, this acts as an offset to the
                                                     computed value (should be set to 0 by default)                            */
    } MSPIDDR_b;
  } ;
  __IM  uint32_t  RESERVED1[2];

  union {
    __IOM uint32_t PADCFG;                      /*!< (@ 0x00000110) MSPI Output Pad Configuration                              */

    struct {
      __IOM uint32_t OUT3       : 1;            /*!< [0..0] Output pad 3 configuration. 0=data[3] 1=CLK                        */
      __IOM uint32_t OUT4       : 1;            /*!< [1..1] Output pad 4 configuration. 0=data[4] 1=data[0]                    */
      __IOM uint32_t OUT5       : 1;            /*!< [2..2] Output pad 5 configuration. 0=data[5] 1=data[1]                    */
      __IOM uint32_t OUT6       : 1;            /*!< [3..3] Output pad 6 configuration. 0=data[6] 1=data[2]                    */
      __IOM uint32_t OUT7       : 1;            /*!< [4..4] Output pad 7 configuration. 0=data[7] 1=data[3]                    */
      __IM  uint32_t            : 11;
      __IOM uint32_t IN0        : 2;            /*!< [17..16] Data Input pad 0 pin muxing: 0=pad[0] 1=pad[4] 2=pad[1]
                                                     3=pad[5]                                                                  */
      __IOM uint32_t IN1        : 1;            /*!< [18..18] Data Input pad 1 pin muxing: 0=pad[1] 1=pad[5]                   */
      __IOM uint32_t IN2        : 1;            /*!< [19..19] Data Input pad 2 pin muxing: 0=pad[2] 1=pad[6]                   */
      __IOM uint32_t IN3        : 1;            /*!< [20..20] Data Input pad 3 pin muxing: 0=pad[3] 1=pad[7]                   */
      __IOM uint32_t REVCS      : 1;            /*!< [21..21] Reverse CS connections. Allows CS1 to be associated
                                                     with lower data lanes and CS0 to be associated with upper
                                                     data lines                                                                */
    } PADCFG_b;
  } ;

  union {
    __IOM uint32_t PADOUTEN;                    /*!< (@ 0x00000114) MSPI Output Enable Pad Configuration                       */

    struct {
      __IOM uint32_t OUTEN      : 10;           /*!< [9..0] Output pad enable configuration. Indicates which pads
                                                     should be driven. Bits [3:0] are Quad0 data, [7:4] are
                                                     Quad1 data, and [8] is clock.                                             */
    } PADOUTEN_b;
  } ;

  union {
    __IOM uint32_t PADOVEREN;                   /*!< (@ 0x00000118) MSPI Output Pad Override                                   */

    struct {
      __IOM uint32_t OVERRIDEEN : 10;           /*!< [9..0] Output pad override enable. Bit mask for pad outputs.
                                                     When set to 1, the values in the OVERRIDE field are driven
                                                     on the pad (output enable is implicitly set in this mode).
                                                     [7:0]=data [8]=clock [9]=DM                                               */
    } PADOVEREN_b;
  } ;

  union {
    __IOM uint32_t PADOVER;                     /*!< (@ 0x0000011C) MSPI Output Pad Override Value                             */

    struct {
      __IOM uint32_t OVERRIDE   : 10;           /*!< [9..0] Output pad override value. [7:0]=data [8]=clock [9]=DM             */
    } PADOVER_b;
  } ;

  union {
    __IOM uint32_t FLASH;                       /*!< (@ 0x00000120) Configuration for XIP/DMA support of SPI flash
                                                                    modules.                                                   */

    struct {
      __IOM uint32_t XIPEN      : 1;            /*!< [0..0] Enable the XIP (eXecute In Place) function which effectively
                                                     enables the address decoding of the MSPI device in the
                                                     flash/cache address space at address 0x04000000-0x07FFFFFF.               */
      __IOM uint32_t XIPENDCX   : 1;            /*!< [1..1] Enable DCX signal on data [1] for XIP/DMA operations               */
      __IOM uint32_t XIPACK     : 2;            /*!< [3..2] Controls transmission of Micron XIP acknowledge cycles
                                                     (Micron Flash devices only)                                               */
      __IOM uint32_t XIPBIGENDIAN : 1;          /*!< [4..4] Indicates whether XIP/AUTO DMA data transfers are in
                                                     big or little endian format                                               */
      __IOM uint32_t XIPENTURN  : 1;            /*!< [5..5] Indicates whether XIP/AUTO DMA operations should enable
                                                     TX->RX turnaround cycles                                                  */
      __IOM uint32_t XIPSENDA   : 1;            /*!< [6..6] Indicates whether XIP/AUTO DMA operations should send
                                                     an an address phase (see DMADEVADDR register and ASIZE
                                                     field in CFG)                                                             */
      __IOM uint32_t XIPSENDI   : 1;            /*!< [7..7] Indicates whether XIP/AUTO DMA operations should send
                                                     an instruction (see READINSTR field and ISIZE field in
                                                     CFG)                                                                      */
      __IOM uint32_t XIPMIXED   : 3;            /*!< [10..8] Reserved. Set to 0x0                                              */
      __IOM uint32_t XIPENWLAT  : 1;            /*!< [11..11] Enable Write Latency counter for XIP write transactions          */
    } FLASH_b;
  } ;

  union {
    __IOM uint32_t XIPINSTR;                    /*!< (@ 0x00000124) Configuration for XIP/DMA support of SPI flash
                                                                    modules.                                                   */

    struct {
      __IOM uint32_t WRITEINSTR : 16;           /*!< [15..0] Write command sent for DMA operations                             */
      __IOM uint32_t READINSTR  : 16;           /*!< [31..16] Read command sent to flash for DMA/XIP operations                */
    } XIPINSTR_b;
  } ;

  union {
    __IOM uint32_t SCRAMBLING;                  /*!< (@ 0x00000128) External Flash Scrambling Controls                         */

    struct {
      __IOM uint32_t SCRSTART   : 10;           /*!< [9..0] Scrambling region start address [25:16] (64K block granularity).
                                                     The START block is the FIRST block included in the scrambled
                                                     address range.                                                            */
      __IM  uint32_t            : 6;
      __IOM uint32_t SCREND     : 10;           /*!< [25..16] Scrambling region end address [25:16] (64K block granularity).
                                                     The END block is the LAST block included in the scrambled
                                                     address range.                                                            */
      __IM  uint32_t            : 5;
      __IOM uint32_t SCRENABLE  : 1;            /*!< [31..31] Enables Data Scrambling Region. When 1 reads and writes
                                                     to the range will be scrambled. When 0, data will be read/written
                                                     unmodified. Address range is specified in 64K granularity
                                                     and the START/END ranges are included within the range.                   */
    } SCRAMBLING_b;
  } ;
  __IM  uint32_t  RESERVED2[53];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) MSPI Master Interrupts: Enable                             */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Transfer complete. Note that DMA and CQ operations are
                                                     layered, so CMDCMP, DCMP, and CQ* can all be signalled
                                                     simultaneously                                                            */
      __IOM uint32_t TXE        : 1;            /*!< [1..1] Transmit FIFO empty.                                               */
      __IOM uint32_t TXO        : 1;            /*!< [2..2] Transmit FIFO Overflow (only occurs when SW writes to
                                                     a full FIFO).                                                             */
      __IOM uint32_t RXU        : 1;            /*!< [3..3] Receive FIFO underflow (only occurs when SW reads from
                                                     an empty FIFO)                                                            */
      __IOM uint32_t RXO        : 1;            /*!< [4..4] Receive FIFO overflow (cannot happen in MSPI design --
                                                     MSPI bus pins will stall)                                                 */
      __IOM uint32_t RXF        : 1;            /*!< [5..5] Receive FIFO full                                                  */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Complete Interrupt                                             */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Interrupt                                                */
      __IOM uint32_t CQCMP      : 1;            /*!< [8..8] Command Queue Complete Interrupt                                   */
      __IOM uint32_t CQUPD      : 1;            /*!< [9..9] Command Queue Update Interrupt. Issued whenever the CQ
                                                     performs an operation where address bit[0] is set. Useful
                                                     for triggering CURIDX interrupts.                                         */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [10..10] Command Queue is Paused.                                         */
      __IOM uint32_t CQERR      : 1;            /*!< [11..11] Command Queue Error Interrupt                                    */
      __IOM uint32_t SCRERR     : 1;            /*!< [12..12] Scrambling Alignment Error. Scrambling operations must
                                                     be aligned to word (4-byte) start address.                                */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) MSPI Master Interrupts: Status                             */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Transfer complete. Note that DMA and CQ operations are
                                                     layered, so CMDCMP, DCMP, and CQ* can all be signalled
                                                     simultaneously                                                            */
      __IOM uint32_t TXE        : 1;            /*!< [1..1] Transmit FIFO empty.                                               */
      __IOM uint32_t TXO        : 1;            /*!< [2..2] Transmit FIFO Overflow (only occurs when SW writes to
                                                     a full FIFO).                                                             */
      __IOM uint32_t RXU        : 1;            /*!< [3..3] Receive FIFO underflow (only occurs when SW reads from
                                                     an empty FIFO)                                                            */
      __IOM uint32_t RXO        : 1;            /*!< [4..4] Receive FIFO overflow (cannot happen in MSPI design --
                                                     MSPI bus pins will stall)                                                 */
      __IOM uint32_t RXF        : 1;            /*!< [5..5] Receive FIFO full                                                  */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Complete Interrupt                                             */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Interrupt                                                */
      __IOM uint32_t CQCMP      : 1;            /*!< [8..8] Command Queue Complete Interrupt                                   */
      __IOM uint32_t CQUPD      : 1;            /*!< [9..9] Command Queue Update Interrupt. Issued whenever the CQ
                                                     performs an operation where address bit[0] is set. Useful
                                                     for triggering CURIDX interrupts.                                         */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [10..10] Command Queue is Paused.                                         */
      __IOM uint32_t CQERR      : 1;            /*!< [11..11] Command Queue Error Interrupt                                    */
      __IOM uint32_t SCRERR     : 1;            /*!< [12..12] Scrambling Alignment Error. Scrambling operations must
                                                     be aligned to word (4-byte) start address.                                */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) MSPI Master Interrupts: Clear                              */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Transfer complete. Note that DMA and CQ operations are
                                                     layered, so CMDCMP, DCMP, and CQ* can all be signalled
                                                     simultaneously                                                            */
      __IOM uint32_t TXE        : 1;            /*!< [1..1] Transmit FIFO empty.                                               */
      __IOM uint32_t TXO        : 1;            /*!< [2..2] Transmit FIFO Overflow (only occurs when SW writes to
                                                     a full FIFO).                                                             */
      __IOM uint32_t RXU        : 1;            /*!< [3..3] Receive FIFO underflow (only occurs when SW reads from
                                                     an empty FIFO)                                                            */
      __IOM uint32_t RXO        : 1;            /*!< [4..4] Receive FIFO overflow (cannot happen in MSPI design --
                                                     MSPI bus pins will stall)                                                 */
      __IOM uint32_t RXF        : 1;            /*!< [5..5] Receive FIFO full                                                  */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Complete Interrupt                                             */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Interrupt                                                */
      __IOM uint32_t CQCMP      : 1;            /*!< [8..8] Command Queue Complete Interrupt                                   */
      __IOM uint32_t CQUPD      : 1;            /*!< [9..9] Command Queue Update Interrupt. Issued whenever the CQ
                                                     performs an operation where address bit[0] is set. Useful
                                                     for triggering CURIDX interrupts.                                         */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [10..10] Command Queue is Paused.                                         */
      __IOM uint32_t CQERR      : 1;            /*!< [11..11] Command Queue Error Interrupt                                    */
      __IOM uint32_t SCRERR     : 1;            /*!< [12..12] Scrambling Alignment Error. Scrambling operations must
                                                     be aligned to word (4-byte) start address.                                */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) MSPI Master Interrupts: Set                                */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Transfer complete. Note that DMA and CQ operations are
                                                     layered, so CMDCMP, DCMP, and CQ* can all be signalled
                                                     simultaneously                                                            */
      __IOM uint32_t TXE        : 1;            /*!< [1..1] Transmit FIFO empty.                                               */
      __IOM uint32_t TXO        : 1;            /*!< [2..2] Transmit FIFO Overflow (only occurs when SW writes to
                                                     a full FIFO).                                                             */
      __IOM uint32_t RXU        : 1;            /*!< [3..3] Receive FIFO underflow (only occurs when SW reads from
                                                     an empty FIFO)                                                            */
      __IOM uint32_t RXO        : 1;            /*!< [4..4] Receive FIFO overflow (cannot happen in MSPI design --
                                                     MSPI bus pins will stall)                                                 */
      __IOM uint32_t RXF        : 1;            /*!< [5..5] Receive FIFO full                                                  */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Complete Interrupt                                             */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Interrupt                                                */
      __IOM uint32_t CQCMP      : 1;            /*!< [8..8] Command Queue Complete Interrupt                                   */
      __IOM uint32_t CQUPD      : 1;            /*!< [9..9] Command Queue Update Interrupt. Issued whenever the CQ
                                                     performs an operation where address bit[0] is set. Useful
                                                     for triggering CURIDX interrupts.                                         */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [10..10] Command Queue is Paused.                                         */
      __IOM uint32_t CQERR      : 1;            /*!< [11..11] Command Queue Error Interrupt                                    */
      __IOM uint32_t SCRERR     : 1;            /*!< [12..12] Scrambling Alignment Error. Scrambling operations must
                                                     be aligned to word (4-byte) start address.                                */
    } INTSET_b;
  } ;
  __IM  uint32_t  RESERVED3[16];

  union {
    __IOM uint32_t DMACFG;                      /*!< (@ 0x00000250) DMA Configuration Register                                 */

    struct {
      __IOM uint32_t DMAEN      : 2;            /*!< [1..0] DMA Enable. Setting this bit to EN will start the DMA
                                                     operation                                                                 */
      __IOM uint32_t DMADIR     : 1;            /*!< [2..2] Direction                                                          */
      __IOM uint32_t DMAPRI     : 2;            /*!< [4..3] Sets the Priority of the DMA request                               */
      __IM  uint32_t            : 13;
      __IOM uint32_t DMAPWROFF  : 1;            /*!< [18..18] Power off MSPI domain upon completion of DMA operation.          */
    } DMACFG_b;
  } ;

  union {
    __IOM uint32_t DMASTAT;                     /*!< (@ 0x00000254) DMA Status Register                                        */

    struct {
      __IOM uint32_t DMATIP     : 1;            /*!< [0..0] DMA Transfer In Progress indicator. 1 will indicate that
                                                     a DMA transfer is active. The DMA transfer may be waiting
                                                     on data, transferring data, or waiting for priority. All
                                                     of these will be indicated with a 1. A 0 will indicate
                                                     that the DMA is fully complete and no further transactions
                                                     will be done.                                                             */
      __IOM uint32_t DMACPL     : 1;            /*!< [1..1] DMA Transfer Complete. This signals the end of the DMA
                                                     operation.                                                                */
      __IOM uint32_t DMAERR     : 1;            /*!< [2..2] DMA Error. This active high bit signals that an error
                                                     was encountered during the DMA operation.                                 */
      __IOM uint32_t SCRERR     : 1;            /*!< [3..3] Scrambling Access Alignment Error. This active high bit
                                                     signals that a scrambling operation was specified for a
                                                     non-word aligned DEVADDR.                                                 */
    } DMASTAT_b;
  } ;

  union {
    __IOM uint32_t DMATARGADDR;                 /*!< (@ 0x00000258) DMA Target Address Register                                */

    struct {
      __IOM uint32_t TARGADDR   : 32;           /*!< [31..0] Target byte address for source of DMA (either read or
                                                     write). In cases of non-word aligned addresses, the DMA
                                                     logic will take care for ensuring only the target bytes
                                                     are read/written.                                                         */
    } DMATARGADDR_b;
  } ;

  union {
    __IOM uint32_t DMADEVADDR;                  /*!< (@ 0x0000025C) DMA Device Address Register                                */

    struct {
      __IOM uint32_t DEVADDR    : 32;           /*!< [31..0] SPI Device address for automated DMA transactions (both
                                                     read and write).                                                          */
    } DMADEVADDR_b;
  } ;

  union {
    __IOM uint32_t DMATOTCOUNT;                 /*!< (@ 0x00000260) DMA Total Transfer Count                                   */

    struct {
      __IOM uint32_t TOTCOUNT   : 24;           /*!< [23..0] Total Transfer Count in bytes.                                    */
    } DMATOTCOUNT_b;
  } ;

  union {
    __IOM uint32_t DMABCOUNT;                   /*!< (@ 0x00000264) DMA BYTE Transfer Count                                    */

    struct {
      __IOM uint32_t BCOUNT     : 8;            /*!< [7..0] Burst transfer size in bytes. This is the number of bytes
                                                     transferred when a FIFO trigger event occurs. Recommended
                                                     value is 32.                                                              */
    } DMABCOUNT_b;
  } ;

  union {
    __IOM uint32_t DMATHRESH;                   /*!< (@ 0x00000268) DMA Transmit Trigger Threshhold                            */

    struct {
      __IOM uint32_t DMATXTHRESH : 5;           /*!< [4..0] DMA transfer FIFO level trigger. For read operations,
                                                     DMA is triggered when the FIFO level is greater than this
                                                     value. For write operations, DMA is triggered when the
                                                     FIFO level is less than this level. Each DMA operation
                                                     will consist of BCOUNT bytes.                                             */
      __IM  uint32_t            : 3;
      __IOM uint32_t DMARXTHRESH : 5;           /*!< [12..8] DMA transfer FIFO level trigger. For read operations,
                                                     DMA is triggered when the FIFO level is greater than this
                                                     value. For write operations, DMA is triggered when the
                                                     FIFO level is less than this level. Each DMA operation
                                                     will consist of BCOUNT bytes.                                             */
    } DMATHRESH_b;
  } ;

  union {
    __IOM uint32_t DMABOUNDARY;                 /*!< (@ 0x0000026C) DMA Transfer Boundary                                      */

    struct {
      __IOM uint32_t DMATIMELIMIT : 12;         /*!< [11..0] DMA time limit. Can be used to limit the tranaction
                                                     time on the MSPI bus. The count is in 100ns incremements.
                                                     A value of 0 disables the counter                                         */
      __IOM uint32_t DMABOUND   : 4;            /*!< [15..12] DMA Address boundray                                             */
    } DMABOUNDARY_b;
  } ;
  __IM  uint32_t  RESERVED4[12];

  union {
    __IOM uint32_t CQCFG;                       /*!< (@ 0x000002A0) Command Queue Configuration Register                       */

    struct {
      __IOM uint32_t CQEN       : 1;            /*!< [0..0] Command queue enable. When set, will enable the processing
                                                     of the command queue                                                      */
      __IOM uint32_t CQPRI      : 1;            /*!< [1..1] Sets the Priority of the command queue dma request                 */
      __IOM uint32_t CQPWROFF   : 1;            /*!< [2..2] Power off MSPI domain upon completion of DMA operation.            */
      __IOM uint32_t CQAUTOCLEARMASK : 1;       /*!< [3..3] Enable clear of CQMASK after each pause operation. This
                                                     may be useful when using software flags to pause CQ.                      */
    } CQCFG_b;
  } ;
  __IM  uint32_t  RESERVED5;

  union {
    __IOM uint32_t CQADDR;                      /*!< (@ 0x000002A8) CQ Target Read Address Register                            */

    struct {
      __IOM uint32_t CQADDR     : 29;           /*!< [28..0] Address of command queue buffer in SRAM or flash. The
                                                     buffer address must be aligned to a word boundary.                        */
    } CQADDR_b;
  } ;

  union {
    __IOM uint32_t CQSTAT;                      /*!< (@ 0x000002AC) Command Queue Status Register                              */

    struct {
      __IOM uint32_t CQTIP      : 1;            /*!< [0..0] Command queue Transfer In Progress indicator. 1 will
                                                     indicate that a CQ transfer is active and this will remain
                                                     active even when paused waiting for external event.                       */
      __IOM uint32_t CQCPL      : 1;            /*!< [1..1] Command queue operation Complete. This signals the end
                                                     of the command queue operation.                                           */
      __IOM uint32_t CQERR      : 1;            /*!< [2..2] Command queue processing Error. This active high bit
                                                     signals that an error was encountered during the CQ operation.            */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [3..3] Command queue is currently paused status.                          */
    } CQSTAT_b;
  } ;

  union {
    __IOM uint32_t CQFLAGS;                     /*!< (@ 0x000002B0) Command Queue Flag Register                                */

    struct {
      __IOM uint32_t CQFLAGS    : 16;           /*!< [15..0] Current flag status (read-only). Bits [7:0] are software
                                                     controllable and bits [15:8] are hardware status.                         */
    } CQFLAGS_b;
  } ;

  union {
    __IOM uint32_t CQSETCLEAR;                  /*!< (@ 0x000002B4) Command Queue Flag Set/Clear Register                      */

    struct {
      __IOM uint32_t CQFSET     : 8;            /*!< [7..0] Set CQFlag status bits. Set has priority over clear if
                                                     both are high.                                                            */
      __IOM uint32_t CQFTOGGLE  : 8;            /*!< [15..8] Toggle CQFlag status bits                                         */
      __IOM uint32_t CQFCLR     : 8;            /*!< [23..16] Clear CQFlag status bits.                                        */
    } CQSETCLEAR_b;
  } ;

  union {
    __IOM uint32_t CQPAUSE;                     /*!< (@ 0x000002B8) Command Queue Pause Mask Register                          */

    struct {
      __IOM uint32_t CQMASK     : 16;           /*!< [15..0] CQ will pause processing when ALL specified events are
                                                     satisfied -- i.e. when (CQMASK and CQPAUSE)==CQMASK.                      */
    } CQPAUSE_b;
  } ;
  __IM  uint32_t  RESERVED6;

  union {
    __IOM uint32_t CQCURIDX;                    /*!< (@ 0x000002C0) Command Queue Current Index                                */

    struct {
      __IOM uint32_t CQCURIDX   : 8;            /*!< [7..0] Can be used to indicate the current position of the command
                                                     queue by having CQ operations write this field. A CQ hardware
                                                     status flag indicates when CURIDX and ENDIDX are not equal,
                                                     allowing SW to pause the CQ processing until the end index
                                                     is updated.                                                               */
    } CQCURIDX_b;
  } ;

  union {
    __IOM uint32_t CQENDIDX;                    /*!< (@ 0x000002C4) Command Queue End Index                                    */

    struct {
      __IOM uint32_t CQENDIDX   : 8;            /*!< [7..0] Can be used to indicate the end position of the command
                                                     queue. A CQ hardware status bit indices when CURIDX !=
                                                     ENDIDX so that the CQ can be paused when it reaches the
                                                     end pointer.                                                              */
    } CQENDIDX_b;
  } ;
} MSPI0_Type;                                   /*!< Size = 712 (0x2c8)                                                        */



/* =========================================================================================================================== */
/* ================                                            PDM                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief PDM Audio (PDM)
  */

typedef struct {                                /*!< (@ 0x50011000) PDM Structure                                              */

  union {
    __IOM uint32_t PCFG;                        /*!< (@ 0x00000000) PDM Configuration Register                                 */

    struct {
      __IOM uint32_t PDMCOREEN  : 1;            /*!< [0..0] Data Streaming Control.                                            */
      __IOM uint32_t SOFTMUTE   : 1;            /*!< [1..1] Soft mute control.                                                 */
      __IOM uint32_t CYCLES     : 3;            /*!< [4..2] Number of clocks during gain-setting changes.                      */
      __IOM uint32_t HPCUTOFF   : 4;            /*!< [8..5] High pass filter coefficients.                                     */
      __IOM uint32_t ADCHPD     : 1;            /*!< [9..9] High pass filter control.                                          */
      __IOM uint32_t SINCRATE   : 7;            /*!< [16..10] SINC decimation rate.                                            */
      __IOM uint32_t MCLKDIV    : 2;            /*!< [18..17] PDM_CLK frequency divisor.                                       */
      __IM  uint32_t            : 2;
      __IOM uint32_t PGALEFT    : 5;            /*!< [25..21] Left channel PGA gain.                                           */
      __IOM uint32_t PGARIGHT   : 5;            /*!< [30..26] Right channel PGA gain.                                          */
      __IOM uint32_t LRSWAP     : 1;            /*!< [31..31] Left/right channel swap.                                         */
    } PCFG_b;
  } ;

  union {
    __IOM uint32_t VCFG;                        /*!< (@ 0x00000004) Voice Configuration Register                               */

    struct {
      __IM  uint32_t            : 3;
      __IOM uint32_t CHSET      : 2;            /*!< [4..3] Set PCM channels.                                                  */
      __IM  uint32_t            : 3;
      __IOM uint32_t PCMPACK    : 1;            /*!< [8..8] PCM data packing enable.                                           */
      __IM  uint32_t            : 7;
      __IOM uint32_t SELAP      : 1;            /*!< [16..16] Select PDM input clock source.                                   */
      __IOM uint32_t DMICKDEL   : 1;            /*!< [17..17] PDM clock sampling delay.                                        */
      __IM  uint32_t            : 1;
      __IOM uint32_t BCLKINV    : 1;            /*!< [19..19] I2S BCLK input inversion.                                        */
      __IOM uint32_t I2SEN      : 1;            /*!< [20..20] I2S interface enable.                                            */
      __IM  uint32_t            : 5;
      __IOM uint32_t PDMCLKEN   : 1;            /*!< [26..26] Enable the serial clock.                                         */
      __IOM uint32_t PDMCLKSEL  : 3;            /*!< [29..27] Select the PDM input clock.                                      */
      __IOM uint32_t RSTB       : 1;            /*!< [30..30] Reset the IP core.                                               */
      __IOM uint32_t IOCLKEN    : 1;            /*!< [31..31] Enable the IO clock.                                             */
    } VCFG_b;
  } ;

  union {
    __IOM uint32_t VOICESTAT;                   /*!< (@ 0x00000008) Voice Status Register                                      */

    struct {
      __IOM uint32_t FIFOCNT    : 6;            /*!< [5..0] Valid 32-bit entries currently in the FIFO.                        */
    } VOICESTAT_b;
  } ;

  union {
    __IOM uint32_t FIFOREAD;                    /*!< (@ 0x0000000C) FIFO Read                                                  */

    struct {
      __IOM uint32_t FIFOREAD   : 32;           /*!< [31..0] FIFO read data.                                                   */
    } FIFOREAD_b;
  } ;

  union {
    __IOM uint32_t FIFOFLUSH;                   /*!< (@ 0x00000010) FIFO Flush                                                 */

    struct {
      __IOM uint32_t FIFOFLUSH  : 1;            /*!< [0..0] FIFO FLUSH.                                                        */
    } FIFOFLUSH_b;
  } ;

  union {
    __IOM uint32_t FIFOTHR;                     /*!< (@ 0x00000014) FIFO Threshold                                             */

    struct {
      __IOM uint32_t FIFOTHR    : 5;            /*!< [4..0] FIFO Threshold value. When the FIFO count is equal to,
                                                     or larger than this value (in words), a THR interrupt is
                                                     generated (if enabled)                                                    */
    } FIFOTHR_b;
  } ;
  __IM  uint32_t  RESERVED[122];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) IO Master Interrupts: Enable                               */

    struct {
      __IOM uint32_t THR        : 1;            /*!< [0..0] This is the FIFO threshold interrupt.                              */
      __IOM uint32_t OVF        : 1;            /*!< [1..1] This is the FIFO overflow interrupt.                               */
      __IOM uint32_t UNDFL      : 1;            /*!< [2..2] This is the FIFO underflow interrupt.                              */
      __IOM uint32_t DCMP       : 1;            /*!< [3..3] DMA completed a transfer                                           */
      __IOM uint32_t DERR       : 1;            /*!< [4..4] DMA Error receieved                                                */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) IO Master Interrupts: Status                               */

    struct {
      __IOM uint32_t THR        : 1;            /*!< [0..0] This is the FIFO threshold interrupt.                              */
      __IOM uint32_t OVF        : 1;            /*!< [1..1] This is the FIFO overflow interrupt.                               */
      __IOM uint32_t UNDFL      : 1;            /*!< [2..2] This is the FIFO underflow interrupt.                              */
      __IOM uint32_t DCMP       : 1;            /*!< [3..3] DMA completed a transfer                                           */
      __IOM uint32_t DERR       : 1;            /*!< [4..4] DMA Error receieved                                                */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) IO Master Interrupts: Clear                                */

    struct {
      __IOM uint32_t THR        : 1;            /*!< [0..0] This is the FIFO threshold interrupt.                              */
      __IOM uint32_t OVF        : 1;            /*!< [1..1] This is the FIFO overflow interrupt.                               */
      __IOM uint32_t UNDFL      : 1;            /*!< [2..2] This is the FIFO underflow interrupt.                              */
      __IOM uint32_t DCMP       : 1;            /*!< [3..3] DMA completed a transfer                                           */
      __IOM uint32_t DERR       : 1;            /*!< [4..4] DMA Error receieved                                                */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) IO Master Interrupts: Set                                  */

    struct {
      __IOM uint32_t THR        : 1;            /*!< [0..0] This is the FIFO threshold interrupt.                              */
      __IOM uint32_t OVF        : 1;            /*!< [1..1] This is the FIFO overflow interrupt.                               */
      __IOM uint32_t UNDFL      : 1;            /*!< [2..2] This is the FIFO underflow interrupt.                              */
      __IOM uint32_t DCMP       : 1;            /*!< [3..3] DMA completed a transfer                                           */
      __IOM uint32_t DERR       : 1;            /*!< [4..4] DMA Error receieved                                                */
    } INTSET_b;
  } ;
  __IM  uint32_t  RESERVED1[12];

  union {
    __IOM uint32_t DMATRIGEN;                   /*!< (@ 0x00000240) DMA Trigger Enable Register                                */

    struct {
      __IOM uint32_t DTHR       : 1;            /*!< [0..0] Trigger DMA upon when FIFO iss filled to level indicated
                                                     by the FIFO THRESHOLD,at granularity of 16 bytes only                     */
      __IOM uint32_t DTHR90     : 1;            /*!< [1..1] Trigger DMA at FIFO 90 percent full. This signal is also
                                                     used internally for AUTOHIP function                                      */
    } DMATRIGEN_b;
  } ;

  union {
    __IOM uint32_t DMATRIGSTAT;                 /*!< (@ 0x00000244) DMA Trigger Status Register                                */

    struct {
      __IOM uint32_t DTHRSTAT   : 1;            /*!< [0..0] Triggered DMA from FIFO reaching threshold                         */
      __IOM uint32_t DTHR90STAT : 1;            /*!< [1..1] Triggered DMA from FIFO reaching 90 percent full                   */
    } DMATRIGSTAT_b;
  } ;
  __IM  uint32_t  RESERVED2[14];

  union {
    __IOM uint32_t DMACFG;                      /*!< (@ 0x00000280) DMA Configuration Register                                 */

    struct {
      __IOM uint32_t DMAEN      : 1;            /*!< [0..0] DMA Enable                                                         */
      __IM  uint32_t            : 1;
      __IOM uint32_t DMADIR     : 1;            /*!< [2..2] Direction                                                          */
      __IM  uint32_t            : 5;
      __IOM uint32_t DMAPRI     : 1;            /*!< [8..8] Sets the Priority of the DMA request                               */
      __IOM uint32_t DAUTOHIP   : 1;            /*!< [9..9] Raise priority to high on fifo full, and DMAPRI set to
                                                     low                                                                       */
      __IOM uint32_t DPWROFF    : 1;            /*!< [10..10] Power Off the ADC System upon DMACPL.                            */
    } DMACFG_b;
  } ;
  __IM  uint32_t  RESERVED3;

  union {
    __IOM uint32_t DMATOTCOUNT;                 /*!< (@ 0x00000288) DMA Total Transfer Count                                   */

    struct {
      __IOM uint32_t TOTCOUNT   : 20;           /*!< [19..0] Total Transfer Count. The transfer count must be a multiple
                                                     of the THR setting to avoid DMA overruns.                                 */
    } DMATOTCOUNT_b;
  } ;

  union {
    __IOM uint32_t DMATARGADDR;                 /*!< (@ 0x0000028C) DMA Target Address Register                                */

    struct {
      __IOM uint32_t LTARGADDR  : 21;           /*!< [20..0] DMA Target Address. This register is not updated with
                                                     the current address of the DMA, but will remain static
                                                     with the original address during the DMA transfer.                        */
      __IOM uint32_t UTARGADDR  : 11;           /*!< [31..21] SRAM Target                                                      */
    } DMATARGADDR_b;
  } ;

  union {
    __IOM uint32_t DMASTAT;                     /*!< (@ 0x00000290) DMA Status Register                                        */

    struct {
      __IOM uint32_t DMATIP     : 1;            /*!< [0..0] DMA Transfer In Progress                                           */
      __IOM uint32_t DMACPL     : 1;            /*!< [1..1] DMA Transfer Complete                                              */
      __IOM uint32_t DMAERR     : 1;            /*!< [2..2] DMA Error                                                          */
    } DMASTAT_b;
  } ;
} PDM_Type;                                     /*!< Size = 660 (0x294)                                                        */



/* =========================================================================================================================== */
/* ================                                          PWRCTRL                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief PWR Controller Register Bank (PWRCTRL)
  */

typedef struct {                                /*!< (@ 0x40021000) PWRCTRL Structure                                          */

  union {
    __IOM uint32_t SUPPLYSRC;                   /*!< (@ 0x00000000) Voltage Regulator Select Register                          */

    struct {
      __IOM uint32_t BLEBUCKEN  : 1;            /*!< [0..0] Enables and Selects the BLE Buck as the supply for the
                                                     BLE power domain or for Burst LDO. It takes the initial
                                                     value from Customer INFO space. Buck will be powered up
                                                     only if there is an active request for BLEH domain or Burst
                                                     mode and appropriate feature is allowed.                                  */
    } SUPPLYSRC_b;
  } ;

  union {
    __IOM uint32_t SUPPLYSTATUS;                /*!< (@ 0x00000004) Voltage Regulators status                                  */

    struct {
      __IOM uint32_t SIMOBUCKON : 1;            /*!< [0..0] Indicates whether the Core/Mem low-voltage domains are
                                                     supplied from the LDO or the Buck.                                        */
      __IOM uint32_t BLEBUCKON  : 1;            /*!< [1..1] Indicates whether the BLE (if supported) domain and burst
                                                     (if supported) domain is supplied from the LDO or the Buck.
                                                     Buck will be powered up only if there is an active request
                                                     for BLEH domain or Burst mode and appropriate reature is
                                                     allowed.                                                                  */
    } SUPPLYSTATUS_b;
  } ;

  union {
    __IOM uint32_t DEVPWREN;                    /*!< (@ 0x00000008) Device Power Enables                                       */

    struct {
      __IOM uint32_t PWRIOS     : 1;            /*!< [0..0] Power up IO Slave                                                  */
      __IOM uint32_t PWRIOM0    : 1;            /*!< [1..1] Power up IO Master 0                                               */
      __IOM uint32_t PWRIOM1    : 1;            /*!< [2..2] Power up IO Master 1                                               */
      __IOM uint32_t PWRIOM2    : 1;            /*!< [3..3] Power up IO Master 2                                               */
      __IOM uint32_t PWRIOM3    : 1;            /*!< [4..4] Power up IO Master 3                                               */
      __IOM uint32_t PWRIOM4    : 1;            /*!< [5..5] Power up IO Master 4                                               */
      __IOM uint32_t PWRIOM5    : 1;            /*!< [6..6] Power up IO Master 5                                               */
      __IOM uint32_t PWRUART0   : 1;            /*!< [7..7] Power up UART Controller 0                                         */
      __IOM uint32_t PWRUART1   : 1;            /*!< [8..8] Power up UART Controller 1                                         */
      __IOM uint32_t PWRADC     : 1;            /*!< [9..9] Power up ADC Digital Controller                                    */
      __IOM uint32_t PWRSCARD   : 1;            /*!< [10..10] Power up SCARD Controller                                        */
      __IOM uint32_t PWRMSPI0   : 1;            /*!< [11..11] Power up MSPI0 Controller                                        */
      __IOM uint32_t PWRMSPI1   : 1;            /*!< [12..12] Power up MSPI1 Controller                                        */
      __IOM uint32_t PWRMSPI2   : 1;            /*!< [13..13] Power up MSPI2 Controller                                        */
      __IOM uint32_t PWRPDM     : 1;            /*!< [14..14] Power up PDM block                                               */
      __IOM uint32_t PWRBLEL    : 1;            /*!< [15..15] Power up BLE controller                                          */
    } DEVPWREN_b;
  } ;

  union {
    __IOM uint32_t MEMPWDINSLEEP;               /*!< (@ 0x0000000C) Powerdown SRAM banks in Deep Sleep mode                    */

    struct {
      __IOM uint32_t DTCMPWDSLP : 3;            /*!< [2..0] power down DTCM in deep sleep                                      */
      __IOM uint32_t SRAMPWDSLP : 10;           /*!< [12..3] Selects which SRAM banks are powered down in deep sleep
                                                     mode, causing the contents of the bank to be lost.                        */
      __IOM uint32_t FLASH0PWDSLP : 1;          /*!< [13..13] Powerdown flash0 in deep sleep                                   */
      __IOM uint32_t FLASH1PWDSLP : 1;          /*!< [14..14] Powerdown flash1 in deep sleep                                   */
      __IM  uint32_t            : 16;
      __IOM uint32_t CACHEPWDSLP : 1;           /*!< [31..31] power down cache in deep sleep                                   */
    } MEMPWDINSLEEP_b;
  } ;

  union {
    __IOM uint32_t MEMPWREN;                    /*!< (@ 0x00000010) Enables individual banks of the MEMORY array               */

    struct {
      __IOM uint32_t DTCM       : 3;            /*!< [2..0] Power up DTCM                                                      */
      __IOM uint32_t SRAM       : 10;           /*!< [12..3] Power up SRAM groups                                              */
      __IOM uint32_t FLASH0     : 1;            /*!< [13..13] Power up Flash group 0 (0MB-1MB)                                 */
      __IOM uint32_t FLASH1     : 1;            /*!< [14..14] Power up Flash group 1 (1MB-2MB)                                 */
      __IM  uint32_t            : 15;
      __IOM uint32_t CACHEB0    : 1;            /*!< [30..30] Power up Cache Bank 0. This works in conjunction with
                                                     Cache enable from flash_cache module. To power up cache
                                                     bank0, cache has to be enabled and this bit has to be set.                */
      __IOM uint32_t CACHEB2    : 1;            /*!< [31..31] Power up Cache Bank 2. This works in conjunction with
                                                     Cache enable from flash_cache module. To power up cache
                                                     bank2, cache has to be enabled and this bit has to be set.                */
    } MEMPWREN_b;
  } ;

  union {
    __IOM uint32_t MEMPWRSTATUS;                /*!< (@ 0x00000014) Mem Power ON Status                                        */

    struct {
      __IOM uint32_t DTCM00     : 1;            /*!< [0..0] This bit is 1 if power is supplied to DTCM GROUP0_0                */
      __IOM uint32_t DTCM01     : 1;            /*!< [1..1] This bit is 1 if power is supplied to DTCM GROUP0_1                */
      __IOM uint32_t DTCM1      : 1;            /*!< [2..2] This bit is 1 if power is supplied to DTCM GROUP1                  */
      __IOM uint32_t SRAM0      : 1;            /*!< [3..3] This bit is 1 if power is supplied to SRAM GROUP0                  */
      __IOM uint32_t SRAM1      : 1;            /*!< [4..4] This bit is 1 if power is supplied to SRAM GROUP1                  */
      __IOM uint32_t SRAM2      : 1;            /*!< [5..5] This bit is 1 if power is supplied to SRAM GROUP2                  */
      __IOM uint32_t SRAM3      : 1;            /*!< [6..6] This bit is 1 if power is supplied to SRAM GROUP3                  */
      __IOM uint32_t SRAM4      : 1;            /*!< [7..7] This bit is 1 if power is supplied to SRAM GROUP4                  */
      __IOM uint32_t SRAM5      : 1;            /*!< [8..8] This bit is 1 if power is supplied to SRAM GROUP5                  */
      __IOM uint32_t SRAM6      : 1;            /*!< [9..9] This bit is 1 if power is supplied to SRAM GROUP6                  */
      __IOM uint32_t SRAM7      : 1;            /*!< [10..10] This bit is 1 if power is supplied to SRAM GROUP7                */
      __IOM uint32_t SRAM8      : 1;            /*!< [11..11] This bit is 1 if power is supplied to SRAM GROUP8                */
      __IOM uint32_t SRAM9      : 1;            /*!< [12..12] This bit is 1 if power is supplied to SRAM GROUP9                */
      __IOM uint32_t FLASH0     : 1;            /*!< [13..13] This bit is 1 if power is supplied to FLASH group 0              */
      __IOM uint32_t FLASH1     : 1;            /*!< [14..14] This bit is 1 if power is supplied to FLASH group 1              */
      __IOM uint32_t CACHEB0    : 1;            /*!< [15..15] This bit is 1 if power is supplied to Cache Bank 0               */
      __IOM uint32_t CACHEB2    : 1;            /*!< [16..16] This bit is 1 if power is supplied to Cache Bank 2               */
    } MEMPWRSTATUS_b;
  } ;

  union {
    __IOM uint32_t DEVPWRSTATUS;                /*!< (@ 0x00000018) Device Power ON Status                                     */

    struct {
      __IOM uint32_t MCUL       : 1;            /*!< [0..0] This bit is 1 if power is supplied to MCUL                         */
      __IOM uint32_t MCUH       : 1;            /*!< [1..1] This bit is 1 if power is supplied to MCUH                         */
      __IOM uint32_t HCPA       : 1;            /*!< [2..2] This bit is 1 if power is supplied to HCPA domain (IO
                                                     SLAVE, UART0, UART1, SCARD)                                               */
      __IOM uint32_t HCPB       : 1;            /*!< [3..3] This bit is 1 if power is supplied to HCPB domain (IO
                                                     MASTER 0, 1, 2)                                                           */
      __IOM uint32_t HCPC       : 1;            /*!< [4..4] This bit is 1 if power is supplied to HCPC domain (IO
                                                     MASTER4, 5, 6)                                                            */
      __IOM uint32_t PWRADC     : 1;            /*!< [5..5] This bit is 1 if power is supplied to ADC                          */
      __IOM uint32_t PWRMSPI    : 1;            /*!< [6..6] This bit is 1 if power is supplied to MSPI                         */
      __IOM uint32_t PWRPDM     : 1;            /*!< [7..7] This bit is 1 if power is supplied to PDM                          */
      __IOM uint32_t BLEL       : 1;            /*!< [8..8] This bit is 1 if power is supplied to BLEL                         */
      __IOM uint32_t BLEH       : 1;            /*!< [9..9] This bit is 1 if power is supplied to BLEH                         */
    } DEVPWRSTATUS_b;
  } ;

  union {
    __IOM uint32_t SRAMCTRL;                    /*!< (@ 0x0000001C) SRAM Control register                                      */

    struct {
      __IM  uint32_t            : 1;
      __IOM uint32_t SRAMCLKGATE : 1;           /*!< [1..1] This bit is 1 if clock gating is allowed for individual
                                                     system SRAMs                                                              */
      __IOM uint32_t SRAMMASTERCLKGATE : 1;     /*!< [2..2] This bit is 1 when the master clock gate is enabled (top-level
                                                     clock gate for entire SRAM block)                                         */
      __IM  uint32_t            : 5;
      __IOM uint32_t SRAMLIGHTSLEEP : 12;       /*!< [19..8] Light Sleep enable for each TCM/SRAM bank. When 1, corresponding
                                                     bank will be put into light sleep. For optimal power, banks
                                                     should be put into light sleep while the system is active
                                                     but the bank has minimal or no accesses.                                  */
    } SRAMCTRL_b;
  } ;

  union {
    __IOM uint32_t ADCSTATUS;                   /*!< (@ 0x00000020) Power Status Register for ADC Block                        */

    struct {
      __IOM uint32_t ADCPWD     : 1;            /*!< [0..0] This bit indicates that the ADC is powered down                    */
      __IOM uint32_t BGTPWD     : 1;            /*!< [1..1] This bit indicates that the ADC Band Gap is powered down           */
      __IOM uint32_t VPTATPWD   : 1;            /*!< [2..2] This bit indicates that the ADC temperature sensor input
                                                     buffer is powered down                                                    */
      __IOM uint32_t VBATPWD    : 1;            /*!< [3..3] This bit indicates that the ADC VBAT resistor divider
                                                     is powered down                                                           */
      __IOM uint32_t REFKEEPPWD : 1;            /*!< [4..4] This bit indicates that the ADC REFKEEP is powered down            */
      __IOM uint32_t REFBUFPWD  : 1;            /*!< [5..5] This bit indicates that the ADC REFBUF is powered down             */
    } ADCSTATUS_b;
  } ;

  union {
    __IOM uint32_t MISC;                        /*!< (@ 0x00000024) Power Optimization Control Bits                            */

    struct {
      __IM  uint32_t            : 3;
      __IOM uint32_t FORCEMEMVRLPTIMERS : 1;    /*!< [3..3] Control Bit to force Mem VR to LP mode in deep sleep
                                                     even when hfrc based ctimer or stimer is running.                         */
      __IM  uint32_t            : 2;
      __IOM uint32_t MEMVRLPBLE : 1;            /*!< [6..6] Control Bit to let Mem VR go to lp mode in deep sleep
                                                     even when BLEL or BLEH is powered on given none of the
                                                     other domains require it.                                                 */
    } MISC_b;
  } ;

  union {
    __IOM uint32_t DEVPWREVENTEN;               /*!< (@ 0x00000028) Event enable register to control which DEVPWRSTATUS
                                                                    bits are routed to event input of CPU.                     */

    struct {
      __IOM uint32_t MCULEVEN   : 1;            /*!< [0..0] Control MCUL power-on status event                                 */
      __IOM uint32_t MCUHEVEN   : 1;            /*!< [1..1] Control MCUH power-on status event                                 */
      __IOM uint32_t HCPAEVEN   : 1;            /*!< [2..2] Control HCPA power-on status event                                 */
      __IOM uint32_t HCPBEVEN   : 1;            /*!< [3..3] Control HCPB power-on status event                                 */
      __IOM uint32_t HCPCEVEN   : 1;            /*!< [4..4] Control HCPC power-on status event                                 */
      __IOM uint32_t ADCEVEN    : 1;            /*!< [5..5] Control ADC power-on status event                                  */
      __IOM uint32_t MSPIEVEN   : 1;            /*!< [6..6] Control MSPI power-on status event                                 */
      __IOM uint32_t PDMEVEN    : 1;            /*!< [7..7] Control PDM power-on status event                                  */
      __IOM uint32_t BLELEVEN   : 1;            /*!< [8..8] Control BLE power-on status event                                  */
      __IM  uint32_t            : 20;
      __IOM uint32_t BLEFEATUREEVEN : 1;        /*!< [29..29] Control BLEFEATURE status event                                  */
      __IOM uint32_t BURSTFEATUREEVEN : 1;      /*!< [30..30] Control BURSTFEATURE status event                                */
      __IOM uint32_t BURSTEVEN  : 1;            /*!< [31..31] Control BURST status event                                       */
    } DEVPWREVENTEN_b;
  } ;

  union {
    __IOM uint32_t MEMPWREVENTEN;               /*!< (@ 0x0000002C) Event enable register to control which MEMPWRSTATUS
                                                                    bits are routed to event input of CPU.                     */

    struct {
      __IOM uint32_t DTCMEN     : 3;            /*!< [2..0] Enable DTCM power-on status event                                  */
      __IOM uint32_t SRAMEN     : 10;           /*!< [12..3] Control SRAM power-on status event                                */
      __IOM uint32_t FLASH0EN   : 1;            /*!< [13..13] Control Flash power-on status event                              */
      __IOM uint32_t FLASH1EN   : 1;            /*!< [14..14] Control Flash power-on status event                              */
      __IM  uint32_t            : 15;
      __IOM uint32_t CACHEB0EN  : 1;            /*!< [30..30] Control CACHE BANK 0 power-on status event                       */
      __IOM uint32_t CACHEB2EN  : 1;            /*!< [31..31] Control CACHEB2 power-on status event                            */
    } MEMPWREVENTEN_b;
  } ;
} PWRCTRL_Type;                                 /*!< Size = 48 (0x30)                                                          */



/* =========================================================================================================================== */
/* ================                                          RSTGEN                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief MCU Reset Generator (RSTGEN)
  */

typedef struct {                                /*!< (@ 0x40000000) RSTGEN Structure                                           */

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Configuration Register                                     */

    struct {
      __IOM uint32_t BODHREN    : 1;            /*!< [0..0] Brown out high (2.1v) reset enable.                                */
      __IOM uint32_t WDREN      : 1;            /*!< [1..1] Watchdog Timer Reset Enable. NOTE: The WDT module must
                                                     also be configured for WDT reset. This includes enabling
                                                     the RESEN bit in WDTCFG register in Watch dog timer block.                */
    } CFG_b;
  } ;

  union {
    __IOM uint32_t SWPOI;                       /*!< (@ 0x00000004) Software POI Reset                                         */

    struct {
      __IOM uint32_t SWPOIKEY   : 8;            /*!< [7..0] 0x1B generates a software POI reset. This is a write-only
                                                     register. Reading from this register will yield only all
                                                     0s.                                                                       */
    } SWPOI_b;
  } ;

  union {
    __IOM uint32_t SWPOR;                       /*!< (@ 0x00000008) Software POR Reset                                         */

    struct {
      __IOM uint32_t SWPORKEY   : 8;            /*!< [7..0] 0xD4 generates a software POR reset.                               */
    } SWPOR_b;
  } ;
  __IM  uint32_t  RESERVED[2];

  union {
    __IOM uint32_t TPIURST;                     /*!< (@ 0x00000014) TPIU reset                                                 */

    struct {
      __IOM uint32_t TPIURST    : 1;            /*!< [0..0] Static reset for the TPIU. Write to '1' to assert reset
                                                     to TPIU. Write to '0' to clear the reset.                                 */
    } TPIURST_b;
  } ;
  __IM  uint32_t  RESERVED1[122];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Reset Interrupt register: Enable                           */

    struct {
      __IOM uint32_t BODH       : 1;            /*!< [0..0] Enables an interrupt that triggers when VCC is below
                                                     BODH level.                                                               */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Reset Interrupt register: Status                           */

    struct {
      __IOM uint32_t BODH       : 1;            /*!< [0..0] Enables an interrupt that triggers when VCC is below
                                                     BODH level.                                                               */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Reset Interrupt register: Clear                            */

    struct {
      __IOM uint32_t BODH       : 1;            /*!< [0..0] Enables an interrupt that triggers when VCC is below
                                                     BODH level.                                                               */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Reset Interrupt register: Set                              */

    struct {
      __IOM uint32_t BODH       : 1;            /*!< [0..0] Enables an interrupt that triggers when VCC is below
                                                     BODH level.                                                               */
    } INTSET_b;
  } ;
  __IM  uint32_t  RESERVED2[67107708];

  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x0FFFF000) Status Register (SBL)                                      */

    struct {
      __IOM uint32_t EXRSTAT    : 1;            /*!< [0..0] Reset was initiated by an External Reset (SBL).                    */
      __IOM uint32_t PORSTAT    : 1;            /*!< [1..1] Reset was initiated by a Power-On Reset (SBL).                     */
      __IOM uint32_t BORSTAT    : 1;            /*!< [2..2] Reset was initiated by a Brown-Out Reset (SBL).                    */
      __IOM uint32_t SWRSTAT    : 1;            /*!< [3..3] Reset was a initiated by SW POR or AIRCR Reset (SBL).              */
      __IOM uint32_t POIRSTAT   : 1;            /*!< [4..4] Reset was a initiated by Software POI Reset (SBL).                 */
      __IOM uint32_t DBGRSTAT   : 1;            /*!< [5..5] Reset was a initiated by Debugger Reset (SBL).                     */
      __IOM uint32_t WDRSTAT    : 1;            /*!< [6..6] Reset was initiated by a Watchdog Timer Reset (SBL).               */
      __IOM uint32_t BOUSTAT    : 1;            /*!< [7..7] An Unregulated Supply Brownout Event occurred (SBL).               */
      __IOM uint32_t BOCSTAT    : 1;            /*!< [8..8] A Core Regulator Brownout Event occurred (SBL).                    */
      __IOM uint32_t BOFSTAT    : 1;            /*!< [9..9] A Memory Regulator Brownout Event occurred (SBL).                  */
      __IOM uint32_t BOBSTAT    : 1;            /*!< [10..10] A BLE/Burst Regulator Brownout Event occurred (SBL).             */
      __IM  uint32_t            : 19;
      __IOM uint32_t FBOOT      : 1;            /*!< [30..30] Set if current boot was initiated by soft reset and
                                                     resulted in Fast Boot (SBL).                                              */
      __IOM uint32_t SBOOT      : 1;            /*!< [31..31] Set when booting securely (SBL).                                 */
    } STAT_b;
  } ;
} RSTGEN_Type;                                  /*!< Size = 268431364 (0xffff004)                                              */



/* =========================================================================================================================== */
/* ================                                            RTC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Real Time Clock (RTC)
  */

typedef struct {                                /*!< (@ 0x40004200) RTC Structure                                              */
  __IM  uint32_t  RESERVED[16];

  union {
    __IOM uint32_t CTRLOW;                      /*!< (@ 0x00000040) RTC Counters Lower                                         */

    struct {
      __IOM uint32_t CTR100     : 8;            /*!< [7..0] 100ths of a second Counter                                         */
      __IOM uint32_t CTRSEC     : 7;            /*!< [14..8] Seconds Counter                                                   */
      __IM  uint32_t            : 1;
      __IOM uint32_t CTRMIN     : 7;            /*!< [22..16] Minutes Counter                                                  */
      __IM  uint32_t            : 1;
      __IOM uint32_t CTRHR      : 6;            /*!< [29..24] Hours Counter                                                    */
    } CTRLOW_b;
  } ;

  union {
    __IOM uint32_t CTRUP;                       /*!< (@ 0x00000044) RTC Counters Upper                                         */

    struct {
      __IOM uint32_t CTRDATE    : 6;            /*!< [5..0] Date Counter                                                       */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTRMO      : 5;            /*!< [12..8] Months Counter                                                    */
      __IM  uint32_t            : 3;
      __IOM uint32_t CTRYR      : 8;            /*!< [23..16] Years Counter                                                    */
      __IOM uint32_t CTRWKDY    : 3;            /*!< [26..24] Weekdays Counter                                                 */
      __IOM uint32_t CB         : 1;            /*!< [27..27] Century                                                          */
      __IOM uint32_t CEB        : 1;            /*!< [28..28] Century enable                                                   */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTERR      : 1;            /*!< [31..31] Counter read error status. Error is triggered when
                                                     software reads the lower word of the counters, and fails
                                                     to read the upper counter within 1/100 second. This is
                                                     because when the lower counter is read, the upper counter
                                                     is held off from incrementing until it is read so that
                                                     the full time stamp can be read.                                          */
    } CTRUP_b;
  } ;

  union {
    __IOM uint32_t ALMLOW;                      /*!< (@ 0x00000048) RTC Alarms Lower                                           */

    struct {
      __IOM uint32_t ALM100     : 8;            /*!< [7..0] 100ths of a second Alarm                                           */
      __IOM uint32_t ALMSEC     : 7;            /*!< [14..8] Seconds Alarm                                                     */
      __IM  uint32_t            : 1;
      __IOM uint32_t ALMMIN     : 7;            /*!< [22..16] Minutes Alarm                                                    */
      __IM  uint32_t            : 1;
      __IOM uint32_t ALMHR      : 6;            /*!< [29..24] Hours Alarm                                                      */
    } ALMLOW_b;
  } ;

  union {
    __IOM uint32_t ALMUP;                       /*!< (@ 0x0000004C) RTC Alarms Upper                                           */

    struct {
      __IOM uint32_t ALMDATE    : 6;            /*!< [5..0] Date Alarm                                                         */
      __IM  uint32_t            : 2;
      __IOM uint32_t ALMMO      : 5;            /*!< [12..8] Months Alarm                                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t ALMWKDY    : 3;            /*!< [18..16] Weekdays Alarm                                                   */
    } ALMUP_b;
  } ;

  union {
    __IOM uint32_t RTCCTL;                      /*!< (@ 0x00000050) RTC Control Register                                       */

    struct {
      __IOM uint32_t WRTC       : 1;            /*!< [0..0] Counter write control                                              */
      __IOM uint32_t RPT        : 3;            /*!< [3..1] Alarm repeat interval                                              */
      __IOM uint32_t RSTOP      : 1;            /*!< [4..4] RTC input clock control                                            */
      __IOM uint32_t HR1224     : 1;            /*!< [5..5] Hours Counter mode                                                 */
    } RTCCTL_b;
  } ;
  __IM  uint32_t  RESERVED1[43];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000100) RTC Interrupt Register: Enable                             */

    struct {
      __IOM uint32_t ALM        : 1;            /*!< [0..0] RTC Alarm interrupt                                                */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000104) RTC Interrupt Register: Status                             */

    struct {
      __IOM uint32_t ALM        : 1;            /*!< [0..0] RTC Alarm interrupt                                                */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000108) RTC Interrupt Register: Clear                              */

    struct {
      __IOM uint32_t ALM        : 1;            /*!< [0..0] RTC Alarm interrupt                                                */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000010C) RTC Interrupt Register: Set                                */

    struct {
      __IOM uint32_t ALM        : 1;            /*!< [0..0] RTC Alarm interrupt                                                */
    } INTSET_b;
  } ;
} RTC_Type;                                     /*!< Size = 272 (0x110)                                                        */



/* =========================================================================================================================== */
/* ================                                           SCARD                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Serial ISO7816 (SCARD)
  */

typedef struct {                                /*!< (@ 0x40080000) SCARD Structure                                            */

  union {
    __IOM uint32_t SR;                          /*!< (@ 0x00000000) ISO7816 interrupt status                                   */

    struct {
      __IOM uint32_t FNE        : 1;            /*!< [0..0] RX FIFO not empty.                                                 */
      __IOM uint32_t TBERBF     : 1;            /*!< [1..1] FIFO empty (transmit) or full (receive).                           */
      __IOM uint32_t FER        : 1;            /*!< [2..2] Framing error.                                                     */
      __IOM uint32_t OVR        : 1;            /*!< [3..3] RX FIFO overflow.                                                  */
      __IOM uint32_t PE         : 1;            /*!< [4..4] Parity Error.                                                      */
      __IOM uint32_t FT2REND    : 1;            /*!< [5..5] TX to RX finished.                                                 */
      __IOM uint32_t FHF        : 1;            /*!< [6..6] FIFO Half Full.                                                    */
    } SR_b;
  } ;

  union {
    __IOM uint32_t IER;                         /*!< (@ 0x00000004) ISO7816 interrupt enable                                   */

    struct {
      __IOM uint32_t FNEEN      : 1;            /*!< [0..0] RX FIFO not empty interrupt enable.                                */
      __IOM uint32_t TBERBFEN   : 1;            /*!< [1..1] FIFO empty (transmit) or full (receive) interrupt enable.          */
      __IOM uint32_t FEREN      : 1;            /*!< [2..2] Framing error interrupt enable.                                    */
      __IOM uint32_t OVREN      : 1;            /*!< [3..3] RX FIFOI overflow interrupt enable.                                */
      __IOM uint32_t PEEN       : 1;            /*!< [4..4] Parity Error interrupt enable.                                     */
      __IOM uint32_t FT2RENDEN  : 1;            /*!< [5..5] TX to RX finished interrupt enable.                                */
      __IOM uint32_t FHFEN      : 1;            /*!< [6..6] FIFO Half Full interrupt enable.                                   */
    } IER_b;
  } ;

  union {
    __IOM uint32_t TCR;                         /*!< (@ 0x00000008) ISO7816 transmit control                                   */

    struct {
      __IOM uint32_t CONV       : 1;            /*!< [0..0] Conversion inversion control.                                      */
      __IOM uint32_t SS         : 1;            /*!< [1..1] Use first byte to configure conversion.                            */
      __IOM uint32_t LCT        : 1;            /*!< [2..2] Fast TX to RX.                                                     */
      __IOM uint32_t TR         : 1;            /*!< [3..3] Transmit/receive mode.                                             */
      __IOM uint32_t PROT       : 1;            /*!< [4..4] PROT control.                                                      */
      __IOM uint32_t AUTOCONV   : 1;            /*!< [5..5] Automatic conversion.                                              */
      __IOM uint32_t FIP        : 1;            /*!< [6..6] Parity select.                                                     */
      __IOM uint32_t DMAMD      : 1;            /*!< [7..7] DMA direction.                                                     */
    } TCR_b;
  } ;

  union {
    __IOM uint32_t UCR;                         /*!< (@ 0x0000000C) ISO7816 user control                                       */

    struct {
      __IOM uint32_t CST        : 1;            /*!< [0..0] Clock control.                                                     */
      __IOM uint32_t RIU        : 1;            /*!< [1..1] ISO7816 reset. This bit is write-only.                             */
      __IOM uint32_t RSTIN      : 1;            /*!< [2..2] Reset polarity.                                                    */
      __IOM uint32_t RETXEN     : 1;            /*!< [3..3] Enable TX/RX time configuration.                                   */
    } UCR_b;
  } ;

  union {
    __IOM uint32_t DR;                          /*!< (@ 0x00000010) ISO7816 data                                               */

    struct {
      __IOM uint32_t DR         : 8;            /*!< [7..0] Data register.                                                     */
    } DR_b;
  } ;

  union {
    __IOM uint32_t BPRL;                        /*!< (@ 0x00000014) ISO7816 baud rate low                                      */

    struct {
      __IOM uint32_t BPRL       : 8;            /*!< [7..0] Baud rate low                                                      */
    } BPRL_b;
  } ;

  union {
    __IOM uint32_t BPRH;                        /*!< (@ 0x00000018) ISO7816 baud rate high                                     */

    struct {
      __IOM uint32_t BPRH       : 4;            /*!< [3..0] Baud rate high                                                     */
    } BPRH_b;
  } ;

  union {
    __IOM uint32_t UCR1;                        /*!< (@ 0x0000001C) ISO7816 user control 1                                     */

    struct {
      __IOM uint32_t PR         : 1;            /*!< [0..0] Query Card Detect.                                                 */
      __IM  uint32_t            : 1;
      __IOM uint32_t STSP       : 1;            /*!< [2..2] ETU counter control. This bit is write-only.                       */
      __IOM uint32_t T1PAREN    : 1;            /*!< [3..3] Parity check control.                                              */
      __IOM uint32_t CLKIOV     : 1;            /*!< [4..4] Output clock level.                                                */
      __IOM uint32_t ENLASTB    : 1;            /*!< [5..5] Enable last byte function.                                         */
    } UCR1_b;
  } ;

  union {
    __IOM uint32_t SR1;                         /*!< (@ 0x00000020) ISO7816 interrupt status 1                                 */

    struct {
      __IOM uint32_t ECNTOVER   : 1;            /*!< [0..0] ETU counter overflow.                                              */
      __IOM uint32_t PRL        : 1;            /*!< [1..1] Card insert/remove.                                                */
      __IOM uint32_t SYNCEND    : 1;            /*!< [2..2] Write complete synchronization.                                    */
      __IOM uint32_t IDLE       : 1;            /*!< [3..3] ISO7816 idle.                                                      */
    } SR1_b;
  } ;

  union {
    __IOM uint32_t IER1;                        /*!< (@ 0x00000024) ISO7816 interrupt enable 1                                 */

    struct {
      __IOM uint32_t ECNTOVEREN : 1;            /*!< [0..0] ETU counter overflow interrupt enable.                             */
      __IOM uint32_t PRLEN      : 1;            /*!< [1..1] Card insert/remove interrupt enable.                               */
      __IOM uint32_t SYNCENDEN  : 1;            /*!< [2..2] Write complete synchronization interrupt enable.                   */
    } IER1_b;
  } ;

  union {
    __IOM uint32_t ECNTL;                       /*!< (@ 0x00000028) ETU counter low                                            */

    struct {
      __IOM uint32_t ECNTL      : 8;            /*!< [7..0] ETU counter low register.                                          */
    } ECNTL_b;
  } ;

  union {
    __IOM uint32_t ECNTH;                       /*!< (@ 0x0000002C) ETU counter high                                           */

    struct {
      __IOM uint32_t ECNTH      : 8;            /*!< [7..0] ETU counter high register.                                         */
    } ECNTH_b;
  } ;

  union {
    __IOM uint32_t GTR;                         /*!< (@ 0x00000030) ISO7816 guard time configuration                           */

    struct {
      __IOM uint32_t GTR        : 8;            /*!< [7..0] Guard time configuration register.                                 */
    } GTR_b;
  } ;

  union {
    __IOM uint32_t RETXCNT;                     /*!< (@ 0x00000034) ISO7816 resend count                                       */

    struct {
      __IOM uint32_t RETXCNT    : 4;            /*!< [3..0] Resend count register.                                             */
    } RETXCNT_b;
  } ;

  union {
    __IOM uint32_t RETXCNTRMI;                  /*!< (@ 0x00000038) ISO7816 resent count inquiry                               */

    struct {
      __IOM uint32_t RETXCNTRMI : 4;            /*!< [3..0] Resent count inquiry register.                                     */
    } RETXCNTRMI_b;
  } ;
  __IM  uint32_t  RESERVED[49];

  union {
    __IOM uint32_t CLKCTRL;                     /*!< (@ 0x00000100) Clock Control                                              */

    struct {
      __IOM uint32_t CLKEN      : 1;            /*!< [0..0] Enable the serial source clock for SCARD.                          */
      __IOM uint32_t APBCLKEN   : 1;            /*!< [1..1] Enable the SCARD APB clock to run continuously.                    */
    } CLKCTRL_b;
  } ;
} SCARD_Type;                                   /*!< Size = 260 (0x104)                                                        */



/* =========================================================================================================================== */
/* ================                                         SECURITY                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief Security Interfaces (SECURITY)
  */

typedef struct {                                /*!< (@ 0x40030000) SECURITY Structure                                         */

  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000000) Control Register                                           */

    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< [0..0] Function Enable. Software should set the ENABLE bit to
                                                     initiate a CRC operation. Hardware will clear the ENABLE
                                                     bit upon completion.                                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t FUNCTION   : 4;            /*!< [7..4] Function Select                                                    */
      __IM  uint32_t            : 23;
      __IOM uint32_t CRCERROR   : 1;            /*!< [31..31] CRC Error Status - Set to 1 if an error occurs during
                                                     a CRC operation. Cleared when CTRL register is written
                                                     (with any value). Usually indicates an invalid address
                                                     range.                                                                    */
    } CTRL_b;
  } ;
  __IM  uint32_t  RESERVED[3];

  union {
    __IOM uint32_t SRCADDR;                     /*!< (@ 0x00000010) Source Addresss                                            */

    struct {
      __IOM uint32_t ADDR       : 32;           /*!< [31..0] Source Buffer Address. Address may be byte aligned,
                                                     but the length must be a multiple of 4 bits.                              */
    } SRCADDR_b;
  } ;
  __IM  uint32_t  RESERVED1[3];

  union {
    __IOM uint32_t LEN;                         /*!< (@ 0x00000020) Length                                                     */

    struct {
      __IM  uint32_t            : 2;
      __IOM uint32_t LEN        : 22;           /*!< [23..2] Buffer size (bottom two bits assumed to be zero to ensure
                                                     a multiple of 4 bytes)                                                    */
    } LEN_b;
  } ;
  __IM  uint32_t  RESERVED2[3];

  union {
    __IOM uint32_t RESULT;                      /*!< (@ 0x00000030) CRC Seed/Result Register                                   */

    struct {
      __IOM uint32_t CRC        : 32;           /*!< [31..0] CRC Seed/Result. Software must seed the CRC with 0xFFFFFFFF
                                                     before starting a CRC operation (unless the CRC is continued
                                                     from a previous operation).                                               */
    } RESULT_b;
  } ;
  __IM  uint32_t  RESERVED3[17];

  union {
    __IOM uint32_t LOCKCTRL;                    /*!< (@ 0x00000078) LOCK Control Register                                      */

    struct {
      __IOM uint32_t SELECT     : 8;            /*!< [7..0] LOCK Function Select register.                                     */
    } LOCKCTRL_b;
  } ;

  union {
    __IOM uint32_t LOCKSTAT;                    /*!< (@ 0x0000007C) LOCK Status Register                                       */

    struct {
      __IOM uint32_t STATUS     : 32;           /*!< [31..0] LOCK Status register. This register is a bitmask for
                                                     which resources are currently unlocked. These bits are
                                                     one-hot per resource.                                                     */
    } LOCKSTAT_b;
  } ;

  union {
    __IOM uint32_t KEY0;                        /*!< (@ 0x00000080) Key0 Register                                              */

    struct {
      __IOM uint32_t KEY0       : 32;           /*!< [31..0] Bits [31:0] of the 128-bit key should be written to
                                                     this register. To protect key values, the register always
                                                     returns 0x00000000.                                                       */
    } KEY0_b;
  } ;

  union {
    __IOM uint32_t KEY1;                        /*!< (@ 0x00000084) Key1 Register                                              */

    struct {
      __IOM uint32_t KEY1       : 32;           /*!< [31..0] Bits [63:32] of the 128-bit key should be written to
                                                     this register. To protect key values, the register always
                                                     returns 0x00000000.                                                       */
    } KEY1_b;
  } ;

  union {
    __IOM uint32_t KEY2;                        /*!< (@ 0x00000088) Key2 Register                                              */

    struct {
      __IOM uint32_t KEY2       : 32;           /*!< [31..0] Bits [95:64] of the 128-bit key should be written to
                                                     this register. To protect key values, the register always
                                                     returns 0x00000000.                                                       */
    } KEY2_b;
  } ;

  union {
    __IOM uint32_t KEY3;                        /*!< (@ 0x0000008C) Key3 Register                                              */

    struct {
      __IOM uint32_t KEY3       : 32;           /*!< [31..0] Bits [127:96] of the 128-bit key should be written to
                                                     this register. To protect key values, the register always
                                                     returns 0x00000000.                                                       */
    } KEY3_b;
  } ;
} SECURITY_Type;                                /*!< Size = 144 (0x90)                                                         */



/* =========================================================================================================================== */
/* ================                                           UART0                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Serial UART (UART0)
  */

typedef struct {                                /*!< (@ 0x4001C000) UART0 Structure                                            */

  union {
    __IOM uint32_t DR;                          /*!< (@ 0x00000000) UART Data Register                                         */

    struct {
      __IOM uint32_t DATA       : 8;            /*!< [7..0] This is the UART data port.                                        */
      __IOM uint32_t FEDATA     : 1;            /*!< [8..8] This is the framing error indicator.                               */
      __IOM uint32_t PEDATA     : 1;            /*!< [9..9] This is the parity error indicator.                                */
      __IOM uint32_t BEDATA     : 1;            /*!< [10..10] This is the break error indicator.                               */
      __IOM uint32_t OEDATA     : 1;            /*!< [11..11] This is the overrun error indicator.                             */
    } DR_b;
  } ;

  union {
    __IOM uint32_t RSR;                         /*!< (@ 0x00000004) UART Status Register                                       */

    struct {
      __IOM uint32_t FESTAT     : 1;            /*!< [0..0] This is the framing error indicator.                               */
      __IOM uint32_t PESTAT     : 1;            /*!< [1..1] This is the parity error indicator.                                */
      __IOM uint32_t BESTAT     : 1;            /*!< [2..2] This is the break error indicator.                                 */
      __IOM uint32_t OESTAT     : 1;            /*!< [3..3] This is the overrun error indicator.                               */
    } RSR_b;
  } ;
  __IM  uint32_t  RESERVED[4];

  union {
    __IOM uint32_t FR;                          /*!< (@ 0x00000018) Flag Register                                              */

    struct {
      __IOM uint32_t CTS        : 1;            /*!< [0..0] This bit holds the clear to send indicator.                        */
      __IOM uint32_t DSR        : 1;            /*!< [1..1] This bit holds the data set ready indicator.                       */
      __IOM uint32_t DCD        : 1;            /*!< [2..2] This bit holds the data carrier detect indicator.                  */
      __IOM uint32_t BUSY       : 1;            /*!< [3..3] This bit holds the busy indicator.                                 */
      __IOM uint32_t RXFE       : 1;            /*!< [4..4] This bit holds the receive FIFO empty indicator.                   */
      __IOM uint32_t TXFF       : 1;            /*!< [5..5] This bit holds the transmit FIFO full indicator.                   */
      __IOM uint32_t RXFF       : 1;            /*!< [6..6] This bit holds the receive FIFO full indicator.                    */
      __IOM uint32_t TXFE       : 1;            /*!< [7..7] This bit holds the transmit FIFO empty indicator.                  */
      __IOM uint32_t TXBUSY     : 1;            /*!< [8..8] This bit holds the transmit BUSY indicator.                        */
    } FR_b;
  } ;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t ILPR;                        /*!< (@ 0x00000020) IrDA Counter                                               */

    struct {
      __IOM uint32_t ILPDVSR    : 8;            /*!< [7..0] These bits hold the IrDA counter divisor.                          */
    } ILPR_b;
  } ;

  union {
    __IOM uint32_t IBRD;                        /*!< (@ 0x00000024) Integer Baud Rate Divisor                                  */

    struct {
      __IOM uint32_t DIVINT     : 16;           /*!< [15..0] These bits hold the baud integer divisor.                         */
    } IBRD_b;
  } ;

  union {
    __IOM uint32_t FBRD;                        /*!< (@ 0x00000028) Fractional Baud Rate Divisor                               */

    struct {
      __IOM uint32_t DIVFRAC    : 6;            /*!< [5..0] These bits hold the baud fractional divisor.                       */
    } FBRD_b;
  } ;

  union {
    __IOM uint32_t LCRH;                        /*!< (@ 0x0000002C) Line Control High                                          */

    struct {
      __IOM uint32_t BRK        : 1;            /*!< [0..0] This bit holds the break set.                                      */
      __IOM uint32_t PEN        : 1;            /*!< [1..1] This bit holds the parity enable.                                  */
      __IOM uint32_t EPS        : 1;            /*!< [2..2] This bit holds the even parity select.                             */
      __IOM uint32_t STP2       : 1;            /*!< [3..3] This bit holds the two stop bits select.                           */
      __IOM uint32_t FEN        : 1;            /*!< [4..4] This bit holds the FIFO enable.                                    */
      __IOM uint32_t WLEN       : 2;            /*!< [6..5] These bits hold the write length.                                  */
      __IOM uint32_t SPS        : 1;            /*!< [7..7] This bit holds the stick parity select.                            */
    } LCRH_b;
  } ;

  union {
    __IOM uint32_t CR;                          /*!< (@ 0x00000030) Control Register                                           */

    struct {
      __IOM uint32_t UARTEN     : 1;            /*!< [0..0] This bit is the UART enable.                                       */
      __IOM uint32_t SIREN      : 1;            /*!< [1..1] This bit is the SIR ENDEC enable.                                  */
      __IOM uint32_t SIRLP      : 1;            /*!< [2..2] This bit is the SIR low power select.                              */
      __IOM uint32_t CLKEN      : 1;            /*!< [3..3] This bit is the UART clock enable.                                 */
      __IOM uint32_t CLKSEL     : 3;            /*!< [6..4] This bitfield is the UART clock select.                            */
      __IOM uint32_t LBE        : 1;            /*!< [7..7] This bit is the loopback enable.                                   */
      __IOM uint32_t TXE        : 1;            /*!< [8..8] This bit is the transmit enable.                                   */
      __IOM uint32_t RXE        : 1;            /*!< [9..9] This bit is the receive enable.                                    */
      __IOM uint32_t DTR        : 1;            /*!< [10..10] This bit enables data transmit ready.                            */
      __IOM uint32_t RTS        : 1;            /*!< [11..11] This bit enables request to send.                                */
      __IOM uint32_t OUT1       : 1;            /*!< [12..12] This bit holds modem Out1.                                       */
      __IOM uint32_t OUT2       : 1;            /*!< [13..13] This bit holds modem Out2.                                       */
      __IOM uint32_t RTSEN      : 1;            /*!< [14..14] This bit enables RTS hardware flow control.                      */
      __IOM uint32_t CTSEN      : 1;            /*!< [15..15] This bit enables CTS hardware flow control.                      */
    } CR_b;
  } ;

  union {
    __IOM uint32_t IFLS;                        /*!< (@ 0x00000034) FIFO Interrupt Level Select                                */

    struct {
      __IOM uint32_t TXIFLSEL   : 3;            /*!< [2..0] These bits hold the transmit FIFO interrupt level.                 */
      __IOM uint32_t RXIFLSEL   : 3;            /*!< [5..3] These bits hold the receive FIFO interrupt level.                  */
    } IFLS_b;
  } ;

  union {
    __IOM uint32_t IER;                         /*!< (@ 0x00000038) Interrupt Enable                                           */

    struct {
      __IOM uint32_t TXCMPMIM   : 1;            /*!< [0..0] This bit holds the modem TXCMP interrupt enable.                   */
      __IOM uint32_t CTSMIM     : 1;            /*!< [1..1] This bit holds the modem CTS interrupt enable.                     */
      __IOM uint32_t DCDMIM     : 1;            /*!< [2..2] This bit holds the modem DCD interrupt enable.                     */
      __IOM uint32_t DSRMIM     : 1;            /*!< [3..3] This bit holds the modem DSR interrupt enable.                     */
      __IOM uint32_t RXIM       : 1;            /*!< [4..4] This bit holds the receive interrupt enable.                       */
      __IOM uint32_t TXIM       : 1;            /*!< [5..5] This bit holds the transmit interrupt enable.                      */
      __IOM uint32_t RTIM       : 1;            /*!< [6..6] This bit holds the receive timeout interrupt enable.               */
      __IOM uint32_t FEIM       : 1;            /*!< [7..7] This bit holds the framing error interrupt enable.                 */
      __IOM uint32_t PEIM       : 1;            /*!< [8..8] This bit holds the parity error interrupt enable.                  */
      __IOM uint32_t BEIM       : 1;            /*!< [9..9] This bit holds the break error interrupt enable.                   */
      __IOM uint32_t OEIM       : 1;            /*!< [10..10] This bit holds the overflow interrupt enable.                    */
    } IER_b;
  } ;

  union {
    __IOM uint32_t IES;                         /*!< (@ 0x0000003C) Interrupt Status                                           */

    struct {
      __IOM uint32_t TXCMPMRIS  : 1;            /*!< [0..0] This bit holds the modem TXCMP interrupt status.                   */
      __IOM uint32_t CTSMRIS    : 1;            /*!< [1..1] This bit holds the modem CTS interrupt status.                     */
      __IOM uint32_t DCDMRIS    : 1;            /*!< [2..2] This bit holds the modem DCD interrupt status.                     */
      __IOM uint32_t DSRMRIS    : 1;            /*!< [3..3] This bit holds the modem DSR interrupt status.                     */
      __IOM uint32_t RXRIS      : 1;            /*!< [4..4] This bit holds the receive interrupt status.                       */
      __IOM uint32_t TXRIS      : 1;            /*!< [5..5] This bit holds the transmit interrupt status.                      */
      __IOM uint32_t RTRIS      : 1;            /*!< [6..6] This bit holds the receive timeout interrupt status.               */
      __IOM uint32_t FERIS      : 1;            /*!< [7..7] This bit holds the framing error interrupt status.                 */
      __IOM uint32_t PERIS      : 1;            /*!< [8..8] This bit holds the parity error interrupt status.                  */
      __IOM uint32_t BERIS      : 1;            /*!< [9..9] This bit holds the break error interrupt status.                   */
      __IOM uint32_t OERIS      : 1;            /*!< [10..10] This bit holds the overflow interrupt status.                    */
    } IES_b;
  } ;

  union {
    __IOM uint32_t MIS;                         /*!< (@ 0x00000040) Masked Interrupt Status                                    */

    struct {
      __IOM uint32_t TXCMPMMIS  : 1;            /*!< [0..0] This bit holds the modem TXCMP interrupt status masked.            */
      __IOM uint32_t CTSMMIS    : 1;            /*!< [1..1] This bit holds the modem CTS interrupt status masked.              */
      __IOM uint32_t DCDMMIS    : 1;            /*!< [2..2] This bit holds the modem DCD interrupt status masked.              */
      __IOM uint32_t DSRMMIS    : 1;            /*!< [3..3] This bit holds the modem DSR interrupt status masked.              */
      __IOM uint32_t RXMIS      : 1;            /*!< [4..4] This bit holds the receive interrupt status masked.                */
      __IOM uint32_t TXMIS      : 1;            /*!< [5..5] This bit holds the transmit interrupt status masked.               */
      __IOM uint32_t RTMIS      : 1;            /*!< [6..6] This bit holds the receive timeout interrupt status masked.        */
      __IOM uint32_t FEMIS      : 1;            /*!< [7..7] This bit holds the framing error interrupt status masked.          */
      __IOM uint32_t PEMIS      : 1;            /*!< [8..8] This bit holds the parity error interrupt status masked.           */
      __IOM uint32_t BEMIS      : 1;            /*!< [9..9] This bit holds the break error interrupt status masked.            */
      __IOM uint32_t OEMIS      : 1;            /*!< [10..10] This bit holds the overflow interrupt status masked.             */
    } MIS_b;
  } ;

  union {
    __IOM uint32_t IEC;                         /*!< (@ 0x00000044) Interrupt Clear                                            */

    struct {
      __IOM uint32_t TXCMPMIC   : 1;            /*!< [0..0] This bit holds the modem TXCMP interrupt clear.                    */
      __IOM uint32_t CTSMIC     : 1;            /*!< [1..1] This bit holds the modem CTS interrupt clear.                      */
      __IOM uint32_t DCDMIC     : 1;            /*!< [2..2] This bit holds the modem DCD interrupt clear.                      */
      __IOM uint32_t DSRMIC     : 1;            /*!< [3..3] This bit holds the modem DSR interrupt clear.                      */
      __IOM uint32_t RXIC       : 1;            /*!< [4..4] This bit holds the receive interrupt clear.                        */
      __IOM uint32_t TXIC       : 1;            /*!< [5..5] This bit holds the transmit interrupt clear.                       */
      __IOM uint32_t RTIC       : 1;            /*!< [6..6] This bit holds the receive timeout interrupt clear.                */
      __IOM uint32_t FEIC       : 1;            /*!< [7..7] This bit holds the framing error interrupt clear.                  */
      __IOM uint32_t PEIC       : 1;            /*!< [8..8] This bit holds the parity error interrupt clear.                   */
      __IOM uint32_t BEIC       : 1;            /*!< [9..9] This bit holds the break error interrupt clear.                    */
      __IOM uint32_t OEIC       : 1;            /*!< [10..10] This bit holds the overflow interrupt clear.                     */
    } IEC_b;
  } ;
} UART0_Type;                                   /*!< Size = 72 (0x48)                                                          */



/* =========================================================================================================================== */
/* ================                                           VCOMP                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Voltage Comparator (VCOMP)
  */

typedef struct {                                /*!< (@ 0x4000C000) VCOMP Structure                                            */

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Configuration Register                                     */

    struct {
      __IOM uint32_t PSEL       : 2;            /*!< [1..0] This bitfield selects the positive input to the comparator.        */
      __IM  uint32_t            : 6;
      __IOM uint32_t NSEL       : 2;            /*!< [9..8] This bitfield selects the negative input to the comparator.        */
      __IM  uint32_t            : 6;
      __IOM uint32_t LVLSEL     : 4;            /*!< [19..16] When the reference input NSEL is set to NSEL_DAC, this
                                                     bitfield selects the voltage level for the negative input
                                                     to the comparator.                                                        */
    } CFG_b;
  } ;

  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x00000004) Status Register                                            */

    struct {
      __IOM uint32_t CMPOUT     : 1;            /*!< [0..0] This bit is 1 if the positive input of the comparator
                                                     is greater than the negative input.                                       */
      __IOM uint32_t PWDSTAT    : 1;            /*!< [1..1] This bit indicates the power down state of the voltage
                                                     comparator.                                                               */
    } STAT_b;
  } ;

  union {
    __IOM uint32_t PWDKEY;                      /*!< (@ 0x00000008) Key Register for Powering Down the Voltage Comparator      */

    struct {
      __IOM uint32_t PWDKEY     : 32;           /*!< [31..0] Key register value.                                               */
    } PWDKEY_b;
  } ;
  __IM  uint32_t  RESERVED[125];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Voltage Comparator Interrupt registers: Enable             */

    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< [0..0] This bit is the vcompout low interrupt.                            */
      __IOM uint32_t OUTHI      : 1;            /*!< [1..1] This bit is the vcompout high interrupt.                           */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Voltage Comparator Interrupt registers: Status             */

    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< [0..0] This bit is the vcompout low interrupt.                            */
      __IOM uint32_t OUTHI      : 1;            /*!< [1..1] This bit is the vcompout high interrupt.                           */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Voltage Comparator Interrupt registers: Clear              */

    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< [0..0] This bit is the vcompout low interrupt.                            */
      __IOM uint32_t OUTHI      : 1;            /*!< [1..1] This bit is the vcompout high interrupt.                           */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Voltage Comparator Interrupt registers: Set                */

    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< [0..0] This bit is the vcompout low interrupt.                            */
      __IOM uint32_t OUTHI      : 1;            /*!< [1..1] This bit is the vcompout high interrupt.                           */
    } INTSET_b;
  } ;
} VCOMP_Type;                                   /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                            WDT                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Watchdog Timer (WDT)
  */

typedef struct {                                /*!< (@ 0x40024000) WDT Structure                                              */

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Configuration Register                                     */

    struct {
      __IOM uint32_t WDTEN      : 1;            /*!< [0..0] This bitfield enables the WDT.                                     */
      __IOM uint32_t INTEN      : 1;            /*!< [1..1] This bitfield enables the WDT interrupt. Note : This
                                                     bit must be set before the interrupt status bit will reflect
                                                     a watchdog timer expiration. The IER interrupt register
                                                     must also be enabled for a WDT interrupt to be sent to
                                                     the NVIC.                                                                 */
      __IOM uint32_t RESEN      : 1;            /*!< [2..2] This bitfield enables the WDT reset. This needs to be
                                                     set together with the WDREN bit in REG_RSTGEN_CFG register
                                                     (in reset gen) to trigger the reset.                                      */
      __IM  uint32_t            : 5;
      __IOM uint32_t RESVAL     : 8;            /*!< [15..8] This bitfield is the compare value for counter bits
                                                     7:0 to generate a watchdog reset. This will cause a software
                                                     reset.                                                                    */
      __IOM uint32_t INTVAL     : 8;            /*!< [23..16] This bitfield is the compare value for counter bits
                                                     7:0 to generate a watchdog interrupt.                                     */
      __IOM uint32_t CLKSEL     : 3;            /*!< [26..24] Select the frequency for the WDT. All values not enumerated
                                                     below are undefined.                                                      */
    } CFG_b;
  } ;

  union {
    __IOM uint32_t RSTRT;                       /*!< (@ 0x00000004) Restart the watchdog timer.                                */

    struct {
      __IOM uint32_t RSTRT      : 8;            /*!< [7..0] Writing 0xB2 to WDTRSTRT restarts the watchdog timer.
                                                     This is a write only register. Reading this register will
                                                     only provide all 0.                                                       */
    } RSTRT_b;
  } ;

  union {
    __IOM uint32_t LOCK;                        /*!< (@ 0x00000008) Locks the WDT                                              */

    struct {
      __IOM uint32_t LOCK       : 8;            /*!< [7..0] Writing 0x3A locks the watchdog timer. Once locked, the
                                                     WDTCFG reg cannot be written and WDTEN is set.                            */
    } LOCK_b;
  } ;

  union {
    __IOM uint32_t COUNT;                       /*!< (@ 0x0000000C) Current Counter Value for WDT                              */

    struct {
      __IOM uint32_t COUNT      : 8;            /*!< [7..0] Read-Only current value of the WDT counter                         */
    } COUNT_b;
  } ;
  __IM  uint32_t  RESERVED[124];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) WDT Interrupt register: Enable                             */

    struct {
      __IOM uint32_t WDTINT     : 1;            /*!< [0..0] Watchdog Timer Interrupt.                                          */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) WDT Interrupt register: Status                             */

    struct {
      __IOM uint32_t WDTINT     : 1;            /*!< [0..0] Watchdog Timer Interrupt.                                          */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) WDT Interrupt register: Clear                              */

    struct {
      __IOM uint32_t WDTINT     : 1;            /*!< [0..0] Watchdog Timer Interrupt.                                          */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) WDT Interrupt register: Set                                */

    struct {
      __IOM uint32_t WDTINT     : 1;            /*!< [0..0] Watchdog Timer Interrupt.                                          */
    } INTSET_b;
  } ;
} WDT_Type;                                     /*!< Size = 528 (0x210)                                                        */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */

#define ADC_BASE                    0x50010000UL
#define APBDMA_BASE                 0x40011000UL
#define BLEIF_BASE                  0x5000C000UL
#define CACHECTRL_BASE              0x40018000UL
#define CLKGEN_BASE                 0x40004000UL
#define CTIMER_BASE                 0x40008000UL
#define GPIO_BASE                   0x40010000UL
#define IOM0_BASE                   0x50004000UL
#define IOM1_BASE                   0x50005000UL
#define IOM2_BASE                   0x50006000UL
#define IOM3_BASE                   0x50007000UL
#define IOM4_BASE                   0x50008000UL
#define IOM5_BASE                   0x50009000UL
#define IOSLAVE_BASE                0x50000000UL
#define MCUCTRL_BASE                0x40020000UL
#define MSPI0_BASE                  0x50014000UL
#define MSPI1_BASE                  0x50015000UL
#define MSPI2_BASE                  0x50016000UL
#define PDM_BASE                    0x50011000UL
#define PWRCTRL_BASE                0x40021000UL
#define RSTGEN_BASE                 0x40000000UL
#define RTC_BASE                    0x40004200UL
#define SCARD_BASE                  0x40080000UL
#define SECURITY_BASE               0x40030000UL
#define UART0_BASE                  0x4001C000UL
#define UART1_BASE                  0x4001D000UL
#define VCOMP_BASE                  0x4000C000UL
#define WDT_BASE                    0x40024000UL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_declaration
  * @{
  */

#define ADC                         ((ADC_Type*)               ADC_BASE)
#define APBDMA                      ((APBDMA_Type*)            APBDMA_BASE)
#define BLEIF                       ((BLEIF_Type*)             BLEIF_BASE)
#define CACHECTRL                   ((CACHECTRL_Type*)         CACHECTRL_BASE)
#define CLKGEN                      ((CLKGEN_Type*)            CLKGEN_BASE)
#define CTIMER                      ((CTIMER_Type*)            CTIMER_BASE)
#define GPIO                        ((GPIO_Type*)              GPIO_BASE)
#define IOM0                        ((IOM0_Type*)              IOM0_BASE)
#define IOM1                        ((IOM0_Type*)              IOM1_BASE)
#define IOM2                        ((IOM0_Type*)              IOM2_BASE)
#define IOM3                        ((IOM0_Type*)              IOM3_BASE)
#define IOM4                        ((IOM0_Type*)              IOM4_BASE)
#define IOM5                        ((IOM0_Type*)              IOM5_BASE)
#define IOSLAVE                     ((IOSLAVE_Type*)           IOSLAVE_BASE)
#define MCUCTRL                     ((MCUCTRL_Type*)           MCUCTRL_BASE)
#define MSPI0                       ((MSPI0_Type*)             MSPI0_BASE)
#define MSPI1                       ((MSPI0_Type*)             MSPI1_BASE)
#define MSPI2                       ((MSPI0_Type*)             MSPI2_BASE)
#define PDM                         ((PDM_Type*)               PDM_BASE)
#define PWRCTRL                     ((PWRCTRL_Type*)           PWRCTRL_BASE)
#define RSTGEN                      ((RSTGEN_Type*)            RSTGEN_BASE)
#define RTC                         ((RTC_Type*)               RTC_BASE)
#define SCARD                       ((SCARD_Type*)             SCARD_BASE)
#define SECURITY                    ((SECURITY_Type*)          SECURITY_BASE)
#define UART0                       ((UART0_Type*)             UART0_BASE)
#define UART1                       ((UART0_Type*)             UART1_BASE)
#define VCOMP                       ((VCOMP_Type*)             VCOMP_BASE)
#define WDT                         ((WDT_Type*)               WDT_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */


/* =========================================  End of section using anonymous unions  ========================================= */
#if defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#endif


/* =========================================================================================================================== */
/* ================                                Pos/Mask Peripheral Section                                ================ */
/* =========================================================================================================================== */


/** @addtogroup PosMask_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                            ADC                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
#define ADC_CFG_CLKSEL_Pos                (24UL)                    /*!< ADC CFG: CLKSEL (Bit 24)                              */
#define ADC_CFG_CLKSEL_Msk                (0x3000000UL)             /*!< ADC CFG: CLKSEL (Bitfield-Mask: 0x03)                 */
#define ADC_CFG_TRIGPOL_Pos               (19UL)                    /*!< ADC CFG: TRIGPOL (Bit 19)                             */
#define ADC_CFG_TRIGPOL_Msk               (0x80000UL)               /*!< ADC CFG: TRIGPOL (Bitfield-Mask: 0x01)                */
#define ADC_CFG_TRIGSEL_Pos               (16UL)                    /*!< ADC CFG: TRIGSEL (Bit 16)                             */
#define ADC_CFG_TRIGSEL_Msk               (0x70000UL)               /*!< ADC CFG: TRIGSEL (Bitfield-Mask: 0x07)                */
#define ADC_CFG_DFIFORDEN_Pos             (12UL)                    /*!< ADC CFG: DFIFORDEN (Bit 12)                           */
#define ADC_CFG_DFIFORDEN_Msk             (0x1000UL)                /*!< ADC CFG: DFIFORDEN (Bitfield-Mask: 0x01)              */
#define ADC_CFG_REFSEL_Pos                (8UL)                     /*!< ADC CFG: REFSEL (Bit 8)                               */
#define ADC_CFG_REFSEL_Msk                (0x300UL)                 /*!< ADC CFG: REFSEL (Bitfield-Mask: 0x03)                 */
#define ADC_CFG_CKMODE_Pos                (4UL)                     /*!< ADC CFG: CKMODE (Bit 4)                               */
#define ADC_CFG_CKMODE_Msk                (0x10UL)                  /*!< ADC CFG: CKMODE (Bitfield-Mask: 0x01)                 */
#define ADC_CFG_LPMODE_Pos                (3UL)                     /*!< ADC CFG: LPMODE (Bit 3)                               */
#define ADC_CFG_LPMODE_Msk                (0x8UL)                   /*!< ADC CFG: LPMODE (Bitfield-Mask: 0x01)                 */
#define ADC_CFG_RPTEN_Pos                 (2UL)                     /*!< ADC CFG: RPTEN (Bit 2)                                */
#define ADC_CFG_RPTEN_Msk                 (0x4UL)                   /*!< ADC CFG: RPTEN (Bitfield-Mask: 0x01)                  */
#define ADC_CFG_ADCEN_Pos                 (0UL)                     /*!< ADC CFG: ADCEN (Bit 0)                                */
#define ADC_CFG_ADCEN_Msk                 (0x1UL)                   /*!< ADC CFG: ADCEN (Bitfield-Mask: 0x01)                  */
/* =========================================================  STAT  ========================================================== */
#define ADC_STAT_PWDSTAT_Pos              (0UL)                     /*!< ADC STAT: PWDSTAT (Bit 0)                             */
#define ADC_STAT_PWDSTAT_Msk              (0x1UL)                   /*!< ADC STAT: PWDSTAT (Bitfield-Mask: 0x01)               */
/* ==========================================================  SWT  ========================================================== */
#define ADC_SWT_SWT_Pos                   (0UL)                     /*!< ADC SWT: SWT (Bit 0)                                  */
#define ADC_SWT_SWT_Msk                   (0xffUL)                  /*!< ADC SWT: SWT (Bitfield-Mask: 0xff)                    */
/* ========================================================  SL0CFG  ========================================================= */
#define ADC_SL0CFG_ADSEL0_Pos             (24UL)                    /*!< ADC SL0CFG: ADSEL0 (Bit 24)                           */
#define ADC_SL0CFG_ADSEL0_Msk             (0x7000000UL)             /*!< ADC SL0CFG: ADSEL0 (Bitfield-Mask: 0x07)              */
#define ADC_SL0CFG_PRMODE0_Pos            (16UL)                    /*!< ADC SL0CFG: PRMODE0 (Bit 16)                          */
#define ADC_SL0CFG_PRMODE0_Msk            (0x30000UL)               /*!< ADC SL0CFG: PRMODE0 (Bitfield-Mask: 0x03)             */
#define ADC_SL0CFG_CHSEL0_Pos             (8UL)                     /*!< ADC SL0CFG: CHSEL0 (Bit 8)                            */
#define ADC_SL0CFG_CHSEL0_Msk             (0xf00UL)                 /*!< ADC SL0CFG: CHSEL0 (Bitfield-Mask: 0x0f)              */
#define ADC_SL0CFG_WCEN0_Pos              (1UL)                     /*!< ADC SL0CFG: WCEN0 (Bit 1)                             */
#define ADC_SL0CFG_WCEN0_Msk              (0x2UL)                   /*!< ADC SL0CFG: WCEN0 (Bitfield-Mask: 0x01)               */
#define ADC_SL0CFG_SLEN0_Pos              (0UL)                     /*!< ADC SL0CFG: SLEN0 (Bit 0)                             */
#define ADC_SL0CFG_SLEN0_Msk              (0x1UL)                   /*!< ADC SL0CFG: SLEN0 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL1CFG  ========================================================= */
#define ADC_SL1CFG_ADSEL1_Pos             (24UL)                    /*!< ADC SL1CFG: ADSEL1 (Bit 24)                           */
#define ADC_SL1CFG_ADSEL1_Msk             (0x7000000UL)             /*!< ADC SL1CFG: ADSEL1 (Bitfield-Mask: 0x07)              */
#define ADC_SL1CFG_PRMODE1_Pos            (16UL)                    /*!< ADC SL1CFG: PRMODE1 (Bit 16)                          */
#define ADC_SL1CFG_PRMODE1_Msk            (0x30000UL)               /*!< ADC SL1CFG: PRMODE1 (Bitfield-Mask: 0x03)             */
#define ADC_SL1CFG_CHSEL1_Pos             (8UL)                     /*!< ADC SL1CFG: CHSEL1 (Bit 8)                            */
#define ADC_SL1CFG_CHSEL1_Msk             (0xf00UL)                 /*!< ADC SL1CFG: CHSEL1 (Bitfield-Mask: 0x0f)              */
#define ADC_SL1CFG_WCEN1_Pos              (1UL)                     /*!< ADC SL1CFG: WCEN1 (Bit 1)                             */
#define ADC_SL1CFG_WCEN1_Msk              (0x2UL)                   /*!< ADC SL1CFG: WCEN1 (Bitfield-Mask: 0x01)               */
#define ADC_SL1CFG_SLEN1_Pos              (0UL)                     /*!< ADC SL1CFG: SLEN1 (Bit 0)                             */
#define ADC_SL1CFG_SLEN1_Msk              (0x1UL)                   /*!< ADC SL1CFG: SLEN1 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL2CFG  ========================================================= */
#define ADC_SL2CFG_ADSEL2_Pos             (24UL)                    /*!< ADC SL2CFG: ADSEL2 (Bit 24)                           */
#define ADC_SL2CFG_ADSEL2_Msk             (0x7000000UL)             /*!< ADC SL2CFG: ADSEL2 (Bitfield-Mask: 0x07)              */
#define ADC_SL2CFG_PRMODE2_Pos            (16UL)                    /*!< ADC SL2CFG: PRMODE2 (Bit 16)                          */
#define ADC_SL2CFG_PRMODE2_Msk            (0x30000UL)               /*!< ADC SL2CFG: PRMODE2 (Bitfield-Mask: 0x03)             */
#define ADC_SL2CFG_CHSEL2_Pos             (8UL)                     /*!< ADC SL2CFG: CHSEL2 (Bit 8)                            */
#define ADC_SL2CFG_CHSEL2_Msk             (0xf00UL)                 /*!< ADC SL2CFG: CHSEL2 (Bitfield-Mask: 0x0f)              */
#define ADC_SL2CFG_WCEN2_Pos              (1UL)                     /*!< ADC SL2CFG: WCEN2 (Bit 1)                             */
#define ADC_SL2CFG_WCEN2_Msk              (0x2UL)                   /*!< ADC SL2CFG: WCEN2 (Bitfield-Mask: 0x01)               */
#define ADC_SL2CFG_SLEN2_Pos              (0UL)                     /*!< ADC SL2CFG: SLEN2 (Bit 0)                             */
#define ADC_SL2CFG_SLEN2_Msk              (0x1UL)                   /*!< ADC SL2CFG: SLEN2 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL3CFG  ========================================================= */
#define ADC_SL3CFG_ADSEL3_Pos             (24UL)                    /*!< ADC SL3CFG: ADSEL3 (Bit 24)                           */
#define ADC_SL3CFG_ADSEL3_Msk             (0x7000000UL)             /*!< ADC SL3CFG: ADSEL3 (Bitfield-Mask: 0x07)              */
#define ADC_SL3CFG_PRMODE3_Pos            (16UL)                    /*!< ADC SL3CFG: PRMODE3 (Bit 16)                          */
#define ADC_SL3CFG_PRMODE3_Msk            (0x30000UL)               /*!< ADC SL3CFG: PRMODE3 (Bitfield-Mask: 0x03)             */
#define ADC_SL3CFG_CHSEL3_Pos             (8UL)                     /*!< ADC SL3CFG: CHSEL3 (Bit 8)                            */
#define ADC_SL3CFG_CHSEL3_Msk             (0xf00UL)                 /*!< ADC SL3CFG: CHSEL3 (Bitfield-Mask: 0x0f)              */
#define ADC_SL3CFG_WCEN3_Pos              (1UL)                     /*!< ADC SL3CFG: WCEN3 (Bit 1)                             */
#define ADC_SL3CFG_WCEN3_Msk              (0x2UL)                   /*!< ADC SL3CFG: WCEN3 (Bitfield-Mask: 0x01)               */
#define ADC_SL3CFG_SLEN3_Pos              (0UL)                     /*!< ADC SL3CFG: SLEN3 (Bit 0)                             */
#define ADC_SL3CFG_SLEN3_Msk              (0x1UL)                   /*!< ADC SL3CFG: SLEN3 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL4CFG  ========================================================= */
#define ADC_SL4CFG_ADSEL4_Pos             (24UL)                    /*!< ADC SL4CFG: ADSEL4 (Bit 24)                           */
#define ADC_SL4CFG_ADSEL4_Msk             (0x7000000UL)             /*!< ADC SL4CFG: ADSEL4 (Bitfield-Mask: 0x07)              */
#define ADC_SL4CFG_PRMODE4_Pos            (16UL)                    /*!< ADC SL4CFG: PRMODE4 (Bit 16)                          */
#define ADC_SL4CFG_PRMODE4_Msk            (0x30000UL)               /*!< ADC SL4CFG: PRMODE4 (Bitfield-Mask: 0x03)             */
#define ADC_SL4CFG_CHSEL4_Pos             (8UL)                     /*!< ADC SL4CFG: CHSEL4 (Bit 8)                            */
#define ADC_SL4CFG_CHSEL4_Msk             (0xf00UL)                 /*!< ADC SL4CFG: CHSEL4 (Bitfield-Mask: 0x0f)              */
#define ADC_SL4CFG_WCEN4_Pos              (1UL)                     /*!< ADC SL4CFG: WCEN4 (Bit 1)                             */
#define ADC_SL4CFG_WCEN4_Msk              (0x2UL)                   /*!< ADC SL4CFG: WCEN4 (Bitfield-Mask: 0x01)               */
#define ADC_SL4CFG_SLEN4_Pos              (0UL)                     /*!< ADC SL4CFG: SLEN4 (Bit 0)                             */
#define ADC_SL4CFG_SLEN4_Msk              (0x1UL)                   /*!< ADC SL4CFG: SLEN4 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL5CFG  ========================================================= */
#define ADC_SL5CFG_ADSEL5_Pos             (24UL)                    /*!< ADC SL5CFG: ADSEL5 (Bit 24)                           */
#define ADC_SL5CFG_ADSEL5_Msk             (0x7000000UL)             /*!< ADC SL5CFG: ADSEL5 (Bitfield-Mask: 0x07)              */
#define ADC_SL5CFG_PRMODE5_Pos            (16UL)                    /*!< ADC SL5CFG: PRMODE5 (Bit 16)                          */
#define ADC_SL5CFG_PRMODE5_Msk            (0x30000UL)               /*!< ADC SL5CFG: PRMODE5 (Bitfield-Mask: 0x03)             */
#define ADC_SL5CFG_CHSEL5_Pos             (8UL)                     /*!< ADC SL5CFG: CHSEL5 (Bit 8)                            */
#define ADC_SL5CFG_CHSEL5_Msk             (0xf00UL)                 /*!< ADC SL5CFG: CHSEL5 (Bitfield-Mask: 0x0f)              */
#define ADC_SL5CFG_WCEN5_Pos              (1UL)                     /*!< ADC SL5CFG: WCEN5 (Bit 1)                             */
#define ADC_SL5CFG_WCEN5_Msk              (0x2UL)                   /*!< ADC SL5CFG: WCEN5 (Bitfield-Mask: 0x01)               */
#define ADC_SL5CFG_SLEN5_Pos              (0UL)                     /*!< ADC SL5CFG: SLEN5 (Bit 0)                             */
#define ADC_SL5CFG_SLEN5_Msk              (0x1UL)                   /*!< ADC SL5CFG: SLEN5 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL6CFG  ========================================================= */
#define ADC_SL6CFG_ADSEL6_Pos             (24UL)                    /*!< ADC SL6CFG: ADSEL6 (Bit 24)                           */
#define ADC_SL6CFG_ADSEL6_Msk             (0x7000000UL)             /*!< ADC SL6CFG: ADSEL6 (Bitfield-Mask: 0x07)              */
#define ADC_SL6CFG_PRMODE6_Pos            (16UL)                    /*!< ADC SL6CFG: PRMODE6 (Bit 16)                          */
#define ADC_SL6CFG_PRMODE6_Msk            (0x30000UL)               /*!< ADC SL6CFG: PRMODE6 (Bitfield-Mask: 0x03)             */
#define ADC_SL6CFG_CHSEL6_Pos             (8UL)                     /*!< ADC SL6CFG: CHSEL6 (Bit 8)                            */
#define ADC_SL6CFG_CHSEL6_Msk             (0xf00UL)                 /*!< ADC SL6CFG: CHSEL6 (Bitfield-Mask: 0x0f)              */
#define ADC_SL6CFG_WCEN6_Pos              (1UL)                     /*!< ADC SL6CFG: WCEN6 (Bit 1)                             */
#define ADC_SL6CFG_WCEN6_Msk              (0x2UL)                   /*!< ADC SL6CFG: WCEN6 (Bitfield-Mask: 0x01)               */
#define ADC_SL6CFG_SLEN6_Pos              (0UL)                     /*!< ADC SL6CFG: SLEN6 (Bit 0)                             */
#define ADC_SL6CFG_SLEN6_Msk              (0x1UL)                   /*!< ADC SL6CFG: SLEN6 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL7CFG  ========================================================= */
#define ADC_SL7CFG_ADSEL7_Pos             (24UL)                    /*!< ADC SL7CFG: ADSEL7 (Bit 24)                           */
#define ADC_SL7CFG_ADSEL7_Msk             (0x7000000UL)             /*!< ADC SL7CFG: ADSEL7 (Bitfield-Mask: 0x07)              */
#define ADC_SL7CFG_PRMODE7_Pos            (16UL)                    /*!< ADC SL7CFG: PRMODE7 (Bit 16)                          */
#define ADC_SL7CFG_PRMODE7_Msk            (0x30000UL)               /*!< ADC SL7CFG: PRMODE7 (Bitfield-Mask: 0x03)             */
#define ADC_SL7CFG_CHSEL7_Pos             (8UL)                     /*!< ADC SL7CFG: CHSEL7 (Bit 8)                            */
#define ADC_SL7CFG_CHSEL7_Msk             (0xf00UL)                 /*!< ADC SL7CFG: CHSEL7 (Bitfield-Mask: 0x0f)              */
#define ADC_SL7CFG_WCEN7_Pos              (1UL)                     /*!< ADC SL7CFG: WCEN7 (Bit 1)                             */
#define ADC_SL7CFG_WCEN7_Msk              (0x2UL)                   /*!< ADC SL7CFG: WCEN7 (Bitfield-Mask: 0x01)               */
#define ADC_SL7CFG_SLEN7_Pos              (0UL)                     /*!< ADC SL7CFG: SLEN7 (Bit 0)                             */
#define ADC_SL7CFG_SLEN7_Msk              (0x1UL)                   /*!< ADC SL7CFG: SLEN7 (Bitfield-Mask: 0x01)               */
/* =========================================================  WULIM  ========================================================= */
#define ADC_WULIM_ULIM_Pos                (0UL)                     /*!< ADC WULIM: ULIM (Bit 0)                               */
#define ADC_WULIM_ULIM_Msk                (0xfffffUL)               /*!< ADC WULIM: ULIM (Bitfield-Mask: 0xfffff)              */
/* =========================================================  WLLIM  ========================================================= */
#define ADC_WLLIM_LLIM_Pos                (0UL)                     /*!< ADC WLLIM: LLIM (Bit 0)                               */
#define ADC_WLLIM_LLIM_Msk                (0xfffffUL)               /*!< ADC WLLIM: LLIM (Bitfield-Mask: 0xfffff)              */
/* ========================================================  SCWLIM  ========================================================= */
#define ADC_SCWLIM_SCWLIMEN_Pos           (0UL)                     /*!< ADC SCWLIM: SCWLIMEN (Bit 0)                          */
#define ADC_SCWLIM_SCWLIMEN_Msk           (0x1UL)                   /*!< ADC SCWLIM: SCWLIMEN (Bitfield-Mask: 0x01)            */
/* =========================================================  FIFO  ========================================================== */
#define ADC_FIFO_RSVD_Pos                 (31UL)                    /*!< ADC FIFO: RSVD (Bit 31)                               */
#define ADC_FIFO_RSVD_Msk                 (0x80000000UL)            /*!< ADC FIFO: RSVD (Bitfield-Mask: 0x01)                  */
#define ADC_FIFO_SLOTNUM_Pos              (28UL)                    /*!< ADC FIFO: SLOTNUM (Bit 28)                            */
#define ADC_FIFO_SLOTNUM_Msk              (0x70000000UL)            /*!< ADC FIFO: SLOTNUM (Bitfield-Mask: 0x07)               */
#define ADC_FIFO_COUNT_Pos                (20UL)                    /*!< ADC FIFO: COUNT (Bit 20)                              */
#define ADC_FIFO_COUNT_Msk                (0xff00000UL)             /*!< ADC FIFO: COUNT (Bitfield-Mask: 0xff)                 */
#define ADC_FIFO_DATA_Pos                 (0UL)                     /*!< ADC FIFO: DATA (Bit 0)                                */
#define ADC_FIFO_DATA_Msk                 (0xfffffUL)               /*!< ADC FIFO: DATA (Bitfield-Mask: 0xfffff)               */
/* ========================================================  FIFOPR  ========================================================= */
#define ADC_FIFOPR_RSVDPR_Pos             (31UL)                    /*!< ADC FIFOPR: RSVDPR (Bit 31)                           */
#define ADC_FIFOPR_RSVDPR_Msk             (0x80000000UL)            /*!< ADC FIFOPR: RSVDPR (Bitfield-Mask: 0x01)              */
#define ADC_FIFOPR_SLOTNUMPR_Pos          (28UL)                    /*!< ADC FIFOPR: SLOTNUMPR (Bit 28)                        */
#define ADC_FIFOPR_SLOTNUMPR_Msk          (0x70000000UL)            /*!< ADC FIFOPR: SLOTNUMPR (Bitfield-Mask: 0x07)           */
#define ADC_FIFOPR_COUNT_Pos              (20UL)                    /*!< ADC FIFOPR: COUNT (Bit 20)                            */
#define ADC_FIFOPR_COUNT_Msk              (0xff00000UL)             /*!< ADC FIFOPR: COUNT (Bitfield-Mask: 0xff)               */
#define ADC_FIFOPR_DATA_Pos               (0UL)                     /*!< ADC FIFOPR: DATA (Bit 0)                              */
#define ADC_FIFOPR_DATA_Msk               (0xfffffUL)               /*!< ADC FIFOPR: DATA (Bitfield-Mask: 0xfffff)             */
/* =========================================================  INTEN  ========================================================= */
#define ADC_INTEN_DERR_Pos                (7UL)                     /*!< ADC INTEN: DERR (Bit 7)                               */
#define ADC_INTEN_DERR_Msk                (0x80UL)                  /*!< ADC INTEN: DERR (Bitfield-Mask: 0x01)                 */
#define ADC_INTEN_DCMP_Pos                (6UL)                     /*!< ADC INTEN: DCMP (Bit 6)                               */
#define ADC_INTEN_DCMP_Msk                (0x40UL)                  /*!< ADC INTEN: DCMP (Bitfield-Mask: 0x01)                 */
#define ADC_INTEN_WCINC_Pos               (5UL)                     /*!< ADC INTEN: WCINC (Bit 5)                              */
#define ADC_INTEN_WCINC_Msk               (0x20UL)                  /*!< ADC INTEN: WCINC (Bitfield-Mask: 0x01)                */
#define ADC_INTEN_WCEXC_Pos               (4UL)                     /*!< ADC INTEN: WCEXC (Bit 4)                              */
#define ADC_INTEN_WCEXC_Msk               (0x10UL)                  /*!< ADC INTEN: WCEXC (Bitfield-Mask: 0x01)                */
#define ADC_INTEN_FIFOOVR2_Pos            (3UL)                     /*!< ADC INTEN: FIFOOVR2 (Bit 3)                           */
#define ADC_INTEN_FIFOOVR2_Msk            (0x8UL)                   /*!< ADC INTEN: FIFOOVR2 (Bitfield-Mask: 0x01)             */
#define ADC_INTEN_FIFOOVR1_Pos            (2UL)                     /*!< ADC INTEN: FIFOOVR1 (Bit 2)                           */
#define ADC_INTEN_FIFOOVR1_Msk            (0x4UL)                   /*!< ADC INTEN: FIFOOVR1 (Bitfield-Mask: 0x01)             */
#define ADC_INTEN_SCNCMP_Pos              (1UL)                     /*!< ADC INTEN: SCNCMP (Bit 1)                             */
#define ADC_INTEN_SCNCMP_Msk              (0x2UL)                   /*!< ADC INTEN: SCNCMP (Bitfield-Mask: 0x01)               */
#define ADC_INTEN_CNVCMP_Pos              (0UL)                     /*!< ADC INTEN: CNVCMP (Bit 0)                             */
#define ADC_INTEN_CNVCMP_Msk              (0x1UL)                   /*!< ADC INTEN: CNVCMP (Bitfield-Mask: 0x01)               */
/* ========================================================  INTSTAT  ======================================================== */
#define ADC_INTSTAT_DERR_Pos              (7UL)                     /*!< ADC INTSTAT: DERR (Bit 7)                             */
#define ADC_INTSTAT_DERR_Msk              (0x80UL)                  /*!< ADC INTSTAT: DERR (Bitfield-Mask: 0x01)               */
#define ADC_INTSTAT_DCMP_Pos              (6UL)                     /*!< ADC INTSTAT: DCMP (Bit 6)                             */
#define ADC_INTSTAT_DCMP_Msk              (0x40UL)                  /*!< ADC INTSTAT: DCMP (Bitfield-Mask: 0x01)               */
#define ADC_INTSTAT_WCINC_Pos             (5UL)                     /*!< ADC INTSTAT: WCINC (Bit 5)                            */
#define ADC_INTSTAT_WCINC_Msk             (0x20UL)                  /*!< ADC INTSTAT: WCINC (Bitfield-Mask: 0x01)              */
#define ADC_INTSTAT_WCEXC_Pos             (4UL)                     /*!< ADC INTSTAT: WCEXC (Bit 4)                            */
#define ADC_INTSTAT_WCEXC_Msk             (0x10UL)                  /*!< ADC INTSTAT: WCEXC (Bitfield-Mask: 0x01)              */
#define ADC_INTSTAT_FIFOOVR2_Pos          (3UL)                     /*!< ADC INTSTAT: FIFOOVR2 (Bit 3)                         */
#define ADC_INTSTAT_FIFOOVR2_Msk          (0x8UL)                   /*!< ADC INTSTAT: FIFOOVR2 (Bitfield-Mask: 0x01)           */
#define ADC_INTSTAT_FIFOOVR1_Pos          (2UL)                     /*!< ADC INTSTAT: FIFOOVR1 (Bit 2)                         */
#define ADC_INTSTAT_FIFOOVR1_Msk          (0x4UL)                   /*!< ADC INTSTAT: FIFOOVR1 (Bitfield-Mask: 0x01)           */
#define ADC_INTSTAT_SCNCMP_Pos            (1UL)                     /*!< ADC INTSTAT: SCNCMP (Bit 1)                           */
#define ADC_INTSTAT_SCNCMP_Msk            (0x2UL)                   /*!< ADC INTSTAT: SCNCMP (Bitfield-Mask: 0x01)             */
#define ADC_INTSTAT_CNVCMP_Pos            (0UL)                     /*!< ADC INTSTAT: CNVCMP (Bit 0)                           */
#define ADC_INTSTAT_CNVCMP_Msk            (0x1UL)                   /*!< ADC INTSTAT: CNVCMP (Bitfield-Mask: 0x01)             */
/* ========================================================  INTCLR  ========================================================= */
#define ADC_INTCLR_DERR_Pos               (7UL)                     /*!< ADC INTCLR: DERR (Bit 7)                              */
#define ADC_INTCLR_DERR_Msk               (0x80UL)                  /*!< ADC INTCLR: DERR (Bitfield-Mask: 0x01)                */
#define ADC_INTCLR_DCMP_Pos               (6UL)                     /*!< ADC INTCLR: DCMP (Bit 6)                              */
#define ADC_INTCLR_DCMP_Msk               (0x40UL)                  /*!< ADC INTCLR: DCMP (Bitfield-Mask: 0x01)                */
#define ADC_INTCLR_WCINC_Pos              (5UL)                     /*!< ADC INTCLR: WCINC (Bit 5)                             */
#define ADC_INTCLR_WCINC_Msk              (0x20UL)                  /*!< ADC INTCLR: WCINC (Bitfield-Mask: 0x01)               */
#define ADC_INTCLR_WCEXC_Pos              (4UL)                     /*!< ADC INTCLR: WCEXC (Bit 4)                             */
#define ADC_INTCLR_WCEXC_Msk              (0x10UL)                  /*!< ADC INTCLR: WCEXC (Bitfield-Mask: 0x01)               */
#define ADC_INTCLR_FIFOOVR2_Pos           (3UL)                     /*!< ADC INTCLR: FIFOOVR2 (Bit 3)                          */
#define ADC_INTCLR_FIFOOVR2_Msk           (0x8UL)                   /*!< ADC INTCLR: FIFOOVR2 (Bitfield-Mask: 0x01)            */
#define ADC_INTCLR_FIFOOVR1_Pos           (2UL)                     /*!< ADC INTCLR: FIFOOVR1 (Bit 2)                          */
#define ADC_INTCLR_FIFOOVR1_Msk           (0x4UL)                   /*!< ADC INTCLR: FIFOOVR1 (Bitfield-Mask: 0x01)            */
#define ADC_INTCLR_SCNCMP_Pos             (1UL)                     /*!< ADC INTCLR: SCNCMP (Bit 1)                            */
#define ADC_INTCLR_SCNCMP_Msk             (0x2UL)                   /*!< ADC INTCLR: SCNCMP (Bitfield-Mask: 0x01)              */
#define ADC_INTCLR_CNVCMP_Pos             (0UL)                     /*!< ADC INTCLR: CNVCMP (Bit 0)                            */
#define ADC_INTCLR_CNVCMP_Msk             (0x1UL)                   /*!< ADC INTCLR: CNVCMP (Bitfield-Mask: 0x01)              */
/* ========================================================  INTSET  ========================================================= */
#define ADC_INTSET_DERR_Pos               (7UL)                     /*!< ADC INTSET: DERR (Bit 7)                              */
#define ADC_INTSET_DERR_Msk               (0x80UL)                  /*!< ADC INTSET: DERR (Bitfield-Mask: 0x01)                */
#define ADC_INTSET_DCMP_Pos               (6UL)                     /*!< ADC INTSET: DCMP (Bit 6)                              */
#define ADC_INTSET_DCMP_Msk               (0x40UL)                  /*!< ADC INTSET: DCMP (Bitfield-Mask: 0x01)                */
#define ADC_INTSET_WCINC_Pos              (5UL)                     /*!< ADC INTSET: WCINC (Bit 5)                             */
#define ADC_INTSET_WCINC_Msk              (0x20UL)                  /*!< ADC INTSET: WCINC (Bitfield-Mask: 0x01)               */
#define ADC_INTSET_WCEXC_Pos              (4UL)                     /*!< ADC INTSET: WCEXC (Bit 4)                             */
#define ADC_INTSET_WCEXC_Msk              (0x10UL)                  /*!< ADC INTSET: WCEXC (Bitfield-Mask: 0x01)               */
#define ADC_INTSET_FIFOOVR2_Pos           (3UL)                     /*!< ADC INTSET: FIFOOVR2 (Bit 3)                          */
#define ADC_INTSET_FIFOOVR2_Msk           (0x8UL)                   /*!< ADC INTSET: FIFOOVR2 (Bitfield-Mask: 0x01)            */
#define ADC_INTSET_FIFOOVR1_Pos           (2UL)                     /*!< ADC INTSET: FIFOOVR1 (Bit 2)                          */
#define ADC_INTSET_FIFOOVR1_Msk           (0x4UL)                   /*!< ADC INTSET: FIFOOVR1 (Bitfield-Mask: 0x01)            */
#define ADC_INTSET_SCNCMP_Pos             (1UL)                     /*!< ADC INTSET: SCNCMP (Bit 1)                            */
#define ADC_INTSET_SCNCMP_Msk             (0x2UL)                   /*!< ADC INTSET: SCNCMP (Bitfield-Mask: 0x01)              */
#define ADC_INTSET_CNVCMP_Pos             (0UL)                     /*!< ADC INTSET: CNVCMP (Bit 0)                            */
#define ADC_INTSET_CNVCMP_Msk             (0x1UL)                   /*!< ADC INTSET: CNVCMP (Bitfield-Mask: 0x01)              */
/* =======================================================  DMATRIGEN  ======================================================= */
#define ADC_DMATRIGEN_DFIFOFULL_Pos       (1UL)                     /*!< ADC DMATRIGEN: DFIFOFULL (Bit 1)                      */
#define ADC_DMATRIGEN_DFIFOFULL_Msk       (0x2UL)                   /*!< ADC DMATRIGEN: DFIFOFULL (Bitfield-Mask: 0x01)        */
#define ADC_DMATRIGEN_DFIFO75_Pos         (0UL)                     /*!< ADC DMATRIGEN: DFIFO75 (Bit 0)                        */
#define ADC_DMATRIGEN_DFIFO75_Msk         (0x1UL)                   /*!< ADC DMATRIGEN: DFIFO75 (Bitfield-Mask: 0x01)          */
/* ======================================================  DMATRIGSTAT  ====================================================== */
#define ADC_DMATRIGSTAT_DFULLSTAT_Pos     (1UL)                     /*!< ADC DMATRIGSTAT: DFULLSTAT (Bit 1)                    */
#define ADC_DMATRIGSTAT_DFULLSTAT_Msk     (0x2UL)                   /*!< ADC DMATRIGSTAT: DFULLSTAT (Bitfield-Mask: 0x01)      */
#define ADC_DMATRIGSTAT_D75STAT_Pos       (0UL)                     /*!< ADC DMATRIGSTAT: D75STAT (Bit 0)                      */
#define ADC_DMATRIGSTAT_D75STAT_Msk       (0x1UL)                   /*!< ADC DMATRIGSTAT: D75STAT (Bitfield-Mask: 0x01)        */
/* ========================================================  DMACFG  ========================================================= */
#define ADC_DMACFG_DPWROFF_Pos            (18UL)                    /*!< ADC DMACFG: DPWROFF (Bit 18)                          */
#define ADC_DMACFG_DPWROFF_Msk            (0x40000UL)               /*!< ADC DMACFG: DPWROFF (Bitfield-Mask: 0x01)             */
#define ADC_DMACFG_DMAMSK_Pos             (17UL)                    /*!< ADC DMACFG: DMAMSK (Bit 17)                           */
#define ADC_DMACFG_DMAMSK_Msk             (0x20000UL)               /*!< ADC DMACFG: DMAMSK (Bitfield-Mask: 0x01)              */
#define ADC_DMACFG_DMAHONSTAT_Pos         (16UL)                    /*!< ADC DMACFG: DMAHONSTAT (Bit 16)                       */
#define ADC_DMACFG_DMAHONSTAT_Msk         (0x10000UL)               /*!< ADC DMACFG: DMAHONSTAT (Bitfield-Mask: 0x01)          */
#define ADC_DMACFG_DMADYNPRI_Pos          (9UL)                     /*!< ADC DMACFG: DMADYNPRI (Bit 9)                         */
#define ADC_DMACFG_DMADYNPRI_Msk          (0x200UL)                 /*!< ADC DMACFG: DMADYNPRI (Bitfield-Mask: 0x01)           */
#define ADC_DMACFG_DMAPRI_Pos             (8UL)                     /*!< ADC DMACFG: DMAPRI (Bit 8)                            */
#define ADC_DMACFG_DMAPRI_Msk             (0x100UL)                 /*!< ADC DMACFG: DMAPRI (Bitfield-Mask: 0x01)              */
#define ADC_DMACFG_DMADIR_Pos             (2UL)                     /*!< ADC DMACFG: DMADIR (Bit 2)                            */
#define ADC_DMACFG_DMADIR_Msk             (0x4UL)                   /*!< ADC DMACFG: DMADIR (Bitfield-Mask: 0x01)              */
#define ADC_DMACFG_DMAEN_Pos              (0UL)                     /*!< ADC DMACFG: DMAEN (Bit 0)                             */
#define ADC_DMACFG_DMAEN_Msk              (0x1UL)                   /*!< ADC DMACFG: DMAEN (Bitfield-Mask: 0x01)               */
/* ======================================================  DMATOTCOUNT  ====================================================== */
#define ADC_DMATOTCOUNT_TOTCOUNT_Pos      (2UL)                     /*!< ADC DMATOTCOUNT: TOTCOUNT (Bit 2)                     */
#define ADC_DMATOTCOUNT_TOTCOUNT_Msk      (0x3fffcUL)               /*!< ADC DMATOTCOUNT: TOTCOUNT (Bitfield-Mask: 0xffff)     */
/* ======================================================  DMATARGADDR  ====================================================== */
#define ADC_DMATARGADDR_UTARGADDR_Pos     (20UL)                    /*!< ADC DMATARGADDR: UTARGADDR (Bit 20)                   */
#define ADC_DMATARGADDR_UTARGADDR_Msk     (0xfff00000UL)            /*!< ADC DMATARGADDR: UTARGADDR (Bitfield-Mask: 0xfff)     */
#define ADC_DMATARGADDR_LTARGADDR_Pos     (0UL)                     /*!< ADC DMATARGADDR: LTARGADDR (Bit 0)                    */
#define ADC_DMATARGADDR_LTARGADDR_Msk     (0xfffffUL)               /*!< ADC DMATARGADDR: LTARGADDR (Bitfield-Mask: 0xfffff)   */
/* ========================================================  DMASTAT  ======================================================== */
#define ADC_DMASTAT_DMAERR_Pos            (2UL)                     /*!< ADC DMASTAT: DMAERR (Bit 2)                           */
#define ADC_DMASTAT_DMAERR_Msk            (0x4UL)                   /*!< ADC DMASTAT: DMAERR (Bitfield-Mask: 0x01)             */
#define ADC_DMASTAT_DMACPL_Pos            (1UL)                     /*!< ADC DMASTAT: DMACPL (Bit 1)                           */
#define ADC_DMASTAT_DMACPL_Msk            (0x2UL)                   /*!< ADC DMASTAT: DMACPL (Bitfield-Mask: 0x01)             */
#define ADC_DMASTAT_DMATIP_Pos            (0UL)                     /*!< ADC DMASTAT: DMATIP (Bit 0)                           */
#define ADC_DMASTAT_DMATIP_Msk            (0x1UL)                   /*!< ADC DMASTAT: DMATIP (Bitfield-Mask: 0x01)             */


/* =========================================================================================================================== */
/* ================                                          APBDMA                                           ================ */
/* =========================================================================================================================== */

/* ========================================================  BBVALUE  ======================================================== */
#define APBDMA_BBVALUE_PIN_Pos            (16UL)                    /*!< APBDMA BBVALUE: PIN (Bit 16)                          */
#define APBDMA_BBVALUE_PIN_Msk            (0xff0000UL)              /*!< APBDMA BBVALUE: PIN (Bitfield-Mask: 0xff)             */
#define APBDMA_BBVALUE_DATAOUT_Pos        (0UL)                     /*!< APBDMA BBVALUE: DATAOUT (Bit 0)                       */
#define APBDMA_BBVALUE_DATAOUT_Msk        (0xffUL)                  /*!< APBDMA BBVALUE: DATAOUT (Bitfield-Mask: 0xff)         */
/* ======================================================  BBSETCLEAR  ======================================================= */
#define APBDMA_BBSETCLEAR_CLEAR_Pos       (16UL)                    /*!< APBDMA BBSETCLEAR: CLEAR (Bit 16)                     */
#define APBDMA_BBSETCLEAR_CLEAR_Msk       (0xff0000UL)              /*!< APBDMA BBSETCLEAR: CLEAR (Bitfield-Mask: 0xff)        */
#define APBDMA_BBSETCLEAR_SET_Pos         (0UL)                     /*!< APBDMA BBSETCLEAR: SET (Bit 0)                        */
#define APBDMA_BBSETCLEAR_SET_Msk         (0xffUL)                  /*!< APBDMA BBSETCLEAR: SET (Bitfield-Mask: 0xff)          */
/* ========================================================  BBINPUT  ======================================================== */
#define APBDMA_BBINPUT_DATAIN_Pos         (0UL)                     /*!< APBDMA BBINPUT: DATAIN (Bit 0)                        */
#define APBDMA_BBINPUT_DATAIN_Msk         (0xffUL)                  /*!< APBDMA BBINPUT: DATAIN (Bitfield-Mask: 0xff)          */
/* =======================================================  DEBUGDATA  ======================================================= */
#define APBDMA_DEBUGDATA_DEBUGDATA_Pos    (0UL)                     /*!< APBDMA DEBUGDATA: DEBUGDATA (Bit 0)                   */
#define APBDMA_DEBUGDATA_DEBUGDATA_Msk    (0xffffffffUL)            /*!< APBDMA DEBUGDATA: DEBUGDATA (Bitfield-Mask: 0xffffffff) */
/* =========================================================  DEBUG  ========================================================= */
#define APBDMA_DEBUG_DEBUGEN_Pos          (0UL)                     /*!< APBDMA DEBUG: DEBUGEN (Bit 0)                         */
#define APBDMA_DEBUG_DEBUGEN_Msk          (0xfUL)                   /*!< APBDMA DEBUG: DEBUGEN (Bitfield-Mask: 0x0f)           */


/* =========================================================================================================================== */
/* ================                                           BLEIF                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  FIFO  ========================================================== */
#define BLEIF_FIFO_FIFO_Pos               (0UL)                     /*!< BLEIF FIFO: FIFO (Bit 0)                              */
#define BLEIF_FIFO_FIFO_Msk               (0xffffffffUL)            /*!< BLEIF FIFO: FIFO (Bitfield-Mask: 0xffffffff)          */
/* ========================================================  FIFOPTR  ======================================================== */
#define BLEIF_FIFOPTR_FIFO1REM_Pos        (24UL)                    /*!< BLEIF FIFOPTR: FIFO1REM (Bit 24)                      */
#define BLEIF_FIFOPTR_FIFO1REM_Msk        (0xff000000UL)            /*!< BLEIF FIFOPTR: FIFO1REM (Bitfield-Mask: 0xff)         */
#define BLEIF_FIFOPTR_FIFO1SIZ_Pos        (16UL)                    /*!< BLEIF FIFOPTR: FIFO1SIZ (Bit 16)                      */
#define BLEIF_FIFOPTR_FIFO1SIZ_Msk        (0xff0000UL)              /*!< BLEIF FIFOPTR: FIFO1SIZ (Bitfield-Mask: 0xff)         */
#define BLEIF_FIFOPTR_FIFO0REM_Pos        (8UL)                     /*!< BLEIF FIFOPTR: FIFO0REM (Bit 8)                       */
#define BLEIF_FIFOPTR_FIFO0REM_Msk        (0xff00UL)                /*!< BLEIF FIFOPTR: FIFO0REM (Bitfield-Mask: 0xff)         */
#define BLEIF_FIFOPTR_FIFO0SIZ_Pos        (0UL)                     /*!< BLEIF FIFOPTR: FIFO0SIZ (Bit 0)                       */
#define BLEIF_FIFOPTR_FIFO0SIZ_Msk        (0xffUL)                  /*!< BLEIF FIFOPTR: FIFO0SIZ (Bitfield-Mask: 0xff)         */
/* ========================================================  FIFOTHR  ======================================================== */
#define BLEIF_FIFOTHR_FIFOWTHR_Pos        (8UL)                     /*!< BLEIF FIFOTHR: FIFOWTHR (Bit 8)                       */
#define BLEIF_FIFOTHR_FIFOWTHR_Msk        (0x3f00UL)                /*!< BLEIF FIFOTHR: FIFOWTHR (Bitfield-Mask: 0x3f)         */
#define BLEIF_FIFOTHR_FIFORTHR_Pos        (0UL)                     /*!< BLEIF FIFOTHR: FIFORTHR (Bit 0)                       */
#define BLEIF_FIFOTHR_FIFORTHR_Msk        (0x3fUL)                  /*!< BLEIF FIFOTHR: FIFORTHR (Bitfield-Mask: 0x3f)         */
/* ========================================================  FIFOPOP  ======================================================== */
#define BLEIF_FIFOPOP_FIFODOUT_Pos        (0UL)                     /*!< BLEIF FIFOPOP: FIFODOUT (Bit 0)                       */
#define BLEIF_FIFOPOP_FIFODOUT_Msk        (0xffffffffUL)            /*!< BLEIF FIFOPOP: FIFODOUT (Bitfield-Mask: 0xffffffff)   */
/* =======================================================  FIFOPUSH  ======================================================== */
#define BLEIF_FIFOPUSH_FIFODIN_Pos        (0UL)                     /*!< BLEIF FIFOPUSH: FIFODIN (Bit 0)                       */
#define BLEIF_FIFOPUSH_FIFODIN_Msk        (0xffffffffUL)            /*!< BLEIF FIFOPUSH: FIFODIN (Bitfield-Mask: 0xffffffff)   */
/* =======================================================  FIFOCTRL  ======================================================== */
#define BLEIF_FIFOCTRL_FIFORSTN_Pos       (1UL)                     /*!< BLEIF FIFOCTRL: FIFORSTN (Bit 1)                      */
#define BLEIF_FIFOCTRL_FIFORSTN_Msk       (0x2UL)                   /*!< BLEIF FIFOCTRL: FIFORSTN (Bitfield-Mask: 0x01)        */
#define BLEIF_FIFOCTRL_POPWR_Pos          (0UL)                     /*!< BLEIF FIFOCTRL: POPWR (Bit 0)                         */
#define BLEIF_FIFOCTRL_POPWR_Msk          (0x1UL)                   /*!< BLEIF FIFOCTRL: POPWR (Bitfield-Mask: 0x01)           */
/* ========================================================  FIFOLOC  ======================================================== */
#define BLEIF_FIFOLOC_FIFORPTR_Pos        (8UL)                     /*!< BLEIF FIFOLOC: FIFORPTR (Bit 8)                       */
#define BLEIF_FIFOLOC_FIFORPTR_Msk        (0xf00UL)                 /*!< BLEIF FIFOLOC: FIFORPTR (Bitfield-Mask: 0x0f)         */
#define BLEIF_FIFOLOC_FIFOWPTR_Pos        (0UL)                     /*!< BLEIF FIFOLOC: FIFOWPTR (Bit 0)                       */
#define BLEIF_FIFOLOC_FIFOWPTR_Msk        (0xfUL)                   /*!< BLEIF FIFOLOC: FIFOWPTR (Bitfield-Mask: 0x0f)         */
/* ========================================================  CLKCFG  ========================================================= */
#define BLEIF_CLKCFG_DIV3_Pos             (12UL)                    /*!< BLEIF CLKCFG: DIV3 (Bit 12)                           */
#define BLEIF_CLKCFG_DIV3_Msk             (0x1000UL)                /*!< BLEIF CLKCFG: DIV3 (Bitfield-Mask: 0x01)              */
#define BLEIF_CLKCFG_CLK32KEN_Pos         (11UL)                    /*!< BLEIF CLKCFG: CLK32KEN (Bit 11)                       */
#define BLEIF_CLKCFG_CLK32KEN_Msk         (0x800UL)                 /*!< BLEIF CLKCFG: CLK32KEN (Bitfield-Mask: 0x01)          */
#define BLEIF_CLKCFG_FSEL_Pos             (8UL)                     /*!< BLEIF CLKCFG: FSEL (Bit 8)                            */
#define BLEIF_CLKCFG_FSEL_Msk             (0x700UL)                 /*!< BLEIF CLKCFG: FSEL (Bitfield-Mask: 0x07)              */
#define BLEIF_CLKCFG_IOCLKEN_Pos          (0UL)                     /*!< BLEIF CLKCFG: IOCLKEN (Bit 0)                         */
#define BLEIF_CLKCFG_IOCLKEN_Msk          (0x1UL)                   /*!< BLEIF CLKCFG: IOCLKEN (Bitfield-Mask: 0x01)           */
/* ==========================================================  CMD  ========================================================== */
#define BLEIF_CMD_OFFSETLO_Pos            (24UL)                    /*!< BLEIF CMD: OFFSETLO (Bit 24)                          */
#define BLEIF_CMD_OFFSETLO_Msk            (0xff000000UL)            /*!< BLEIF CMD: OFFSETLO (Bitfield-Mask: 0xff)             */
#define BLEIF_CMD_CMDSEL_Pos              (20UL)                    /*!< BLEIF CMD: CMDSEL (Bit 20)                            */
#define BLEIF_CMD_CMDSEL_Msk              (0x300000UL)              /*!< BLEIF CMD: CMDSEL (Bitfield-Mask: 0x03)               */
#define BLEIF_CMD_TSIZE_Pos               (8UL)                     /*!< BLEIF CMD: TSIZE (Bit 8)                              */
#define BLEIF_CMD_TSIZE_Msk               (0xfff00UL)               /*!< BLEIF CMD: TSIZE (Bitfield-Mask: 0xfff)               */
#define BLEIF_CMD_CONT_Pos                (7UL)                     /*!< BLEIF CMD: CONT (Bit 7)                               */
#define BLEIF_CMD_CONT_Msk                (0x80UL)                  /*!< BLEIF CMD: CONT (Bitfield-Mask: 0x01)                 */
#define BLEIF_CMD_OFFSETCNT_Pos           (5UL)                     /*!< BLEIF CMD: OFFSETCNT (Bit 5)                          */
#define BLEIF_CMD_OFFSETCNT_Msk           (0x60UL)                  /*!< BLEIF CMD: OFFSETCNT (Bitfield-Mask: 0x03)            */
#define BLEIF_CMD_CMD_Pos                 (0UL)                     /*!< BLEIF CMD: CMD (Bit 0)                                */
#define BLEIF_CMD_CMD_Msk                 (0x1fUL)                  /*!< BLEIF CMD: CMD (Bitfield-Mask: 0x1f)                  */
/* ========================================================  CMDRPT  ========================================================= */
#define BLEIF_CMDRPT_CMDRPT_Pos           (0UL)                     /*!< BLEIF CMDRPT: CMDRPT (Bit 0)                          */
#define BLEIF_CMDRPT_CMDRPT_Msk           (0x1fUL)                  /*!< BLEIF CMDRPT: CMDRPT (Bitfield-Mask: 0x1f)            */
/* =======================================================  OFFSETHI  ======================================================== */
#define BLEIF_OFFSETHI_OFFSETHI_Pos       (0UL)                     /*!< BLEIF OFFSETHI: OFFSETHI (Bit 0)                      */
#define BLEIF_OFFSETHI_OFFSETHI_Msk       (0xffffUL)                /*!< BLEIF OFFSETHI: OFFSETHI (Bitfield-Mask: 0xffff)      */
/* ========================================================  CMDSTAT  ======================================================== */
#define BLEIF_CMDSTAT_CTSIZE_Pos          (8UL)                     /*!< BLEIF CMDSTAT: CTSIZE (Bit 8)                         */
#define BLEIF_CMDSTAT_CTSIZE_Msk          (0xfff00UL)               /*!< BLEIF CMDSTAT: CTSIZE (Bitfield-Mask: 0xfff)          */
#define BLEIF_CMDSTAT_CMDSTAT_Pos         (5UL)                     /*!< BLEIF CMDSTAT: CMDSTAT (Bit 5)                        */
#define BLEIF_CMDSTAT_CMDSTAT_Msk         (0xe0UL)                  /*!< BLEIF CMDSTAT: CMDSTAT (Bitfield-Mask: 0x07)          */
#define BLEIF_CMDSTAT_CCMD_Pos            (0UL)                     /*!< BLEIF CMDSTAT: CCMD (Bit 0)                           */
#define BLEIF_CMDSTAT_CCMD_Msk            (0x1fUL)                  /*!< BLEIF CMDSTAT: CCMD (Bitfield-Mask: 0x1f)             */
/* =========================================================  INTEN  ========================================================= */
#define BLEIF_INTEN_B2MSHUTDN_Pos         (16UL)                    /*!< BLEIF INTEN: B2MSHUTDN (Bit 16)                       */
#define BLEIF_INTEN_B2MSHUTDN_Msk         (0x10000UL)               /*!< BLEIF INTEN: B2MSHUTDN (Bitfield-Mask: 0x01)          */
#define BLEIF_INTEN_B2MACTIVE_Pos         (15UL)                    /*!< BLEIF INTEN: B2MACTIVE (Bit 15)                       */
#define BLEIF_INTEN_B2MACTIVE_Msk         (0x8000UL)                /*!< BLEIF INTEN: B2MACTIVE (Bitfield-Mask: 0x01)          */
#define BLEIF_INTEN_B2MSLEEP_Pos          (14UL)                    /*!< BLEIF INTEN: B2MSLEEP (Bit 14)                        */
#define BLEIF_INTEN_B2MSLEEP_Msk          (0x4000UL)                /*!< BLEIF INTEN: B2MSLEEP (Bitfield-Mask: 0x01)           */
#define BLEIF_INTEN_CQERR_Pos             (13UL)                    /*!< BLEIF INTEN: CQERR (Bit 13)                           */
#define BLEIF_INTEN_CQERR_Msk             (0x2000UL)                /*!< BLEIF INTEN: CQERR (Bitfield-Mask: 0x01)              */
#define BLEIF_INTEN_CQUPD_Pos             (12UL)                    /*!< BLEIF INTEN: CQUPD (Bit 12)                           */
#define BLEIF_INTEN_CQUPD_Msk             (0x1000UL)                /*!< BLEIF INTEN: CQUPD (Bitfield-Mask: 0x01)              */
#define BLEIF_INTEN_CQPAUSED_Pos          (11UL)                    /*!< BLEIF INTEN: CQPAUSED (Bit 11)                        */
#define BLEIF_INTEN_CQPAUSED_Msk          (0x800UL)                 /*!< BLEIF INTEN: CQPAUSED (Bitfield-Mask: 0x01)           */
#define BLEIF_INTEN_DERR_Pos              (10UL)                    /*!< BLEIF INTEN: DERR (Bit 10)                            */
#define BLEIF_INTEN_DERR_Msk              (0x400UL)                 /*!< BLEIF INTEN: DERR (Bitfield-Mask: 0x01)               */
#define BLEIF_INTEN_DCMP_Pos              (9UL)                     /*!< BLEIF INTEN: DCMP (Bit 9)                             */
#define BLEIF_INTEN_DCMP_Msk              (0x200UL)                 /*!< BLEIF INTEN: DCMP (Bitfield-Mask: 0x01)               */
#define BLEIF_INTEN_BLECSSTAT_Pos         (8UL)                     /*!< BLEIF INTEN: BLECSSTAT (Bit 8)                        */
#define BLEIF_INTEN_BLECSSTAT_Msk         (0x100UL)                 /*!< BLEIF INTEN: BLECSSTAT (Bitfield-Mask: 0x01)          */
#define BLEIF_INTEN_BLECIRQ_Pos           (7UL)                     /*!< BLEIF INTEN: BLECIRQ (Bit 7)                          */
#define BLEIF_INTEN_BLECIRQ_Msk           (0x80UL)                  /*!< BLEIF INTEN: BLECIRQ (Bitfield-Mask: 0x01)            */
#define BLEIF_INTEN_ICMD_Pos              (6UL)                     /*!< BLEIF INTEN: ICMD (Bit 6)                             */
#define BLEIF_INTEN_ICMD_Msk              (0x40UL)                  /*!< BLEIF INTEN: ICMD (Bitfield-Mask: 0x01)               */
#define BLEIF_INTEN_IACC_Pos              (5UL)                     /*!< BLEIF INTEN: IACC (Bit 5)                             */
#define BLEIF_INTEN_IACC_Msk              (0x20UL)                  /*!< BLEIF INTEN: IACC (Bitfield-Mask: 0x01)               */
#define BLEIF_INTEN_B2MST_Pos             (4UL)                     /*!< BLEIF INTEN: B2MST (Bit 4)                            */
#define BLEIF_INTEN_B2MST_Msk             (0x10UL)                  /*!< BLEIF INTEN: B2MST (Bitfield-Mask: 0x01)              */
#define BLEIF_INTEN_FOVFL_Pos             (3UL)                     /*!< BLEIF INTEN: FOVFL (Bit 3)                            */
#define BLEIF_INTEN_FOVFL_Msk             (0x8UL)                   /*!< BLEIF INTEN: FOVFL (Bitfield-Mask: 0x01)              */
#define BLEIF_INTEN_FUNDFL_Pos            (2UL)                     /*!< BLEIF INTEN: FUNDFL (Bit 2)                           */
#define BLEIF_INTEN_FUNDFL_Msk            (0x4UL)                   /*!< BLEIF INTEN: FUNDFL (Bitfield-Mask: 0x01)             */
#define BLEIF_INTEN_THR_Pos               (1UL)                     /*!< BLEIF INTEN: THR (Bit 1)                              */
#define BLEIF_INTEN_THR_Msk               (0x2UL)                   /*!< BLEIF INTEN: THR (Bitfield-Mask: 0x01)                */
#define BLEIF_INTEN_CMDCMP_Pos            (0UL)                     /*!< BLEIF INTEN: CMDCMP (Bit 0)                           */
#define BLEIF_INTEN_CMDCMP_Msk            (0x1UL)                   /*!< BLEIF INTEN: CMDCMP (Bitfield-Mask: 0x01)             */
/* ========================================================  INTSTAT  ======================================================== */
#define BLEIF_INTSTAT_B2MSHUTDN_Pos       (16UL)                    /*!< BLEIF INTSTAT: B2MSHUTDN (Bit 16)                     */
#define BLEIF_INTSTAT_B2MSHUTDN_Msk       (0x10000UL)               /*!< BLEIF INTSTAT: B2MSHUTDN (Bitfield-Mask: 0x01)        */
#define BLEIF_INTSTAT_B2MACTIVE_Pos       (15UL)                    /*!< BLEIF INTSTAT: B2MACTIVE (Bit 15)                     */
#define BLEIF_INTSTAT_B2MACTIVE_Msk       (0x8000UL)                /*!< BLEIF INTSTAT: B2MACTIVE (Bitfield-Mask: 0x01)        */
#define BLEIF_INTSTAT_B2MSLEEP_Pos        (14UL)                    /*!< BLEIF INTSTAT: B2MSLEEP (Bit 14)                      */
#define BLEIF_INTSTAT_B2MSLEEP_Msk        (0x4000UL)                /*!< BLEIF INTSTAT: B2MSLEEP (Bitfield-Mask: 0x01)         */
#define BLEIF_INTSTAT_CQERR_Pos           (13UL)                    /*!< BLEIF INTSTAT: CQERR (Bit 13)                         */
#define BLEIF_INTSTAT_CQERR_Msk           (0x2000UL)                /*!< BLEIF INTSTAT: CQERR (Bitfield-Mask: 0x01)            */
#define BLEIF_INTSTAT_CQUPD_Pos           (12UL)                    /*!< BLEIF INTSTAT: CQUPD (Bit 12)                         */
#define BLEIF_INTSTAT_CQUPD_Msk           (0x1000UL)                /*!< BLEIF INTSTAT: CQUPD (Bitfield-Mask: 0x01)            */
#define BLEIF_INTSTAT_CQPAUSED_Pos        (11UL)                    /*!< BLEIF INTSTAT: CQPAUSED (Bit 11)                      */
#define BLEIF_INTSTAT_CQPAUSED_Msk        (0x800UL)                 /*!< BLEIF INTSTAT: CQPAUSED (Bitfield-Mask: 0x01)         */
#define BLEIF_INTSTAT_DERR_Pos            (10UL)                    /*!< BLEIF INTSTAT: DERR (Bit 10)                          */
#define BLEIF_INTSTAT_DERR_Msk            (0x400UL)                 /*!< BLEIF INTSTAT: DERR (Bitfield-Mask: 0x01)             */
#define BLEIF_INTSTAT_DCMP_Pos            (9UL)                     /*!< BLEIF INTSTAT: DCMP (Bit 9)                           */
#define BLEIF_INTSTAT_DCMP_Msk            (0x200UL)                 /*!< BLEIF INTSTAT: DCMP (Bitfield-Mask: 0x01)             */
#define BLEIF_INTSTAT_BLECSSTAT_Pos       (8UL)                     /*!< BLEIF INTSTAT: BLECSSTAT (Bit 8)                      */
#define BLEIF_INTSTAT_BLECSSTAT_Msk       (0x100UL)                 /*!< BLEIF INTSTAT: BLECSSTAT (Bitfield-Mask: 0x01)        */
#define BLEIF_INTSTAT_BLECIRQ_Pos         (7UL)                     /*!< BLEIF INTSTAT: BLECIRQ (Bit 7)                        */
#define BLEIF_INTSTAT_BLECIRQ_Msk         (0x80UL)                  /*!< BLEIF INTSTAT: BLECIRQ (Bitfield-Mask: 0x01)          */
#define BLEIF_INTSTAT_ICMD_Pos            (6UL)                     /*!< BLEIF INTSTAT: ICMD (Bit 6)                           */
#define BLEIF_INTSTAT_ICMD_Msk            (0x40UL)                  /*!< BLEIF INTSTAT: ICMD (Bitfield-Mask: 0x01)             */
#define BLEIF_INTSTAT_IACC_Pos            (5UL)                     /*!< BLEIF INTSTAT: IACC (Bit 5)                           */
#define BLEIF_INTSTAT_IACC_Msk            (0x20UL)                  /*!< BLEIF INTSTAT: IACC (Bitfield-Mask: 0x01)             */
#define BLEIF_INTSTAT_B2MST_Pos           (4UL)                     /*!< BLEIF INTSTAT: B2MST (Bit 4)                          */
#define BLEIF_INTSTAT_B2MST_Msk           (0x10UL)                  /*!< BLEIF INTSTAT: B2MST (Bitfield-Mask: 0x01)            */
#define BLEIF_INTSTAT_FOVFL_Pos           (3UL)                     /*!< BLEIF INTSTAT: FOVFL (Bit 3)                          */
#define BLEIF_INTSTAT_FOVFL_Msk           (0x8UL)                   /*!< BLEIF INTSTAT: FOVFL (Bitfield-Mask: 0x01)            */
#define BLEIF_INTSTAT_FUNDFL_Pos          (2UL)                     /*!< BLEIF INTSTAT: FUNDFL (Bit 2)                         */
#define BLEIF_INTSTAT_FUNDFL_Msk          (0x4UL)                   /*!< BLEIF INTSTAT: FUNDFL (Bitfield-Mask: 0x01)           */
#define BLEIF_INTSTAT_THR_Pos             (1UL)                     /*!< BLEIF INTSTAT: THR (Bit 1)                            */
#define BLEIF_INTSTAT_THR_Msk             (0x2UL)                   /*!< BLEIF INTSTAT: THR (Bitfield-Mask: 0x01)              */
#define BLEIF_INTSTAT_CMDCMP_Pos          (0UL)                     /*!< BLEIF INTSTAT: CMDCMP (Bit 0)                         */
#define BLEIF_INTSTAT_CMDCMP_Msk          (0x1UL)                   /*!< BLEIF INTSTAT: CMDCMP (Bitfield-Mask: 0x01)           */
/* ========================================================  INTCLR  ========================================================= */
#define BLEIF_INTCLR_B2MSHUTDN_Pos        (16UL)                    /*!< BLEIF INTCLR: B2MSHUTDN (Bit 16)                      */
#define BLEIF_INTCLR_B2MSHUTDN_Msk        (0x10000UL)               /*!< BLEIF INTCLR: B2MSHUTDN (Bitfield-Mask: 0x01)         */
#define BLEIF_INTCLR_B2MACTIVE_Pos        (15UL)                    /*!< BLEIF INTCLR: B2MACTIVE (Bit 15)                      */
#define BLEIF_INTCLR_B2MACTIVE_Msk        (0x8000UL)                /*!< BLEIF INTCLR: B2MACTIVE (Bitfield-Mask: 0x01)         */
#define BLEIF_INTCLR_B2MSLEEP_Pos         (14UL)                    /*!< BLEIF INTCLR: B2MSLEEP (Bit 14)                       */
#define BLEIF_INTCLR_B2MSLEEP_Msk         (0x4000UL)                /*!< BLEIF INTCLR: B2MSLEEP (Bitfield-Mask: 0x01)          */
#define BLEIF_INTCLR_CQERR_Pos            (13UL)                    /*!< BLEIF INTCLR: CQERR (Bit 13)                          */
#define BLEIF_INTCLR_CQERR_Msk            (0x2000UL)                /*!< BLEIF INTCLR: CQERR (Bitfield-Mask: 0x01)             */
#define BLEIF_INTCLR_CQUPD_Pos            (12UL)                    /*!< BLEIF INTCLR: CQUPD (Bit 12)                          */
#define BLEIF_INTCLR_CQUPD_Msk            (0x1000UL)                /*!< BLEIF INTCLR: CQUPD (Bitfield-Mask: 0x01)             */
#define BLEIF_INTCLR_CQPAUSED_Pos         (11UL)                    /*!< BLEIF INTCLR: CQPAUSED (Bit 11)                       */
#define BLEIF_INTCLR_CQPAUSED_Msk         (0x800UL)                 /*!< BLEIF INTCLR: CQPAUSED (Bitfield-Mask: 0x01)          */
#define BLEIF_INTCLR_DERR_Pos             (10UL)                    /*!< BLEIF INTCLR: DERR (Bit 10)                           */
#define BLEIF_INTCLR_DERR_Msk             (0x400UL)                 /*!< BLEIF INTCLR: DERR (Bitfield-Mask: 0x01)              */
#define BLEIF_INTCLR_DCMP_Pos             (9UL)                     /*!< BLEIF INTCLR: DCMP (Bit 9)                            */
#define BLEIF_INTCLR_DCMP_Msk             (0x200UL)                 /*!< BLEIF INTCLR: DCMP (Bitfield-Mask: 0x01)              */
#define BLEIF_INTCLR_BLECSSTAT_Pos        (8UL)                     /*!< BLEIF INTCLR: BLECSSTAT (Bit 8)                       */
#define BLEIF_INTCLR_BLECSSTAT_Msk        (0x100UL)                 /*!< BLEIF INTCLR: BLECSSTAT (Bitfield-Mask: 0x01)         */
#define BLEIF_INTCLR_BLECIRQ_Pos          (7UL)                     /*!< BLEIF INTCLR: BLECIRQ (Bit 7)                         */
#define BLEIF_INTCLR_BLECIRQ_Msk          (0x80UL)                  /*!< BLEIF INTCLR: BLECIRQ (Bitfield-Mask: 0x01)           */
#define BLEIF_INTCLR_ICMD_Pos             (6UL)                     /*!< BLEIF INTCLR: ICMD (Bit 6)                            */
#define BLEIF_INTCLR_ICMD_Msk             (0x40UL)                  /*!< BLEIF INTCLR: ICMD (Bitfield-Mask: 0x01)              */
#define BLEIF_INTCLR_IACC_Pos             (5UL)                     /*!< BLEIF INTCLR: IACC (Bit 5)                            */
#define BLEIF_INTCLR_IACC_Msk             (0x20UL)                  /*!< BLEIF INTCLR: IACC (Bitfield-Mask: 0x01)              */
#define BLEIF_INTCLR_B2MST_Pos            (4UL)                     /*!< BLEIF INTCLR: B2MST (Bit 4)                           */
#define BLEIF_INTCLR_B2MST_Msk            (0x10UL)                  /*!< BLEIF INTCLR: B2MST (Bitfield-Mask: 0x01)             */
#define BLEIF_INTCLR_FOVFL_Pos            (3UL)                     /*!< BLEIF INTCLR: FOVFL (Bit 3)                           */
#define BLEIF_INTCLR_FOVFL_Msk            (0x8UL)                   /*!< BLEIF INTCLR: FOVFL (Bitfield-Mask: 0x01)             */
#define BLEIF_INTCLR_FUNDFL_Pos           (2UL)                     /*!< BLEIF INTCLR: FUNDFL (Bit 2)                          */
#define BLEIF_INTCLR_FUNDFL_Msk           (0x4UL)                   /*!< BLEIF INTCLR: FUNDFL (Bitfield-Mask: 0x01)            */
#define BLEIF_INTCLR_THR_Pos              (1UL)                     /*!< BLEIF INTCLR: THR (Bit 1)                             */
#define BLEIF_INTCLR_THR_Msk              (0x2UL)                   /*!< BLEIF INTCLR: THR (Bitfield-Mask: 0x01)               */
#define BLEIF_INTCLR_CMDCMP_Pos           (0UL)                     /*!< BLEIF INTCLR: CMDCMP (Bit 0)                          */
#define BLEIF_INTCLR_CMDCMP_Msk           (0x1UL)                   /*!< BLEIF INTCLR: CMDCMP (Bitfield-Mask: 0x01)            */
/* ========================================================  INTSET  ========================================================= */
#define BLEIF_INTSET_B2MSHUTDN_Pos        (16UL)                    /*!< BLEIF INTSET: B2MSHUTDN (Bit 16)                      */
#define BLEIF_INTSET_B2MSHUTDN_Msk        (0x10000UL)               /*!< BLEIF INTSET: B2MSHUTDN (Bitfield-Mask: 0x01)         */
#define BLEIF_INTSET_B2MACTIVE_Pos        (15UL)                    /*!< BLEIF INTSET: B2MACTIVE (Bit 15)                      */
#define BLEIF_INTSET_B2MACTIVE_Msk        (0x8000UL)                /*!< BLEIF INTSET: B2MACTIVE (Bitfield-Mask: 0x01)         */
#define BLEIF_INTSET_B2MSLEEP_Pos         (14UL)                    /*!< BLEIF INTSET: B2MSLEEP (Bit 14)                       */
#define BLEIF_INTSET_B2MSLEEP_Msk         (0x4000UL)                /*!< BLEIF INTSET: B2MSLEEP (Bitfield-Mask: 0x01)          */
#define BLEIF_INTSET_CQERR_Pos            (13UL)                    /*!< BLEIF INTSET: CQERR (Bit 13)                          */
#define BLEIF_INTSET_CQERR_Msk            (0x2000UL)                /*!< BLEIF INTSET: CQERR (Bitfield-Mask: 0x01)             */
#define BLEIF_INTSET_CQUPD_Pos            (12UL)                    /*!< BLEIF INTSET: CQUPD (Bit 12)                          */
#define BLEIF_INTSET_CQUPD_Msk            (0x1000UL)                /*!< BLEIF INTSET: CQUPD (Bitfield-Mask: 0x01)             */
#define BLEIF_INTSET_CQPAUSED_Pos         (11UL)                    /*!< BLEIF INTSET: CQPAUSED (Bit 11)                       */
#define BLEIF_INTSET_CQPAUSED_Msk         (0x800UL)                 /*!< BLEIF INTSET: CQPAUSED (Bitfield-Mask: 0x01)          */
#define BLEIF_INTSET_DERR_Pos             (10UL)                    /*!< BLEIF INTSET: DERR (Bit 10)                           */
#define BLEIF_INTSET_DERR_Msk             (0x400UL)                 /*!< BLEIF INTSET: DERR (Bitfield-Mask: 0x01)              */
#define BLEIF_INTSET_DCMP_Pos             (9UL)                     /*!< BLEIF INTSET: DCMP (Bit 9)                            */
#define BLEIF_INTSET_DCMP_Msk             (0x200UL)                 /*!< BLEIF INTSET: DCMP (Bitfield-Mask: 0x01)              */
#define BLEIF_INTSET_BLECSSTAT_Pos        (8UL)                     /*!< BLEIF INTSET: BLECSSTAT (Bit 8)                       */
#define BLEIF_INTSET_BLECSSTAT_Msk        (0x100UL)                 /*!< BLEIF INTSET: BLECSSTAT (Bitfield-Mask: 0x01)         */
#define BLEIF_INTSET_BLECIRQ_Pos          (7UL)                     /*!< BLEIF INTSET: BLECIRQ (Bit 7)                         */
#define BLEIF_INTSET_BLECIRQ_Msk          (0x80UL)                  /*!< BLEIF INTSET: BLECIRQ (Bitfield-Mask: 0x01)           */
#define BLEIF_INTSET_ICMD_Pos             (6UL)                     /*!< BLEIF INTSET: ICMD (Bit 6)                            */
#define BLEIF_INTSET_ICMD_Msk             (0x40UL)                  /*!< BLEIF INTSET: ICMD (Bitfield-Mask: 0x01)              */
#define BLEIF_INTSET_IACC_Pos             (5UL)                     /*!< BLEIF INTSET: IACC (Bit 5)                            */
#define BLEIF_INTSET_IACC_Msk             (0x20UL)                  /*!< BLEIF INTSET: IACC (Bitfield-Mask: 0x01)              */
#define BLEIF_INTSET_B2MST_Pos            (4UL)                     /*!< BLEIF INTSET: B2MST (Bit 4)                           */
#define BLEIF_INTSET_B2MST_Msk            (0x10UL)                  /*!< BLEIF INTSET: B2MST (Bitfield-Mask: 0x01)             */
#define BLEIF_INTSET_FOVFL_Pos            (3UL)                     /*!< BLEIF INTSET: FOVFL (Bit 3)                           */
#define BLEIF_INTSET_FOVFL_Msk            (0x8UL)                   /*!< BLEIF INTSET: FOVFL (Bitfield-Mask: 0x01)             */
#define BLEIF_INTSET_FUNDFL_Pos           (2UL)                     /*!< BLEIF INTSET: FUNDFL (Bit 2)                          */
#define BLEIF_INTSET_FUNDFL_Msk           (0x4UL)                   /*!< BLEIF INTSET: FUNDFL (Bitfield-Mask: 0x01)            */
#define BLEIF_INTSET_THR_Pos              (1UL)                     /*!< BLEIF INTSET: THR (Bit 1)                             */
#define BLEIF_INTSET_THR_Msk              (0x2UL)                   /*!< BLEIF INTSET: THR (Bitfield-Mask: 0x01)               */
#define BLEIF_INTSET_CMDCMP_Pos           (0UL)                     /*!< BLEIF INTSET: CMDCMP (Bit 0)                          */
#define BLEIF_INTSET_CMDCMP_Msk           (0x1UL)                   /*!< BLEIF INTSET: CMDCMP (Bitfield-Mask: 0x01)            */
/* =======================================================  DMATRIGEN  ======================================================= */
#define BLEIF_DMATRIGEN_DTHREN_Pos        (1UL)                     /*!< BLEIF DMATRIGEN: DTHREN (Bit 1)                       */
#define BLEIF_DMATRIGEN_DTHREN_Msk        (0x2UL)                   /*!< BLEIF DMATRIGEN: DTHREN (Bitfield-Mask: 0x01)         */
#define BLEIF_DMATRIGEN_DCMDCMPEN_Pos     (0UL)                     /*!< BLEIF DMATRIGEN: DCMDCMPEN (Bit 0)                    */
#define BLEIF_DMATRIGEN_DCMDCMPEN_Msk     (0x1UL)                   /*!< BLEIF DMATRIGEN: DCMDCMPEN (Bitfield-Mask: 0x01)      */
/* ======================================================  DMATRIGSTAT  ====================================================== */
#define BLEIF_DMATRIGSTAT_DTOTCMP_Pos     (2UL)                     /*!< BLEIF DMATRIGSTAT: DTOTCMP (Bit 2)                    */
#define BLEIF_DMATRIGSTAT_DTOTCMP_Msk     (0x4UL)                   /*!< BLEIF DMATRIGSTAT: DTOTCMP (Bitfield-Mask: 0x01)      */
#define BLEIF_DMATRIGSTAT_DTHR_Pos        (1UL)                     /*!< BLEIF DMATRIGSTAT: DTHR (Bit 1)                       */
#define BLEIF_DMATRIGSTAT_DTHR_Msk        (0x2UL)                   /*!< BLEIF DMATRIGSTAT: DTHR (Bitfield-Mask: 0x01)         */
#define BLEIF_DMATRIGSTAT_DCMDCMP_Pos     (0UL)                     /*!< BLEIF DMATRIGSTAT: DCMDCMP (Bit 0)                    */
#define BLEIF_DMATRIGSTAT_DCMDCMP_Msk     (0x1UL)                   /*!< BLEIF DMATRIGSTAT: DCMDCMP (Bitfield-Mask: 0x01)      */
/* ========================================================  DMACFG  ========================================================= */
#define BLEIF_DMACFG_DMAPRI_Pos           (8UL)                     /*!< BLEIF DMACFG: DMAPRI (Bit 8)                          */
#define BLEIF_DMACFG_DMAPRI_Msk           (0x100UL)                 /*!< BLEIF DMACFG: DMAPRI (Bitfield-Mask: 0x01)            */
#define BLEIF_DMACFG_DMADIR_Pos           (1UL)                     /*!< BLEIF DMACFG: DMADIR (Bit 1)                          */
#define BLEIF_DMACFG_DMADIR_Msk           (0x2UL)                   /*!< BLEIF DMACFG: DMADIR (Bitfield-Mask: 0x01)            */
#define BLEIF_DMACFG_DMAEN_Pos            (0UL)                     /*!< BLEIF DMACFG: DMAEN (Bit 0)                           */
#define BLEIF_DMACFG_DMAEN_Msk            (0x1UL)                   /*!< BLEIF DMACFG: DMAEN (Bitfield-Mask: 0x01)             */
/* ======================================================  DMATOTCOUNT  ====================================================== */
#define BLEIF_DMATOTCOUNT_TOTCOUNT_Pos    (0UL)                     /*!< BLEIF DMATOTCOUNT: TOTCOUNT (Bit 0)                   */
#define BLEIF_DMATOTCOUNT_TOTCOUNT_Msk    (0xfffUL)                 /*!< BLEIF DMATOTCOUNT: TOTCOUNT (Bitfield-Mask: 0xfff)    */
/* ======================================================  DMATARGADDR  ====================================================== */
#define BLEIF_DMATARGADDR_TARGADDR28_Pos  (28UL)                    /*!< BLEIF DMATARGADDR: TARGADDR28 (Bit 28)                */
#define BLEIF_DMATARGADDR_TARGADDR28_Msk  (0x10000000UL)            /*!< BLEIF DMATARGADDR: TARGADDR28 (Bitfield-Mask: 0x01)   */
#define BLEIF_DMATARGADDR_TARGADDR_Pos    (0UL)                     /*!< BLEIF DMATARGADDR: TARGADDR (Bit 0)                   */
#define BLEIF_DMATARGADDR_TARGADDR_Msk    (0x1fffffUL)              /*!< BLEIF DMATARGADDR: TARGADDR (Bitfield-Mask: 0x1fffff) */
/* ========================================================  DMASTAT  ======================================================== */
#define BLEIF_DMASTAT_DMAERR_Pos          (2UL)                     /*!< BLEIF DMASTAT: DMAERR (Bit 2)                         */
#define BLEIF_DMASTAT_DMAERR_Msk          (0x4UL)                   /*!< BLEIF DMASTAT: DMAERR (Bitfield-Mask: 0x01)           */
#define BLEIF_DMASTAT_DMACPL_Pos          (1UL)                     /*!< BLEIF DMASTAT: DMACPL (Bit 1)                         */
#define BLEIF_DMASTAT_DMACPL_Msk          (0x2UL)                   /*!< BLEIF DMASTAT: DMACPL (Bitfield-Mask: 0x01)           */
#define BLEIF_DMASTAT_DMATIP_Pos          (0UL)                     /*!< BLEIF DMASTAT: DMATIP (Bit 0)                         */
#define BLEIF_DMASTAT_DMATIP_Msk          (0x1UL)                   /*!< BLEIF DMASTAT: DMATIP (Bitfield-Mask: 0x01)           */
/* =========================================================  CQCFG  ========================================================= */
#define BLEIF_CQCFG_CQPRI_Pos             (1UL)                     /*!< BLEIF CQCFG: CQPRI (Bit 1)                            */
#define BLEIF_CQCFG_CQPRI_Msk             (0x2UL)                   /*!< BLEIF CQCFG: CQPRI (Bitfield-Mask: 0x01)              */
#define BLEIF_CQCFG_CQEN_Pos              (0UL)                     /*!< BLEIF CQCFG: CQEN (Bit 0)                             */
#define BLEIF_CQCFG_CQEN_Msk              (0x1UL)                   /*!< BLEIF CQCFG: CQEN (Bitfield-Mask: 0x01)               */
/* ========================================================  CQADDR  ========================================================= */
#define BLEIF_CQADDR_CQADDR28_Pos         (28UL)                    /*!< BLEIF CQADDR: CQADDR28 (Bit 28)                       */
#define BLEIF_CQADDR_CQADDR28_Msk         (0x10000000UL)            /*!< BLEIF CQADDR: CQADDR28 (Bitfield-Mask: 0x01)          */
#define BLEIF_CQADDR_CQADDR_Pos           (2UL)                     /*!< BLEIF CQADDR: CQADDR (Bit 2)                          */
#define BLEIF_CQADDR_CQADDR_Msk           (0x1ffffcUL)              /*!< BLEIF CQADDR: CQADDR (Bitfield-Mask: 0x7ffff)         */
/* ========================================================  CQSTAT  ========================================================= */
#define BLEIF_CQSTAT_CQERR_Pos            (2UL)                     /*!< BLEIF CQSTAT: CQERR (Bit 2)                           */
#define BLEIF_CQSTAT_CQERR_Msk            (0x4UL)                   /*!< BLEIF CQSTAT: CQERR (Bitfield-Mask: 0x01)             */
#define BLEIF_CQSTAT_CQPAUSED_Pos         (1UL)                     /*!< BLEIF CQSTAT: CQPAUSED (Bit 1)                        */
#define BLEIF_CQSTAT_CQPAUSED_Msk         (0x2UL)                   /*!< BLEIF CQSTAT: CQPAUSED (Bitfield-Mask: 0x01)          */
#define BLEIF_CQSTAT_CQTIP_Pos            (0UL)                     /*!< BLEIF CQSTAT: CQTIP (Bit 0)                           */
#define BLEIF_CQSTAT_CQTIP_Msk            (0x1UL)                   /*!< BLEIF CQSTAT: CQTIP (Bitfield-Mask: 0x01)             */
/* ========================================================  CQFLAGS  ======================================================== */
#define BLEIF_CQFLAGS_CQIRQMASK_Pos       (16UL)                    /*!< BLEIF CQFLAGS: CQIRQMASK (Bit 16)                     */
#define BLEIF_CQFLAGS_CQIRQMASK_Msk       (0xffff0000UL)            /*!< BLEIF CQFLAGS: CQIRQMASK (Bitfield-Mask: 0xffff)      */
#define BLEIF_CQFLAGS_CQFLAGS_Pos         (0UL)                     /*!< BLEIF CQFLAGS: CQFLAGS (Bit 0)                        */
#define BLEIF_CQFLAGS_CQFLAGS_Msk         (0xffffUL)                /*!< BLEIF CQFLAGS: CQFLAGS (Bitfield-Mask: 0xffff)        */
/* ======================================================  CQSETCLEAR  ======================================================= */
#define BLEIF_CQSETCLEAR_CQFCLR_Pos       (16UL)                    /*!< BLEIF CQSETCLEAR: CQFCLR (Bit 16)                     */
#define BLEIF_CQSETCLEAR_CQFCLR_Msk       (0xff0000UL)              /*!< BLEIF CQSETCLEAR: CQFCLR (Bitfield-Mask: 0xff)        */
#define BLEIF_CQSETCLEAR_CQFTGL_Pos       (8UL)                     /*!< BLEIF CQSETCLEAR: CQFTGL (Bit 8)                      */
#define BLEIF_CQSETCLEAR_CQFTGL_Msk       (0xff00UL)                /*!< BLEIF CQSETCLEAR: CQFTGL (Bitfield-Mask: 0xff)        */
#define BLEIF_CQSETCLEAR_CQFSET_Pos       (0UL)                     /*!< BLEIF CQSETCLEAR: CQFSET (Bit 0)                      */
#define BLEIF_CQSETCLEAR_CQFSET_Msk       (0xffUL)                  /*!< BLEIF CQSETCLEAR: CQFSET (Bitfield-Mask: 0xff)        */
/* =======================================================  CQPAUSEEN  ======================================================= */
#define BLEIF_CQPAUSEEN_CQPEN_Pos         (0UL)                     /*!< BLEIF CQPAUSEEN: CQPEN (Bit 0)                        */
#define BLEIF_CQPAUSEEN_CQPEN_Msk         (0xffffUL)                /*!< BLEIF CQPAUSEEN: CQPEN (Bitfield-Mask: 0xffff)        */
/* =======================================================  CQCURIDX  ======================================================== */
#define BLEIF_CQCURIDX_CQCURIDX_Pos       (0UL)                     /*!< BLEIF CQCURIDX: CQCURIDX (Bit 0)                      */
#define BLEIF_CQCURIDX_CQCURIDX_Msk       (0xffUL)                  /*!< BLEIF CQCURIDX: CQCURIDX (Bitfield-Mask: 0xff)        */
/* =======================================================  CQENDIDX  ======================================================== */
#define BLEIF_CQENDIDX_CQENDIDX_Pos       (0UL)                     /*!< BLEIF CQENDIDX: CQENDIDX (Bit 0)                      */
#define BLEIF_CQENDIDX_CQENDIDX_Msk       (0xffUL)                  /*!< BLEIF CQENDIDX: CQENDIDX (Bitfield-Mask: 0xff)        */
/* ========================================================  STATUS  ========================================================= */
#define BLEIF_STATUS_IDLEST_Pos           (2UL)                     /*!< BLEIF STATUS: IDLEST (Bit 2)                          */
#define BLEIF_STATUS_IDLEST_Msk           (0x4UL)                   /*!< BLEIF STATUS: IDLEST (Bitfield-Mask: 0x01)            */
#define BLEIF_STATUS_CMDACT_Pos           (1UL)                     /*!< BLEIF STATUS: CMDACT (Bit 1)                          */
#define BLEIF_STATUS_CMDACT_Msk           (0x2UL)                   /*!< BLEIF STATUS: CMDACT (Bitfield-Mask: 0x01)            */
#define BLEIF_STATUS_ERR_Pos              (0UL)                     /*!< BLEIF STATUS: ERR (Bit 0)                             */
#define BLEIF_STATUS_ERR_Msk              (0x1UL)                   /*!< BLEIF STATUS: ERR (Bitfield-Mask: 0x01)               */
/* ========================================================  MSPICFG  ======================================================== */
#define BLEIF_MSPICFG_MSPIRST_Pos         (30UL)                    /*!< BLEIF MSPICFG: MSPIRST (Bit 30)                       */
#define BLEIF_MSPICFG_MSPIRST_Msk         (0x40000000UL)            /*!< BLEIF MSPICFG: MSPIRST (Bitfield-Mask: 0x01)          */
#define BLEIF_MSPICFG_DOUTDLY_Pos         (27UL)                    /*!< BLEIF MSPICFG: DOUTDLY (Bit 27)                       */
#define BLEIF_MSPICFG_DOUTDLY_Msk         (0x38000000UL)            /*!< BLEIF MSPICFG: DOUTDLY (Bitfield-Mask: 0x07)          */
#define BLEIF_MSPICFG_DINDLY_Pos          (24UL)                    /*!< BLEIF MSPICFG: DINDLY (Bit 24)                        */
#define BLEIF_MSPICFG_DINDLY_Msk          (0x7000000UL)             /*!< BLEIF MSPICFG: DINDLY (Bitfield-Mask: 0x07)           */
#define BLEIF_MSPICFG_SPILSB_Pos          (23UL)                    /*!< BLEIF MSPICFG: SPILSB (Bit 23)                        */
#define BLEIF_MSPICFG_SPILSB_Msk          (0x800000UL)              /*!< BLEIF MSPICFG: SPILSB (Bitfield-Mask: 0x01)           */
#define BLEIF_MSPICFG_RDFCPOL_Pos         (22UL)                    /*!< BLEIF MSPICFG: RDFCPOL (Bit 22)                       */
#define BLEIF_MSPICFG_RDFCPOL_Msk         (0x400000UL)              /*!< BLEIF MSPICFG: RDFCPOL (Bitfield-Mask: 0x01)          */
#define BLEIF_MSPICFG_WTFCPOL_Pos         (21UL)                    /*!< BLEIF MSPICFG: WTFCPOL (Bit 21)                       */
#define BLEIF_MSPICFG_WTFCPOL_Msk         (0x200000UL)              /*!< BLEIF MSPICFG: WTFCPOL (Bitfield-Mask: 0x01)          */
#define BLEIF_MSPICFG_RDFC_Pos            (17UL)                    /*!< BLEIF MSPICFG: RDFC (Bit 17)                          */
#define BLEIF_MSPICFG_RDFC_Msk            (0x20000UL)               /*!< BLEIF MSPICFG: RDFC (Bitfield-Mask: 0x01)             */
#define BLEIF_MSPICFG_WTFC_Pos            (16UL)                    /*!< BLEIF MSPICFG: WTFC (Bit 16)                          */
#define BLEIF_MSPICFG_WTFC_Msk            (0x10000UL)               /*!< BLEIF MSPICFG: WTFC (Bitfield-Mask: 0x01)             */
#define BLEIF_MSPICFG_FULLDUP_Pos         (2UL)                     /*!< BLEIF MSPICFG: FULLDUP (Bit 2)                        */
#define BLEIF_MSPICFG_FULLDUP_Msk         (0x4UL)                   /*!< BLEIF MSPICFG: FULLDUP (Bitfield-Mask: 0x01)          */
#define BLEIF_MSPICFG_SPHA_Pos            (1UL)                     /*!< BLEIF MSPICFG: SPHA (Bit 1)                           */
#define BLEIF_MSPICFG_SPHA_Msk            (0x2UL)                   /*!< BLEIF MSPICFG: SPHA (Bitfield-Mask: 0x01)             */
#define BLEIF_MSPICFG_SPOL_Pos            (0UL)                     /*!< BLEIF MSPICFG: SPOL (Bit 0)                           */
#define BLEIF_MSPICFG_SPOL_Msk            (0x1UL)                   /*!< BLEIF MSPICFG: SPOL (Bitfield-Mask: 0x01)             */
/* ========================================================  BLECFG  ========================================================= */
#define BLEIF_BLECFG_SPIISOCTL_Pos        (14UL)                    /*!< BLEIF BLECFG: SPIISOCTL (Bit 14)                      */
#define BLEIF_BLECFG_SPIISOCTL_Msk        (0xc000UL)                /*!< BLEIF BLECFG: SPIISOCTL (Bitfield-Mask: 0x03)         */
#define BLEIF_BLECFG_PWRISOCTL_Pos        (12UL)                    /*!< BLEIF BLECFG: PWRISOCTL (Bit 12)                      */
#define BLEIF_BLECFG_PWRISOCTL_Msk        (0x3000UL)                /*!< BLEIF BLECFG: PWRISOCTL (Bitfield-Mask: 0x03)         */
#define BLEIF_BLECFG_STAYASLEEP_Pos       (11UL)                    /*!< BLEIF BLECFG: STAYASLEEP (Bit 11)                     */
#define BLEIF_BLECFG_STAYASLEEP_Msk       (0x800UL)                 /*!< BLEIF BLECFG: STAYASLEEP (Bitfield-Mask: 0x01)        */
#define BLEIF_BLECFG_FRCCLK_Pos           (10UL)                    /*!< BLEIF BLECFG: FRCCLK (Bit 10)                         */
#define BLEIF_BLECFG_FRCCLK_Msk           (0x400UL)                 /*!< BLEIF BLECFG: FRCCLK (Bitfield-Mask: 0x01)            */
#define BLEIF_BLECFG_MCUFRCSLP_Pos        (9UL)                     /*!< BLEIF BLECFG: MCUFRCSLP (Bit 9)                       */
#define BLEIF_BLECFG_MCUFRCSLP_Msk        (0x200UL)                 /*!< BLEIF BLECFG: MCUFRCSLP (Bitfield-Mask: 0x01)         */
#define BLEIF_BLECFG_WT4ACTOFF_Pos        (8UL)                     /*!< BLEIF BLECFG: WT4ACTOFF (Bit 8)                       */
#define BLEIF_BLECFG_WT4ACTOFF_Msk        (0x100UL)                 /*!< BLEIF BLECFG: WT4ACTOFF (Bitfield-Mask: 0x01)         */
#define BLEIF_BLECFG_BLEHREQCTL_Pos       (6UL)                     /*!< BLEIF BLECFG: BLEHREQCTL (Bit 6)                      */
#define BLEIF_BLECFG_BLEHREQCTL_Msk       (0xc0UL)                  /*!< BLEIF BLECFG: BLEHREQCTL (Bitfield-Mask: 0x03)        */
#define BLEIF_BLECFG_DCDCFLGCTL_Pos       (4UL)                     /*!< BLEIF BLECFG: DCDCFLGCTL (Bit 4)                      */
#define BLEIF_BLECFG_DCDCFLGCTL_Msk       (0x30UL)                  /*!< BLEIF BLECFG: DCDCFLGCTL (Bitfield-Mask: 0x03)        */
#define BLEIF_BLECFG_WAKEUPCTL_Pos        (2UL)                     /*!< BLEIF BLECFG: WAKEUPCTL (Bit 2)                       */
#define BLEIF_BLECFG_WAKEUPCTL_Msk        (0xcUL)                   /*!< BLEIF BLECFG: WAKEUPCTL (Bitfield-Mask: 0x03)         */
#define BLEIF_BLECFG_BLERSTN_Pos          (1UL)                     /*!< BLEIF BLECFG: BLERSTN (Bit 1)                         */
#define BLEIF_BLECFG_BLERSTN_Msk          (0x2UL)                   /*!< BLEIF BLECFG: BLERSTN (Bitfield-Mask: 0x01)           */
#define BLEIF_BLECFG_PWRSMEN_Pos          (0UL)                     /*!< BLEIF BLECFG: PWRSMEN (Bit 0)                         */
#define BLEIF_BLECFG_PWRSMEN_Msk          (0x1UL)                   /*!< BLEIF BLECFG: PWRSMEN (Bitfield-Mask: 0x01)           */
/* ========================================================  PWRCMD  ========================================================= */
#define BLEIF_PWRCMD_RESTART_Pos          (1UL)                     /*!< BLEIF PWRCMD: RESTART (Bit 1)                         */
#define BLEIF_PWRCMD_RESTART_Msk          (0x2UL)                   /*!< BLEIF PWRCMD: RESTART (Bitfield-Mask: 0x01)           */
#define BLEIF_PWRCMD_WAKEREQ_Pos          (0UL)                     /*!< BLEIF PWRCMD: WAKEREQ (Bit 0)                         */
#define BLEIF_PWRCMD_WAKEREQ_Msk          (0x1UL)                   /*!< BLEIF PWRCMD: WAKEREQ (Bitfield-Mask: 0x01)           */
/* ========================================================  BSTATUS  ======================================================== */
#define BLEIF_BSTATUS_BLEHREQ_Pos         (12UL)                    /*!< BLEIF BSTATUS: BLEHREQ (Bit 12)                       */
#define BLEIF_BSTATUS_BLEHREQ_Msk         (0x1000UL)                /*!< BLEIF BSTATUS: BLEHREQ (Bitfield-Mask: 0x01)          */
#define BLEIF_BSTATUS_BLEHACK_Pos         (11UL)                    /*!< BLEIF BSTATUS: BLEHACK (Bit 11)                       */
#define BLEIF_BSTATUS_BLEHACK_Msk         (0x800UL)                 /*!< BLEIF BSTATUS: BLEHACK (Bitfield-Mask: 0x01)          */
#define BLEIF_BSTATUS_PWRST_Pos           (8UL)                     /*!< BLEIF BSTATUS: PWRST (Bit 8)                          */
#define BLEIF_BSTATUS_PWRST_Msk           (0x700UL)                 /*!< BLEIF BSTATUS: PWRST (Bitfield-Mask: 0x07)            */
#define BLEIF_BSTATUS_BLEIRQ_Pos          (7UL)                     /*!< BLEIF BSTATUS: BLEIRQ (Bit 7)                         */
#define BLEIF_BSTATUS_BLEIRQ_Msk          (0x80UL)                  /*!< BLEIF BSTATUS: BLEIRQ (Bitfield-Mask: 0x01)           */
#define BLEIF_BSTATUS_WAKEUP_Pos          (6UL)                     /*!< BLEIF BSTATUS: WAKEUP (Bit 6)                         */
#define BLEIF_BSTATUS_WAKEUP_Msk          (0x40UL)                  /*!< BLEIF BSTATUS: WAKEUP (Bitfield-Mask: 0x01)           */
#define BLEIF_BSTATUS_DCDCFLAG_Pos        (5UL)                     /*!< BLEIF BSTATUS: DCDCFLAG (Bit 5)                       */
#define BLEIF_BSTATUS_DCDCFLAG_Msk        (0x20UL)                  /*!< BLEIF BSTATUS: DCDCFLAG (Bitfield-Mask: 0x01)         */
#define BLEIF_BSTATUS_DCDCREQ_Pos         (4UL)                     /*!< BLEIF BSTATUS: DCDCREQ (Bit 4)                        */
#define BLEIF_BSTATUS_DCDCREQ_Msk         (0x10UL)                  /*!< BLEIF BSTATUS: DCDCREQ (Bitfield-Mask: 0x01)          */
#define BLEIF_BSTATUS_SPISTATUS_Pos       (3UL)                     /*!< BLEIF BSTATUS: SPISTATUS (Bit 3)                      */
#define BLEIF_BSTATUS_SPISTATUS_Msk       (0x8UL)                   /*!< BLEIF BSTATUS: SPISTATUS (Bitfield-Mask: 0x01)        */
#define BLEIF_BSTATUS_B2MSTATE_Pos        (0UL)                     /*!< BLEIF BSTATUS: B2MSTATE (Bit 0)                       */
#define BLEIF_BSTATUS_B2MSTATE_Msk        (0x7UL)                   /*!< BLEIF BSTATUS: B2MSTATE (Bitfield-Mask: 0x07)         */
/* ========================================================  BLEDBG  ========================================================= */
#define BLEIF_BLEDBG_DBGDATA_Pos          (3UL)                     /*!< BLEIF BLEDBG: DBGDATA (Bit 3)                         */
#define BLEIF_BLEDBG_DBGDATA_Msk          (0xfffffff8UL)            /*!< BLEIF BLEDBG: DBGDATA (Bitfield-Mask: 0x1fffffff)     */
#define BLEIF_BLEDBG_APBCLKON_Pos         (2UL)                     /*!< BLEIF BLEDBG: APBCLKON (Bit 2)                        */
#define BLEIF_BLEDBG_APBCLKON_Msk         (0x4UL)                   /*!< BLEIF BLEDBG: APBCLKON (Bitfield-Mask: 0x01)          */
#define BLEIF_BLEDBG_IOCLKON_Pos          (1UL)                     /*!< BLEIF BLEDBG: IOCLKON (Bit 1)                         */
#define BLEIF_BLEDBG_IOCLKON_Msk          (0x2UL)                   /*!< BLEIF BLEDBG: IOCLKON (Bitfield-Mask: 0x01)           */
#define BLEIF_BLEDBG_DBGEN_Pos            (0UL)                     /*!< BLEIF BLEDBG: DBGEN (Bit 0)                           */
#define BLEIF_BLEDBG_DBGEN_Msk            (0x1UL)                   /*!< BLEIF BLEDBG: DBGEN (Bitfield-Mask: 0x01)             */


/* =========================================================================================================================== */
/* ================                                         CACHECTRL                                         ================ */
/* =========================================================================================================================== */

/* =======================================================  CACHECFG  ======================================================== */
#define CACHECTRL_CACHECFG_ENABLE_MONITOR_Pos (24UL)                /*!< CACHECTRL CACHECFG: ENABLE_MONITOR (Bit 24)           */
#define CACHECTRL_CACHECFG_ENABLE_MONITOR_Msk (0x1000000UL)         /*!< CACHECTRL CACHECFG: ENABLE_MONITOR (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECFG_DATA_CLKGATE_Pos (20UL)                  /*!< CACHECTRL CACHECFG: DATA_CLKGATE (Bit 20)             */
#define CACHECTRL_CACHECFG_DATA_CLKGATE_Msk (0x100000UL)            /*!< CACHECTRL CACHECFG: DATA_CLKGATE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECFG_CACHE_LS_Pos   (11UL)                    /*!< CACHECTRL CACHECFG: CACHE_LS (Bit 11)                 */
#define CACHECTRL_CACHECFG_CACHE_LS_Msk   (0x800UL)                 /*!< CACHECTRL CACHECFG: CACHE_LS (Bitfield-Mask: 0x01)    */
#define CACHECTRL_CACHECFG_CACHE_CLKGATE_Pos (10UL)                 /*!< CACHECTRL CACHECFG: CACHE_CLKGATE (Bit 10)            */
#define CACHECTRL_CACHECFG_CACHE_CLKGATE_Msk (0x400UL)              /*!< CACHECTRL CACHECFG: CACHE_CLKGATE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECFG_DCACHE_ENABLE_Pos (9UL)                  /*!< CACHECTRL CACHECFG: DCACHE_ENABLE (Bit 9)             */
#define CACHECTRL_CACHECFG_DCACHE_ENABLE_Msk (0x200UL)              /*!< CACHECTRL CACHECFG: DCACHE_ENABLE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECFG_ICACHE_ENABLE_Pos (8UL)                  /*!< CACHECTRL CACHECFG: ICACHE_ENABLE (Bit 8)             */
#define CACHECTRL_CACHECFG_ICACHE_ENABLE_Msk (0x100UL)              /*!< CACHECTRL CACHECFG: ICACHE_ENABLE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECFG_CONFIG_Pos     (4UL)                     /*!< CACHECTRL CACHECFG: CONFIG (Bit 4)                    */
#define CACHECTRL_CACHECFG_CONFIG_Msk     (0xf0UL)                  /*!< CACHECTRL CACHECFG: CONFIG (Bitfield-Mask: 0x0f)      */
#define CACHECTRL_CACHECFG_ENABLE_NC1_Pos (3UL)                     /*!< CACHECTRL CACHECFG: ENABLE_NC1 (Bit 3)                */
#define CACHECTRL_CACHECFG_ENABLE_NC1_Msk (0x8UL)                   /*!< CACHECTRL CACHECFG: ENABLE_NC1 (Bitfield-Mask: 0x01)  */
#define CACHECTRL_CACHECFG_ENABLE_NC0_Pos (2UL)                     /*!< CACHECTRL CACHECFG: ENABLE_NC0 (Bit 2)                */
#define CACHECTRL_CACHECFG_ENABLE_NC0_Msk (0x4UL)                   /*!< CACHECTRL CACHECFG: ENABLE_NC0 (Bitfield-Mask: 0x01)  */
#define CACHECTRL_CACHECFG_LRU_Pos        (1UL)                     /*!< CACHECTRL CACHECFG: LRU (Bit 1)                       */
#define CACHECTRL_CACHECFG_LRU_Msk        (0x2UL)                   /*!< CACHECTRL CACHECFG: LRU (Bitfield-Mask: 0x01)         */
#define CACHECTRL_CACHECFG_ENABLE_Pos     (0UL)                     /*!< CACHECTRL CACHECFG: ENABLE (Bit 0)                    */
#define CACHECTRL_CACHECFG_ENABLE_Msk     (0x1UL)                   /*!< CACHECTRL CACHECFG: ENABLE (Bitfield-Mask: 0x01)      */
/* =========================================================  CTRL  ========================================================== */
#define CACHECTRL_CTRL_FLASH3_SLM_ENABLE_Pos (18UL)                 /*!< CACHECTRL CTRL: FLASH3_SLM_ENABLE (Bit 18)            */
#define CACHECTRL_CTRL_FLASH3_SLM_ENABLE_Msk (0x40000UL)            /*!< CACHECTRL CTRL: FLASH3_SLM_ENABLE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CTRL_FLASH3_SLM_DISABLE_Pos (17UL)                /*!< CACHECTRL CTRL: FLASH3_SLM_DISABLE (Bit 17)           */
#define CACHECTRL_CTRL_FLASH3_SLM_DISABLE_Msk (0x20000UL)           /*!< CACHECTRL CTRL: FLASH3_SLM_DISABLE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CTRL_FLASH3_SLM_STATUS_Pos (16UL)                 /*!< CACHECTRL CTRL: FLASH3_SLM_STATUS (Bit 16)            */
#define CACHECTRL_CTRL_FLASH3_SLM_STATUS_Msk (0x10000UL)            /*!< CACHECTRL CTRL: FLASH3_SLM_STATUS (Bitfield-Mask: 0x01) */
#define CACHECTRL_CTRL_FLASH2_SLM_ENABLE_Pos (14UL)                 /*!< CACHECTRL CTRL: FLASH2_SLM_ENABLE (Bit 14)            */
#define CACHECTRL_CTRL_FLASH2_SLM_ENABLE_Msk (0x4000UL)             /*!< CACHECTRL CTRL: FLASH2_SLM_ENABLE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CTRL_FLASH2_SLM_DISABLE_Pos (13UL)                /*!< CACHECTRL CTRL: FLASH2_SLM_DISABLE (Bit 13)           */
#define CACHECTRL_CTRL_FLASH2_SLM_DISABLE_Msk (0x2000UL)            /*!< CACHECTRL CTRL: FLASH2_SLM_DISABLE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CTRL_FLASH2_SLM_STATUS_Pos (12UL)                 /*!< CACHECTRL CTRL: FLASH2_SLM_STATUS (Bit 12)            */
#define CACHECTRL_CTRL_FLASH2_SLM_STATUS_Msk (0x1000UL)             /*!< CACHECTRL CTRL: FLASH2_SLM_STATUS (Bitfield-Mask: 0x01) */
#define CACHECTRL_CTRL_FLASH1_SLM_ENABLE_Pos (10UL)                 /*!< CACHECTRL CTRL: FLASH1_SLM_ENABLE (Bit 10)            */
#define CACHECTRL_CTRL_FLASH1_SLM_ENABLE_Msk (0x400UL)              /*!< CACHECTRL CTRL: FLASH1_SLM_ENABLE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CTRL_FLASH1_SLM_DISABLE_Pos (9UL)                 /*!< CACHECTRL CTRL: FLASH1_SLM_DISABLE (Bit 9)            */
#define CACHECTRL_CTRL_FLASH1_SLM_DISABLE_Msk (0x200UL)             /*!< CACHECTRL CTRL: FLASH1_SLM_DISABLE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CTRL_FLASH1_SLM_STATUS_Pos (8UL)                  /*!< CACHECTRL CTRL: FLASH1_SLM_STATUS (Bit 8)             */
#define CACHECTRL_CTRL_FLASH1_SLM_STATUS_Msk (0x100UL)              /*!< CACHECTRL CTRL: FLASH1_SLM_STATUS (Bitfield-Mask: 0x01) */
#define CACHECTRL_CTRL_FLASH0_SLM_ENABLE_Pos (6UL)                  /*!< CACHECTRL CTRL: FLASH0_SLM_ENABLE (Bit 6)             */
#define CACHECTRL_CTRL_FLASH0_SLM_ENABLE_Msk (0x40UL)               /*!< CACHECTRL CTRL: FLASH0_SLM_ENABLE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CTRL_FLASH0_SLM_DISABLE_Pos (5UL)                 /*!< CACHECTRL CTRL: FLASH0_SLM_DISABLE (Bit 5)            */
#define CACHECTRL_CTRL_FLASH0_SLM_DISABLE_Msk (0x20UL)              /*!< CACHECTRL CTRL: FLASH0_SLM_DISABLE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CTRL_FLASH0_SLM_STATUS_Pos (4UL)                  /*!< CACHECTRL CTRL: FLASH0_SLM_STATUS (Bit 4)             */
#define CACHECTRL_CTRL_FLASH0_SLM_STATUS_Msk (0x10UL)               /*!< CACHECTRL CTRL: FLASH0_SLM_STATUS (Bitfield-Mask: 0x01) */
#define CACHECTRL_CTRL_CACHE_READY_Pos    (2UL)                     /*!< CACHECTRL CTRL: CACHE_READY (Bit 2)                   */
#define CACHECTRL_CTRL_CACHE_READY_Msk    (0x4UL)                   /*!< CACHECTRL CTRL: CACHE_READY (Bitfield-Mask: 0x01)     */
#define CACHECTRL_CTRL_RESET_STAT_Pos     (1UL)                     /*!< CACHECTRL CTRL: RESET_STAT (Bit 1)                    */
#define CACHECTRL_CTRL_RESET_STAT_Msk     (0x2UL)                   /*!< CACHECTRL CTRL: RESET_STAT (Bitfield-Mask: 0x01)      */
#define CACHECTRL_CTRL_INVALIDATE_Pos     (0UL)                     /*!< CACHECTRL CTRL: INVALIDATE (Bit 0)                    */
#define CACHECTRL_CTRL_INVALIDATE_Msk     (0x1UL)                   /*!< CACHECTRL CTRL: INVALIDATE (Bitfield-Mask: 0x01)      */
/* =======================================================  NCR0START  ======================================================= */
#define CACHECTRL_NCR0START_ADDR_Pos      (4UL)                     /*!< CACHECTRL NCR0START: ADDR (Bit 4)                     */
#define CACHECTRL_NCR0START_ADDR_Msk      (0x7fffff0UL)             /*!< CACHECTRL NCR0START: ADDR (Bitfield-Mask: 0x7fffff)   */
/* ========================================================  NCR0END  ======================================================== */
#define CACHECTRL_NCR0END_ADDR_Pos        (4UL)                     /*!< CACHECTRL NCR0END: ADDR (Bit 4)                       */
#define CACHECTRL_NCR0END_ADDR_Msk        (0x7fffff0UL)             /*!< CACHECTRL NCR0END: ADDR (Bitfield-Mask: 0x7fffff)     */
/* =======================================================  NCR1START  ======================================================= */
#define CACHECTRL_NCR1START_ADDR_Pos      (4UL)                     /*!< CACHECTRL NCR1START: ADDR (Bit 4)                     */
#define CACHECTRL_NCR1START_ADDR_Msk      (0x7fffff0UL)             /*!< CACHECTRL NCR1START: ADDR (Bitfield-Mask: 0x7fffff)   */
/* ========================================================  NCR1END  ======================================================== */
#define CACHECTRL_NCR1END_ADDR_Pos        (4UL)                     /*!< CACHECTRL NCR1END: ADDR (Bit 4)                       */
#define CACHECTRL_NCR1END_ADDR_Msk        (0x7fffff0UL)             /*!< CACHECTRL NCR1END: ADDR (Bitfield-Mask: 0x7fffff)     */
/* =========================================================  DMON0  ========================================================= */
#define CACHECTRL_DMON0_DACCESS_COUNT_Pos (0UL)                     /*!< CACHECTRL DMON0: DACCESS_COUNT (Bit 0)                */
#define CACHECTRL_DMON0_DACCESS_COUNT_Msk (0xffffffffUL)            /*!< CACHECTRL DMON0: DACCESS_COUNT (Bitfield-Mask: 0xffffffff) */
/* =========================================================  DMON1  ========================================================= */
#define CACHECTRL_DMON1_DLOOKUP_COUNT_Pos (0UL)                     /*!< CACHECTRL DMON1: DLOOKUP_COUNT (Bit 0)                */
#define CACHECTRL_DMON1_DLOOKUP_COUNT_Msk (0xffffffffUL)            /*!< CACHECTRL DMON1: DLOOKUP_COUNT (Bitfield-Mask: 0xffffffff) */
/* =========================================================  DMON2  ========================================================= */
#define CACHECTRL_DMON2_DHIT_COUNT_Pos    (0UL)                     /*!< CACHECTRL DMON2: DHIT_COUNT (Bit 0)                   */
#define CACHECTRL_DMON2_DHIT_COUNT_Msk    (0xffffffffUL)            /*!< CACHECTRL DMON2: DHIT_COUNT (Bitfield-Mask: 0xffffffff) */
/* =========================================================  DMON3  ========================================================= */
#define CACHECTRL_DMON3_DLINE_COUNT_Pos   (0UL)                     /*!< CACHECTRL DMON3: DLINE_COUNT (Bit 0)                  */
#define CACHECTRL_DMON3_DLINE_COUNT_Msk   (0xffffffffUL)            /*!< CACHECTRL DMON3: DLINE_COUNT (Bitfield-Mask: 0xffffffff) */
/* =========================================================  IMON0  ========================================================= */
#define CACHECTRL_IMON0_IACCESS_COUNT_Pos (0UL)                     /*!< CACHECTRL IMON0: IACCESS_COUNT (Bit 0)                */
#define CACHECTRL_IMON0_IACCESS_COUNT_Msk (0xffffffffUL)            /*!< CACHECTRL IMON0: IACCESS_COUNT (Bitfield-Mask: 0xffffffff) */
/* =========================================================  IMON1  ========================================================= */
#define CACHECTRL_IMON1_ILOOKUP_COUNT_Pos (0UL)                     /*!< CACHECTRL IMON1: ILOOKUP_COUNT (Bit 0)                */
#define CACHECTRL_IMON1_ILOOKUP_COUNT_Msk (0xffffffffUL)            /*!< CACHECTRL IMON1: ILOOKUP_COUNT (Bitfield-Mask: 0xffffffff) */
/* =========================================================  IMON2  ========================================================= */
#define CACHECTRL_IMON2_IHIT_COUNT_Pos    (0UL)                     /*!< CACHECTRL IMON2: IHIT_COUNT (Bit 0)                   */
#define CACHECTRL_IMON2_IHIT_COUNT_Msk    (0xffffffffUL)            /*!< CACHECTRL IMON2: IHIT_COUNT (Bitfield-Mask: 0xffffffff) */
/* =========================================================  IMON3  ========================================================= */
#define CACHECTRL_IMON3_ILINE_COUNT_Pos   (0UL)                     /*!< CACHECTRL IMON3: ILINE_COUNT (Bit 0)                  */
#define CACHECTRL_IMON3_ILINE_COUNT_Msk   (0xffffffffUL)            /*!< CACHECTRL IMON3: ILINE_COUNT (Bitfield-Mask: 0xffffffff) */
/* =======================================================  FLASH0CFG  ======================================================= */
#define CACHECTRL_FLASH0CFG_LPMMODE0_Pos  (12UL)                    /*!< CACHECTRL FLASH0CFG: LPMMODE0 (Bit 12)                */
#define CACHECTRL_FLASH0CFG_LPMMODE0_Msk  (0x3000UL)                /*!< CACHECTRL FLASH0CFG: LPMMODE0 (Bitfield-Mask: 0x03)   */
#define CACHECTRL_FLASH0CFG_LPMRDWAIT0_Pos (8UL)                    /*!< CACHECTRL FLASH0CFG: LPMRDWAIT0 (Bit 8)               */
#define CACHECTRL_FLASH0CFG_LPMRDWAIT0_Msk (0xf00UL)                /*!< CACHECTRL FLASH0CFG: LPMRDWAIT0 (Bitfield-Mask: 0x0f) */
#define CACHECTRL_FLASH0CFG_SEDELAY0_Pos  (4UL)                     /*!< CACHECTRL FLASH0CFG: SEDELAY0 (Bit 4)                 */
#define CACHECTRL_FLASH0CFG_SEDELAY0_Msk  (0x70UL)                  /*!< CACHECTRL FLASH0CFG: SEDELAY0 (Bitfield-Mask: 0x07)   */
#define CACHECTRL_FLASH0CFG_RDWAIT0_Pos   (0UL)                     /*!< CACHECTRL FLASH0CFG: RDWAIT0 (Bit 0)                  */
#define CACHECTRL_FLASH0CFG_RDWAIT0_Msk   (0xfUL)                   /*!< CACHECTRL FLASH0CFG: RDWAIT0 (Bitfield-Mask: 0x0f)    */
/* =======================================================  FLASH1CFG  ======================================================= */
#define CACHECTRL_FLASH1CFG_LPMMODE1_Pos  (12UL)                    /*!< CACHECTRL FLASH1CFG: LPMMODE1 (Bit 12)                */
#define CACHECTRL_FLASH1CFG_LPMMODE1_Msk  (0x3000UL)                /*!< CACHECTRL FLASH1CFG: LPMMODE1 (Bitfield-Mask: 0x03)   */
#define CACHECTRL_FLASH1CFG_LPMRDWAIT1_Pos (8UL)                    /*!< CACHECTRL FLASH1CFG: LPMRDWAIT1 (Bit 8)               */
#define CACHECTRL_FLASH1CFG_LPMRDWAIT1_Msk (0xf00UL)                /*!< CACHECTRL FLASH1CFG: LPMRDWAIT1 (Bitfield-Mask: 0x0f) */
#define CACHECTRL_FLASH1CFG_SEDELAY1_Pos  (4UL)                     /*!< CACHECTRL FLASH1CFG: SEDELAY1 (Bit 4)                 */
#define CACHECTRL_FLASH1CFG_SEDELAY1_Msk  (0x70UL)                  /*!< CACHECTRL FLASH1CFG: SEDELAY1 (Bitfield-Mask: 0x07)   */
#define CACHECTRL_FLASH1CFG_RDWAIT1_Pos   (0UL)                     /*!< CACHECTRL FLASH1CFG: RDWAIT1 (Bit 0)                  */
#define CACHECTRL_FLASH1CFG_RDWAIT1_Msk   (0xfUL)                   /*!< CACHECTRL FLASH1CFG: RDWAIT1 (Bitfield-Mask: 0x0f)    */
/* =======================================================  FLASH2CFG  ======================================================= */
#define CACHECTRL_FLASH2CFG_LPMMODE2_Pos  (12UL)                    /*!< CACHECTRL FLASH2CFG: LPMMODE2 (Bit 12)                */
#define CACHECTRL_FLASH2CFG_LPMMODE2_Msk  (0x3000UL)                /*!< CACHECTRL FLASH2CFG: LPMMODE2 (Bitfield-Mask: 0x03)   */
#define CACHECTRL_FLASH2CFG_LPMRDWAIT2_Pos (8UL)                    /*!< CACHECTRL FLASH2CFG: LPMRDWAIT2 (Bit 8)               */
#define CACHECTRL_FLASH2CFG_LPMRDWAIT2_Msk (0xf00UL)                /*!< CACHECTRL FLASH2CFG: LPMRDWAIT2 (Bitfield-Mask: 0x0f) */
#define CACHECTRL_FLASH2CFG_SEDELAY2_Pos  (4UL)                     /*!< CACHECTRL FLASH2CFG: SEDELAY2 (Bit 4)                 */
#define CACHECTRL_FLASH2CFG_SEDELAY2_Msk  (0x70UL)                  /*!< CACHECTRL FLASH2CFG: SEDELAY2 (Bitfield-Mask: 0x07)   */
#define CACHECTRL_FLASH2CFG_RDWAIT2_Pos   (0UL)                     /*!< CACHECTRL FLASH2CFG: RDWAIT2 (Bit 0)                  */
#define CACHECTRL_FLASH2CFG_RDWAIT2_Msk   (0xfUL)                   /*!< CACHECTRL FLASH2CFG: RDWAIT2 (Bitfield-Mask: 0x0f)    */
/* =======================================================  FLASH3CFG  ======================================================= */
#define CACHECTRL_FLASH3CFG_LPMMODE3_Pos  (12UL)                    /*!< CACHECTRL FLASH3CFG: LPMMODE3 (Bit 12)                */
#define CACHECTRL_FLASH3CFG_LPMMODE3_Msk  (0x3000UL)                /*!< CACHECTRL FLASH3CFG: LPMMODE3 (Bitfield-Mask: 0x03)   */
#define CACHECTRL_FLASH3CFG_LPMRDWAIT3_Pos (8UL)                    /*!< CACHECTRL FLASH3CFG: LPMRDWAIT3 (Bit 8)               */
#define CACHECTRL_FLASH3CFG_LPMRDWAIT3_Msk (0xf00UL)                /*!< CACHECTRL FLASH3CFG: LPMRDWAIT3 (Bitfield-Mask: 0x0f) */
#define CACHECTRL_FLASH3CFG_SEDELAY3_Pos  (4UL)                     /*!< CACHECTRL FLASH3CFG: SEDELAY3 (Bit 4)                 */
#define CACHECTRL_FLASH3CFG_SEDELAY3_Msk  (0x70UL)                  /*!< CACHECTRL FLASH3CFG: SEDELAY3 (Bitfield-Mask: 0x07)   */
#define CACHECTRL_FLASH3CFG_RDWAIT3_Pos   (0UL)                     /*!< CACHECTRL FLASH3CFG: RDWAIT3 (Bit 0)                  */
#define CACHECTRL_FLASH3CFG_RDWAIT3_Msk   (0xfUL)                   /*!< CACHECTRL FLASH3CFG: RDWAIT3 (Bitfield-Mask: 0x0f)    */


/* =========================================================================================================================== */
/* ================                                          CLKGEN                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  CALXT  ========================================================= */
#define CLKGEN_CALXT_CALXT_Pos            (0UL)                     /*!< CLKGEN CALXT: CALXT (Bit 0)                           */
#define CLKGEN_CALXT_CALXT_Msk            (0x7ffUL)                 /*!< CLKGEN CALXT: CALXT (Bitfield-Mask: 0x7ff)            */
/* =========================================================  CALRC  ========================================================= */
#define CLKGEN_CALRC_CALRC_Pos            (0UL)                     /*!< CLKGEN CALRC: CALRC (Bit 0)                           */
#define CLKGEN_CALRC_CALRC_Msk            (0x3ffffUL)               /*!< CLKGEN CALRC: CALRC (Bitfield-Mask: 0x3ffff)          */
/* ========================================================  ACALCTR  ======================================================== */
#define CLKGEN_ACALCTR_ACALCTR_Pos        (0UL)                     /*!< CLKGEN ACALCTR: ACALCTR (Bit 0)                       */
#define CLKGEN_ACALCTR_ACALCTR_Msk        (0xffffffUL)              /*!< CLKGEN ACALCTR: ACALCTR (Bitfield-Mask: 0xffffff)     */
/* =========================================================  OCTRL  ========================================================= */
#define CLKGEN_OCTRL_ACAL_Pos             (8UL)                     /*!< CLKGEN OCTRL: ACAL (Bit 8)                            */
#define CLKGEN_OCTRL_ACAL_Msk             (0x700UL)                 /*!< CLKGEN OCTRL: ACAL (Bitfield-Mask: 0x07)              */
#define CLKGEN_OCTRL_OSEL_Pos             (7UL)                     /*!< CLKGEN OCTRL: OSEL (Bit 7)                            */
#define CLKGEN_OCTRL_OSEL_Msk             (0x80UL)                  /*!< CLKGEN OCTRL: OSEL (Bitfield-Mask: 0x01)              */
#define CLKGEN_OCTRL_FOS_Pos              (6UL)                     /*!< CLKGEN OCTRL: FOS (Bit 6)                             */
#define CLKGEN_OCTRL_FOS_Msk              (0x40UL)                  /*!< CLKGEN OCTRL: FOS (Bitfield-Mask: 0x01)               */
#define CLKGEN_OCTRL_STOPRC_Pos           (1UL)                     /*!< CLKGEN OCTRL: STOPRC (Bit 1)                          */
#define CLKGEN_OCTRL_STOPRC_Msk           (0x2UL)                   /*!< CLKGEN OCTRL: STOPRC (Bitfield-Mask: 0x01)            */
#define CLKGEN_OCTRL_STOPXT_Pos           (0UL)                     /*!< CLKGEN OCTRL: STOPXT (Bit 0)                          */
#define CLKGEN_OCTRL_STOPXT_Msk           (0x1UL)                   /*!< CLKGEN OCTRL: STOPXT (Bitfield-Mask: 0x01)            */
/* ========================================================  CLKOUT  ========================================================= */
#define CLKGEN_CLKOUT_CKEN_Pos            (7UL)                     /*!< CLKGEN CLKOUT: CKEN (Bit 7)                           */
#define CLKGEN_CLKOUT_CKEN_Msk            (0x80UL)                  /*!< CLKGEN CLKOUT: CKEN (Bitfield-Mask: 0x01)             */
#define CLKGEN_CLKOUT_CKSEL_Pos           (0UL)                     /*!< CLKGEN CLKOUT: CKSEL (Bit 0)                          */
#define CLKGEN_CLKOUT_CKSEL_Msk           (0x3fUL)                  /*!< CLKGEN CLKOUT: CKSEL (Bitfield-Mask: 0x3f)            */
/* ========================================================  CLKKEY  ========================================================= */
#define CLKGEN_CLKKEY_CLKKEY_Pos          (0UL)                     /*!< CLKGEN CLKKEY: CLKKEY (Bit 0)                         */
#define CLKGEN_CLKKEY_CLKKEY_Msk          (0xffffffffUL)            /*!< CLKGEN CLKKEY: CLKKEY (Bitfield-Mask: 0xffffffff)     */
/* =========================================================  CCTRL  ========================================================= */
#define CLKGEN_CCTRL_CORESEL_Pos          (0UL)                     /*!< CLKGEN CCTRL: CORESEL (Bit 0)                         */
#define CLKGEN_CCTRL_CORESEL_Msk          (0x1UL)                   /*!< CLKGEN CCTRL: CORESEL (Bitfield-Mask: 0x01)           */
/* ========================================================  STATUS  ========================================================= */
#define CLKGEN_STATUS_OSCF_Pos            (1UL)                     /*!< CLKGEN STATUS: OSCF (Bit 1)                           */
#define CLKGEN_STATUS_OSCF_Msk            (0x2UL)                   /*!< CLKGEN STATUS: OSCF (Bitfield-Mask: 0x01)             */
#define CLKGEN_STATUS_OMODE_Pos           (0UL)                     /*!< CLKGEN STATUS: OMODE (Bit 0)                          */
#define CLKGEN_STATUS_OMODE_Msk           (0x1UL)                   /*!< CLKGEN STATUS: OMODE (Bitfield-Mask: 0x01)            */
/* =========================================================  HFADJ  ========================================================= */
#define CLKGEN_HFADJ_HFADJGAIN_Pos        (21UL)                    /*!< CLKGEN HFADJ: HFADJGAIN (Bit 21)                      */
#define CLKGEN_HFADJ_HFADJGAIN_Msk        (0xe00000UL)              /*!< CLKGEN HFADJ: HFADJGAIN (Bitfield-Mask: 0x07)         */
#define CLKGEN_HFADJ_HFWARMUP_Pos         (20UL)                    /*!< CLKGEN HFADJ: HFWARMUP (Bit 20)                       */
#define CLKGEN_HFADJ_HFWARMUP_Msk         (0x100000UL)              /*!< CLKGEN HFADJ: HFWARMUP (Bitfield-Mask: 0x01)          */
#define CLKGEN_HFADJ_HFXTADJ_Pos          (8UL)                     /*!< CLKGEN HFADJ: HFXTADJ (Bit 8)                         */
#define CLKGEN_HFADJ_HFXTADJ_Msk          (0xfff00UL)               /*!< CLKGEN HFADJ: HFXTADJ (Bitfield-Mask: 0xfff)          */
#define CLKGEN_HFADJ_HFADJCK_Pos          (1UL)                     /*!< CLKGEN HFADJ: HFADJCK (Bit 1)                         */
#define CLKGEN_HFADJ_HFADJCK_Msk          (0xeUL)                   /*!< CLKGEN HFADJ: HFADJCK (Bitfield-Mask: 0x07)           */
#define CLKGEN_HFADJ_HFADJEN_Pos          (0UL)                     /*!< CLKGEN HFADJ: HFADJEN (Bit 0)                         */
#define CLKGEN_HFADJ_HFADJEN_Msk          (0x1UL)                   /*!< CLKGEN HFADJ: HFADJEN (Bitfield-Mask: 0x01)           */
/* ======================================================  CLOCKENSTAT  ====================================================== */
#define CLKGEN_CLOCKENSTAT_CLOCKENSTAT_Pos (0UL)                    /*!< CLKGEN CLOCKENSTAT: CLOCKENSTAT (Bit 0)               */
#define CLKGEN_CLOCKENSTAT_CLOCKENSTAT_Msk (0xffffffffUL)           /*!< CLKGEN CLOCKENSTAT: CLOCKENSTAT (Bitfield-Mask: 0xffffffff) */
/* =====================================================  CLOCKEN2STAT  ====================================================== */
#define CLKGEN_CLOCKEN2STAT_CLOCKEN2STAT_Pos (0UL)                  /*!< CLKGEN CLOCKEN2STAT: CLOCKEN2STAT (Bit 0)             */
#define CLKGEN_CLOCKEN2STAT_CLOCKEN2STAT_Msk (0xffffffffUL)         /*!< CLKGEN CLOCKEN2STAT: CLOCKEN2STAT (Bitfield-Mask: 0xffffffff) */
/* =====================================================  CLOCKEN3STAT  ====================================================== */
#define CLKGEN_CLOCKEN3STAT_CLOCKEN3STAT_Pos (0UL)                  /*!< CLKGEN CLOCKEN3STAT: CLOCKEN3STAT (Bit 0)             */
#define CLKGEN_CLOCKEN3STAT_CLOCKEN3STAT_Msk (0xffffffffUL)         /*!< CLKGEN CLOCKEN3STAT: CLOCKEN3STAT (Bitfield-Mask: 0xffffffff) */
/* =======================================================  FREQCTRL  ======================================================== */
#define CLKGEN_FREQCTRL_BURSTSTATUS_Pos   (2UL)                     /*!< CLKGEN FREQCTRL: BURSTSTATUS (Bit 2)                  */
#define CLKGEN_FREQCTRL_BURSTSTATUS_Msk   (0x4UL)                   /*!< CLKGEN FREQCTRL: BURSTSTATUS (Bitfield-Mask: 0x01)    */
#define CLKGEN_FREQCTRL_BURSTACK_Pos      (1UL)                     /*!< CLKGEN FREQCTRL: BURSTACK (Bit 1)                     */
#define CLKGEN_FREQCTRL_BURSTACK_Msk      (0x2UL)                   /*!< CLKGEN FREQCTRL: BURSTACK (Bitfield-Mask: 0x01)       */
#define CLKGEN_FREQCTRL_BURSTREQ_Pos      (0UL)                     /*!< CLKGEN FREQCTRL: BURSTREQ (Bit 0)                     */
#define CLKGEN_FREQCTRL_BURSTREQ_Msk      (0x1UL)                   /*!< CLKGEN FREQCTRL: BURSTREQ (Bitfield-Mask: 0x01)       */
/* =====================================================  BLEBUCKTONADJ  ===================================================== */
#define CLKGEN_BLEBUCKTONADJ_ZEROLENDETECTEN_Pos (27UL)             /*!< CLKGEN BLEBUCKTONADJ: ZEROLENDETECTEN (Bit 27)        */
#define CLKGEN_BLEBUCKTONADJ_ZEROLENDETECTEN_Msk (0x8000000UL)      /*!< CLKGEN BLEBUCKTONADJ: ZEROLENDETECTEN (Bitfield-Mask: 0x01) */
#define CLKGEN_BLEBUCKTONADJ_ZEROLENDETECTTRIM_Pos (23UL)           /*!< CLKGEN BLEBUCKTONADJ: ZEROLENDETECTTRIM (Bit 23)      */
#define CLKGEN_BLEBUCKTONADJ_ZEROLENDETECTTRIM_Msk (0x7800000UL)    /*!< CLKGEN BLEBUCKTONADJ: ZEROLENDETECTTRIM (Bitfield-Mask: 0x0f) */
#define CLKGEN_BLEBUCKTONADJ_TONADJUSTEN_Pos (22UL)                 /*!< CLKGEN BLEBUCKTONADJ: TONADJUSTEN (Bit 22)            */
#define CLKGEN_BLEBUCKTONADJ_TONADJUSTEN_Msk (0x400000UL)           /*!< CLKGEN BLEBUCKTONADJ: TONADJUSTEN (Bitfield-Mask: 0x01) */
#define CLKGEN_BLEBUCKTONADJ_TONADJUSTPERIOD_Pos (20UL)             /*!< CLKGEN BLEBUCKTONADJ: TONADJUSTPERIOD (Bit 20)        */
#define CLKGEN_BLEBUCKTONADJ_TONADJUSTPERIOD_Msk (0x300000UL)       /*!< CLKGEN BLEBUCKTONADJ: TONADJUSTPERIOD (Bitfield-Mask: 0x03) */
#define CLKGEN_BLEBUCKTONADJ_TONHIGHTHRESHOLD_Pos (10UL)            /*!< CLKGEN BLEBUCKTONADJ: TONHIGHTHRESHOLD (Bit 10)       */
#define CLKGEN_BLEBUCKTONADJ_TONHIGHTHRESHOLD_Msk (0xffc00UL)       /*!< CLKGEN BLEBUCKTONADJ: TONHIGHTHRESHOLD (Bitfield-Mask: 0x3ff) */
#define CLKGEN_BLEBUCKTONADJ_TONLOWTHRESHOLD_Pos (0UL)              /*!< CLKGEN BLEBUCKTONADJ: TONLOWTHRESHOLD (Bit 0)         */
#define CLKGEN_BLEBUCKTONADJ_TONLOWTHRESHOLD_Msk (0x3ffUL)          /*!< CLKGEN BLEBUCKTONADJ: TONLOWTHRESHOLD (Bitfield-Mask: 0x3ff) */
/* =======================================================  INTRPTEN  ======================================================== */
#define CLKGEN_INTRPTEN_OF_Pos            (2UL)                     /*!< CLKGEN INTRPTEN: OF (Bit 2)                           */
#define CLKGEN_INTRPTEN_OF_Msk            (0x4UL)                   /*!< CLKGEN INTRPTEN: OF (Bitfield-Mask: 0x01)             */
#define CLKGEN_INTRPTEN_ACC_Pos           (1UL)                     /*!< CLKGEN INTRPTEN: ACC (Bit 1)                          */
#define CLKGEN_INTRPTEN_ACC_Msk           (0x2UL)                   /*!< CLKGEN INTRPTEN: ACC (Bitfield-Mask: 0x01)            */
#define CLKGEN_INTRPTEN_ACF_Pos           (0UL)                     /*!< CLKGEN INTRPTEN: ACF (Bit 0)                          */
#define CLKGEN_INTRPTEN_ACF_Msk           (0x1UL)                   /*!< CLKGEN INTRPTEN: ACF (Bitfield-Mask: 0x01)            */
/* ======================================================  INTRPTSTAT  ======================================================= */
#define CLKGEN_INTRPTSTAT_OF_Pos          (2UL)                     /*!< CLKGEN INTRPTSTAT: OF (Bit 2)                         */
#define CLKGEN_INTRPTSTAT_OF_Msk          (0x4UL)                   /*!< CLKGEN INTRPTSTAT: OF (Bitfield-Mask: 0x01)           */
#define CLKGEN_INTRPTSTAT_ACC_Pos         (1UL)                     /*!< CLKGEN INTRPTSTAT: ACC (Bit 1)                        */
#define CLKGEN_INTRPTSTAT_ACC_Msk         (0x2UL)                   /*!< CLKGEN INTRPTSTAT: ACC (Bitfield-Mask: 0x01)          */
#define CLKGEN_INTRPTSTAT_ACF_Pos         (0UL)                     /*!< CLKGEN INTRPTSTAT: ACF (Bit 0)                        */
#define CLKGEN_INTRPTSTAT_ACF_Msk         (0x1UL)                   /*!< CLKGEN INTRPTSTAT: ACF (Bitfield-Mask: 0x01)          */
/* =======================================================  INTRPTCLR  ======================================================= */
#define CLKGEN_INTRPTCLR_OF_Pos           (2UL)                     /*!< CLKGEN INTRPTCLR: OF (Bit 2)                          */
#define CLKGEN_INTRPTCLR_OF_Msk           (0x4UL)                   /*!< CLKGEN INTRPTCLR: OF (Bitfield-Mask: 0x01)            */
#define CLKGEN_INTRPTCLR_ACC_Pos          (1UL)                     /*!< CLKGEN INTRPTCLR: ACC (Bit 1)                         */
#define CLKGEN_INTRPTCLR_ACC_Msk          (0x2UL)                   /*!< CLKGEN INTRPTCLR: ACC (Bitfield-Mask: 0x01)           */
#define CLKGEN_INTRPTCLR_ACF_Pos          (0UL)                     /*!< CLKGEN INTRPTCLR: ACF (Bit 0)                         */
#define CLKGEN_INTRPTCLR_ACF_Msk          (0x1UL)                   /*!< CLKGEN INTRPTCLR: ACF (Bitfield-Mask: 0x01)           */
/* =======================================================  INTRPTSET  ======================================================= */
#define CLKGEN_INTRPTSET_OF_Pos           (2UL)                     /*!< CLKGEN INTRPTSET: OF (Bit 2)                          */
#define CLKGEN_INTRPTSET_OF_Msk           (0x4UL)                   /*!< CLKGEN INTRPTSET: OF (Bitfield-Mask: 0x01)            */
#define CLKGEN_INTRPTSET_ACC_Pos          (1UL)                     /*!< CLKGEN INTRPTSET: ACC (Bit 1)                         */
#define CLKGEN_INTRPTSET_ACC_Msk          (0x2UL)                   /*!< CLKGEN INTRPTSET: ACC (Bitfield-Mask: 0x01)           */
#define CLKGEN_INTRPTSET_ACF_Pos          (0UL)                     /*!< CLKGEN INTRPTSET: ACF (Bit 0)                         */
#define CLKGEN_INTRPTSET_ACF_Msk          (0x1UL)                   /*!< CLKGEN INTRPTSET: ACF (Bitfield-Mask: 0x01)           */


/* =========================================================================================================================== */
/* ================                                          CTIMER                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  TMR0  ========================================================== */
#define CTIMER_TMR0_CTTMRB0_Pos           (16UL)                    /*!< CTIMER TMR0: CTTMRB0 (Bit 16)                         */
#define CTIMER_TMR0_CTTMRB0_Msk           (0xffff0000UL)            /*!< CTIMER TMR0: CTTMRB0 (Bitfield-Mask: 0xffff)          */
#define CTIMER_TMR0_CTTMRA0_Pos           (0UL)                     /*!< CTIMER TMR0: CTTMRA0 (Bit 0)                          */
#define CTIMER_TMR0_CTTMRA0_Msk           (0xffffUL)                /*!< CTIMER TMR0: CTTMRA0 (Bitfield-Mask: 0xffff)          */
/* ========================================================  CMPRA0  ========================================================= */
#define CTIMER_CMPRA0_CMPR1A0_Pos         (16UL)                    /*!< CTIMER CMPRA0: CMPR1A0 (Bit 16)                       */
#define CTIMER_CMPRA0_CMPR1A0_Msk         (0xffff0000UL)            /*!< CTIMER CMPRA0: CMPR1A0 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRA0_CMPR0A0_Pos         (0UL)                     /*!< CTIMER CMPRA0: CMPR0A0 (Bit 0)                        */
#define CTIMER_CMPRA0_CMPR0A0_Msk         (0xffffUL)                /*!< CTIMER CMPRA0: CMPR0A0 (Bitfield-Mask: 0xffff)        */
/* ========================================================  CMPRB0  ========================================================= */
#define CTIMER_CMPRB0_CMPR1B0_Pos         (16UL)                    /*!< CTIMER CMPRB0: CMPR1B0 (Bit 16)                       */
#define CTIMER_CMPRB0_CMPR1B0_Msk         (0xffff0000UL)            /*!< CTIMER CMPRB0: CMPR1B0 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRB0_CMPR0B0_Pos         (0UL)                     /*!< CTIMER CMPRB0: CMPR0B0 (Bit 0)                        */
#define CTIMER_CMPRB0_CMPR0B0_Msk         (0xffffUL)                /*!< CTIMER CMPRB0: CMPR0B0 (Bitfield-Mask: 0xffff)        */
/* =========================================================  CTRL0  ========================================================= */
#define CTIMER_CTRL0_CTLINK0_Pos          (31UL)                    /*!< CTIMER CTRL0: CTLINK0 (Bit 31)                        */
#define CTIMER_CTRL0_CTLINK0_Msk          (0x80000000UL)            /*!< CTIMER CTRL0: CTLINK0 (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL0_TMRB0POL_Pos         (28UL)                    /*!< CTIMER CTRL0: TMRB0POL (Bit 28)                       */
#define CTIMER_CTRL0_TMRB0POL_Msk         (0x10000000UL)            /*!< CTIMER CTRL0: TMRB0POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRB0CLR_Pos         (27UL)                    /*!< CTIMER CTRL0: TMRB0CLR (Bit 27)                       */
#define CTIMER_CTRL0_TMRB0CLR_Msk         (0x8000000UL)             /*!< CTIMER CTRL0: TMRB0CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRB0IE1_Pos         (26UL)                    /*!< CTIMER CTRL0: TMRB0IE1 (Bit 26)                       */
#define CTIMER_CTRL0_TMRB0IE1_Msk         (0x4000000UL)             /*!< CTIMER CTRL0: TMRB0IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRB0IE0_Pos         (25UL)                    /*!< CTIMER CTRL0: TMRB0IE0 (Bit 25)                       */
#define CTIMER_CTRL0_TMRB0IE0_Msk         (0x2000000UL)             /*!< CTIMER CTRL0: TMRB0IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRB0FN_Pos          (22UL)                    /*!< CTIMER CTRL0: TMRB0FN (Bit 22)                        */
#define CTIMER_CTRL0_TMRB0FN_Msk          (0x1c00000UL)             /*!< CTIMER CTRL0: TMRB0FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL0_TMRB0CLK_Pos         (17UL)                    /*!< CTIMER CTRL0: TMRB0CLK (Bit 17)                       */
#define CTIMER_CTRL0_TMRB0CLK_Msk         (0x3e0000UL)              /*!< CTIMER CTRL0: TMRB0CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL0_TMRB0EN_Pos          (16UL)                    /*!< CTIMER CTRL0: TMRB0EN (Bit 16)                        */
#define CTIMER_CTRL0_TMRB0EN_Msk          (0x10000UL)               /*!< CTIMER CTRL0: TMRB0EN (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL0_TMRA0POL_Pos         (12UL)                    /*!< CTIMER CTRL0: TMRA0POL (Bit 12)                       */
#define CTIMER_CTRL0_TMRA0POL_Msk         (0x1000UL)                /*!< CTIMER CTRL0: TMRA0POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRA0CLR_Pos         (11UL)                    /*!< CTIMER CTRL0: TMRA0CLR (Bit 11)                       */
#define CTIMER_CTRL0_TMRA0CLR_Msk         (0x800UL)                 /*!< CTIMER CTRL0: TMRA0CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRA0IE1_Pos         (10UL)                    /*!< CTIMER CTRL0: TMRA0IE1 (Bit 10)                       */
#define CTIMER_CTRL0_TMRA0IE1_Msk         (0x400UL)                 /*!< CTIMER CTRL0: TMRA0IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRA0IE0_Pos         (9UL)                     /*!< CTIMER CTRL0: TMRA0IE0 (Bit 9)                        */
#define CTIMER_CTRL0_TMRA0IE0_Msk         (0x200UL)                 /*!< CTIMER CTRL0: TMRA0IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRA0FN_Pos          (6UL)                     /*!< CTIMER CTRL0: TMRA0FN (Bit 6)                         */
#define CTIMER_CTRL0_TMRA0FN_Msk          (0x1c0UL)                 /*!< CTIMER CTRL0: TMRA0FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL0_TMRA0CLK_Pos         (1UL)                     /*!< CTIMER CTRL0: TMRA0CLK (Bit 1)                        */
#define CTIMER_CTRL0_TMRA0CLK_Msk         (0x3eUL)                  /*!< CTIMER CTRL0: TMRA0CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL0_TMRA0EN_Pos          (0UL)                     /*!< CTIMER CTRL0: TMRA0EN (Bit 0)                         */
#define CTIMER_CTRL0_TMRA0EN_Msk          (0x1UL)                   /*!< CTIMER CTRL0: TMRA0EN (Bitfield-Mask: 0x01)           */
/* =======================================================  CMPRAUXA0  ======================================================= */
#define CTIMER_CMPRAUXA0_CMPR3A0_Pos      (16UL)                    /*!< CTIMER CMPRAUXA0: CMPR3A0 (Bit 16)                    */
#define CTIMER_CMPRAUXA0_CMPR3A0_Msk      (0xffff0000UL)            /*!< CTIMER CMPRAUXA0: CMPR3A0 (Bitfield-Mask: 0xffff)     */
#define CTIMER_CMPRAUXA0_CMPR2A0_Pos      (0UL)                     /*!< CTIMER CMPRAUXA0: CMPR2A0 (Bit 0)                     */
#define CTIMER_CMPRAUXA0_CMPR2A0_Msk      (0xffffUL)                /*!< CTIMER CMPRAUXA0: CMPR2A0 (Bitfield-Mask: 0xffff)     */
/* =======================================================  CMPRAUXB0  ======================================================= */
#define CTIMER_CMPRAUXB0_CMPR3B0_Pos      (16UL)                    /*!< CTIMER CMPRAUXB0: CMPR3B0 (Bit 16)                    */
#define CTIMER_CMPRAUXB0_CMPR3B0_Msk      (0xffff0000UL)            /*!< CTIMER CMPRAUXB0: CMPR3B0 (Bitfield-Mask: 0xffff)     */
#define CTIMER_CMPRAUXB0_CMPR2B0_Pos      (0UL)                     /*!< CTIMER CMPRAUXB0: CMPR2B0 (Bit 0)                     */
#define CTIMER_CMPRAUXB0_CMPR2B0_Msk      (0xffffUL)                /*!< CTIMER CMPRAUXB0: CMPR2B0 (Bitfield-Mask: 0xffff)     */
/* =========================================================  AUX0  ========================================================== */
#define CTIMER_AUX0_TMRB0EN23_Pos         (30UL)                    /*!< CTIMER AUX0: TMRB0EN23 (Bit 30)                       */
#define CTIMER_AUX0_TMRB0EN23_Msk         (0x40000000UL)            /*!< CTIMER AUX0: TMRB0EN23 (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX0_TMRB0POL23_Pos        (29UL)                    /*!< CTIMER AUX0: TMRB0POL23 (Bit 29)                      */
#define CTIMER_AUX0_TMRB0POL23_Msk        (0x20000000UL)            /*!< CTIMER AUX0: TMRB0POL23 (Bitfield-Mask: 0x01)         */
#define CTIMER_AUX0_TMRB0TINV_Pos         (28UL)                    /*!< CTIMER AUX0: TMRB0TINV (Bit 28)                       */
#define CTIMER_AUX0_TMRB0TINV_Msk         (0x10000000UL)            /*!< CTIMER AUX0: TMRB0TINV (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX0_TMRB0NOSYNC_Pos       (27UL)                    /*!< CTIMER AUX0: TMRB0NOSYNC (Bit 27)                     */
#define CTIMER_AUX0_TMRB0NOSYNC_Msk       (0x8000000UL)             /*!< CTIMER AUX0: TMRB0NOSYNC (Bitfield-Mask: 0x01)        */
#define CTIMER_AUX0_TMRB0TRIG_Pos         (23UL)                    /*!< CTIMER AUX0: TMRB0TRIG (Bit 23)                       */
#define CTIMER_AUX0_TMRB0TRIG_Msk         (0x7800000UL)             /*!< CTIMER AUX0: TMRB0TRIG (Bitfield-Mask: 0x0f)          */
#define CTIMER_AUX0_TMRB0LMT_Pos          (16UL)                    /*!< CTIMER AUX0: TMRB0LMT (Bit 16)                        */
#define CTIMER_AUX0_TMRB0LMT_Msk          (0x3f0000UL)              /*!< CTIMER AUX0: TMRB0LMT (Bitfield-Mask: 0x3f)           */
#define CTIMER_AUX0_TMRA0EN23_Pos         (14UL)                    /*!< CTIMER AUX0: TMRA0EN23 (Bit 14)                       */
#define CTIMER_AUX0_TMRA0EN23_Msk         (0x4000UL)                /*!< CTIMER AUX0: TMRA0EN23 (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX0_TMRA0POL23_Pos        (13UL)                    /*!< CTIMER AUX0: TMRA0POL23 (Bit 13)                      */
#define CTIMER_AUX0_TMRA0POL23_Msk        (0x2000UL)                /*!< CTIMER AUX0: TMRA0POL23 (Bitfield-Mask: 0x01)         */
#define CTIMER_AUX0_TMRA0TINV_Pos         (12UL)                    /*!< CTIMER AUX0: TMRA0TINV (Bit 12)                       */
#define CTIMER_AUX0_TMRA0TINV_Msk         (0x1000UL)                /*!< CTIMER AUX0: TMRA0TINV (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX0_TMRA0NOSYNC_Pos       (11UL)                    /*!< CTIMER AUX0: TMRA0NOSYNC (Bit 11)                     */
#define CTIMER_AUX0_TMRA0NOSYNC_Msk       (0x800UL)                 /*!< CTIMER AUX0: TMRA0NOSYNC (Bitfield-Mask: 0x01)        */
#define CTIMER_AUX0_TMRA0TRIG_Pos         (7UL)                     /*!< CTIMER AUX0: TMRA0TRIG (Bit 7)                        */
#define CTIMER_AUX0_TMRA0TRIG_Msk         (0x780UL)                 /*!< CTIMER AUX0: TMRA0TRIG (Bitfield-Mask: 0x0f)          */
#define CTIMER_AUX0_TMRA0LMT_Pos          (0UL)                     /*!< CTIMER AUX0: TMRA0LMT (Bit 0)                         */
#define CTIMER_AUX0_TMRA0LMT_Msk          (0x7fUL)                  /*!< CTIMER AUX0: TMRA0LMT (Bitfield-Mask: 0x7f)           */
/* =========================================================  TMR1  ========================================================== */
#define CTIMER_TMR1_CTTMRB1_Pos           (16UL)                    /*!< CTIMER TMR1: CTTMRB1 (Bit 16)                         */
#define CTIMER_TMR1_CTTMRB1_Msk           (0xffff0000UL)            /*!< CTIMER TMR1: CTTMRB1 (Bitfield-Mask: 0xffff)          */
#define CTIMER_TMR1_CTTMRA1_Pos           (0UL)                     /*!< CTIMER TMR1: CTTMRA1 (Bit 0)                          */
#define CTIMER_TMR1_CTTMRA1_Msk           (0xffffUL)                /*!< CTIMER TMR1: CTTMRA1 (Bitfield-Mask: 0xffff)          */
/* ========================================================  CMPRA1  ========================================================= */
#define CTIMER_CMPRA1_CMPR1A1_Pos         (16UL)                    /*!< CTIMER CMPRA1: CMPR1A1 (Bit 16)                       */
#define CTIMER_CMPRA1_CMPR1A1_Msk         (0xffff0000UL)            /*!< CTIMER CMPRA1: CMPR1A1 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRA1_CMPR0A1_Pos         (0UL)                     /*!< CTIMER CMPRA1: CMPR0A1 (Bit 0)                        */
#define CTIMER_CMPRA1_CMPR0A1_Msk         (0xffffUL)                /*!< CTIMER CMPRA1: CMPR0A1 (Bitfield-Mask: 0xffff)        */
/* ========================================================  CMPRB1  ========================================================= */
#define CTIMER_CMPRB1_CMPR1B1_Pos         (16UL)                    /*!< CTIMER CMPRB1: CMPR1B1 (Bit 16)                       */
#define CTIMER_CMPRB1_CMPR1B1_Msk         (0xffff0000UL)            /*!< CTIMER CMPRB1: CMPR1B1 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRB1_CMPR0B1_Pos         (0UL)                     /*!< CTIMER CMPRB1: CMPR0B1 (Bit 0)                        */
#define CTIMER_CMPRB1_CMPR0B1_Msk         (0xffffUL)                /*!< CTIMER CMPRB1: CMPR0B1 (Bitfield-Mask: 0xffff)        */
/* =========================================================  CTRL1  ========================================================= */
#define CTIMER_CTRL1_CTLINK1_Pos          (31UL)                    /*!< CTIMER CTRL1: CTLINK1 (Bit 31)                        */
#define CTIMER_CTRL1_CTLINK1_Msk          (0x80000000UL)            /*!< CTIMER CTRL1: CTLINK1 (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL1_TMRB1POL_Pos         (28UL)                    /*!< CTIMER CTRL1: TMRB1POL (Bit 28)                       */
#define CTIMER_CTRL1_TMRB1POL_Msk         (0x10000000UL)            /*!< CTIMER CTRL1: TMRB1POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRB1CLR_Pos         (27UL)                    /*!< CTIMER CTRL1: TMRB1CLR (Bit 27)                       */
#define CTIMER_CTRL1_TMRB1CLR_Msk         (0x8000000UL)             /*!< CTIMER CTRL1: TMRB1CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRB1IE1_Pos         (26UL)                    /*!< CTIMER CTRL1: TMRB1IE1 (Bit 26)                       */
#define CTIMER_CTRL1_TMRB1IE1_Msk         (0x4000000UL)             /*!< CTIMER CTRL1: TMRB1IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRB1IE0_Pos         (25UL)                    /*!< CTIMER CTRL1: TMRB1IE0 (Bit 25)                       */
#define CTIMER_CTRL1_TMRB1IE0_Msk         (0x2000000UL)             /*!< CTIMER CTRL1: TMRB1IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRB1FN_Pos          (22UL)                    /*!< CTIMER CTRL1: TMRB1FN (Bit 22)                        */
#define CTIMER_CTRL1_TMRB1FN_Msk          (0x1c00000UL)             /*!< CTIMER CTRL1: TMRB1FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL1_TMRB1CLK_Pos         (17UL)                    /*!< CTIMER CTRL1: TMRB1CLK (Bit 17)                       */
#define CTIMER_CTRL1_TMRB1CLK_Msk         (0x3e0000UL)              /*!< CTIMER CTRL1: TMRB1CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL1_TMRB1EN_Pos          (16UL)                    /*!< CTIMER CTRL1: TMRB1EN (Bit 16)                        */
#define CTIMER_CTRL1_TMRB1EN_Msk          (0x10000UL)               /*!< CTIMER CTRL1: TMRB1EN (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL1_TMRA1POL_Pos         (12UL)                    /*!< CTIMER CTRL1: TMRA1POL (Bit 12)                       */
#define CTIMER_CTRL1_TMRA1POL_Msk         (0x1000UL)                /*!< CTIMER CTRL1: TMRA1POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRA1CLR_Pos         (11UL)                    /*!< CTIMER CTRL1: TMRA1CLR (Bit 11)                       */
#define CTIMER_CTRL1_TMRA1CLR_Msk         (0x800UL)                 /*!< CTIMER CTRL1: TMRA1CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRA1IE1_Pos         (10UL)                    /*!< CTIMER CTRL1: TMRA1IE1 (Bit 10)                       */
#define CTIMER_CTRL1_TMRA1IE1_Msk         (0x400UL)                 /*!< CTIMER CTRL1: TMRA1IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRA1IE0_Pos         (9UL)                     /*!< CTIMER CTRL1: TMRA1IE0 (Bit 9)                        */
#define CTIMER_CTRL1_TMRA1IE0_Msk         (0x200UL)                 /*!< CTIMER CTRL1: TMRA1IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRA1FN_Pos          (6UL)                     /*!< CTIMER CTRL1: TMRA1FN (Bit 6)                         */
#define CTIMER_CTRL1_TMRA1FN_Msk          (0x1c0UL)                 /*!< CTIMER CTRL1: TMRA1FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL1_TMRA1CLK_Pos         (1UL)                     /*!< CTIMER CTRL1: TMRA1CLK (Bit 1)                        */
#define CTIMER_CTRL1_TMRA1CLK_Msk         (0x3eUL)                  /*!< CTIMER CTRL1: TMRA1CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL1_TMRA1EN_Pos          (0UL)                     /*!< CTIMER CTRL1: TMRA1EN (Bit 0)                         */
#define CTIMER_CTRL1_TMRA1EN_Msk          (0x1UL)                   /*!< CTIMER CTRL1: TMRA1EN (Bitfield-Mask: 0x01)           */
/* =======================================================  CMPRAUXA1  ======================================================= */
#define CTIMER_CMPRAUXA1_CMPR3A1_Pos      (16UL)                    /*!< CTIMER CMPRAUXA1: CMPR3A1 (Bit 16)                    */
#define CTIMER_CMPRAUXA1_CMPR3A1_Msk      (0xffff0000UL)            /*!< CTIMER CMPRAUXA1: CMPR3A1 (Bitfield-Mask: 0xffff)     */
#define CTIMER_CMPRAUXA1_CMPR2A1_Pos      (0UL)                     /*!< CTIMER CMPRAUXA1: CMPR2A1 (Bit 0)                     */
#define CTIMER_CMPRAUXA1_CMPR2A1_Msk      (0xffffUL)                /*!< CTIMER CMPRAUXA1: CMPR2A1 (Bitfield-Mask: 0xffff)     */
/* =======================================================  CMPRAUXB1  ======================================================= */
#define CTIMER_CMPRAUXB1_CMPR3B1_Pos      (16UL)                    /*!< CTIMER CMPRAUXB1: CMPR3B1 (Bit 16)                    */
#define CTIMER_CMPRAUXB1_CMPR3B1_Msk      (0xffff0000UL)            /*!< CTIMER CMPRAUXB1: CMPR3B1 (Bitfield-Mask: 0xffff)     */
#define CTIMER_CMPRAUXB1_CMPR2B1_Pos      (0UL)                     /*!< CTIMER CMPRAUXB1: CMPR2B1 (Bit 0)                     */
#define CTIMER_CMPRAUXB1_CMPR2B1_Msk      (0xffffUL)                /*!< CTIMER CMPRAUXB1: CMPR2B1 (Bitfield-Mask: 0xffff)     */
/* =========================================================  AUX1  ========================================================== */
#define CTIMER_AUX1_TMRB1EN23_Pos         (30UL)                    /*!< CTIMER AUX1: TMRB1EN23 (Bit 30)                       */
#define CTIMER_AUX1_TMRB1EN23_Msk         (0x40000000UL)            /*!< CTIMER AUX1: TMRB1EN23 (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX1_TMRB1POL23_Pos        (29UL)                    /*!< CTIMER AUX1: TMRB1POL23 (Bit 29)                      */
#define CTIMER_AUX1_TMRB1POL23_Msk        (0x20000000UL)            /*!< CTIMER AUX1: TMRB1POL23 (Bitfield-Mask: 0x01)         */
#define CTIMER_AUX1_TMRB1TINV_Pos         (28UL)                    /*!< CTIMER AUX1: TMRB1TINV (Bit 28)                       */
#define CTIMER_AUX1_TMRB1TINV_Msk         (0x10000000UL)            /*!< CTIMER AUX1: TMRB1TINV (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX1_TMRB1NOSYNC_Pos       (27UL)                    /*!< CTIMER AUX1: TMRB1NOSYNC (Bit 27)                     */
#define CTIMER_AUX1_TMRB1NOSYNC_Msk       (0x8000000UL)             /*!< CTIMER AUX1: TMRB1NOSYNC (Bitfield-Mask: 0x01)        */
#define CTIMER_AUX1_TMRB1TRIG_Pos         (23UL)                    /*!< CTIMER AUX1: TMRB1TRIG (Bit 23)                       */
#define CTIMER_AUX1_TMRB1TRIG_Msk         (0x7800000UL)             /*!< CTIMER AUX1: TMRB1TRIG (Bitfield-Mask: 0x0f)          */
#define CTIMER_AUX1_TMRB1LMT_Pos          (16UL)                    /*!< CTIMER AUX1: TMRB1LMT (Bit 16)                        */
#define CTIMER_AUX1_TMRB1LMT_Msk          (0x3f0000UL)              /*!< CTIMER AUX1: TMRB1LMT (Bitfield-Mask: 0x3f)           */
#define CTIMER_AUX1_TMRA1EN23_Pos         (14UL)                    /*!< CTIMER AUX1: TMRA1EN23 (Bit 14)                       */
#define CTIMER_AUX1_TMRA1EN23_Msk         (0x4000UL)                /*!< CTIMER AUX1: TMRA1EN23 (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX1_TMRA1POL23_Pos        (13UL)                    /*!< CTIMER AUX1: TMRA1POL23 (Bit 13)                      */
#define CTIMER_AUX1_TMRA1POL23_Msk        (0x2000UL)                /*!< CTIMER AUX1: TMRA1POL23 (Bitfield-Mask: 0x01)         */
#define CTIMER_AUX1_TMRA1TINV_Pos         (12UL)                    /*!< CTIMER AUX1: TMRA1TINV (Bit 12)                       */
#define CTIMER_AUX1_TMRA1TINV_Msk         (0x1000UL)                /*!< CTIMER AUX1: TMRA1TINV (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX1_TMRA1NOSYNC_Pos       (11UL)                    /*!< CTIMER AUX1: TMRA1NOSYNC (Bit 11)                     */
#define CTIMER_AUX1_TMRA1NOSYNC_Msk       (0x800UL)                 /*!< CTIMER AUX1: TMRA1NOSYNC (Bitfield-Mask: 0x01)        */
#define CTIMER_AUX1_TMRA1TRIG_Pos         (7UL)                     /*!< CTIMER AUX1: TMRA1TRIG (Bit 7)                        */
#define CTIMER_AUX1_TMRA1TRIG_Msk         (0x780UL)                 /*!< CTIMER AUX1: TMRA1TRIG (Bitfield-Mask: 0x0f)          */
#define CTIMER_AUX1_TMRA1LMT_Pos          (0UL)                     /*!< CTIMER AUX1: TMRA1LMT (Bit 0)                         */
#define CTIMER_AUX1_TMRA1LMT_Msk          (0x7fUL)                  /*!< CTIMER AUX1: TMRA1LMT (Bitfield-Mask: 0x7f)           */
/* =========================================================  TMR2  ========================================================== */
#define CTIMER_TMR2_CTTMRB2_Pos           (16UL)                    /*!< CTIMER TMR2: CTTMRB2 (Bit 16)                         */
#define CTIMER_TMR2_CTTMRB2_Msk           (0xffff0000UL)            /*!< CTIMER TMR2: CTTMRB2 (Bitfield-Mask: 0xffff)          */
#define CTIMER_TMR2_CTTMRA2_Pos           (0UL)                     /*!< CTIMER TMR2: CTTMRA2 (Bit 0)                          */
#define CTIMER_TMR2_CTTMRA2_Msk           (0xffffUL)                /*!< CTIMER TMR2: CTTMRA2 (Bitfield-Mask: 0xffff)          */
/* ========================================================  CMPRA2  ========================================================= */
#define CTIMER_CMPRA2_CMPR1A2_Pos         (16UL)                    /*!< CTIMER CMPRA2: CMPR1A2 (Bit 16)                       */
#define CTIMER_CMPRA2_CMPR1A2_Msk         (0xffff0000UL)            /*!< CTIMER CMPRA2: CMPR1A2 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRA2_CMPR0A2_Pos         (0UL)                     /*!< CTIMER CMPRA2: CMPR0A2 (Bit 0)                        */
#define CTIMER_CMPRA2_CMPR0A2_Msk         (0xffffUL)                /*!< CTIMER CMPRA2: CMPR0A2 (Bitfield-Mask: 0xffff)        */
/* ========================================================  CMPRB2  ========================================================= */
#define CTIMER_CMPRB2_CMPR1B2_Pos         (16UL)                    /*!< CTIMER CMPRB2: CMPR1B2 (Bit 16)                       */
#define CTIMER_CMPRB2_CMPR1B2_Msk         (0xffff0000UL)            /*!< CTIMER CMPRB2: CMPR1B2 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRB2_CMPR0B2_Pos         (0UL)                     /*!< CTIMER CMPRB2: CMPR0B2 (Bit 0)                        */
#define CTIMER_CMPRB2_CMPR0B2_Msk         (0xffffUL)                /*!< CTIMER CMPRB2: CMPR0B2 (Bitfield-Mask: 0xffff)        */
/* =========================================================  CTRL2  ========================================================= */
#define CTIMER_CTRL2_CTLINK2_Pos          (31UL)                    /*!< CTIMER CTRL2: CTLINK2 (Bit 31)                        */
#define CTIMER_CTRL2_CTLINK2_Msk          (0x80000000UL)            /*!< CTIMER CTRL2: CTLINK2 (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL2_TMRB2POL_Pos         (28UL)                    /*!< CTIMER CTRL2: TMRB2POL (Bit 28)                       */
#define CTIMER_CTRL2_TMRB2POL_Msk         (0x10000000UL)            /*!< CTIMER CTRL2: TMRB2POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRB2CLR_Pos         (27UL)                    /*!< CTIMER CTRL2: TMRB2CLR (Bit 27)                       */
#define CTIMER_CTRL2_TMRB2CLR_Msk         (0x8000000UL)             /*!< CTIMER CTRL2: TMRB2CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRB2IE1_Pos         (26UL)                    /*!< CTIMER CTRL2: TMRB2IE1 (Bit 26)                       */
#define CTIMER_CTRL2_TMRB2IE1_Msk         (0x4000000UL)             /*!< CTIMER CTRL2: TMRB2IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRB2IE0_Pos         (25UL)                    /*!< CTIMER CTRL2: TMRB2IE0 (Bit 25)                       */
#define CTIMER_CTRL2_TMRB2IE0_Msk         (0x2000000UL)             /*!< CTIMER CTRL2: TMRB2IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRB2FN_Pos          (22UL)                    /*!< CTIMER CTRL2: TMRB2FN (Bit 22)                        */
#define CTIMER_CTRL2_TMRB2FN_Msk          (0x1c00000UL)             /*!< CTIMER CTRL2: TMRB2FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL2_TMRB2CLK_Pos         (17UL)                    /*!< CTIMER CTRL2: TMRB2CLK (Bit 17)                       */
#define CTIMER_CTRL2_TMRB2CLK_Msk         (0x3e0000UL)              /*!< CTIMER CTRL2: TMRB2CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL2_TMRB2EN_Pos          (16UL)                    /*!< CTIMER CTRL2: TMRB2EN (Bit 16)                        */
#define CTIMER_CTRL2_TMRB2EN_Msk          (0x10000UL)               /*!< CTIMER CTRL2: TMRB2EN (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL2_TMRA2POL_Pos         (12UL)                    /*!< CTIMER CTRL2: TMRA2POL (Bit 12)                       */
#define CTIMER_CTRL2_TMRA2POL_Msk         (0x1000UL)                /*!< CTIMER CTRL2: TMRA2POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRA2CLR_Pos         (11UL)                    /*!< CTIMER CTRL2: TMRA2CLR (Bit 11)                       */
#define CTIMER_CTRL2_TMRA2CLR_Msk         (0x800UL)                 /*!< CTIMER CTRL2: TMRA2CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRA2IE1_Pos         (10UL)                    /*!< CTIMER CTRL2: TMRA2IE1 (Bit 10)                       */
#define CTIMER_CTRL2_TMRA2IE1_Msk         (0x400UL)                 /*!< CTIMER CTRL2: TMRA2IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRA2IE0_Pos         (9UL)                     /*!< CTIMER CTRL2: TMRA2IE0 (Bit 9)                        */
#define CTIMER_CTRL2_TMRA2IE0_Msk         (0x200UL)                 /*!< CTIMER CTRL2: TMRA2IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRA2FN_Pos          (6UL)                     /*!< CTIMER CTRL2: TMRA2FN (Bit 6)                         */
#define CTIMER_CTRL2_TMRA2FN_Msk          (0x1c0UL)                 /*!< CTIMER CTRL2: TMRA2FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL2_TMRA2CLK_Pos         (1UL)                     /*!< CTIMER CTRL2: TMRA2CLK (Bit 1)                        */
#define CTIMER_CTRL2_TMRA2CLK_Msk         (0x3eUL)                  /*!< CTIMER CTRL2: TMRA2CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL2_TMRA2EN_Pos          (0UL)                     /*!< CTIMER CTRL2: TMRA2EN (Bit 0)                         */
#define CTIMER_CTRL2_TMRA2EN_Msk          (0x1UL)                   /*!< CTIMER CTRL2: TMRA2EN (Bitfield-Mask: 0x01)           */
/* =======================================================  CMPRAUXA2  ======================================================= */
#define CTIMER_CMPRAUXA2_CMPR3A2_Pos      (16UL)                    /*!< CTIMER CMPRAUXA2: CMPR3A2 (Bit 16)                    */
#define CTIMER_CMPRAUXA2_CMPR3A2_Msk      (0xffff0000UL)            /*!< CTIMER CMPRAUXA2: CMPR3A2 (Bitfield-Mask: 0xffff)     */
#define CTIMER_CMPRAUXA2_CMPR2A2_Pos      (0UL)                     /*!< CTIMER CMPRAUXA2: CMPR2A2 (Bit 0)                     */
#define CTIMER_CMPRAUXA2_CMPR2A2_Msk      (0xffffUL)                /*!< CTIMER CMPRAUXA2: CMPR2A2 (Bitfield-Mask: 0xffff)     */
/* =======================================================  CMPRAUXB2  ======================================================= */
#define CTIMER_CMPRAUXB2_CMPR3B2_Pos      (16UL)                    /*!< CTIMER CMPRAUXB2: CMPR3B2 (Bit 16)                    */
#define CTIMER_CMPRAUXB2_CMPR3B2_Msk      (0xffff0000UL)            /*!< CTIMER CMPRAUXB2: CMPR3B2 (Bitfield-Mask: 0xffff)     */
#define CTIMER_CMPRAUXB2_CMPR2B2_Pos      (0UL)                     /*!< CTIMER CMPRAUXB2: CMPR2B2 (Bit 0)                     */
#define CTIMER_CMPRAUXB2_CMPR2B2_Msk      (0xffffUL)                /*!< CTIMER CMPRAUXB2: CMPR2B2 (Bitfield-Mask: 0xffff)     */
/* =========================================================  AUX2  ========================================================== */
#define CTIMER_AUX2_TMRB2EN23_Pos         (30UL)                    /*!< CTIMER AUX2: TMRB2EN23 (Bit 30)                       */
#define CTIMER_AUX2_TMRB2EN23_Msk         (0x40000000UL)            /*!< CTIMER AUX2: TMRB2EN23 (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX2_TMRB2POL23_Pos        (29UL)                    /*!< CTIMER AUX2: TMRB2POL23 (Bit 29)                      */
#define CTIMER_AUX2_TMRB2POL23_Msk        (0x20000000UL)            /*!< CTIMER AUX2: TMRB2POL23 (Bitfield-Mask: 0x01)         */
#define CTIMER_AUX2_TMRB2TINV_Pos         (28UL)                    /*!< CTIMER AUX2: TMRB2TINV (Bit 28)                       */
#define CTIMER_AUX2_TMRB2TINV_Msk         (0x10000000UL)            /*!< CTIMER AUX2: TMRB2TINV (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX2_TMRB2NOSYNC_Pos       (27UL)                    /*!< CTIMER AUX2: TMRB2NOSYNC (Bit 27)                     */
#define CTIMER_AUX2_TMRB2NOSYNC_Msk       (0x8000000UL)             /*!< CTIMER AUX2: TMRB2NOSYNC (Bitfield-Mask: 0x01)        */
#define CTIMER_AUX2_TMRB2TRIG_Pos         (23UL)                    /*!< CTIMER AUX2: TMRB2TRIG (Bit 23)                       */
#define CTIMER_AUX2_TMRB2TRIG_Msk         (0x7800000UL)             /*!< CTIMER AUX2: TMRB2TRIG (Bitfield-Mask: 0x0f)          */
#define CTIMER_AUX2_TMRB2LMT_Pos          (16UL)                    /*!< CTIMER AUX2: TMRB2LMT (Bit 16)                        */
#define CTIMER_AUX2_TMRB2LMT_Msk          (0x3f0000UL)              /*!< CTIMER AUX2: TMRB2LMT (Bitfield-Mask: 0x3f)           */
#define CTIMER_AUX2_TMRA2EN23_Pos         (14UL)                    /*!< CTIMER AUX2: TMRA2EN23 (Bit 14)                       */
#define CTIMER_AUX2_TMRA2EN23_Msk         (0x4000UL)                /*!< CTIMER AUX2: TMRA2EN23 (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX2_TMRA2POL23_Pos        (13UL)                    /*!< CTIMER AUX2: TMRA2POL23 (Bit 13)                      */
#define CTIMER_AUX2_TMRA2POL23_Msk        (0x2000UL)                /*!< CTIMER AUX2: TMRA2POL23 (Bitfield-Mask: 0x01)         */
#define CTIMER_AUX2_TMRA2TINV_Pos         (12UL)                    /*!< CTIMER AUX2: TMRA2TINV (Bit 12)                       */
#define CTIMER_AUX2_TMRA2TINV_Msk         (0x1000UL)                /*!< CTIMER AUX2: TMRA2TINV (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX2_TMRA2NOSYNC_Pos       (11UL)                    /*!< CTIMER AUX2: TMRA2NOSYNC (Bit 11)                     */
#define CTIMER_AUX2_TMRA2NOSYNC_Msk       (0x800UL)                 /*!< CTIMER AUX2: TMRA2NOSYNC (Bitfield-Mask: 0x01)        */
#define CTIMER_AUX2_TMRA2TRIG_Pos         (7UL)                     /*!< CTIMER AUX2: TMRA2TRIG (Bit 7)                        */
#define CTIMER_AUX2_TMRA2TRIG_Msk         (0x780UL)                 /*!< CTIMER AUX2: TMRA2TRIG (Bitfield-Mask: 0x0f)          */
#define CTIMER_AUX2_TMRA2LMT_Pos          (0UL)                     /*!< CTIMER AUX2: TMRA2LMT (Bit 0)                         */
#define CTIMER_AUX2_TMRA2LMT_Msk          (0x7fUL)                  /*!< CTIMER AUX2: TMRA2LMT (Bitfield-Mask: 0x7f)           */
/* =========================================================  TMR3  ========================================================== */
#define CTIMER_TMR3_CTTMRB3_Pos           (16UL)                    /*!< CTIMER TMR3: CTTMRB3 (Bit 16)                         */
#define CTIMER_TMR3_CTTMRB3_Msk           (0xffff0000UL)            /*!< CTIMER TMR3: CTTMRB3 (Bitfield-Mask: 0xffff)          */
#define CTIMER_TMR3_CTTMRA3_Pos           (0UL)                     /*!< CTIMER TMR3: CTTMRA3 (Bit 0)                          */
#define CTIMER_TMR3_CTTMRA3_Msk           (0xffffUL)                /*!< CTIMER TMR3: CTTMRA3 (Bitfield-Mask: 0xffff)          */
/* ========================================================  CMPRA3  ========================================================= */
#define CTIMER_CMPRA3_CMPR1A3_Pos         (16UL)                    /*!< CTIMER CMPRA3: CMPR1A3 (Bit 16)                       */
#define CTIMER_CMPRA3_CMPR1A3_Msk         (0xffff0000UL)            /*!< CTIMER CMPRA3: CMPR1A3 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRA3_CMPR0A3_Pos         (0UL)                     /*!< CTIMER CMPRA3: CMPR0A3 (Bit 0)                        */
#define CTIMER_CMPRA3_CMPR0A3_Msk         (0xffffUL)                /*!< CTIMER CMPRA3: CMPR0A3 (Bitfield-Mask: 0xffff)        */
/* ========================================================  CMPRB3  ========================================================= */
#define CTIMER_CMPRB3_CMPR1B3_Pos         (16UL)                    /*!< CTIMER CMPRB3: CMPR1B3 (Bit 16)                       */
#define CTIMER_CMPRB3_CMPR1B3_Msk         (0xffff0000UL)            /*!< CTIMER CMPRB3: CMPR1B3 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRB3_CMPR0B3_Pos         (0UL)                     /*!< CTIMER CMPRB3: CMPR0B3 (Bit 0)                        */
#define CTIMER_CMPRB3_CMPR0B3_Msk         (0xffffUL)                /*!< CTIMER CMPRB3: CMPR0B3 (Bitfield-Mask: 0xffff)        */
/* =========================================================  CTRL3  ========================================================= */
#define CTIMER_CTRL3_CTLINK3_Pos          (31UL)                    /*!< CTIMER CTRL3: CTLINK3 (Bit 31)                        */
#define CTIMER_CTRL3_CTLINK3_Msk          (0x80000000UL)            /*!< CTIMER CTRL3: CTLINK3 (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL3_TMRB3POL_Pos         (28UL)                    /*!< CTIMER CTRL3: TMRB3POL (Bit 28)                       */
#define CTIMER_CTRL3_TMRB3POL_Msk         (0x10000000UL)            /*!< CTIMER CTRL3: TMRB3POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRB3CLR_Pos         (27UL)                    /*!< CTIMER CTRL3: TMRB3CLR (Bit 27)                       */
#define CTIMER_CTRL3_TMRB3CLR_Msk         (0x8000000UL)             /*!< CTIMER CTRL3: TMRB3CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRB3IE1_Pos         (26UL)                    /*!< CTIMER CTRL3: TMRB3IE1 (Bit 26)                       */
#define CTIMER_CTRL3_TMRB3IE1_Msk         (0x4000000UL)             /*!< CTIMER CTRL3: TMRB3IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRB3IE0_Pos         (25UL)                    /*!< CTIMER CTRL3: TMRB3IE0 (Bit 25)                       */
#define CTIMER_CTRL3_TMRB3IE0_Msk         (0x2000000UL)             /*!< CTIMER CTRL3: TMRB3IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRB3FN_Pos          (22UL)                    /*!< CTIMER CTRL3: TMRB3FN (Bit 22)                        */
#define CTIMER_CTRL3_TMRB3FN_Msk          (0x1c00000UL)             /*!< CTIMER CTRL3: TMRB3FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL3_TMRB3CLK_Pos         (17UL)                    /*!< CTIMER CTRL3: TMRB3CLK (Bit 17)                       */
#define CTIMER_CTRL3_TMRB3CLK_Msk         (0x3e0000UL)              /*!< CTIMER CTRL3: TMRB3CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL3_TMRB3EN_Pos          (16UL)                    /*!< CTIMER CTRL3: TMRB3EN (Bit 16)                        */
#define CTIMER_CTRL3_TMRB3EN_Msk          (0x10000UL)               /*!< CTIMER CTRL3: TMRB3EN (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL3_ADCEN_Pos            (15UL)                    /*!< CTIMER CTRL3: ADCEN (Bit 15)                          */
#define CTIMER_CTRL3_ADCEN_Msk            (0x8000UL)                /*!< CTIMER CTRL3: ADCEN (Bitfield-Mask: 0x01)             */
#define CTIMER_CTRL3_TMRA3POL_Pos         (12UL)                    /*!< CTIMER CTRL3: TMRA3POL (Bit 12)                       */
#define CTIMER_CTRL3_TMRA3POL_Msk         (0x1000UL)                /*!< CTIMER CTRL3: TMRA3POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRA3CLR_Pos         (11UL)                    /*!< CTIMER CTRL3: TMRA3CLR (Bit 11)                       */
#define CTIMER_CTRL3_TMRA3CLR_Msk         (0x800UL)                 /*!< CTIMER CTRL3: TMRA3CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRA3IE1_Pos         (10UL)                    /*!< CTIMER CTRL3: TMRA3IE1 (Bit 10)                       */
#define CTIMER_CTRL3_TMRA3IE1_Msk         (0x400UL)                 /*!< CTIMER CTRL3: TMRA3IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRA3IE0_Pos         (9UL)                     /*!< CTIMER CTRL3: TMRA3IE0 (Bit 9)                        */
#define CTIMER_CTRL3_TMRA3IE0_Msk         (0x200UL)                 /*!< CTIMER CTRL3: TMRA3IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRA3FN_Pos          (6UL)                     /*!< CTIMER CTRL3: TMRA3FN (Bit 6)                         */
#define CTIMER_CTRL3_TMRA3FN_Msk          (0x1c0UL)                 /*!< CTIMER CTRL3: TMRA3FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL3_TMRA3CLK_Pos         (1UL)                     /*!< CTIMER CTRL3: TMRA3CLK (Bit 1)                        */
#define CTIMER_CTRL3_TMRA3CLK_Msk         (0x3eUL)                  /*!< CTIMER CTRL3: TMRA3CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL3_TMRA3EN_Pos          (0UL)                     /*!< CTIMER CTRL3: TMRA3EN (Bit 0)                         */
#define CTIMER_CTRL3_TMRA3EN_Msk          (0x1UL)                   /*!< CTIMER CTRL3: TMRA3EN (Bitfield-Mask: 0x01)           */
/* =======================================================  CMPRAUXA3  ======================================================= */
#define CTIMER_CMPRAUXA3_CMPR3A3_Pos      (16UL)                    /*!< CTIMER CMPRAUXA3: CMPR3A3 (Bit 16)                    */
#define CTIMER_CMPRAUXA3_CMPR3A3_Msk      (0xffff0000UL)            /*!< CTIMER CMPRAUXA3: CMPR3A3 (Bitfield-Mask: 0xffff)     */
#define CTIMER_CMPRAUXA3_CMPR2A3_Pos      (0UL)                     /*!< CTIMER CMPRAUXA3: CMPR2A3 (Bit 0)                     */
#define CTIMER_CMPRAUXA3_CMPR2A3_Msk      (0xffffUL)                /*!< CTIMER CMPRAUXA3: CMPR2A3 (Bitfield-Mask: 0xffff)     */
/* =======================================================  CMPRAUXB3  ======================================================= */
#define CTIMER_CMPRAUXB3_CMPR3B3_Pos      (16UL)                    /*!< CTIMER CMPRAUXB3: CMPR3B3 (Bit 16)                    */
#define CTIMER_CMPRAUXB3_CMPR3B3_Msk      (0xffff0000UL)            /*!< CTIMER CMPRAUXB3: CMPR3B3 (Bitfield-Mask: 0xffff)     */
#define CTIMER_CMPRAUXB3_CMPR2B3_Pos      (0UL)                     /*!< CTIMER CMPRAUXB3: CMPR2B3 (Bit 0)                     */
#define CTIMER_CMPRAUXB3_CMPR2B3_Msk      (0xffffUL)                /*!< CTIMER CMPRAUXB3: CMPR2B3 (Bitfield-Mask: 0xffff)     */
/* =========================================================  AUX3  ========================================================== */
#define CTIMER_AUX3_TMRB3EN23_Pos         (30UL)                    /*!< CTIMER AUX3: TMRB3EN23 (Bit 30)                       */
#define CTIMER_AUX3_TMRB3EN23_Msk         (0x40000000UL)            /*!< CTIMER AUX3: TMRB3EN23 (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX3_TMRB3POL23_Pos        (29UL)                    /*!< CTIMER AUX3: TMRB3POL23 (Bit 29)                      */
#define CTIMER_AUX3_TMRB3POL23_Msk        (0x20000000UL)            /*!< CTIMER AUX3: TMRB3POL23 (Bitfield-Mask: 0x01)         */
#define CTIMER_AUX3_TMRB3TINV_Pos         (28UL)                    /*!< CTIMER AUX3: TMRB3TINV (Bit 28)                       */
#define CTIMER_AUX3_TMRB3TINV_Msk         (0x10000000UL)            /*!< CTIMER AUX3: TMRB3TINV (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX3_TMRB3NOSYNC_Pos       (27UL)                    /*!< CTIMER AUX3: TMRB3NOSYNC (Bit 27)                     */
#define CTIMER_AUX3_TMRB3NOSYNC_Msk       (0x8000000UL)             /*!< CTIMER AUX3: TMRB3NOSYNC (Bitfield-Mask: 0x01)        */
#define CTIMER_AUX3_TMRB3TRIG_Pos         (23UL)                    /*!< CTIMER AUX3: TMRB3TRIG (Bit 23)                       */
#define CTIMER_AUX3_TMRB3TRIG_Msk         (0x7800000UL)             /*!< CTIMER AUX3: TMRB3TRIG (Bitfield-Mask: 0x0f)          */
#define CTIMER_AUX3_TMRB3LMT_Pos          (16UL)                    /*!< CTIMER AUX3: TMRB3LMT (Bit 16)                        */
#define CTIMER_AUX3_TMRB3LMT_Msk          (0x3f0000UL)              /*!< CTIMER AUX3: TMRB3LMT (Bitfield-Mask: 0x3f)           */
#define CTIMER_AUX3_TMRA3EN23_Pos         (14UL)                    /*!< CTIMER AUX3: TMRA3EN23 (Bit 14)                       */
#define CTIMER_AUX3_TMRA3EN23_Msk         (0x4000UL)                /*!< CTIMER AUX3: TMRA3EN23 (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX3_TMRA3POL23_Pos        (13UL)                    /*!< CTIMER AUX3: TMRA3POL23 (Bit 13)                      */
#define CTIMER_AUX3_TMRA3POL23_Msk        (0x2000UL)                /*!< CTIMER AUX3: TMRA3POL23 (Bitfield-Mask: 0x01)         */
#define CTIMER_AUX3_TMRA3TINV_Pos         (12UL)                    /*!< CTIMER AUX3: TMRA3TINV (Bit 12)                       */
#define CTIMER_AUX3_TMRA3TINV_Msk         (0x1000UL)                /*!< CTIMER AUX3: TMRA3TINV (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX3_TMRA3NOSYNC_Pos       (11UL)                    /*!< CTIMER AUX3: TMRA3NOSYNC (Bit 11)                     */
#define CTIMER_AUX3_TMRA3NOSYNC_Msk       (0x800UL)                 /*!< CTIMER AUX3: TMRA3NOSYNC (Bitfield-Mask: 0x01)        */
#define CTIMER_AUX3_TMRA3TRIG_Pos         (7UL)                     /*!< CTIMER AUX3: TMRA3TRIG (Bit 7)                        */
#define CTIMER_AUX3_TMRA3TRIG_Msk         (0x780UL)                 /*!< CTIMER AUX3: TMRA3TRIG (Bitfield-Mask: 0x0f)          */
#define CTIMER_AUX3_TMRA3LMT_Pos          (0UL)                     /*!< CTIMER AUX3: TMRA3LMT (Bit 0)                         */
#define CTIMER_AUX3_TMRA3LMT_Msk          (0x7fUL)                  /*!< CTIMER AUX3: TMRA3LMT (Bitfield-Mask: 0x7f)           */
/* =========================================================  TMR4  ========================================================== */
#define CTIMER_TMR4_CTTMRB4_Pos           (16UL)                    /*!< CTIMER TMR4: CTTMRB4 (Bit 16)                         */
#define CTIMER_TMR4_CTTMRB4_Msk           (0xffff0000UL)            /*!< CTIMER TMR4: CTTMRB4 (Bitfield-Mask: 0xffff)          */
#define CTIMER_TMR4_CTTMRA4_Pos           (0UL)                     /*!< CTIMER TMR4: CTTMRA4 (Bit 0)                          */
#define CTIMER_TMR4_CTTMRA4_Msk           (0xffffUL)                /*!< CTIMER TMR4: CTTMRA4 (Bitfield-Mask: 0xffff)          */
/* ========================================================  CMPRA4  ========================================================= */
#define CTIMER_CMPRA4_CMPR1A4_Pos         (16UL)                    /*!< CTIMER CMPRA4: CMPR1A4 (Bit 16)                       */
#define CTIMER_CMPRA4_CMPR1A4_Msk         (0xffff0000UL)            /*!< CTIMER CMPRA4: CMPR1A4 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRA4_CMPR0A4_Pos         (0UL)                     /*!< CTIMER CMPRA4: CMPR0A4 (Bit 0)                        */
#define CTIMER_CMPRA4_CMPR0A4_Msk         (0xffffUL)                /*!< CTIMER CMPRA4: CMPR0A4 (Bitfield-Mask: 0xffff)        */
/* ========================================================  CMPRB4  ========================================================= */
#define CTIMER_CMPRB4_CMPR1B4_Pos         (16UL)                    /*!< CTIMER CMPRB4: CMPR1B4 (Bit 16)                       */
#define CTIMER_CMPRB4_CMPR1B4_Msk         (0xffff0000UL)            /*!< CTIMER CMPRB4: CMPR1B4 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRB4_CMPR0B4_Pos         (0UL)                     /*!< CTIMER CMPRB4: CMPR0B4 (Bit 0)                        */
#define CTIMER_CMPRB4_CMPR0B4_Msk         (0xffffUL)                /*!< CTIMER CMPRB4: CMPR0B4 (Bitfield-Mask: 0xffff)        */
/* =========================================================  CTRL4  ========================================================= */
#define CTIMER_CTRL4_CTLINK4_Pos          (31UL)                    /*!< CTIMER CTRL4: CTLINK4 (Bit 31)                        */
#define CTIMER_CTRL4_CTLINK4_Msk          (0x80000000UL)            /*!< CTIMER CTRL4: CTLINK4 (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL4_TMRB4POL_Pos         (28UL)                    /*!< CTIMER CTRL4: TMRB4POL (Bit 28)                       */
#define CTIMER_CTRL4_TMRB4POL_Msk         (0x10000000UL)            /*!< CTIMER CTRL4: TMRB4POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL4_TMRB4CLR_Pos         (27UL)                    /*!< CTIMER CTRL4: TMRB4CLR (Bit 27)                       */
#define CTIMER_CTRL4_TMRB4CLR_Msk         (0x8000000UL)             /*!< CTIMER CTRL4: TMRB4CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL4_TMRB4IE1_Pos         (26UL)                    /*!< CTIMER CTRL4: TMRB4IE1 (Bit 26)                       */
#define CTIMER_CTRL4_TMRB4IE1_Msk         (0x4000000UL)             /*!< CTIMER CTRL4: TMRB4IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL4_TMRB4IE0_Pos         (25UL)                    /*!< CTIMER CTRL4: TMRB4IE0 (Bit 25)                       */
#define CTIMER_CTRL4_TMRB4IE0_Msk         (0x2000000UL)             /*!< CTIMER CTRL4: TMRB4IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL4_TMRB4FN_Pos          (22UL)                    /*!< CTIMER CTRL4: TMRB4FN (Bit 22)                        */
#define CTIMER_CTRL4_TMRB4FN_Msk          (0x1c00000UL)             /*!< CTIMER CTRL4: TMRB4FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL4_TMRB4CLK_Pos         (17UL)                    /*!< CTIMER CTRL4: TMRB4CLK (Bit 17)                       */
#define CTIMER_CTRL4_TMRB4CLK_Msk         (0x3e0000UL)              /*!< CTIMER CTRL4: TMRB4CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL4_TMRB4EN_Pos          (16UL)                    /*!< CTIMER CTRL4: TMRB4EN (Bit 16)                        */
#define CTIMER_CTRL4_TMRB4EN_Msk          (0x10000UL)               /*!< CTIMER CTRL4: TMRB4EN (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL4_TMRA4POL_Pos         (12UL)                    /*!< CTIMER CTRL4: TMRA4POL (Bit 12)                       */
#define CTIMER_CTRL4_TMRA4POL_Msk         (0x1000UL)                /*!< CTIMER CTRL4: TMRA4POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL4_TMRA4CLR_Pos         (11UL)                    /*!< CTIMER CTRL4: TMRA4CLR (Bit 11)                       */
#define CTIMER_CTRL4_TMRA4CLR_Msk         (0x800UL)                 /*!< CTIMER CTRL4: TMRA4CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL4_TMRA4IE1_Pos         (10UL)                    /*!< CTIMER CTRL4: TMRA4IE1 (Bit 10)                       */
#define CTIMER_CTRL4_TMRA4IE1_Msk         (0x400UL)                 /*!< CTIMER CTRL4: TMRA4IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL4_TMRA4IE0_Pos         (9UL)                     /*!< CTIMER CTRL4: TMRA4IE0 (Bit 9)                        */
#define CTIMER_CTRL4_TMRA4IE0_Msk         (0x200UL)                 /*!< CTIMER CTRL4: TMRA4IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL4_TMRA4FN_Pos          (6UL)                     /*!< CTIMER CTRL4: TMRA4FN (Bit 6)                         */
#define CTIMER_CTRL4_TMRA4FN_Msk          (0x1c0UL)                 /*!< CTIMER CTRL4: TMRA4FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL4_TMRA4CLK_Pos         (1UL)                     /*!< CTIMER CTRL4: TMRA4CLK (Bit 1)                        */
#define CTIMER_CTRL4_TMRA4CLK_Msk         (0x3eUL)                  /*!< CTIMER CTRL4: TMRA4CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL4_TMRA4EN_Pos          (0UL)                     /*!< CTIMER CTRL4: TMRA4EN (Bit 0)                         */
#define CTIMER_CTRL4_TMRA4EN_Msk          (0x1UL)                   /*!< CTIMER CTRL4: TMRA4EN (Bitfield-Mask: 0x01)           */
/* =======================================================  CMPRAUXA4  ======================================================= */
#define CTIMER_CMPRAUXA4_CMPR3A4_Pos      (16UL)                    /*!< CTIMER CMPRAUXA4: CMPR3A4 (Bit 16)                    */
#define CTIMER_CMPRAUXA4_CMPR3A4_Msk      (0xffff0000UL)            /*!< CTIMER CMPRAUXA4: CMPR3A4 (Bitfield-Mask: 0xffff)     */
#define CTIMER_CMPRAUXA4_CMPR2A4_Pos      (0UL)                     /*!< CTIMER CMPRAUXA4: CMPR2A4 (Bit 0)                     */
#define CTIMER_CMPRAUXA4_CMPR2A4_Msk      (0xffffUL)                /*!< CTIMER CMPRAUXA4: CMPR2A4 (Bitfield-Mask: 0xffff)     */
/* =======================================================  CMPRAUXB4  ======================================================= */
#define CTIMER_CMPRAUXB4_CMPR3B4_Pos      (16UL)                    /*!< CTIMER CMPRAUXB4: CMPR3B4 (Bit 16)                    */
#define CTIMER_CMPRAUXB4_CMPR3B4_Msk      (0xffff0000UL)            /*!< CTIMER CMPRAUXB4: CMPR3B4 (Bitfield-Mask: 0xffff)     */
#define CTIMER_CMPRAUXB4_CMPR2B4_Pos      (0UL)                     /*!< CTIMER CMPRAUXB4: CMPR2B4 (Bit 0)                     */
#define CTIMER_CMPRAUXB4_CMPR2B4_Msk      (0xffffUL)                /*!< CTIMER CMPRAUXB4: CMPR2B4 (Bitfield-Mask: 0xffff)     */
/* =========================================================  AUX4  ========================================================== */
#define CTIMER_AUX4_TMRB4EN23_Pos         (30UL)                    /*!< CTIMER AUX4: TMRB4EN23 (Bit 30)                       */
#define CTIMER_AUX4_TMRB4EN23_Msk         (0x40000000UL)            /*!< CTIMER AUX4: TMRB4EN23 (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX4_TMRB4POL23_Pos        (29UL)                    /*!< CTIMER AUX4: TMRB4POL23 (Bit 29)                      */
#define CTIMER_AUX4_TMRB4POL23_Msk        (0x20000000UL)            /*!< CTIMER AUX4: TMRB4POL23 (Bitfield-Mask: 0x01)         */
#define CTIMER_AUX4_TMRB4TINV_Pos         (28UL)                    /*!< CTIMER AUX4: TMRB4TINV (Bit 28)                       */
#define CTIMER_AUX4_TMRB4TINV_Msk         (0x10000000UL)            /*!< CTIMER AUX4: TMRB4TINV (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX4_TMRB4NOSYNC_Pos       (27UL)                    /*!< CTIMER AUX4: TMRB4NOSYNC (Bit 27)                     */
#define CTIMER_AUX4_TMRB4NOSYNC_Msk       (0x8000000UL)             /*!< CTIMER AUX4: TMRB4NOSYNC (Bitfield-Mask: 0x01)        */
#define CTIMER_AUX4_TMRB4TRIG_Pos         (23UL)                    /*!< CTIMER AUX4: TMRB4TRIG (Bit 23)                       */
#define CTIMER_AUX4_TMRB4TRIG_Msk         (0x7800000UL)             /*!< CTIMER AUX4: TMRB4TRIG (Bitfield-Mask: 0x0f)          */
#define CTIMER_AUX4_TMRB4LMT_Pos          (16UL)                    /*!< CTIMER AUX4: TMRB4LMT (Bit 16)                        */
#define CTIMER_AUX4_TMRB4LMT_Msk          (0x3f0000UL)              /*!< CTIMER AUX4: TMRB4LMT (Bitfield-Mask: 0x3f)           */
#define CTIMER_AUX4_TMRA4EN23_Pos         (14UL)                    /*!< CTIMER AUX4: TMRA4EN23 (Bit 14)                       */
#define CTIMER_AUX4_TMRA4EN23_Msk         (0x4000UL)                /*!< CTIMER AUX4: TMRA4EN23 (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX4_TMRA4POL23_Pos        (13UL)                    /*!< CTIMER AUX4: TMRA4POL23 (Bit 13)                      */
#define CTIMER_AUX4_TMRA4POL23_Msk        (0x2000UL)                /*!< CTIMER AUX4: TMRA4POL23 (Bitfield-Mask: 0x01)         */
#define CTIMER_AUX4_TMRA4TINV_Pos         (12UL)                    /*!< CTIMER AUX4: TMRA4TINV (Bit 12)                       */
#define CTIMER_AUX4_TMRA4TINV_Msk         (0x1000UL)                /*!< CTIMER AUX4: TMRA4TINV (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX4_TMRA4NOSYNC_Pos       (11UL)                    /*!< CTIMER AUX4: TMRA4NOSYNC (Bit 11)                     */
#define CTIMER_AUX4_TMRA4NOSYNC_Msk       (0x800UL)                 /*!< CTIMER AUX4: TMRA4NOSYNC (Bitfield-Mask: 0x01)        */
#define CTIMER_AUX4_TMRA4TRIG_Pos         (7UL)                     /*!< CTIMER AUX4: TMRA4TRIG (Bit 7)                        */
#define CTIMER_AUX4_TMRA4TRIG_Msk         (0x780UL)                 /*!< CTIMER AUX4: TMRA4TRIG (Bitfield-Mask: 0x0f)          */
#define CTIMER_AUX4_TMRA4LMT_Pos          (0UL)                     /*!< CTIMER AUX4: TMRA4LMT (Bit 0)                         */
#define CTIMER_AUX4_TMRA4LMT_Msk          (0x7fUL)                  /*!< CTIMER AUX4: TMRA4LMT (Bitfield-Mask: 0x7f)           */
/* =========================================================  TMR5  ========================================================== */
#define CTIMER_TMR5_CTTMRB5_Pos           (16UL)                    /*!< CTIMER TMR5: CTTMRB5 (Bit 16)                         */
#define CTIMER_TMR5_CTTMRB5_Msk           (0xffff0000UL)            /*!< CTIMER TMR5: CTTMRB5 (Bitfield-Mask: 0xffff)          */
#define CTIMER_TMR5_CTTMRA5_Pos           (0UL)                     /*!< CTIMER TMR5: CTTMRA5 (Bit 0)                          */
#define CTIMER_TMR5_CTTMRA5_Msk           (0xffffUL)                /*!< CTIMER TMR5: CTTMRA5 (Bitfield-Mask: 0xffff)          */
/* ========================================================  CMPRA5  ========================================================= */
#define CTIMER_CMPRA5_CMPR1A5_Pos         (16UL)                    /*!< CTIMER CMPRA5: CMPR1A5 (Bit 16)                       */
#define CTIMER_CMPRA5_CMPR1A5_Msk         (0xffff0000UL)            /*!< CTIMER CMPRA5: CMPR1A5 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRA5_CMPR0A5_Pos         (0UL)                     /*!< CTIMER CMPRA5: CMPR0A5 (Bit 0)                        */
#define CTIMER_CMPRA5_CMPR0A5_Msk         (0xffffUL)                /*!< CTIMER CMPRA5: CMPR0A5 (Bitfield-Mask: 0xffff)        */
/* ========================================================  CMPRB5  ========================================================= */
#define CTIMER_CMPRB5_CMPR1B5_Pos         (16UL)                    /*!< CTIMER CMPRB5: CMPR1B5 (Bit 16)                       */
#define CTIMER_CMPRB5_CMPR1B5_Msk         (0xffff0000UL)            /*!< CTIMER CMPRB5: CMPR1B5 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRB5_CMPR0B5_Pos         (0UL)                     /*!< CTIMER CMPRB5: CMPR0B5 (Bit 0)                        */
#define CTIMER_CMPRB5_CMPR0B5_Msk         (0xffffUL)                /*!< CTIMER CMPRB5: CMPR0B5 (Bitfield-Mask: 0xffff)        */
/* =========================================================  CTRL5  ========================================================= */
#define CTIMER_CTRL5_CTLINK5_Pos          (31UL)                    /*!< CTIMER CTRL5: CTLINK5 (Bit 31)                        */
#define CTIMER_CTRL5_CTLINK5_Msk          (0x80000000UL)            /*!< CTIMER CTRL5: CTLINK5 (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL5_TMRB5POL_Pos         (28UL)                    /*!< CTIMER CTRL5: TMRB5POL (Bit 28)                       */
#define CTIMER_CTRL5_TMRB5POL_Msk         (0x10000000UL)            /*!< CTIMER CTRL5: TMRB5POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL5_TMRB5CLR_Pos         (27UL)                    /*!< CTIMER CTRL5: TMRB5CLR (Bit 27)                       */
#define CTIMER_CTRL5_TMRB5CLR_Msk         (0x8000000UL)             /*!< CTIMER CTRL5: TMRB5CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL5_TMRB5IE1_Pos         (26UL)                    /*!< CTIMER CTRL5: TMRB5IE1 (Bit 26)                       */
#define CTIMER_CTRL5_TMRB5IE1_Msk         (0x4000000UL)             /*!< CTIMER CTRL5: TMRB5IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL5_TMRB5IE0_Pos         (25UL)                    /*!< CTIMER CTRL5: TMRB5IE0 (Bit 25)                       */
#define CTIMER_CTRL5_TMRB5IE0_Msk         (0x2000000UL)             /*!< CTIMER CTRL5: TMRB5IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL5_TMRB5FN_Pos          (22UL)                    /*!< CTIMER CTRL5: TMRB5FN (Bit 22)                        */
#define CTIMER_CTRL5_TMRB5FN_Msk          (0x1c00000UL)             /*!< CTIMER CTRL5: TMRB5FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL5_TMRB5CLK_Pos         (17UL)                    /*!< CTIMER CTRL5: TMRB5CLK (Bit 17)                       */
#define CTIMER_CTRL5_TMRB5CLK_Msk         (0x3e0000UL)              /*!< CTIMER CTRL5: TMRB5CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL5_TMRB5EN_Pos          (16UL)                    /*!< CTIMER CTRL5: TMRB5EN (Bit 16)                        */
#define CTIMER_CTRL5_TMRB5EN_Msk          (0x10000UL)               /*!< CTIMER CTRL5: TMRB5EN (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL5_TMRA5POL_Pos         (12UL)                    /*!< CTIMER CTRL5: TMRA5POL (Bit 12)                       */
#define CTIMER_CTRL5_TMRA5POL_Msk         (0x1000UL)                /*!< CTIMER CTRL5: TMRA5POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL5_TMRA5CLR_Pos         (11UL)                    /*!< CTIMER CTRL5: TMRA5CLR (Bit 11)                       */
#define CTIMER_CTRL5_TMRA5CLR_Msk         (0x800UL)                 /*!< CTIMER CTRL5: TMRA5CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL5_TMRA5IE1_Pos         (10UL)                    /*!< CTIMER CTRL5: TMRA5IE1 (Bit 10)                       */
#define CTIMER_CTRL5_TMRA5IE1_Msk         (0x400UL)                 /*!< CTIMER CTRL5: TMRA5IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL5_TMRA5IE0_Pos         (9UL)                     /*!< CTIMER CTRL5: TMRA5IE0 (Bit 9)                        */
#define CTIMER_CTRL5_TMRA5IE0_Msk         (0x200UL)                 /*!< CTIMER CTRL5: TMRA5IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL5_TMRA5FN_Pos          (6UL)                     /*!< CTIMER CTRL5: TMRA5FN (Bit 6)                         */
#define CTIMER_CTRL5_TMRA5FN_Msk          (0x1c0UL)                 /*!< CTIMER CTRL5: TMRA5FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL5_TMRA5CLK_Pos         (1UL)                     /*!< CTIMER CTRL5: TMRA5CLK (Bit 1)                        */
#define CTIMER_CTRL5_TMRA5CLK_Msk         (0x3eUL)                  /*!< CTIMER CTRL5: TMRA5CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL5_TMRA5EN_Pos          (0UL)                     /*!< CTIMER CTRL5: TMRA5EN (Bit 0)                         */
#define CTIMER_CTRL5_TMRA5EN_Msk          (0x1UL)                   /*!< CTIMER CTRL5: TMRA5EN (Bitfield-Mask: 0x01)           */
/* =======================================================  CMPRAUXA5  ======================================================= */
#define CTIMER_CMPRAUXA5_CMPR3A5_Pos      (16UL)                    /*!< CTIMER CMPRAUXA5: CMPR3A5 (Bit 16)                    */
#define CTIMER_CMPRAUXA5_CMPR3A5_Msk      (0xffff0000UL)            /*!< CTIMER CMPRAUXA5: CMPR3A5 (Bitfield-Mask: 0xffff)     */
#define CTIMER_CMPRAUXA5_CMPR2A5_Pos      (0UL)                     /*!< CTIMER CMPRAUXA5: CMPR2A5 (Bit 0)                     */
#define CTIMER_CMPRAUXA5_CMPR2A5_Msk      (0xffffUL)                /*!< CTIMER CMPRAUXA5: CMPR2A5 (Bitfield-Mask: 0xffff)     */
/* =======================================================  CMPRAUXB5  ======================================================= */
#define CTIMER_CMPRAUXB5_CMPR3B5_Pos      (16UL)                    /*!< CTIMER CMPRAUXB5: CMPR3B5 (Bit 16)                    */
#define CTIMER_CMPRAUXB5_CMPR3B5_Msk      (0xffff0000UL)            /*!< CTIMER CMPRAUXB5: CMPR3B5 (Bitfield-Mask: 0xffff)     */
#define CTIMER_CMPRAUXB5_CMPR2B5_Pos      (0UL)                     /*!< CTIMER CMPRAUXB5: CMPR2B5 (Bit 0)                     */
#define CTIMER_CMPRAUXB5_CMPR2B5_Msk      (0xffffUL)                /*!< CTIMER CMPRAUXB5: CMPR2B5 (Bitfield-Mask: 0xffff)     */
/* =========================================================  AUX5  ========================================================== */
#define CTIMER_AUX5_TMRB5EN23_Pos         (30UL)                    /*!< CTIMER AUX5: TMRB5EN23 (Bit 30)                       */
#define CTIMER_AUX5_TMRB5EN23_Msk         (0x40000000UL)            /*!< CTIMER AUX5: TMRB5EN23 (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX5_TMRB5POL23_Pos        (29UL)                    /*!< CTIMER AUX5: TMRB5POL23 (Bit 29)                      */
#define CTIMER_AUX5_TMRB5POL23_Msk        (0x20000000UL)            /*!< CTIMER AUX5: TMRB5POL23 (Bitfield-Mask: 0x01)         */
#define CTIMER_AUX5_TMRB5TINV_Pos         (28UL)                    /*!< CTIMER AUX5: TMRB5TINV (Bit 28)                       */
#define CTIMER_AUX5_TMRB5TINV_Msk         (0x10000000UL)            /*!< CTIMER AUX5: TMRB5TINV (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX5_TMRB5NOSYNC_Pos       (27UL)                    /*!< CTIMER AUX5: TMRB5NOSYNC (Bit 27)                     */
#define CTIMER_AUX5_TMRB5NOSYNC_Msk       (0x8000000UL)             /*!< CTIMER AUX5: TMRB5NOSYNC (Bitfield-Mask: 0x01)        */
#define CTIMER_AUX5_TMRB5TRIG_Pos         (23UL)                    /*!< CTIMER AUX5: TMRB5TRIG (Bit 23)                       */
#define CTIMER_AUX5_TMRB5TRIG_Msk         (0x7800000UL)             /*!< CTIMER AUX5: TMRB5TRIG (Bitfield-Mask: 0x0f)          */
#define CTIMER_AUX5_TMRB5LMT_Pos          (16UL)                    /*!< CTIMER AUX5: TMRB5LMT (Bit 16)                        */
#define CTIMER_AUX5_TMRB5LMT_Msk          (0x3f0000UL)              /*!< CTIMER AUX5: TMRB5LMT (Bitfield-Mask: 0x3f)           */
#define CTIMER_AUX5_TMRA5EN23_Pos         (14UL)                    /*!< CTIMER AUX5: TMRA5EN23 (Bit 14)                       */
#define CTIMER_AUX5_TMRA5EN23_Msk         (0x4000UL)                /*!< CTIMER AUX5: TMRA5EN23 (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX5_TMRA5POL23_Pos        (13UL)                    /*!< CTIMER AUX5: TMRA5POL23 (Bit 13)                      */
#define CTIMER_AUX5_TMRA5POL23_Msk        (0x2000UL)                /*!< CTIMER AUX5: TMRA5POL23 (Bitfield-Mask: 0x01)         */
#define CTIMER_AUX5_TMRA5TINV_Pos         (12UL)                    /*!< CTIMER AUX5: TMRA5TINV (Bit 12)                       */
#define CTIMER_AUX5_TMRA5TINV_Msk         (0x1000UL)                /*!< CTIMER AUX5: TMRA5TINV (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX5_TMRA5NOSYNC_Pos       (11UL)                    /*!< CTIMER AUX5: TMRA5NOSYNC (Bit 11)                     */
#define CTIMER_AUX5_TMRA5NOSYNC_Msk       (0x800UL)                 /*!< CTIMER AUX5: TMRA5NOSYNC (Bitfield-Mask: 0x01)        */
#define CTIMER_AUX5_TMRA5TRIG_Pos         (7UL)                     /*!< CTIMER AUX5: TMRA5TRIG (Bit 7)                        */
#define CTIMER_AUX5_TMRA5TRIG_Msk         (0x780UL)                 /*!< CTIMER AUX5: TMRA5TRIG (Bitfield-Mask: 0x0f)          */
#define CTIMER_AUX5_TMRA5LMT_Pos          (0UL)                     /*!< CTIMER AUX5: TMRA5LMT (Bit 0)                         */
#define CTIMER_AUX5_TMRA5LMT_Msk          (0x7fUL)                  /*!< CTIMER AUX5: TMRA5LMT (Bitfield-Mask: 0x7f)           */
/* =========================================================  TMR6  ========================================================== */
#define CTIMER_TMR6_CTTMRB6_Pos           (16UL)                    /*!< CTIMER TMR6: CTTMRB6 (Bit 16)                         */
#define CTIMER_TMR6_CTTMRB6_Msk           (0xffff0000UL)            /*!< CTIMER TMR6: CTTMRB6 (Bitfield-Mask: 0xffff)          */
#define CTIMER_TMR6_CTTMRA6_Pos           (0UL)                     /*!< CTIMER TMR6: CTTMRA6 (Bit 0)                          */
#define CTIMER_TMR6_CTTMRA6_Msk           (0xffffUL)                /*!< CTIMER TMR6: CTTMRA6 (Bitfield-Mask: 0xffff)          */
/* ========================================================  CMPRA6  ========================================================= */
#define CTIMER_CMPRA6_CMPR1A6_Pos         (16UL)                    /*!< CTIMER CMPRA6: CMPR1A6 (Bit 16)                       */
#define CTIMER_CMPRA6_CMPR1A6_Msk         (0xffff0000UL)            /*!< CTIMER CMPRA6: CMPR1A6 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRA6_CMPR0A6_Pos         (0UL)                     /*!< CTIMER CMPRA6: CMPR0A6 (Bit 0)                        */
#define CTIMER_CMPRA6_CMPR0A6_Msk         (0xffffUL)                /*!< CTIMER CMPRA6: CMPR0A6 (Bitfield-Mask: 0xffff)        */
/* ========================================================  CMPRB6  ========================================================= */
#define CTIMER_CMPRB6_CMPR1B6_Pos         (16UL)                    /*!< CTIMER CMPRB6: CMPR1B6 (Bit 16)                       */
#define CTIMER_CMPRB6_CMPR1B6_Msk         (0xffff0000UL)            /*!< CTIMER CMPRB6: CMPR1B6 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRB6_CMPR0B6_Pos         (0UL)                     /*!< CTIMER CMPRB6: CMPR0B6 (Bit 0)                        */
#define CTIMER_CMPRB6_CMPR0B6_Msk         (0xffffUL)                /*!< CTIMER CMPRB6: CMPR0B6 (Bitfield-Mask: 0xffff)        */
/* =========================================================  CTRL6  ========================================================= */
#define CTIMER_CTRL6_CTLINK6_Pos          (31UL)                    /*!< CTIMER CTRL6: CTLINK6 (Bit 31)                        */
#define CTIMER_CTRL6_CTLINK6_Msk          (0x80000000UL)            /*!< CTIMER CTRL6: CTLINK6 (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL6_TMRB6POL_Pos         (28UL)                    /*!< CTIMER CTRL6: TMRB6POL (Bit 28)                       */
#define CTIMER_CTRL6_TMRB6POL_Msk         (0x10000000UL)            /*!< CTIMER CTRL6: TMRB6POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL6_TMRB6CLR_Pos         (27UL)                    /*!< CTIMER CTRL6: TMRB6CLR (Bit 27)                       */
#define CTIMER_CTRL6_TMRB6CLR_Msk         (0x8000000UL)             /*!< CTIMER CTRL6: TMRB6CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL6_TMRB6IE1_Pos         (26UL)                    /*!< CTIMER CTRL6: TMRB6IE1 (Bit 26)                       */
#define CTIMER_CTRL6_TMRB6IE1_Msk         (0x4000000UL)             /*!< CTIMER CTRL6: TMRB6IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL6_TMRB6IE0_Pos         (25UL)                    /*!< CTIMER CTRL6: TMRB6IE0 (Bit 25)                       */
#define CTIMER_CTRL6_TMRB6IE0_Msk         (0x2000000UL)             /*!< CTIMER CTRL6: TMRB6IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL6_TMRB6FN_Pos          (22UL)                    /*!< CTIMER CTRL6: TMRB6FN (Bit 22)                        */
#define CTIMER_CTRL6_TMRB6FN_Msk          (0x1c00000UL)             /*!< CTIMER CTRL6: TMRB6FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL6_TMRB6CLK_Pos         (17UL)                    /*!< CTIMER CTRL6: TMRB6CLK (Bit 17)                       */
#define CTIMER_CTRL6_TMRB6CLK_Msk         (0x3e0000UL)              /*!< CTIMER CTRL6: TMRB6CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL6_TMRB6EN_Pos          (16UL)                    /*!< CTIMER CTRL6: TMRB6EN (Bit 16)                        */
#define CTIMER_CTRL6_TMRB6EN_Msk          (0x10000UL)               /*!< CTIMER CTRL6: TMRB6EN (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL6_TMRA6POL_Pos         (12UL)                    /*!< CTIMER CTRL6: TMRA6POL (Bit 12)                       */
#define CTIMER_CTRL6_TMRA6POL_Msk         (0x1000UL)                /*!< CTIMER CTRL6: TMRA6POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL6_TMRA6CLR_Pos         (11UL)                    /*!< CTIMER CTRL6: TMRA6CLR (Bit 11)                       */
#define CTIMER_CTRL6_TMRA6CLR_Msk         (0x800UL)                 /*!< CTIMER CTRL6: TMRA6CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL6_TMRA6IE1_Pos         (10UL)                    /*!< CTIMER CTRL6: TMRA6IE1 (Bit 10)                       */
#define CTIMER_CTRL6_TMRA6IE1_Msk         (0x400UL)                 /*!< CTIMER CTRL6: TMRA6IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL6_TMRA6IE0_Pos         (9UL)                     /*!< CTIMER CTRL6: TMRA6IE0 (Bit 9)                        */
#define CTIMER_CTRL6_TMRA6IE0_Msk         (0x200UL)                 /*!< CTIMER CTRL6: TMRA6IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL6_TMRA6FN_Pos          (6UL)                     /*!< CTIMER CTRL6: TMRA6FN (Bit 6)                         */
#define CTIMER_CTRL6_TMRA6FN_Msk          (0x1c0UL)                 /*!< CTIMER CTRL6: TMRA6FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL6_TMRA6CLK_Pos         (1UL)                     /*!< CTIMER CTRL6: TMRA6CLK (Bit 1)                        */
#define CTIMER_CTRL6_TMRA6CLK_Msk         (0x3eUL)                  /*!< CTIMER CTRL6: TMRA6CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL6_TMRA6EN_Pos          (0UL)                     /*!< CTIMER CTRL6: TMRA6EN (Bit 0)                         */
#define CTIMER_CTRL6_TMRA6EN_Msk          (0x1UL)                   /*!< CTIMER CTRL6: TMRA6EN (Bitfield-Mask: 0x01)           */
/* =======================================================  CMPRAUXA6  ======================================================= */
#define CTIMER_CMPRAUXA6_CMPR3A6_Pos      (16UL)                    /*!< CTIMER CMPRAUXA6: CMPR3A6 (Bit 16)                    */
#define CTIMER_CMPRAUXA6_CMPR3A6_Msk      (0xffff0000UL)            /*!< CTIMER CMPRAUXA6: CMPR3A6 (Bitfield-Mask: 0xffff)     */
#define CTIMER_CMPRAUXA6_CMPR2A6_Pos      (0UL)                     /*!< CTIMER CMPRAUXA6: CMPR2A6 (Bit 0)                     */
#define CTIMER_CMPRAUXA6_CMPR2A6_Msk      (0xffffUL)                /*!< CTIMER CMPRAUXA6: CMPR2A6 (Bitfield-Mask: 0xffff)     */
/* =======================================================  CMPRAUXB6  ======================================================= */
#define CTIMER_CMPRAUXB6_CMPR3B6_Pos      (16UL)                    /*!< CTIMER CMPRAUXB6: CMPR3B6 (Bit 16)                    */
#define CTIMER_CMPRAUXB6_CMPR3B6_Msk      (0xffff0000UL)            /*!< CTIMER CMPRAUXB6: CMPR3B6 (Bitfield-Mask: 0xffff)     */
#define CTIMER_CMPRAUXB6_CMPR2B6_Pos      (0UL)                     /*!< CTIMER CMPRAUXB6: CMPR2B6 (Bit 0)                     */
#define CTIMER_CMPRAUXB6_CMPR2B6_Msk      (0xffffUL)                /*!< CTIMER CMPRAUXB6: CMPR2B6 (Bitfield-Mask: 0xffff)     */
/* =========================================================  AUX6  ========================================================== */
#define CTIMER_AUX6_TMRB6EN23_Pos         (30UL)                    /*!< CTIMER AUX6: TMRB6EN23 (Bit 30)                       */
#define CTIMER_AUX6_TMRB6EN23_Msk         (0x40000000UL)            /*!< CTIMER AUX6: TMRB6EN23 (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX6_TMRB6POL23_Pos        (29UL)                    /*!< CTIMER AUX6: TMRB6POL23 (Bit 29)                      */
#define CTIMER_AUX6_TMRB6POL23_Msk        (0x20000000UL)            /*!< CTIMER AUX6: TMRB6POL23 (Bitfield-Mask: 0x01)         */
#define CTIMER_AUX6_TMRB6TINV_Pos         (28UL)                    /*!< CTIMER AUX6: TMRB6TINV (Bit 28)                       */
#define CTIMER_AUX6_TMRB6TINV_Msk         (0x10000000UL)            /*!< CTIMER AUX6: TMRB6TINV (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX6_TMRB6NOSYNC_Pos       (27UL)                    /*!< CTIMER AUX6: TMRB6NOSYNC (Bit 27)                     */
#define CTIMER_AUX6_TMRB6NOSYNC_Msk       (0x8000000UL)             /*!< CTIMER AUX6: TMRB6NOSYNC (Bitfield-Mask: 0x01)        */
#define CTIMER_AUX6_TMRB6TRIG_Pos         (23UL)                    /*!< CTIMER AUX6: TMRB6TRIG (Bit 23)                       */
#define CTIMER_AUX6_TMRB6TRIG_Msk         (0x7800000UL)             /*!< CTIMER AUX6: TMRB6TRIG (Bitfield-Mask: 0x0f)          */
#define CTIMER_AUX6_TMRB6LMT_Pos          (16UL)                    /*!< CTIMER AUX6: TMRB6LMT (Bit 16)                        */
#define CTIMER_AUX6_TMRB6LMT_Msk          (0x3f0000UL)              /*!< CTIMER AUX6: TMRB6LMT (Bitfield-Mask: 0x3f)           */
#define CTIMER_AUX6_TMRA6EN23_Pos         (14UL)                    /*!< CTIMER AUX6: TMRA6EN23 (Bit 14)                       */
#define CTIMER_AUX6_TMRA6EN23_Msk         (0x4000UL)                /*!< CTIMER AUX6: TMRA6EN23 (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX6_TMRA6POL23_Pos        (13UL)                    /*!< CTIMER AUX6: TMRA6POL23 (Bit 13)                      */
#define CTIMER_AUX6_TMRA6POL23_Msk        (0x2000UL)                /*!< CTIMER AUX6: TMRA6POL23 (Bitfield-Mask: 0x01)         */
#define CTIMER_AUX6_TMRA6TINV_Pos         (12UL)                    /*!< CTIMER AUX6: TMRA6TINV (Bit 12)                       */
#define CTIMER_AUX6_TMRA6TINV_Msk         (0x1000UL)                /*!< CTIMER AUX6: TMRA6TINV (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX6_TMRA6NOSYNC_Pos       (11UL)                    /*!< CTIMER AUX6: TMRA6NOSYNC (Bit 11)                     */
#define CTIMER_AUX6_TMRA6NOSYNC_Msk       (0x800UL)                 /*!< CTIMER AUX6: TMRA6NOSYNC (Bitfield-Mask: 0x01)        */
#define CTIMER_AUX6_TMRA6TRIG_Pos         (7UL)                     /*!< CTIMER AUX6: TMRA6TRIG (Bit 7)                        */
#define CTIMER_AUX6_TMRA6TRIG_Msk         (0x780UL)                 /*!< CTIMER AUX6: TMRA6TRIG (Bitfield-Mask: 0x0f)          */
#define CTIMER_AUX6_TMRA6LMT_Pos          (0UL)                     /*!< CTIMER AUX6: TMRA6LMT (Bit 0)                         */
#define CTIMER_AUX6_TMRA6LMT_Msk          (0x7fUL)                  /*!< CTIMER AUX6: TMRA6LMT (Bitfield-Mask: 0x7f)           */
/* =========================================================  TMR7  ========================================================== */
#define CTIMER_TMR7_CTTMRB7_Pos           (16UL)                    /*!< CTIMER TMR7: CTTMRB7 (Bit 16)                         */
#define CTIMER_TMR7_CTTMRB7_Msk           (0xffff0000UL)            /*!< CTIMER TMR7: CTTMRB7 (Bitfield-Mask: 0xffff)          */
#define CTIMER_TMR7_CTTMRA7_Pos           (0UL)                     /*!< CTIMER TMR7: CTTMRA7 (Bit 0)                          */
#define CTIMER_TMR7_CTTMRA7_Msk           (0xffffUL)                /*!< CTIMER TMR7: CTTMRA7 (Bitfield-Mask: 0xffff)          */
/* ========================================================  CMPRA7  ========================================================= */
#define CTIMER_CMPRA7_CMPR1A7_Pos         (16UL)                    /*!< CTIMER CMPRA7: CMPR1A7 (Bit 16)                       */
#define CTIMER_CMPRA7_CMPR1A7_Msk         (0xffff0000UL)            /*!< CTIMER CMPRA7: CMPR1A7 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRA7_CMPR0A7_Pos         (0UL)                     /*!< CTIMER CMPRA7: CMPR0A7 (Bit 0)                        */
#define CTIMER_CMPRA7_CMPR0A7_Msk         (0xffffUL)                /*!< CTIMER CMPRA7: CMPR0A7 (Bitfield-Mask: 0xffff)        */
/* ========================================================  CMPRB7  ========================================================= */
#define CTIMER_CMPRB7_CMPR1B7_Pos         (16UL)                    /*!< CTIMER CMPRB7: CMPR1B7 (Bit 16)                       */
#define CTIMER_CMPRB7_CMPR1B7_Msk         (0xffff0000UL)            /*!< CTIMER CMPRB7: CMPR1B7 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRB7_CMPR0B7_Pos         (0UL)                     /*!< CTIMER CMPRB7: CMPR0B7 (Bit 0)                        */
#define CTIMER_CMPRB7_CMPR0B7_Msk         (0xffffUL)                /*!< CTIMER CMPRB7: CMPR0B7 (Bitfield-Mask: 0xffff)        */
/* =========================================================  CTRL7  ========================================================= */
#define CTIMER_CTRL7_CTLINK7_Pos          (31UL)                    /*!< CTIMER CTRL7: CTLINK7 (Bit 31)                        */
#define CTIMER_CTRL7_CTLINK7_Msk          (0x80000000UL)            /*!< CTIMER CTRL7: CTLINK7 (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL7_TMRB7POL_Pos         (28UL)                    /*!< CTIMER CTRL7: TMRB7POL (Bit 28)                       */
#define CTIMER_CTRL7_TMRB7POL_Msk         (0x10000000UL)            /*!< CTIMER CTRL7: TMRB7POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL7_TMRB7CLR_Pos         (27UL)                    /*!< CTIMER CTRL7: TMRB7CLR (Bit 27)                       */
#define CTIMER_CTRL7_TMRB7CLR_Msk         (0x8000000UL)             /*!< CTIMER CTRL7: TMRB7CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL7_TMRB7IE1_Pos         (26UL)                    /*!< CTIMER CTRL7: TMRB7IE1 (Bit 26)                       */
#define CTIMER_CTRL7_TMRB7IE1_Msk         (0x4000000UL)             /*!< CTIMER CTRL7: TMRB7IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL7_TMRB7IE0_Pos         (25UL)                    /*!< CTIMER CTRL7: TMRB7IE0 (Bit 25)                       */
#define CTIMER_CTRL7_TMRB7IE0_Msk         (0x2000000UL)             /*!< CTIMER CTRL7: TMRB7IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL7_TMRB7FN_Pos          (22UL)                    /*!< CTIMER CTRL7: TMRB7FN (Bit 22)                        */
#define CTIMER_CTRL7_TMRB7FN_Msk          (0x1c00000UL)             /*!< CTIMER CTRL7: TMRB7FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL7_TMRB7CLK_Pos         (17UL)                    /*!< CTIMER CTRL7: TMRB7CLK (Bit 17)                       */
#define CTIMER_CTRL7_TMRB7CLK_Msk         (0x3e0000UL)              /*!< CTIMER CTRL7: TMRB7CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL7_TMRB7EN_Pos          (16UL)                    /*!< CTIMER CTRL7: TMRB7EN (Bit 16)                        */
#define CTIMER_CTRL7_TMRB7EN_Msk          (0x10000UL)               /*!< CTIMER CTRL7: TMRB7EN (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL7_TMRA7POL_Pos         (12UL)                    /*!< CTIMER CTRL7: TMRA7POL (Bit 12)                       */
#define CTIMER_CTRL7_TMRA7POL_Msk         (0x1000UL)                /*!< CTIMER CTRL7: TMRA7POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL7_TMRA7CLR_Pos         (11UL)                    /*!< CTIMER CTRL7: TMRA7CLR (Bit 11)                       */
#define CTIMER_CTRL7_TMRA7CLR_Msk         (0x800UL)                 /*!< CTIMER CTRL7: TMRA7CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL7_TMRA7IE1_Pos         (10UL)                    /*!< CTIMER CTRL7: TMRA7IE1 (Bit 10)                       */
#define CTIMER_CTRL7_TMRA7IE1_Msk         (0x400UL)                 /*!< CTIMER CTRL7: TMRA7IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL7_TMRA7IE0_Pos         (9UL)                     /*!< CTIMER CTRL7: TMRA7IE0 (Bit 9)                        */
#define CTIMER_CTRL7_TMRA7IE0_Msk         (0x200UL)                 /*!< CTIMER CTRL7: TMRA7IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL7_TMRA7FN_Pos          (6UL)                     /*!< CTIMER CTRL7: TMRA7FN (Bit 6)                         */
#define CTIMER_CTRL7_TMRA7FN_Msk          (0x1c0UL)                 /*!< CTIMER CTRL7: TMRA7FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL7_TMRA7CLK_Pos         (1UL)                     /*!< CTIMER CTRL7: TMRA7CLK (Bit 1)                        */
#define CTIMER_CTRL7_TMRA7CLK_Msk         (0x3eUL)                  /*!< CTIMER CTRL7: TMRA7CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL7_TMRA7EN_Pos          (0UL)                     /*!< CTIMER CTRL7: TMRA7EN (Bit 0)                         */
#define CTIMER_CTRL7_TMRA7EN_Msk          (0x1UL)                   /*!< CTIMER CTRL7: TMRA7EN (Bitfield-Mask: 0x01)           */
/* =======================================================  CMPRAUXA7  ======================================================= */
#define CTIMER_CMPRAUXA7_CMPR3A7_Pos      (16UL)                    /*!< CTIMER CMPRAUXA7: CMPR3A7 (Bit 16)                    */
#define CTIMER_CMPRAUXA7_CMPR3A7_Msk      (0xffff0000UL)            /*!< CTIMER CMPRAUXA7: CMPR3A7 (Bitfield-Mask: 0xffff)     */
#define CTIMER_CMPRAUXA7_CMPR2A7_Pos      (0UL)                     /*!< CTIMER CMPRAUXA7: CMPR2A7 (Bit 0)                     */
#define CTIMER_CMPRAUXA7_CMPR2A7_Msk      (0xffffUL)                /*!< CTIMER CMPRAUXA7: CMPR2A7 (Bitfield-Mask: 0xffff)     */
/* =======================================================  CMPRAUXB7  ======================================================= */
#define CTIMER_CMPRAUXB7_CMPR3B7_Pos      (16UL)                    /*!< CTIMER CMPRAUXB7: CMPR3B7 (Bit 16)                    */
#define CTIMER_CMPRAUXB7_CMPR3B7_Msk      (0xffff0000UL)            /*!< CTIMER CMPRAUXB7: CMPR3B7 (Bitfield-Mask: 0xffff)     */
#define CTIMER_CMPRAUXB7_CMPR2B7_Pos      (0UL)                     /*!< CTIMER CMPRAUXB7: CMPR2B7 (Bit 0)                     */
#define CTIMER_CMPRAUXB7_CMPR2B7_Msk      (0xffffUL)                /*!< CTIMER CMPRAUXB7: CMPR2B7 (Bitfield-Mask: 0xffff)     */
/* =========================================================  AUX7  ========================================================== */
#define CTIMER_AUX7_TMRB7EN23_Pos         (30UL)                    /*!< CTIMER AUX7: TMRB7EN23 (Bit 30)                       */
#define CTIMER_AUX7_TMRB7EN23_Msk         (0x40000000UL)            /*!< CTIMER AUX7: TMRB7EN23 (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX7_TMRB7POL23_Pos        (29UL)                    /*!< CTIMER AUX7: TMRB7POL23 (Bit 29)                      */
#define CTIMER_AUX7_TMRB7POL23_Msk        (0x20000000UL)            /*!< CTIMER AUX7: TMRB7POL23 (Bitfield-Mask: 0x01)         */
#define CTIMER_AUX7_TMRB7TINV_Pos         (28UL)                    /*!< CTIMER AUX7: TMRB7TINV (Bit 28)                       */
#define CTIMER_AUX7_TMRB7TINV_Msk         (0x10000000UL)            /*!< CTIMER AUX7: TMRB7TINV (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX7_TMRB7NOSYNC_Pos       (27UL)                    /*!< CTIMER AUX7: TMRB7NOSYNC (Bit 27)                     */
#define CTIMER_AUX7_TMRB7NOSYNC_Msk       (0x8000000UL)             /*!< CTIMER AUX7: TMRB7NOSYNC (Bitfield-Mask: 0x01)        */
#define CTIMER_AUX7_TMRB7TRIG_Pos         (23UL)                    /*!< CTIMER AUX7: TMRB7TRIG (Bit 23)                       */
#define CTIMER_AUX7_TMRB7TRIG_Msk         (0x7800000UL)             /*!< CTIMER AUX7: TMRB7TRIG (Bitfield-Mask: 0x0f)          */
#define CTIMER_AUX7_TMRB7LMT_Pos          (16UL)                    /*!< CTIMER AUX7: TMRB7LMT (Bit 16)                        */
#define CTIMER_AUX7_TMRB7LMT_Msk          (0x3f0000UL)              /*!< CTIMER AUX7: TMRB7LMT (Bitfield-Mask: 0x3f)           */
#define CTIMER_AUX7_TMRA7EN23_Pos         (14UL)                    /*!< CTIMER AUX7: TMRA7EN23 (Bit 14)                       */
#define CTIMER_AUX7_TMRA7EN23_Msk         (0x4000UL)                /*!< CTIMER AUX7: TMRA7EN23 (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX7_TMRA7POL23_Pos        (13UL)                    /*!< CTIMER AUX7: TMRA7POL23 (Bit 13)                      */
#define CTIMER_AUX7_TMRA7POL23_Msk        (0x2000UL)                /*!< CTIMER AUX7: TMRA7POL23 (Bitfield-Mask: 0x01)         */
#define CTIMER_AUX7_TMRA7TINV_Pos         (12UL)                    /*!< CTIMER AUX7: TMRA7TINV (Bit 12)                       */
#define CTIMER_AUX7_TMRA7TINV_Msk         (0x1000UL)                /*!< CTIMER AUX7: TMRA7TINV (Bitfield-Mask: 0x01)          */
#define CTIMER_AUX7_TMRA7NOSYNC_Pos       (11UL)                    /*!< CTIMER AUX7: TMRA7NOSYNC (Bit 11)                     */
#define CTIMER_AUX7_TMRA7NOSYNC_Msk       (0x800UL)                 /*!< CTIMER AUX7: TMRA7NOSYNC (Bitfield-Mask: 0x01)        */
#define CTIMER_AUX7_TMRA7TRIG_Pos         (7UL)                     /*!< CTIMER AUX7: TMRA7TRIG (Bit 7)                        */
#define CTIMER_AUX7_TMRA7TRIG_Msk         (0x780UL)                 /*!< CTIMER AUX7: TMRA7TRIG (Bitfield-Mask: 0x0f)          */
#define CTIMER_AUX7_TMRA7LMT_Pos          (0UL)                     /*!< CTIMER AUX7: TMRA7LMT (Bit 0)                         */
#define CTIMER_AUX7_TMRA7LMT_Msk          (0x7fUL)                  /*!< CTIMER AUX7: TMRA7LMT (Bitfield-Mask: 0x7f)           */
/* ========================================================  GLOBEN  ========================================================= */
#define CTIMER_GLOBEN_ENB7_Pos            (15UL)                    /*!< CTIMER GLOBEN: ENB7 (Bit 15)                          */
#define CTIMER_GLOBEN_ENB7_Msk            (0x8000UL)                /*!< CTIMER GLOBEN: ENB7 (Bitfield-Mask: 0x01)             */
#define CTIMER_GLOBEN_ENA7_Pos            (14UL)                    /*!< CTIMER GLOBEN: ENA7 (Bit 14)                          */
#define CTIMER_GLOBEN_ENA7_Msk            (0x4000UL)                /*!< CTIMER GLOBEN: ENA7 (Bitfield-Mask: 0x01)             */
#define CTIMER_GLOBEN_ENB6_Pos            (13UL)                    /*!< CTIMER GLOBEN: ENB6 (Bit 13)                          */
#define CTIMER_GLOBEN_ENB6_Msk            (0x2000UL)                /*!< CTIMER GLOBEN: ENB6 (Bitfield-Mask: 0x01)             */
#define CTIMER_GLOBEN_ENA6_Pos            (12UL)                    /*!< CTIMER GLOBEN: ENA6 (Bit 12)                          */
#define CTIMER_GLOBEN_ENA6_Msk            (0x1000UL)                /*!< CTIMER GLOBEN: ENA6 (Bitfield-Mask: 0x01)             */
#define CTIMER_GLOBEN_ENB5_Pos            (11UL)                    /*!< CTIMER GLOBEN: ENB5 (Bit 11)                          */
#define CTIMER_GLOBEN_ENB5_Msk            (0x800UL)                 /*!< CTIMER GLOBEN: ENB5 (Bitfield-Mask: 0x01)             */
#define CTIMER_GLOBEN_ENA5_Pos            (10UL)                    /*!< CTIMER GLOBEN: ENA5 (Bit 10)                          */
#define CTIMER_GLOBEN_ENA5_Msk            (0x400UL)                 /*!< CTIMER GLOBEN: ENA5 (Bitfield-Mask: 0x01)             */
#define CTIMER_GLOBEN_ENB4_Pos            (9UL)                     /*!< CTIMER GLOBEN: ENB4 (Bit 9)                           */
#define CTIMER_GLOBEN_ENB4_Msk            (0x200UL)                 /*!< CTIMER GLOBEN: ENB4 (Bitfield-Mask: 0x01)             */
#define CTIMER_GLOBEN_ENA4_Pos            (8UL)                     /*!< CTIMER GLOBEN: ENA4 (Bit 8)                           */
#define CTIMER_GLOBEN_ENA4_Msk            (0x100UL)                 /*!< CTIMER GLOBEN: ENA4 (Bitfield-Mask: 0x01)             */
#define CTIMER_GLOBEN_ENB3_Pos            (7UL)                     /*!< CTIMER GLOBEN: ENB3 (Bit 7)                           */
#define CTIMER_GLOBEN_ENB3_Msk            (0x80UL)                  /*!< CTIMER GLOBEN: ENB3 (Bitfield-Mask: 0x01)             */
#define CTIMER_GLOBEN_ENA3_Pos            (6UL)                     /*!< CTIMER GLOBEN: ENA3 (Bit 6)                           */
#define CTIMER_GLOBEN_ENA3_Msk            (0x40UL)                  /*!< CTIMER GLOBEN: ENA3 (Bitfield-Mask: 0x01)             */
#define CTIMER_GLOBEN_ENB2_Pos            (5UL)                     /*!< CTIMER GLOBEN: ENB2 (Bit 5)                           */
#define CTIMER_GLOBEN_ENB2_Msk            (0x20UL)                  /*!< CTIMER GLOBEN: ENB2 (Bitfield-Mask: 0x01)             */
#define CTIMER_GLOBEN_ENA2_Pos            (4UL)                     /*!< CTIMER GLOBEN: ENA2 (Bit 4)                           */
#define CTIMER_GLOBEN_ENA2_Msk            (0x10UL)                  /*!< CTIMER GLOBEN: ENA2 (Bitfield-Mask: 0x01)             */
#define CTIMER_GLOBEN_ENB1_Pos            (3UL)                     /*!< CTIMER GLOBEN: ENB1 (Bit 3)                           */
#define CTIMER_GLOBEN_ENB1_Msk            (0x8UL)                   /*!< CTIMER GLOBEN: ENB1 (Bitfield-Mask: 0x01)             */
#define CTIMER_GLOBEN_ENA1_Pos            (2UL)                     /*!< CTIMER GLOBEN: ENA1 (Bit 2)                           */
#define CTIMER_GLOBEN_ENA1_Msk            (0x4UL)                   /*!< CTIMER GLOBEN: ENA1 (Bitfield-Mask: 0x01)             */
#define CTIMER_GLOBEN_ENB0_Pos            (1UL)                     /*!< CTIMER GLOBEN: ENB0 (Bit 1)                           */
#define CTIMER_GLOBEN_ENB0_Msk            (0x2UL)                   /*!< CTIMER GLOBEN: ENB0 (Bitfield-Mask: 0x01)             */
#define CTIMER_GLOBEN_ENA0_Pos            (0UL)                     /*!< CTIMER GLOBEN: ENA0 (Bit 0)                           */
#define CTIMER_GLOBEN_ENA0_Msk            (0x1UL)                   /*!< CTIMER GLOBEN: ENA0 (Bitfield-Mask: 0x01)             */
/* ========================================================  OUTCFG0  ======================================================== */
#define CTIMER_OUTCFG0_CFG9_Pos           (28UL)                    /*!< CTIMER OUTCFG0: CFG9 (Bit 28)                         */
#define CTIMER_OUTCFG0_CFG9_Msk           (0x70000000UL)            /*!< CTIMER OUTCFG0: CFG9 (Bitfield-Mask: 0x07)            */
#define CTIMER_OUTCFG0_CFG8_Pos           (25UL)                    /*!< CTIMER OUTCFG0: CFG8 (Bit 25)                         */
#define CTIMER_OUTCFG0_CFG8_Msk           (0xe000000UL)             /*!< CTIMER OUTCFG0: CFG8 (Bitfield-Mask: 0x07)            */
#define CTIMER_OUTCFG0_CFG7_Pos           (22UL)                    /*!< CTIMER OUTCFG0: CFG7 (Bit 22)                         */
#define CTIMER_OUTCFG0_CFG7_Msk           (0x1c00000UL)             /*!< CTIMER OUTCFG0: CFG7 (Bitfield-Mask: 0x07)            */
#define CTIMER_OUTCFG0_CFG6_Pos           (19UL)                    /*!< CTIMER OUTCFG0: CFG6 (Bit 19)                         */
#define CTIMER_OUTCFG0_CFG6_Msk           (0x380000UL)              /*!< CTIMER OUTCFG0: CFG6 (Bitfield-Mask: 0x07)            */
#define CTIMER_OUTCFG0_CFG5_Pos           (16UL)                    /*!< CTIMER OUTCFG0: CFG5 (Bit 16)                         */
#define CTIMER_OUTCFG0_CFG5_Msk           (0x70000UL)               /*!< CTIMER OUTCFG0: CFG5 (Bitfield-Mask: 0x07)            */
#define CTIMER_OUTCFG0_CFG4_Pos           (12UL)                    /*!< CTIMER OUTCFG0: CFG4 (Bit 12)                         */
#define CTIMER_OUTCFG0_CFG4_Msk           (0x7000UL)                /*!< CTIMER OUTCFG0: CFG4 (Bitfield-Mask: 0x07)            */
#define CTIMER_OUTCFG0_CFG3_Pos           (9UL)                     /*!< CTIMER OUTCFG0: CFG3 (Bit 9)                          */
#define CTIMER_OUTCFG0_CFG3_Msk           (0xe00UL)                 /*!< CTIMER OUTCFG0: CFG3 (Bitfield-Mask: 0x07)            */
#define CTIMER_OUTCFG0_CFG2_Pos           (6UL)                     /*!< CTIMER OUTCFG0: CFG2 (Bit 6)                          */
#define CTIMER_OUTCFG0_CFG2_Msk           (0x1c0UL)                 /*!< CTIMER OUTCFG0: CFG2 (Bitfield-Mask: 0x07)            */
#define CTIMER_OUTCFG0_CFG1_Pos           (3UL)                     /*!< CTIMER OUTCFG0: CFG1 (Bit 3)                          */
#define CTIMER_OUTCFG0_CFG1_Msk           (0x38UL)                  /*!< CTIMER OUTCFG0: CFG1 (Bitfield-Mask: 0x07)            */
#define CTIMER_OUTCFG0_CFG0_Pos           (0UL)                     /*!< CTIMER OUTCFG0: CFG0 (Bit 0)                          */
#define CTIMER_OUTCFG0_CFG0_Msk           (0x7UL)                   /*!< CTIMER OUTCFG0: CFG0 (Bitfield-Mask: 0x07)            */
/* ========================================================  OUTCFG1  ======================================================== */
#define CTIMER_OUTCFG1_CFG19_Pos          (28UL)                    /*!< CTIMER OUTCFG1: CFG19 (Bit 28)                        */
#define CTIMER_OUTCFG1_CFG19_Msk          (0x70000000UL)            /*!< CTIMER OUTCFG1: CFG19 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG1_CFG18_Pos          (25UL)                    /*!< CTIMER OUTCFG1: CFG18 (Bit 25)                        */
#define CTIMER_OUTCFG1_CFG18_Msk          (0xe000000UL)             /*!< CTIMER OUTCFG1: CFG18 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG1_CFG17_Pos          (22UL)                    /*!< CTIMER OUTCFG1: CFG17 (Bit 22)                        */
#define CTIMER_OUTCFG1_CFG17_Msk          (0x1c00000UL)             /*!< CTIMER OUTCFG1: CFG17 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG1_CFG16_Pos          (19UL)                    /*!< CTIMER OUTCFG1: CFG16 (Bit 19)                        */
#define CTIMER_OUTCFG1_CFG16_Msk          (0x380000UL)              /*!< CTIMER OUTCFG1: CFG16 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG1_CFG15_Pos          (16UL)                    /*!< CTIMER OUTCFG1: CFG15 (Bit 16)                        */
#define CTIMER_OUTCFG1_CFG15_Msk          (0x70000UL)               /*!< CTIMER OUTCFG1: CFG15 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG1_CFG14_Pos          (12UL)                    /*!< CTIMER OUTCFG1: CFG14 (Bit 12)                        */
#define CTIMER_OUTCFG1_CFG14_Msk          (0x7000UL)                /*!< CTIMER OUTCFG1: CFG14 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG1_CFG13_Pos          (9UL)                     /*!< CTIMER OUTCFG1: CFG13 (Bit 9)                         */
#define CTIMER_OUTCFG1_CFG13_Msk          (0xe00UL)                 /*!< CTIMER OUTCFG1: CFG13 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG1_CFG12_Pos          (6UL)                     /*!< CTIMER OUTCFG1: CFG12 (Bit 6)                         */
#define CTIMER_OUTCFG1_CFG12_Msk          (0x1c0UL)                 /*!< CTIMER OUTCFG1: CFG12 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG1_CFG11_Pos          (3UL)                     /*!< CTIMER OUTCFG1: CFG11 (Bit 3)                         */
#define CTIMER_OUTCFG1_CFG11_Msk          (0x38UL)                  /*!< CTIMER OUTCFG1: CFG11 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG1_CFG10_Pos          (0UL)                     /*!< CTIMER OUTCFG1: CFG10 (Bit 0)                         */
#define CTIMER_OUTCFG1_CFG10_Msk          (0x7UL)                   /*!< CTIMER OUTCFG1: CFG10 (Bitfield-Mask: 0x07)           */
/* ========================================================  OUTCFG2  ======================================================== */
#define CTIMER_OUTCFG2_CFG29_Pos          (28UL)                    /*!< CTIMER OUTCFG2: CFG29 (Bit 28)                        */
#define CTIMER_OUTCFG2_CFG29_Msk          (0x70000000UL)            /*!< CTIMER OUTCFG2: CFG29 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG2_CFG28_Pos          (25UL)                    /*!< CTIMER OUTCFG2: CFG28 (Bit 25)                        */
#define CTIMER_OUTCFG2_CFG28_Msk          (0xe000000UL)             /*!< CTIMER OUTCFG2: CFG28 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG2_CFG27_Pos          (22UL)                    /*!< CTIMER OUTCFG2: CFG27 (Bit 22)                        */
#define CTIMER_OUTCFG2_CFG27_Msk          (0x1c00000UL)             /*!< CTIMER OUTCFG2: CFG27 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG2_CFG26_Pos          (19UL)                    /*!< CTIMER OUTCFG2: CFG26 (Bit 19)                        */
#define CTIMER_OUTCFG2_CFG26_Msk          (0x380000UL)              /*!< CTIMER OUTCFG2: CFG26 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG2_CFG25_Pos          (16UL)                    /*!< CTIMER OUTCFG2: CFG25 (Bit 16)                        */
#define CTIMER_OUTCFG2_CFG25_Msk          (0x70000UL)               /*!< CTIMER OUTCFG2: CFG25 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG2_CFG24_Pos          (12UL)                    /*!< CTIMER OUTCFG2: CFG24 (Bit 12)                        */
#define CTIMER_OUTCFG2_CFG24_Msk          (0x7000UL)                /*!< CTIMER OUTCFG2: CFG24 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG2_CFG23_Pos          (9UL)                     /*!< CTIMER OUTCFG2: CFG23 (Bit 9)                         */
#define CTIMER_OUTCFG2_CFG23_Msk          (0xe00UL)                 /*!< CTIMER OUTCFG2: CFG23 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG2_CFG22_Pos          (6UL)                     /*!< CTIMER OUTCFG2: CFG22 (Bit 6)                         */
#define CTIMER_OUTCFG2_CFG22_Msk          (0x1c0UL)                 /*!< CTIMER OUTCFG2: CFG22 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG2_CFG21_Pos          (3UL)                     /*!< CTIMER OUTCFG2: CFG21 (Bit 3)                         */
#define CTIMER_OUTCFG2_CFG21_Msk          (0x38UL)                  /*!< CTIMER OUTCFG2: CFG21 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG2_CFG20_Pos          (0UL)                     /*!< CTIMER OUTCFG2: CFG20 (Bit 0)                         */
#define CTIMER_OUTCFG2_CFG20_Msk          (0x7UL)                   /*!< CTIMER OUTCFG2: CFG20 (Bitfield-Mask: 0x07)           */
/* ========================================================  OUTCFG3  ======================================================== */
#define CTIMER_OUTCFG3_CFG31_Pos          (3UL)                     /*!< CTIMER OUTCFG3: CFG31 (Bit 3)                         */
#define CTIMER_OUTCFG3_CFG31_Msk          (0x38UL)                  /*!< CTIMER OUTCFG3: CFG31 (Bitfield-Mask: 0x07)           */
#define CTIMER_OUTCFG3_CFG30_Pos          (0UL)                     /*!< CTIMER OUTCFG3: CFG30 (Bit 0)                         */
#define CTIMER_OUTCFG3_CFG30_Msk          (0x7UL)                   /*!< CTIMER OUTCFG3: CFG30 (Bitfield-Mask: 0x07)           */
/* =========================================================  INCFG  ========================================================= */
#define CTIMER_INCFG_CFGB7_Pos            (15UL)                    /*!< CTIMER INCFG: CFGB7 (Bit 15)                          */
#define CTIMER_INCFG_CFGB7_Msk            (0x8000UL)                /*!< CTIMER INCFG: CFGB7 (Bitfield-Mask: 0x01)             */
#define CTIMER_INCFG_CFGA7_Pos            (14UL)                    /*!< CTIMER INCFG: CFGA7 (Bit 14)                          */
#define CTIMER_INCFG_CFGA7_Msk            (0x4000UL)                /*!< CTIMER INCFG: CFGA7 (Bitfield-Mask: 0x01)             */
#define CTIMER_INCFG_CFGB6_Pos            (13UL)                    /*!< CTIMER INCFG: CFGB6 (Bit 13)                          */
#define CTIMER_INCFG_CFGB6_Msk            (0x2000UL)                /*!< CTIMER INCFG: CFGB6 (Bitfield-Mask: 0x01)             */
#define CTIMER_INCFG_CFGA6_Pos            (12UL)                    /*!< CTIMER INCFG: CFGA6 (Bit 12)                          */
#define CTIMER_INCFG_CFGA6_Msk            (0x1000UL)                /*!< CTIMER INCFG: CFGA6 (Bitfield-Mask: 0x01)             */
#define CTIMER_INCFG_CFGB5_Pos            (11UL)                    /*!< CTIMER INCFG: CFGB5 (Bit 11)                          */
#define CTIMER_INCFG_CFGB5_Msk            (0x800UL)                 /*!< CTIMER INCFG: CFGB5 (Bitfield-Mask: 0x01)             */
#define CTIMER_INCFG_CFGA5_Pos            (10UL)                    /*!< CTIMER INCFG: CFGA5 (Bit 10)                          */
#define CTIMER_INCFG_CFGA5_Msk            (0x400UL)                 /*!< CTIMER INCFG: CFGA5 (Bitfield-Mask: 0x01)             */
#define CTIMER_INCFG_CFGB4_Pos            (9UL)                     /*!< CTIMER INCFG: CFGB4 (Bit 9)                           */
#define CTIMER_INCFG_CFGB4_Msk            (0x200UL)                 /*!< CTIMER INCFG: CFGB4 (Bitfield-Mask: 0x01)             */
#define CTIMER_INCFG_CFGA4_Pos            (8UL)                     /*!< CTIMER INCFG: CFGA4 (Bit 8)                           */
#define CTIMER_INCFG_CFGA4_Msk            (0x100UL)                 /*!< CTIMER INCFG: CFGA4 (Bitfield-Mask: 0x01)             */
#define CTIMER_INCFG_CFGB3_Pos            (7UL)                     /*!< CTIMER INCFG: CFGB3 (Bit 7)                           */
#define CTIMER_INCFG_CFGB3_Msk            (0x80UL)                  /*!< CTIMER INCFG: CFGB3 (Bitfield-Mask: 0x01)             */
#define CTIMER_INCFG_CFGA3_Pos            (6UL)                     /*!< CTIMER INCFG: CFGA3 (Bit 6)                           */
#define CTIMER_INCFG_CFGA3_Msk            (0x40UL)                  /*!< CTIMER INCFG: CFGA3 (Bitfield-Mask: 0x01)             */
#define CTIMER_INCFG_CFGB2_Pos            (5UL)                     /*!< CTIMER INCFG: CFGB2 (Bit 5)                           */
#define CTIMER_INCFG_CFGB2_Msk            (0x20UL)                  /*!< CTIMER INCFG: CFGB2 (Bitfield-Mask: 0x01)             */
#define CTIMER_INCFG_CFGA2_Pos            (4UL)                     /*!< CTIMER INCFG: CFGA2 (Bit 4)                           */
#define CTIMER_INCFG_CFGA2_Msk            (0x10UL)                  /*!< CTIMER INCFG: CFGA2 (Bitfield-Mask: 0x01)             */
#define CTIMER_INCFG_CFGB1_Pos            (3UL)                     /*!< CTIMER INCFG: CFGB1 (Bit 3)                           */
#define CTIMER_INCFG_CFGB1_Msk            (0x8UL)                   /*!< CTIMER INCFG: CFGB1 (Bitfield-Mask: 0x01)             */
#define CTIMER_INCFG_CFGA1_Pos            (2UL)                     /*!< CTIMER INCFG: CFGA1 (Bit 2)                           */
#define CTIMER_INCFG_CFGA1_Msk            (0x4UL)                   /*!< CTIMER INCFG: CFGA1 (Bitfield-Mask: 0x01)             */
#define CTIMER_INCFG_CFGB0_Pos            (1UL)                     /*!< CTIMER INCFG: CFGB0 (Bit 1)                           */
#define CTIMER_INCFG_CFGB0_Msk            (0x2UL)                   /*!< CTIMER INCFG: CFGB0 (Bitfield-Mask: 0x01)             */
#define CTIMER_INCFG_CFGA0_Pos            (0UL)                     /*!< CTIMER INCFG: CFGA0 (Bit 0)                           */
#define CTIMER_INCFG_CFGA0_Msk            (0x1UL)                   /*!< CTIMER INCFG: CFGA0 (Bitfield-Mask: 0x01)             */
/* =========================================================  STCFG  ========================================================= */
#define CTIMER_STCFG_FREEZE_Pos           (31UL)                    /*!< CTIMER STCFG: FREEZE (Bit 31)                         */
#define CTIMER_STCFG_FREEZE_Msk           (0x80000000UL)            /*!< CTIMER STCFG: FREEZE (Bitfield-Mask: 0x01)            */
#define CTIMER_STCFG_CLEAR_Pos            (30UL)                    /*!< CTIMER STCFG: CLEAR (Bit 30)                          */
#define CTIMER_STCFG_CLEAR_Msk            (0x40000000UL)            /*!< CTIMER STCFG: CLEAR (Bitfield-Mask: 0x01)             */
#define CTIMER_STCFG_COMPARE_H_EN_Pos     (15UL)                    /*!< CTIMER STCFG: COMPARE_H_EN (Bit 15)                   */
#define CTIMER_STCFG_COMPARE_H_EN_Msk     (0x8000UL)                /*!< CTIMER STCFG: COMPARE_H_EN (Bitfield-Mask: 0x01)      */
#define CTIMER_STCFG_COMPARE_G_EN_Pos     (14UL)                    /*!< CTIMER STCFG: COMPARE_G_EN (Bit 14)                   */
#define CTIMER_STCFG_COMPARE_G_EN_Msk     (0x4000UL)                /*!< CTIMER STCFG: COMPARE_G_EN (Bitfield-Mask: 0x01)      */
#define CTIMER_STCFG_COMPARE_F_EN_Pos     (13UL)                    /*!< CTIMER STCFG: COMPARE_F_EN (Bit 13)                   */
#define CTIMER_STCFG_COMPARE_F_EN_Msk     (0x2000UL)                /*!< CTIMER STCFG: COMPARE_F_EN (Bitfield-Mask: 0x01)      */
#define CTIMER_STCFG_COMPARE_E_EN_Pos     (12UL)                    /*!< CTIMER STCFG: COMPARE_E_EN (Bit 12)                   */
#define CTIMER_STCFG_COMPARE_E_EN_Msk     (0x1000UL)                /*!< CTIMER STCFG: COMPARE_E_EN (Bitfield-Mask: 0x01)      */
#define CTIMER_STCFG_COMPARE_D_EN_Pos     (11UL)                    /*!< CTIMER STCFG: COMPARE_D_EN (Bit 11)                   */
#define CTIMER_STCFG_COMPARE_D_EN_Msk     (0x800UL)                 /*!< CTIMER STCFG: COMPARE_D_EN (Bitfield-Mask: 0x01)      */
#define CTIMER_STCFG_COMPARE_C_EN_Pos     (10UL)                    /*!< CTIMER STCFG: COMPARE_C_EN (Bit 10)                   */
#define CTIMER_STCFG_COMPARE_C_EN_Msk     (0x400UL)                 /*!< CTIMER STCFG: COMPARE_C_EN (Bitfield-Mask: 0x01)      */
#define CTIMER_STCFG_COMPARE_B_EN_Pos     (9UL)                     /*!< CTIMER STCFG: COMPARE_B_EN (Bit 9)                    */
#define CTIMER_STCFG_COMPARE_B_EN_Msk     (0x200UL)                 /*!< CTIMER STCFG: COMPARE_B_EN (Bitfield-Mask: 0x01)      */
#define CTIMER_STCFG_COMPARE_A_EN_Pos     (8UL)                     /*!< CTIMER STCFG: COMPARE_A_EN (Bit 8)                    */
#define CTIMER_STCFG_COMPARE_A_EN_Msk     (0x100UL)                 /*!< CTIMER STCFG: COMPARE_A_EN (Bitfield-Mask: 0x01)      */
#define CTIMER_STCFG_CLKSEL_Pos           (0UL)                     /*!< CTIMER STCFG: CLKSEL (Bit 0)                          */
#define CTIMER_STCFG_CLKSEL_Msk           (0xfUL)                   /*!< CTIMER STCFG: CLKSEL (Bitfield-Mask: 0x0f)            */
/* =========================================================  STTMR  ========================================================= */
#define CTIMER_STTMR_STTMR_Pos            (0UL)                     /*!< CTIMER STTMR: STTMR (Bit 0)                           */
#define CTIMER_STTMR_STTMR_Msk            (0xffffffffUL)            /*!< CTIMER STTMR: STTMR (Bitfield-Mask: 0xffffffff)       */
/* ====================================================  CAPTURECONTROL  ===================================================== */
#define CTIMER_CAPTURECONTROL_CAPTURE3_Pos (3UL)                    /*!< CTIMER CAPTURECONTROL: CAPTURE3 (Bit 3)               */
#define CTIMER_CAPTURECONTROL_CAPTURE3_Msk (0x8UL)                  /*!< CTIMER CAPTURECONTROL: CAPTURE3 (Bitfield-Mask: 0x01) */
#define CTIMER_CAPTURECONTROL_CAPTURE2_Pos (2UL)                    /*!< CTIMER CAPTURECONTROL: CAPTURE2 (Bit 2)               */
#define CTIMER_CAPTURECONTROL_CAPTURE2_Msk (0x4UL)                  /*!< CTIMER CAPTURECONTROL: CAPTURE2 (Bitfield-Mask: 0x01) */
#define CTIMER_CAPTURECONTROL_CAPTURE1_Pos (1UL)                    /*!< CTIMER CAPTURECONTROL: CAPTURE1 (Bit 1)               */
#define CTIMER_CAPTURECONTROL_CAPTURE1_Msk (0x2UL)                  /*!< CTIMER CAPTURECONTROL: CAPTURE1 (Bitfield-Mask: 0x01) */
#define CTIMER_CAPTURECONTROL_CAPTURE0_Pos (0UL)                    /*!< CTIMER CAPTURECONTROL: CAPTURE0 (Bit 0)               */
#define CTIMER_CAPTURECONTROL_CAPTURE0_Msk (0x1UL)                  /*!< CTIMER CAPTURECONTROL: CAPTURE0 (Bitfield-Mask: 0x01) */
/* ========================================================  SCMPR0  ========================================================= */
#define CTIMER_SCMPR0_SCMPR0_Pos          (0UL)                     /*!< CTIMER SCMPR0: SCMPR0 (Bit 0)                         */
#define CTIMER_SCMPR0_SCMPR0_Msk          (0xffffffffUL)            /*!< CTIMER SCMPR0: SCMPR0 (Bitfield-Mask: 0xffffffff)     */
/* ========================================================  SCMPR1  ========================================================= */
#define CTIMER_SCMPR1_SCMPR1_Pos          (0UL)                     /*!< CTIMER SCMPR1: SCMPR1 (Bit 0)                         */
#define CTIMER_SCMPR1_SCMPR1_Msk          (0xffffffffUL)            /*!< CTIMER SCMPR1: SCMPR1 (Bitfield-Mask: 0xffffffff)     */
/* ========================================================  SCMPR2  ========================================================= */
#define CTIMER_SCMPR2_SCMPR2_Pos          (0UL)                     /*!< CTIMER SCMPR2: SCMPR2 (Bit 0)                         */
#define CTIMER_SCMPR2_SCMPR2_Msk          (0xffffffffUL)            /*!< CTIMER SCMPR2: SCMPR2 (Bitfield-Mask: 0xffffffff)     */
/* ========================================================  SCMPR3  ========================================================= */
#define CTIMER_SCMPR3_SCMPR3_Pos          (0UL)                     /*!< CTIMER SCMPR3: SCMPR3 (Bit 0)                         */
#define CTIMER_SCMPR3_SCMPR3_Msk          (0xffffffffUL)            /*!< CTIMER SCMPR3: SCMPR3 (Bitfield-Mask: 0xffffffff)     */
/* ========================================================  SCMPR4  ========================================================= */
#define CTIMER_SCMPR4_SCMPR4_Pos          (0UL)                     /*!< CTIMER SCMPR4: SCMPR4 (Bit 0)                         */
#define CTIMER_SCMPR4_SCMPR4_Msk          (0xffffffffUL)            /*!< CTIMER SCMPR4: SCMPR4 (Bitfield-Mask: 0xffffffff)     */
/* ========================================================  SCMPR5  ========================================================= */
#define CTIMER_SCMPR5_SCMPR5_Pos          (0UL)                     /*!< CTIMER SCMPR5: SCMPR5 (Bit 0)                         */
#define CTIMER_SCMPR5_SCMPR5_Msk          (0xffffffffUL)            /*!< CTIMER SCMPR5: SCMPR5 (Bitfield-Mask: 0xffffffff)     */
/* ========================================================  SCMPR6  ========================================================= */
#define CTIMER_SCMPR6_SCMPR6_Pos          (0UL)                     /*!< CTIMER SCMPR6: SCMPR6 (Bit 0)                         */
#define CTIMER_SCMPR6_SCMPR6_Msk          (0xffffffffUL)            /*!< CTIMER SCMPR6: SCMPR6 (Bitfield-Mask: 0xffffffff)     */
/* ========================================================  SCMPR7  ========================================================= */
#define CTIMER_SCMPR7_SCMPR7_Pos          (0UL)                     /*!< CTIMER SCMPR7: SCMPR7 (Bit 0)                         */
#define CTIMER_SCMPR7_SCMPR7_Msk          (0xffffffffUL)            /*!< CTIMER SCMPR7: SCMPR7 (Bitfield-Mask: 0xffffffff)     */
/* ========================================================  SCAPT0  ========================================================= */
#define CTIMER_SCAPT0_SCAPT0_Pos          (0UL)                     /*!< CTIMER SCAPT0: SCAPT0 (Bit 0)                         */
#define CTIMER_SCAPT0_SCAPT0_Msk          (0xffffffffUL)            /*!< CTIMER SCAPT0: SCAPT0 (Bitfield-Mask: 0xffffffff)     */
/* ========================================================  SCAPT1  ========================================================= */
#define CTIMER_SCAPT1_SCAPT1_Pos          (0UL)                     /*!< CTIMER SCAPT1: SCAPT1 (Bit 0)                         */
#define CTIMER_SCAPT1_SCAPT1_Msk          (0xffffffffUL)            /*!< CTIMER SCAPT1: SCAPT1 (Bitfield-Mask: 0xffffffff)     */
/* ========================================================  SCAPT2  ========================================================= */
#define CTIMER_SCAPT2_SCAPT2_Pos          (0UL)                     /*!< CTIMER SCAPT2: SCAPT2 (Bit 0)                         */
#define CTIMER_SCAPT2_SCAPT2_Msk          (0xffffffffUL)            /*!< CTIMER SCAPT2: SCAPT2 (Bitfield-Mask: 0xffffffff)     */
/* ========================================================  SCAPT3  ========================================================= */
#define CTIMER_SCAPT3_SCAPT3_Pos          (0UL)                     /*!< CTIMER SCAPT3: SCAPT3 (Bit 0)                         */
#define CTIMER_SCAPT3_SCAPT3_Msk          (0xffffffffUL)            /*!< CTIMER SCAPT3: SCAPT3 (Bitfield-Mask: 0xffffffff)     */
/* =========================================================  SNVR0  ========================================================= */
#define CTIMER_SNVR0_SNVR0_Pos            (0UL)                     /*!< CTIMER SNVR0: SNVR0 (Bit 0)                           */
#define CTIMER_SNVR0_SNVR0_Msk            (0xffffffffUL)            /*!< CTIMER SNVR0: SNVR0 (Bitfield-Mask: 0xffffffff)       */
/* =========================================================  SNVR1  ========================================================= */
#define CTIMER_SNVR1_SNVR1_Pos            (0UL)                     /*!< CTIMER SNVR1: SNVR1 (Bit 0)                           */
#define CTIMER_SNVR1_SNVR1_Msk            (0xffffffffUL)            /*!< CTIMER SNVR1: SNVR1 (Bitfield-Mask: 0xffffffff)       */
/* =========================================================  SNVR2  ========================================================= */
#define CTIMER_SNVR2_SNVR2_Pos            (0UL)                     /*!< CTIMER SNVR2: SNVR2 (Bit 0)                           */
#define CTIMER_SNVR2_SNVR2_Msk            (0xffffffffUL)            /*!< CTIMER SNVR2: SNVR2 (Bitfield-Mask: 0xffffffff)       */
/* =========================================================  SNVR3  ========================================================= */
#define CTIMER_SNVR3_SNVR3_Pos            (0UL)                     /*!< CTIMER SNVR3: SNVR3 (Bit 0)                           */
#define CTIMER_SNVR3_SNVR3_Msk            (0xffffffffUL)            /*!< CTIMER SNVR3: SNVR3 (Bitfield-Mask: 0xffffffff)       */
/* =========================================================  INTEN  ========================================================= */
#define CTIMER_INTEN_CTMRB7C1INT_Pos      (31UL)                    /*!< CTIMER INTEN: CTMRB7C1INT (Bit 31)                    */
#define CTIMER_INTEN_CTMRB7C1INT_Msk      (0x80000000UL)            /*!< CTIMER INTEN: CTMRB7C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA7C1INT_Pos      (30UL)                    /*!< CTIMER INTEN: CTMRA7C1INT (Bit 30)                    */
#define CTIMER_INTEN_CTMRA7C1INT_Msk      (0x40000000UL)            /*!< CTIMER INTEN: CTMRA7C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB6C1INT_Pos      (29UL)                    /*!< CTIMER INTEN: CTMRB6C1INT (Bit 29)                    */
#define CTIMER_INTEN_CTMRB6C1INT_Msk      (0x20000000UL)            /*!< CTIMER INTEN: CTMRB6C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA6C1INT_Pos      (28UL)                    /*!< CTIMER INTEN: CTMRA6C1INT (Bit 28)                    */
#define CTIMER_INTEN_CTMRA6C1INT_Msk      (0x10000000UL)            /*!< CTIMER INTEN: CTMRA6C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB5C1INT_Pos      (27UL)                    /*!< CTIMER INTEN: CTMRB5C1INT (Bit 27)                    */
#define CTIMER_INTEN_CTMRB5C1INT_Msk      (0x8000000UL)             /*!< CTIMER INTEN: CTMRB5C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA5C1INT_Pos      (26UL)                    /*!< CTIMER INTEN: CTMRA5C1INT (Bit 26)                    */
#define CTIMER_INTEN_CTMRA5C1INT_Msk      (0x4000000UL)             /*!< CTIMER INTEN: CTMRA5C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB4C1INT_Pos      (25UL)                    /*!< CTIMER INTEN: CTMRB4C1INT (Bit 25)                    */
#define CTIMER_INTEN_CTMRB4C1INT_Msk      (0x2000000UL)             /*!< CTIMER INTEN: CTMRB4C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA4C1INT_Pos      (24UL)                    /*!< CTIMER INTEN: CTMRA4C1INT (Bit 24)                    */
#define CTIMER_INTEN_CTMRA4C1INT_Msk      (0x1000000UL)             /*!< CTIMER INTEN: CTMRA4C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB3C1INT_Pos      (23UL)                    /*!< CTIMER INTEN: CTMRB3C1INT (Bit 23)                    */
#define CTIMER_INTEN_CTMRB3C1INT_Msk      (0x800000UL)              /*!< CTIMER INTEN: CTMRB3C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA3C1INT_Pos      (22UL)                    /*!< CTIMER INTEN: CTMRA3C1INT (Bit 22)                    */
#define CTIMER_INTEN_CTMRA3C1INT_Msk      (0x400000UL)              /*!< CTIMER INTEN: CTMRA3C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB2C1INT_Pos      (21UL)                    /*!< CTIMER INTEN: CTMRB2C1INT (Bit 21)                    */
#define CTIMER_INTEN_CTMRB2C1INT_Msk      (0x200000UL)              /*!< CTIMER INTEN: CTMRB2C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA2C1INT_Pos      (20UL)                    /*!< CTIMER INTEN: CTMRA2C1INT (Bit 20)                    */
#define CTIMER_INTEN_CTMRA2C1INT_Msk      (0x100000UL)              /*!< CTIMER INTEN: CTMRA2C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB1C1INT_Pos      (19UL)                    /*!< CTIMER INTEN: CTMRB1C1INT (Bit 19)                    */
#define CTIMER_INTEN_CTMRB1C1INT_Msk      (0x80000UL)               /*!< CTIMER INTEN: CTMRB1C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA1C1INT_Pos      (18UL)                    /*!< CTIMER INTEN: CTMRA1C1INT (Bit 18)                    */
#define CTIMER_INTEN_CTMRA1C1INT_Msk      (0x40000UL)               /*!< CTIMER INTEN: CTMRA1C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB0C1INT_Pos      (17UL)                    /*!< CTIMER INTEN: CTMRB0C1INT (Bit 17)                    */
#define CTIMER_INTEN_CTMRB0C1INT_Msk      (0x20000UL)               /*!< CTIMER INTEN: CTMRB0C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA0C1INT_Pos      (16UL)                    /*!< CTIMER INTEN: CTMRA0C1INT (Bit 16)                    */
#define CTIMER_INTEN_CTMRA0C1INT_Msk      (0x10000UL)               /*!< CTIMER INTEN: CTMRA0C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB7C0INT_Pos      (15UL)                    /*!< CTIMER INTEN: CTMRB7C0INT (Bit 15)                    */
#define CTIMER_INTEN_CTMRB7C0INT_Msk      (0x8000UL)                /*!< CTIMER INTEN: CTMRB7C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA7C0INT_Pos      (14UL)                    /*!< CTIMER INTEN: CTMRA7C0INT (Bit 14)                    */
#define CTIMER_INTEN_CTMRA7C0INT_Msk      (0x4000UL)                /*!< CTIMER INTEN: CTMRA7C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB6C0INT_Pos      (13UL)                    /*!< CTIMER INTEN: CTMRB6C0INT (Bit 13)                    */
#define CTIMER_INTEN_CTMRB6C0INT_Msk      (0x2000UL)                /*!< CTIMER INTEN: CTMRB6C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA6C0INT_Pos      (12UL)                    /*!< CTIMER INTEN: CTMRA6C0INT (Bit 12)                    */
#define CTIMER_INTEN_CTMRA6C0INT_Msk      (0x1000UL)                /*!< CTIMER INTEN: CTMRA6C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB5C0INT_Pos      (11UL)                    /*!< CTIMER INTEN: CTMRB5C0INT (Bit 11)                    */
#define CTIMER_INTEN_CTMRB5C0INT_Msk      (0x800UL)                 /*!< CTIMER INTEN: CTMRB5C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA5C0INT_Pos      (10UL)                    /*!< CTIMER INTEN: CTMRA5C0INT (Bit 10)                    */
#define CTIMER_INTEN_CTMRA5C0INT_Msk      (0x400UL)                 /*!< CTIMER INTEN: CTMRA5C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB4C0INT_Pos      (9UL)                     /*!< CTIMER INTEN: CTMRB4C0INT (Bit 9)                     */
#define CTIMER_INTEN_CTMRB4C0INT_Msk      (0x200UL)                 /*!< CTIMER INTEN: CTMRB4C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA4C0INT_Pos      (8UL)                     /*!< CTIMER INTEN: CTMRA4C0INT (Bit 8)                     */
#define CTIMER_INTEN_CTMRA4C0INT_Msk      (0x100UL)                 /*!< CTIMER INTEN: CTMRA4C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB3C0INT_Pos      (7UL)                     /*!< CTIMER INTEN: CTMRB3C0INT (Bit 7)                     */
#define CTIMER_INTEN_CTMRB3C0INT_Msk      (0x80UL)                  /*!< CTIMER INTEN: CTMRB3C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA3C0INT_Pos      (6UL)                     /*!< CTIMER INTEN: CTMRA3C0INT (Bit 6)                     */
#define CTIMER_INTEN_CTMRA3C0INT_Msk      (0x40UL)                  /*!< CTIMER INTEN: CTMRA3C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB2C0INT_Pos      (5UL)                     /*!< CTIMER INTEN: CTMRB2C0INT (Bit 5)                     */
#define CTIMER_INTEN_CTMRB2C0INT_Msk      (0x20UL)                  /*!< CTIMER INTEN: CTMRB2C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA2C0INT_Pos      (4UL)                     /*!< CTIMER INTEN: CTMRA2C0INT (Bit 4)                     */
#define CTIMER_INTEN_CTMRA2C0INT_Msk      (0x10UL)                  /*!< CTIMER INTEN: CTMRA2C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB1C0INT_Pos      (3UL)                     /*!< CTIMER INTEN: CTMRB1C0INT (Bit 3)                     */
#define CTIMER_INTEN_CTMRB1C0INT_Msk      (0x8UL)                   /*!< CTIMER INTEN: CTMRB1C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA1C0INT_Pos      (2UL)                     /*!< CTIMER INTEN: CTMRA1C0INT (Bit 2)                     */
#define CTIMER_INTEN_CTMRA1C0INT_Msk      (0x4UL)                   /*!< CTIMER INTEN: CTMRA1C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB0C0INT_Pos      (1UL)                     /*!< CTIMER INTEN: CTMRB0C0INT (Bit 1)                     */
#define CTIMER_INTEN_CTMRB0C0INT_Msk      (0x2UL)                   /*!< CTIMER INTEN: CTMRB0C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA0C0INT_Pos      (0UL)                     /*!< CTIMER INTEN: CTMRA0C0INT (Bit 0)                     */
#define CTIMER_INTEN_CTMRA0C0INT_Msk      (0x1UL)                   /*!< CTIMER INTEN: CTMRA0C0INT (Bitfield-Mask: 0x01)       */
/* ========================================================  INTSTAT  ======================================================== */
#define CTIMER_INTSTAT_CTMRB7C1INT_Pos    (31UL)                    /*!< CTIMER INTSTAT: CTMRB7C1INT (Bit 31)                  */
#define CTIMER_INTSTAT_CTMRB7C1INT_Msk    (0x80000000UL)            /*!< CTIMER INTSTAT: CTMRB7C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA7C1INT_Pos    (30UL)                    /*!< CTIMER INTSTAT: CTMRA7C1INT (Bit 30)                  */
#define CTIMER_INTSTAT_CTMRA7C1INT_Msk    (0x40000000UL)            /*!< CTIMER INTSTAT: CTMRA7C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB6C1INT_Pos    (29UL)                    /*!< CTIMER INTSTAT: CTMRB6C1INT (Bit 29)                  */
#define CTIMER_INTSTAT_CTMRB6C1INT_Msk    (0x20000000UL)            /*!< CTIMER INTSTAT: CTMRB6C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA6C1INT_Pos    (28UL)                    /*!< CTIMER INTSTAT: CTMRA6C1INT (Bit 28)                  */
#define CTIMER_INTSTAT_CTMRA6C1INT_Msk    (0x10000000UL)            /*!< CTIMER INTSTAT: CTMRA6C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB5C1INT_Pos    (27UL)                    /*!< CTIMER INTSTAT: CTMRB5C1INT (Bit 27)                  */
#define CTIMER_INTSTAT_CTMRB5C1INT_Msk    (0x8000000UL)             /*!< CTIMER INTSTAT: CTMRB5C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA5C1INT_Pos    (26UL)                    /*!< CTIMER INTSTAT: CTMRA5C1INT (Bit 26)                  */
#define CTIMER_INTSTAT_CTMRA5C1INT_Msk    (0x4000000UL)             /*!< CTIMER INTSTAT: CTMRA5C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB4C1INT_Pos    (25UL)                    /*!< CTIMER INTSTAT: CTMRB4C1INT (Bit 25)                  */
#define CTIMER_INTSTAT_CTMRB4C1INT_Msk    (0x2000000UL)             /*!< CTIMER INTSTAT: CTMRB4C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA4C1INT_Pos    (24UL)                    /*!< CTIMER INTSTAT: CTMRA4C1INT (Bit 24)                  */
#define CTIMER_INTSTAT_CTMRA4C1INT_Msk    (0x1000000UL)             /*!< CTIMER INTSTAT: CTMRA4C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB3C1INT_Pos    (23UL)                    /*!< CTIMER INTSTAT: CTMRB3C1INT (Bit 23)                  */
#define CTIMER_INTSTAT_CTMRB3C1INT_Msk    (0x800000UL)              /*!< CTIMER INTSTAT: CTMRB3C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA3C1INT_Pos    (22UL)                    /*!< CTIMER INTSTAT: CTMRA3C1INT (Bit 22)                  */
#define CTIMER_INTSTAT_CTMRA3C1INT_Msk    (0x400000UL)              /*!< CTIMER INTSTAT: CTMRA3C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB2C1INT_Pos    (21UL)                    /*!< CTIMER INTSTAT: CTMRB2C1INT (Bit 21)                  */
#define CTIMER_INTSTAT_CTMRB2C1INT_Msk    (0x200000UL)              /*!< CTIMER INTSTAT: CTMRB2C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA2C1INT_Pos    (20UL)                    /*!< CTIMER INTSTAT: CTMRA2C1INT (Bit 20)                  */
#define CTIMER_INTSTAT_CTMRA2C1INT_Msk    (0x100000UL)              /*!< CTIMER INTSTAT: CTMRA2C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB1C1INT_Pos    (19UL)                    /*!< CTIMER INTSTAT: CTMRB1C1INT (Bit 19)                  */
#define CTIMER_INTSTAT_CTMRB1C1INT_Msk    (0x80000UL)               /*!< CTIMER INTSTAT: CTMRB1C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA1C1INT_Pos    (18UL)                    /*!< CTIMER INTSTAT: CTMRA1C1INT (Bit 18)                  */
#define CTIMER_INTSTAT_CTMRA1C1INT_Msk    (0x40000UL)               /*!< CTIMER INTSTAT: CTMRA1C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB0C1INT_Pos    (17UL)                    /*!< CTIMER INTSTAT: CTMRB0C1INT (Bit 17)                  */
#define CTIMER_INTSTAT_CTMRB0C1INT_Msk    (0x20000UL)               /*!< CTIMER INTSTAT: CTMRB0C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA0C1INT_Pos    (16UL)                    /*!< CTIMER INTSTAT: CTMRA0C1INT (Bit 16)                  */
#define CTIMER_INTSTAT_CTMRA0C1INT_Msk    (0x10000UL)               /*!< CTIMER INTSTAT: CTMRA0C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB7C0INT_Pos    (15UL)                    /*!< CTIMER INTSTAT: CTMRB7C0INT (Bit 15)                  */
#define CTIMER_INTSTAT_CTMRB7C0INT_Msk    (0x8000UL)                /*!< CTIMER INTSTAT: CTMRB7C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA7C0INT_Pos    (14UL)                    /*!< CTIMER INTSTAT: CTMRA7C0INT (Bit 14)                  */
#define CTIMER_INTSTAT_CTMRA7C0INT_Msk    (0x4000UL)                /*!< CTIMER INTSTAT: CTMRA7C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB6C0INT_Pos    (13UL)                    /*!< CTIMER INTSTAT: CTMRB6C0INT (Bit 13)                  */
#define CTIMER_INTSTAT_CTMRB6C0INT_Msk    (0x2000UL)                /*!< CTIMER INTSTAT: CTMRB6C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA6C0INT_Pos    (12UL)                    /*!< CTIMER INTSTAT: CTMRA6C0INT (Bit 12)                  */
#define CTIMER_INTSTAT_CTMRA6C0INT_Msk    (0x1000UL)                /*!< CTIMER INTSTAT: CTMRA6C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB5C0INT_Pos    (11UL)                    /*!< CTIMER INTSTAT: CTMRB5C0INT (Bit 11)                  */
#define CTIMER_INTSTAT_CTMRB5C0INT_Msk    (0x800UL)                 /*!< CTIMER INTSTAT: CTMRB5C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA5C0INT_Pos    (10UL)                    /*!< CTIMER INTSTAT: CTMRA5C0INT (Bit 10)                  */
#define CTIMER_INTSTAT_CTMRA5C0INT_Msk    (0x400UL)                 /*!< CTIMER INTSTAT: CTMRA5C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB4C0INT_Pos    (9UL)                     /*!< CTIMER INTSTAT: CTMRB4C0INT (Bit 9)                   */
#define CTIMER_INTSTAT_CTMRB4C0INT_Msk    (0x200UL)                 /*!< CTIMER INTSTAT: CTMRB4C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA4C0INT_Pos    (8UL)                     /*!< CTIMER INTSTAT: CTMRA4C0INT (Bit 8)                   */
#define CTIMER_INTSTAT_CTMRA4C0INT_Msk    (0x100UL)                 /*!< CTIMER INTSTAT: CTMRA4C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB3C0INT_Pos    (7UL)                     /*!< CTIMER INTSTAT: CTMRB3C0INT (Bit 7)                   */
#define CTIMER_INTSTAT_CTMRB3C0INT_Msk    (0x80UL)                  /*!< CTIMER INTSTAT: CTMRB3C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA3C0INT_Pos    (6UL)                     /*!< CTIMER INTSTAT: CTMRA3C0INT (Bit 6)                   */
#define CTIMER_INTSTAT_CTMRA3C0INT_Msk    (0x40UL)                  /*!< CTIMER INTSTAT: CTMRA3C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB2C0INT_Pos    (5UL)                     /*!< CTIMER INTSTAT: CTMRB2C0INT (Bit 5)                   */
#define CTIMER_INTSTAT_CTMRB2C0INT_Msk    (0x20UL)                  /*!< CTIMER INTSTAT: CTMRB2C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA2C0INT_Pos    (4UL)                     /*!< CTIMER INTSTAT: CTMRA2C0INT (Bit 4)                   */
#define CTIMER_INTSTAT_CTMRA2C0INT_Msk    (0x10UL)                  /*!< CTIMER INTSTAT: CTMRA2C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB1C0INT_Pos    (3UL)                     /*!< CTIMER INTSTAT: CTMRB1C0INT (Bit 3)                   */
#define CTIMER_INTSTAT_CTMRB1C0INT_Msk    (0x8UL)                   /*!< CTIMER INTSTAT: CTMRB1C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA1C0INT_Pos    (2UL)                     /*!< CTIMER INTSTAT: CTMRA1C0INT (Bit 2)                   */
#define CTIMER_INTSTAT_CTMRA1C0INT_Msk    (0x4UL)                   /*!< CTIMER INTSTAT: CTMRA1C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB0C0INT_Pos    (1UL)                     /*!< CTIMER INTSTAT: CTMRB0C0INT (Bit 1)                   */
#define CTIMER_INTSTAT_CTMRB0C0INT_Msk    (0x2UL)                   /*!< CTIMER INTSTAT: CTMRB0C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA0C0INT_Pos    (0UL)                     /*!< CTIMER INTSTAT: CTMRA0C0INT (Bit 0)                   */
#define CTIMER_INTSTAT_CTMRA0C0INT_Msk    (0x1UL)                   /*!< CTIMER INTSTAT: CTMRA0C0INT (Bitfield-Mask: 0x01)     */
/* ========================================================  INTCLR  ========================================================= */
#define CTIMER_INTCLR_CTMRB7C1INT_Pos     (31UL)                    /*!< CTIMER INTCLR: CTMRB7C1INT (Bit 31)                   */
#define CTIMER_INTCLR_CTMRB7C1INT_Msk     (0x80000000UL)            /*!< CTIMER INTCLR: CTMRB7C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA7C1INT_Pos     (30UL)                    /*!< CTIMER INTCLR: CTMRA7C1INT (Bit 30)                   */
#define CTIMER_INTCLR_CTMRA7C1INT_Msk     (0x40000000UL)            /*!< CTIMER INTCLR: CTMRA7C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB6C1INT_Pos     (29UL)                    /*!< CTIMER INTCLR: CTMRB6C1INT (Bit 29)                   */
#define CTIMER_INTCLR_CTMRB6C1INT_Msk     (0x20000000UL)            /*!< CTIMER INTCLR: CTMRB6C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA6C1INT_Pos     (28UL)                    /*!< CTIMER INTCLR: CTMRA6C1INT (Bit 28)                   */
#define CTIMER_INTCLR_CTMRA6C1INT_Msk     (0x10000000UL)            /*!< CTIMER INTCLR: CTMRA6C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB5C1INT_Pos     (27UL)                    /*!< CTIMER INTCLR: CTMRB5C1INT (Bit 27)                   */
#define CTIMER_INTCLR_CTMRB5C1INT_Msk     (0x8000000UL)             /*!< CTIMER INTCLR: CTMRB5C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA5C1INT_Pos     (26UL)                    /*!< CTIMER INTCLR: CTMRA5C1INT (Bit 26)                   */
#define CTIMER_INTCLR_CTMRA5C1INT_Msk     (0x4000000UL)             /*!< CTIMER INTCLR: CTMRA5C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB4C1INT_Pos     (25UL)                    /*!< CTIMER INTCLR: CTMRB4C1INT (Bit 25)                   */
#define CTIMER_INTCLR_CTMRB4C1INT_Msk     (0x2000000UL)             /*!< CTIMER INTCLR: CTMRB4C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA4C1INT_Pos     (24UL)                    /*!< CTIMER INTCLR: CTMRA4C1INT (Bit 24)                   */
#define CTIMER_INTCLR_CTMRA4C1INT_Msk     (0x1000000UL)             /*!< CTIMER INTCLR: CTMRA4C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB3C1INT_Pos     (23UL)                    /*!< CTIMER INTCLR: CTMRB3C1INT (Bit 23)                   */
#define CTIMER_INTCLR_CTMRB3C1INT_Msk     (0x800000UL)              /*!< CTIMER INTCLR: CTMRB3C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA3C1INT_Pos     (22UL)                    /*!< CTIMER INTCLR: CTMRA3C1INT (Bit 22)                   */
#define CTIMER_INTCLR_CTMRA3C1INT_Msk     (0x400000UL)              /*!< CTIMER INTCLR: CTMRA3C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB2C1INT_Pos     (21UL)                    /*!< CTIMER INTCLR: CTMRB2C1INT (Bit 21)                   */
#define CTIMER_INTCLR_CTMRB2C1INT_Msk     (0x200000UL)              /*!< CTIMER INTCLR: CTMRB2C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA2C1INT_Pos     (20UL)                    /*!< CTIMER INTCLR: CTMRA2C1INT (Bit 20)                   */
#define CTIMER_INTCLR_CTMRA2C1INT_Msk     (0x100000UL)              /*!< CTIMER INTCLR: CTMRA2C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB1C1INT_Pos     (19UL)                    /*!< CTIMER INTCLR: CTMRB1C1INT (Bit 19)                   */
#define CTIMER_INTCLR_CTMRB1C1INT_Msk     (0x80000UL)               /*!< CTIMER INTCLR: CTMRB1C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA1C1INT_Pos     (18UL)                    /*!< CTIMER INTCLR: CTMRA1C1INT (Bit 18)                   */
#define CTIMER_INTCLR_CTMRA1C1INT_Msk     (0x40000UL)               /*!< CTIMER INTCLR: CTMRA1C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB0C1INT_Pos     (17UL)                    /*!< CTIMER INTCLR: CTMRB0C1INT (Bit 17)                   */
#define CTIMER_INTCLR_CTMRB0C1INT_Msk     (0x20000UL)               /*!< CTIMER INTCLR: CTMRB0C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA0C1INT_Pos     (16UL)                    /*!< CTIMER INTCLR: CTMRA0C1INT (Bit 16)                   */
#define CTIMER_INTCLR_CTMRA0C1INT_Msk     (0x10000UL)               /*!< CTIMER INTCLR: CTMRA0C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB7C0INT_Pos     (15UL)                    /*!< CTIMER INTCLR: CTMRB7C0INT (Bit 15)                   */
#define CTIMER_INTCLR_CTMRB7C0INT_Msk     (0x8000UL)                /*!< CTIMER INTCLR: CTMRB7C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA7C0INT_Pos     (14UL)                    /*!< CTIMER INTCLR: CTMRA7C0INT (Bit 14)                   */
#define CTIMER_INTCLR_CTMRA7C0INT_Msk     (0x4000UL)                /*!< CTIMER INTCLR: CTMRA7C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB6C0INT_Pos     (13UL)                    /*!< CTIMER INTCLR: CTMRB6C0INT (Bit 13)                   */
#define CTIMER_INTCLR_CTMRB6C0INT_Msk     (0x2000UL)                /*!< CTIMER INTCLR: CTMRB6C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA6C0INT_Pos     (12UL)                    /*!< CTIMER INTCLR: CTMRA6C0INT (Bit 12)                   */
#define CTIMER_INTCLR_CTMRA6C0INT_Msk     (0x1000UL)                /*!< CTIMER INTCLR: CTMRA6C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB5C0INT_Pos     (11UL)                    /*!< CTIMER INTCLR: CTMRB5C0INT (Bit 11)                   */
#define CTIMER_INTCLR_CTMRB5C0INT_Msk     (0x800UL)                 /*!< CTIMER INTCLR: CTMRB5C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA5C0INT_Pos     (10UL)                    /*!< CTIMER INTCLR: CTMRA5C0INT (Bit 10)                   */
#define CTIMER_INTCLR_CTMRA5C0INT_Msk     (0x400UL)                 /*!< CTIMER INTCLR: CTMRA5C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB4C0INT_Pos     (9UL)                     /*!< CTIMER INTCLR: CTMRB4C0INT (Bit 9)                    */
#define CTIMER_INTCLR_CTMRB4C0INT_Msk     (0x200UL)                 /*!< CTIMER INTCLR: CTMRB4C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA4C0INT_Pos     (8UL)                     /*!< CTIMER INTCLR: CTMRA4C0INT (Bit 8)                    */
#define CTIMER_INTCLR_CTMRA4C0INT_Msk     (0x100UL)                 /*!< CTIMER INTCLR: CTMRA4C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB3C0INT_Pos     (7UL)                     /*!< CTIMER INTCLR: CTMRB3C0INT (Bit 7)                    */
#define CTIMER_INTCLR_CTMRB3C0INT_Msk     (0x80UL)                  /*!< CTIMER INTCLR: CTMRB3C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA3C0INT_Pos     (6UL)                     /*!< CTIMER INTCLR: CTMRA3C0INT (Bit 6)                    */
#define CTIMER_INTCLR_CTMRA3C0INT_Msk     (0x40UL)                  /*!< CTIMER INTCLR: CTMRA3C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB2C0INT_Pos     (5UL)                     /*!< CTIMER INTCLR: CTMRB2C0INT (Bit 5)                    */
#define CTIMER_INTCLR_CTMRB2C0INT_Msk     (0x20UL)                  /*!< CTIMER INTCLR: CTMRB2C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA2C0INT_Pos     (4UL)                     /*!< CTIMER INTCLR: CTMRA2C0INT (Bit 4)                    */
#define CTIMER_INTCLR_CTMRA2C0INT_Msk     (0x10UL)                  /*!< CTIMER INTCLR: CTMRA2C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB1C0INT_Pos     (3UL)                     /*!< CTIMER INTCLR: CTMRB1C0INT (Bit 3)                    */
#define CTIMER_INTCLR_CTMRB1C0INT_Msk     (0x8UL)                   /*!< CTIMER INTCLR: CTMRB1C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA1C0INT_Pos     (2UL)                     /*!< CTIMER INTCLR: CTMRA1C0INT (Bit 2)                    */
#define CTIMER_INTCLR_CTMRA1C0INT_Msk     (0x4UL)                   /*!< CTIMER INTCLR: CTMRA1C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB0C0INT_Pos     (1UL)                     /*!< CTIMER INTCLR: CTMRB0C0INT (Bit 1)                    */
#define CTIMER_INTCLR_CTMRB0C0INT_Msk     (0x2UL)                   /*!< CTIMER INTCLR: CTMRB0C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA0C0INT_Pos     (0UL)                     /*!< CTIMER INTCLR: CTMRA0C0INT (Bit 0)                    */
#define CTIMER_INTCLR_CTMRA0C0INT_Msk     (0x1UL)                   /*!< CTIMER INTCLR: CTMRA0C0INT (Bitfield-Mask: 0x01)      */
/* ========================================================  INTSET  ========================================================= */
#define CTIMER_INTSET_CTMRB7C1INT_Pos     (31UL)                    /*!< CTIMER INTSET: CTMRB7C1INT (Bit 31)                   */
#define CTIMER_INTSET_CTMRB7C1INT_Msk     (0x80000000UL)            /*!< CTIMER INTSET: CTMRB7C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA7C1INT_Pos     (30UL)                    /*!< CTIMER INTSET: CTMRA7C1INT (Bit 30)                   */
#define CTIMER_INTSET_CTMRA7C1INT_Msk     (0x40000000UL)            /*!< CTIMER INTSET: CTMRA7C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB6C1INT_Pos     (29UL)                    /*!< CTIMER INTSET: CTMRB6C1INT (Bit 29)                   */
#define CTIMER_INTSET_CTMRB6C1INT_Msk     (0x20000000UL)            /*!< CTIMER INTSET: CTMRB6C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA6C1INT_Pos     (28UL)                    /*!< CTIMER INTSET: CTMRA6C1INT (Bit 28)                   */
#define CTIMER_INTSET_CTMRA6C1INT_Msk     (0x10000000UL)            /*!< CTIMER INTSET: CTMRA6C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB5C1INT_Pos     (27UL)                    /*!< CTIMER INTSET: CTMRB5C1INT (Bit 27)                   */
#define CTIMER_INTSET_CTMRB5C1INT_Msk     (0x8000000UL)             /*!< CTIMER INTSET: CTMRB5C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA5C1INT_Pos     (26UL)                    /*!< CTIMER INTSET: CTMRA5C1INT (Bit 26)                   */
#define CTIMER_INTSET_CTMRA5C1INT_Msk     (0x4000000UL)             /*!< CTIMER INTSET: CTMRA5C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB4C1INT_Pos     (25UL)                    /*!< CTIMER INTSET: CTMRB4C1INT (Bit 25)                   */
#define CTIMER_INTSET_CTMRB4C1INT_Msk     (0x2000000UL)             /*!< CTIMER INTSET: CTMRB4C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA4C1INT_Pos     (24UL)                    /*!< CTIMER INTSET: CTMRA4C1INT (Bit 24)                   */
#define CTIMER_INTSET_CTMRA4C1INT_Msk     (0x1000000UL)             /*!< CTIMER INTSET: CTMRA4C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB3C1INT_Pos     (23UL)                    /*!< CTIMER INTSET: CTMRB3C1INT (Bit 23)                   */
#define CTIMER_INTSET_CTMRB3C1INT_Msk     (0x800000UL)              /*!< CTIMER INTSET: CTMRB3C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA3C1INT_Pos     (22UL)                    /*!< CTIMER INTSET: CTMRA3C1INT (Bit 22)                   */
#define CTIMER_INTSET_CTMRA3C1INT_Msk     (0x400000UL)              /*!< CTIMER INTSET: CTMRA3C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB2C1INT_Pos     (21UL)                    /*!< CTIMER INTSET: CTMRB2C1INT (Bit 21)                   */
#define CTIMER_INTSET_CTMRB2C1INT_Msk     (0x200000UL)              /*!< CTIMER INTSET: CTMRB2C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA2C1INT_Pos     (20UL)                    /*!< CTIMER INTSET: CTMRA2C1INT (Bit 20)                   */
#define CTIMER_INTSET_CTMRA2C1INT_Msk     (0x100000UL)              /*!< CTIMER INTSET: CTMRA2C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB1C1INT_Pos     (19UL)                    /*!< CTIMER INTSET: CTMRB1C1INT (Bit 19)                   */
#define CTIMER_INTSET_CTMRB1C1INT_Msk     (0x80000UL)               /*!< CTIMER INTSET: CTMRB1C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA1C1INT_Pos     (18UL)                    /*!< CTIMER INTSET: CTMRA1C1INT (Bit 18)                   */
#define CTIMER_INTSET_CTMRA1C1INT_Msk     (0x40000UL)               /*!< CTIMER INTSET: CTMRA1C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB0C1INT_Pos     (17UL)                    /*!< CTIMER INTSET: CTMRB0C1INT (Bit 17)                   */
#define CTIMER_INTSET_CTMRB0C1INT_Msk     (0x20000UL)               /*!< CTIMER INTSET: CTMRB0C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA0C1INT_Pos     (16UL)                    /*!< CTIMER INTSET: CTMRA0C1INT (Bit 16)                   */
#define CTIMER_INTSET_CTMRA0C1INT_Msk     (0x10000UL)               /*!< CTIMER INTSET: CTMRA0C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB7C0INT_Pos     (15UL)                    /*!< CTIMER INTSET: CTMRB7C0INT (Bit 15)                   */
#define CTIMER_INTSET_CTMRB7C0INT_Msk     (0x8000UL)                /*!< CTIMER INTSET: CTMRB7C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA7C0INT_Pos     (14UL)                    /*!< CTIMER INTSET: CTMRA7C0INT (Bit 14)                   */
#define CTIMER_INTSET_CTMRA7C0INT_Msk     (0x4000UL)                /*!< CTIMER INTSET: CTMRA7C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB6C0INT_Pos     (13UL)                    /*!< CTIMER INTSET: CTMRB6C0INT (Bit 13)                   */
#define CTIMER_INTSET_CTMRB6C0INT_Msk     (0x2000UL)                /*!< CTIMER INTSET: CTMRB6C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA6C0INT_Pos     (12UL)                    /*!< CTIMER INTSET: CTMRA6C0INT (Bit 12)                   */
#define CTIMER_INTSET_CTMRA6C0INT_Msk     (0x1000UL)                /*!< CTIMER INTSET: CTMRA6C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB5C0INT_Pos     (11UL)                    /*!< CTIMER INTSET: CTMRB5C0INT (Bit 11)                   */
#define CTIMER_INTSET_CTMRB5C0INT_Msk     (0x800UL)                 /*!< CTIMER INTSET: CTMRB5C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA5C0INT_Pos     (10UL)                    /*!< CTIMER INTSET: CTMRA5C0INT (Bit 10)                   */
#define CTIMER_INTSET_CTMRA5C0INT_Msk     (0x400UL)                 /*!< CTIMER INTSET: CTMRA5C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB4C0INT_Pos     (9UL)                     /*!< CTIMER INTSET: CTMRB4C0INT (Bit 9)                    */
#define CTIMER_INTSET_CTMRB4C0INT_Msk     (0x200UL)                 /*!< CTIMER INTSET: CTMRB4C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA4C0INT_Pos     (8UL)                     /*!< CTIMER INTSET: CTMRA4C0INT (Bit 8)                    */
#define CTIMER_INTSET_CTMRA4C0INT_Msk     (0x100UL)                 /*!< CTIMER INTSET: CTMRA4C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB3C0INT_Pos     (7UL)                     /*!< CTIMER INTSET: CTMRB3C0INT (Bit 7)                    */
#define CTIMER_INTSET_CTMRB3C0INT_Msk     (0x80UL)                  /*!< CTIMER INTSET: CTMRB3C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA3C0INT_Pos     (6UL)                     /*!< CTIMER INTSET: CTMRA3C0INT (Bit 6)                    */
#define CTIMER_INTSET_CTMRA3C0INT_Msk     (0x40UL)                  /*!< CTIMER INTSET: CTMRA3C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB2C0INT_Pos     (5UL)                     /*!< CTIMER INTSET: CTMRB2C0INT (Bit 5)                    */
#define CTIMER_INTSET_CTMRB2C0INT_Msk     (0x20UL)                  /*!< CTIMER INTSET: CTMRB2C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA2C0INT_Pos     (4UL)                     /*!< CTIMER INTSET: CTMRA2C0INT (Bit 4)                    */
#define CTIMER_INTSET_CTMRA2C0INT_Msk     (0x10UL)                  /*!< CTIMER INTSET: CTMRA2C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB1C0INT_Pos     (3UL)                     /*!< CTIMER INTSET: CTMRB1C0INT (Bit 3)                    */
#define CTIMER_INTSET_CTMRB1C0INT_Msk     (0x8UL)                   /*!< CTIMER INTSET: CTMRB1C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA1C0INT_Pos     (2UL)                     /*!< CTIMER INTSET: CTMRA1C0INT (Bit 2)                    */
#define CTIMER_INTSET_CTMRA1C0INT_Msk     (0x4UL)                   /*!< CTIMER INTSET: CTMRA1C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB0C0INT_Pos     (1UL)                     /*!< CTIMER INTSET: CTMRB0C0INT (Bit 1)                    */
#define CTIMER_INTSET_CTMRB0C0INT_Msk     (0x2UL)                   /*!< CTIMER INTSET: CTMRB0C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA0C0INT_Pos     (0UL)                     /*!< CTIMER INTSET: CTMRA0C0INT (Bit 0)                    */
#define CTIMER_INTSET_CTMRA0C0INT_Msk     (0x1UL)                   /*!< CTIMER INTSET: CTMRA0C0INT (Bitfield-Mask: 0x01)      */
/* =======================================================  STMINTEN  ======================================================== */
#define CTIMER_STMINTEN_CAPTURED_Pos      (12UL)                    /*!< CTIMER STMINTEN: CAPTURED (Bit 12)                    */
#define CTIMER_STMINTEN_CAPTURED_Msk      (0x1000UL)                /*!< CTIMER STMINTEN: CAPTURED (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_CAPTUREC_Pos      (11UL)                    /*!< CTIMER STMINTEN: CAPTUREC (Bit 11)                    */
#define CTIMER_STMINTEN_CAPTUREC_Msk      (0x800UL)                 /*!< CTIMER STMINTEN: CAPTUREC (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_CAPTUREB_Pos      (10UL)                    /*!< CTIMER STMINTEN: CAPTUREB (Bit 10)                    */
#define CTIMER_STMINTEN_CAPTUREB_Msk      (0x400UL)                 /*!< CTIMER STMINTEN: CAPTUREB (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_CAPTUREA_Pos      (9UL)                     /*!< CTIMER STMINTEN: CAPTUREA (Bit 9)                     */
#define CTIMER_STMINTEN_CAPTUREA_Msk      (0x200UL)                 /*!< CTIMER STMINTEN: CAPTUREA (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_OVERFLOW_Pos      (8UL)                     /*!< CTIMER STMINTEN: OVERFLOW (Bit 8)                     */
#define CTIMER_STMINTEN_OVERFLOW_Msk      (0x100UL)                 /*!< CTIMER STMINTEN: OVERFLOW (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_COMPAREH_Pos      (7UL)                     /*!< CTIMER STMINTEN: COMPAREH (Bit 7)                     */
#define CTIMER_STMINTEN_COMPAREH_Msk      (0x80UL)                  /*!< CTIMER STMINTEN: COMPAREH (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_COMPAREG_Pos      (6UL)                     /*!< CTIMER STMINTEN: COMPAREG (Bit 6)                     */
#define CTIMER_STMINTEN_COMPAREG_Msk      (0x40UL)                  /*!< CTIMER STMINTEN: COMPAREG (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_COMPAREF_Pos      (5UL)                     /*!< CTIMER STMINTEN: COMPAREF (Bit 5)                     */
#define CTIMER_STMINTEN_COMPAREF_Msk      (0x20UL)                  /*!< CTIMER STMINTEN: COMPAREF (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_COMPAREE_Pos      (4UL)                     /*!< CTIMER STMINTEN: COMPAREE (Bit 4)                     */
#define CTIMER_STMINTEN_COMPAREE_Msk      (0x10UL)                  /*!< CTIMER STMINTEN: COMPAREE (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_COMPARED_Pos      (3UL)                     /*!< CTIMER STMINTEN: COMPARED (Bit 3)                     */
#define CTIMER_STMINTEN_COMPARED_Msk      (0x8UL)                   /*!< CTIMER STMINTEN: COMPARED (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_COMPAREC_Pos      (2UL)                     /*!< CTIMER STMINTEN: COMPAREC (Bit 2)                     */
#define CTIMER_STMINTEN_COMPAREC_Msk      (0x4UL)                   /*!< CTIMER STMINTEN: COMPAREC (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_COMPAREB_Pos      (1UL)                     /*!< CTIMER STMINTEN: COMPAREB (Bit 1)                     */
#define CTIMER_STMINTEN_COMPAREB_Msk      (0x2UL)                   /*!< CTIMER STMINTEN: COMPAREB (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_COMPAREA_Pos      (0UL)                     /*!< CTIMER STMINTEN: COMPAREA (Bit 0)                     */
#define CTIMER_STMINTEN_COMPAREA_Msk      (0x1UL)                   /*!< CTIMER STMINTEN: COMPAREA (Bitfield-Mask: 0x01)       */
/* ======================================================  STMINTSTAT  ======================================================= */
#define CTIMER_STMINTSTAT_CAPTURED_Pos    (12UL)                    /*!< CTIMER STMINTSTAT: CAPTURED (Bit 12)                  */
#define CTIMER_STMINTSTAT_CAPTURED_Msk    (0x1000UL)                /*!< CTIMER STMINTSTAT: CAPTURED (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_CAPTUREC_Pos    (11UL)                    /*!< CTIMER STMINTSTAT: CAPTUREC (Bit 11)                  */
#define CTIMER_STMINTSTAT_CAPTUREC_Msk    (0x800UL)                 /*!< CTIMER STMINTSTAT: CAPTUREC (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_CAPTUREB_Pos    (10UL)                    /*!< CTIMER STMINTSTAT: CAPTUREB (Bit 10)                  */
#define CTIMER_STMINTSTAT_CAPTUREB_Msk    (0x400UL)                 /*!< CTIMER STMINTSTAT: CAPTUREB (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_CAPTUREA_Pos    (9UL)                     /*!< CTIMER STMINTSTAT: CAPTUREA (Bit 9)                   */
#define CTIMER_STMINTSTAT_CAPTUREA_Msk    (0x200UL)                 /*!< CTIMER STMINTSTAT: CAPTUREA (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_OVERFLOW_Pos    (8UL)                     /*!< CTIMER STMINTSTAT: OVERFLOW (Bit 8)                   */
#define CTIMER_STMINTSTAT_OVERFLOW_Msk    (0x100UL)                 /*!< CTIMER STMINTSTAT: OVERFLOW (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_COMPAREH_Pos    (7UL)                     /*!< CTIMER STMINTSTAT: COMPAREH (Bit 7)                   */
#define CTIMER_STMINTSTAT_COMPAREH_Msk    (0x80UL)                  /*!< CTIMER STMINTSTAT: COMPAREH (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_COMPAREG_Pos    (6UL)                     /*!< CTIMER STMINTSTAT: COMPAREG (Bit 6)                   */
#define CTIMER_STMINTSTAT_COMPAREG_Msk    (0x40UL)                  /*!< CTIMER STMINTSTAT: COMPAREG (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_COMPAREF_Pos    (5UL)                     /*!< CTIMER STMINTSTAT: COMPAREF (Bit 5)                   */
#define CTIMER_STMINTSTAT_COMPAREF_Msk    (0x20UL)                  /*!< CTIMER STMINTSTAT: COMPAREF (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_COMPAREE_Pos    (4UL)                     /*!< CTIMER STMINTSTAT: COMPAREE (Bit 4)                   */
#define CTIMER_STMINTSTAT_COMPAREE_Msk    (0x10UL)                  /*!< CTIMER STMINTSTAT: COMPAREE (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_COMPARED_Pos    (3UL)                     /*!< CTIMER STMINTSTAT: COMPARED (Bit 3)                   */
#define CTIMER_STMINTSTAT_COMPARED_Msk    (0x8UL)                   /*!< CTIMER STMINTSTAT: COMPARED (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_COMPAREC_Pos    (2UL)                     /*!< CTIMER STMINTSTAT: COMPAREC (Bit 2)                   */
#define CTIMER_STMINTSTAT_COMPAREC_Msk    (0x4UL)                   /*!< CTIMER STMINTSTAT: COMPAREC (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_COMPAREB_Pos    (1UL)                     /*!< CTIMER STMINTSTAT: COMPAREB (Bit 1)                   */
#define CTIMER_STMINTSTAT_COMPAREB_Msk    (0x2UL)                   /*!< CTIMER STMINTSTAT: COMPAREB (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_COMPAREA_Pos    (0UL)                     /*!< CTIMER STMINTSTAT: COMPAREA (Bit 0)                   */
#define CTIMER_STMINTSTAT_COMPAREA_Msk    (0x1UL)                   /*!< CTIMER STMINTSTAT: COMPAREA (Bitfield-Mask: 0x01)     */
/* =======================================================  STMINTCLR  ======================================================= */
#define CTIMER_STMINTCLR_CAPTURED_Pos     (12UL)                    /*!< CTIMER STMINTCLR: CAPTURED (Bit 12)                   */
#define CTIMER_STMINTCLR_CAPTURED_Msk     (0x1000UL)                /*!< CTIMER STMINTCLR: CAPTURED (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_CAPTUREC_Pos     (11UL)                    /*!< CTIMER STMINTCLR: CAPTUREC (Bit 11)                   */
#define CTIMER_STMINTCLR_CAPTUREC_Msk     (0x800UL)                 /*!< CTIMER STMINTCLR: CAPTUREC (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_CAPTUREB_Pos     (10UL)                    /*!< CTIMER STMINTCLR: CAPTUREB (Bit 10)                   */
#define CTIMER_STMINTCLR_CAPTUREB_Msk     (0x400UL)                 /*!< CTIMER STMINTCLR: CAPTUREB (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_CAPTUREA_Pos     (9UL)                     /*!< CTIMER STMINTCLR: CAPTUREA (Bit 9)                    */
#define CTIMER_STMINTCLR_CAPTUREA_Msk     (0x200UL)                 /*!< CTIMER STMINTCLR: CAPTUREA (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_OVERFLOW_Pos     (8UL)                     /*!< CTIMER STMINTCLR: OVERFLOW (Bit 8)                    */
#define CTIMER_STMINTCLR_OVERFLOW_Msk     (0x100UL)                 /*!< CTIMER STMINTCLR: OVERFLOW (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_COMPAREH_Pos     (7UL)                     /*!< CTIMER STMINTCLR: COMPAREH (Bit 7)                    */
#define CTIMER_STMINTCLR_COMPAREH_Msk     (0x80UL)                  /*!< CTIMER STMINTCLR: COMPAREH (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_COMPAREG_Pos     (6UL)                     /*!< CTIMER STMINTCLR: COMPAREG (Bit 6)                    */
#define CTIMER_STMINTCLR_COMPAREG_Msk     (0x40UL)                  /*!< CTIMER STMINTCLR: COMPAREG (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_COMPAREF_Pos     (5UL)                     /*!< CTIMER STMINTCLR: COMPAREF (Bit 5)                    */
#define CTIMER_STMINTCLR_COMPAREF_Msk     (0x20UL)                  /*!< CTIMER STMINTCLR: COMPAREF (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_COMPAREE_Pos     (4UL)                     /*!< CTIMER STMINTCLR: COMPAREE (Bit 4)                    */
#define CTIMER_STMINTCLR_COMPAREE_Msk     (0x10UL)                  /*!< CTIMER STMINTCLR: COMPAREE (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_COMPARED_Pos     (3UL)                     /*!< CTIMER STMINTCLR: COMPARED (Bit 3)                    */
#define CTIMER_STMINTCLR_COMPARED_Msk     (0x8UL)                   /*!< CTIMER STMINTCLR: COMPARED (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_COMPAREC_Pos     (2UL)                     /*!< CTIMER STMINTCLR: COMPAREC (Bit 2)                    */
#define CTIMER_STMINTCLR_COMPAREC_Msk     (0x4UL)                   /*!< CTIMER STMINTCLR: COMPAREC (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_COMPAREB_Pos     (1UL)                     /*!< CTIMER STMINTCLR: COMPAREB (Bit 1)                    */
#define CTIMER_STMINTCLR_COMPAREB_Msk     (0x2UL)                   /*!< CTIMER STMINTCLR: COMPAREB (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_COMPAREA_Pos     (0UL)                     /*!< CTIMER STMINTCLR: COMPAREA (Bit 0)                    */
#define CTIMER_STMINTCLR_COMPAREA_Msk     (0x1UL)                   /*!< CTIMER STMINTCLR: COMPAREA (Bitfield-Mask: 0x01)      */
/* =======================================================  STMINTSET  ======================================================= */
#define CTIMER_STMINTSET_CAPTURED_Pos     (12UL)                    /*!< CTIMER STMINTSET: CAPTURED (Bit 12)                   */
#define CTIMER_STMINTSET_CAPTURED_Msk     (0x1000UL)                /*!< CTIMER STMINTSET: CAPTURED (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_CAPTUREC_Pos     (11UL)                    /*!< CTIMER STMINTSET: CAPTUREC (Bit 11)                   */
#define CTIMER_STMINTSET_CAPTUREC_Msk     (0x800UL)                 /*!< CTIMER STMINTSET: CAPTUREC (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_CAPTUREB_Pos     (10UL)                    /*!< CTIMER STMINTSET: CAPTUREB (Bit 10)                   */
#define CTIMER_STMINTSET_CAPTUREB_Msk     (0x400UL)                 /*!< CTIMER STMINTSET: CAPTUREB (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_CAPTUREA_Pos     (9UL)                     /*!< CTIMER STMINTSET: CAPTUREA (Bit 9)                    */
#define CTIMER_STMINTSET_CAPTUREA_Msk     (0x200UL)                 /*!< CTIMER STMINTSET: CAPTUREA (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_OVERFLOW_Pos     (8UL)                     /*!< CTIMER STMINTSET: OVERFLOW (Bit 8)                    */
#define CTIMER_STMINTSET_OVERFLOW_Msk     (0x100UL)                 /*!< CTIMER STMINTSET: OVERFLOW (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_COMPAREH_Pos     (7UL)                     /*!< CTIMER STMINTSET: COMPAREH (Bit 7)                    */
#define CTIMER_STMINTSET_COMPAREH_Msk     (0x80UL)                  /*!< CTIMER STMINTSET: COMPAREH (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_COMPAREG_Pos     (6UL)                     /*!< CTIMER STMINTSET: COMPAREG (Bit 6)                    */
#define CTIMER_STMINTSET_COMPAREG_Msk     (0x40UL)                  /*!< CTIMER STMINTSET: COMPAREG (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_COMPAREF_Pos     (5UL)                     /*!< CTIMER STMINTSET: COMPAREF (Bit 5)                    */
#define CTIMER_STMINTSET_COMPAREF_Msk     (0x20UL)                  /*!< CTIMER STMINTSET: COMPAREF (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_COMPAREE_Pos     (4UL)                     /*!< CTIMER STMINTSET: COMPAREE (Bit 4)                    */
#define CTIMER_STMINTSET_COMPAREE_Msk     (0x10UL)                  /*!< CTIMER STMINTSET: COMPAREE (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_COMPARED_Pos     (3UL)                     /*!< CTIMER STMINTSET: COMPARED (Bit 3)                    */
#define CTIMER_STMINTSET_COMPARED_Msk     (0x8UL)                   /*!< CTIMER STMINTSET: COMPARED (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_COMPAREC_Pos     (2UL)                     /*!< CTIMER STMINTSET: COMPAREC (Bit 2)                    */
#define CTIMER_STMINTSET_COMPAREC_Msk     (0x4UL)                   /*!< CTIMER STMINTSET: COMPAREC (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_COMPAREB_Pos     (1UL)                     /*!< CTIMER STMINTSET: COMPAREB (Bit 1)                    */
#define CTIMER_STMINTSET_COMPAREB_Msk     (0x2UL)                   /*!< CTIMER STMINTSET: COMPAREB (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_COMPAREA_Pos     (0UL)                     /*!< CTIMER STMINTSET: COMPAREA (Bit 0)                    */
#define CTIMER_STMINTSET_COMPAREA_Msk     (0x1UL)                   /*!< CTIMER STMINTSET: COMPAREA (Bitfield-Mask: 0x01)      */


/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */

/* ========================================================  PADREGA  ======================================================== */
#define GPIO_PADREGA_PAD3PWRUP_Pos        (30UL)                    /*!< GPIO PADREGA: PAD3PWRUP (Bit 30)                      */
#define GPIO_PADREGA_PAD3PWRUP_Msk        (0x40000000UL)            /*!< GPIO PADREGA: PAD3PWRUP (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD3FNCSEL_Pos       (27UL)                    /*!< GPIO PADREGA: PAD3FNCSEL (Bit 27)                     */
#define GPIO_PADREGA_PAD3FNCSEL_Msk       (0x38000000UL)            /*!< GPIO PADREGA: PAD3FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGA_PAD3STRNG_Pos        (26UL)                    /*!< GPIO PADREGA: PAD3STRNG (Bit 26)                      */
#define GPIO_PADREGA_PAD3STRNG_Msk        (0x4000000UL)             /*!< GPIO PADREGA: PAD3STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD3INPEN_Pos        (25UL)                    /*!< GPIO PADREGA: PAD3INPEN (Bit 25)                      */
#define GPIO_PADREGA_PAD3INPEN_Msk        (0x2000000UL)             /*!< GPIO PADREGA: PAD3INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD3PULL_Pos         (24UL)                    /*!< GPIO PADREGA: PAD3PULL (Bit 24)                       */
#define GPIO_PADREGA_PAD3PULL_Msk         (0x1000000UL)             /*!< GPIO PADREGA: PAD3PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGA_PAD2FNCSEL_Pos       (19UL)                    /*!< GPIO PADREGA: PAD2FNCSEL (Bit 19)                     */
#define GPIO_PADREGA_PAD2FNCSEL_Msk       (0x380000UL)              /*!< GPIO PADREGA: PAD2FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGA_PAD2STRNG_Pos        (18UL)                    /*!< GPIO PADREGA: PAD2STRNG (Bit 18)                      */
#define GPIO_PADREGA_PAD2STRNG_Msk        (0x40000UL)               /*!< GPIO PADREGA: PAD2STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD2INPEN_Pos        (17UL)                    /*!< GPIO PADREGA: PAD2INPEN (Bit 17)                      */
#define GPIO_PADREGA_PAD2INPEN_Msk        (0x20000UL)               /*!< GPIO PADREGA: PAD2INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD2PULL_Pos         (16UL)                    /*!< GPIO PADREGA: PAD2PULL (Bit 16)                       */
#define GPIO_PADREGA_PAD2PULL_Msk         (0x10000UL)               /*!< GPIO PADREGA: PAD2PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGA_PAD1RSEL_Pos         (14UL)                    /*!< GPIO PADREGA: PAD1RSEL (Bit 14)                       */
#define GPIO_PADREGA_PAD1RSEL_Msk         (0xc000UL)                /*!< GPIO PADREGA: PAD1RSEL (Bitfield-Mask: 0x03)          */
#define GPIO_PADREGA_PAD1FNCSEL_Pos       (11UL)                    /*!< GPIO PADREGA: PAD1FNCSEL (Bit 11)                     */
#define GPIO_PADREGA_PAD1FNCSEL_Msk       (0x3800UL)                /*!< GPIO PADREGA: PAD1FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGA_PAD1STRNG_Pos        (10UL)                    /*!< GPIO PADREGA: PAD1STRNG (Bit 10)                      */
#define GPIO_PADREGA_PAD1STRNG_Msk        (0x400UL)                 /*!< GPIO PADREGA: PAD1STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD1INPEN_Pos        (9UL)                     /*!< GPIO PADREGA: PAD1INPEN (Bit 9)                       */
#define GPIO_PADREGA_PAD1INPEN_Msk        (0x200UL)                 /*!< GPIO PADREGA: PAD1INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD1PULL_Pos         (8UL)                     /*!< GPIO PADREGA: PAD1PULL (Bit 8)                        */
#define GPIO_PADREGA_PAD1PULL_Msk         (0x100UL)                 /*!< GPIO PADREGA: PAD1PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGA_PAD0RSEL_Pos         (6UL)                     /*!< GPIO PADREGA: PAD0RSEL (Bit 6)                        */
#define GPIO_PADREGA_PAD0RSEL_Msk         (0xc0UL)                  /*!< GPIO PADREGA: PAD0RSEL (Bitfield-Mask: 0x03)          */
#define GPIO_PADREGA_PAD0FNCSEL_Pos       (3UL)                     /*!< GPIO PADREGA: PAD0FNCSEL (Bit 3)                      */
#define GPIO_PADREGA_PAD0FNCSEL_Msk       (0x38UL)                  /*!< GPIO PADREGA: PAD0FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGA_PAD0STRNG_Pos        (2UL)                     /*!< GPIO PADREGA: PAD0STRNG (Bit 2)                       */
#define GPIO_PADREGA_PAD0STRNG_Msk        (0x4UL)                   /*!< GPIO PADREGA: PAD0STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD0INPEN_Pos        (1UL)                     /*!< GPIO PADREGA: PAD0INPEN (Bit 1)                       */
#define GPIO_PADREGA_PAD0INPEN_Msk        (0x2UL)                   /*!< GPIO PADREGA: PAD0INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD0PULL_Pos         (0UL)                     /*!< GPIO PADREGA: PAD0PULL (Bit 0)                        */
#define GPIO_PADREGA_PAD0PULL_Msk         (0x1UL)                   /*!< GPIO PADREGA: PAD0PULL (Bitfield-Mask: 0x01)          */
/* ========================================================  PADREGB  ======================================================== */
#define GPIO_PADREGB_PAD7FNCSEL_Pos       (27UL)                    /*!< GPIO PADREGB: PAD7FNCSEL (Bit 27)                     */
#define GPIO_PADREGB_PAD7FNCSEL_Msk       (0x38000000UL)            /*!< GPIO PADREGB: PAD7FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGB_PAD7STRNG_Pos        (26UL)                    /*!< GPIO PADREGB: PAD7STRNG (Bit 26)                      */
#define GPIO_PADREGB_PAD7STRNG_Msk        (0x4000000UL)             /*!< GPIO PADREGB: PAD7STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD7INPEN_Pos        (25UL)                    /*!< GPIO PADREGB: PAD7INPEN (Bit 25)                      */
#define GPIO_PADREGB_PAD7INPEN_Msk        (0x2000000UL)             /*!< GPIO PADREGB: PAD7INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD7PULL_Pos         (24UL)                    /*!< GPIO PADREGB: PAD7PULL (Bit 24)                       */
#define GPIO_PADREGB_PAD7PULL_Msk         (0x1000000UL)             /*!< GPIO PADREGB: PAD7PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGB_PAD6RSEL_Pos         (22UL)                    /*!< GPIO PADREGB: PAD6RSEL (Bit 22)                       */
#define GPIO_PADREGB_PAD6RSEL_Msk         (0xc00000UL)              /*!< GPIO PADREGB: PAD6RSEL (Bitfield-Mask: 0x03)          */
#define GPIO_PADREGB_PAD6FNCSEL_Pos       (19UL)                    /*!< GPIO PADREGB: PAD6FNCSEL (Bit 19)                     */
#define GPIO_PADREGB_PAD6FNCSEL_Msk       (0x380000UL)              /*!< GPIO PADREGB: PAD6FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGB_PAD6STRNG_Pos        (18UL)                    /*!< GPIO PADREGB: PAD6STRNG (Bit 18)                      */
#define GPIO_PADREGB_PAD6STRNG_Msk        (0x40000UL)               /*!< GPIO PADREGB: PAD6STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD6INPEN_Pos        (17UL)                    /*!< GPIO PADREGB: PAD6INPEN (Bit 17)                      */
#define GPIO_PADREGB_PAD6INPEN_Msk        (0x20000UL)               /*!< GPIO PADREGB: PAD6INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD6PULL_Pos         (16UL)                    /*!< GPIO PADREGB: PAD6PULL (Bit 16)                       */
#define GPIO_PADREGB_PAD6PULL_Msk         (0x10000UL)               /*!< GPIO PADREGB: PAD6PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGB_PAD5RSEL_Pos         (14UL)                    /*!< GPIO PADREGB: PAD5RSEL (Bit 14)                       */
#define GPIO_PADREGB_PAD5RSEL_Msk         (0xc000UL)                /*!< GPIO PADREGB: PAD5RSEL (Bitfield-Mask: 0x03)          */
#define GPIO_PADREGB_PAD5FNCSEL_Pos       (11UL)                    /*!< GPIO PADREGB: PAD5FNCSEL (Bit 11)                     */
#define GPIO_PADREGB_PAD5FNCSEL_Msk       (0x3800UL)                /*!< GPIO PADREGB: PAD5FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGB_PAD5STRNG_Pos        (10UL)                    /*!< GPIO PADREGB: PAD5STRNG (Bit 10)                      */
#define GPIO_PADREGB_PAD5STRNG_Msk        (0x400UL)                 /*!< GPIO PADREGB: PAD5STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD5INPEN_Pos        (9UL)                     /*!< GPIO PADREGB: PAD5INPEN (Bit 9)                       */
#define GPIO_PADREGB_PAD5INPEN_Msk        (0x200UL)                 /*!< GPIO PADREGB: PAD5INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD5PULL_Pos         (8UL)                     /*!< GPIO PADREGB: PAD5PULL (Bit 8)                        */
#define GPIO_PADREGB_PAD5PULL_Msk         (0x100UL)                 /*!< GPIO PADREGB: PAD5PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGB_PAD4FNCSEL_Pos       (3UL)                     /*!< GPIO PADREGB: PAD4FNCSEL (Bit 3)                      */
#define GPIO_PADREGB_PAD4FNCSEL_Msk       (0x38UL)                  /*!< GPIO PADREGB: PAD4FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGB_PAD4STRNG_Pos        (2UL)                     /*!< GPIO PADREGB: PAD4STRNG (Bit 2)                       */
#define GPIO_PADREGB_PAD4STRNG_Msk        (0x4UL)                   /*!< GPIO PADREGB: PAD4STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD4INPEN_Pos        (1UL)                     /*!< GPIO PADREGB: PAD4INPEN (Bit 1)                       */
#define GPIO_PADREGB_PAD4INPEN_Msk        (0x2UL)                   /*!< GPIO PADREGB: PAD4INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD4PULL_Pos         (0UL)                     /*!< GPIO PADREGB: PAD4PULL (Bit 0)                        */
#define GPIO_PADREGB_PAD4PULL_Msk         (0x1UL)                   /*!< GPIO PADREGB: PAD4PULL (Bitfield-Mask: 0x01)          */
/* ========================================================  PADREGC  ======================================================== */
#define GPIO_PADREGC_PAD11FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGC: PAD11FNCSEL (Bit 27)                    */
#define GPIO_PADREGC_PAD11FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGC: PAD11FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGC_PAD11STRNG_Pos       (26UL)                    /*!< GPIO PADREGC: PAD11STRNG (Bit 26)                     */
#define GPIO_PADREGC_PAD11STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGC: PAD11STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGC_PAD11INPEN_Pos       (25UL)                    /*!< GPIO PADREGC: PAD11INPEN (Bit 25)                     */
#define GPIO_PADREGC_PAD11INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGC: PAD11INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGC_PAD11PULL_Pos        (24UL)                    /*!< GPIO PADREGC: PAD11PULL (Bit 24)                      */
#define GPIO_PADREGC_PAD11PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGC: PAD11PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD10FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGC: PAD10FNCSEL (Bit 19)                    */
#define GPIO_PADREGC_PAD10FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGC: PAD10FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGC_PAD10STRNG_Pos       (18UL)                    /*!< GPIO PADREGC: PAD10STRNG (Bit 18)                     */
#define GPIO_PADREGC_PAD10STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGC: PAD10STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGC_PAD10INPEN_Pos       (17UL)                    /*!< GPIO PADREGC: PAD10INPEN (Bit 17)                     */
#define GPIO_PADREGC_PAD10INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGC: PAD10INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGC_PAD10PULL_Pos        (16UL)                    /*!< GPIO PADREGC: PAD10PULL (Bit 16)                      */
#define GPIO_PADREGC_PAD10PULL_Msk        (0x10000UL)               /*!< GPIO PADREGC: PAD10PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD9RSEL_Pos         (14UL)                    /*!< GPIO PADREGC: PAD9RSEL (Bit 14)                       */
#define GPIO_PADREGC_PAD9RSEL_Msk         (0xc000UL)                /*!< GPIO PADREGC: PAD9RSEL (Bitfield-Mask: 0x03)          */
#define GPIO_PADREGC_PAD9FNCSEL_Pos       (11UL)                    /*!< GPIO PADREGC: PAD9FNCSEL (Bit 11)                     */
#define GPIO_PADREGC_PAD9FNCSEL_Msk       (0x3800UL)                /*!< GPIO PADREGC: PAD9FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGC_PAD9STRNG_Pos        (10UL)                    /*!< GPIO PADREGC: PAD9STRNG (Bit 10)                      */
#define GPIO_PADREGC_PAD9STRNG_Msk        (0x400UL)                 /*!< GPIO PADREGC: PAD9STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD9INPEN_Pos        (9UL)                     /*!< GPIO PADREGC: PAD9INPEN (Bit 9)                       */
#define GPIO_PADREGC_PAD9INPEN_Msk        (0x200UL)                 /*!< GPIO PADREGC: PAD9INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD9PULL_Pos         (8UL)                     /*!< GPIO PADREGC: PAD9PULL (Bit 8)                        */
#define GPIO_PADREGC_PAD9PULL_Msk         (0x100UL)                 /*!< GPIO PADREGC: PAD9PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGC_PAD8RSEL_Pos         (6UL)                     /*!< GPIO PADREGC: PAD8RSEL (Bit 6)                        */
#define GPIO_PADREGC_PAD8RSEL_Msk         (0xc0UL)                  /*!< GPIO PADREGC: PAD8RSEL (Bitfield-Mask: 0x03)          */
#define GPIO_PADREGC_PAD8FNCSEL_Pos       (3UL)                     /*!< GPIO PADREGC: PAD8FNCSEL (Bit 3)                      */
#define GPIO_PADREGC_PAD8FNCSEL_Msk       (0x38UL)                  /*!< GPIO PADREGC: PAD8FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGC_PAD8STRNG_Pos        (2UL)                     /*!< GPIO PADREGC: PAD8STRNG (Bit 2)                       */
#define GPIO_PADREGC_PAD8STRNG_Msk        (0x4UL)                   /*!< GPIO PADREGC: PAD8STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD8INPEN_Pos        (1UL)                     /*!< GPIO PADREGC: PAD8INPEN (Bit 1)                       */
#define GPIO_PADREGC_PAD8INPEN_Msk        (0x2UL)                   /*!< GPIO PADREGC: PAD8INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD8PULL_Pos         (0UL)                     /*!< GPIO PADREGC: PAD8PULL (Bit 0)                        */
#define GPIO_PADREGC_PAD8PULL_Msk         (0x1UL)                   /*!< GPIO PADREGC: PAD8PULL (Bitfield-Mask: 0x01)          */
/* ========================================================  PADREGD  ======================================================== */
#define GPIO_PADREGD_PAD15FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGD: PAD15FNCSEL (Bit 27)                    */
#define GPIO_PADREGD_PAD15FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGD: PAD15FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGD_PAD15STRNG_Pos       (26UL)                    /*!< GPIO PADREGD: PAD15STRNG (Bit 26)                     */
#define GPIO_PADREGD_PAD15STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGD: PAD15STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD15INPEN_Pos       (25UL)                    /*!< GPIO PADREGD: PAD15INPEN (Bit 25)                     */
#define GPIO_PADREGD_PAD15INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGD: PAD15INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD15PULL_Pos        (24UL)                    /*!< GPIO PADREGD: PAD15PULL (Bit 24)                      */
#define GPIO_PADREGD_PAD15PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGD: PAD15PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGD_PAD14FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGD: PAD14FNCSEL (Bit 19)                    */
#define GPIO_PADREGD_PAD14FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGD: PAD14FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGD_PAD14STRNG_Pos       (18UL)                    /*!< GPIO PADREGD: PAD14STRNG (Bit 18)                     */
#define GPIO_PADREGD_PAD14STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGD: PAD14STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD14INPEN_Pos       (17UL)                    /*!< GPIO PADREGD: PAD14INPEN (Bit 17)                     */
#define GPIO_PADREGD_PAD14INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGD: PAD14INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD14PULL_Pos        (16UL)                    /*!< GPIO PADREGD: PAD14PULL (Bit 16)                      */
#define GPIO_PADREGD_PAD14PULL_Msk        (0x10000UL)               /*!< GPIO PADREGD: PAD14PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGD_PAD13FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGD: PAD13FNCSEL (Bit 11)                    */
#define GPIO_PADREGD_PAD13FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGD: PAD13FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGD_PAD13STRNG_Pos       (10UL)                    /*!< GPIO PADREGD: PAD13STRNG (Bit 10)                     */
#define GPIO_PADREGD_PAD13STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGD: PAD13STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD13INPEN_Pos       (9UL)                     /*!< GPIO PADREGD: PAD13INPEN (Bit 9)                      */
#define GPIO_PADREGD_PAD13INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGD: PAD13INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD13PULL_Pos        (8UL)                     /*!< GPIO PADREGD: PAD13PULL (Bit 8)                       */
#define GPIO_PADREGD_PAD13PULL_Msk        (0x100UL)                 /*!< GPIO PADREGD: PAD13PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGD_PAD12FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGD: PAD12FNCSEL (Bit 3)                     */
#define GPIO_PADREGD_PAD12FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGD: PAD12FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGD_PAD12STRNG_Pos       (2UL)                     /*!< GPIO PADREGD: PAD12STRNG (Bit 2)                      */
#define GPIO_PADREGD_PAD12STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGD: PAD12STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD12INPEN_Pos       (1UL)                     /*!< GPIO PADREGD: PAD12INPEN (Bit 1)                      */
#define GPIO_PADREGD_PAD12INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGD: PAD12INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD12PULL_Pos        (0UL)                     /*!< GPIO PADREGD: PAD12PULL (Bit 0)                       */
#define GPIO_PADREGD_PAD12PULL_Msk        (0x1UL)                   /*!< GPIO PADREGD: PAD12PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGE  ======================================================== */
#define GPIO_PADREGE_PAD19FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGE: PAD19FNCSEL (Bit 27)                    */
#define GPIO_PADREGE_PAD19FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGE: PAD19FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGE_PAD19STRNG_Pos       (26UL)                    /*!< GPIO PADREGE: PAD19STRNG (Bit 26)                     */
#define GPIO_PADREGE_PAD19STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGE: PAD19STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD19INPEN_Pos       (25UL)                    /*!< GPIO PADREGE: PAD19INPEN (Bit 25)                     */
#define GPIO_PADREGE_PAD19INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGE: PAD19INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD19PULL_Pos        (24UL)                    /*!< GPIO PADREGE: PAD19PULL (Bit 24)                      */
#define GPIO_PADREGE_PAD19PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGE: PAD19PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGE_PAD18FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGE: PAD18FNCSEL (Bit 19)                    */
#define GPIO_PADREGE_PAD18FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGE: PAD18FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGE_PAD18STRNG_Pos       (18UL)                    /*!< GPIO PADREGE: PAD18STRNG (Bit 18)                     */
#define GPIO_PADREGE_PAD18STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGE: PAD18STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD18INPEN_Pos       (17UL)                    /*!< GPIO PADREGE: PAD18INPEN (Bit 17)                     */
#define GPIO_PADREGE_PAD18INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGE: PAD18INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD18PULL_Pos        (16UL)                    /*!< GPIO PADREGE: PAD18PULL (Bit 16)                      */
#define GPIO_PADREGE_PAD18PULL_Msk        (0x10000UL)               /*!< GPIO PADREGE: PAD18PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGE_PAD17FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGE: PAD17FNCSEL (Bit 11)                    */
#define GPIO_PADREGE_PAD17FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGE: PAD17FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGE_PAD17STRNG_Pos       (10UL)                    /*!< GPIO PADREGE: PAD17STRNG (Bit 10)                     */
#define GPIO_PADREGE_PAD17STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGE: PAD17STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD17INPEN_Pos       (9UL)                     /*!< GPIO PADREGE: PAD17INPEN (Bit 9)                      */
#define GPIO_PADREGE_PAD17INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGE: PAD17INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD17PULL_Pos        (8UL)                     /*!< GPIO PADREGE: PAD17PULL (Bit 8)                       */
#define GPIO_PADREGE_PAD17PULL_Msk        (0x100UL)                 /*!< GPIO PADREGE: PAD17PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGE_PAD16FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGE: PAD16FNCSEL (Bit 3)                     */
#define GPIO_PADREGE_PAD16FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGE: PAD16FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGE_PAD16STRNG_Pos       (2UL)                     /*!< GPIO PADREGE: PAD16STRNG (Bit 2)                      */
#define GPIO_PADREGE_PAD16STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGE: PAD16STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD16INPEN_Pos       (1UL)                     /*!< GPIO PADREGE: PAD16INPEN (Bit 1)                      */
#define GPIO_PADREGE_PAD16INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGE: PAD16INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD16PULL_Pos        (0UL)                     /*!< GPIO PADREGE: PAD16PULL (Bit 0)                       */
#define GPIO_PADREGE_PAD16PULL_Msk        (0x1UL)                   /*!< GPIO PADREGE: PAD16PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGF  ======================================================== */
#define GPIO_PADREGF_PAD23FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGF: PAD23FNCSEL (Bit 27)                    */
#define GPIO_PADREGF_PAD23FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGF: PAD23FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGF_PAD23STRNG_Pos       (26UL)                    /*!< GPIO PADREGF: PAD23STRNG (Bit 26)                     */
#define GPIO_PADREGF_PAD23STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGF: PAD23STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD23INPEN_Pos       (25UL)                    /*!< GPIO PADREGF: PAD23INPEN (Bit 25)                     */
#define GPIO_PADREGF_PAD23INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGF: PAD23INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD23PULL_Pos        (24UL)                    /*!< GPIO PADREGF: PAD23PULL (Bit 24)                      */
#define GPIO_PADREGF_PAD23PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGF: PAD23PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGF_PAD22FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGF: PAD22FNCSEL (Bit 19)                    */
#define GPIO_PADREGF_PAD22FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGF: PAD22FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGF_PAD22STRNG_Pos       (18UL)                    /*!< GPIO PADREGF: PAD22STRNG (Bit 18)                     */
#define GPIO_PADREGF_PAD22STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGF: PAD22STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD22INPEN_Pos       (17UL)                    /*!< GPIO PADREGF: PAD22INPEN (Bit 17)                     */
#define GPIO_PADREGF_PAD22INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGF: PAD22INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD22PULL_Pos        (16UL)                    /*!< GPIO PADREGF: PAD22PULL (Bit 16)                      */
#define GPIO_PADREGF_PAD22PULL_Msk        (0x10000UL)               /*!< GPIO PADREGF: PAD22PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGF_PAD21FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGF: PAD21FNCSEL (Bit 11)                    */
#define GPIO_PADREGF_PAD21FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGF: PAD21FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGF_PAD21STRNG_Pos       (10UL)                    /*!< GPIO PADREGF: PAD21STRNG (Bit 10)                     */
#define GPIO_PADREGF_PAD21STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGF: PAD21STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD21INPEN_Pos       (9UL)                     /*!< GPIO PADREGF: PAD21INPEN (Bit 9)                      */
#define GPIO_PADREGF_PAD21INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGF: PAD21INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD21PULL_Pos        (8UL)                     /*!< GPIO PADREGF: PAD21PULL (Bit 8)                       */
#define GPIO_PADREGF_PAD21PULL_Msk        (0x100UL)                 /*!< GPIO PADREGF: PAD21PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGF_PAD20FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGF: PAD20FNCSEL (Bit 3)                     */
#define GPIO_PADREGF_PAD20FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGF: PAD20FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGF_PAD20STRNG_Pos       (2UL)                     /*!< GPIO PADREGF: PAD20STRNG (Bit 2)                      */
#define GPIO_PADREGF_PAD20STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGF: PAD20STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD20INPEN_Pos       (1UL)                     /*!< GPIO PADREGF: PAD20INPEN (Bit 1)                      */
#define GPIO_PADREGF_PAD20INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGF: PAD20INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD20PULL_Pos        (0UL)                     /*!< GPIO PADREGF: PAD20PULL (Bit 0)                       */
#define GPIO_PADREGF_PAD20PULL_Msk        (0x1UL)                   /*!< GPIO PADREGF: PAD20PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGG  ======================================================== */
#define GPIO_PADREGG_PAD27RSEL_Pos        (30UL)                    /*!< GPIO PADREGG: PAD27RSEL (Bit 30)                      */
#define GPIO_PADREGG_PAD27RSEL_Msk        (0xc0000000UL)            /*!< GPIO PADREGG: PAD27RSEL (Bitfield-Mask: 0x03)         */
#define GPIO_PADREGG_PAD27FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGG: PAD27FNCSEL (Bit 27)                    */
#define GPIO_PADREGG_PAD27FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGG: PAD27FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGG_PAD27STRNG_Pos       (26UL)                    /*!< GPIO PADREGG: PAD27STRNG (Bit 26)                     */
#define GPIO_PADREGG_PAD27STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGG: PAD27STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD27INPEN_Pos       (25UL)                    /*!< GPIO PADREGG: PAD27INPEN (Bit 25)                     */
#define GPIO_PADREGG_PAD27INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGG: PAD27INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD27PULL_Pos        (24UL)                    /*!< GPIO PADREGG: PAD27PULL (Bit 24)                      */
#define GPIO_PADREGG_PAD27PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGG: PAD27PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGG_PAD26FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGG: PAD26FNCSEL (Bit 19)                    */
#define GPIO_PADREGG_PAD26FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGG: PAD26FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGG_PAD26STRNG_Pos       (18UL)                    /*!< GPIO PADREGG: PAD26STRNG (Bit 18)                     */
#define GPIO_PADREGG_PAD26STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGG: PAD26STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD26INPEN_Pos       (17UL)                    /*!< GPIO PADREGG: PAD26INPEN (Bit 17)                     */
#define GPIO_PADREGG_PAD26INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGG: PAD26INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD26PULL_Pos        (16UL)                    /*!< GPIO PADREGG: PAD26PULL (Bit 16)                      */
#define GPIO_PADREGG_PAD26PULL_Msk        (0x10000UL)               /*!< GPIO PADREGG: PAD26PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGG_PAD25RSEL_Pos        (14UL)                    /*!< GPIO PADREGG: PAD25RSEL (Bit 14)                      */
#define GPIO_PADREGG_PAD25RSEL_Msk        (0xc000UL)                /*!< GPIO PADREGG: PAD25RSEL (Bitfield-Mask: 0x03)         */
#define GPIO_PADREGG_PAD25FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGG: PAD25FNCSEL (Bit 11)                    */
#define GPIO_PADREGG_PAD25FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGG: PAD25FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGG_PAD25STRNG_Pos       (10UL)                    /*!< GPIO PADREGG: PAD25STRNG (Bit 10)                     */
#define GPIO_PADREGG_PAD25STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGG: PAD25STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD25INPEN_Pos       (9UL)                     /*!< GPIO PADREGG: PAD25INPEN (Bit 9)                      */
#define GPIO_PADREGG_PAD25INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGG: PAD25INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD25PULL_Pos        (8UL)                     /*!< GPIO PADREGG: PAD25PULL (Bit 8)                       */
#define GPIO_PADREGG_PAD25PULL_Msk        (0x100UL)                 /*!< GPIO PADREGG: PAD25PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGG_PAD24FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGG: PAD24FNCSEL (Bit 3)                     */
#define GPIO_PADREGG_PAD24FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGG: PAD24FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGG_PAD24STRNG_Pos       (2UL)                     /*!< GPIO PADREGG: PAD24STRNG (Bit 2)                      */
#define GPIO_PADREGG_PAD24STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGG: PAD24STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD24INPEN_Pos       (1UL)                     /*!< GPIO PADREGG: PAD24INPEN (Bit 1)                      */
#define GPIO_PADREGG_PAD24INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGG: PAD24INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD24PULL_Pos        (0UL)                     /*!< GPIO PADREGG: PAD24PULL (Bit 0)                       */
#define GPIO_PADREGG_PAD24PULL_Msk        (0x1UL)                   /*!< GPIO PADREGG: PAD24PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGH  ======================================================== */
#define GPIO_PADREGH_PAD31FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGH: PAD31FNCSEL (Bit 27)                    */
#define GPIO_PADREGH_PAD31FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGH: PAD31FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGH_PAD31STRNG_Pos       (26UL)                    /*!< GPIO PADREGH: PAD31STRNG (Bit 26)                     */
#define GPIO_PADREGH_PAD31STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGH: PAD31STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD31INPEN_Pos       (25UL)                    /*!< GPIO PADREGH: PAD31INPEN (Bit 25)                     */
#define GPIO_PADREGH_PAD31INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGH: PAD31INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD31PULL_Pos        (24UL)                    /*!< GPIO PADREGH: PAD31PULL (Bit 24)                      */
#define GPIO_PADREGH_PAD31PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGH: PAD31PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGH_PAD30FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGH: PAD30FNCSEL (Bit 19)                    */
#define GPIO_PADREGH_PAD30FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGH: PAD30FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGH_PAD30STRNG_Pos       (18UL)                    /*!< GPIO PADREGH: PAD30STRNG (Bit 18)                     */
#define GPIO_PADREGH_PAD30STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGH: PAD30STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD30INPEN_Pos       (17UL)                    /*!< GPIO PADREGH: PAD30INPEN (Bit 17)                     */
#define GPIO_PADREGH_PAD30INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGH: PAD30INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD30PULL_Pos        (16UL)                    /*!< GPIO PADREGH: PAD30PULL (Bit 16)                      */
#define GPIO_PADREGH_PAD30PULL_Msk        (0x10000UL)               /*!< GPIO PADREGH: PAD30PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGH_PAD29FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGH: PAD29FNCSEL (Bit 11)                    */
#define GPIO_PADREGH_PAD29FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGH: PAD29FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGH_PAD29STRNG_Pos       (10UL)                    /*!< GPIO PADREGH: PAD29STRNG (Bit 10)                     */
#define GPIO_PADREGH_PAD29STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGH: PAD29STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD29INPEN_Pos       (9UL)                     /*!< GPIO PADREGH: PAD29INPEN (Bit 9)                      */
#define GPIO_PADREGH_PAD29INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGH: PAD29INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD29PULL_Pos        (8UL)                     /*!< GPIO PADREGH: PAD29PULL (Bit 8)                       */
#define GPIO_PADREGH_PAD29PULL_Msk        (0x100UL)                 /*!< GPIO PADREGH: PAD29PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGH_PAD28FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGH: PAD28FNCSEL (Bit 3)                     */
#define GPIO_PADREGH_PAD28FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGH: PAD28FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGH_PAD28STRNG_Pos       (2UL)                     /*!< GPIO PADREGH: PAD28STRNG (Bit 2)                      */
#define GPIO_PADREGH_PAD28STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGH: PAD28STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD28INPEN_Pos       (1UL)                     /*!< GPIO PADREGH: PAD28INPEN (Bit 1)                      */
#define GPIO_PADREGH_PAD28INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGH: PAD28INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD28PULL_Pos        (0UL)                     /*!< GPIO PADREGH: PAD28PULL (Bit 0)                       */
#define GPIO_PADREGH_PAD28PULL_Msk        (0x1UL)                   /*!< GPIO PADREGH: PAD28PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGI  ======================================================== */
#define GPIO_PADREGI_PAD35FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGI: PAD35FNCSEL (Bit 27)                    */
#define GPIO_PADREGI_PAD35FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGI: PAD35FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGI_PAD35STRNG_Pos       (26UL)                    /*!< GPIO PADREGI: PAD35STRNG (Bit 26)                     */
#define GPIO_PADREGI_PAD35STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGI: PAD35STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD35INPEN_Pos       (25UL)                    /*!< GPIO PADREGI: PAD35INPEN (Bit 25)                     */
#define GPIO_PADREGI_PAD35INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGI: PAD35INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD35PULL_Pos        (24UL)                    /*!< GPIO PADREGI: PAD35PULL (Bit 24)                      */
#define GPIO_PADREGI_PAD35PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGI: PAD35PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGI_PAD34FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGI: PAD34FNCSEL (Bit 19)                    */
#define GPIO_PADREGI_PAD34FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGI: PAD34FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGI_PAD34STRNG_Pos       (18UL)                    /*!< GPIO PADREGI: PAD34STRNG (Bit 18)                     */
#define GPIO_PADREGI_PAD34STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGI: PAD34STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD34INPEN_Pos       (17UL)                    /*!< GPIO PADREGI: PAD34INPEN (Bit 17)                     */
#define GPIO_PADREGI_PAD34INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGI: PAD34INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD34PULL_Pos        (16UL)                    /*!< GPIO PADREGI: PAD34PULL (Bit 16)                      */
#define GPIO_PADREGI_PAD34PULL_Msk        (0x10000UL)               /*!< GPIO PADREGI: PAD34PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGI_PAD33FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGI: PAD33FNCSEL (Bit 11)                    */
#define GPIO_PADREGI_PAD33FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGI: PAD33FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGI_PAD33STRNG_Pos       (10UL)                    /*!< GPIO PADREGI: PAD33STRNG (Bit 10)                     */
#define GPIO_PADREGI_PAD33STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGI: PAD33STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD33INPEN_Pos       (9UL)                     /*!< GPIO PADREGI: PAD33INPEN (Bit 9)                      */
#define GPIO_PADREGI_PAD33INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGI: PAD33INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD33PULL_Pos        (8UL)                     /*!< GPIO PADREGI: PAD33PULL (Bit 8)                       */
#define GPIO_PADREGI_PAD33PULL_Msk        (0x100UL)                 /*!< GPIO PADREGI: PAD33PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGI_PAD32FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGI: PAD32FNCSEL (Bit 3)                     */
#define GPIO_PADREGI_PAD32FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGI: PAD32FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGI_PAD32STRNG_Pos       (2UL)                     /*!< GPIO PADREGI: PAD32STRNG (Bit 2)                      */
#define GPIO_PADREGI_PAD32STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGI: PAD32STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD32INPEN_Pos       (1UL)                     /*!< GPIO PADREGI: PAD32INPEN (Bit 1)                      */
#define GPIO_PADREGI_PAD32INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGI: PAD32INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD32PULL_Pos        (0UL)                     /*!< GPIO PADREGI: PAD32PULL (Bit 0)                       */
#define GPIO_PADREGI_PAD32PULL_Msk        (0x1UL)                   /*!< GPIO PADREGI: PAD32PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGJ  ======================================================== */
#define GPIO_PADREGJ_PAD39RSEL_Pos        (30UL)                    /*!< GPIO PADREGJ: PAD39RSEL (Bit 30)                      */
#define GPIO_PADREGJ_PAD39RSEL_Msk        (0xc0000000UL)            /*!< GPIO PADREGJ: PAD39RSEL (Bitfield-Mask: 0x03)         */
#define GPIO_PADREGJ_PAD39FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGJ: PAD39FNCSEL (Bit 27)                    */
#define GPIO_PADREGJ_PAD39FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGJ: PAD39FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGJ_PAD39STRNG_Pos       (26UL)                    /*!< GPIO PADREGJ: PAD39STRNG (Bit 26)                     */
#define GPIO_PADREGJ_PAD39STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGJ: PAD39STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD39INPEN_Pos       (25UL)                    /*!< GPIO PADREGJ: PAD39INPEN (Bit 25)                     */
#define GPIO_PADREGJ_PAD39INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGJ: PAD39INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD39PULL_Pos        (24UL)                    /*!< GPIO PADREGJ: PAD39PULL (Bit 24)                      */
#define GPIO_PADREGJ_PAD39PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGJ: PAD39PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGJ_PAD38FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGJ: PAD38FNCSEL (Bit 19)                    */
#define GPIO_PADREGJ_PAD38FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGJ: PAD38FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGJ_PAD38STRNG_Pos       (18UL)                    /*!< GPIO PADREGJ: PAD38STRNG (Bit 18)                     */
#define GPIO_PADREGJ_PAD38STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGJ: PAD38STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD38INPEN_Pos       (17UL)                    /*!< GPIO PADREGJ: PAD38INPEN (Bit 17)                     */
#define GPIO_PADREGJ_PAD38INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGJ: PAD38INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD38PULL_Pos        (16UL)                    /*!< GPIO PADREGJ: PAD38PULL (Bit 16)                      */
#define GPIO_PADREGJ_PAD38PULL_Msk        (0x10000UL)               /*!< GPIO PADREGJ: PAD38PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGJ_PAD37PWRDN_Pos       (15UL)                    /*!< GPIO PADREGJ: PAD37PWRDN (Bit 15)                     */
#define GPIO_PADREGJ_PAD37PWRDN_Msk       (0x8000UL)                /*!< GPIO PADREGJ: PAD37PWRDN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD37FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGJ: PAD37FNCSEL (Bit 11)                    */
#define GPIO_PADREGJ_PAD37FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGJ: PAD37FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGJ_PAD37STRNG_Pos       (10UL)                    /*!< GPIO PADREGJ: PAD37STRNG (Bit 10)                     */
#define GPIO_PADREGJ_PAD37STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGJ: PAD37STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD37INPEN_Pos       (9UL)                     /*!< GPIO PADREGJ: PAD37INPEN (Bit 9)                      */
#define GPIO_PADREGJ_PAD37INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGJ: PAD37INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD37PULL_Pos        (8UL)                     /*!< GPIO PADREGJ: PAD37PULL (Bit 8)                       */
#define GPIO_PADREGJ_PAD37PULL_Msk        (0x100UL)                 /*!< GPIO PADREGJ: PAD37PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGJ_PAD36FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGJ: PAD36FNCSEL (Bit 3)                     */
#define GPIO_PADREGJ_PAD36FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGJ: PAD36FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGJ_PAD36STRNG_Pos       (2UL)                     /*!< GPIO PADREGJ: PAD36STRNG (Bit 2)                      */
#define GPIO_PADREGJ_PAD36STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGJ: PAD36STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD36INPEN_Pos       (1UL)                     /*!< GPIO PADREGJ: PAD36INPEN (Bit 1)                      */
#define GPIO_PADREGJ_PAD36INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGJ: PAD36INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD36PULL_Pos        (0UL)                     /*!< GPIO PADREGJ: PAD36PULL (Bit 0)                       */
#define GPIO_PADREGJ_PAD36PULL_Msk        (0x1UL)                   /*!< GPIO PADREGJ: PAD36PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGK  ======================================================== */
#define GPIO_PADREGK_PAD43RSEL_Pos        (30UL)                    /*!< GPIO PADREGK: PAD43RSEL (Bit 30)                      */
#define GPIO_PADREGK_PAD43RSEL_Msk        (0xc0000000UL)            /*!< GPIO PADREGK: PAD43RSEL (Bitfield-Mask: 0x03)         */
#define GPIO_PADREGK_PAD43FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGK: PAD43FNCSEL (Bit 27)                    */
#define GPIO_PADREGK_PAD43FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGK: PAD43FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGK_PAD43STRNG_Pos       (26UL)                    /*!< GPIO PADREGK: PAD43STRNG (Bit 26)                     */
#define GPIO_PADREGK_PAD43STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGK: PAD43STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD43INPEN_Pos       (25UL)                    /*!< GPIO PADREGK: PAD43INPEN (Bit 25)                     */
#define GPIO_PADREGK_PAD43INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGK: PAD43INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD43PULL_Pos        (24UL)                    /*!< GPIO PADREGK: PAD43PULL (Bit 24)                      */
#define GPIO_PADREGK_PAD43PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGK: PAD43PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGK_PAD42RSEL_Pos        (22UL)                    /*!< GPIO PADREGK: PAD42RSEL (Bit 22)                      */
#define GPIO_PADREGK_PAD42RSEL_Msk        (0xc00000UL)              /*!< GPIO PADREGK: PAD42RSEL (Bitfield-Mask: 0x03)         */
#define GPIO_PADREGK_PAD42FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGK: PAD42FNCSEL (Bit 19)                    */
#define GPIO_PADREGK_PAD42FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGK: PAD42FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGK_PAD42STRNG_Pos       (18UL)                    /*!< GPIO PADREGK: PAD42STRNG (Bit 18)                     */
#define GPIO_PADREGK_PAD42STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGK: PAD42STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD42INPEN_Pos       (17UL)                    /*!< GPIO PADREGK: PAD42INPEN (Bit 17)                     */
#define GPIO_PADREGK_PAD42INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGK: PAD42INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD42PULL_Pos        (16UL)                    /*!< GPIO PADREGK: PAD42PULL (Bit 16)                      */
#define GPIO_PADREGK_PAD42PULL_Msk        (0x10000UL)               /*!< GPIO PADREGK: PAD42PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGK_PAD41PWRDN_Pos       (15UL)                    /*!< GPIO PADREGK: PAD41PWRDN (Bit 15)                     */
#define GPIO_PADREGK_PAD41PWRDN_Msk       (0x8000UL)                /*!< GPIO PADREGK: PAD41PWRDN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD41FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGK: PAD41FNCSEL (Bit 11)                    */
#define GPIO_PADREGK_PAD41FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGK: PAD41FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGK_PAD41STRNG_Pos       (10UL)                    /*!< GPIO PADREGK: PAD41STRNG (Bit 10)                     */
#define GPIO_PADREGK_PAD41STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGK: PAD41STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD41INPEN_Pos       (9UL)                     /*!< GPIO PADREGK: PAD41INPEN (Bit 9)                      */
#define GPIO_PADREGK_PAD41INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGK: PAD41INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD41PULL_Pos        (8UL)                     /*!< GPIO PADREGK: PAD41PULL (Bit 8)                       */
#define GPIO_PADREGK_PAD41PULL_Msk        (0x100UL)                 /*!< GPIO PADREGK: PAD41PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGK_PAD40RSEL_Pos        (6UL)                     /*!< GPIO PADREGK: PAD40RSEL (Bit 6)                       */
#define GPIO_PADREGK_PAD40RSEL_Msk        (0xc0UL)                  /*!< GPIO PADREGK: PAD40RSEL (Bitfield-Mask: 0x03)         */
#define GPIO_PADREGK_PAD40FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGK: PAD40FNCSEL (Bit 3)                     */
#define GPIO_PADREGK_PAD40FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGK: PAD40FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGK_PAD40STRNG_Pos       (2UL)                     /*!< GPIO PADREGK: PAD40STRNG (Bit 2)                      */
#define GPIO_PADREGK_PAD40STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGK: PAD40STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD40INPEN_Pos       (1UL)                     /*!< GPIO PADREGK: PAD40INPEN (Bit 1)                      */
#define GPIO_PADREGK_PAD40INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGK: PAD40INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD40PULL_Pos        (0UL)                     /*!< GPIO PADREGK: PAD40PULL (Bit 0)                       */
#define GPIO_PADREGK_PAD40PULL_Msk        (0x1UL)                   /*!< GPIO PADREGK: PAD40PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGL  ======================================================== */
#define GPIO_PADREGL_PAD47FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGL: PAD47FNCSEL (Bit 27)                    */
#define GPIO_PADREGL_PAD47FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGL: PAD47FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGL_PAD47STRNG_Pos       (26UL)                    /*!< GPIO PADREGL: PAD47STRNG (Bit 26)                     */
#define GPIO_PADREGL_PAD47STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGL: PAD47STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD47INPEN_Pos       (25UL)                    /*!< GPIO PADREGL: PAD47INPEN (Bit 25)                     */
#define GPIO_PADREGL_PAD47INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGL: PAD47INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD47PULL_Pos        (24UL)                    /*!< GPIO PADREGL: PAD47PULL (Bit 24)                      */
#define GPIO_PADREGL_PAD47PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGL: PAD47PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGL_PAD46FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGL: PAD46FNCSEL (Bit 19)                    */
#define GPIO_PADREGL_PAD46FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGL: PAD46FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGL_PAD46STRNG_Pos       (18UL)                    /*!< GPIO PADREGL: PAD46STRNG (Bit 18)                     */
#define GPIO_PADREGL_PAD46STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGL: PAD46STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD46INPEN_Pos       (17UL)                    /*!< GPIO PADREGL: PAD46INPEN (Bit 17)                     */
#define GPIO_PADREGL_PAD46INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGL: PAD46INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD46PULL_Pos        (16UL)                    /*!< GPIO PADREGL: PAD46PULL (Bit 16)                      */
#define GPIO_PADREGL_PAD46PULL_Msk        (0x10000UL)               /*!< GPIO PADREGL: PAD46PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGL_PAD45FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGL: PAD45FNCSEL (Bit 11)                    */
#define GPIO_PADREGL_PAD45FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGL: PAD45FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGL_PAD45STRNG_Pos       (10UL)                    /*!< GPIO PADREGL: PAD45STRNG (Bit 10)                     */
#define GPIO_PADREGL_PAD45STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGL: PAD45STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD45INPEN_Pos       (9UL)                     /*!< GPIO PADREGL: PAD45INPEN (Bit 9)                      */
#define GPIO_PADREGL_PAD45INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGL: PAD45INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD45PULL_Pos        (8UL)                     /*!< GPIO PADREGL: PAD45PULL (Bit 8)                       */
#define GPIO_PADREGL_PAD45PULL_Msk        (0x100UL)                 /*!< GPIO PADREGL: PAD45PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGL_PAD44FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGL: PAD44FNCSEL (Bit 3)                     */
#define GPIO_PADREGL_PAD44FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGL: PAD44FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGL_PAD44STRNG_Pos       (2UL)                     /*!< GPIO PADREGL: PAD44STRNG (Bit 2)                      */
#define GPIO_PADREGL_PAD44STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGL: PAD44STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD44INPEN_Pos       (1UL)                     /*!< GPIO PADREGL: PAD44INPEN (Bit 1)                      */
#define GPIO_PADREGL_PAD44INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGL: PAD44INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD44PULL_Pos        (0UL)                     /*!< GPIO PADREGL: PAD44PULL (Bit 0)                       */
#define GPIO_PADREGL_PAD44PULL_Msk        (0x1UL)                   /*!< GPIO PADREGL: PAD44PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGM  ======================================================== */
#define GPIO_PADREGM_PAD51FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGM: PAD51FNCSEL (Bit 27)                    */
#define GPIO_PADREGM_PAD51FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGM: PAD51FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGM_PAD51STRNG_Pos       (26UL)                    /*!< GPIO PADREGM: PAD51STRNG (Bit 26)                     */
#define GPIO_PADREGM_PAD51STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGM: PAD51STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGM_PAD51INPEN_Pos       (25UL)                    /*!< GPIO PADREGM: PAD51INPEN (Bit 25)                     */
#define GPIO_PADREGM_PAD51INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGM: PAD51INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGM_PAD51PULL_Pos        (24UL)                    /*!< GPIO PADREGM: PAD51PULL (Bit 24)                      */
#define GPIO_PADREGM_PAD51PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGM: PAD51PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGM_PAD50FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGM: PAD50FNCSEL (Bit 19)                    */
#define GPIO_PADREGM_PAD50FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGM: PAD50FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGM_PAD50STRNG_Pos       (18UL)                    /*!< GPIO PADREGM: PAD50STRNG (Bit 18)                     */
#define GPIO_PADREGM_PAD50STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGM: PAD50STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGM_PAD50INPEN_Pos       (17UL)                    /*!< GPIO PADREGM: PAD50INPEN (Bit 17)                     */
#define GPIO_PADREGM_PAD50INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGM: PAD50INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGM_PAD50PULL_Pos        (16UL)                    /*!< GPIO PADREGM: PAD50PULL 